/***************************************************************************
 *            wvdialconf.c
 *
 *  Mon May 24 23:51:01 2004
 *  Copyright  2004  Vladimir Đokić
 *  vladeck@gnome-ppp.org
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "gnome-ppp.h"


gboolean on_wvdialconf_out (GIOChannel *source, GIOCondition condition, gpointer data)
{
	gchar *line;
	GIOStatus status;
	
	status = g_io_channel_read_line (source, &line, NULL, NULL, NULL);
	
	if (status != G_IO_STATUS_NORMAL)
		return FALSE;
	
	g_print ("GNOME PPP: STDOUT: %s", line);
	
	if (g_strrstr (line, "Sorry, no modem was detected") != NULL) {
		gtk_widget_destroy (gnome_ppp.detect);
				
		gnome_ppp.detect = gtk_message_dialog_new (GTK_WINDOW (gnome_ppp.gnome_ppp.window),
						GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
						GTK_MESSAGE_WARNING,
						GTK_BUTTONS_OK,
						_("No modem was found on your system."));
		g_signal_connect_swapped (G_OBJECT (gnome_ppp.detect), "response",
					G_CALLBACK (gtk_widget_destroy), gnome_ppp.detect);
		gtk_widget_show (gnome_ppp.detect);
	}
	/* Analog modem */
	if (g_strrstr (line, "Found a modem on") != NULL) {
		gchar device[255];
		gchar tmp[255];
		int i = 0;
		
		sscanf (line, "%s %s %s %s %s", tmp, tmp, tmp, tmp, device);
		
		/* when we get device name, we get `extra` chars */
		for (i = 0; i < 255; i++) {
			
			if (device[i] == ',' || device[i] == '.' || device[i] == ';')
				device[i] = '\0';
		}
		gtk_entry_set_text (GTK_ENTRY( GTK_BIN(gnome_ppp.setup.device)->child), &device[0]);
		gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.type), 0);
		gtk_widget_destroy (gnome_ppp.detect);
	}
	/* USB modem */
	if (g_strrstr (line, "Found an USB modem on") != NULL) {
		gchar device[255];
		gchar tmp[255];
		int i = 0;
		
		sscanf (line, "%s %s %s %s %s %s", tmp, tmp, tmp, tmp, tmp, device);
		
		/* when we get device name, we get `extra` chars */
		for (i = 0; i < 255; i++) {
			
			if (device[i] == ',' || device[i] == '.' || device[i] == ';')
				device[i] = '\0';
		}
		gtk_entry_set_text (GTK_ENTRY( GTK_BIN(gnome_ppp.setup.device)->child), &device[0]);
		gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.type), 0);
		gtk_widget_destroy (gnome_ppp.detect);
	}
	/* ISDN TA */
	if (g_strrstr (line, "Found an ISDN TA on") != NULL) {
		gchar device[255];
		gchar tmp[255];
		int i = 0;
		
		sscanf (line, "%s %s %s %s %s %s", tmp, tmp, tmp, tmp, tmp, device);
		
		/* when we get device name, we get `extra` chars */
		for (i = 0; i < 255; i++) {
			
			if (device[i] == ',' || device[i] == '.' || device[i] == ';')
				device[i] = '\0';
		}
		gtk_entry_set_text (GTK_ENTRY( GTK_BIN(gnome_ppp.setup.device)->child), &device[0]);
		gtk_combo_box_set_active (GTK_COMBO_BOX (gnome_ppp.setup.type), 0);
		gtk_widget_destroy (gnome_ppp.detect);
	}
	g_free (line);
	
	return TRUE;
}

gboolean on_wvdialconf_err (GIOChannel *source, GIOCondition condition, gpointer data)
{
	gchar *line;
	GIOStatus status;
			
	status = g_io_channel_read_line (source, &line, NULL, NULL, NULL);
	
	if (status != G_IO_STATUS_NORMAL)
		return FALSE;
	
	g_print ("GNOME PPP: STDERR: %s", line);
	
	if (g_strrstr (line, ">: Max speed is") != NULL) {
		gchar speed[255];
		gchar tmp[255];
		int i = 0;
		
		sscanf (line, "%s %s %s %s %s", tmp, tmp, tmp, tmp, speed);
		
		/* when we get speed (baud), we get `extra` chars */
		for (i = 0; i < 255; i++) {
			
			if (speed[i] == ';' || speed[i] == ',' || speed[i] == '.')
				speed[i] = '\0';
		}
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN (gnome_ppp.setup.speed)->child), &speed[0]);
	}
	g_free (line);
	
	return TRUE;
}
