/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace@gnome.org>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */


#ifndef _FLEGITA_SINK_H_
#define _FLEGITA_SINK_H_

#include <glib-object.h>
#include <gnome-scan-sink.h>

G_BEGIN_DECLS

#define FLEGITA_TYPE_SINK             (flegita_sink_get_type ())
#define FLEGITA_SINK(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), FLEGITA_TYPE_SINK, FlegitaSink))
#define FLEGITA_SINK_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), FLEGITA_TYPE_SINK, FlegitaSinkClass))
#define FLEGITA_IS_SINK(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FLEGITA_TYPE_SINK))
#define FLEGITA_IS_SINK_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), FLEGITA_TYPE_SINK))
#define FLEGITA_SINK_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), FLEGITA_TYPE_SINK, FlegitaSinkClass))

typedef struct _FlegitaSinkClass FlegitaSinkClass;
typedef struct _FlegitaSink FlegitaSink;

struct _FlegitaSinkClass
{
	GnomeScanSinkClass parent_class;
};

struct _FlegitaSink
{
	GnomeScanSink parent_instance;
	
	gint	count;
	gchar	*filename;
	gchar	*suffix;
};

GType flegita_sink_get_type (void) G_GNUC_CONST;
void flegita_sink_register_type (GTypeModule *module);
GnomeScanSink* flegita_sink_new ();

G_END_DECLS

#endif /* _FLEGITA_SINK_H_ */
