#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#
# generated by wxGlade 0.7.0
#

import wx

# begin wxGlade: dependencies
import gettext
# end wxGlade

# begin wxGlade: extracode
from Gnumed.wxpython.gmDateTimeInput import cDateInputPhraseWheel
from Gnumed.wxpython.gmTextCtrl import cTextCtrl
from Gnumed.wxpython.gmSubstanceMgmtWidgets import cSubstancePhraseWheel
# end wxGlade


class wxgSubstanceAbuseEAPnl(wx.ScrolledWindow):
	def __init__(self, *args, **kwds):
		# begin wxGlade: wxgSubstanceAbuseEAPnl.__init__
		kwds["style"] = wx.BORDER_NONE | wx.TAB_TRAVERSAL
		wx.ScrolledWindow.__init__(self, *args, **kwds)
		self._RBTN_tobacco = wx.RadioButton(self, wx.ID_ANY, _("&Nicotine"))
		self._RBTN_c2 = wx.RadioButton(self, wx.ID_ANY, _("&Alcohol"))
		self._RBTN_other_substance = wx.RadioButton(self, wx.ID_ANY, _("&Other:"))
		self._PRW_substance = cSubstancePhraseWheel(self, wx.ID_ANY, "", style=wx.BORDER_NONE)
		self._RBTN_nonharmful_use = wx.RadioButton(self, wx.ID_ANY, _("&Non-harmful use"), style=wx.RB_GROUP)
		self._RBTN_harmful_use = wx.RadioButton(self, wx.ID_ANY, _("&Harmful use"))
		self._RBTN_presently_addicted = wx.RadioButton(self, wx.ID_ANY, _("Presently &addicted"))
		self._RBTN_previously_addicted = wx.RadioButton(self, wx.ID_ANY, _("Previously &addicted"))
		self._TCTRL_comment = cTextCtrl(self, wx.ID_ANY, "", style=wx.BORDER_NONE)
		self._DPRW_quit_when = cDateInputPhraseWheel(self, wx.ID_ANY, "", style=wx.BORDER_NONE)
		self._LBL_confirm_date = wx.StaticText(self, wx.ID_ANY, _("?"))
		self._CHBOX_confirm = wx.CheckBox(self, wx.ID_ANY, _("&Reconfirm as of today"))

		self.__set_properties()
		self.__do_layout()

		self.Bind(wx.EVT_RADIOBUTTON, self._on_substance_rbutton_selected, self._RBTN_tobacco)
		self.Bind(wx.EVT_RADIOBUTTON, self._on_substance_rbutton_selected, self._RBTN_c2)
		self.Bind(wx.EVT_RADIOBUTTON, self._on_substance_rbutton_selected, self._RBTN_other_substance)
		# end wxGlade

	def __set_properties(self):
		# begin wxGlade: wxgSubstanceAbuseEAPnl.__set_properties
		self.SetScrollRate(10, 10)
		self._RBTN_tobacco.SetToolTipString(_("Select for documenting smoking status."))
		self._RBTN_tobacco.SetValue(1)
		self._RBTN_c2.SetToolTipString(_("Select for documenting alcohol use status."))
		self._RBTN_other_substance.SetToolTipString(_("Select for documenting use of substances other than nicotine or alcohol."))
		self._PRW_substance.SetToolTipString(_("Select the abused substance."))
		self._PRW_substance.Enable(False)
		self._RBTN_nonharmful_use.SetToolTipString(_("Select if the substance use is not considered harmful (say, no use or non-harmful use)."))
		self._RBTN_nonharmful_use.SetValue(1)
		self._RBTN_harmful_use.SetToolTipString(_("Select if substance is use considered harmful."))
		self._RBTN_presently_addicted.SetToolTipString(_("Select if the patient is presently addicted to this substance."))
		self._RBTN_previously_addicted.SetToolTipString(_("Select if the patient was previously addicted to this substance."))
		self._TCTRL_comment.SetToolTipString(_("A comment on this substance use:\n- type of product used\n- frequency\n- amount\n- when started\n- attempts to quit\n..."))
		self._DPRW_quit_when.SetToolTipString(_("When did the patient quit?\n\nYou can also set a target quit date here."))
		self._CHBOX_confirm.SetToolTipString(_("Check here to confirm for today."))
		self._CHBOX_confirm.SetValue(1)
		# end wxGlade

	def __do_layout(self):
		# begin wxGlade: wxgSubstanceAbuseEAPnl.__do_layout
		_gszr_main = wx.FlexGridSizer(7, 2, 1, 3)
		__szr_confirm = wx.BoxSizer(wx.HORIZONTAL)
		__szr_addiction = wx.BoxSizer(wx.HORIZONTAL)
		__szr_status = wx.BoxSizer(wx.HORIZONTAL)
		__szr_substance = wx.BoxSizer(wx.HORIZONTAL)
		__lbl_substance = wx.StaticText(self, wx.ID_ANY, _("Substance"))
		__lbl_substance.SetForegroundColour(wx.Colour(255, 0, 0))
		_gszr_main.Add(__lbl_substance, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		__szr_substance.Add(self._RBTN_tobacco, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
		__szr_substance.Add(self._RBTN_c2, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
		__szr_substance.Add(self._RBTN_other_substance, 0, wx.ALIGN_CENTER_VERTICAL, 5)
		_gszr_main.Add(__szr_substance, 1, 0, 0)
		_gszr_main.Add((20, 20), 1, wx.EXPAND, 0)
		_gszr_main.Add(self._PRW_substance, 1, wx.EXPAND, 0)
		__lbl_status = wx.StaticText(self, wx.ID_ANY, _("Status"))
		__lbl_status.SetForegroundColour(wx.Colour(255, 0, 0))
		_gszr_main.Add(__lbl_status, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		__szr_status.Add(self._RBTN_nonharmful_use, 0, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 3)
		__szr_status.Add(self._RBTN_harmful_use, 0, wx.ALIGN_CENTER_VERTICAL, 3)
		_gszr_main.Add(__szr_status, 1, 0, 0)
		_gszr_main.Add((20, 20), 1, wx.EXPAND, 0)
		__szr_addiction.Add(self._RBTN_presently_addicted, 0, wx.ALIGN_CENTER_VERTICAL, 3)
		__szr_addiction.Add(self._RBTN_previously_addicted, 0, wx.ALIGN_CENTER_VERTICAL, 3)
		_gszr_main.Add(__szr_addiction, 1, 0, 0)
		__lbl_comment = wx.StaticText(self, wx.ID_ANY, _("Comment"))
		_gszr_main.Add(__lbl_comment, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		_gszr_main.Add(self._TCTRL_comment, 0, wx.EXPAND, 0)
		__lbl_quit_when = wx.StaticText(self, wx.ID_ANY, _("Quit date"))
		_gszr_main.Add(__lbl_quit_when, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		_gszr_main.Add(self._DPRW_quit_when, 0, wx.EXPAND, 0)
		__lbl_last_confirmed = wx.StaticText(self, wx.ID_ANY, _("Last confirmed"))
		_gszr_main.Add(__lbl_last_confirmed, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		__szr_confirm.Add(self._LBL_confirm_date, 1, wx.ALIGN_CENTER_VERTICAL | wx.RIGHT, 5)
		__szr_confirm.Add(self._CHBOX_confirm, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		_gszr_main.Add(__szr_confirm, 1, 0, 0)
		self.SetSizer(_gszr_main)
		_gszr_main.Fit(self)
		_gszr_main.AddGrowableCol(1)
		self.Layout()
		# end wxGlade

	def _on_substance_rbutton_selected(self, event):  # wxGlade: wxgSubstanceAbuseEAPnl.<event_handler>
		print "Event handler '_on_substance_rbutton_selected' not implemented!"
		event.Skip()

# end of class wxgSubstanceAbuseEAPnl
