// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Summary information about an access log subscription.
type AccessLogSubscriptionSummary struct {

	// The Amazon Resource Name (ARN) of the access log subscription
	//
	// This member is required.
	Arn *string

	// The date and time that the access log subscription was created, specified in
	// ISO-8601 format.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the destination.
	//
	// This member is required.
	DestinationArn *string

	// The ID of the access log subscription.
	//
	// This member is required.
	Id *string

	// The date and time that the access log subscription was last updated, specified
	// in ISO-8601 format.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The Amazon Resource Name (ARN) of the service or service network.
	//
	// This member is required.
	ResourceArn *string

	// The ID of the service or service network.
	//
	// This member is required.
	ResourceId *string

	noSmithyDocumentSerde
}

// Describes the DNS information of a service.
type DnsEntry struct {

	// The domain name of the service.
	DomainName *string

	// The ID of the hosted zone.
	HostedZoneId *string

	noSmithyDocumentSerde
}

// Information about an action that returns a custom HTTP response.
type FixedResponseAction struct {

	// The HTTP response code.
	//
	// This member is required.
	StatusCode *int32

	noSmithyDocumentSerde
}

// Describes a forward action. You can use forward actions to route requests to
// one or more target groups.
type ForwardAction struct {

	// The target groups. Traffic matching the rule is forwarded to the specified
	// target groups. With forward actions, you can assign a weight that controls the
	// prioritization and selection of each target group. This means that requests are
	// distributed to individual target groups based on their weights. For example, if
	// two target groups have the same weight, each target group receives half of the
	// traffic. The default value is 1. This means that if only one target group is
	// provided, there is no need to set the weight; 100% of traffic will go to that
	// target group.
	//
	// This member is required.
	TargetGroups []WeightedTargetGroup

	noSmithyDocumentSerde
}

// Describes the constraints for a header match. Matches incoming requests with
// rule based on request header value before applying rule action.
type HeaderMatch struct {

	// The header match type.
	//
	// This member is required.
	Match HeaderMatchType

	// The name of the header.
	//
	// This member is required.
	Name *string

	// Indicates whether the match is case sensitive. Defaults to false.
	CaseSensitive *bool

	noSmithyDocumentSerde
}

// Describes a header match type. Only one can be provided.
//
// The following types satisfy this interface:
//
//	HeaderMatchTypeMemberContains
//	HeaderMatchTypeMemberExact
//	HeaderMatchTypeMemberPrefix
type HeaderMatchType interface {
	isHeaderMatchType()
}

// Specifies a contains type match.
type HeaderMatchTypeMemberContains struct {
	Value string

	noSmithyDocumentSerde
}

func (*HeaderMatchTypeMemberContains) isHeaderMatchType() {}

// Specifies an exact type match.
type HeaderMatchTypeMemberExact struct {
	Value string

	noSmithyDocumentSerde
}

func (*HeaderMatchTypeMemberExact) isHeaderMatchType() {}

// Specifies a prefix type match. Matches the value with the prefix.
type HeaderMatchTypeMemberPrefix struct {
	Value string

	noSmithyDocumentSerde
}

func (*HeaderMatchTypeMemberPrefix) isHeaderMatchType() {}

// The health check configuration of a target group. Health check configurations
// aren't used for LAMBDA and ALB target groups.
type HealthCheckConfig struct {

	// Indicates whether health checking is enabled.
	Enabled *bool

	// The approximate amount of time, in seconds, between health checks of an
	// individual target. The range is 5–300 seconds. The default is 30 seconds.
	HealthCheckIntervalSeconds *int32

	// The amount of time, in seconds, to wait before reporting a target as unhealthy.
	// The range is 1–120 seconds. The default is 5 seconds.
	HealthCheckTimeoutSeconds *int32

	// The number of consecutive successful health checks required before considering
	// an unhealthy target healthy. The range is 2–10. The default is 5.
	HealthyThresholdCount *int32

	// The codes to use when checking for a successful response from a target. These
	// are called Success codes in the console.
	Matcher Matcher

	// The destination for health checks on the targets. If the protocol version is
	// HTTP/1.1 or HTTP/2 , specify a valid URI (for example, /path?query ). The
	// default path is / . Health checks are not supported if the protocol version is
	// gRPC , however, you can choose HTTP/1.1 or HTTP/2 and specify a valid URI.
	Path *string

	// The port used when performing health checks on targets. The default setting is
	// the port that a target receives traffic on.
	Port *int32

	// The protocol used when performing health checks on targets. The possible
	// protocols are HTTP and HTTPS . The default is HTTP .
	Protocol TargetGroupProtocol

	// The protocol version used when performing health checks on targets. The
	// possible protocol versions are HTTP1 and HTTP2 .
	ProtocolVersion HealthCheckProtocolVersion

	// The number of consecutive failed health checks required before considering a
	// target unhealthy. The range is 2–10. The default is 2.
	UnhealthyThresholdCount *int32

	noSmithyDocumentSerde
}

// Describes criteria that can be applied to incoming requests.
type HttpMatch struct {

	// The header matches. Matches incoming requests with rule based on request header
	// value before applying rule action.
	HeaderMatches []HeaderMatch

	// The HTTP method type.
	Method *string

	// The path match.
	PathMatch *PathMatch

	noSmithyDocumentSerde
}

// Summary information about a listener.
type ListenerSummary struct {

	// The Amazon Resource Name (ARN) of the listener.
	Arn *string

	// The date and time that the listener was created, specified in ISO-8601 format.
	CreatedAt *time.Time

	// The ID of the listener.
	Id *string

	// The date and time that the listener was last updated, specified in ISO-8601
	// format.
	LastUpdatedAt *time.Time

	// The name of the listener.
	Name *string

	// The listener port.
	Port *int32

	// The listener protocol.
	Protocol ListenerProtocol

	noSmithyDocumentSerde
}

// The codes to use when checking for a successful response from a target for
// health checks.
//
// The following types satisfy this interface:
//
//	MatcherMemberHttpCode
type Matcher interface {
	isMatcher()
}

// The HTTP code to use when checking for a successful response from a target.
type MatcherMemberHttpCode struct {
	Value string

	noSmithyDocumentSerde
}

func (*MatcherMemberHttpCode) isMatcher() {}

// Describes the conditions that can be applied when matching a path for incoming
// requests.
type PathMatch struct {

	// The type of path match.
	//
	// This member is required.
	Match PathMatchType

	// Indicates whether the match is case sensitive. Defaults to false.
	CaseSensitive *bool

	noSmithyDocumentSerde
}

// Describes a path match type. Each rule can include only one of the following
// types of paths.
//
// The following types satisfy this interface:
//
//	PathMatchTypeMemberExact
//	PathMatchTypeMemberPrefix
type PathMatchType interface {
	isPathMatchType()
}

// An exact match of the path.
type PathMatchTypeMemberExact struct {
	Value string

	noSmithyDocumentSerde
}

func (*PathMatchTypeMemberExact) isPathMatchType() {}

// A prefix match of the path.
type PathMatchTypeMemberPrefix struct {
	Value string

	noSmithyDocumentSerde
}

func (*PathMatchTypeMemberPrefix) isPathMatchType() {}

// Describes the action for a rule. Each rule must include exactly one of the
// following types of actions: forward or fixed-response , and it must be the last
// action to be performed.
//
// The following types satisfy this interface:
//
//	RuleActionMemberFixedResponse
//	RuleActionMemberForward
type RuleAction interface {
	isRuleAction()
}

// Describes the rule action that returns a custom HTTP response.
type RuleActionMemberFixedResponse struct {
	Value FixedResponseAction

	noSmithyDocumentSerde
}

func (*RuleActionMemberFixedResponse) isRuleAction() {}

// The forward action. Traffic that matches the rule is forwarded to the specified
// target groups.
type RuleActionMemberForward struct {
	Value ForwardAction

	noSmithyDocumentSerde
}

func (*RuleActionMemberForward) isRuleAction() {}

// Describes a rule match.
//
// The following types satisfy this interface:
//
//	RuleMatchMemberHttpMatch
type RuleMatch interface {
	isRuleMatch()
}

// The HTTP criteria that a rule must match.
type RuleMatchMemberHttpMatch struct {
	Value HttpMatch

	noSmithyDocumentSerde
}

func (*RuleMatchMemberHttpMatch) isRuleMatch() {}

// Summary information about the listener rule.
type RuleSummary struct {

	// The Amazon Resource Name (ARN) of the rule.
	Arn *string

	// The date and time that the listener rule was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time

	// The ID of the rule.
	Id *string

	// Indicates whether this is the default rule. Listener rules are created when you
	// create a listener. Each listener has a default rule for checking connection
	// requests.
	IsDefault *bool

	// The date and time that the listener rule was last updated, specified in
	// ISO-8601 format.
	LastUpdatedAt *time.Time

	// The name of the rule.
	Name *string

	// The priority of the rule.
	Priority *int32

	noSmithyDocumentSerde
}

// Represents an object when updating a rule.
type RuleUpdate struct {

	// The ID or Amazon Resource Name (ARN) of the rule.
	//
	// This member is required.
	RuleIdentifier *string

	// The rule action.
	Action RuleAction

	// The rule match.
	Match RuleMatch

	// The rule priority. A listener can't have multiple rules with the same priority.
	Priority *int32

	noSmithyDocumentSerde
}

// Describes a rule update that failed.
type RuleUpdateFailure struct {

	// The failure code.
	FailureCode *string

	// The failure message.
	FailureMessage *string

	// The ID or Amazon Resource Name (ARN) of the rule.
	RuleIdentifier *string

	noSmithyDocumentSerde
}

// Describes a successful rule update.
type RuleUpdateSuccess struct {

	// The action for the default rule.
	Action RuleAction

	// The Amazon Resource Name (ARN) of the listener.
	Arn *string

	// The ID of the listener.
	Id *string

	// Indicates whether this is the default rule.
	IsDefault *bool

	// The rule match.
	Match RuleMatch

	// The name of the listener.
	Name *string

	// The rule priority.
	Priority *int32

	noSmithyDocumentSerde
}

// Summary information about the association between a service network and a
// service.
type ServiceNetworkServiceAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the association.
	Arn *string

	// The date and time that the association was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time

	// The account that created the association.
	CreatedBy *string

	// The custom domain name of the service.
	CustomDomainName *string

	// DNS information about the service.
	DnsEntry *DnsEntry

	// The ID of the association.
	Id *string

	// The Amazon Resource Name (ARN) of the service.
	ServiceArn *string

	// The ID of the service.
	ServiceId *string

	// The name of the service.
	ServiceName *string

	// The Amazon Resource Name (ARN) of the service network.
	ServiceNetworkArn *string

	// The ID of the service network.
	ServiceNetworkId *string

	// The name of the service network.
	ServiceNetworkName *string

	// The status. If the deletion fails, try to delete again.
	Status ServiceNetworkServiceAssociationStatus

	noSmithyDocumentSerde
}

// Summary information about a service network.
type ServiceNetworkSummary struct {

	// The Amazon Resource Name (ARN) of the service network.
	Arn *string

	// The date and time that the service network was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time

	// The ID of the service network.
	Id *string

	// The date and time that the service network was last updated, specified in
	// ISO-8601 format.
	LastUpdatedAt *time.Time

	// The name of the service network.
	Name *string

	// The number of services associated with the service network.
	NumberOfAssociatedServices *int64

	// The number of VPCs associated with the service network.
	NumberOfAssociatedVPCs *int64

	noSmithyDocumentSerde
}

// Summary information about an association between a service network and a VPC.
type ServiceNetworkVpcAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the association.
	Arn *string

	// The date and time that the association was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time

	// The account that created the association.
	CreatedBy *string

	// The ID of the association.
	Id *string

	// The date and time that the association was last updated, specified in ISO-8601
	// format.
	LastUpdatedAt *time.Time

	// The Amazon Resource Name (ARN) of the service network.
	ServiceNetworkArn *string

	// The ID of the service network.
	ServiceNetworkId *string

	// The name of the service network.
	ServiceNetworkName *string

	// The status.
	Status ServiceNetworkVpcAssociationStatus

	// The ID of the VPC.
	VpcId *string

	noSmithyDocumentSerde
}

// Summary information about a service.
type ServiceSummary struct {

	// The Amazon Resource Name (ARN) of the service.
	Arn *string

	// The date and time that the service was created, specified in ISO-8601 format.
	CreatedAt *time.Time

	// The custom domain name of the service.
	CustomDomainName *string

	// DNS information about the service.
	DnsEntry *DnsEntry

	// The ID of the service.
	Id *string

	// The date and time that the service was last updated. The format is ISO-8601.
	LastUpdatedAt *time.Time

	// The name of the service.
	Name *string

	// The status.
	Status ServiceStatus

	noSmithyDocumentSerde
}

// Describes a target.
type Target struct {

	// The ID of the target. If the target type of the target group is INSTANCE , this
	// is an instance ID. If the target type is IP , this is an IP address. If the
	// target type is LAMBDA , this is the ARN of the Lambda function. If the target
	// type is ALB , this is the ARN of the Application Load Balancer.
	//
	// This member is required.
	Id *string

	// The port on which the target is listening. For HTTP, the default is 80 . For
	// HTTPS, the default is 443 .
	Port *int32

	noSmithyDocumentSerde
}

// Describes a target failure.
type TargetFailure struct {

	// The failure code.
	FailureCode *string

	// The failure message.
	FailureMessage *string

	// The ID of the target. If the target type of the target group is INSTANCE , this
	// is an instance ID. If the target type is IP , this is an IP address. If the
	// target type is LAMBDA , this is the ARN of the Lambda function. If the target
	// type is ALB , this is the ARN of the Application Load Balancer.
	Id *string

	// The port on which the target is listening. This parameter doesn't apply if the
	// target is a Lambda function.
	Port *int32

	noSmithyDocumentSerde
}

// Describes the configuration of a target group. Lambda functions don't support
// target group configuration.
type TargetGroupConfig struct {

	// The health check configuration.
	HealthCheck *HealthCheckConfig

	// The type of IP address used for the target group. The possible values are ipv4
	// and ipv6 . This is an optional parameter. If not specified, the IP address type
	// defaults to ipv4 .
	IpAddressType IpAddressType

	// Lambda event structure version
	LambdaEventStructureVersion LambdaEventStructureVersion

	// The port on which the targets are listening. For HTTP, the default is 80 . For
	// HTTPS, the default is 443
	Port *int32

	// The protocol to use for routing traffic to the targets. Default is the protocol
	// of a target group.
	Protocol TargetGroupProtocol

	// The protocol version. Default value is HTTP1 .
	ProtocolVersion TargetGroupProtocolVersion

	// The ID of the VPC.
	VpcIdentifier *string

	noSmithyDocumentSerde
}

// Summary information about a target group.
type TargetGroupSummary struct {

	// The ARN (Amazon Resource Name) of the target group.
	Arn *string

	// The date and time that the target group was created, specified in ISO-8601
	// format.
	CreatedAt *time.Time

	// The ID of the target group.
	Id *string

	// The type of IP address used for the target group. The possible values are ipv4
	// and ipv6 . This is an optional parameter. If not specified, the IP address type
	// defaults to ipv4 .
	IpAddressType IpAddressType

	// Lambda event structure version
	LambdaEventStructureVersion LambdaEventStructureVersion

	// The date and time that the target group was last updated, specified in ISO-8601
	// format.
	LastUpdatedAt *time.Time

	// The name of the target group.
	Name *string

	// The port of the target group.
	Port *int32

	// The protocol of the target group.
	Protocol TargetGroupProtocol

	// The list of Amazon Resource Names (ARNs) of the service.
	ServiceArns []string

	// The status.
	Status TargetGroupStatus

	// The target group type.
	Type TargetGroupType

	// The ID of the VPC of the target group.
	VpcIdentifier *string

	noSmithyDocumentSerde
}

// Summary information about a target.
type TargetSummary struct {

	// The ID of the target. If the target type of the target group is INSTANCE , this
	// is an instance ID. If the target type is IP , this is an IP address. If the
	// target type is LAMBDA , this is the ARN of the Lambda function. If the target
	// type is ALB , this is the ARN of the Application Load Balancer.
	Id *string

	// The port on which the target is listening.
	Port *int32

	// The code for why the target status is what it is.
	ReasonCode *string

	// The status of the target.
	//   - Draining : The target is being deregistered. No new connections will be sent
	//   to this target while current connections are being drained. Default draining
	//   time is 5 minutes.
	//   - Unavailable : Health checks are unavailable for the target group.
	//   - Healthy : The target is healthy.
	//   - Unhealthy : The target is unhealthy.
	//   - Initial : Initial health checks on the target are being performed.
	//   - Unused : Target group is not used in a service.
	Status TargetStatus

	noSmithyDocumentSerde
}

// Describes a validation failure.
type ValidationExceptionField struct {

	// Additional details about why the validation failed.
	//
	// This member is required.
	Message *string

	// The name of the validation exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Describes the weight of a target group.
type WeightedTargetGroup struct {

	// The ID or Amazon Resource Name (ARN) of the target group.
	//
	// This member is required.
	TargetGroupIdentifier *string

	// Only required if you specify multiple target groups for a forward action. The
	// "weight" determines how requests are distributed to the target group. For
	// example, if you specify two target groups, each with a weight of 10, each target
	// group receives half the requests. If you specify two target groups, one with a
	// weight of 10 and the other with a weight of 20, the target group with a weight
	// of 20 receives twice as many requests as the other target group. If there's only
	// one target group specified, then the default value is 100.
	Weight *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isHeaderMatchType() {}
func (*UnknownUnionMember) isMatcher()         {}
func (*UnknownUnionMember) isPathMatchType()   {}
func (*UnknownUnionMember) isRuleAction()      {}
func (*UnknownUnionMember) isRuleMatch()       {}
