// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The details of an alert manager definition.
type AlertManagerDefinitionDescription struct {

	// The date and time that the alert manager definition was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The actual alert manager definition. For details about the alert manager
	// definition, see AlertManagedDefinitionData (https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-AlertManagerDefinitionData.html)
	// .
	//
	// This member is required.
	Data []byte

	// The date and time that the alert manager definition was most recently changed.
	//
	// This member is required.
	ModifiedAt *time.Time

	// A structure that displays the current status of the alert manager definition..
	//
	// This member is required.
	Status *AlertManagerDefinitionStatus

	noSmithyDocumentSerde
}

// The status of the alert manager.
type AlertManagerDefinitionStatus struct {

	// The current status of the alert manager.
	//
	// This member is required.
	StatusCode AlertManagerDefinitionStatusCode

	// If there is a failure, the reason for the failure.
	StatusReason *string

	noSmithyDocumentSerde
}

// The AmpConfiguration structure defines the Amazon Managed Service for
// Prometheus instance a scraper should send metrics to.
type AmpConfiguration struct {

	// ARN of the Amazon Managed Service for Prometheus workspace.
	//
	// This member is required.
	WorkspaceArn *string

	noSmithyDocumentSerde
}

// Where to send the metrics from a scraper.
//
// The following types satisfy this interface:
//
//	DestinationMemberAmpConfiguration
type Destination interface {
	isDestination()
}

// The Amazon Managed Service for Prometheusworkspace to send metrics to.
type DestinationMemberAmpConfiguration struct {
	Value AmpConfiguration

	noSmithyDocumentSerde
}

func (*DestinationMemberAmpConfiguration) isDestination() {}

// The EksConfiguration structure describes the connection to the Amazon EKS
// cluster from which a scraper collects metrics.
type EksConfiguration struct {

	// ARN of the Amazon EKS cluster.
	//
	// This member is required.
	ClusterArn *string

	// A list of subnet IDs for the Amazon EKS cluster VPC configuration.
	//
	// This member is required.
	SubnetIds []string

	// A list of the security group IDs for the Amazon EKS cluster VPC configuration.
	SecurityGroupIds []string

	noSmithyDocumentSerde
}

// Contains information about the logging configuration.
type LoggingConfigurationMetadata struct {

	// The date and time that the logging configuration was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ARN of the CloudWatch log group to which the vended log data will be
	// published.
	//
	// This member is required.
	LogGroupArn *string

	// The date and time that the logging configuration was most recently changed.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The current status of the logging configuration.
	//
	// This member is required.
	Status *LoggingConfigurationStatus

	// The ID of the workspace the logging configuration is for.
	//
	// This member is required.
	Workspace *string

	noSmithyDocumentSerde
}

// The status of the logging configuration.
type LoggingConfigurationStatus struct {

	// The current status of the logging configuration.
	//
	// This member is required.
	StatusCode LoggingConfigurationStatusCode

	// If failed, the reason for the failure.
	StatusReason *string

	noSmithyDocumentSerde
}

// The details about one rule groups namespace.
type RuleGroupsNamespaceDescription struct {

	// The ARN of the rule groups namespace.
	//
	// This member is required.
	Arn *string

	// The date and time that the rule groups namespace was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The rule groups file used in the namespace. For details about the rule groups
	// namespace structure, see RuleGroupsNamespaceData (https://docs.aws.amazon.com/prometheus/latest/APIReference/yaml-RuleGroupsNamespaceData.html)
	// .
	//
	// This member is required.
	Data []byte

	// The date and time that the rule groups namespace was most recently changed.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The name of the rule groups namespace.
	//
	// This member is required.
	Name *string

	// The current status of the rule groups namespace.
	//
	// This member is required.
	Status *RuleGroupsNamespaceStatus

	// The list of tag keys and values that are associated with the rule groups
	// namespace.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The status information about a rule groups namespace.
type RuleGroupsNamespaceStatus struct {

	// The current status of the namespace.
	//
	// This member is required.
	StatusCode RuleGroupsNamespaceStatusCode

	// The reason for the failure, if any.
	StatusReason *string

	noSmithyDocumentSerde
}

// The high-level information about a rule groups namespace. To retrieve more
// information, use DescribeRuleGroupsNamespace .
type RuleGroupsNamespaceSummary struct {

	// The ARN of the rule groups namespace.
	//
	// This member is required.
	Arn *string

	// The date and time that the rule groups namespace was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The date and time that the rule groups namespace was most recently changed.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The name of the rule groups namespace.
	//
	// This member is required.
	Name *string

	// A structure that displays the current status of the rule groups namespace.
	//
	// This member is required.
	Status *RuleGroupsNamespaceStatus

	// The list of tag keys and values that are associated with the rule groups
	// namespace.
	Tags map[string]string

	noSmithyDocumentSerde
}

// A scrape configuration for a scraper, base 64 encoded. For more information,
// see Scraper configuration in the Amazon Managed Service for Prometheus User
// Guide.
//
// The following types satisfy this interface:
//
//	ScrapeConfigurationMemberConfigurationBlob
type ScrapeConfiguration interface {
	isScrapeConfiguration()
}

// The base 64 encoded scrape configuration file.
type ScrapeConfigurationMemberConfigurationBlob struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*ScrapeConfigurationMemberConfigurationBlob) isScrapeConfiguration() {}

// The ScraperDescription structure contains the full details about one scraper in
// your account.
type ScraperDescription struct {

	// The Amazon Resource Name (ARN) of the scraper.
	//
	// This member is required.
	Arn *string

	// The date and time that the scraper was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Managed Service for Prometheus workspace the scraper sends metrics
	// to.
	//
	// This member is required.
	Destination Destination

	// The date and time that the scraper was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions for
	// the scraper to discover and collect metrics on your behalf.
	//
	// This member is required.
	RoleArn *string

	// The configuration file in use by the scraper.
	//
	// This member is required.
	ScrapeConfiguration ScrapeConfiguration

	// The ID of the scraper.
	//
	// This member is required.
	ScraperId *string

	// The Amazon EKS cluster from which the scraper collects metrics.
	//
	// This member is required.
	Source Source

	// A structure that contains the current status of the scraper.
	//
	// This member is required.
	Status *ScraperStatus

	// (Optional) A name associated with the scraper.
	Alias *string

	// If there is a failure, the reason for the failure.
	StatusReason *string

	// (Optional) The list of tag keys and values associated with the scraper.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The ScraperStatus structure contains status information about the scraper.
type ScraperStatus struct {

	// The current status of the scraper.
	//
	// This member is required.
	StatusCode ScraperStatusCode

	noSmithyDocumentSerde
}

// The ScraperSummary structure contains a summary of the details about one
// scraper in your account.
type ScraperSummary struct {

	// The Amazon Resource Name (ARN) of the scraper.
	//
	// This member is required.
	Arn *string

	// The date and time that the scraper was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Managed Service for Prometheus workspace the scraper sends metrics
	// to.
	//
	// This member is required.
	Destination Destination

	// The date and time that the scraper was last modified.
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions for
	// the scraper to discover and collect metrics on your behalf.
	//
	// This member is required.
	RoleArn *string

	// The ID of the scraper.
	//
	// This member is required.
	ScraperId *string

	// The Amazon EKS cluster from which the scraper collects metrics.
	//
	// This member is required.
	Source Source

	// A structure that contains the current status of the scraper.
	//
	// This member is required.
	Status *ScraperStatus

	// (Optional) A name associated with the scraper.
	Alias *string

	// If there is a failure, the reason for the failure.
	StatusReason *string

	// (Optional) The list of tag keys and values associated with the scraper.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The source of collected metrics for a scraper.
//
// The following types satisfy this interface:
//
//	SourceMemberEksConfiguration
type Source interface {
	isSource()
}

// The Amazon EKS cluster from which a scraper collects metrics.
type SourceMemberEksConfiguration struct {
	Value EksConfiguration

	noSmithyDocumentSerde
}

func (*SourceMemberEksConfiguration) isSource() {}

// Information about a field passed into a request that resulted in an exception.
type ValidationExceptionField struct {

	// A message describing why the field caused an exception.
	//
	// This member is required.
	Message *string

	// The name of the field that caused an exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The full details about one Amazon Managed Service for Prometheus workspace in
// your account.
type WorkspaceDescription struct {

	// The ARN of the workspace.
	//
	// This member is required.
	Arn *string

	// The date and time that the workspace was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The current status of the workspace.
	//
	// This member is required.
	Status *WorkspaceStatus

	// The unique ID for the workspace.
	//
	// This member is required.
	WorkspaceId *string

	// The alias that is assigned to this workspace to help identify it. It may not be
	// unique.
	Alias *string

	// (optional) If the workspace was created with a customer managed KMS key, the
	// ARN for the key used.
	KmsKeyArn *string

	// The Prometheus endpoint available for this workspace.
	PrometheusEndpoint *string

	// The list of tag keys and values that are associated with the workspace.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The status of the workspace.
type WorkspaceStatus struct {

	// The current status of the workspace.
	//
	// This member is required.
	StatusCode WorkspaceStatusCode

	noSmithyDocumentSerde
}

// The information about one Amazon Managed Service for Prometheus workspace in
// your account.
type WorkspaceSummary struct {

	// The ARN of the workspace.
	//
	// This member is required.
	Arn *string

	// The date and time that the workspace was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The current status of the workspace.
	//
	// This member is required.
	Status *WorkspaceStatus

	// The unique ID for the workspace.
	//
	// This member is required.
	WorkspaceId *string

	// The alias that is assigned to this workspace to help identify it. It may not be
	// unique.
	Alias *string

	// (optional) If the workspace was created with a customer managed KMS key, the
	// ARN for the key used.
	KmsKeyArn *string

	// The list of tag keys and values that are associated with the workspace.
	Tags map[string]string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isDestination()         {}
func (*UnknownUnionMember) isScrapeConfiguration() {}
func (*UnknownUnionMember) isSource()              {}
