// Code generated by smithy-go-codegen DO NOT EDIT.

package comprehend

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/comprehend/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets a list of sentiment detection jobs that you have submitted.
func (c *Client) ListSentimentDetectionJobs(ctx context.Context, params *ListSentimentDetectionJobsInput, optFns ...func(*Options)) (*ListSentimentDetectionJobsOutput, error) {
	if params == nil {
		params = &ListSentimentDetectionJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSentimentDetectionJobs", params, optFns, c.addOperationListSentimentDetectionJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSentimentDetectionJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSentimentDetectionJobsInput struct {

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter at a
	// time.
	Filter *types.SentimentDetectionJobFilter

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int32

	// Identifies the next page of results to return.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSentimentDetectionJobsOutput struct {

	// Identifies the next page of results to return.
	NextToken *string

	// A list containing the properties of each job that is returned.
	SentimentDetectionJobPropertiesList []types.SentimentDetectionJobProperties

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSentimentDetectionJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListSentimentDetectionJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListSentimentDetectionJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSentimentDetectionJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSentimentDetectionJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSentimentDetectionJobsAPIClient is a client that implements the
// ListSentimentDetectionJobs operation.
type ListSentimentDetectionJobsAPIClient interface {
	ListSentimentDetectionJobs(context.Context, *ListSentimentDetectionJobsInput, ...func(*Options)) (*ListSentimentDetectionJobsOutput, error)
}

var _ ListSentimentDetectionJobsAPIClient = (*Client)(nil)

// ListSentimentDetectionJobsPaginatorOptions is the paginator options for
// ListSentimentDetectionJobs
type ListSentimentDetectionJobsPaginatorOptions struct {
	// The maximum number of results to return in each page. The default is 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSentimentDetectionJobsPaginator is a paginator for
// ListSentimentDetectionJobs
type ListSentimentDetectionJobsPaginator struct {
	options   ListSentimentDetectionJobsPaginatorOptions
	client    ListSentimentDetectionJobsAPIClient
	params    *ListSentimentDetectionJobsInput
	nextToken *string
	firstPage bool
}

// NewListSentimentDetectionJobsPaginator returns a new
// ListSentimentDetectionJobsPaginator
func NewListSentimentDetectionJobsPaginator(client ListSentimentDetectionJobsAPIClient, params *ListSentimentDetectionJobsInput, optFns ...func(*ListSentimentDetectionJobsPaginatorOptions)) *ListSentimentDetectionJobsPaginator {
	if params == nil {
		params = &ListSentimentDetectionJobsInput{}
	}

	options := ListSentimentDetectionJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSentimentDetectionJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSentimentDetectionJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSentimentDetectionJobs page.
func (p *ListSentimentDetectionJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSentimentDetectionJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListSentimentDetectionJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListSentimentDetectionJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSentimentDetectionJobs",
	}
}
