// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Represents a single entry in a list (or array) of DataSync agents when you call
// the ListAgents (https://docs.aws.amazon.com/datasync/latest/userguide/API_ListAgents.html)
// operation.
type AgentListEntry struct {

	// The Amazon Resource Name (ARN) of a DataSync agent.
	AgentArn *string

	// The name of an agent.
	Name *string

	// The platform-related details about the agent, such as the version number.
	Platform *Platform

	// The status of an agent.
	//   - If the status is ONLINE , the agent is configured properly and ready to use.
	//   - If the status is OFFLINE , the agent has been out of contact with DataSync
	//   for five minutes or longer. This can happen for a few reasons. For more
	//   information, see What do I do if my agent is offline? (https://docs.aws.amazon.com/datasync/latest/userguide/troubleshooting-datasync-agents.html#troubleshoot-agent-offline)
	Status AgentStatus

	noSmithyDocumentSerde
}

// The shared access signature (SAS) configuration that allows DataSync to access
// your Microsoft Azure Blob Storage. For more information, see SAS tokens (https://docs.aws.amazon.com/datasync/latest/userguide/creating-azure-blob-location.html#azure-blob-sas-tokens)
// for accessing your Azure Blob Storage.
type AzureBlobSasConfiguration struct {

	// Specifies a SAS token that provides permissions to access your Azure Blob
	// Storage. The token is part of the SAS URI string that comes after the storage
	// resource URI and a question mark. A token looks something like this:
	// sp=r&st=2023-12-20T14:54:52Z&se=2023-12-20T22:54:52Z&spr=https&sv=2021-06-08&sr=c&sig=aBBKDWQvyuVcTPH9EBp%2FXTI9E%2F%2Fmq171%2BZU178wcwqU%3D
	//
	// This member is required.
	Token *string

	noSmithyDocumentSerde
}

// The storage capacity of an on-premises storage system resource (for example, a
// volume).
type Capacity struct {

	// The amount of space in the cluster that's in cloud storage (for example, if
	// you're using data tiering).
	ClusterCloudStorageUsed *int64

	// The amount of space that's being used in a storage system resource without
	// accounting for compression or deduplication.
	LogicalUsed *int64

	// The total amount of space available in a storage system resource.
	Provisioned *int64

	// The amount of space that's being used in a storage system resource.
	Used *int64

	noSmithyDocumentSerde
}

// The credentials that provide DataSync Discovery read access to your on-premises
// storage system's management interface. DataSync Discovery stores these
// credentials in Secrets Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
// . For more information, see Accessing your on-premises storage system (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-configure-storage.html)
// .
type Credentials struct {

	// Specifies the password for your storage system's management interface.
	//
	// This member is required.
	Password *string

	// Specifies the user name for your storage system's management interface.
	//
	// This member is required.
	Username *string

	noSmithyDocumentSerde
}

// The details about a specific DataSync discovery job.
type DiscoveryJobListEntry struct {

	// The Amazon Resource Name (ARN) of a discovery job.
	DiscoveryJobArn *string

	// The status of a discovery job. For more information, see Discovery job statuses (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#discovery-job-statuses-table)
	// .
	Status DiscoveryJobStatus

	noSmithyDocumentSerde
}

// The network settings that DataSync Discovery uses to connect with your
// on-premises storage system's management interface.
type DiscoveryServerConfiguration struct {

	// The domain name or IP address of your storage system's management interface.
	//
	// This member is required.
	ServerHostname *string

	// The network port for accessing the storage system's management interface.
	ServerPort *int32

	noSmithyDocumentSerde
}

// The subnet and security groups that DataSync uses to access your Amazon EFS
// file system.
type Ec2Config struct {

	// Specifies the Amazon Resource Names (ARNs) of the security groups associated
	// with an Amazon EFS file system's mount target.
	//
	// This member is required.
	SecurityGroupArns []string

	// Specifies the ARN of a subnet where DataSync creates the network interfaces (https://docs.aws.amazon.com/datasync/latest/userguide/datasync-network.html#required-network-interfaces)
	// for managing traffic during your transfer. The subnet must be located:
	//   - In the same virtual private cloud (VPC) as the Amazon EFS file system.
	//   - In the same Availability Zone as at least one mount target for the Amazon
	//   EFS file system.
	// You don't need to specify a subnet that includes a file system mount target.
	//
	// This member is required.
	SubnetArn *string

	noSmithyDocumentSerde
}

// Specifies which files, folders, and objects to include or exclude when
// transferring files from source to destination.
type FilterRule struct {

	// The type of filter rule to apply. DataSync only supports the SIMPLE_PATTERN
	// rule type.
	FilterType FilterType

	// A single filter string that consists of the patterns to include or exclude. The
	// patterns are delimited by "|" (that is, a pipe), for example: /folder1|/folder2
	Value *string

	noSmithyDocumentSerde
}

// Specifies the data transfer protocol that DataSync uses to access your Amazon
// FSx file system.
type FsxProtocol struct {

	// Specifies the Network File System (NFS) protocol configuration that DataSync
	// uses to access your FSx for OpenZFS file system or FSx for ONTAP file system's
	// storage virtual machine (SVM).
	NFS *FsxProtocolNfs

	// Specifies the Server Message Block (SMB) protocol configuration that DataSync
	// uses to access your FSx for ONTAP file system's SVM.
	SMB *FsxProtocolSmb

	noSmithyDocumentSerde
}

// Specifies the Network File System (NFS) protocol configuration that DataSync
// uses to access your Amazon FSx for OpenZFS or Amazon FSx for NetApp ONTAP file
// system.
type FsxProtocolNfs struct {

	// Specifies how DataSync can access a location using the NFS protocol.
	MountOptions *NfsMountOptions

	noSmithyDocumentSerde
}

// Specifies the Server Message Block (SMB) protocol configuration that DataSync
// uses to access your Amazon FSx for NetApp ONTAP file system. For more
// information, see Accessing FSx for ONTAP file systems (https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-access)
// .
type FsxProtocolSmb struct {

	// Specifies the password of a user who has permission to access your SVM.
	//
	// This member is required.
	Password *string

	// Specifies a user that can mount and access the files, folders, and metadata in
	// your SVM. For information about choosing a user with the right level of access
	// for your transfer, see Using the SMB protocol (https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-smb)
	// .
	//
	// This member is required.
	User *string

	// Specifies the fully qualified domain name (FQDN) of the Microsoft Active
	// Directory that your storage virtual machine (SVM) belongs to. If you have
	// multiple domains in your environment, configuring this setting makes sure that
	// DataSync connects to the right SVM.
	Domain *string

	// Specifies the version of the Server Message Block (SMB) protocol that DataSync
	// uses to access an SMB file server.
	MountOptions *SmbMountOptions

	noSmithyDocumentSerde
}

// The NameNode of the Hadoop Distributed File System (HDFS). The NameNode manages
// the file system's namespace. The NameNode performs operations such as opening,
// closing, and renaming files and directories. The NameNode contains the
// information to map blocks of data to the DataNodes.
type HdfsNameNode struct {

	// The hostname of the NameNode in the HDFS cluster. This value is the IP address
	// or Domain Name Service (DNS) name of the NameNode. An agent that's installed
	// on-premises uses this hostname to communicate with the NameNode in the network.
	//
	// This member is required.
	Hostname *string

	// The port that the NameNode uses to listen to client requests.
	//
	// This member is required.
	Port *int32

	noSmithyDocumentSerde
}

// The IOPS peaks for an on-premises storage system resource. Each data point
// represents the 95th percentile peak value during a 1-hour interval.
type IOPS struct {

	// Peak IOPS unrelated to read and write operations.
	Other *float64

	// Peak IOPS related to read operations.
	Read *float64

	// Peak total IOPS on your on-premises storage system resource.
	Total *float64

	// Peak IOPS related to write operations.
	Write *float64

	noSmithyDocumentSerde
}

// The latency peaks for an on-premises storage system resource. Each data point
// represents the 95th percentile peak value during a 1-hour interval.
type Latency struct {

	// Peak latency for operations unrelated to read and write operations.
	Other *float64

	// Peak latency for read operations.
	Read *float64

	// Peak latency for write operations.
	Write *float64

	noSmithyDocumentSerde
}

// Narrow down the list of resources returned by ListLocations . For example, to
// see all your Amazon S3 locations, create a filter using "Name": "LocationType" ,
// "Operator": "Equals" , and "Values": "S3" . For more information, see filtering
// resources (https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html)
// .
type LocationFilter struct {

	// The name of the filter being used. Each API call supports a list of filters
	// that are available for it (for example, LocationType for ListLocations ).
	//
	// This member is required.
	Name LocationFilterName

	// The operator that is used to compare filter values (for example, Equals or
	// Contains ).
	//
	// This member is required.
	Operator Operator

	// The values that you want to filter for. For example, you might want to display
	// only Amazon S3 locations.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Represents a single entry in a list of locations. LocationListEntry returns an
// array that contains a list of locations when the ListLocations (https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html)
// operation is called.
type LocationListEntry struct {

	// The Amazon Resource Name (ARN) of the location. For Network File System (NFS)
	// or Amazon EFS, the location is the export path. For Amazon S3, the location is
	// the prefix path that you want to mount and use as the root of the location.
	LocationArn *string

	// Represents a list of URIs of a location. LocationUri returns an array that
	// contains a list of locations when the ListLocations (https://docs.aws.amazon.com/datasync/latest/userguide/API_ListLocations.html)
	// operation is called. Format: TYPE://GLOBAL_ID/SUBDIR . TYPE designates the type
	// of location (for example, nfs or s3 ). GLOBAL_ID is the globally unique
	// identifier of the resource that backs the location. An example for EFS is
	// us-east-2.fs-abcd1234 . An example for Amazon S3 is the bucket name, such as
	// myBucket . An example for NFS is a valid IPv4 address or a hostname that is
	// compliant with Domain Name Service (DNS). SUBDIR is a valid file system path,
	// delimited by forward slashes as is the *nix convention. For NFS and Amazon EFS,
	// it's the export path to mount the location. For Amazon S3, it's the prefix path
	// that you mount to and treat as the root of the location.
	LocationUri *string

	noSmithyDocumentSerde
}

// Configures a manifest, which is a list of files or objects that you want
// DataSync to transfer. For more information and configuration examples, see
// Specifying what DataSync transfers by using a manifest (https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html)
// .
type ManifestConfig struct {

	// Specifies what DataSync uses the manifest for.
	Action ManifestAction

	// Specifies the file format of your manifest. For more information, see Creating
	// a manifest (https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-create)
	// .
	Format ManifestFormat

	// Specifies the manifest that you want DataSync to use and where it's hosted. You
	// must specify this parameter if you're configuring a new manifest on or after
	// February 7, 2024. If you don't, you'll get a 400 status code and
	// ValidationException error stating that you're missing the IAM role for DataSync
	// to access the S3 bucket where you're hosting your manifest. For more
	// information, see Providing DataSync access to your manifest (https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access)
	// .
	Source *SourceManifestConfig

	noSmithyDocumentSerde
}

// The performance data that DataSync Discovery collects about an on-premises
// storage system resource.
type MaxP95Performance struct {

	// Peak IOPS unrelated to read and write operations.
	IopsOther *float64

	// Peak IOPS related to read operations.
	IopsRead *float64

	// Peak total IOPS on your on-premises storage system resource.
	IopsTotal *float64

	// Peak IOPS related to write operations.
	IopsWrite *float64

	// Peak latency for operations unrelated to read and write operations.
	LatencyOther *float64

	// Peak latency for read operations.
	LatencyRead *float64

	// Peak latency for write operations.
	LatencyWrite *float64

	// Peak throughput unrelated to read and write operations.
	ThroughputOther *float64

	// Peak throughput related to read operations.
	ThroughputRead *float64

	// Peak total throughput on your on-premises storage system resource.
	ThroughputTotal *float64

	// Peak throughput related to write operations.
	ThroughputWrite *float64

	noSmithyDocumentSerde
}

// The information that DataSync Discovery collects about an on-premises storage
// system cluster.
type NetAppONTAPCluster struct {

	// The number of CIFS shares in the cluster.
	CifsShareCount *int64

	// The storage space that's being used in the cluster without accounting for
	// compression or deduplication.
	ClusterBlockStorageLogicalUsed *int64

	// The total storage space that's available in the cluster.
	ClusterBlockStorageSize *int64

	// The storage space that's being used in a cluster.
	ClusterBlockStorageUsed *int64

	// The amount of space in the cluster that's in cloud storage (for example, if
	// you're using data tiering).
	ClusterCloudStorageUsed *int64

	// The name of the cluster.
	ClusterName *string

	// The number of LUNs (logical unit numbers) in the cluster.
	LunCount *int64

	// The performance data that DataSync Discovery collects about the cluster.
	MaxP95Performance *MaxP95Performance

	// The number of NFS volumes in the cluster.
	NfsExportedVolumes *int64

	// Indicates whether DataSync Discovery recommendations for the cluster are ready
	// to view, incomplete, or can't be determined. For more information, see
	// Recommendation statuses (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#recommendation-statuses-table)
	// .
	RecommendationStatus RecommendationStatus

	// The Amazon Web Services storage services that DataSync Discovery recommends for
	// the cluster. For more information, see Recommendations provided by DataSync
	// Discovery (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html)
	// .
	Recommendations []Recommendation

	// The universally unique identifier (UUID) of the cluster.
	ResourceId *string

	noSmithyDocumentSerde
}

// The information that DataSync Discovery collects about a storage virtual
// machine (SVM) in your on-premises storage system.
type NetAppONTAPSVM struct {

	// The number of CIFS shares in the SVM.
	CifsShareCount *int64

	// The universally unique identifier (UUID) of the cluster associated with the SVM.
	ClusterUuid *string

	// The data transfer protocols (such as NFS) configured for the SVM.
	EnabledProtocols []string

	// The number of LUNs (logical unit numbers) in the SVM.
	LunCount *int64

	// The performance data that DataSync Discovery collects about the SVM.
	MaxP95Performance *MaxP95Performance

	// The number of NFS volumes in the SVM.
	NfsExportedVolumes *int64

	// Indicates whether DataSync Discovery recommendations for the SVM are ready to
	// view, incomplete, or can't be determined. For more information, see
	// Recommendation statuses (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#recommendation-statuses-table)
	// .
	RecommendationStatus RecommendationStatus

	// The Amazon Web Services storage services that DataSync Discovery recommends for
	// the SVM. For more information, see Recommendations provided by DataSync
	// Discovery (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html)
	// .
	Recommendations []Recommendation

	// The UUID of the SVM.
	ResourceId *string

	// The name of the SVM
	SvmName *string

	// The total storage space that's available in the SVM.
	TotalCapacityProvisioned *int64

	// The storage space that's being used in the SVM.
	TotalCapacityUsed *int64

	// The storage space that's being used in the SVM without accounting for
	// compression or deduplication.
	TotalLogicalCapacityUsed *int64

	// The amount of storage in the SVM that's being used for snapshots.
	TotalSnapshotCapacityUsed *int64

	noSmithyDocumentSerde
}

// The information that DataSync Discovery collects about a volume in your
// on-premises storage system.
type NetAppONTAPVolume struct {

	// The total storage space that's available in the volume.
	CapacityProvisioned *int64

	// The storage space that's being used in the volume.
	CapacityUsed *int64

	// The number of CIFS shares in the volume.
	CifsShareCount *int64

	// The storage space that's being used in the volume without accounting for
	// compression or deduplication.
	LogicalCapacityUsed *int64

	// The number of LUNs (logical unit numbers) in the volume.
	LunCount *int64

	// The performance data that DataSync Discovery collects about the volume.
	MaxP95Performance *MaxP95Performance

	// The number of NFS volumes in the volume.
	NfsExported bool

	// Indicates whether DataSync Discovery recommendations for the volume are ready
	// to view, incomplete, or can't be determined. For more information, see
	// Recommendation statuses (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-job-statuses.html#recommendation-statuses-table)
	// .
	RecommendationStatus RecommendationStatus

	// The Amazon Web Services storage services that DataSync Discovery recommends for
	// the volume. For more information, see Recommendations provided by DataSync
	// Discovery (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html)
	// .
	Recommendations []Recommendation

	// The universally unique identifier (UUID) of the volume.
	ResourceId *string

	// The volume's security style (such as Unix or NTFS).
	SecurityStyle *string

	// The amount of storage in the volume that's being used for snapshots.
	SnapshotCapacityUsed *int64

	// The name of the SVM associated with the volume.
	SvmName *string

	// The UUID of the storage virtual machine (SVM) associated with the volume.
	SvmUuid *string

	// The name of the volume.
	VolumeName *string

	noSmithyDocumentSerde
}

// Specifies how DataSync can access a location using the NFS protocol.
type NfsMountOptions struct {

	// Specifies the NFS version that you want DataSync to use when mounting your NFS
	// share. If the server refuses to use the version specified, the task fails. You
	// can specify the following options:
	//   - AUTOMATIC (default): DataSync chooses NFS version 4.1.
	//   - NFS3 : Stateless protocol version that allows for asynchronous writes on the
	//   server.
	//   - NFSv4_0 : Stateful, firewall-friendly protocol version that supports
	//   delegations and pseudo file systems.
	//   - NFSv4_1 : Stateful protocol version that supports sessions, directory
	//   delegations, and parallel data processing. NFS version 4.1 also includes all
	//   features available in version 4.0.
	// DataSync currently only supports NFS version 3 with Amazon FSx for NetApp ONTAP
	// locations.
	Version NfsVersion

	noSmithyDocumentSerde
}

// The DataSync agents that are connecting to a Network File System (NFS) location.
type OnPremConfig struct {

	// The Amazon Resource Names (ARNs) of the agents connecting to a transfer
	// location.
	//
	// This member is required.
	AgentArns []string

	noSmithyDocumentSerde
}

// Indicates how your transfer task is configured. These options include how
// DataSync handles files, objects, and their associated metadata during your
// transfer. You also can specify how to verify data integrity, set bandwidth
// limits for your task, among other options. Each option has a default value.
// Unless you need to, you don't have to configure any of these options before
// starting your task.
type Options struct {

	// Specifies whether to preserve metadata indicating the last time a file was read
	// or written to. The behavior of Atime isn't fully standard across platforms, so
	// DataSync can only do this on a best-effort basis.
	//   - BEST_EFFORT (default) - DataSync attempts to preserve the original Atime
	//   attribute on all source files (that is, the version before the PREPARING phase
	//   of the task execution). This option is recommended.
	//   - NONE - Ignores Atime .
	// If Atime is set to BEST_EFFORT , Mtime must be set to PRESERVE . If Atime is
	// set to NONE , Mtime must also be NONE .
	Atime Atime

	// Limits the bandwidth used by a DataSync task. For example, if you want DataSync
	// to use a maximum of 1 MB, set this value to 1048576 ( =1024*1024 ).
	BytesPerSecond *int64

	// Specifies the POSIX group ID (GID) of the file's owners.
	//   - INT_VALUE (default) - Preserves the integer value of user ID (UID) and GID,
	//   which is recommended.
	//   - NONE - Ignores UID and GID.
	// For more information, see Metadata copied by DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied)
	// .
	Gid Gid

	// Specifies the type of logs that DataSync publishes to a Amazon CloudWatch Logs
	// log group. To specify the log group, see CloudWatchLogGroupArn (https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateTask.html#DataSync-CreateTask-request-CloudWatchLogGroupArn)
	// .
	//   - BASIC - Publishes logs with only basic information (such as transfer
	//   errors).
	//   - TRANSFER - Publishes logs for all files or objects that your DataSync task
	//   transfers and performs data-integrity checks on.
	//   - OFF - No logs are published.
	LogLevel LogLevel

	// Specifies whether to preserve metadata indicating the last time that a file was
	// written to before the PREPARING phase of your task execution. This option is
	// required when you need to run the a task more than once.
	//   - PRESERVE (default) - Preserves original Mtime , which is recommended.
	//   - NONE - Ignores Mtime .
	// If Mtime is set to PRESERVE , Atime must be set to BEST_EFFORT . If Mtime is
	// set to NONE , Atime must also be set to NONE .
	Mtime Mtime

	// Specifies whether you want DataSync to PRESERVE object tags (default behavior)
	// when transferring between object storage systems. If you want your DataSync task
	// to ignore object tags, specify the NONE value.
	ObjectTags ObjectTags

	// Specifies whether DataSync should modify or preserve data at the destination
	// location.
	//   - ALWAYS (default) - DataSync modifies data in the destination location when
	//   source data (including metadata) has changed. If DataSync overwrites objects,
	//   you might incur additional charges for certain Amazon S3 storage classes (for
	//   example, for retrieval or early deletion). For more information, see Storage
	//   class considerations with Amazon S3 transfers (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
	//   .
	//   - NEVER - DataSync doesn't overwrite data in the destination location even if
	//   the source data has changed. You can use this option to protect against
	//   overwriting changes made to files or objects in the destination.
	OverwriteMode OverwriteMode

	// Specifies which users or groups can access a file for a specific purpose such
	// as reading, writing, or execution of the file. For more information, see
	// Metadata copied by DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied)
	// .
	//   - PRESERVE (default) - Preserves POSIX-style permissions, which is
	//   recommended.
	//   - NONE - Ignores POSIX-style permissions.
	// DataSync can preserve extant permissions of a source location.
	PosixPermissions PosixPermissions

	// Specifies whether files in the destination location that don't exist in the
	// source should be preserved. This option can affect your Amazon S3 storage cost.
	// If your task deletes objects, you might incur minimum storage duration charges
	// for certain storage classes. For detailed information, see Considerations when
	// working with Amazon S3 storage classes in DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
	// .
	//   - PRESERVE (default) - Ignores such destination files, which is recommended.
	//   - REMOVE - Deletes destination files that aren’t present in the source.
	// If you set this parameter to REMOVE , you can't set TransferMode to ALL . When
	// you transfer all data, DataSync doesn't scan your destination location and
	// doesn't know what to delete.
	PreserveDeletedFiles PreserveDeletedFiles

	// Specifies whether DataSync should preserve the metadata of block and character
	// devices in the source location and recreate the files with that device name and
	// metadata on the destination. DataSync copies only the name and metadata of such
	// devices. DataSync can't copy the actual contents of these devices because
	// they're nonterminal and don't return an end-of-file (EOF) marker.
	//   - NONE (default) - Ignores special devices (recommended).
	//   - PRESERVE - Preserves character and block device metadata. This option
	//   currently isn't supported for Amazon EFS.
	PreserveDevices PreserveDevices

	// Specifies which components of the SMB security descriptor are copied from
	// source to destination objects. This value is only used for transfers between SMB
	// and Amazon FSx for Windows File Server locations or between two FSx for Windows
	// File Server locations. For more information, see how DataSync handles metadata (https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html)
	// .
	//   - OWNER_DACL (default) - For each copied object, DataSync copies the following
	//   metadata:
	//   - The object owner.
	//   - NTFS discretionary access control lists (DACLs), which determine whether to
	//   grant access to an object. DataSync won't copy NTFS system access control lists
	//   (SACLs) with this option.
	//   - OWNER_DACL_SACL - For each copied object, DataSync copies the following
	//   metadata:
	//   - The object owner.
	//   - NTFS discretionary access control lists (DACLs), which determine whether to
	//   grant access to an object.
	//   - SACLs, which are used by administrators to log attempts to access a secured
	//   object. Copying SACLs requires granting additional permissions to the Windows
	//   user that DataSync uses to access your SMB location. For information about
	//   choosing a user with the right permissions, see required permissions for SMB (https://docs.aws.amazon.com/datasync/latest/userguide/create-smb-location.html#configuring-smb-permissions)
	//   , FSx for Windows File Server (https://docs.aws.amazon.com/datasync/latest/userguide/create-fsx-location.html#create-fsx-windows-location-permissions)
	//   , or FSx for ONTAP (https://docs.aws.amazon.com/datasync/latest/userguide/create-ontap-location.html#create-ontap-location-smb)
	//   (depending on the type of location in your transfer).
	//   - NONE - None of the SMB security descriptor components are copied.
	//   Destination objects are owned by the user that was provided for accessing the
	//   destination location. DACLs and SACLs are set based on the destination server’s
	//   configuration.
	SecurityDescriptorCopyFlags SmbSecurityDescriptorCopyFlags

	// Specifies whether your transfer tasks should be put into a queue during certain
	// scenarios when running multiple tasks (https://docs.aws.amazon.com/datasync/latest/userguide/run-task.html#running-multiple-tasks)
	// . This is ENABLED by default.
	TaskQueueing TaskQueueing

	// Determines whether DataSync transfers only the data and metadata that differ
	// between the source and the destination location or transfers all the content
	// from the source (without comparing what's in the destination).
	//   - CHANGED (default) - DataSync copies only data or metadata that is new or
	//   different content from the source location to the destination location.
	//   - ALL - DataSync copies everything in the source to the destination without
	//   comparing differences between the locations.
	TransferMode TransferMode

	// Specifies the POSIX user ID (UID) of the file's owner.
	//   - INT_VALUE (default) - Preserves the integer value of UID and group ID (GID),
	//   which is recommended.
	//   - NONE - Ignores UID and GID.
	// For more information, see Metadata copied by DataSync (https://docs.aws.amazon.com/datasync/latest/userguide/special-files.html#metadata-copied)
	// .
	Uid Uid

	// Specifies how and when DataSync checks the integrity of your data during a
	// transfer.
	//   - ONLY_FILES_TRANSFERRED (recommended) - DataSync calculates the checksum of
	//   transferred files and metadata at the source location. At the end of the
	//   transfer, DataSync then compares this checksum to the checksum calculated on
	//   those files at the destination. We recommend this option when transferring to S3
	//   Glacier Flexible Retrieval or S3 Glacier Deep Archive storage classes. For more
	//   information, see Storage class considerations with Amazon S3 locations (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
	//   .
	//   - POINT_IN_TIME_CONSISTENT (default) - At the end of the transfer, DataSync
	//   scans the entire source and destination to verify that both locations are fully
	//   synchronized. You can't use this option when transferring to S3 Glacier Flexible
	//   Retrieval or S3 Glacier Deep Archive storage classes. For more information, see
	//   Storage class considerations with Amazon S3 locations (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#using-storage-classes)
	//   .
	//   - NONE - DataSync doesn't run additional verification at the end of the
	//   transfer. All data transmissions are still integrity-checked with checksum
	//   verification during the transfer.
	VerifyMode VerifyMode

	noSmithyDocumentSerde
}

// The types of performance data that DataSync Discovery collects about an
// on-premises storage system resource.
type P95Metrics struct {

	// The IOPS peaks for an on-premises storage system resource. Each data point
	// represents the 95th percentile peak value during a 1-hour interval.
	IOPS *IOPS

	// The latency peaks for an on-premises storage system resource. Each data point
	// represents the 95th percentile peak value during a 1-hour interval.
	Latency *Latency

	// The throughput peaks for an on-premises storage system resource. Each data
	// point represents the 95th percentile peak value during a 1-hour interval.
	Throughput *Throughput

	noSmithyDocumentSerde
}

// The platform-related details about the DataSync agent, such as the version
// number.
type Platform struct {

	// The version of the DataSync agent. On December 7, 2023, we discontinued version
	// 1 DataSync agents. Check the DataSync console to see if you have affected
	// agents. If you do, replace (https://docs.aws.amazon.com/datasync/latest/userguide/replacing-agent.html)
	// those agents or delete (https://docs.aws.amazon.com/datasync/latest/userguide/deleting-agent.html)
	// them if they aren't in use. If you need more help, contact Amazon Web Services
	// Support (https://aws.amazon.com/contact-us/) .
	Version *string

	noSmithyDocumentSerde
}

// Specifies how your DataSync agent connects to Amazon Web Services using a
// virtual private cloud (VPC) service endpoint (https://docs.aws.amazon.com/datasync/latest/userguide/choose-service-endpoint.html#choose-service-endpoint-vpc)
// . An agent that uses a VPC endpoint isn't accessible over the public internet.
type PrivateLinkConfig struct {

	// Specifies the VPC endpoint provided by Amazon Web Services PrivateLink (https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html)
	// that your agent connects to.
	PrivateLinkEndpoint *string

	// Specifies the Amazon Resource Names (ARN) of the security group that provides
	// DataSync access to your VPC endpoint. You can only specify one ARN.
	SecurityGroupArns []string

	// Specifies the ARN of the subnet where your VPC endpoint is located. You can
	// only specify one ARN.
	SubnetArns []string

	// Specifies the ID of the VPC endpoint that your agent connects to.
	VpcEndpointId *string

	noSmithyDocumentSerde
}

// The Quality of Protection (QOP) configuration specifies the Remote Procedure
// Call (RPC) and data transfer privacy settings configured on the Hadoop
// Distributed File System (HDFS) cluster.
type QopConfiguration struct {

	// The data transfer protection setting configured on the HDFS cluster. This
	// setting corresponds to your dfs.data.transfer.protection setting in the
	// hdfs-site.xml file on your Hadoop cluster.
	DataTransferProtection HdfsDataTransferProtection

	// The RPC protection setting configured on the HDFS cluster. This setting
	// corresponds to your hadoop.rpc.protection setting in your core-site.xml file on
	// your Hadoop cluster.
	RpcProtection HdfsRpcProtection

	noSmithyDocumentSerde
}

// The details about an Amazon Web Services storage service that DataSync
// Discovery recommends for a resource in your on-premises storage system. For more
// information, see Recommendations provided by DataSync Discovery (https://docs.aws.amazon.com/datasync/latest/userguide/discovery-understand-recommendations.html)
// .
type Recommendation struct {

	// The estimated monthly cost of the recommended Amazon Web Services storage
	// service.
	EstimatedMonthlyStorageCost *string

	// Information about how you can set up a recommended Amazon Web Services storage
	// service.
	StorageConfiguration map[string]string

	// A recommended Amazon Web Services storage service that you can migrate data to
	// based on information that DataSync Discovery collects about your on-premises
	// storage system.
	StorageType *string

	noSmithyDocumentSerde
}

// Specifies where DataSync uploads your task report (https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html)
// .
type ReportDestination struct {

	// Specifies the Amazon S3 bucket where DataSync uploads your task report.
	S3 *ReportDestinationS3

	noSmithyDocumentSerde
}

// Specifies the Amazon S3 bucket where DataSync uploads your task report (https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html)
// .
type ReportDestinationS3 struct {

	// Specifies the Amazon Resource Name (ARN) of the IAM policy that allows DataSync
	// to upload a task report to your S3 bucket. For more information, see Allowing
	// DataSync to upload a task report to an Amazon S3 bucket (https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html)
	// .
	//
	// This member is required.
	BucketAccessRoleArn *string

	// Specifies the ARN of the S3 bucket where DataSync uploads your report.
	//
	// This member is required.
	S3BucketArn *string

	// Specifies a bucket prefix for your report.
	Subdirectory *string

	noSmithyDocumentSerde
}

// Specifies the level of detail for a particular aspect of your DataSync task
// report (https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html)
// .
type ReportOverride struct {

	// Specifies whether your task report includes errors only or successes and
	// errors. For example, your report might mostly include only what didn't go well
	// in your transfer ( ERRORS_ONLY ). At the same time, you want to verify that your
	// task filter (https://docs.aws.amazon.com/datasync/latest/userguide/filtering.html)
	// is working correctly. In this situation, you can get a list of what files
	// DataSync successfully skipped and if something transferred that you didn't to
	// transfer ( SUCCESSES_AND_ERRORS ).
	ReportLevel ReportLevel

	noSmithyDocumentSerde
}

// The level of detail included in each aspect of your DataSync task report (https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html)
// .
type ReportOverrides struct {

	// Specifies the level of reporting for the files, objects, and directories that
	// DataSync attempted to delete in your destination location. This only applies if
	// you configure your task (https://docs.aws.amazon.com/datasync/latest/userguide/configure-metadata.html)
	// to delete data in the destination that isn't in the source.
	Deleted *ReportOverride

	// Specifies the level of reporting for the files, objects, and directories that
	// DataSync attempted to skip during your transfer.
	Skipped *ReportOverride

	// Specifies the level of reporting for the files, objects, and directories that
	// DataSync attempted to transfer.
	Transferred *ReportOverride

	// Specifies the level of reporting for the files, objects, and directories that
	// DataSync attempted to verify at the end of your transfer.
	Verified *ReportOverride

	noSmithyDocumentSerde
}

// Indicates whether DataSync created a complete task report (https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html)
// for your transfer.
type ReportResult struct {

	// Indicates the code associated with the error if DataSync can't create a
	// complete report.
	ErrorCode *string

	// Provides details about issues creating a report.
	ErrorDetail *string

	// Indicates whether DataSync is still working on your report, created a report,
	// or can't create a complete report.
	Status PhaseStatus

	noSmithyDocumentSerde
}

// Information provided by DataSync Discovery about the resources in your
// on-premises storage system.
type ResourceDetails struct {

	// The information that DataSync Discovery collects about the cluster in your
	// on-premises storage system.
	NetAppONTAPClusters []NetAppONTAPCluster

	// The information that DataSync Discovery collects about storage virtual machines
	// (SVMs) in your on-premises storage system.
	NetAppONTAPSVMs []NetAppONTAPSVM

	// The information that DataSync Discovery collects about volumes in your
	// on-premises storage system.
	NetAppONTAPVolumes []NetAppONTAPVolume

	noSmithyDocumentSerde
}

// Information, including performance data and capacity usage, provided by
// DataSync Discovery about a resource in your on-premises storage system.
type ResourceMetrics struct {

	// The storage capacity of the on-premises storage system resource.
	Capacity *Capacity

	// The types of performance data that DataSync Discovery collects about the
	// on-premises storage system resource.
	P95Metrics *P95Metrics

	// The universally unique identifier (UUID) of the on-premises storage system
	// resource.
	ResourceId *string

	// The type of on-premises storage system resource.
	ResourceType DiscoveryResourceType

	// The time when DataSync Discovery collected this information from the resource.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// Specifies the Amazon Resource Name (ARN) of the Identity and Access Management
// (IAM) role that DataSync uses to access your S3 bucket. For more information,
// see Accessing S3 buckets (https://docs.aws.amazon.com/datasync/latest/userguide/create-s3-location.html#create-s3-location-access)
// .
type S3Config struct {

	// Specifies the ARN of the IAM role that DataSync uses to access your S3 bucket.
	//
	// This member is required.
	BucketAccessRoleArn *string

	noSmithyDocumentSerde
}

// Specifies the S3 bucket where you're hosting the manifest that you want
// DataSync to use. For more information and configuration examples, see
// Specifying what DataSync transfers by using a manifest (https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html)
// .
type S3ManifestConfig struct {

	// Specifies the Identity and Access Management (IAM) role that allows DataSync to
	// access your manifest. For more information, see Providing DataSync access to
	// your manifest (https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html#transferring-with-manifest-access)
	// .
	//
	// This member is required.
	BucketAccessRoleArn *string

	// Specifies the Amazon S3 object key of your manifest. This can include a prefix
	// (for example, prefix/my-manifest.csv ).
	//
	// This member is required.
	ManifestObjectPath *string

	// Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting
	// your manifest.
	//
	// This member is required.
	S3BucketArn *string

	// Specifies the object version ID of the manifest that you want DataSync to use.
	// If you don't set this, DataSync uses the latest version of the object.
	ManifestObjectVersionId *string

	noSmithyDocumentSerde
}

// Specifies the version of the Server Message Block (SMB) protocol that DataSync
// uses to access an SMB file server.
type SmbMountOptions struct {

	// By default, DataSync automatically chooses an SMB protocol version based on
	// negotiation with your SMB file server. You also can configure DataSync to use a
	// specific SMB version, but we recommend doing this only if DataSync has trouble
	// negotiating with the SMB file server automatically. These are the following
	// options for configuring the SMB version:
	//   - AUTOMATIC (default): DataSync and the SMB file server negotiate the highest
	//   version of SMB that they mutually support between 2.1 and 3.1.1. This is the
	//   recommended option. If you instead choose a specific version that your file
	//   server doesn't support, you may get an Operation Not Supported error.
	//   - SMB3 : Restricts the protocol negotiation to only SMB version 3.0.2.
	//   - SMB2 : Restricts the protocol negotiation to only SMB version 2.1.
	//   - SMB2_0 : Restricts the protocol negotiation to only SMB version 2.0.
	//   - SMB1 : Restricts the protocol negotiation to only SMB version 1.0. The SMB1
	//   option isn't available when creating an Amazon FSx for NetApp ONTAP location (https://docs.aws.amazon.com/datasync/latest/userguide/API_CreateLocationFsxOntap.html)
	//   .
	Version SmbVersion

	noSmithyDocumentSerde
}

// Specifies the manifest that you want DataSync to use and where it's hosted. For
// more information and configuration examples, see Specifying what DataSync
// transfers by using a manifest (https://docs.aws.amazon.com/datasync/latest/userguide/transferring-with-manifest.html)
// .
type SourceManifestConfig struct {

	// Specifies the S3 bucket where you're hosting your manifest.
	//
	// This member is required.
	S3 *S3ManifestConfig

	noSmithyDocumentSerde
}

// Information that identifies an on-premises storage system that you're using
// with DataSync Discovery.
type StorageSystemListEntry struct {

	// The name of an on-premises storage system that you added to DataSync Discovery.
	Name *string

	// The Amazon Resource Names (ARN) of an on-premises storage system that you added
	// to DataSync Discovery.
	StorageSystemArn *string

	noSmithyDocumentSerde
}

// A key-value pair representing a single tag that's been applied to an Amazon Web
// Services resource.
type TagListEntry struct {

	// The key for an Amazon Web Services resource tag.
	//
	// This member is required.
	Key *string

	// The value for an Amazon Web Services resource tag.
	Value *string

	noSmithyDocumentSerde
}

// Represents a single entry in a list of DataSync task executions that's returned
// with the ListTaskExecutions (https://docs.aws.amazon.com/datasync/latest/userguide/API_ListTaskExecutions.html)
// operation.
type TaskExecutionListEntry struct {

	// The status of a task execution. For more information, see Task execution
	// statuses (https://docs.aws.amazon.com/datasync/latest/userguide/understand-task-statuses.html#understand-task-execution-statuses)
	// .
	Status TaskExecutionStatus

	// The Amazon Resource Name (ARN) of a task execution.
	TaskExecutionArn *string

	noSmithyDocumentSerde
}

// Describes the detailed result of a TaskExecution operation. This result
// includes the time in milliseconds spent in each phase, the status of the task
// execution, and the errors encountered.
type TaskExecutionResultDetail struct {

	// Errors that DataSync encountered during execution of the task. You can use this
	// error code to help troubleshoot issues.
	ErrorCode *string

	// Detailed description of an error that was encountered during the task
	// execution. You can use this information to help troubleshoot issues.
	ErrorDetail *string

	// The total time in milliseconds that DataSync spent in the PREPARING phase.
	PrepareDuration *int64

	// The status of the PREPARING phase.
	PrepareStatus PhaseStatus

	// The total time in milliseconds that DataSync took to transfer the file from the
	// source to the destination location.
	TotalDuration *int64

	// The total time in milliseconds that DataSync spent in the TRANSFERRING phase.
	TransferDuration *int64

	// The status of the TRANSFERRING phase.
	TransferStatus PhaseStatus

	// The total time in milliseconds that DataSync spent in the VERIFYING phase.
	VerifyDuration *int64

	// The status of the VERIFYING phase.
	VerifyStatus PhaseStatus

	noSmithyDocumentSerde
}

// You can use API filters to narrow down the list of resources returned by
// ListTasks . For example, to retrieve all tasks on a source location, you can use
// ListTasks with filter name LocationId and Operator Equals with the ARN for the
// location. For more information, see filtering DataSync resources (https://docs.aws.amazon.com/datasync/latest/userguide/query-resources.html)
// .
type TaskFilter struct {

	// The name of the filter being used. Each API call supports a list of filters
	// that are available for it. For example, LocationId for ListTasks .
	//
	// This member is required.
	Name TaskFilterName

	// The operator that is used to compare filter values (for example, Equals or
	// Contains ).
	//
	// This member is required.
	Operator Operator

	// The values that you want to filter for. For example, you might want to display
	// only tasks for a specific destination location.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Represents a single entry in a list of tasks. TaskListEntry returns an array
// that contains a list of tasks when the ListTasks (https://docs.aws.amazon.com/datasync/latest/userguide/API_ListTasks.html)
// operation is called. A task includes the source and destination file systems to
// sync and the options to use for the tasks.
type TaskListEntry struct {

	// The name of the task.
	Name *string

	// The status of the task.
	Status TaskStatus

	// The Amazon Resource Name (ARN) of the task.
	TaskArn *string

	noSmithyDocumentSerde
}

// Specifies how you want to configure a task report, which provides detailed
// information about for your DataSync transfer. For more information, see Task
// reports (https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html)
// .
type TaskReportConfig struct {

	// Specifies the Amazon S3 bucket where DataSync uploads your task report. For
	// more information, see Task reports (https://docs.aws.amazon.com/datasync/latest/userguide/task-reports.html#task-report-access)
	// .
	Destination *ReportDestination

	// Specifies whether your task report includes the new version of each object
	// transferred into an S3 bucket. This only applies if you enable versioning on
	// your bucket (https://docs.aws.amazon.com/AmazonS3/latest/userguide/manage-versioning-examples.html)
	// . Keep in mind that setting this to INCLUDE can increase the duration of your
	// task execution.
	ObjectVersionIds ObjectVersionIds

	// Specifies the type of task report that you want:
	//   - SUMMARY_ONLY : Provides necessary details about your task, including the
	//   number of files, objects, and directories transferred and transfer duration.
	//   - STANDARD : Provides complete details about your task, including a full list
	//   of files, objects, and directories that were transferred, skipped, verified, and
	//   more.
	OutputType ReportOutputType

	// Customizes the reporting level for aspects of your task report. For example,
	// your report might generally only include errors, but you could specify that you
	// want a list of successes and errors just for the files that DataSync attempted
	// to delete in your destination location.
	Overrides *ReportOverrides

	// Specifies whether you want your task report to include only what went wrong
	// with your transfer or a list of what succeeded and didn't.
	//   - ERRORS_ONLY : A report shows what DataSync was unable to transfer, skip,
	//   verify, and delete.
	//   - SUCCESSES_AND_ERRORS : A report shows what DataSync was able and unable to
	//   transfer, skip, verify, and delete.
	ReportLevel ReportLevel

	noSmithyDocumentSerde
}

// Specifies the schedule you want your task to use for repeated executions. For
// more information, see Schedule Expressions for Rules (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html)
// .
type TaskSchedule struct {

	// A cron expression that specifies when DataSync initiates a scheduled transfer
	// from a source to a destination location.
	//
	// This member is required.
	ScheduleExpression *string

	noSmithyDocumentSerde
}

// The throughput peaks for an on-premises storage system volume. Each data point
// represents the 95th percentile peak value during a 1-hour interval.
type Throughput struct {

	// Peak throughput unrelated to read and write operations.
	Other *float64

	// Peak throughput related to read operations.
	Read *float64

	// Peak total throughput on your on-premises storage system resource.
	Total *float64

	// Peak throughput related to write operations.
	Write *float64

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
