// Code generated by smithy-go-codegen DO NOT EDIT.

package ebs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ebs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about the blocks that are different between two Amazon
// Elastic Block Store snapshots of the same volume/snapshot lineage. You should
// always retry requests that receive server ( 5xx ) error responses, and
// ThrottlingException and RequestThrottledException client error responses. For
// more information see Error retries (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/error-retries.html)
// in the Amazon Elastic Compute Cloud User Guide.
func (c *Client) ListChangedBlocks(ctx context.Context, params *ListChangedBlocksInput, optFns ...func(*Options)) (*ListChangedBlocksOutput, error) {
	if params == nil {
		params = &ListChangedBlocksInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListChangedBlocks", params, optFns, c.addOperationListChangedBlocksMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListChangedBlocksOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListChangedBlocksInput struct {

	// The ID of the second snapshot to use for the comparison. The SecondSnapshotId
	// parameter must be specified with a FirstSnapshotID parameter; otherwise, an
	// error occurs.
	//
	// This member is required.
	SecondSnapshotId *string

	// The ID of the first snapshot to use for the comparison. The FirstSnapshotID
	// parameter must be specified with a SecondSnapshotId parameter; otherwise, an
	// error occurs.
	FirstSnapshotId *string

	// The maximum number of blocks to be returned by the request. Even if additional
	// blocks can be retrieved from the snapshot, the request can return less blocks
	// than MaxResults or an empty array of blocks. To retrieve the next set of blocks
	// from the snapshot, make another request with the returned NextToken value. The
	// value of NextToken is null when there are no more blocks to return.
	MaxResults *int32

	// The token to request the next page of results. If you specify NextToken, then
	// StartingBlockIndex is ignored.
	NextToken *string

	// The block index from which the comparison should start. The list in the
	// response will start from this block index or the next valid block index in the
	// snapshots. If you specify NextToken, then StartingBlockIndex is ignored.
	StartingBlockIndex *int32

	noSmithyDocumentSerde
}

type ListChangedBlocksOutput struct {

	// The size of the blocks in the snapshot, in bytes.
	BlockSize *int32

	// An array of objects containing information about the changed blocks.
	ChangedBlocks []types.ChangedBlock

	// The time when the BlockToken expires.
	ExpiryTime *time.Time

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// The size of the volume in GB.
	VolumeSize *int64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListChangedBlocksMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListChangedBlocks{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListChangedBlocks{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListChangedBlocks"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListChangedBlocksValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListChangedBlocks(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListChangedBlocksAPIClient is a client that implements the ListChangedBlocks
// operation.
type ListChangedBlocksAPIClient interface {
	ListChangedBlocks(context.Context, *ListChangedBlocksInput, ...func(*Options)) (*ListChangedBlocksOutput, error)
}

var _ ListChangedBlocksAPIClient = (*Client)(nil)

// ListChangedBlocksPaginatorOptions is the paginator options for ListChangedBlocks
type ListChangedBlocksPaginatorOptions struct {
	// The maximum number of blocks to be returned by the request. Even if additional
	// blocks can be retrieved from the snapshot, the request can return less blocks
	// than MaxResults or an empty array of blocks. To retrieve the next set of blocks
	// from the snapshot, make another request with the returned NextToken value. The
	// value of NextToken is null when there are no more blocks to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListChangedBlocksPaginator is a paginator for ListChangedBlocks
type ListChangedBlocksPaginator struct {
	options   ListChangedBlocksPaginatorOptions
	client    ListChangedBlocksAPIClient
	params    *ListChangedBlocksInput
	nextToken *string
	firstPage bool
}

// NewListChangedBlocksPaginator returns a new ListChangedBlocksPaginator
func NewListChangedBlocksPaginator(client ListChangedBlocksAPIClient, params *ListChangedBlocksInput, optFns ...func(*ListChangedBlocksPaginatorOptions)) *ListChangedBlocksPaginator {
	if params == nil {
		params = &ListChangedBlocksInput{}
	}

	options := ListChangedBlocksPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListChangedBlocksPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListChangedBlocksPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListChangedBlocks page.
func (p *ListChangedBlocksPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListChangedBlocksOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListChangedBlocks(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListChangedBlocks(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListChangedBlocks",
	}
}
