// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Indicates whether the user requires a password to authenticate.
type Authentication struct {

	// The number of passwords belonging to the user. The maximum is two.
	PasswordCount *int32

	// Indicates whether the user requires a password to authenticate.
	Type AuthenticationType

	noSmithyDocumentSerde
}

// Specifies the authentication mode to use.
type AuthenticationMode struct {

	// Specifies the passwords to use for authentication if Type is set to password .
	Passwords []string

	// Specifies the authentication type. Possible options are IAM authentication,
	// password and no password.
	Type InputAuthenticationType

	noSmithyDocumentSerde
}

// Describes an Availability Zone in which the cluster is launched.
type AvailabilityZone struct {

	// The name of the Availability Zone.
	Name *string

	noSmithyDocumentSerde
}

// Contains all of the attributes of a specific cluster.
type CacheCluster struct {

	// The ARN (Amazon Resource Name) of the cache cluster.
	ARN *string

	// A flag that enables encryption at-rest when set to true . You cannot modify the
	// value of AtRestEncryptionEnabled after the cluster is created. To enable
	// at-rest encryption on a cluster you must set AtRestEncryptionEnabled to true
	// when you create a cluster. Required: Only available when creating a replication
	// group in an Amazon VPC using redis version 3.2.6 , 4.x or later. Default: false
	AtRestEncryptionEnabled *bool

	// A flag that enables using an AuthToken (password) when issuing Redis commands.
	// Default: false
	AuthTokenEnabled *bool

	// The date the auth token was last modified
	AuthTokenLastModifiedDate *time.Time

	//  If you are running Redis engine version 6.0 or later, set this parameter to
	// yes if you want to opt-in to the next auto minor version upgrade campaign. This
	// parameter is disabled for previous versions.
	AutoMinorVersionUpgrade *bool

	// The date and time when the cluster was created.
	CacheClusterCreateTime *time.Time

	// The user-supplied identifier of the cluster. This identifier is a unique key
	// that identifies a cluster.
	CacheClusterId *string

	// The current state of this cluster, one of the following values: available ,
	// creating , deleted , deleting , incompatible-network , modifying , rebooting
	// cluster nodes , restore-failed , or snapshotting .
	CacheClusterStatus *string

	// The name of the compute and memory capacity node type for the cluster. The
	// following node types are supported by ElastiCache. Generally speaking, the
	// current generation types provide more memory and computational power at lower
	// cost when compared to their equivalent previous generation counterparts.
	//   - General purpose:
	//   - Current generation: M7g node types: cache.m7g.large , cache.m7g.xlarge ,
	//   cache.m7g.2xlarge , cache.m7g.4xlarge , cache.m7g.8xlarge , cache.m7g.12xlarge
	//   , cache.m7g.16xlarge For region availability, see Supported Node Types (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
	//   M6g node types (available only for Redis engine version 5.0.6 onward and for
	//   Memcached engine version 1.5.16 onward): cache.m6g.large , cache.m6g.xlarge ,
	//   cache.m6g.2xlarge , cache.m6g.4xlarge , cache.m6g.8xlarge , cache.m6g.12xlarge
	//   , cache.m6g.16xlarge M5 node types: cache.m5.large , cache.m5.xlarge ,
	//   cache.m5.2xlarge , cache.m5.4xlarge , cache.m5.12xlarge , cache.m5.24xlarge M4
	//   node types: cache.m4.large , cache.m4.xlarge , cache.m4.2xlarge ,
	//   cache.m4.4xlarge , cache.m4.10xlarge T4g node types (available only for Redis
	//   engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
	//   cache.t4g.micro , cache.t4g.small , cache.t4g.medium T3 node types:
	//   cache.t3.micro , cache.t3.small , cache.t3.medium T2 node types:
	//   cache.t2.micro , cache.t2.small , cache.t2.medium
	//   - Previous generation: (not recommended. Existing clusters are still
	//   supported but creation of new clusters is not supported for these types.) T1
	//   node types: cache.t1.micro M1 node types: cache.m1.small , cache.m1.medium ,
	//   cache.m1.large , cache.m1.xlarge M3 node types: cache.m3.medium ,
	//   cache.m3.large , cache.m3.xlarge , cache.m3.2xlarge
	//   - Compute optimized:
	//   - Previous generation: (not recommended. Existing clusters are still
	//   supported but creation of new clusters is not supported for these types.) C1
	//   node types: cache.c1.xlarge
	//   - Memory optimized:
	//   - Current generation: R7g node types: cache.r7g.large , cache.r7g.xlarge ,
	//   cache.r7g.2xlarge , cache.r7g.4xlarge , cache.r7g.8xlarge , cache.r7g.12xlarge
	//   , cache.r7g.16xlarge For region availability, see Supported Node Types (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
	//   R6g node types (available only for Redis engine version 5.0.6 onward and for
	//   Memcached engine version 1.5.16 onward): cache.r6g.large , cache.r6g.xlarge ,
	//   cache.r6g.2xlarge , cache.r6g.4xlarge , cache.r6g.8xlarge , cache.r6g.12xlarge
	//   , cache.r6g.16xlarge R5 node types: cache.r5.large , cache.r5.xlarge ,
	//   cache.r5.2xlarge , cache.r5.4xlarge , cache.r5.12xlarge , cache.r5.24xlarge R4
	//   node types: cache.r4.large , cache.r4.xlarge , cache.r4.2xlarge ,
	//   cache.r4.4xlarge , cache.r4.8xlarge , cache.r4.16xlarge
	//   - Previous generation: (not recommended. Existing clusters are still
	//   supported but creation of new clusters is not supported for these types.) M2
	//   node types: cache.m2.xlarge , cache.m2.2xlarge , cache.m2.4xlarge R3 node
	//   types: cache.r3.large , cache.r3.xlarge , cache.r3.2xlarge ,
	//
	// cache.r3.4xlarge , cache.r3.8xlarge
	// Additional node type info
	//   - All current generation instance types are created in Amazon VPC by default.
	//   - Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//   - Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//   - Redis configuration variables appendonly and appendfsync are not supported
	//   on Redis version 2.8.22 and later.
	CacheNodeType *string

	// A list of cache nodes that are members of the cluster.
	CacheNodes []CacheNode

	// Status of the cache parameter group.
	CacheParameterGroup *CacheParameterGroupStatus

	// A list of cache security group elements, composed of name and status
	// sub-elements.
	CacheSecurityGroups []CacheSecurityGroupMembership

	// The name of the cache subnet group associated with the cluster.
	CacheSubnetGroupName *string

	// The URL of the web page where you can download the latest ElastiCache client
	// library.
	ClientDownloadLandingPage *string

	// Represents a Memcached cluster endpoint which can be used by an application to
	// connect to any node in the cluster. The configuration endpoint will always have
	// .cfg in it. Example: mem-3.9dvc4r.cfg.usw2.cache.amazonaws.com:11211
	ConfigurationEndpoint *Endpoint

	// The name of the cache engine ( memcached or redis ) to be used for this cluster.
	Engine *string

	// The version of the cache engine that is used in this cluster.
	EngineVersion *string

	// The network type associated with the cluster, either ipv4 | ipv6 . IPv6 is
	// supported for workloads using Redis engine version 6.2 onward or Memcached
	// engine version 1.6.6 on all instances built on the Nitro system (http://aws.amazon.com/ec2/nitro/)
	// .
	IpDiscovery IpDiscovery

	// Returns the destination, format and type of the logs.
	LogDeliveryConfigurations []LogDeliveryConfiguration

	// Must be either ipv4 | ipv6 | dual_stack . IPv6 is supported for workloads using
	// Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all
	// instances built on the Nitro system (http://aws.amazon.com/ec2/nitro/) .
	NetworkType NetworkType

	// Describes a notification topic and its status. Notification topics are used for
	// publishing ElastiCache events to subscribers using Amazon Simple Notification
	// Service (SNS).
	NotificationConfiguration *NotificationConfiguration

	// The number of cache nodes in the cluster. For clusters running Redis, this
	// value must be 1. For clusters running Memcached, this value must be between 1
	// and 40.
	NumCacheNodes *int32

	// A group of settings that are applied to the cluster in the future, or that are
	// currently being applied.
	PendingModifiedValues *PendingModifiedValues

	// The name of the Availability Zone in which the cluster is located or "Multiple"
	// if the cache nodes are located in different Availability Zones.
	PreferredAvailabilityZone *string

	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H
	// Clock UTC). The minimum maintenance window is a 60 minute period. Valid values
	// for ddd are:
	//   - sun
	//   - mon
	//   - tue
	//   - wed
	//   - thu
	//   - fri
	//   - sat
	// Example: sun:23:00-mon:01:30
	PreferredMaintenanceWindow *string

	// The outpost ARN in which the cache cluster is created.
	PreferredOutpostArn *string

	// The replication group to which this cluster belongs. If this field is empty,
	// the cluster is not associated with any replication group.
	ReplicationGroupId *string

	// A boolean value indicating whether log delivery is enabled for the replication
	// group.
	ReplicationGroupLogDeliveryEnabled *bool

	// A list of VPC Security Groups associated with the cluster.
	SecurityGroups []SecurityGroupMembership

	// The number of days for which ElastiCache retains automatic cluster snapshots
	// before deleting them. For example, if you set SnapshotRetentionLimit to 5, a
	// snapshot that was taken today is retained for 5 days before being deleted. If
	// the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
	SnapshotRetentionLimit *int32

	// The daily time range (in UTC) during which ElastiCache begins taking a daily
	// snapshot of your cluster. Example: 05:00-09:00
	SnapshotWindow *string

	// A flag that enables in-transit encryption when set to true . Required: Only
	// available when creating a replication group in an Amazon VPC using redis version
	// 3.2.6 , 4.x or later. Default: false
	TransitEncryptionEnabled *bool

	// A setting that allows you to migrate your clients to use in-transit encryption,
	// with no downtime.
	TransitEncryptionMode TransitEncryptionMode

	noSmithyDocumentSerde
}

// Provides all of the details about a particular cache engine version.
type CacheEngineVersion struct {

	// The description of the cache engine.
	CacheEngineDescription *string

	// The description of the cache engine version.
	CacheEngineVersionDescription *string

	// The name of the cache parameter group family associated with this cache engine.
	// Valid values are: memcached1.4 | memcached1.5 | memcached1.6 | redis2.6 |
	// redis2.8 | redis3.2 | redis4.0 | redis5.0 | redis6.x | redis7
	CacheParameterGroupFamily *string

	// The name of the cache engine.
	Engine *string

	// The version number of the cache engine.
	EngineVersion *string

	noSmithyDocumentSerde
}

// Represents an individual cache node within a cluster. Each cache node runs its
// own instance of the cluster's protocol-compliant caching software - either
// Memcached or Redis. The following node types are supported by ElastiCache.
// Generally speaking, the current generation types provide more memory and
// computational power at lower cost when compared to their equivalent previous
// generation counterparts.
//   - General purpose:
//   - Current generation: M7g node types: cache.m7g.large , cache.m7g.xlarge ,
//     cache.m7g.2xlarge , cache.m7g.4xlarge , cache.m7g.8xlarge , cache.m7g.12xlarge
//     , cache.m7g.16xlarge For region availability, see Supported Node Types (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
//     M6g node types (available only for Redis engine version 5.0.6 onward and for
//     Memcached engine version 1.5.16 onward): cache.m6g.large , cache.m6g.xlarge ,
//     cache.m6g.2xlarge , cache.m6g.4xlarge , cache.m6g.8xlarge , cache.m6g.12xlarge
//     , cache.m6g.16xlarge M5 node types: cache.m5.large , cache.m5.xlarge ,
//     cache.m5.2xlarge , cache.m5.4xlarge , cache.m5.12xlarge , cache.m5.24xlarge M4
//     node types: cache.m4.large , cache.m4.xlarge , cache.m4.2xlarge ,
//     cache.m4.4xlarge , cache.m4.10xlarge T4g node types (available only for Redis
//     engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
//     cache.t4g.micro , cache.t4g.small , cache.t4g.medium T3 node types:
//     cache.t3.micro , cache.t3.small , cache.t3.medium T2 node types:
//     cache.t2.micro , cache.t2.small , cache.t2.medium
//   - Previous generation: (not recommended. Existing clusters are still
//     supported but creation of new clusters is not supported for these types.) T1
//     node types: cache.t1.micro M1 node types: cache.m1.small , cache.m1.medium ,
//     cache.m1.large , cache.m1.xlarge M3 node types: cache.m3.medium ,
//     cache.m3.large , cache.m3.xlarge , cache.m3.2xlarge
//   - Compute optimized:
//   - Previous generation: (not recommended. Existing clusters are still
//     supported but creation of new clusters is not supported for these types.) C1
//     node types: cache.c1.xlarge
//   - Memory optimized:
//   - Current generation: R7g node types: cache.r7g.large , cache.r7g.xlarge ,
//     cache.r7g.2xlarge , cache.r7g.4xlarge , cache.r7g.8xlarge , cache.r7g.12xlarge
//     , cache.r7g.16xlarge For region availability, see Supported Node Types (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
//     R6g node types (available only for Redis engine version 5.0.6 onward and for
//     Memcached engine version 1.5.16 onward): cache.r6g.large , cache.r6g.xlarge ,
//     cache.r6g.2xlarge , cache.r6g.4xlarge , cache.r6g.8xlarge , cache.r6g.12xlarge
//     , cache.r6g.16xlarge R5 node types: cache.r5.large , cache.r5.xlarge ,
//     cache.r5.2xlarge , cache.r5.4xlarge , cache.r5.12xlarge , cache.r5.24xlarge R4
//     node types: cache.r4.large , cache.r4.xlarge , cache.r4.2xlarge ,
//     cache.r4.4xlarge , cache.r4.8xlarge , cache.r4.16xlarge
//   - Previous generation: (not recommended. Existing clusters are still
//     supported but creation of new clusters is not supported for these types.) M2
//     node types: cache.m2.xlarge , cache.m2.2xlarge , cache.m2.4xlarge R3 node
//     types: cache.r3.large , cache.r3.xlarge , cache.r3.2xlarge ,
//
// cache.r3.4xlarge , cache.r3.8xlarge
// Additional node type info
//   - All current generation instance types are created in Amazon VPC by default.
//   - Redis append-only files (AOF) are not supported for T1 or T2 instances.
//   - Redis Multi-AZ with automatic failover is not supported on T1 instances.
//   - Redis configuration variables appendonly and appendfsync are not supported
//     on Redis version 2.8.22 and later.
type CacheNode struct {

	// The date and time when the cache node was created.
	CacheNodeCreateTime *time.Time

	// The cache node identifier. A node ID is a numeric identifier (0001, 0002,
	// etc.). The combination of cluster ID and node ID uniquely identifies every cache
	// node used in a customer's Amazon account.
	CacheNodeId *string

	// The current state of this cache node, one of the following values: available ,
	// creating , rebooting , or deleting .
	CacheNodeStatus *string

	// The Availability Zone where this node was created and now resides.
	CustomerAvailabilityZone *string

	// The customer outpost ARN of the cache node.
	CustomerOutpostArn *string

	// The hostname for connecting to this cache node.
	Endpoint *Endpoint

	// The status of the parameter group applied to this cache node.
	ParameterGroupStatus *string

	// The ID of the primary node to which this read replica node is synchronized. If
	// this field is empty, this node is not associated with a primary cluster.
	SourceCacheNodeId *string

	noSmithyDocumentSerde
}

// A parameter that has a different value for each cache node type it is applied
// to. For example, in a Redis cluster, a cache.m1.large cache node type would
// have a larger maxmemory value than a cache.m1.small type.
type CacheNodeTypeSpecificParameter struct {

	// The valid range of values for the parameter.
	AllowedValues *string

	// A list of cache node types and their corresponding values for this parameter.
	CacheNodeTypeSpecificValues []CacheNodeTypeSpecificValue

	// Indicates whether a change to the parameter is applied immediately or requires
	// a reboot for the change to be applied. You can force a reboot or wait until the
	// next maintenance window's reboot. For more information, see Rebooting a Cluster (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html)
	// .
	ChangeType ChangeType

	// The valid data type for the parameter.
	DataType *string

	// A description of the parameter.
	Description *string

	// Indicates whether ( true ) or not ( false ) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool

	// The earliest cache engine version to which the parameter can apply.
	MinimumEngineVersion *string

	// The name of the parameter.
	ParameterName *string

	// The source of the parameter value.
	Source *string

	noSmithyDocumentSerde
}

// A value that applies only to a certain cache node type.
type CacheNodeTypeSpecificValue struct {

	// The cache node type for which this value applies.
	CacheNodeType *string

	// The value for the cache node type.
	Value *string

	noSmithyDocumentSerde
}

// The status of the service update on the cache node
type CacheNodeUpdateStatus struct {

	// The node ID of the cache cluster
	CacheNodeId *string

	// The deletion date of the node
	NodeDeletionDate *time.Time

	// The end date of the update for a node
	NodeUpdateEndDate *time.Time

	// Reflects whether the update was initiated by the customer or automatically
	// applied
	NodeUpdateInitiatedBy NodeUpdateInitiatedBy

	// The date when the update is triggered
	NodeUpdateInitiatedDate *time.Time

	// The start date of the update for a node
	NodeUpdateStartDate *time.Time

	// The update status of the node
	NodeUpdateStatus NodeUpdateStatus

	// The date when the NodeUpdateStatus was last modified>
	NodeUpdateStatusModifiedDate *time.Time

	noSmithyDocumentSerde
}

// Represents the output of a CreateCacheParameterGroup operation.
type CacheParameterGroup struct {

	// The ARN (Amazon Resource Name) of the cache parameter group.
	ARN *string

	// The name of the cache parameter group family that this cache parameter group is
	// compatible with. Valid values are: memcached1.4 | memcached1.5 | memcached1.6 |
	// redis2.6 | redis2.8 | redis3.2 | redis4.0 | redis5.0 | redis6.x | redis7
	CacheParameterGroupFamily *string

	// The name of the cache parameter group.
	CacheParameterGroupName *string

	// The description for this cache parameter group.
	Description *string

	// Indicates whether the parameter group is associated with a Global datastore
	IsGlobal *bool

	noSmithyDocumentSerde
}

// Status of the cache parameter group.
type CacheParameterGroupStatus struct {

	// A list of the cache node IDs which need to be rebooted for parameter changes to
	// be applied. A node ID is a numeric identifier (0001, 0002, etc.).
	CacheNodeIdsToReboot []string

	// The name of the cache parameter group.
	CacheParameterGroupName *string

	// The status of parameter updates.
	ParameterApplyStatus *string

	noSmithyDocumentSerde
}

// Represents the output of one of the following operations:
//   - AuthorizeCacheSecurityGroupIngress
//   - CreateCacheSecurityGroup
//   - RevokeCacheSecurityGroupIngress
type CacheSecurityGroup struct {

	// The ARN of the cache security group,
	ARN *string

	// The name of the cache security group.
	CacheSecurityGroupName *string

	// The description of the cache security group.
	Description *string

	// A list of Amazon EC2 security groups that are associated with this cache
	// security group.
	EC2SecurityGroups []EC2SecurityGroup

	// The Amazon account ID of the cache security group owner.
	OwnerId *string

	noSmithyDocumentSerde
}

// Represents a cluster's status within a particular cache security group.
type CacheSecurityGroupMembership struct {

	// The name of the cache security group.
	CacheSecurityGroupName *string

	// The membership status in the cache security group. The status changes when a
	// cache security group is modified, or when the cache security groups assigned to
	// a cluster are modified.
	Status *string

	noSmithyDocumentSerde
}

// Represents the output of one of the following operations:
//   - CreateCacheSubnetGroup
//   - ModifyCacheSubnetGroup
type CacheSubnetGroup struct {

	// The ARN (Amazon Resource Name) of the cache subnet group.
	ARN *string

	// The description of the cache subnet group.
	CacheSubnetGroupDescription *string

	// The name of the cache subnet group.
	CacheSubnetGroupName *string

	// A list of subnets associated with the cache subnet group.
	Subnets []Subnet

	// Either ipv4 | ipv6 | dual_stack . IPv6 is supported for workloads using Redis
	// engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
	// built on the Nitro system (http://aws.amazon.com/ec2/nitro/) .
	SupportedNetworkTypes []NetworkType

	// The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group.
	VpcId *string

	noSmithyDocumentSerde
}

// The usage limits for storage and ElastiCache Processing Units for the cache.
type CacheUsageLimits struct {

	// The maximum data storage limit in the cache, expressed in Gigabytes.
	DataStorage *DataStorage

	// The configuration for the number of ElastiCache Processing Units (ECPU) the
	// cache can consume per second.
	ECPUPerSecond *ECPUPerSecond

	noSmithyDocumentSerde
}

// The configuration details of the CloudWatch Logs destination.
type CloudWatchLogsDestinationDetails struct {

	// The name of the CloudWatch Logs log group.
	LogGroup *string

	noSmithyDocumentSerde
}

// Node group (shard) configuration options when adding or removing replicas. Each
// node group (shard) configuration has the following members: NodeGroupId,
// NewReplicaCount, and PreferredAvailabilityZones.
type ConfigureShard struct {

	// The number of replicas you want in this node group at the end of this
	// operation. The maximum value for NewReplicaCount is 5. The minimum value
	// depends upon the type of Redis replication group you are working with. The
	// minimum number of replicas in a shard or replication group is:
	//   - Redis (cluster mode disabled)
	//   - If Multi-AZ: 1
	//   - If Multi-AZ: 0
	//   - Redis (cluster mode enabled): 0 (though you will not be able to failover to
	//   a replica if your primary node fails)
	//
	// This member is required.
	NewReplicaCount *int32

	// The 4-digit id for the node group you are configuring. For Redis (cluster mode
	// disabled) replication groups, the node group id is always 0001. To find a Redis
	// (cluster mode enabled)'s node group's (shard's) id, see Finding a Shard's Id (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/shard-find-id.html)
	// .
	//
	// This member is required.
	NodeGroupId *string

	// A list of PreferredAvailabilityZone strings that specify which availability
	// zones the replication group's nodes are to be in. The nummber of
	// PreferredAvailabilityZone values must equal the value of NewReplicaCount plus 1
	// to account for the primary node. If this member of ReplicaConfiguration is
	// omitted, ElastiCache for Redis selects the availability zone for each of the
	// replicas.
	PreferredAvailabilityZones []string

	// The outpost ARNs in which the cache cluster is created.
	PreferredOutpostArns []string

	noSmithyDocumentSerde
}

// The endpoint from which data should be migrated.
type CustomerNodeEndpoint struct {

	// The address of the node endpoint
	Address *string

	// The port of the node endpoint
	Port *int32

	noSmithyDocumentSerde
}

// The data storage limit.
type DataStorage struct {

	// The unit that the storage is measured in, in GB.
	//
	// This member is required.
	Unit DataStorageUnit

	// The upper limit for data storage the cache is set to use.
	Maximum *int32

	// The lower limit for data storage the cache is set to use.
	Minimum *int32

	noSmithyDocumentSerde
}

// Configuration details of either a CloudWatch Logs destination or Kinesis Data
// Firehose destination.
type DestinationDetails struct {

	// The configuration details of the CloudWatch Logs destination.
	CloudWatchLogsDetails *CloudWatchLogsDestinationDetails

	// The configuration details of the Kinesis Data Firehose destination.
	KinesisFirehoseDetails *KinesisFirehoseDestinationDetails

	noSmithyDocumentSerde
}

// Provides ownership and status information for an Amazon EC2 security group.
type EC2SecurityGroup struct {

	// The name of the Amazon EC2 security group.
	EC2SecurityGroupName *string

	// The Amazon account ID of the Amazon EC2 security group owner.
	EC2SecurityGroupOwnerId *string

	// The status of the Amazon EC2 security group.
	Status *string

	noSmithyDocumentSerde
}

// The configuration for the number of ElastiCache Processing Units (ECPU) the
// cache can consume per second.
type ECPUPerSecond struct {

	// The configuration for the maximum number of ECPUs the cache can consume per
	// second.
	Maximum *int32

	// The configuration for the minimum number of ECPUs the cache should be able
	// consume per second.
	Minimum *int32

	noSmithyDocumentSerde
}

// Represents the information required for client programs to connect to a cache
// node. This value is read-only.
type Endpoint struct {

	// The DNS hostname of the cache node.
	Address *string

	// The port number that the cache engine is listening on.
	Port *int32

	noSmithyDocumentSerde
}

// Represents the output of a DescribeEngineDefaultParameters operation.
type EngineDefaults struct {

	// A list of parameters specific to a particular cache node type. Each element in
	// the list contains detailed information about one parameter.
	CacheNodeTypeSpecificParameters []CacheNodeTypeSpecificParameter

	// Specifies the name of the cache parameter group family to which the engine
	// default parameters apply. Valid values are: memcached1.4 | memcached1.5 |
	// memcached1.6 | redis2.6 | redis2.8 | redis3.2 | redis4.0 | redis5.0 | redis6.0
	// | redis6.x | redis7
	CacheParameterGroupFamily *string

	// Provides an identifier to allow retrieval of paginated results.
	Marker *string

	// Contains a list of engine default parameters.
	Parameters []Parameter

	noSmithyDocumentSerde
}

// Represents a single occurrence of something interesting within the system. Some
// examples of events are creating a cluster, adding or removing a cache node, or
// rebooting a node.
type Event struct {

	// The date and time when the event occurred.
	Date *time.Time

	// The text of the event.
	Message *string

	// The identifier for the source of the event. For example, if the event occurred
	// at the cluster level, the identifier would be the name of the cluster.
	SourceIdentifier *string

	// Specifies the origin of this event - a cluster, a parameter group, a security
	// group, etc.
	SourceType SourceType

	noSmithyDocumentSerde
}

// Used to streamline results of a search based on the property being filtered.
type Filter struct {

	// The property being filtered. For example, UserId.
	//
	// This member is required.
	Name *string

	// The property values to filter on. For example, "user-123".
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Indicates the slot configuration and global identifier for a slice group.
type GlobalNodeGroup struct {

	// The name of the global node group
	GlobalNodeGroupId *string

	// The keyspace for this node group
	Slots *string

	noSmithyDocumentSerde
}

// Consists of a primary cluster that accepts writes and an associated secondary
// cluster that resides in a different Amazon region. The secondary cluster accepts
// only reads. The primary cluster automatically replicates updates to the
// secondary cluster.
//   - The GlobalReplicationGroupIdSuffix represents the name of the Global
//     datastore, which is what you use to associate a secondary cluster.
type GlobalReplicationGroup struct {

	// The ARN (Amazon Resource Name) of the global replication group.
	ARN *string

	// A flag that enables encryption at rest when set to true . You cannot modify the
	// value of AtRestEncryptionEnabled after the replication group is created. To
	// enable encryption at rest on a replication group you must set
	// AtRestEncryptionEnabled to true when you create the replication group.
	// Required: Only available when creating a replication group in an Amazon VPC
	// using redis version 3.2.6 , 4.x or later.
	AtRestEncryptionEnabled *bool

	// A flag that enables using an AuthToken (password) when issuing Redis commands.
	// Default: false
	AuthTokenEnabled *bool

	// The cache node type of the Global datastore
	CacheNodeType *string

	// A flag that indicates whether the Global datastore is cluster enabled.
	ClusterEnabled *bool

	// The Elasticache engine. For Redis only.
	Engine *string

	// The Elasticache Redis engine version.
	EngineVersion *string

	// Indicates the slot configuration and global identifier for each slice group.
	GlobalNodeGroups []GlobalNodeGroup

	// The optional description of the Global datastore
	GlobalReplicationGroupDescription *string

	// The name of the Global datastore
	GlobalReplicationGroupId *string

	// The replication groups that comprise the Global datastore.
	Members []GlobalReplicationGroupMember

	// The status of the Global datastore
	Status *string

	// A flag that enables in-transit encryption when set to true. Required: Only
	// available when creating a replication group in an Amazon VPC using redis version
	// 3.2.6 , 4.x or later.
	TransitEncryptionEnabled *bool

	noSmithyDocumentSerde
}

// The name of the Global datastore and role of this replication group in the
// Global datastore.
type GlobalReplicationGroupInfo struct {

	// The name of the Global datastore
	GlobalReplicationGroupId *string

	// The role of the replication group in a Global datastore. Can be primary or
	// secondary.
	GlobalReplicationGroupMemberRole *string

	noSmithyDocumentSerde
}

// A member of a Global datastore. It contains the Replication Group Id, the
// Amazon region and the role of the replication group.
type GlobalReplicationGroupMember struct {

	// Indicates whether automatic failover is enabled for the replication group.
	AutomaticFailover AutomaticFailoverStatus

	// The replication group id of the Global datastore member.
	ReplicationGroupId *string

	// The Amazon region of the Global datastore member.
	ReplicationGroupRegion *string

	// Indicates the role of the replication group, primary or secondary.
	Role *string

	// The status of the membership of the replication group.
	Status *string

	noSmithyDocumentSerde
}

// The configuration details of the Kinesis Data Firehose destination.
type KinesisFirehoseDestinationDetails struct {

	// The name of the Kinesis Data Firehose delivery stream.
	DeliveryStream *string

	noSmithyDocumentSerde
}

// Returns the destination, format and type of the logs.
type LogDeliveryConfiguration struct {

	// Configuration details of either a CloudWatch Logs destination or Kinesis Data
	// Firehose destination.
	DestinationDetails *DestinationDetails

	// Returns the destination type, either cloudwatch-logs or kinesis-firehose .
	DestinationType DestinationType

	// Returns the log format, either JSON or TEXT.
	LogFormat LogFormat

	// Refers to slow-log (https://redis.io/commands/slowlog) or engine-log.
	LogType LogType

	// Returns an error message for the log delivery configuration.
	Message *string

	// Returns the log delivery configuration status. Values are one of enabling |
	// disabling | modifying | active | error
	Status LogDeliveryConfigurationStatus

	noSmithyDocumentSerde
}

// Specifies the destination, format and type of the logs.
type LogDeliveryConfigurationRequest struct {

	// Configuration details of either a CloudWatch Logs destination or Kinesis Data
	// Firehose destination.
	DestinationDetails *DestinationDetails

	// Specify either cloudwatch-logs or kinesis-firehose as the destination type.
	DestinationType DestinationType

	// Specify if log delivery is enabled. Default true .
	Enabled *bool

	// Specifies either JSON or TEXT
	LogFormat LogFormat

	// Refers to slow-log (https://redis.io/commands/slowlog) or engine-log..
	LogType LogType

	noSmithyDocumentSerde
}

// Represents a collection of cache nodes in a replication group. One node in the
// node group is the read/write primary node. All the other nodes are read-only
// Replica nodes.
type NodeGroup struct {

	// The identifier for the node group (shard). A Redis (cluster mode disabled)
	// replication group contains only 1 node group; therefore, the node group ID is
	// 0001. A Redis (cluster mode enabled) replication group contains 1 to 90 node
	// groups numbered 0001 to 0090. Optionally, the user can provide the id for a node
	// group.
	NodeGroupId *string

	// A list containing information about individual nodes within the node group
	// (shard).
	NodeGroupMembers []NodeGroupMember

	// The endpoint of the primary node in this node group (shard).
	PrimaryEndpoint *Endpoint

	// The endpoint of the replica nodes in this node group (shard). This value is
	// read-only.
	ReaderEndpoint *Endpoint

	// The keyspace for this node group (shard).
	Slots *string

	// The current state of this replication group - creating , available , modifying ,
	// deleting .
	Status *string

	noSmithyDocumentSerde
}

// Node group (shard) configuration options. Each node group (shard) configuration
// has the following: Slots , PrimaryAvailabilityZone , ReplicaAvailabilityZones ,
// ReplicaCount .
type NodeGroupConfiguration struct {

	// Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for
	// the node group these configuration values apply to.
	NodeGroupId *string

	// The Availability Zone where the primary node of this node group (shard) is
	// launched.
	PrimaryAvailabilityZone *string

	// The outpost ARN of the primary node.
	PrimaryOutpostArn *string

	// A list of Availability Zones to be used for the read replicas. The number of
	// Availability Zones in this list must match the value of ReplicaCount or
	// ReplicasPerNodeGroup if not specified.
	ReplicaAvailabilityZones []string

	// The number of read replica nodes in this node group (shard).
	ReplicaCount *int32

	// The outpost ARN of the node replicas.
	ReplicaOutpostArns []string

	// A string that specifies the keyspace for a particular node group. Keyspaces
	// range from 0 to 16,383. The string is in the format startkey-endkey . Example:
	// "0-3999"
	Slots *string

	noSmithyDocumentSerde
}

// Represents a single node within a node group (shard).
type NodeGroupMember struct {

	// The ID of the cluster to which the node belongs.
	CacheClusterId *string

	// The ID of the node within its cluster. A node ID is a numeric identifier (0001,
	// 0002, etc.).
	CacheNodeId *string

	// The role that is currently assigned to the node - primary or replica . This
	// member is only applicable for Redis (cluster mode disabled) replication groups.
	CurrentRole *string

	// The name of the Availability Zone in which the node is located.
	PreferredAvailabilityZone *string

	// The outpost ARN of the node group member.
	PreferredOutpostArn *string

	// The information required for client programs to connect to a node for read
	// operations. The read endpoint is only applicable on Redis (cluster mode
	// disabled) clusters.
	ReadEndpoint *Endpoint

	noSmithyDocumentSerde
}

// The status of the service update on the node group member
type NodeGroupMemberUpdateStatus struct {

	// The cache cluster ID
	CacheClusterId *string

	// The node ID of the cache cluster
	CacheNodeId *string

	// The deletion date of the node
	NodeDeletionDate *time.Time

	// The end date of the update for a node
	NodeUpdateEndDate *time.Time

	// Reflects whether the update was initiated by the customer or automatically
	// applied
	NodeUpdateInitiatedBy NodeUpdateInitiatedBy

	// The date when the update is triggered
	NodeUpdateInitiatedDate *time.Time

	// The start date of the update for a node
	NodeUpdateStartDate *time.Time

	// The update status of the node
	NodeUpdateStatus NodeUpdateStatus

	// The date when the NodeUpdateStatus was last modified
	NodeUpdateStatusModifiedDate *time.Time

	noSmithyDocumentSerde
}

// The status of the service update on the node group
type NodeGroupUpdateStatus struct {

	// The ID of the node group
	NodeGroupId *string

	// The status of the service update on the node group member
	NodeGroupMemberUpdateStatus []NodeGroupMemberUpdateStatus

	noSmithyDocumentSerde
}

// Represents an individual cache node in a snapshot of a cluster.
type NodeSnapshot struct {

	// A unique identifier for the source cluster.
	CacheClusterId *string

	// The date and time when the cache node was created in the source cluster.
	CacheNodeCreateTime *time.Time

	// The cache node identifier for the node in the source cluster.
	CacheNodeId *string

	// The size of the cache on the source cache node.
	CacheSize *string

	// The configuration for the source node group (shard).
	NodeGroupConfiguration *NodeGroupConfiguration

	// A unique identifier for the source node group (shard).
	NodeGroupId *string

	// The date and time when the source node's metadata and cache data set was
	// obtained for the snapshot.
	SnapshotCreateTime *time.Time

	noSmithyDocumentSerde
}

// Describes a notification topic and its status. Notification topics are used for
// publishing ElastiCache events to subscribers using Amazon Simple Notification
// Service (SNS).
type NotificationConfiguration struct {

	// The Amazon Resource Name (ARN) that identifies the topic.
	TopicArn *string

	// The current state of the topic.
	TopicStatus *string

	noSmithyDocumentSerde
}

// Describes an individual setting that controls some aspect of ElastiCache
// behavior.
type Parameter struct {

	// The valid range of values for the parameter.
	AllowedValues *string

	// Indicates whether a change to the parameter is applied immediately or requires
	// a reboot for the change to be applied. You can force a reboot or wait until the
	// next maintenance window's reboot. For more information, see Rebooting a Cluster (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html)
	// .
	ChangeType ChangeType

	// The valid data type for the parameter.
	DataType *string

	// A description of the parameter.
	Description *string

	// Indicates whether ( true ) or not ( false ) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool

	// The earliest cache engine version to which the parameter can apply.
	MinimumEngineVersion *string

	// The name of the parameter.
	ParameterName *string

	// The value of the parameter.
	ParameterValue *string

	// The source of the parameter.
	Source *string

	noSmithyDocumentSerde
}

// Describes a name-value pair that is used to update the value of a parameter.
type ParameterNameValue struct {

	// The name of the parameter.
	ParameterName *string

	// The value of the parameter.
	ParameterValue *string

	noSmithyDocumentSerde
}

// The log delivery configurations being modified
type PendingLogDeliveryConfiguration struct {

	// Configuration details of either a CloudWatch Logs destination or Kinesis Data
	// Firehose destination.
	DestinationDetails *DestinationDetails

	// Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.
	DestinationType DestinationType

	// Returns the log format, either JSON or TEXT
	LogFormat LogFormat

	// Refers to slow-log (https://redis.io/commands/slowlog) or engine-log..
	LogType LogType

	noSmithyDocumentSerde
}

// A group of settings that are applied to the cluster in the future, or that are
// currently being applied.
type PendingModifiedValues struct {

	// The auth token status
	AuthTokenStatus AuthTokenUpdateStatus

	// A list of cache node IDs that are being removed (or will be removed) from the
	// cluster. A node ID is a 4-digit numeric identifier (0001, 0002, etc.).
	CacheNodeIdsToRemove []string

	// The cache node type that this cluster or replication group is scaled to.
	CacheNodeType *string

	// The new cache engine version that the cluster runs.
	EngineVersion *string

	// The log delivery configurations being modified
	LogDeliveryConfigurations []PendingLogDeliveryConfiguration

	// The new number of cache nodes for the cluster. For clusters running Redis, this
	// value must be 1. For clusters running Memcached, this value must be between 1
	// and 40.
	NumCacheNodes *int32

	// A flag that enables in-transit encryption when set to true.
	TransitEncryptionEnabled *bool

	// A setting that allows you to migrate your clients to use in-transit encryption,
	// with no downtime.
	TransitEncryptionMode TransitEncryptionMode

	noSmithyDocumentSerde
}

// Update action that has been processed for the corresponding apply/stop request
type ProcessedUpdateAction struct {

	// The ID of the cache cluster
	CacheClusterId *string

	// The ID of the replication group
	ReplicationGroupId *string

	// The unique ID of the service update
	ServiceUpdateName *string

	// The status of the update action on the Redis cluster
	UpdateActionStatus UpdateActionStatus

	noSmithyDocumentSerde
}

// Contains the specific price and frequency of a recurring charges for a reserved
// cache node, or for a reserved cache node offering.
type RecurringCharge struct {

	// The monetary amount of the recurring charge.
	RecurringChargeAmount *float64

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string

	noSmithyDocumentSerde
}

// A list of the replication groups
type RegionalConfiguration struct {

	// The name of the secondary cluster
	//
	// This member is required.
	ReplicationGroupId *string

	// The Amazon region where the cluster is stored
	//
	// This member is required.
	ReplicationGroupRegion *string

	// A list of PreferredAvailabilityZones objects that specifies the configuration
	// of a node group in the resharded cluster.
	//
	// This member is required.
	ReshardingConfiguration []ReshardingConfiguration

	noSmithyDocumentSerde
}

// Contains all of the attributes of a specific Redis replication group.
type ReplicationGroup struct {

	// The ARN (Amazon Resource Name) of the replication group.
	ARN *string

	// A flag that enables encryption at-rest when set to true . You cannot modify the
	// value of AtRestEncryptionEnabled after the cluster is created. To enable
	// encryption at-rest on a cluster you must set AtRestEncryptionEnabled to true
	// when you create a cluster. Required: Only available when creating a replication
	// group in an Amazon VPC using redis version 3.2.6 , 4.x or later. Default: false
	AtRestEncryptionEnabled *bool

	// A flag that enables using an AuthToken (password) when issuing Redis commands.
	// Default: false
	AuthTokenEnabled *bool

	// The date the auth token was last modified
	AuthTokenLastModifiedDate *time.Time

	// If you are running Redis engine version 6.0 or later, set this parameter to yes
	// if you want to opt-in to the next auto minor version upgrade campaign. This
	// parameter is disabled for previous versions.
	AutoMinorVersionUpgrade *bool

	// Indicates the status of automatic failover for this Redis replication group.
	AutomaticFailover AutomaticFailoverStatus

	// The name of the compute and memory capacity node type for each node in the
	// replication group.
	CacheNodeType *string

	// A flag indicating whether or not this replication group is cluster enabled;
	// i.e., whether its data can be partitioned across multiple shards (API/CLI: node
	// groups). Valid values: true | false
	ClusterEnabled *bool

	// Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must
	// first set the cluster mode to Compatible. Compatible mode allows your Redis
	// clients to connect using both cluster mode enabled and cluster mode disabled.
	// After you migrate all Redis clients to use cluster mode enabled, you can then
	// complete cluster mode configuration and set the cluster mode to Enabled.
	ClusterMode ClusterMode

	// The configuration endpoint for this replication group. Use the configuration
	// endpoint to connect to this replication group.
	ConfigurationEndpoint *Endpoint

	// Enables data tiering. Data tiering is only supported for replication groups
	// using the r6gd node type. This parameter must be set to true when using r6gd
	// nodes. For more information, see Data tiering (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html)
	// .
	DataTiering DataTieringStatus

	// The user supplied description of the replication group.
	Description *string

	// The name of the Global datastore and role of this replication group in the
	// Global datastore.
	GlobalReplicationGroupInfo *GlobalReplicationGroupInfo

	// The network type you choose when modifying a cluster, either ipv4 | ipv6 . IPv6
	// is supported for workloads using Redis engine version 6.2 onward or Memcached
	// engine version 1.6.6 on all instances built on the Nitro system (http://aws.amazon.com/ec2/nitro/)
	// .
	IpDiscovery IpDiscovery

	// The ID of the KMS key used to encrypt the disk in the cluster.
	KmsKeyId *string

	// Returns the destination, format and type of the logs.
	LogDeliveryConfigurations []LogDeliveryConfiguration

	// The names of all the cache clusters that are part of this replication group.
	MemberClusters []string

	// The outpost ARNs of the replication group's member clusters.
	MemberClustersOutpostArns []string

	// A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For
	// more information, see Minimizing Downtime: Multi-AZ (http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html)
	MultiAZ MultiAZStatus

	// Must be either ipv4 | ipv6 | dual_stack . IPv6 is supported for workloads using
	// Redis engine version 6.2 onward or Memcached engine version 1.6.6 on all
	// instances built on the Nitro system (http://aws.amazon.com/ec2/nitro/) .
	NetworkType NetworkType

	// A list of node groups in this replication group. For Redis (cluster mode
	// disabled) replication groups, this is a single-element list. For Redis (cluster
	// mode enabled) replication groups, the list contains an entry for each node group
	// (shard).
	NodeGroups []NodeGroup

	// A group of settings to be applied to the replication group, either immediately
	// or during the next maintenance window.
	PendingModifiedValues *ReplicationGroupPendingModifiedValues

	// The date and time when the cluster was created.
	ReplicationGroupCreateTime *time.Time

	// The identifier for the replication group.
	ReplicationGroupId *string

	// The number of days for which ElastiCache retains automatic cluster snapshots
	// before deleting them. For example, if you set SnapshotRetentionLimit to 5, a
	// snapshot that was taken today is retained for 5 days before being deleted. If
	// the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.
	SnapshotRetentionLimit *int32

	// The daily time range (in UTC) during which ElastiCache begins taking a daily
	// snapshot of your node group (shard). Example: 05:00-09:00 If you do not specify
	// this parameter, ElastiCache automatically chooses an appropriate time range.
	// This parameter is only valid if the Engine parameter is redis .
	SnapshotWindow *string

	// The cluster ID that is used as the daily snapshot source for the replication
	// group.
	SnapshottingClusterId *string

	// The current state of this replication group - creating , available , modifying ,
	// deleting , create-failed , snapshotting .
	Status *string

	// A flag that enables in-transit encryption when set to true . Required: Only
	// available when creating a replication group in an Amazon VPC using redis version
	// 3.2.6 , 4.x or later. Default: false
	TransitEncryptionEnabled *bool

	// A setting that allows you to migrate your clients to use in-transit encryption,
	// with no downtime.
	TransitEncryptionMode TransitEncryptionMode

	// The ID of the user group associated to the replication group.
	UserGroupIds []string

	noSmithyDocumentSerde
}

// The settings to be applied to the Redis replication group, either immediately
// or during the next maintenance window.
type ReplicationGroupPendingModifiedValues struct {

	// The auth token status
	AuthTokenStatus AuthTokenUpdateStatus

	// Indicates the status of automatic failover for this Redis replication group.
	AutomaticFailoverStatus PendingAutomaticFailoverStatus

	// Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must
	// first set the cluster mode to Compatible. Compatible mode allows your Redis
	// clients to connect using both cluster mode enabled and cluster mode disabled.
	// After you migrate all Redis clients to use cluster mode enabled, you can then
	// complete cluster mode configuration and set the cluster mode to Enabled.
	ClusterMode ClusterMode

	// The log delivery configurations being modified
	LogDeliveryConfigurations []PendingLogDeliveryConfiguration

	// The primary cluster ID that is applied immediately (if --apply-immediately was
	// specified), or during the next maintenance window.
	PrimaryClusterId *string

	// The status of an online resharding operation.
	Resharding *ReshardingStatus

	// A flag that enables in-transit encryption when set to true.
	TransitEncryptionEnabled *bool

	// A setting that allows you to migrate your clients to use in-transit encryption,
	// with no downtime.
	TransitEncryptionMode TransitEncryptionMode

	// The user group being modified.
	UserGroups *UserGroupsUpdateStatus

	noSmithyDocumentSerde
}

// Represents the output of a PurchaseReservedCacheNodesOffering operation.
type ReservedCacheNode struct {

	// The number of cache nodes that have been reserved.
	CacheNodeCount *int32

	// The cache node type for the reserved cache nodes. The following node types are
	// supported by ElastiCache. Generally speaking, the current generation types
	// provide more memory and computational power at lower cost when compared to their
	// equivalent previous generation counterparts.
	//   - General purpose:
	//   - Current generation: M7g node types: cache.m7g.large , cache.m7g.xlarge ,
	//   cache.m7g.2xlarge , cache.m7g.4xlarge , cache.m7g.8xlarge , cache.m7g.12xlarge
	//   , cache.m7g.16xlarge For region availability, see Supported Node Types (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
	//   M6g node types (available only for Redis engine version 5.0.6 onward and for
	//   Memcached engine version 1.5.16 onward): cache.m6g.large , cache.m6g.xlarge ,
	//   cache.m6g.2xlarge , cache.m6g.4xlarge , cache.m6g.8xlarge , cache.m6g.12xlarge
	//   , cache.m6g.16xlarge M5 node types: cache.m5.large , cache.m5.xlarge ,
	//   cache.m5.2xlarge , cache.m5.4xlarge , cache.m5.12xlarge , cache.m5.24xlarge M4
	//   node types: cache.m4.large , cache.m4.xlarge , cache.m4.2xlarge ,
	//   cache.m4.4xlarge , cache.m4.10xlarge T4g node types (available only for Redis
	//   engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
	//   cache.t4g.micro , cache.t4g.small , cache.t4g.medium T3 node types:
	//   cache.t3.micro , cache.t3.small , cache.t3.medium T2 node types:
	//   cache.t2.micro , cache.t2.small , cache.t2.medium
	//   - Previous generation: (not recommended. Existing clusters are still
	//   supported but creation of new clusters is not supported for these types.) T1
	//   node types: cache.t1.micro M1 node types: cache.m1.small , cache.m1.medium ,
	//   cache.m1.large , cache.m1.xlarge M3 node types: cache.m3.medium ,
	//   cache.m3.large , cache.m3.xlarge , cache.m3.2xlarge
	//   - Compute optimized:
	//   - Previous generation: (not recommended. Existing clusters are still
	//   supported but creation of new clusters is not supported for these types.) C1
	//   node types: cache.c1.xlarge
	//   - Memory optimized:
	//   - Current generation: R7g node types: cache.r7g.large , cache.r7g.xlarge ,
	//   cache.r7g.2xlarge , cache.r7g.4xlarge , cache.r7g.8xlarge , cache.r7g.12xlarge
	//   , cache.r7g.16xlarge For region availability, see Supported Node Types (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
	//   R6g node types (available only for Redis engine version 5.0.6 onward and for
	//   Memcached engine version 1.5.16 onward): cache.r6g.large , cache.r6g.xlarge ,
	//   cache.r6g.2xlarge , cache.r6g.4xlarge , cache.r6g.8xlarge , cache.r6g.12xlarge
	//   , cache.r6g.16xlarge R5 node types: cache.r5.large , cache.r5.xlarge ,
	//   cache.r5.2xlarge , cache.r5.4xlarge , cache.r5.12xlarge , cache.r5.24xlarge R4
	//   node types: cache.r4.large , cache.r4.xlarge , cache.r4.2xlarge ,
	//   cache.r4.4xlarge , cache.r4.8xlarge , cache.r4.16xlarge
	//   - Previous generation: (not recommended. Existing clusters are still
	//   supported but creation of new clusters is not supported for these types.) M2
	//   node types: cache.m2.xlarge , cache.m2.2xlarge , cache.m2.4xlarge R3 node
	//   types: cache.r3.large , cache.r3.xlarge , cache.r3.2xlarge ,
	//
	// cache.r3.4xlarge , cache.r3.8xlarge
	// Additional node type info
	//   - All current generation instance types are created in Amazon VPC by default.
	//   - Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//   - Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//   - Redis configuration variables appendonly and appendfsync are not supported
	//   on Redis version 2.8.22 and later.
	CacheNodeType *string

	// The duration of the reservation in seconds.
	Duration *int32

	// The fixed price charged for this reserved cache node.
	FixedPrice *float64

	// The offering type of this reserved cache node.
	OfferingType *string

	// The description of the reserved cache node.
	ProductDescription *string

	// The recurring price charged to run this reserved cache node.
	RecurringCharges []RecurringCharge

	// The Amazon Resource Name (ARN) of the reserved cache node. Example:
	// arn:aws:elasticache:us-east-1:123456789012:reserved-instance:ri-2017-03-27-08-33-25-582
	ReservationARN *string

	// The unique identifier for the reservation.
	ReservedCacheNodeId *string

	// The offering identifier.
	ReservedCacheNodesOfferingId *string

	// The time the reservation started.
	StartTime *time.Time

	// The state of the reserved cache node.
	State *string

	// The hourly price charged for this reserved cache node.
	UsagePrice *float64

	noSmithyDocumentSerde
}

// Describes all of the attributes of a reserved cache node offering.
type ReservedCacheNodesOffering struct {

	// The cache node type for the reserved cache node. The following node types are
	// supported by ElastiCache. Generally speaking, the current generation types
	// provide more memory and computational power at lower cost when compared to their
	// equivalent previous generation counterparts.
	//   - General purpose:
	//   - Current generation: M7g node types: cache.m7g.large , cache.m7g.xlarge ,
	//   cache.m7g.2xlarge , cache.m7g.4xlarge , cache.m7g.8xlarge , cache.m7g.12xlarge
	//   , cache.m7g.16xlarge For region availability, see Supported Node Types (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
	//   M6g node types (available only for Redis engine version 5.0.6 onward and for
	//   Memcached engine version 1.5.16 onward): cache.m6g.large , cache.m6g.xlarge ,
	//   cache.m6g.2xlarge , cache.m6g.4xlarge , cache.m6g.8xlarge , cache.m6g.12xlarge
	//   , cache.m6g.16xlarge M5 node types: cache.m5.large , cache.m5.xlarge ,
	//   cache.m5.2xlarge , cache.m5.4xlarge , cache.m5.12xlarge , cache.m5.24xlarge M4
	//   node types: cache.m4.large , cache.m4.xlarge , cache.m4.2xlarge ,
	//   cache.m4.4xlarge , cache.m4.10xlarge T4g node types (available only for Redis
	//   engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
	//   cache.t4g.micro , cache.t4g.small , cache.t4g.medium T3 node types:
	//   cache.t3.micro , cache.t3.small , cache.t3.medium T2 node types:
	//   cache.t2.micro , cache.t2.small , cache.t2.medium
	//   - Previous generation: (not recommended. Existing clusters are still
	//   supported but creation of new clusters is not supported for these types.) T1
	//   node types: cache.t1.micro M1 node types: cache.m1.small , cache.m1.medium ,
	//   cache.m1.large , cache.m1.xlarge M3 node types: cache.m3.medium ,
	//   cache.m3.large , cache.m3.xlarge , cache.m3.2xlarge
	//   - Compute optimized:
	//   - Previous generation: (not recommended. Existing clusters are still
	//   supported but creation of new clusters is not supported for these types.) C1
	//   node types: cache.c1.xlarge
	//   - Memory optimized:
	//   - Current generation: R7g node types: cache.r7g.large , cache.r7g.xlarge ,
	//   cache.r7g.2xlarge , cache.r7g.4xlarge , cache.r7g.8xlarge , cache.r7g.12xlarge
	//   , cache.r7g.16xlarge For region availability, see Supported Node Types (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
	//   R6g node types (available only for Redis engine version 5.0.6 onward and for
	//   Memcached engine version 1.5.16 onward): cache.r6g.large , cache.r6g.xlarge ,
	//   cache.r6g.2xlarge , cache.r6g.4xlarge , cache.r6g.8xlarge , cache.r6g.12xlarge
	//   , cache.r6g.16xlarge R5 node types: cache.r5.large , cache.r5.xlarge ,
	//   cache.r5.2xlarge , cache.r5.4xlarge , cache.r5.12xlarge , cache.r5.24xlarge R4
	//   node types: cache.r4.large , cache.r4.xlarge , cache.r4.2xlarge ,
	//   cache.r4.4xlarge , cache.r4.8xlarge , cache.r4.16xlarge
	//   - Previous generation: (not recommended. Existing clusters are still
	//   supported but creation of new clusters is not supported for these types.) M2
	//   node types: cache.m2.xlarge , cache.m2.2xlarge , cache.m2.4xlarge R3 node
	//   types: cache.r3.large , cache.r3.xlarge , cache.r3.2xlarge ,
	//
	// cache.r3.4xlarge , cache.r3.8xlarge
	// Additional node type info
	//   - All current generation instance types are created in Amazon VPC by default.
	//   - Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//   - Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//   - Redis configuration variables appendonly and appendfsync are not supported
	//   on Redis version 2.8.22 and later.
	CacheNodeType *string

	// The duration of the offering. in seconds.
	Duration *int32

	// The fixed price charged for this offering.
	FixedPrice *float64

	// The offering type.
	OfferingType *string

	// The cache engine used by the offering.
	ProductDescription *string

	// The recurring price charged to run this reserved cache node.
	RecurringCharges []RecurringCharge

	// A unique identifier for the reserved cache node offering.
	ReservedCacheNodesOfferingId *string

	// The hourly price charged for this offering.
	UsagePrice *float64

	noSmithyDocumentSerde
}

// A list of PreferredAvailabilityZones objects that specifies the configuration
// of a node group in the resharded cluster.
type ReshardingConfiguration struct {

	// Either the ElastiCache for Redis supplied 4-digit id or a user supplied id for
	// the node group these configuration values apply to.
	NodeGroupId *string

	// A list of preferred availability zones for the nodes in this cluster.
	PreferredAvailabilityZones []string

	noSmithyDocumentSerde
}

// The status of an online resharding operation.
type ReshardingStatus struct {

	// Represents the progress of an online resharding operation.
	SlotMigration *SlotMigration

	noSmithyDocumentSerde
}

// Represents a single cache security group and its status.
type SecurityGroupMembership struct {

	// The identifier of the cache security group.
	SecurityGroupId *string

	// The status of the cache security group membership. The status changes whenever
	// a cache security group is modified, or when the cache security groups assigned
	// to a cluster are modified.
	Status *string

	noSmithyDocumentSerde
}

// The resource representing a serverless cache.
type ServerlessCache struct {

	// The Amazon Resource Name (ARN) of the serverless cache.
	ARN *string

	// The cache usage limit for the serverless cache.
	CacheUsageLimits *CacheUsageLimits

	// When the serverless cache was created.
	CreateTime *time.Time

	// The daily time that a cache snapshot will be created. Default is NULL, i.e.
	// snapshots will not be created at a specific time on a daily basis. Available for
	// Redis only.
	DailySnapshotTime *string

	// A description of the serverless cache.
	Description *string

	// Represents the information required for client programs to connect to a cache
	// node. This value is read-only.
	Endpoint *Endpoint

	// The engine the serverless cache is compatible with.
	Engine *string

	// The name and version number of the engine the serverless cache is compatible
	// with.
	FullEngineVersion *string

	// The ID of the Amazon Web Services Key Management Service (KMS) key that is used
	// to encrypt data at rest in the serverless cache.
	KmsKeyId *string

	// The version number of the engine the serverless cache is compatible with.
	MajorEngineVersion *string

	// Represents the information required for client programs to connect to a cache
	// node. This value is read-only.
	ReaderEndpoint *Endpoint

	// The IDs of the EC2 security groups associated with the serverless cache.
	SecurityGroupIds []string

	// The unique identifier of the serverless cache.
	ServerlessCacheName *string

	// The current setting for the number of serverless cache snapshots the system
	// will retain. Available for Redis only.
	SnapshotRetentionLimit *int32

	// The current status of the serverless cache. The allowed values are CREATING,
	// AVAILABLE, DELETING, CREATE-FAILED and MODIFYING.
	Status *string

	// If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will
	// select 2 default subnets across AZs in your VPC. For all other Regions, if no
	// subnet IDs are given then ElastiCache will select 3 default subnets across AZs
	// in your default VPC.
	SubnetIds []string

	// The identifier of the user group associated with the serverless cache.
	// Available for Redis only. Default is NULL.
	UserGroupId *string

	noSmithyDocumentSerde
}

// The configuration settings for a specific serverless cache.
type ServerlessCacheConfiguration struct {

	// The engine that the serverless cache is configured with.
	Engine *string

	// The engine version number that the serverless cache is configured with.
	MajorEngineVersion *string

	// The identifier of a serverless cache.
	ServerlessCacheName *string

	noSmithyDocumentSerde
}

// The resource representing a serverless cache snapshot. Available for Redis only.
type ServerlessCacheSnapshot struct {

	// The Amazon Resource Name (ARN) of a serverless cache snapshot. Available for
	// Redis only.
	ARN *string

	// The total size of a serverless cache snapshot, in bytes. Available for Redis
	// only.
	BytesUsedForCache *string

	// The date and time that the source serverless cache's metadata and cache data
	// set was obtained for the snapshot. Available for Redis only.
	CreateTime *time.Time

	// The time that the serverless cache snapshot will expire. Available for Redis
	// only.
	ExpiryTime *time.Time

	// The ID of the Amazon Web Services Key Management Service (KMS) key of a
	// serverless cache snapshot. Available for Redis only.
	KmsKeyId *string

	// The configuration of the serverless cache, at the time the snapshot was taken.
	// Available for Redis only.
	ServerlessCacheConfiguration *ServerlessCacheConfiguration

	// The identifier of a serverless cache snapshot. Available for Redis only.
	ServerlessCacheSnapshotName *string

	// The type of snapshot of serverless cache. Available for Redis only.
	SnapshotType *string

	// The current status of the serverless cache. Available for Redis only.
	Status *string

	noSmithyDocumentSerde
}

// An update that you can apply to your Redis clusters.
type ServiceUpdate struct {

	// Indicates whether the service update will be automatically applied once the
	// recommended apply-by date has expired.
	AutoUpdateAfterRecommendedApplyByDate *bool

	// The Elasticache engine to which the update applies. Either Redis or Memcached
	Engine *string

	// The Elasticache engine version to which the update applies. Either Redis or
	// Memcached engine version
	EngineVersion *string

	// The estimated length of time the service update will take
	EstimatedUpdateTime *string

	// Provides details of the service update
	ServiceUpdateDescription *string

	// The date after which the service update is no longer available
	ServiceUpdateEndDate *time.Time

	// The unique ID of the service update
	ServiceUpdateName *string

	// The recommendend date to apply the service update in order to ensure
	// compliance. For information on compliance, see Self-Service Security Updates
	// for Compliance (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service)
	// .
	ServiceUpdateRecommendedApplyByDate *time.Time

	// The date when the service update is initially available
	ServiceUpdateReleaseDate *time.Time

	// The severity of the service update
	ServiceUpdateSeverity ServiceUpdateSeverity

	// The status of the service update
	ServiceUpdateStatus ServiceUpdateStatus

	// Reflects the nature of the service update
	ServiceUpdateType ServiceUpdateType

	noSmithyDocumentSerde
}

// Represents the progress of an online resharding operation.
type SlotMigration struct {

	// The percentage of the slot migration that is complete.
	ProgressPercentage *float64

	noSmithyDocumentSerde
}

// Represents a copy of an entire Redis cluster as of the time when the snapshot
// was taken.
type Snapshot struct {

	// The ARN (Amazon Resource Name) of the snapshot.
	ARN *string

	//  If you are running Redis engine version 6.0 or later, set this parameter to
	// yes if you want to opt-in to the next auto minor version upgrade campaign. This
	// parameter is disabled for previous versions.
	AutoMinorVersionUpgrade *bool

	// Indicates the status of automatic failover for the source Redis replication
	// group.
	AutomaticFailover AutomaticFailoverStatus

	// The date and time when the source cluster was created.
	CacheClusterCreateTime *time.Time

	// The user-supplied identifier of the source cluster.
	CacheClusterId *string

	// The name of the compute and memory capacity node type for the source cluster.
	// The following node types are supported by ElastiCache. Generally speaking, the
	// current generation types provide more memory and computational power at lower
	// cost when compared to their equivalent previous generation counterparts.
	//   - General purpose:
	//   - Current generation: M7g node types: cache.m7g.large , cache.m7g.xlarge ,
	//   cache.m7g.2xlarge , cache.m7g.4xlarge , cache.m7g.8xlarge , cache.m7g.12xlarge
	//   , cache.m7g.16xlarge For region availability, see Supported Node Types (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
	//   M6g node types (available only for Redis engine version 5.0.6 onward and for
	//   Memcached engine version 1.5.16 onward): cache.m6g.large , cache.m6g.xlarge ,
	//   cache.m6g.2xlarge , cache.m6g.4xlarge , cache.m6g.8xlarge , cache.m6g.12xlarge
	//   , cache.m6g.16xlarge M5 node types: cache.m5.large , cache.m5.xlarge ,
	//   cache.m5.2xlarge , cache.m5.4xlarge , cache.m5.12xlarge , cache.m5.24xlarge M4
	//   node types: cache.m4.large , cache.m4.xlarge , cache.m4.2xlarge ,
	//   cache.m4.4xlarge , cache.m4.10xlarge T4g node types (available only for Redis
	//   engine version 5.0.6 onward and Memcached engine version 1.5.16 onward):
	//   cache.t4g.micro , cache.t4g.small , cache.t4g.medium T3 node types:
	//   cache.t3.micro , cache.t3.small , cache.t3.medium T2 node types:
	//   cache.t2.micro , cache.t2.small , cache.t2.medium
	//   - Previous generation: (not recommended. Existing clusters are still
	//   supported but creation of new clusters is not supported for these types.) T1
	//   node types: cache.t1.micro M1 node types: cache.m1.small , cache.m1.medium ,
	//   cache.m1.large , cache.m1.xlarge M3 node types: cache.m3.medium ,
	//   cache.m3.large , cache.m3.xlarge , cache.m3.2xlarge
	//   - Compute optimized:
	//   - Previous generation: (not recommended. Existing clusters are still
	//   supported but creation of new clusters is not supported for these types.) C1
	//   node types: cache.c1.xlarge
	//   - Memory optimized:
	//   - Current generation: R7g node types: cache.r7g.large , cache.r7g.xlarge ,
	//   cache.r7g.2xlarge , cache.r7g.4xlarge , cache.r7g.8xlarge , cache.r7g.12xlarge
	//   , cache.r7g.16xlarge For region availability, see Supported Node Types (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion)
	//   R6g node types (available only for Redis engine version 5.0.6 onward and for
	//   Memcached engine version 1.5.16 onward): cache.r6g.large , cache.r6g.xlarge ,
	//   cache.r6g.2xlarge , cache.r6g.4xlarge , cache.r6g.8xlarge , cache.r6g.12xlarge
	//   , cache.r6g.16xlarge R5 node types: cache.r5.large , cache.r5.xlarge ,
	//   cache.r5.2xlarge , cache.r5.4xlarge , cache.r5.12xlarge , cache.r5.24xlarge R4
	//   node types: cache.r4.large , cache.r4.xlarge , cache.r4.2xlarge ,
	//   cache.r4.4xlarge , cache.r4.8xlarge , cache.r4.16xlarge
	//   - Previous generation: (not recommended. Existing clusters are still
	//   supported but creation of new clusters is not supported for these types.) M2
	//   node types: cache.m2.xlarge , cache.m2.2xlarge , cache.m2.4xlarge R3 node
	//   types: cache.r3.large , cache.r3.xlarge , cache.r3.2xlarge ,
	//
	// cache.r3.4xlarge , cache.r3.8xlarge
	// Additional node type info
	//   - All current generation instance types are created in Amazon VPC by default.
	//   - Redis append-only files (AOF) are not supported for T1 or T2 instances.
	//   - Redis Multi-AZ with automatic failover is not supported on T1 instances.
	//   - Redis configuration variables appendonly and appendfsync are not supported
	//   on Redis version 2.8.22 and later.
	CacheNodeType *string

	// The cache parameter group that is associated with the source cluster.
	CacheParameterGroupName *string

	// The name of the cache subnet group associated with the source cluster.
	CacheSubnetGroupName *string

	// Enables data tiering. Data tiering is only supported for replication groups
	// using the r6gd node type. This parameter must be set to true when using r6gd
	// nodes. For more information, see Data tiering (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html)
	// .
	DataTiering DataTieringStatus

	// The name of the cache engine ( memcached or redis ) used by the source cluster.
	Engine *string

	// The version of the cache engine version that is used by the source cluster.
	EngineVersion *string

	// The ID of the KMS key used to encrypt the snapshot.
	KmsKeyId *string

	// A list of the cache nodes in the source cluster.
	NodeSnapshots []NodeSnapshot

	// The number of cache nodes in the source cluster. For clusters running Redis,
	// this value must be 1. For clusters running Memcached, this value must be between
	// 1 and 40.
	NumCacheNodes *int32

	// The number of node groups (shards) in this snapshot. When restoring from a
	// snapshot, the number of node groups (shards) in the snapshot and in the restored
	// replication group must be the same.
	NumNodeGroups *int32

	// The port number used by each cache nodes in the source cluster.
	Port *int32

	// The name of the Availability Zone in which the source cluster is located.
	PreferredAvailabilityZone *string

	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H
	// Clock UTC). The minimum maintenance window is a 60 minute period. Valid values
	// for ddd are:
	//   - sun
	//   - mon
	//   - tue
	//   - wed
	//   - thu
	//   - fri
	//   - sat
	// Example: sun:23:00-mon:01:30
	PreferredMaintenanceWindow *string

	// The ARN (Amazon Resource Name) of the preferred outpost.
	PreferredOutpostArn *string

	// A description of the source replication group.
	ReplicationGroupDescription *string

	// The unique identifier of the source replication group.
	ReplicationGroupId *string

	// The name of a snapshot. For an automatic snapshot, the name is
	// system-generated. For a manual snapshot, this is the user-provided name.
	SnapshotName *string

	// For an automatic snapshot, the number of days for which ElastiCache retains the
	// snapshot before deleting it. For manual snapshots, this field reflects the
	// SnapshotRetentionLimit for the source cluster when the snapshot was created.
	// This field is otherwise ignored: Manual snapshots do not expire, and can only be
	// deleted using the DeleteSnapshot operation. Important If the value of
	// SnapshotRetentionLimit is set to zero (0), backups are turned off.
	SnapshotRetentionLimit *int32

	// Indicates whether the snapshot is from an automatic backup ( automated ) or was
	// created manually ( manual ).
	SnapshotSource *string

	// The status of the snapshot. Valid values: creating | available | restoring |
	// copying | deleting .
	SnapshotStatus *string

	// The daily time range during which ElastiCache takes daily snapshots of the
	// source cluster.
	SnapshotWindow *string

	// The Amazon Resource Name (ARN) for the topic used by the source cluster for
	// publishing notifications.
	TopicArn *string

	// The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group
	// for the source cluster.
	VpcId *string

	noSmithyDocumentSerde
}

// Represents the subnet associated with a cluster. This parameter refers to
// subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used with
// ElastiCache.
type Subnet struct {

	// The Availability Zone associated with the subnet.
	SubnetAvailabilityZone *AvailabilityZone

	// The unique identifier for the subnet.
	SubnetIdentifier *string

	// The outpost ARN of the subnet.
	SubnetOutpost *SubnetOutpost

	// Either ipv4 | ipv6 | dual_stack . IPv6 is supported for workloads using Redis
	// engine version 6.2 onward or Memcached engine version 1.6.6 on all instances
	// built on the Nitro system (http://aws.amazon.com/ec2/nitro/) .
	SupportedNetworkTypes []NetworkType

	noSmithyDocumentSerde
}

// The ID of the outpost subnet.
type SubnetOutpost struct {

	// The outpost ARN of the subnet.
	SubnetOutpostArn *string

	noSmithyDocumentSerde
}

// A tag that can be added to an ElastiCache cluster or replication group. Tags
// are composed of a Key/Value pair. You can use tags to categorize and track all
// your ElastiCache resources, with the exception of global replication group. When
// you add or remove tags on replication groups, those actions will be replicated
// to all nodes in the replication group. A tag with a null Value is permitted.
type Tag struct {

	// The key for the tag. May not be null.
	Key *string

	// The tag's value. May be null.
	Value *string

	noSmithyDocumentSerde
}

// Filters update actions from the service updates that are in available status
// during the time range.
type TimeRangeFilter struct {

	// The end time of the time range filter
	EndTime *time.Time

	// The start time of the time range filter
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Update action that has failed to be processed for the corresponding apply/stop
// request
type UnprocessedUpdateAction struct {

	// The ID of the cache cluster
	CacheClusterId *string

	// The error message that describes the reason the request was not processed
	ErrorMessage *string

	// The error type for requests that are not processed
	ErrorType *string

	// The replication group ID
	ReplicationGroupId *string

	// The unique ID of the service update
	ServiceUpdateName *string

	noSmithyDocumentSerde
}

// The status of the service update for a specific replication group
type UpdateAction struct {

	// The ID of the cache cluster
	CacheClusterId *string

	// The status of the service update on the cache node
	CacheNodeUpdateStatus []CacheNodeUpdateStatus

	// The Elasticache engine to which the update applies. Either Redis or Memcached
	Engine *string

	// The estimated length of time for the update to complete
	EstimatedUpdateTime *string

	// The status of the service update on the node group
	NodeGroupUpdateStatus []NodeGroupUpdateStatus

	// The progress of the service update on the replication group
	NodesUpdated *string

	// The ID of the replication group
	ReplicationGroupId *string

	// The unique ID of the service update
	ServiceUpdateName *string

	// The recommended date to apply the service update to ensure compliance. For
	// information on compliance, see Self-Service Security Updates for Compliance (https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service)
	// .
	ServiceUpdateRecommendedApplyByDate *time.Time

	// The date the update is first available
	ServiceUpdateReleaseDate *time.Time

	// The severity of the service update
	ServiceUpdateSeverity ServiceUpdateSeverity

	// The status of the service update
	ServiceUpdateStatus ServiceUpdateStatus

	// Reflects the nature of the service update
	ServiceUpdateType ServiceUpdateType

	// If yes, all nodes in the replication group have been updated by the recommended
	// apply-by date. If no, at least one node in the replication group have not been
	// updated by the recommended apply-by date. If N/A, the replication group was
	// created after the recommended apply-by date.
	SlaMet SlaMet

	// The date that the service update is available to a replication group
	UpdateActionAvailableDate *time.Time

	// The status of the update action
	UpdateActionStatus UpdateActionStatus

	// The date when the UpdateActionStatus was last modified
	UpdateActionStatusModifiedDate *time.Time

	noSmithyDocumentSerde
}

type User struct {

	// The Amazon Resource Name (ARN) of the user.
	ARN *string

	// Access permissions string used for this user.
	AccessString *string

	// Denotes whether the user requires a password to authenticate.
	Authentication *Authentication

	// The current supported value is Redis.
	Engine *string

	// The minimum engine version required, which is Redis 6.0
	MinimumEngineVersion *string

	// Indicates the user status. Can be "active", "modifying" or "deleting".
	Status *string

	// Returns a list of the user group IDs the user belongs to.
	UserGroupIds []string

	// The ID of the user.
	UserId *string

	// The username of the user.
	UserName *string

	noSmithyDocumentSerde
}

type UserGroup struct {

	// The Amazon Resource Name (ARN) of the user group.
	ARN *string

	// The current supported value is Redis.
	Engine *string

	// The minimum engine version required, which is Redis 6.0
	MinimumEngineVersion *string

	// A list of updates being applied to the user group.
	PendingChanges *UserGroupPendingChanges

	// A list of replication groups that the user group can access.
	ReplicationGroups []string

	// Indicates which serverless caches the specified user group is associated with.
	// Available for Redis only.
	ServerlessCaches []string

	// Indicates user group status. Can be "creating", "active", "modifying",
	// "deleting".
	Status *string

	// The ID of the user group.
	UserGroupId *string

	// The list of user IDs that belong to the user group.
	UserIds []string

	noSmithyDocumentSerde
}

// Returns the updates being applied to the user group.
type UserGroupPendingChanges struct {

	// The list of user IDs to add.
	UserIdsToAdd []string

	// The list of user IDs to remove.
	UserIdsToRemove []string

	noSmithyDocumentSerde
}

// The status of the user group update.
type UserGroupsUpdateStatus struct {

	// The ID of the user group to add.
	UserGroupIdsToAdd []string

	// The ID of the user group to remove.
	UserGroupIdsToRemove []string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
