// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptographydata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Re-encrypt ciphertext using DUKPT, Symmetric and Asymmetric Data Encryption
// Keys. You can either generate an encryption key within Amazon Web Services
// Payment Cryptography by calling CreateKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html)
// or import your own encryption key by calling ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html)
// . The KeyArn for use with this operation must be in a compatible key state with
// KeyModesOfUse set to Encrypt . In asymmetric encryption, ciphertext is encrypted
// using public component (imported by calling ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html)
// ) of the asymmetric key pair created outside of Amazon Web Services Payment
// Cryptography. For symmetric and DUKPT encryption, Amazon Web Services Payment
// Cryptography supports TDES and AES algorithms. For asymmetric encryption,
// Amazon Web Services Payment Cryptography supports RSA . To encrypt using DUKPT,
// a DUKPT key must already exist within your account with KeyModesOfUse set to
// DeriveKey or a new DUKPT can be generated by calling CreateKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html)
// . For information about valid keys for this operation, see Understanding key
// attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// and Key types for specific data operations (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html)
// in the Amazon Web Services Payment Cryptography User Guide. Cross-account use:
// This operation can't be used across different Amazon Web Services accounts.
// Related operations:
//   - DecryptData
//   - EncryptData
//   - GetPublicCertificate (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetPublicKeyCertificate.html)
//   - ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html)
func (c *Client) ReEncryptData(ctx context.Context, params *ReEncryptDataInput, optFns ...func(*Options)) (*ReEncryptDataOutput, error) {
	if params == nil {
		params = &ReEncryptDataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ReEncryptData", params, optFns, c.addOperationReEncryptDataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ReEncryptDataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ReEncryptDataInput struct {

	// Ciphertext to be encrypted. The minimum allowed length is 16 bytes and maximum
	// allowed length is 4096 bytes.
	//
	// This member is required.
	CipherText *string

	// The attributes and values for incoming ciphertext.
	//
	// This member is required.
	IncomingEncryptionAttributes types.ReEncryptionAttributes

	// The keyARN of the encryption key of incoming ciphertext data.
	//
	// This member is required.
	IncomingKeyIdentifier *string

	// The attributes and values for outgoing ciphertext data after encryption by
	// Amazon Web Services Payment Cryptography.
	//
	// This member is required.
	OutgoingEncryptionAttributes types.ReEncryptionAttributes

	// The keyARN of the encryption key of outgoing ciphertext data after encryption
	// by Amazon Web Services Payment Cryptography.
	//
	// This member is required.
	OutgoingKeyIdentifier *string

	noSmithyDocumentSerde
}

type ReEncryptDataOutput struct {

	// The encrypted ciphertext.
	//
	// This member is required.
	CipherText *string

	// The keyARN (Amazon Resource Name) of the encryption key that Amazon Web
	// Services Payment Cryptography uses for plaintext encryption.
	//
	// This member is required.
	KeyArn *string

	// The key check value (KCV) of the encryption key. The KCV is used to check if
	// all parties holding a given key have the same key or to detect that a key has
	// changed. Amazon Web Services Payment Cryptography computes the KCV according to
	// the CMAC specification.
	//
	// This member is required.
	KeyCheckValue *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationReEncryptDataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpReEncryptData{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpReEncryptData{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ReEncryptData"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpReEncryptDataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opReEncryptData(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opReEncryptData(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ReEncryptData",
	}
}
