// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets information about an existing Amazon Q plugin.
func (c *Client) GetPlugin(ctx context.Context, params *GetPluginInput, optFns ...func(*Options)) (*GetPluginOutput, error) {
	if params == nil {
		params = &GetPluginInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetPlugin", params, optFns, c.addOperationGetPluginMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetPluginOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetPluginInput struct {

	// The identifier of the application which contains the plugin.
	//
	// This member is required.
	ApplicationId *string

	// The identifier of the plugin.
	//
	// This member is required.
	PluginId *string

	noSmithyDocumentSerde
}

type GetPluginOutput struct {

	// The identifier of the application which contains the plugin.
	ApplicationId *string

	// Authentication configuration information for an Amazon Q plugin.
	AuthConfiguration types.PluginAuthConfiguration

	// The timestamp for when the plugin was created.
	CreatedAt *time.Time

	// The name of the plugin.
	DisplayName *string

	// The Amazon Resource Name (ARN) of the role with permission to access resources
	// needed to create the plugin.
	PluginArn *string

	// The identifier of the plugin.
	PluginId *string

	// The source URL used for plugin configuration.
	ServerUrl *string

	// The current state of the plugin.
	State types.PluginState

	// The type of the plugin.
	Type types.PluginType

	// The timestamp for when the plugin was last updated.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetPluginMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetPlugin{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetPlugin{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetPlugin"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetPluginValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetPlugin(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetPlugin(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetPlugin",
	}
}
