// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Used to configure access permissions for a document.
type AccessConfiguration struct {

	// A list of AccessControlList objects.
	//
	// This member is required.
	AccessControls []AccessControl

	// Describes the member relation within the AccessControlList object.
	MemberRelation MemberRelation

	noSmithyDocumentSerde
}

// A list of principals. Each principal can be either a USER or a GROUP and can be
// designated document access permissions of either ALLOW or DENY .
type AccessControl struct {

	// Contains a list of principals, where a principal can be either a USER or a GROUP
	// . Each principal can be have the following type of document access: ALLOW or
	// DENY .
	//
	// This member is required.
	Principals []Principal

	// Describes the member relation within a principal list.
	MemberRelation MemberRelation

	noSmithyDocumentSerde
}

// Performs an Amazon Q plugin action during a non-streaming chat conversation.
type ActionExecution struct {

	// A mapping of field names to the field values in input that an end user provides
	// to Amazon Q requests to perform their plugin action.
	//
	// This member is required.
	Payload map[string]ActionExecutionPayloadField

	// A string used to retain information about the hierarchical contexts within an
	// action execution event payload.
	//
	// This member is required.
	PayloadFieldNameSeparator *string

	// The identifier of the plugin the action is attached to.
	//
	// This member is required.
	PluginId *string

	noSmithyDocumentSerde
}

// A user input field in an plugin action execution payload.
type ActionExecutionPayloadField struct {

	// The content of a user input field in an plugin action execution payload.
	//
	// This member is required.
	Value document.Interface

	noSmithyDocumentSerde
}

// An output event that Amazon Q returns to an user who wants to perform a plugin
// action during a non-streaming chat conversation. It contains information about
// the selected action with a list of possible user input fields, some
// pre-populated by Amazon Q.
type ActionReview struct {

	// Field values that an end user needs to provide to Amazon Q for Amazon Q to
	// perform the requested plugin action.
	Payload map[string]ActionReviewPayloadField

	// A string used to retain information about the hierarchical contexts within an
	// action review payload.
	PayloadFieldNameSeparator *string

	// The identifier of the plugin associated with the action review.
	PluginId *string

	// The type of plugin.
	PluginType PluginType

	noSmithyDocumentSerde
}

// A user input field in an plugin action review payload.
type ActionReviewPayloadField struct {

	// Information about the field values that an end user can use to provide to
	// Amazon Q for Amazon Q to perform the requested plugin action.
	AllowedValues []ActionReviewPayloadFieldAllowedValue

	// The name of the field.
	DisplayName *string

	// The display order of fields in a payload.
	DisplayOrder *int32

	// Information about whether the field is required.
	Required *bool

	// The type of field.
	Type ActionPayloadFieldType

	// The field value.
	Value document.Interface

	noSmithyDocumentSerde
}

// Information about the field values that an end user can use to provide to
// Amazon Q for Amazon Q to perform the requested plugin action.
type ActionReviewPayloadFieldAllowedValue struct {

	// The name of the field.
	DisplayValue document.Interface

	// The field value.
	Value document.Interface

	noSmithyDocumentSerde
}

// Summary information for an Amazon Q application.
type Application struct {

	// The identifier for the Amazon Q application.
	ApplicationId *string

	// The Unix timestamp when the Amazon Q application was created.
	CreatedAt *time.Time

	// The name of the Amazon Q application.
	DisplayName *string

	// The status of the Amazon Q application. The application is ready to use when
	// the status is ACTIVE .
	Status ApplicationStatus

	// The Unix timestamp when the Amazon Q application was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Configuration information about the file upload during chat feature for your
// application.
type AppliedAttachmentsConfiguration struct {

	// Information about whether file upload during chat functionality is activated
	// for your application.
	AttachmentsControlMode AttachmentsControlMode

	noSmithyDocumentSerde
}

// A file directly uploaded into a web experience chat.
type AttachmentInput struct {

	// The data contained within the uploaded file.
	//
	// This member is required.
	Data []byte

	// The name of the file.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The details of a file uploaded during chat.
type AttachmentOutput struct {

	// An error associated with a file uploaded during chat.
	Error *ErrorDetail

	// The name of a file uploaded during chat.
	Name *string

	// The status of a file uploaded during chat.
	Status AttachmentStatus

	noSmithyDocumentSerde
}

// Configuration information for the file upload during chat feature.
type AttachmentsConfiguration struct {

	// Status information about whether file upload functionality is activated or
	// deactivated for your end user.
	//
	// This member is required.
	AttachmentsControlMode AttachmentsControlMode

	noSmithyDocumentSerde
}

// Enables filtering of responses based on document attributes or metadata fields.
type AttributeFilter struct {

	// Performs a logical AND operation on all supplied filters.
	AndAllFilters []AttributeFilter

	// Returns true when a document contains all the specified document attributes or
	// metadata fields.
	ContainsAll *DocumentAttribute

	// Returns true when a document contains any of the specified document attributes
	// or metadata fields.
	ContainsAny *DocumentAttribute

	// Performs an equals operation on two document attributes or metadata fields.
	EqualsTo *DocumentAttribute

	// Performs a greater than operation on two document attributes or metadata
	// fields. Use with a document attribute of type Date or Long .
	GreaterThan *DocumentAttribute

	// Performs a greater or equals than operation on two document attributes or
	// metadata fields. Use with a document attribute of type Date or Long .
	GreaterThanOrEquals *DocumentAttribute

	// Performs a less than operation on two document attributes or metadata fields.
	// Use with a document attribute of type Date or Long .
	LessThan *DocumentAttribute

	// Performs a less than or equals operation on two document attributes or metadata
	// fields. Use with a document attribute of type Date or Long .
	LessThanOrEquals *DocumentAttribute

	// Performs a logical NOT operation on all supplied filters.
	NotFilter *AttributeFilter

	// Performs a logical OR operation on all supplied filters.
	OrAllFilters []AttributeFilter

	noSmithyDocumentSerde
}

// Information about the basic authentication credentials used to configure a
// plugin.
type BasicAuthConfiguration struct {

	// The ARN of an IAM role used by Amazon Q to access the basic authentication
	// credentials stored in a Secrets Manager secret.
	//
	// This member is required.
	RoleArn *string

	// The ARN of the Secrets Manager secret that stores the basic authentication
	// credentials used for plugin configuration..
	//
	// This member is required.
	SecretArn *string

	noSmithyDocumentSerde
}

// Provides information about the phrases blocked from chat by your chat control
// configuration.
type BlockedPhrasesConfiguration struct {

	// A list of phrases blocked from a Amazon Q web experience chat.
	BlockedPhrases []string

	// The configured custom message displayed to an end user informing them that
	// they've used a blocked phrase during chat.
	SystemMessageOverride *string

	noSmithyDocumentSerde
}

// Updates a blocked phrases configuration in your Amazon Q application.
type BlockedPhrasesConfigurationUpdate struct {

	// Creates or updates a blocked phrases configuration in your Amazon Q application.
	BlockedPhrasesToCreateOrUpdate []string

	// Deletes a blocked phrases configuration in your Amazon Q application.
	BlockedPhrasesToDelete []string

	// The configured custom message displayed to your end user when they use blocked
	// phrase during chat.
	SystemMessageOverride *string

	noSmithyDocumentSerde
}

// A rule for configuring how Amazon Q responds when it encounters a a blocked
// topic. You can configure a custom message to inform your end users that they
// have asked about a restricted topic and suggest any next steps they should take.
type ContentBlockerRule struct {

	// The configured custom message displayed to an end user informing them that
	// they've used a blocked phrase during chat.
	SystemMessageOverride *string

	noSmithyDocumentSerde
}

// Rules for retrieving content from data sources connected to a Amazon Q
// application for a specific topic control configuration.
type ContentRetrievalRule struct {

	// Specifies data sources in a Amazon Q application to use for content generation.
	EligibleDataSources []EligibleDataSource

	noSmithyDocumentSerde
}

// A conversation in an Amazon Q application.
type Conversation struct {

	// The identifier of the Amazon Q conversation.
	ConversationId *string

	// The start time of the conversation.
	StartTime *time.Time

	// The title of the conversation.
	Title *string

	noSmithyDocumentSerde
}

// A data source in an Amazon Q application.
type DataSource struct {

	// The Unix timestamp when the Amazon Q data source was created.
	CreatedAt *time.Time

	// The identifier of the Amazon Q data source.
	DataSourceId *string

	// The name of the Amazon Q data source.
	DisplayName *string

	// The status of the Amazon Q data source.
	Status DataSourceStatus

	// The type of the Amazon Q data source.
	Type *string

	// The Unix timestamp when the Amazon Q data source was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Provides information about an Amazon Q data source connector synchronization
// job.
type DataSourceSyncJob struct {

	// If the reason that the synchronization failed is due to an error with the
	// underlying data source, this field contains a code that identifies the error.
	DataSourceErrorCode *string

	// The Unix timestamp when the synchronization job completed.
	EndTime *time.Time

	// If the Status field is set to FAILED , the ErrorCode field indicates the reason
	// the synchronization failed.
	Error *ErrorDetail

	// The identifier of a data source synchronization job.
	ExecutionId *string

	// Maps a batch delete document request to a specific data source sync job. This
	// is optional and should only be supplied when documents are deleted by a data
	// source connector.
	Metrics *DataSourceSyncJobMetrics

	// The Unix time stamp when the data source synchronization job started.
	StartTime *time.Time

	// The status of the synchronization job. When the Status field is set to SUCCEEDED
	// , the synchronization job is done. If the status code is FAILED , the ErrorCode
	// and ErrorMessage fields give you the reason for the failure.
	Status DataSourceSyncJobStatus

	noSmithyDocumentSerde
}

// Maps a batch delete document request to a specific Amazon Q data source
// connector sync job.
type DataSourceSyncJobMetrics struct {

	// The current count of documents added from the data source during the data
	// source sync.
	DocumentsAdded *string

	// The current count of documents deleted from the data source during the data
	// source sync.
	DocumentsDeleted *string

	// The current count of documents that failed to sync from the data source during
	// the data source sync.
	DocumentsFailed *string

	// The current count of documents modified in the data source during the data
	// source sync.
	DocumentsModified *string

	// The current count of documents crawled by the ongoing sync job in the data
	// source.
	DocumentsScanned *string

	noSmithyDocumentSerde
}

// Provides configuration information needed to connect to an Amazon VPC (Virtual
// Private Cloud).
type DataSourceVpcConfiguration struct {

	// A list of identifiers of security groups within your Amazon VPC. The security
	// groups should enable Amazon Q to connect to the data source.
	//
	// This member is required.
	SecurityGroupIds []string

	// A list of identifiers for subnets within your Amazon VPC. The subnets should be
	// able to connect to each other in the VPC, and they should have outgoing access
	// to the Internet through a NAT device.
	//
	// This member is required.
	SubnetIds []string

	noSmithyDocumentSerde
}

// Provides information on boosting DATE type document attributes. For more
// information on how boosting document attributes work in Amazon Q, see Boosting
// using document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html)
// .
type DateAttributeBoostingConfiguration struct {

	// Specifies how much a document attribute is boosted.
	//
	// This member is required.
	BoostingLevel DocumentAttributeBoostingLevel

	// Specifies the duration, in seconds, of a boost applies to a DATE type document
	// attribute.
	BoostingDurationInSeconds *int64

	noSmithyDocumentSerde
}

// A document deleted from an Amazon Q data source connector.
type DeleteDocument struct {

	// The identifier of the deleted document.
	//
	// This member is required.
	DocumentId *string

	noSmithyDocumentSerde
}

// A document in an Amazon Q application.
type Document struct {

	// The identifier of the document.
	//
	// This member is required.
	Id *string

	// Configuration information for access permission to a document.
	AccessConfiguration *AccessConfiguration

	// Custom attributes to apply to the document for refining Amazon Q web experience
	// responses.
	Attributes []DocumentAttribute

	// The contents of the document.
	Content DocumentContent

	// The file type of the document in the Blob field. If you want to index snippets
	// or subsets of HTML documents instead of the entirety of the HTML documents, you
	// add the HTML start and closing tags ( <HTML>content</HTML> ) around the content.
	ContentType ContentType

	// The configuration information for altering document metadata and content during
	// the document ingestion process.
	DocumentEnrichmentConfiguration *DocumentEnrichmentConfiguration

	// The title of the document.
	Title *string

	noSmithyDocumentSerde
}

// A document attribute or metadata field.
type DocumentAttribute struct {

	// The identifier for the attribute.
	//
	// This member is required.
	Name *string

	// The value of the attribute.
	//
	// This member is required.
	Value DocumentAttributeValue

	noSmithyDocumentSerde
}

// Provides information on boosting supported Amazon Q document attribute types.
// When an end user chat query matches document attributes that have been boosted,
// Amazon Q prioritizes generating responses from content that matches the boosted
// document attributes. For STRING and STRING_LIST type document attributes to be
// used for boosting on the console and the API, they must be enabled for search
// using the DocumentAttributeConfiguration (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeConfiguration.html)
// object of the UpdateIndex (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateIndex.html)
// API. If you haven't enabled searching on these attributes, you can't boost
// attributes of these data types on either the console or the API. For more
// information on how boosting document attributes work in Amazon Q, see Boosting
// using document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html)
// .
//
// The following types satisfy this interface:
//
//	DocumentAttributeBoostingConfigurationMemberDateConfiguration
//	DocumentAttributeBoostingConfigurationMemberNumberConfiguration
//	DocumentAttributeBoostingConfigurationMemberStringConfiguration
//	DocumentAttributeBoostingConfigurationMemberStringListConfiguration
type DocumentAttributeBoostingConfiguration interface {
	isDocumentAttributeBoostingConfiguration()
}

// Provides information on boosting DATE type document attributes.
type DocumentAttributeBoostingConfigurationMemberDateConfiguration struct {
	Value DateAttributeBoostingConfiguration

	noSmithyDocumentSerde
}

func (*DocumentAttributeBoostingConfigurationMemberDateConfiguration) isDocumentAttributeBoostingConfiguration() {
}

// Provides information on boosting NUMBER type document attributes.
type DocumentAttributeBoostingConfigurationMemberNumberConfiguration struct {
	Value NumberAttributeBoostingConfiguration

	noSmithyDocumentSerde
}

func (*DocumentAttributeBoostingConfigurationMemberNumberConfiguration) isDocumentAttributeBoostingConfiguration() {
}

// Provides information on boosting STRING type document attributes.
type DocumentAttributeBoostingConfigurationMemberStringConfiguration struct {
	Value StringAttributeBoostingConfiguration

	noSmithyDocumentSerde
}

func (*DocumentAttributeBoostingConfigurationMemberStringConfiguration) isDocumentAttributeBoostingConfiguration() {
}

// Provides information on boosting STRING_LIST type document attributes.
type DocumentAttributeBoostingConfigurationMemberStringListConfiguration struct {
	Value StringListAttributeBoostingConfiguration

	noSmithyDocumentSerde
}

func (*DocumentAttributeBoostingConfigurationMemberStringListConfiguration) isDocumentAttributeBoostingConfiguration() {
}

// The condition used for the target document attribute or metadata field when
// ingesting documents into Amazon Q. You use this with DocumentAttributeTarget (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html)
// to apply the condition. For example, you can create the 'Department' target
// field and have it prefill department names associated with the documents based
// on information in the 'Source_URI' field. Set the condition that if the
// 'Source_URI' field contains 'financial' in its URI value, then prefill the
// target field 'Department' with the target value 'Finance' for the document.
// Amazon Q can't create a target field if it has not already been created as an
// index field. After you create your index field, you can create a document
// metadata field using DocumentAttributeTarget . Amazon Q then will map your newly
// created metadata field to your index field.
type DocumentAttributeCondition struct {

	// The identifier of the document attribute used for the condition. For example,
	// 'Source_URI' could be an identifier for the attribute or metadata field that
	// contains source URIs associated with the documents. Amazon Q currently doesn't
	// support _document_body as an attribute key used for the condition.
	//
	// This member is required.
	Key *string

	// The identifier of the document attribute used for the condition. For example,
	// 'Source_URI' could be an identifier for the attribute or metadata field that
	// contains source URIs associated with the documents. Amazon Kendra currently does
	// not support _document_body as an attribute key used for the condition.
	//
	// This member is required.
	Operator DocumentEnrichmentConditionOperator

	// The value of a document attribute. You can only provide one value for a
	// document attribute.
	Value DocumentAttributeValue

	noSmithyDocumentSerde
}

// Configuration information for document attributes. Document attributes are
// metadata or fields associated with your documents. For example, the company
// department name associated with each document. For more information, see
// Understanding document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/doc-attributes.html)
// .
type DocumentAttributeConfiguration struct {

	// The name of the document attribute.
	Name *string

	// Information about whether the document attribute can be used by an end user to
	// search for information on their web experience.
	Search Status

	// The type of document attribute.
	Type AttributeType

	noSmithyDocumentSerde
}

// The target document attribute or metadata field you want to alter when
// ingesting documents into Amazon Q. For example, you can delete all customer
// identification numbers associated with the documents, stored in the document
// metadata field called 'Customer_ID' by setting the target key as 'Customer_ID'
// and the deletion flag to TRUE . This removes all customer ID values in the field
// 'Customer_ID'. This would scrub personally identifiable information from each
// document's metadata. Amazon Q can't create a target field if it has not already
// been created as an index field. After you create your index field, you can
// create a document metadata field using DocumentAttributeTarget (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html)
// . Amazon Q will then map your newly created document attribute to your index
// field. You can also use this with DocumentAttributeCondition (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeCondition.html)
// .
type DocumentAttributeTarget struct {

	// The identifier of the target document attribute or metadata field. For example,
	// 'Department' could be an identifier for the target attribute or metadata field
	// that includes the department names associated with the documents.
	//
	// This member is required.
	Key *string

	// TRUE to delete the existing target value for your specified target attribute
	// key. You cannot create a target value and set this to TRUE .
	AttributeValueOperator AttributeValueOperator

	// The value of a document attribute. You can only provide one value for a
	// document attribute.
	Value DocumentAttributeValue

	noSmithyDocumentSerde
}

// The value of a document attribute. You can only provide one value for a
// document attribute.
//
// The following types satisfy this interface:
//
//	DocumentAttributeValueMemberDateValue
//	DocumentAttributeValueMemberLongValue
//	DocumentAttributeValueMemberStringListValue
//	DocumentAttributeValueMemberStringValue
type DocumentAttributeValue interface {
	isDocumentAttributeValue()
}

// A date expressed as an ISO 8601 string. It's important for the time zone to be
// included in the ISO 8601 date-time format. For example,
// 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012
// at 12:30PM (plus 10 seconds) in Central European Time.
type DocumentAttributeValueMemberDateValue struct {
	Value time.Time

	noSmithyDocumentSerde
}

func (*DocumentAttributeValueMemberDateValue) isDocumentAttributeValue() {}

// A long integer value.
type DocumentAttributeValueMemberLongValue struct {
	Value int64

	noSmithyDocumentSerde
}

func (*DocumentAttributeValueMemberLongValue) isDocumentAttributeValue() {}

// A list of strings.
type DocumentAttributeValueMemberStringListValue struct {
	Value []string

	noSmithyDocumentSerde
}

func (*DocumentAttributeValueMemberStringListValue) isDocumentAttributeValue() {}

// A string.
type DocumentAttributeValueMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*DocumentAttributeValueMemberStringValue) isDocumentAttributeValue() {}

// The contents of a document.
//
// The following types satisfy this interface:
//
//	DocumentContentMemberBlob
//	DocumentContentMemberS3
type DocumentContent interface {
	isDocumentContent()
}

// The contents of the document. Documents passed to the blob parameter must be
// base64 encoded. Your code might not need to encode the document file bytes if
// you're using an Amazon Web Services SDK to call Amazon Q APIs. If you are
// calling the Amazon Q endpoint directly using REST, you must base64 encode the
// contents before sending.
type DocumentContentMemberBlob struct {
	Value []byte

	noSmithyDocumentSerde
}

func (*DocumentContentMemberBlob) isDocumentContent() {}

// The path to the document in an Amazon S3 bucket.
type DocumentContentMemberS3 struct {
	Value S3

	noSmithyDocumentSerde
}

func (*DocumentContentMemberS3) isDocumentContent() {}

// The details of a document within an Amazon Q index.
type DocumentDetails struct {

	// The timestamp for when the document was created.
	CreatedAt *time.Time

	// The identifier of the document.
	DocumentId *string

	// An error message associated with the document.
	Error *ErrorDetail

	// The current status of the document.
	Status DocumentStatus

	// The timestamp for when the document was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Provides the configuration information for altering document metadata and
// content during the document ingestion process. For more information, see Custom
// document enrichment (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html)
// .
type DocumentEnrichmentConfiguration struct {

	// Configuration information to alter document attributes or metadata fields and
	// content when ingesting documents into Amazon Q.
	InlineConfigurations []InlineDocumentEnrichmentConfiguration

	// Provides the configuration information for invoking a Lambda function in Lambda
	// to alter document metadata and content when ingesting documents into Amazon Q.
	// You can configure your Lambda function using PreExtractionHookConfiguration (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html)
	// if you want to apply advanced alterations on the original or raw documents. If
	// you want to apply advanced alterations on the Amazon Q structured documents, you
	// must configure your Lambda function using PostExtractionHookConfiguration (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html)
	// . You can only invoke one Lambda function. However, this function can invoke
	// other functions it requires. For more information, see Custom document
	// enrichment (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html)
	// .
	PostExtractionHookConfiguration *HookConfiguration

	// Provides the configuration information for invoking a Lambda function in Lambda
	// to alter document metadata and content when ingesting documents into Amazon Q.
	// You can configure your Lambda function using PreExtractionHookConfiguration (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html)
	// if you want to apply advanced alterations on the original or raw documents. If
	// you want to apply advanced alterations on the Amazon Q structured documents, you
	// must configure your Lambda function using PostExtractionHookConfiguration (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html)
	// . You can only invoke one Lambda function. However, this function can invoke
	// other functions it requires. For more information, see Custom document
	// enrichment (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html)
	// .
	PreExtractionHookConfiguration *HookConfiguration

	noSmithyDocumentSerde
}

// The identifier of the data source Amazon Q will generate responses from.
type EligibleDataSource struct {

	// The identifier of the data source.
	DataSourceId *string

	// The identifier of the index the data source is attached to.
	IndexId *string

	noSmithyDocumentSerde
}

// Provides the identifier of the KMS key used to encrypt data indexed by Amazon
// Q. Amazon Q doesn't support asymmetric keys.
type EncryptionConfiguration struct {

	// The identifier of the KMS key. Amazon Q doesn't support asymmetric keys.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Provides information about a data source sync error.
type ErrorDetail struct {

	// The code associated with the data source sync error.
	ErrorCode ErrorCode

	// The message explaining the data source sync error.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// A list of documents that could not be removed from an Amazon Q index. Each
// entry contains an error message that indicates why the document couldn't be
// removed from the index.
type FailedDocument struct {

	// The identifier of the Amazon Q data source connector that contains the failed
	// document.
	DataSourceId *string

	// An explanation for why the document couldn't be removed from the index.
	Error *ErrorDetail

	// The identifier of the document that couldn't be removed from the Amazon Q index.
	Id *string

	noSmithyDocumentSerde
}

// A list of users or sub groups that belong to a group. This is for generating
// Amazon Q chat results only from document a user has access to.
type GroupMembers struct {

	// A list of sub groups that belong to a group. For example, the sub groups
	// "Research", "Engineering", and "Sales and Marketing" all belong to the group
	// "Company".
	MemberGroups []MemberGroup

	// A list of users that belong to a group. For example, a list of interns all
	// belong to the "Interns" group.
	MemberUsers []MemberUser

	noSmithyDocumentSerde
}

// Provides the details of a group's status.
type GroupStatusDetail struct {

	// The details of an error associated a group status.
	ErrorDetail *ErrorDetail

	// The Unix timestamp when the Amazon Q application was last updated.
	LastUpdatedAt *time.Time

	// The status of a group.
	Status GroupStatus

	noSmithyDocumentSerde
}

// Summary information for groups.
type GroupSummary struct {

	// The name of the group the summary information is for.
	GroupName *string

	noSmithyDocumentSerde
}

// Provides the configuration information for invoking a Lambda function in Lambda
// to alter document metadata and content when ingesting documents into Amazon Q.
// You can configure your Lambda function using PreExtractionHookConfiguration (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html)
// if you want to apply advanced alterations on the original or raw documents. If
// you want to apply advanced alterations on the Amazon Q structured documents, you
// must configure your Lambda function using PostExtractionHookConfiguration (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentEnrichmentConfiguration.html)
// . You can only invoke one Lambda function. However, this function can invoke
// other functions it requires. For more information, see Custom document
// enrichment (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html)
// .
type HookConfiguration struct {

	// The condition used for when a Lambda function should be invoked. For example,
	// you can specify a condition that if there are empty date-time values, then
	// Amazon Q should invoke a function that inserts the current date-time.
	InvocationCondition *DocumentAttributeCondition

	// The Amazon Resource Name (ARN) of a role with permission to run a Lambda
	// function during ingestion. For more information, see IAM roles for Custom
	// Document Enrichment (CDE) (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/iam-roles.html#cde-iam-role)
	// .
	LambdaArn *string

	// The Amazon Resource Name (ARN) of a role with permission to run
	// PreExtractionHookConfiguration and PostExtractionHookConfiguration for altering
	// document metadata and content during the document ingestion process.
	RoleArn *string

	// Stores the original, raw documents or the structured, parsed documents before
	// and after altering them. For more information, see Data contracts for Lambda
	// functions (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/cde-lambda-operations.html#cde-lambda-operations-data-contracts)
	// .
	S3BucketName *string

	noSmithyDocumentSerde
}

// Summary information for your Amazon Q index.
type Index struct {

	// The Unix timestamp when the index was created.
	CreatedAt *time.Time

	// The name of the index.
	DisplayName *string

	// The identifier for the index.
	IndexId *string

	// The current status of the index. When the status is ACTIVE , the index is ready.
	Status IndexStatus

	// The Unix timestamp when the index was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Provides information about index capacity configuration.
type IndexCapacityConfiguration struct {

	// The number of storage units configured for an Amazon Q index.
	Units *int32

	noSmithyDocumentSerde
}

// Provides information about the number of documents in an index.
type IndexStatistics struct {

	// The number of documents indexed.
	TextDocumentStatistics *TextDocumentStatistics

	noSmithyDocumentSerde
}

// Provides the configuration information for applying basic logic to alter
// document metadata and content when ingesting documents into Amazon Q. To apply
// advanced logic, to go beyond what you can do with basic logic, see
// HookConfiguration (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_HookConfiguration.html)
// . For more information, see Custom document enrichment (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/custom-document-enrichment.html)
// .
type InlineDocumentEnrichmentConfiguration struct {

	// The condition used for the target document attribute or metadata field when
	// ingesting documents into Amazon Q. You use this with DocumentAttributeTarget (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html)
	// to apply the condition. For example, you can create the 'Department' target
	// field and have it prefill department names associated with the documents based
	// on information in the 'Source_URI' field. Set the condition that if the
	// 'Source_URI' field contains 'financial' in its URI value, then prefill the
	// target field 'Department' with the target value 'Finance' for the document.
	// Amazon Q can't create a target field if it has not already been created as an
	// index field. After you create your index field, you can create a document
	// metadata field using DocumentAttributeTarget . Amazon Q then will map your newly
	// created metadata field to your index field.
	Condition *DocumentAttributeCondition

	// TRUE to delete content if the condition used for the target attribute is met.
	DocumentContentOperator DocumentContentOperator

	// The target document attribute or metadata field you want to alter when
	// ingesting documents into Amazon Q. For example, you can delete all customer
	// identification numbers associated with the documents, stored in the document
	// metadata field called 'Customer_ID' by setting the target key as 'Customer_ID'
	// and the deletion flag to TRUE . This removes all customer ID values in the field
	// 'Customer_ID'. This would scrub personally identifiable information from each
	// document's metadata. Amazon Q can't create a target field if it has not already
	// been created as an index field. After you create your index field, you can
	// create a document metadata field using DocumentAttributeTarget (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeTarget.html)
	// . Amazon Q will then map your newly created document attribute to your index
	// field. You can also use this with DocumentAttributeCondition (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeCondition.html)
	// .
	Target *DocumentAttributeTarget

	noSmithyDocumentSerde
}

// Stores an Amazon Kendra index as a retriever.
type KendraIndexConfiguration struct {

	// The identifier of the Amazon Kendra index.
	//
	// This member is required.
	IndexId *string

	noSmithyDocumentSerde
}

// The sub groups that belong to a group.
type MemberGroup struct {

	// The name of the sub group.
	//
	// This member is required.
	GroupName *string

	// The type of the sub group.
	Type MembershipType

	noSmithyDocumentSerde
}

// The users that belong to a group.
type MemberUser struct {

	// The identifier of the user you want to map to a group.
	//
	// This member is required.
	UserId *string

	// The type of the user.
	Type MembershipType

	noSmithyDocumentSerde
}

// A message in an Amazon Q web experience.
type Message struct {

	// Performs an Amazon Q plugin action during a non-streaming chat conversation.
	ActionExecution *ActionExecution

	// An output event that Amazon Q returns to an user who wants to perform a plugin
	// action during a non-streaming chat conversation. It contains information about
	// the selected action with a list of possible user input fields, some
	// pre-populated by Amazon Q.
	ActionReview *ActionReview

	// A file directly uploaded into an Amazon Q web experience chat.
	Attachments []AttachmentOutput

	// The content of the Amazon Q web experience message.
	Body *string

	// The identifier of the Amazon Q web experience message.
	MessageId *string

	// The source documents used to generate Amazon Q web experience message.
	SourceAttribution []*SourceAttribution

	// The timestamp of the first Amazon Q web experience message.
	Time *time.Time

	// The type of Amazon Q message, whether HUMAN or AI generated.
	Type MessageType

	noSmithyDocumentSerde
}

// End user feedback on an AI-generated web experience chat message usefulness.
type MessageUsefulnessFeedback struct {

	// The timestamp for when the feedback was submitted.
	//
	// This member is required.
	SubmittedAt *time.Time

	// The usefulness value assigned by an end user to a message.
	//
	// This member is required.
	Usefulness MessageUsefulness

	// A comment given by an end user on the usefulness of an AI-generated chat
	// message.
	Comment *string

	// The reason for a usefulness rating.
	Reason MessageUsefulnessReason

	noSmithyDocumentSerde
}

// Configuration information for an Amazon Q index.
type NativeIndexConfiguration struct {

	// The identifier for the Amazon Q index.
	//
	// This member is required.
	IndexId *string

	// Overrides the default boosts applied by Amazon Q to supported document
	// attribute data types.
	BoostingOverride map[string]DocumentAttributeBoostingConfiguration

	noSmithyDocumentSerde
}

// Provides information on boosting NUMBER type document attributes. For more
// information on how boosting document attributes work in Amazon Q, see Boosting
// using document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html)
// .
type NumberAttributeBoostingConfiguration struct {

	// Specifies the duration, in seconds, of a boost applies to a NUMBER type
	// document attribute.
	//
	// This member is required.
	BoostingLevel DocumentAttributeBoostingLevel

	// Specifies how much a document attribute is boosted.
	BoostingType NumberAttributeBoostingType

	noSmithyDocumentSerde
}

// Information about the OAuth 2.0 authentication credential/token used to
// configure a plugin.
type OAuth2ClientCredentialConfiguration struct {

	// The ARN of an IAM role used by Amazon Q to access the OAuth 2.0 authentication
	// credentials stored in a Secrets Manager secret.
	//
	// This member is required.
	RoleArn *string

	// The ARN of the Secrets Manager secret that stores the OAuth 2.0
	// credentials/token used for plugin configuration.
	//
	// This member is required.
	SecretArn *string

	noSmithyDocumentSerde
}

// Information about an Amazon Q plugin and its configuration.
type Plugin struct {

	// The timestamp for when the plugin was created.
	CreatedAt *time.Time

	// The name of the plugin.
	DisplayName *string

	// The identifier of the plugin.
	PluginId *string

	// The plugin server URL used for configuration.
	ServerUrl *string

	// The current status of the plugin.
	State PluginState

	// The type of the plugin.
	Type PluginType

	// The timestamp for when the plugin was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Authentication configuration information for an Amazon Q plugin.
//
// The following types satisfy this interface:
//
//	PluginAuthConfigurationMemberBasicAuthConfiguration
//	PluginAuthConfigurationMemberOAuth2ClientCredentialConfiguration
type PluginAuthConfiguration interface {
	isPluginAuthConfiguration()
}

// Information about the basic authentication credentials used to configure a
// plugin.
type PluginAuthConfigurationMemberBasicAuthConfiguration struct {
	Value BasicAuthConfiguration

	noSmithyDocumentSerde
}

func (*PluginAuthConfigurationMemberBasicAuthConfiguration) isPluginAuthConfiguration() {}

// Information about the OAuth 2.0 authentication credential/token used to
// configure a plugin.
type PluginAuthConfigurationMemberOAuth2ClientCredentialConfiguration struct {
	Value OAuth2ClientCredentialConfiguration

	noSmithyDocumentSerde
}

func (*PluginAuthConfigurationMemberOAuth2ClientCredentialConfiguration) isPluginAuthConfiguration() {
}

// Provides user and group information used for filtering documents to use for
// generating Amazon Q conversation responses.
//
// The following types satisfy this interface:
//
//	PrincipalMemberGroup
//	PrincipalMemberUser
type Principal interface {
	isPrincipal()
}

// The group associated with the principal.
type PrincipalMemberGroup struct {
	Value PrincipalGroup

	noSmithyDocumentSerde
}

func (*PrincipalMemberGroup) isPrincipal() {}

// The user associated with the principal.
type PrincipalMemberUser struct {
	Value PrincipalUser

	noSmithyDocumentSerde
}

func (*PrincipalMemberUser) isPrincipal() {}

// Provides information about a group associated with the principal.
type PrincipalGroup struct {

	// Provides information about whether to allow or deny access to the principal.
	//
	// This member is required.
	Access ReadAccessType

	// The type of group.
	MembershipType MembershipType

	// The name of the group.
	Name *string

	noSmithyDocumentSerde
}

// Provides information about a user associated with a principal.
type PrincipalUser struct {

	// Provides information about whether to allow or deny access to the principal.
	//
	// This member is required.
	Access ReadAccessType

	// The identifier of the user.
	Id *string

	// The type of group.
	MembershipType MembershipType

	noSmithyDocumentSerde
}

// Summary information for the retriever used for your Amazon Q application.
type Retriever struct {

	// The identifier of the Amazon Q application using the retriever.
	ApplicationId *string

	// The name of your retriever.
	DisplayName *string

	// The identifier of the retriever used by your Amazon Q application.
	RetrieverId *string

	// The status of your retriever.
	Status RetrieverStatus

	// The type of your retriever.
	Type RetrieverType

	noSmithyDocumentSerde
}

// Provides information on how the retriever used for your Amazon Q application is
// configured.
//
// The following types satisfy this interface:
//
//	RetrieverConfigurationMemberKendraIndexConfiguration
//	RetrieverConfigurationMemberNativeIndexConfiguration
type RetrieverConfiguration interface {
	isRetrieverConfiguration()
}

// Provides information on how the Amazon Kendra index used as a retriever for
// your Amazon Q application is configured.
type RetrieverConfigurationMemberKendraIndexConfiguration struct {
	Value KendraIndexConfiguration

	noSmithyDocumentSerde
}

func (*RetrieverConfigurationMemberKendraIndexConfiguration) isRetrieverConfiguration() {}

// Provides information on how a Amazon Q index used as a retriever for your
// Amazon Q application is configured.
type RetrieverConfigurationMemberNativeIndexConfiguration struct {
	Value NativeIndexConfiguration

	noSmithyDocumentSerde
}

func (*RetrieverConfigurationMemberNativeIndexConfiguration) isRetrieverConfiguration() {}

// Guardrail rules for an Amazon Q application. Amazon Q supports only one rule at
// a time.
type Rule struct {

	// The type of rule.
	//
	// This member is required.
	RuleType RuleType

	// Users and groups to be excluded from a rule.
	ExcludedUsersAndGroups *UsersAndGroups

	// Users and groups to be included in a rule.
	IncludedUsersAndGroups *UsersAndGroups

	// The configuration information for a rule.
	RuleConfiguration RuleConfiguration

	noSmithyDocumentSerde
}

// Provides configuration information about a rule.
//
// The following types satisfy this interface:
//
//	RuleConfigurationMemberContentBlockerRule
//	RuleConfigurationMemberContentRetrievalRule
type RuleConfiguration interface {
	isRuleConfiguration()
}

// A rule for configuring how Amazon Q responds when it encounters a a blocked
// topic.
type RuleConfigurationMemberContentBlockerRule struct {
	Value ContentBlockerRule

	noSmithyDocumentSerde
}

func (*RuleConfigurationMemberContentBlockerRule) isRuleConfiguration() {}

// Rules for retrieving content from data sources connected to a Amazon Q
// application for a specific topic control configuration.
type RuleConfigurationMemberContentRetrievalRule struct {
	Value ContentRetrievalRule

	noSmithyDocumentSerde
}

func (*RuleConfigurationMemberContentRetrievalRule) isRuleConfiguration() {}

// Information required for Amazon Q to find a specific file in an Amazon S3
// bucket.
type S3 struct {

	// The name of the S3 bucket that contains the file.
	//
	// This member is required.
	Bucket *string

	// The name of the file.
	//
	// This member is required.
	Key *string

	noSmithyDocumentSerde
}

// Provides the SAML 2.0 compliant identity provider (IdP) configuration
// information Amazon Q needs to deploy a Amazon Q web experience.
type SamlConfiguration struct {

	// The metadata XML that your IdP generated.
	//
	// This member is required.
	MetadataXML *string

	// The Amazon Resource Name (ARN) of an IAM role assumed by users when they
	// authenticate into their Amazon Q web experience, containing the relevant Amazon
	// Q permissions for conversing with Amazon Q.
	//
	// This member is required.
	RoleArn *string

	// The user attribute name in your IdP that maps to the user email.
	//
	// This member is required.
	UserIdAttribute *string

	// The group attribute name in your IdP that maps to user groups.
	UserGroupAttribute *string

	noSmithyDocumentSerde
}

// The documents used to generate an Amazon Q web experience response.
type SourceAttribution struct {

	// The number attached to a citation in an Amazon Q generated response.
	CitationNumber *int32

	// The content extract from the document on which the generated response is based.
	Snippet *string

	// A text extract from a source document that is used for source attribution.
	TextMessageSegments []TextSegment

	// The title of the document which is the source for the Amazon Q generated
	// response.
	Title *string

	// The Unix timestamp when the Amazon Q application was last updated.
	UpdatedAt *time.Time

	// The URL of the document which is the source for the Amazon Q generated response.
	Url *string

	noSmithyDocumentSerde
}

// Provides information on boosting STRING type document attributes. For STRING
// and STRING_LIST type document attributes to be used for boosting on the console
// and the API, they must be enabled for search using the
// DocumentAttributeConfiguration (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeConfiguration.html)
// object of the UpdateIndex (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateIndex.html)
// API. If you haven't enabled searching on these attributes, you can't boost
// attributes of these data types on either the console or the API. For more
// information on how boosting document attributes work in Amazon Q, see Boosting
// using document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html)
// .
type StringAttributeBoostingConfiguration struct {

	// Specifies how much a document attribute is boosted.
	//
	// This member is required.
	BoostingLevel DocumentAttributeBoostingLevel

	// Specifies specific values of a STRING type document attribute being boosted.
	AttributeValueBoosting map[string]StringAttributeValueBoostingLevel

	noSmithyDocumentSerde
}

// Provides information on boosting STRING_LIST type document attributes. For
// STRING and STRING_LIST type document attributes to be used for boosting on the
// console and the API, they must be enabled for search using the
// DocumentAttributeConfiguration (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeConfiguration.html)
// object of the UpdateIndex (https://docs.aws.amazon.com/amazonq/latest/api-reference/API_UpdateIndex.html)
// API. If you haven't enabled searching on these attributes, you can't boost
// attributes of these data types on either the console or the API. For more
// information on how boosting document attributes work in Amazon Q, see Boosting
// using document attributes (https://docs.aws.amazon.com/amazonq/latest/business-use-dg/metadata-boosting.html)
// .
type StringListAttributeBoostingConfiguration struct {

	// Specifies how much a document attribute is boosted.
	//
	// This member is required.
	BoostingLevel DocumentAttributeBoostingLevel

	noSmithyDocumentSerde
}

// A list of key/value pairs that identify an index, FAQ, or data source. Tag keys
// and values can consist of Unicode letters, digits, white space, and any of the
// following symbols: _ . : / = + - @.
type Tag struct {

	// The key for the tag. Keys are not case sensitive and must be unique for the
	// Amazon Q application or data source.
	//
	// This member is required.
	Key *string

	// The value associated with the tag. The value may be an empty string but it
	// can't be null.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Provides information about text documents in an index.
type TextDocumentStatistics struct {

	// The total size, in bytes, of the indexed documents.
	IndexedTextBytes *int64

	// The number of text documents indexed.
	IndexedTextDocumentCount *int32

	noSmithyDocumentSerde
}

// Provides information about a text extract in a chat response that can be
// attributed to a source document.
type TextSegment struct {

	// The zero-based location in the response string where the source attribution
	// starts.
	BeginOffset *int32

	// The zero-based location in the response string where the source attribution
	// ends.
	EndOffset *int32

	noSmithyDocumentSerde
}

// The topic specific controls configured for an Amazon Q application.
type TopicConfiguration struct {

	// A name for your topic control configuration.
	//
	// This member is required.
	Name *string

	// Rules defined for a topic configuration.
	//
	// This member is required.
	Rules []Rule

	// A description for your topic control configuration. Use this to outline how the
	// large language model (LLM) should use this topic control configuration.
	Description *string

	// A list of example phrases that you expect the end user to use in relation to
	// the topic.
	ExampleChatMessages []string

	noSmithyDocumentSerde
}

// Aliases attached to a user id within an Amazon Q application.
type UserAlias struct {

	// The identifier of the user id associated with the user aliases.
	//
	// This member is required.
	UserId *string

	// The identifier of the data source that the user aliases are associated with.
	DataSourceId *string

	// The identifier of the index that the user aliases are associated with.
	IndexId *string

	noSmithyDocumentSerde
}

// Provides information about users and groups associated with a topic control
// rule.
type UsersAndGroups struct {

	// The user groups associated with a topic control rule.
	UserGroups []string

	// The user ids associated with a topic control rule.
	UserIds []string

	noSmithyDocumentSerde
}

// The input failed to meet the constraints specified by Amazon Q in a specified
// field.
type ValidationExceptionField struct {

	// A message about the validation exception.
	//
	// This member is required.
	Message *string

	// The field name where the invalid entry was detected.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Provides information for an Amazon Q web experience.
type WebExperience struct {

	// The Unix timestamp when the Amazon Q application was last updated.
	CreatedAt *time.Time

	// The endpoint URLs for your Amazon Q web experience. The URLs are unique and
	// fully hosted by Amazon Web Services.
	DefaultEndpoint *string

	// The status of your Amazon Q web experience.
	Status WebExperienceStatus

	// The Unix timestamp when your Amazon Q web experience was updated.
	UpdatedAt *time.Time

	// The identifier of your Amazon Q web experience.
	WebExperienceId *string

	noSmithyDocumentSerde
}

// Provides the authorization configuration information needed to deploy a Amazon
// Q web experience to end users.
//
// The following types satisfy this interface:
//
//	WebExperienceAuthConfigurationMemberSamlConfiguration
type WebExperienceAuthConfiguration interface {
	isWebExperienceAuthConfiguration()
}

// Provides the SAML 2.0 compliant identity provider (IdP) configuration
// information Amazon Q needs to deploy a Amazon Q web experience.
type WebExperienceAuthConfigurationMemberSamlConfiguration struct {
	Value SamlConfiguration

	noSmithyDocumentSerde
}

func (*WebExperienceAuthConfigurationMemberSamlConfiguration) isWebExperienceAuthConfiguration() {}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isDocumentAttributeBoostingConfiguration() {}
func (*UnknownUnionMember) isDocumentAttributeValue()                 {}
func (*UnknownUnionMember) isDocumentContent()                        {}
func (*UnknownUnionMember) isPluginAuthConfiguration()                {}
func (*UnknownUnionMember) isPrincipal()                              {}
func (*UnknownUnionMember) isRetrieverConfiguration()                 {}
func (*UnknownUnionMember) isRuleConfiguration()                      {}
func (*UnknownUnionMember) isWebExperienceAuthConfiguration()         {}
