// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// An object that represents the custom domain name association.
type Association struct {

	// The custom domain name’s certificate Amazon resource name (ARN).
	CustomDomainCertificateArn *string

	// The expiration time for the certificate.
	CustomDomainCertificateExpiryTime *time.Time

	// The custom domain name associated with the workgroup.
	CustomDomainName *string

	// The name of the workgroup associated with the database.
	WorkgroupName *string

	noSmithyDocumentSerde
}

// An array of key-value pairs to set for advanced control over Amazon Redshift
// Serverless.
type ConfigParameter struct {

	// The key of the parameter. The options are auto_mv , datestyle ,
	// enable_case_sensitive_identifier , enable_user_activity_logging , query_group ,
	// search_path , require_ssl , and query monitoring metrics that let you define
	// performance boundaries. For more information about query monitoring rules and
	// available metrics, see Query monitoring metrics for Amazon Redshift Serverless (https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless)
	// .
	ParameterKey *string

	// The value of the parameter to set.
	ParameterValue *string

	noSmithyDocumentSerde
}

// The parameters that you can use to configure a scheduled action (https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html)
// to create a snapshot. For more information about creating a scheduled action,
// see CreateScheduledAction (https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html)
// .
type CreateSnapshotScheduleActionParameters struct {

	// The name of the namespace for which you want to configure a scheduled action to
	// create a snapshot.
	//
	// This member is required.
	NamespaceName *string

	// A string prefix that is attached to the name of the snapshot created by the
	// scheduled action. The final name of the snapshot is the string prefix appended
	// by the date and time of when the snapshot was created.
	//
	// This member is required.
	SnapshotNamePrefix *string

	// The retention period of the snapshot created by the scheduled action.
	RetentionPeriod *int32

	// An array of Tag objects (https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html)
	// to associate with the snapshot.
	Tags []Tag

	noSmithyDocumentSerde
}

// The VPC endpoint object.
type Endpoint struct {

	// The DNS address of the VPC endpoint.
	Address *string

	// The port that Amazon Redshift Serverless listens on.
	Port *int32

	// An array of VpcEndpoint objects.
	VpcEndpoints []VpcEndpoint

	noSmithyDocumentSerde
}

// Information about an Amazon Redshift Serverless VPC endpoint.
type EndpointAccess struct {

	// The DNS address of the endpoint.
	Address *string

	// The Amazon Resource Name (ARN) of the VPC endpoint.
	EndpointArn *string

	// The time that the endpoint was created.
	EndpointCreateTime *time.Time

	// The name of the VPC endpoint.
	EndpointName *string

	// The status of the VPC endpoint.
	EndpointStatus *string

	// The port number on which Amazon Redshift Serverless accepts incoming
	// connections.
	Port *int32

	// The unique identifier of subnets where Amazon Redshift Serverless choose to
	// deploy the VPC endpoint.
	SubnetIds []string

	// The connection endpoint for connecting to Amazon Redshift Serverless.
	VpcEndpoint *VpcEndpoint

	// The security groups associated with the endpoint.
	VpcSecurityGroups []VpcSecurityGroupMembership

	// The name of the workgroup associated with the endpoint.
	WorkgroupName *string

	noSmithyDocumentSerde
}

// A collection of database objects and users.
type Namespace struct {

	// The Amazon Resource Name (ARN) for the namespace's admin user credentials
	// secret.
	AdminPasswordSecretArn *string

	// The ID of the Key Management Service (KMS) key used to encrypt and store the
	// namespace's admin credentials secret.
	AdminPasswordSecretKmsKeyId *string

	// The username of the administrator for the first database created in the
	// namespace.
	AdminUsername *string

	// The date of when the namespace was created.
	CreationDate *time.Time

	// The name of the first database created in the namespace.
	DbName *string

	// The Amazon Resource Name (ARN) of the IAM role to set as a default in the
	// namespace.
	DefaultIamRoleArn *string

	// A list of IAM roles to associate with the namespace.
	IamRoles []string

	// The ID of the Amazon Web Services Key Management Service key used to encrypt
	// your data.
	KmsKeyId *string

	// The types of logs the namespace can export. Available export types are User
	// log, Connection log, and User activity log.
	LogExports []LogExport

	// The Amazon Resource Name (ARN) associated with a namespace.
	NamespaceArn *string

	// The unique identifier of a namespace.
	NamespaceId *string

	// The name of the namespace. Must be between 3-64 alphanumeric characters in
	// lowercase, and it cannot be a reserved word. A list of reserved words can be
	// found in Reserved Words (https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	// in the Amazon Redshift Database Developer Guide.
	NamespaceName *string

	// The status of the namespace.
	Status NamespaceStatus

	noSmithyDocumentSerde
}

// Contains information about a network interface in an Amazon Redshift Serverless
// managed VPC endpoint.
type NetworkInterface struct {

	// The availability Zone.
	AvailabilityZone *string

	// The unique identifier of the network interface.
	NetworkInterfaceId *string

	// The IPv4 address of the network interface within the subnet.
	PrivateIpAddress *string

	// The unique identifier of the subnet.
	SubnetId *string

	noSmithyDocumentSerde
}

// The automatically created recovery point of a namespace. Recovery points are
// created every 30 minutes and kept for 24 hours.
type RecoveryPoint struct {

	// The Amazon Resource Name (ARN) of the namespace the recovery point is
	// associated with.
	NamespaceArn *string

	// The name of the namespace the recovery point is associated with.
	NamespaceName *string

	// The time the recovery point is created.
	RecoveryPointCreateTime *time.Time

	// The unique identifier of the recovery point.
	RecoveryPointId *string

	// The total size of the data in the recovery point in megabytes.
	TotalSizeInMegaBytes *float64

	// The name of the workgroup the recovery point is associated with.
	WorkgroupName *string

	noSmithyDocumentSerde
}

// The resource policy object. Currently, you can use policies to share snapshots
// across Amazon Web Services accounts.
type ResourcePolicy struct {

	// The resource policy.
	Policy *string

	// The Amazon Resource Name (ARN) of the policy.
	ResourceArn *string

	noSmithyDocumentSerde
}

// The schedule of when Amazon Redshift Serverless should run the scheduled action.
//
// The following types satisfy this interface:
//
//	ScheduleMemberAt
//	ScheduleMemberCron
type Schedule interface {
	isSchedule()
}

// The timestamp of when Amazon Redshift Serverless should run the scheduled
// action. Format of at expressions is " at(yyyy-mm-ddThh:mm:ss) ". For example, "
// at(2016-03-04T17:27:00) ".
type ScheduleMemberAt struct {
	Value time.Time

	noSmithyDocumentSerde
}

func (*ScheduleMemberAt) isSchedule() {}

// The cron expression to use to schedule a recurring scheduled action. Schedule
// invocations must be separated by at least one hour. Format of cron expressions
// is " cron(Minutes Hours Day-of-month Month Day-of-week Year) ". For example, "
// cron(0 10 ? * MON *) ". For more information, see Cron Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
// in the Amazon CloudWatch Events User Guide.
type ScheduleMemberCron struct {
	Value string

	noSmithyDocumentSerde
}

func (*ScheduleMemberCron) isSchedule() {}

// The returned scheduled action object.
type ScheduledActionResponse struct {

	// The end time of
	EndTime *time.Time

	// The end time in UTC when the schedule is no longer active. After this time, the
	// scheduled action does not trigger.
	NamespaceName *string

	// An array of timestamps of when the next scheduled actions will trigger.
	NextInvocations []time.Time

	// The ARN of the IAM role to assume to run the scheduled action. This IAM role
	// must have permission to run the Amazon Redshift Serverless API operation in the
	// scheduled action. This IAM role must allow the Amazon Redshift scheduler to
	// schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com) to
	// assume permissions on your behalf. For more information about the IAM role to
	// use with the Amazon Redshift scheduler, see Using Identity-Based Policies for
	// Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html)
	// in the Amazon Redshift Cluster Management Guide
	RoleArn *string

	// The schedule for a one-time (at format) or recurring (cron format) scheduled
	// action. Schedule invocations must be separated by at least one hour. Format of
	// at expressions is " at(yyyy-mm-ddThh:mm:ss) ". For example, "
	// at(2016-03-04T17:27:00) ". Format of cron expressions is " cron(Minutes Hours
	// Day-of-month Month Day-of-week Year) ". For example, " cron(0 10 ? * MON *) ".
	// For more information, see Cron Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	// in the Amazon CloudWatch Events User Guide.
	Schedule Schedule

	// The description of the scheduled action.
	ScheduledActionDescription *string

	// The name of the scheduled action.
	ScheduledActionName *string

	// The uuid of the scheduled action.
	ScheduledActionUuid *string

	// The start time in UTC when the schedule is active. Before this time, the
	// scheduled action does not trigger.
	StartTime *time.Time

	// The state of the scheduled action.
	State State

	// A JSON format string of the Amazon Redshift Serverless API operation with input
	// parameters. The following is an example of a target action. "{"CreateSnapshot":
	// {"NamespaceName": "sampleNamespace","SnapshotName": "sampleSnapshot",
	// "retentionPeriod": "1"}}"
	TargetAction TargetAction

	noSmithyDocumentSerde
}

// A snapshot object that contains databases.
type Snapshot struct {

	// All of the Amazon Web Services accounts that have access to restore a snapshot
	// to a provisioned cluster.
	AccountsWithProvisionedRestoreAccess []string

	// All of the Amazon Web Services accounts that have access to restore a snapshot
	// to a namespace.
	AccountsWithRestoreAccess []string

	// The size of the incremental backup in megabytes.
	ActualIncrementalBackupSizeInMegaBytes *float64

	// The Amazon Resource Name (ARN) for the namespace's admin user credentials
	// secret.
	AdminPasswordSecretArn *string

	// The ID of the Key Management Service (KMS) key used to encrypt and store the
	// namespace's admin credentials secret.
	AdminPasswordSecretKmsKeyId *string

	// The username of the database within a snapshot.
	AdminUsername *string

	// The size in megabytes of the data that has been backed up to a snapshot.
	BackupProgressInMegaBytes *float64

	// The rate at which data is backed up into a snapshot in megabytes per second.
	CurrentBackupRateInMegaBytesPerSecond *float64

	// The amount of time it took to back up data into a snapshot.
	ElapsedTimeInSeconds *int64

	// The estimated amount of seconds until the snapshot completes backup.
	EstimatedSecondsToCompletion *int64

	// The unique identifier of the KMS key used to encrypt the snapshot.
	KmsKeyId *string

	// The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
	NamespaceArn *string

	// The name of the namepsace.
	NamespaceName *string

	// The owner Amazon Web Services; account of the snapshot.
	OwnerAccount *string

	// The Amazon Resource Name (ARN) of the snapshot.
	SnapshotArn *string

	// The timestamp of when the snapshot was created.
	SnapshotCreateTime *time.Time

	// The name of the snapshot.
	SnapshotName *string

	// The amount of days until the snapshot is deleted.
	SnapshotRemainingDays *int32

	// The period of time, in days, of how long the snapshot is retained.
	SnapshotRetentionPeriod *int32

	// The timestamp of when data within the snapshot started getting retained.
	SnapshotRetentionStartTime *time.Time

	// The status of the snapshot.
	Status SnapshotStatus

	// The total size, in megabytes, of how big the snapshot is.
	TotalBackupSizeInMegaBytes *float64

	noSmithyDocumentSerde
}

// The object that you configure to copy snapshots from one namespace to a
// namespace in another Amazon Web Services Region.
type SnapshotCopyConfiguration struct {

	// The ID of the KMS key to use to encrypt your snapshots in the destination
	// Amazon Web Services Region.
	DestinationKmsKeyId *string

	// The destination Amazon Web Services Region to copy snapshots to.
	DestinationRegion *string

	// The name of the namespace to copy snapshots from in the source Amazon Web
	// Services Region.
	NamespaceName *string

	// The ARN of the snapshot copy configuration object.
	SnapshotCopyConfigurationArn *string

	// The ID of the snapshot copy configuration object.
	SnapshotCopyConfigurationId *string

	// The retention period of snapshots that are copied to the destination Amazon Web
	// Services Region.
	SnapshotRetentionPeriod *int32

	noSmithyDocumentSerde
}

// Contains information about a table restore request.
type TableRestoreStatus struct {

	// A message that explains the returned status. For example, if the status of the
	// operation is FAILED , the message explains why the operation failed.
	Message *string

	// The namespace of the table being restored from.
	NamespaceName *string

	// The name of the table to create from the restore operation.
	NewTableName *string

	// The amount of data restored to the new table so far, in megabytes (MB).
	ProgressInMegaBytes *int64

	// The ID of the recovery point being restored from.
	RecoveryPointId *string

	// The time that the table restore request was made, in Universal Coordinated Time
	// (UTC).
	RequestTime *time.Time

	// The name of the snapshot being restored from.
	SnapshotName *string

	// The name of the source database being restored from.
	SourceDatabaseName *string

	// The name of the source schema being restored from.
	SourceSchemaName *string

	// The name of the source table being restored from.
	SourceTableName *string

	// A value that describes the current state of the table restore request. Possible
	// values are SUCCEEDED , FAILED , CANCELED , PENDING , and IN_PROGRESS .
	Status *string

	// The ID of the RestoreTableFromSnapshot request.
	TableRestoreRequestId *string

	// The name of the database to restore to.
	TargetDatabaseName *string

	// The name of the schema to restore to.
	TargetSchemaName *string

	// The total amount of data to restore to the new table, in megabytes (MB).
	TotalDataInMegaBytes *int64

	// The name of the workgroup being restored from.
	WorkgroupName *string

	noSmithyDocumentSerde
}

// A map of key-value pairs.
type Tag struct {

	// The key to use in the tag.
	//
	// This member is required.
	Key *string

	// The value of the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A JSON format string of the Amazon Redshift Serverless API operation with input
// parameters. The following is an example of a target action. "{"CreateSnapshot":
// {"NamespaceName": "sampleNamespace","SnapshotName": "sampleSnapshot",
// "retentionPeriod": "1"}}"
//
// The following types satisfy this interface:
//
//	TargetActionMemberCreateSnapshot
type TargetAction interface {
	isTargetAction()
}

// The parameters that you can use to configure a scheduled action (https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html)
// to create a snapshot. For more information about creating a scheduled action,
// see CreateScheduledAction (https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html)
// .
type TargetActionMemberCreateSnapshot struct {
	Value CreateSnapshotScheduleActionParameters

	noSmithyDocumentSerde
}

func (*TargetActionMemberCreateSnapshot) isTargetAction() {}

// The usage limit object.
type UsageLimit struct {

	// The limit amount. If time-based, this amount is in RPUs consumed per hour. If
	// data-based, this amount is in terabytes (TB). The value must be a positive
	// number.
	Amount *int64

	// The action that Amazon Redshift Serverless takes when the limit is reached.
	BreachAction UsageLimitBreachAction

	// The time period that the amount applies to. A weekly period begins on Sunday.
	// The default is monthly.
	Period UsageLimitPeriod

	// The Amazon Resource Name (ARN) that identifies the Amazon Redshift Serverless
	// resource.
	ResourceArn *string

	// The Amazon Resource Name (ARN) of the resource associated with the usage limit.
	UsageLimitArn *string

	// The identifier of the usage limit.
	UsageLimitId *string

	// The Amazon Redshift Serverless feature to limit.
	UsageType UsageLimitUsageType

	noSmithyDocumentSerde
}

// The connection endpoint for connecting to Amazon Redshift Serverless through
// the proxy.
type VpcEndpoint struct {

	// One or more network interfaces of the endpoint. Also known as an interface
	// endpoint.
	NetworkInterfaces []NetworkInterface

	// The connection endpoint ID for connecting to Amazon Redshift Serverless.
	VpcEndpointId *string

	// The VPC identifier that the endpoint is associated with.
	VpcId *string

	noSmithyDocumentSerde
}

// Describes the members of a VPC security group.
type VpcSecurityGroupMembership struct {

	// The status of the VPC security group.
	Status *string

	// The unique identifier of the VPC security group.
	VpcSecurityGroupId *string

	noSmithyDocumentSerde
}

// The collection of computing resources from which an endpoint is created.
type Workgroup struct {

	// The base data warehouse capacity of the workgroup in Redshift Processing Units
	// (RPUs).
	BaseCapacity *int32

	// An array of parameters to set for advanced control over a database. The options
	// are auto_mv , datestyle , enable_case_sensitive_identifier ,
	// enable_user_activity_logging , query_group , search_path , require_ssl , and
	// query monitoring metrics that let you define performance boundaries. For more
	// information about query monitoring rules and available metrics, see Query
	// monitoring metrics for Amazon Redshift Serverless (https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless)
	// .
	ConfigParameters []ConfigParameter

	// The creation date of the workgroup.
	CreationDate *time.Time

	// A list of VPCs. Each entry is the unique identifier of a virtual private cloud
	// with access to Amazon Redshift Serverless. If all of the VPCs for the grantee
	// are allowed, it shows an asterisk.
	CrossAccountVpcs []string

	// The custom domain name’s certificate Amazon resource name (ARN).
	CustomDomainCertificateArn *string

	// The expiration time for the certificate.
	CustomDomainCertificateExpiryTime *time.Time

	// The custom domain name associated with the workgroup.
	CustomDomainName *string

	// The endpoint that is created from the workgroup.
	Endpoint *Endpoint

	// The value that specifies whether to enable enhanced virtual private cloud (VPC)
	// routing, which forces Amazon Redshift Serverless to route traffic through your
	// VPC.
	EnhancedVpcRouting *bool

	// The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve
	// queries. The max capacity is specified in RPUs.
	MaxCapacity *int32

	// The namespace the workgroup is associated with.
	NamespaceName *string

	// The patch version of your Amazon Redshift Serverless workgroup. For more
	// information about patch versions, see Cluster versions for Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html)
	// .
	PatchVersion *string

	// The custom port to use when connecting to a workgroup. Valid port ranges are
	// 5431-5455 and 8191-8215. The default is 5439.
	Port *int32

	// A value that specifies whether the workgroup can be accessible from a public
	// network
	PubliclyAccessible *bool

	// An array of security group IDs to associate with the workgroup.
	SecurityGroupIds []string

	// The status of the workgroup.
	Status WorkgroupStatus

	// An array of subnet IDs the workgroup is associated with.
	SubnetIds []string

	// The Amazon Resource Name (ARN) that links to the workgroup.
	WorkgroupArn *string

	// The unique identifier of the workgroup.
	WorkgroupId *string

	// The name of the workgroup.
	WorkgroupName *string

	// The Amazon Redshift Serverless version of your workgroup. For more information
	// about Amazon Redshift Serverless versions, see Cluster versions for Amazon
	// Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html)
	// .
	WorkgroupVersion *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isSchedule()     {}
func (*UnknownUnionMember) isTargetAction() {}
