// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This API is in preview release for Amazon Connect and is subject to change.
// Returns a paginated list of all approved origins associated with the instance.
func (c *Client) ListApprovedOrigins(ctx context.Context, params *ListApprovedOriginsInput, optFns ...func(*Options)) (*ListApprovedOriginsOutput, error) {
	if params == nil {
		params = &ListApprovedOriginsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListApprovedOrigins", params, optFns, c.addOperationListApprovedOriginsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListApprovedOriginsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListApprovedOriginsInput struct {

	// The identifier of the Amazon Connect instance. You can find the instance ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// This member is required.
	InstanceId *string

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListApprovedOriginsOutput struct {

	// If there are additional results, this is the token for the next set of results.
	NextToken *string

	// The approved origins.
	Origins []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListApprovedOriginsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListApprovedOrigins{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListApprovedOrigins{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListApprovedOrigins"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListApprovedOriginsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListApprovedOrigins(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListApprovedOriginsAPIClient is a client that implements the
// ListApprovedOrigins operation.
type ListApprovedOriginsAPIClient interface {
	ListApprovedOrigins(context.Context, *ListApprovedOriginsInput, ...func(*Options)) (*ListApprovedOriginsOutput, error)
}

var _ ListApprovedOriginsAPIClient = (*Client)(nil)

// ListApprovedOriginsPaginatorOptions is the paginator options for
// ListApprovedOrigins
type ListApprovedOriginsPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListApprovedOriginsPaginator is a paginator for ListApprovedOrigins
type ListApprovedOriginsPaginator struct {
	options   ListApprovedOriginsPaginatorOptions
	client    ListApprovedOriginsAPIClient
	params    *ListApprovedOriginsInput
	nextToken *string
	firstPage bool
}

// NewListApprovedOriginsPaginator returns a new ListApprovedOriginsPaginator
func NewListApprovedOriginsPaginator(client ListApprovedOriginsAPIClient, params *ListApprovedOriginsInput, optFns ...func(*ListApprovedOriginsPaginatorOptions)) *ListApprovedOriginsPaginator {
	if params == nil {
		params = &ListApprovedOriginsInput{}
	}

	options := ListApprovedOriginsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListApprovedOriginsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListApprovedOriginsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListApprovedOrigins page.
func (p *ListApprovedOriginsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListApprovedOriginsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListApprovedOrigins(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListApprovedOrigins(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListApprovedOrigins",
	}
}
