// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the specified registration type field definitions. You can use
// DescribeRegistrationFieldDefinitions to view the requirements for creating,
// filling out, and submitting each registration type.
func (c *Client) DescribeRegistrationFieldDefinitions(ctx context.Context, params *DescribeRegistrationFieldDefinitionsInput, optFns ...func(*Options)) (*DescribeRegistrationFieldDefinitionsOutput, error) {
	if params == nil {
		params = &DescribeRegistrationFieldDefinitionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeRegistrationFieldDefinitions", params, optFns, c.addOperationDescribeRegistrationFieldDefinitionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeRegistrationFieldDefinitionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeRegistrationFieldDefinitionsInput struct {

	// The type of registration form. The list of RegistrationTypes can be found using
	// the DescribeRegistrationTypeDefinitions action.
	//
	// This member is required.
	RegistrationType *string

	// An array of paths to the registration form field.
	FieldPaths []string

	// The maximum number of results to return per each request.
	MaxResults *int32

	// The token to be used for the next set of paginated results. You don't need to
	// supply a value for this field in the initial request.
	NextToken *string

	// The path to the section of the registration.
	SectionPath *string

	noSmithyDocumentSerde
}

type DescribeRegistrationFieldDefinitionsOutput struct {

	// An array of RegistrationFieldDefinitions objects that contain the details for
	// the requested fields.
	//
	// This member is required.
	RegistrationFieldDefinitions []types.RegistrationFieldDefinition

	// The type of registration form. The list of RegistrationTypes can be found using
	// the DescribeRegistrationTypeDefinitions action.
	//
	// This member is required.
	RegistrationType *string

	// The token to be used for the next set of paginated results. You don't need to
	// supply a value for this field in the initial request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeRegistrationFieldDefinitionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeRegistrationFieldDefinitions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeRegistrationFieldDefinitions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeRegistrationFieldDefinitions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeRegistrationFieldDefinitionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeRegistrationFieldDefinitions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeRegistrationFieldDefinitionsAPIClient is a client that implements the
// DescribeRegistrationFieldDefinitions operation.
type DescribeRegistrationFieldDefinitionsAPIClient interface {
	DescribeRegistrationFieldDefinitions(context.Context, *DescribeRegistrationFieldDefinitionsInput, ...func(*Options)) (*DescribeRegistrationFieldDefinitionsOutput, error)
}

var _ DescribeRegistrationFieldDefinitionsAPIClient = (*Client)(nil)

// DescribeRegistrationFieldDefinitionsPaginatorOptions is the paginator options
// for DescribeRegistrationFieldDefinitions
type DescribeRegistrationFieldDefinitionsPaginatorOptions struct {
	// The maximum number of results to return per each request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeRegistrationFieldDefinitionsPaginator is a paginator for
// DescribeRegistrationFieldDefinitions
type DescribeRegistrationFieldDefinitionsPaginator struct {
	options   DescribeRegistrationFieldDefinitionsPaginatorOptions
	client    DescribeRegistrationFieldDefinitionsAPIClient
	params    *DescribeRegistrationFieldDefinitionsInput
	nextToken *string
	firstPage bool
}

// NewDescribeRegistrationFieldDefinitionsPaginator returns a new
// DescribeRegistrationFieldDefinitionsPaginator
func NewDescribeRegistrationFieldDefinitionsPaginator(client DescribeRegistrationFieldDefinitionsAPIClient, params *DescribeRegistrationFieldDefinitionsInput, optFns ...func(*DescribeRegistrationFieldDefinitionsPaginatorOptions)) *DescribeRegistrationFieldDefinitionsPaginator {
	if params == nil {
		params = &DescribeRegistrationFieldDefinitionsInput{}
	}

	options := DescribeRegistrationFieldDefinitionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeRegistrationFieldDefinitionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeRegistrationFieldDefinitionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeRegistrationFieldDefinitions page.
func (p *DescribeRegistrationFieldDefinitionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeRegistrationFieldDefinitionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeRegistrationFieldDefinitions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeRegistrationFieldDefinitions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeRegistrationFieldDefinitions",
	}
}
