// Code generated by smithy-go-codegen DO NOT EDIT.

package securitylake

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securitylake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the Amazon Security Lake exceptions that you can use to find the source
// of problems and fix them.
func (c *Client) ListDataLakeExceptions(ctx context.Context, params *ListDataLakeExceptionsInput, optFns ...func(*Options)) (*ListDataLakeExceptionsOutput, error) {
	if params == nil {
		params = &ListDataLakeExceptionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataLakeExceptions", params, optFns, c.addOperationListDataLakeExceptionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataLakeExceptionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDataLakeExceptionsInput struct {

	// List the maximum number of failures in Security Lake.
	MaxResults *int32

	// List if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token to
	// retrieve the next page. Keep all other arguments unchanged. Each pagination
	// token expires after 24 hours. Using an expired pagination token will return an
	// HTTP 400 InvalidToken error.
	NextToken *string

	// The Amazon Web Services Regions from which exceptions are retrieved.
	Regions []string

	noSmithyDocumentSerde
}

type ListDataLakeExceptionsOutput struct {

	// Lists the failures that cannot be retried in the current Region.
	Exceptions []types.DataLakeException

	// List if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token to
	// retrieve the next page. Keep all other arguments unchanged. Each pagination
	// token expires after 24 hours. Using an expired pagination token will return an
	// HTTP 400 InvalidToken error.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataLakeExceptionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataLakeExceptions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataLakeExceptions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataLakeExceptions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataLakeExceptions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDataLakeExceptionsAPIClient is a client that implements the
// ListDataLakeExceptions operation.
type ListDataLakeExceptionsAPIClient interface {
	ListDataLakeExceptions(context.Context, *ListDataLakeExceptionsInput, ...func(*Options)) (*ListDataLakeExceptionsOutput, error)
}

var _ ListDataLakeExceptionsAPIClient = (*Client)(nil)

// ListDataLakeExceptionsPaginatorOptions is the paginator options for
// ListDataLakeExceptions
type ListDataLakeExceptionsPaginatorOptions struct {
	// List the maximum number of failures in Security Lake.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataLakeExceptionsPaginator is a paginator for ListDataLakeExceptions
type ListDataLakeExceptionsPaginator struct {
	options   ListDataLakeExceptionsPaginatorOptions
	client    ListDataLakeExceptionsAPIClient
	params    *ListDataLakeExceptionsInput
	nextToken *string
	firstPage bool
}

// NewListDataLakeExceptionsPaginator returns a new ListDataLakeExceptionsPaginator
func NewListDataLakeExceptionsPaginator(client ListDataLakeExceptionsAPIClient, params *ListDataLakeExceptionsInput, optFns ...func(*ListDataLakeExceptionsPaginatorOptions)) *ListDataLakeExceptionsPaginator {
	if params == nil {
		params = &ListDataLakeExceptionsInput{}
	}

	options := ListDataLakeExceptionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataLakeExceptionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataLakeExceptionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataLakeExceptions page.
func (p *ListDataLakeExceptionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataLakeExceptionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListDataLakeExceptions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListDataLakeExceptions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataLakeExceptions",
	}
}
