// Code generated by smithy-go-codegen DO NOT EDIT.

package emr

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/emr/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves release labels of Amazon EMR services in the Region where the API is
// called.
func (c *Client) ListReleaseLabels(ctx context.Context, params *ListReleaseLabelsInput, optFns ...func(*Options)) (*ListReleaseLabelsOutput, error) {
	if params == nil {
		params = &ListReleaseLabelsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListReleaseLabels", params, optFns, c.addOperationListReleaseLabelsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListReleaseLabelsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListReleaseLabelsInput struct {

	// Filters the results of the request. Prefix specifies the prefix of release
	// labels to return. Application specifies the application (with/without version)
	// of release labels to return.
	Filters *types.ReleaseLabelFilter

	// Defines the maximum number of release labels to return in a single response.
	// The default is 100 .
	MaxResults *int32

	// Specifies the next page of results. If NextToken is not specified, which is
	// usually the case for the first request of ListReleaseLabels, the first page of
	// results are determined by other filtering parameters or by the latest version.
	// The ListReleaseLabels request fails if the identity (Amazon Web Services
	// account ID) and all filtering parameters are different from the original
	// request, or if the NextToken is expired or tampered with.
	NextToken *string

	noSmithyDocumentSerde
}

type ListReleaseLabelsOutput struct {

	// Used to paginate the next page of results if specified in the next
	// ListReleaseLabels request.
	NextToken *string

	// The returned release labels.
	ReleaseLabels []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListReleaseLabelsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListReleaseLabels{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListReleaseLabels{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListReleaseLabels"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListReleaseLabels(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListReleaseLabelsPaginatorOptions is the paginator options for ListReleaseLabels
type ListReleaseLabelsPaginatorOptions struct {
	// Defines the maximum number of release labels to return in a single response.
	// The default is 100 .
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListReleaseLabelsPaginator is a paginator for ListReleaseLabels
type ListReleaseLabelsPaginator struct {
	options   ListReleaseLabelsPaginatorOptions
	client    ListReleaseLabelsAPIClient
	params    *ListReleaseLabelsInput
	nextToken *string
	firstPage bool
}

// NewListReleaseLabelsPaginator returns a new ListReleaseLabelsPaginator
func NewListReleaseLabelsPaginator(client ListReleaseLabelsAPIClient, params *ListReleaseLabelsInput, optFns ...func(*ListReleaseLabelsPaginatorOptions)) *ListReleaseLabelsPaginator {
	if params == nil {
		params = &ListReleaseLabelsInput{}
	}

	options := ListReleaseLabelsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListReleaseLabelsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListReleaseLabelsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListReleaseLabels page.
func (p *ListReleaseLabelsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListReleaseLabelsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListReleaseLabels(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListReleaseLabelsAPIClient is a client that implements the ListReleaseLabels
// operation.
type ListReleaseLabelsAPIClient interface {
	ListReleaseLabels(context.Context, *ListReleaseLabelsInput, ...func(*Options)) (*ListReleaseLabelsOutput, error)
}

var _ ListReleaseLabelsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListReleaseLabels(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListReleaseLabels",
	}
}
