// Code generated by smithy-go-codegen DO NOT EDIT.

package pi

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pi/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all the analysis reports created for the DB instance. The reports are
// sorted based on the start time of each report.
func (c *Client) ListPerformanceAnalysisReports(ctx context.Context, params *ListPerformanceAnalysisReportsInput, optFns ...func(*Options)) (*ListPerformanceAnalysisReportsOutput, error) {
	if params == nil {
		params = &ListPerformanceAnalysisReportsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPerformanceAnalysisReports", params, optFns, c.addOperationListPerformanceAnalysisReportsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPerformanceAnalysisReportsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPerformanceAnalysisReportsInput struct {

	// An immutable identifier for a data source that is unique for an Amazon Web
	// Services Region. Performance Insights gathers metrics from this data source. In
	// the console, the identifier is shown as ResourceID. When you call
	// DescribeDBInstances , the identifier is returned as DbiResourceId .
	//
	// To use a DB instance as a data source, specify its DbiResourceId value. For
	// example, specify db-ABCDEFGHIJKLMNOPQRSTU1VW2X .
	//
	// This member is required.
	Identifier *string

	// The Amazon Web Services service for which Performance Insights returns metrics.
	// Valid value is RDS .
	//
	// This member is required.
	ServiceType types.ServiceType

	// Specifies whether or not to include the list of tags in the response.
	ListTags *bool

	// The maximum number of items to return in the response. If more items exist than
	// the specified MaxResults value, a pagination token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int32

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to the
	// value specified by MaxResults .
	NextToken *string

	noSmithyDocumentSerde
}

type ListPerformanceAnalysisReportsOutput struct {

	// List of reports including the report identifier, start and end time, creation
	// time, and status.
	AnalysisReports []types.AnalysisReportSummary

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the token, up to the
	// value specified by MaxResults .
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPerformanceAnalysisReportsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListPerformanceAnalysisReports{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListPerformanceAnalysisReports{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPerformanceAnalysisReports"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListPerformanceAnalysisReportsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPerformanceAnalysisReports(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListPerformanceAnalysisReportsPaginatorOptions is the paginator options for
// ListPerformanceAnalysisReports
type ListPerformanceAnalysisReportsPaginatorOptions struct {
	// The maximum number of items to return in the response. If more items exist than
	// the specified MaxResults value, a pagination token is included in the response
	// so that the remaining results can be retrieved.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPerformanceAnalysisReportsPaginator is a paginator for
// ListPerformanceAnalysisReports
type ListPerformanceAnalysisReportsPaginator struct {
	options   ListPerformanceAnalysisReportsPaginatorOptions
	client    ListPerformanceAnalysisReportsAPIClient
	params    *ListPerformanceAnalysisReportsInput
	nextToken *string
	firstPage bool
}

// NewListPerformanceAnalysisReportsPaginator returns a new
// ListPerformanceAnalysisReportsPaginator
func NewListPerformanceAnalysisReportsPaginator(client ListPerformanceAnalysisReportsAPIClient, params *ListPerformanceAnalysisReportsInput, optFns ...func(*ListPerformanceAnalysisReportsPaginatorOptions)) *ListPerformanceAnalysisReportsPaginator {
	if params == nil {
		params = &ListPerformanceAnalysisReportsInput{}
	}

	options := ListPerformanceAnalysisReportsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPerformanceAnalysisReportsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPerformanceAnalysisReportsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPerformanceAnalysisReports page.
func (p *ListPerformanceAnalysisReportsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPerformanceAnalysisReportsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPerformanceAnalysisReports(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPerformanceAnalysisReportsAPIClient is a client that implements the
// ListPerformanceAnalysisReports operation.
type ListPerformanceAnalysisReportsAPIClient interface {
	ListPerformanceAnalysisReports(context.Context, *ListPerformanceAnalysisReportsInput, ...func(*Options)) (*ListPerformanceAnalysisReportsOutput, error)
}

var _ ListPerformanceAnalysisReportsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPerformanceAnalysisReports(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPerformanceAnalysisReports",
	}
}
