// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package route53domains provides a client for Amazon Route 53 Domains.
package route53domains

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCheckDomainAvailability = "CheckDomainAvailability"

// CheckDomainAvailabilityRequest generates a "aws/request.Request" representing the
// client's request for the CheckDomainAvailability operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CheckDomainAvailability for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CheckDomainAvailability method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CheckDomainAvailabilityRequest method.
//    req, resp := client.CheckDomainAvailabilityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) CheckDomainAvailabilityRequest(input *CheckDomainAvailabilityInput) (req *request.Request, output *CheckDomainAvailabilityOutput) {
	op := &request.Operation{
		Name:       opCheckDomainAvailability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CheckDomainAvailabilityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CheckDomainAvailabilityOutput{}
	req.Data = output
	return
}

// CheckDomainAvailability API operation for Amazon Route 53 Domains.
//
// This operation checks the availability of one domain name. Note that if the
// availability status of a domain is pending, you must submit another request
// to determine the availability of the domain name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation CheckDomainAvailability for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) CheckDomainAvailability(input *CheckDomainAvailabilityInput) (*CheckDomainAvailabilityOutput, error) {
	req, out := c.CheckDomainAvailabilityRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTagsForDomain = "DeleteTagsForDomain"

// DeleteTagsForDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTagsForDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTagsForDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTagsForDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTagsForDomainRequest method.
//    req, resp := client.DeleteTagsForDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) DeleteTagsForDomainRequest(input *DeleteTagsForDomainInput) (req *request.Request, output *DeleteTagsForDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteTagsForDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsForDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTagsForDomainOutput{}
	req.Data = output
	return
}

// DeleteTagsForDomain API operation for Amazon Route 53 Domains.
//
// This operation deletes the specified tags for a domain.
//
// All tag operations are eventually consistent; subsequent operations may not
// immediately represent all issued operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation DeleteTagsForDomain for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * OperationLimitExceeded
//   The number of operations or jobs running exceeded the allowed threshold for
//   the account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) DeleteTagsForDomain(input *DeleteTagsForDomainInput) (*DeleteTagsForDomainOutput, error) {
	req, out := c.DeleteTagsForDomainRequest(input)
	err := req.Send()
	return out, err
}

const opDisableDomainAutoRenew = "DisableDomainAutoRenew"

// DisableDomainAutoRenewRequest generates a "aws/request.Request" representing the
// client's request for the DisableDomainAutoRenew operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableDomainAutoRenew for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableDomainAutoRenew method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableDomainAutoRenewRequest method.
//    req, resp := client.DisableDomainAutoRenewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) DisableDomainAutoRenewRequest(input *DisableDomainAutoRenewInput) (req *request.Request, output *DisableDomainAutoRenewOutput) {
	op := &request.Operation{
		Name:       opDisableDomainAutoRenew,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableDomainAutoRenewInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableDomainAutoRenewOutput{}
	req.Data = output
	return
}

// DisableDomainAutoRenew API operation for Amazon Route 53 Domains.
//
// This operation disables automatic renewal of domain registration for the
// specified domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation DisableDomainAutoRenew for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) DisableDomainAutoRenew(input *DisableDomainAutoRenewInput) (*DisableDomainAutoRenewOutput, error) {
	req, out := c.DisableDomainAutoRenewRequest(input)
	err := req.Send()
	return out, err
}

const opDisableDomainTransferLock = "DisableDomainTransferLock"

// DisableDomainTransferLockRequest generates a "aws/request.Request" representing the
// client's request for the DisableDomainTransferLock operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableDomainTransferLock for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableDomainTransferLock method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableDomainTransferLockRequest method.
//    req, resp := client.DisableDomainTransferLockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) DisableDomainTransferLockRequest(input *DisableDomainTransferLockInput) (req *request.Request, output *DisableDomainTransferLockOutput) {
	op := &request.Operation{
		Name:       opDisableDomainTransferLock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableDomainTransferLockInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableDomainTransferLockOutput{}
	req.Data = output
	return
}

// DisableDomainTransferLock API operation for Amazon Route 53 Domains.
//
// This operation removes the transfer lock on the domain (specifically the
// clientTransferProhibited status) to allow domain transfers. We recommend
// you refrain from performing this action unless you intend to transfer the
// domain to a different registrar. Successful submission returns an operation
// ID that you can use to track the progress and completion of the action. If
// the request is not completed successfully, the domain registrant will be
// notified by email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation DisableDomainTransferLock for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * DuplicateRequest
//   The request is already in progress for the domain.
//
//   * TLDRulesViolation
//   The top-level domain does not support this operation.
//
//   * OperationLimitExceeded
//   The number of operations or jobs running exceeded the allowed threshold for
//   the account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) DisableDomainTransferLock(input *DisableDomainTransferLockInput) (*DisableDomainTransferLockOutput, error) {
	req, out := c.DisableDomainTransferLockRequest(input)
	err := req.Send()
	return out, err
}

const opEnableDomainAutoRenew = "EnableDomainAutoRenew"

// EnableDomainAutoRenewRequest generates a "aws/request.Request" representing the
// client's request for the EnableDomainAutoRenew operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableDomainAutoRenew for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableDomainAutoRenew method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableDomainAutoRenewRequest method.
//    req, resp := client.EnableDomainAutoRenewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) EnableDomainAutoRenewRequest(input *EnableDomainAutoRenewInput) (req *request.Request, output *EnableDomainAutoRenewOutput) {
	op := &request.Operation{
		Name:       opEnableDomainAutoRenew,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableDomainAutoRenewInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableDomainAutoRenewOutput{}
	req.Data = output
	return
}

// EnableDomainAutoRenew API operation for Amazon Route 53 Domains.
//
// This operation configures Amazon Route 53 to automatically renew the specified
// domain before the domain registration expires. The cost of renewing your
// domain registration is billed to your AWS account.
//
// The period during which you can renew a domain name varies by TLD. For a
// list of TLDs and their renewal policies, see "Renewal, restoration, and deletion
// times" (http://wiki.gandi.net/en/domains/renew#renewal_restoration_and_deletion_times)
// on the website for our registrar partner, Gandi. Route 53 requires that you
// renew before the end of the renewal period that is listed on the Gandi website
// so we can complete processing before the deadline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation EnableDomainAutoRenew for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
//   * TLDRulesViolation
//   The top-level domain does not support this operation.
//
func (c *Route53Domains) EnableDomainAutoRenew(input *EnableDomainAutoRenewInput) (*EnableDomainAutoRenewOutput, error) {
	req, out := c.EnableDomainAutoRenewRequest(input)
	err := req.Send()
	return out, err
}

const opEnableDomainTransferLock = "EnableDomainTransferLock"

// EnableDomainTransferLockRequest generates a "aws/request.Request" representing the
// client's request for the EnableDomainTransferLock operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableDomainTransferLock for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableDomainTransferLock method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableDomainTransferLockRequest method.
//    req, resp := client.EnableDomainTransferLockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) EnableDomainTransferLockRequest(input *EnableDomainTransferLockInput) (req *request.Request, output *EnableDomainTransferLockOutput) {
	op := &request.Operation{
		Name:       opEnableDomainTransferLock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableDomainTransferLockInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableDomainTransferLockOutput{}
	req.Data = output
	return
}

// EnableDomainTransferLock API operation for Amazon Route 53 Domains.
//
// This operation sets the transfer lock on the domain (specifically the clientTransferProhibited
// status) to prevent domain transfers. Successful submission returns an operation
// ID that you can use to track the progress and completion of the action. If
// the request is not completed successfully, the domain registrant will be
// notified by email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation EnableDomainTransferLock for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * DuplicateRequest
//   The request is already in progress for the domain.
//
//   * TLDRulesViolation
//   The top-level domain does not support this operation.
//
//   * OperationLimitExceeded
//   The number of operations or jobs running exceeded the allowed threshold for
//   the account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) EnableDomainTransferLock(input *EnableDomainTransferLockInput) (*EnableDomainTransferLockOutput, error) {
	req, out := c.EnableDomainTransferLockRequest(input)
	err := req.Send()
	return out, err
}

const opGetContactReachabilityStatus = "GetContactReachabilityStatus"

// GetContactReachabilityStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetContactReachabilityStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetContactReachabilityStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetContactReachabilityStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetContactReachabilityStatusRequest method.
//    req, resp := client.GetContactReachabilityStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) GetContactReachabilityStatusRequest(input *GetContactReachabilityStatusInput) (req *request.Request, output *GetContactReachabilityStatusOutput) {
	op := &request.Operation{
		Name:       opGetContactReachabilityStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContactReachabilityStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetContactReachabilityStatusOutput{}
	req.Data = output
	return
}

// GetContactReachabilityStatus API operation for Amazon Route 53 Domains.
//
// For operations that require confirmation that the email address for the registrant
// contact is valid, such as registering a new domain, this operation returns
// information about whether the registrant contact has responded.
//
// If you want us to resend the email, use the ResendContactReachabilityEmail
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation GetContactReachabilityStatus for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * OperationLimitExceeded
//   The number of operations or jobs running exceeded the allowed threshold for
//   the account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) GetContactReachabilityStatus(input *GetContactReachabilityStatusInput) (*GetContactReachabilityStatusOutput, error) {
	req, out := c.GetContactReachabilityStatusRequest(input)
	err := req.Send()
	return out, err
}

const opGetDomainDetail = "GetDomainDetail"

// GetDomainDetailRequest generates a "aws/request.Request" representing the
// client's request for the GetDomainDetail operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDomainDetail for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDomainDetail method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDomainDetailRequest method.
//    req, resp := client.GetDomainDetailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) GetDomainDetailRequest(input *GetDomainDetailInput) (req *request.Request, output *GetDomainDetailOutput) {
	op := &request.Operation{
		Name:       opGetDomainDetail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDomainDetailInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDomainDetailOutput{}
	req.Data = output
	return
}

// GetDomainDetail API operation for Amazon Route 53 Domains.
//
// This operation returns detailed information about the domain. The domain's
// contact information is also returned as part of the output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation GetDomainDetail for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) GetDomainDetail(input *GetDomainDetailInput) (*GetDomainDetailOutput, error) {
	req, out := c.GetDomainDetailRequest(input)
	err := req.Send()
	return out, err
}

const opGetDomainSuggestions = "GetDomainSuggestions"

// GetDomainSuggestionsRequest generates a "aws/request.Request" representing the
// client's request for the GetDomainSuggestions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetDomainSuggestions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetDomainSuggestions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetDomainSuggestionsRequest method.
//    req, resp := client.GetDomainSuggestionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) GetDomainSuggestionsRequest(input *GetDomainSuggestionsInput) (req *request.Request, output *GetDomainSuggestionsOutput) {
	op := &request.Operation{
		Name:       opGetDomainSuggestions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDomainSuggestionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDomainSuggestionsOutput{}
	req.Data = output
	return
}

// GetDomainSuggestions API operation for Amazon Route 53 Domains.
//
// The GetDomainSuggestions operation returns a list of suggested domain names
// given a string, which can either be a domain name or simply a word or phrase
// (without spaces).
//
// Parameters: DomainName (string): The basis for your domain suggestion search,
// a string with (or without) top-level domain specified.
// SuggestionCount (int): The number of domain suggestions to be returned, maximum
// 50, minimum 1.
// OnlyAvailable (bool): If true, availability check will be performed on suggestion
// results, and only available domains will be returned. If false, suggestions
// will be returned without checking whether the domain is actually available,
// and caller will have to call checkDomainAvailability for each suggestion
// to determine availability for registration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation GetDomainSuggestions for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) GetDomainSuggestions(input *GetDomainSuggestionsInput) (*GetDomainSuggestionsOutput, error) {
	req, out := c.GetDomainSuggestionsRequest(input)
	err := req.Send()
	return out, err
}

const opGetOperationDetail = "GetOperationDetail"

// GetOperationDetailRequest generates a "aws/request.Request" representing the
// client's request for the GetOperationDetail operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetOperationDetail for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetOperationDetail method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetOperationDetailRequest method.
//    req, resp := client.GetOperationDetailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) GetOperationDetailRequest(input *GetOperationDetailInput) (req *request.Request, output *GetOperationDetailOutput) {
	op := &request.Operation{
		Name:       opGetOperationDetail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationDetailInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetOperationDetailOutput{}
	req.Data = output
	return
}

// GetOperationDetail API operation for Amazon Route 53 Domains.
//
// This operation returns the current status of an operation that is not completed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation GetOperationDetail for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
func (c *Route53Domains) GetOperationDetail(input *GetOperationDetailInput) (*GetOperationDetailOutput, error) {
	req, out := c.GetOperationDetailRequest(input)
	err := req.Send()
	return out, err
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomains operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDomains for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDomains method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDomainsRequest method.
//    req, resp := client.ListDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextPageMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDomainsOutput{}
	req.Data = output
	return
}

// ListDomains API operation for Amazon Route 53 Domains.
//
// This operation returns all the domain names registered with Amazon Route
// 53 for the current AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation ListDomains for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
func (c *Route53Domains) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	err := req.Send()
	return out, err
}

// ListDomainsPages iterates over the pages of a ListDomains operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomains method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDomains operation.
//    pageNum := 0
//    err := client.ListDomainsPages(params,
//        func(page *ListDomainsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53Domains) ListDomainsPages(input *ListDomainsInput, fn func(p *ListDomainsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDomainsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDomainsOutput), lastPage)
	})
}

const opListOperations = "ListOperations"

// ListOperationsRequest generates a "aws/request.Request" representing the
// client's request for the ListOperations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListOperations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListOperations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListOperationsRequest method.
//    req, resp := client.ListOperationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) ListOperationsRequest(input *ListOperationsInput) (req *request.Request, output *ListOperationsOutput) {
	op := &request.Operation{
		Name:       opListOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextPageMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOperationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListOperationsOutput{}
	req.Data = output
	return
}

// ListOperations API operation for Amazon Route 53 Domains.
//
// This operation returns the operation IDs of operations that are not yet complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation ListOperations for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
func (c *Route53Domains) ListOperations(input *ListOperationsInput) (*ListOperationsOutput, error) {
	req, out := c.ListOperationsRequest(input)
	err := req.Send()
	return out, err
}

// ListOperationsPages iterates over the pages of a ListOperations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOperations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOperations operation.
//    pageNum := 0
//    err := client.ListOperationsPages(params,
//        func(page *ListOperationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Route53Domains) ListOperationsPages(input *ListOperationsInput, fn func(p *ListOperationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListOperationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListOperationsOutput), lastPage)
	})
}

const opListTagsForDomain = "ListTagsForDomain"

// ListTagsForDomainRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTagsForDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTagsForDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTagsForDomainRequest method.
//    req, resp := client.ListTagsForDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) ListTagsForDomainRequest(input *ListTagsForDomainInput) (req *request.Request, output *ListTagsForDomainOutput) {
	op := &request.Operation{
		Name:       opListTagsForDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForDomainOutput{}
	req.Data = output
	return
}

// ListTagsForDomain API operation for Amazon Route 53 Domains.
//
// This operation returns all of the tags that are associated with the specified
// domain.
//
// All tag operations are eventually consistent; subsequent operations may not
// immediately represent all issued operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation ListTagsForDomain for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * OperationLimitExceeded
//   The number of operations or jobs running exceeded the allowed threshold for
//   the account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) ListTagsForDomain(input *ListTagsForDomainInput) (*ListTagsForDomainOutput, error) {
	req, out := c.ListTagsForDomainRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterDomain = "RegisterDomain"

// RegisterDomainRequest generates a "aws/request.Request" representing the
// client's request for the RegisterDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RegisterDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RegisterDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RegisterDomainRequest method.
//    req, resp := client.RegisterDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) RegisterDomainRequest(input *RegisterDomainInput) (req *request.Request, output *RegisterDomainOutput) {
	op := &request.Operation{
		Name:       opRegisterDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterDomainOutput{}
	req.Data = output
	return
}

// RegisterDomain API operation for Amazon Route 53 Domains.
//
// This operation registers a domain. Domains are registered by the AWS registrar
// partner, Gandi. For some top-level domains (TLDs), this operation requires
// extra parameters.
//
// When you register a domain, Amazon Route 53 does the following:
//
//    * Creates a Amazon Route 53 hosted zone that has the same name as the
//    domain. Amazon Route 53 assigns four name servers to your hosted zone
//    and automatically updates your domain registration with the names of these
//    name servers.
//    * Enables autorenew, so your domain registration will renew automatically
//    each year. We'll notify you in advance of the renewal date so you can
//    choose whether to renew the registration.
//    * Optionally enables privacy protection, so WHOIS queries return contact
//    information for our registrar partner, Gandi, instead of the information
//    you entered for registrant, admin, and tech contacts.
//    * If registration is successful, returns an operation ID that you can
//    use to track the progress and completion of the action. If the request
//    is not completed successfully, the domain registrant is notified by email.
//
//    * Charges your AWS account an amount based on the top-level domain. For
//    more information, see Amazon Route 53 Pricing (http://aws.amazon.com/route53/pricing/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation RegisterDomain for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
//   * DuplicateRequest
//   The request is already in progress for the domain.
//
//   * TLDRulesViolation
//   The top-level domain does not support this operation.
//
//   * DomainLimitExceeded
//   The number of domains has exceeded the allowed threshold for the account.
//
//   * OperationLimitExceeded
//   The number of operations or jobs running exceeded the allowed threshold for
//   the account.
//
func (c *Route53Domains) RegisterDomain(input *RegisterDomainInput) (*RegisterDomainOutput, error) {
	req, out := c.RegisterDomainRequest(input)
	err := req.Send()
	return out, err
}

const opRenewDomain = "RenewDomain"

// RenewDomainRequest generates a "aws/request.Request" representing the
// client's request for the RenewDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RenewDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RenewDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RenewDomainRequest method.
//    req, resp := client.RenewDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) RenewDomainRequest(input *RenewDomainInput) (req *request.Request, output *RenewDomainOutput) {
	op := &request.Operation{
		Name:       opRenewDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RenewDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RenewDomainOutput{}
	req.Data = output
	return
}

// RenewDomain API operation for Amazon Route 53 Domains.
//
// This operation renews a domain for the specified number of years. The cost
// of renewing your domain is billed to your AWS account.
//
// We recommend that you renew your domain several weeks before the expiration
// date. Some TLD registries delete domains before the expiration date if you
// haven't renewed far enough in advance. For more information about renewing
// domain registration, see Renewing Registration for a Domain (http://docs.aws.amazon.com/console/route53/domain-renew)
// in the Amazon Route 53 documentation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation RenewDomain for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
//   * DuplicateRequest
//   The request is already in progress for the domain.
//
//   * TLDRulesViolation
//   The top-level domain does not support this operation.
//
//   * OperationLimitExceeded
//   The number of operations or jobs running exceeded the allowed threshold for
//   the account.
//
func (c *Route53Domains) RenewDomain(input *RenewDomainInput) (*RenewDomainOutput, error) {
	req, out := c.RenewDomainRequest(input)
	err := req.Send()
	return out, err
}

const opResendContactReachabilityEmail = "ResendContactReachabilityEmail"

// ResendContactReachabilityEmailRequest generates a "aws/request.Request" representing the
// client's request for the ResendContactReachabilityEmail operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResendContactReachabilityEmail for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResendContactReachabilityEmail method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResendContactReachabilityEmailRequest method.
//    req, resp := client.ResendContactReachabilityEmailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) ResendContactReachabilityEmailRequest(input *ResendContactReachabilityEmailInput) (req *request.Request, output *ResendContactReachabilityEmailOutput) {
	op := &request.Operation{
		Name:       opResendContactReachabilityEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResendContactReachabilityEmailInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ResendContactReachabilityEmailOutput{}
	req.Data = output
	return
}

// ResendContactReachabilityEmail API operation for Amazon Route 53 Domains.
//
// For operations that require confirmation that the email address for the registrant
// contact is valid, such as registering a new domain, this operation resends
// the confirmation email to the current email address for the registrant contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation ResendContactReachabilityEmail for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * OperationLimitExceeded
//   The number of operations or jobs running exceeded the allowed threshold for
//   the account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) ResendContactReachabilityEmail(input *ResendContactReachabilityEmailInput) (*ResendContactReachabilityEmailOutput, error) {
	req, out := c.ResendContactReachabilityEmailRequest(input)
	err := req.Send()
	return out, err
}

const opRetrieveDomainAuthCode = "RetrieveDomainAuthCode"

// RetrieveDomainAuthCodeRequest generates a "aws/request.Request" representing the
// client's request for the RetrieveDomainAuthCode operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RetrieveDomainAuthCode for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RetrieveDomainAuthCode method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RetrieveDomainAuthCodeRequest method.
//    req, resp := client.RetrieveDomainAuthCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) RetrieveDomainAuthCodeRequest(input *RetrieveDomainAuthCodeInput) (req *request.Request, output *RetrieveDomainAuthCodeOutput) {
	op := &request.Operation{
		Name:       opRetrieveDomainAuthCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveDomainAuthCodeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RetrieveDomainAuthCodeOutput{}
	req.Data = output
	return
}

// RetrieveDomainAuthCode API operation for Amazon Route 53 Domains.
//
// This operation returns the AuthCode for the domain. To transfer a domain
// to another registrar, you provide this value to the new registrar.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation RetrieveDomainAuthCode for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) RetrieveDomainAuthCode(input *RetrieveDomainAuthCodeInput) (*RetrieveDomainAuthCodeOutput, error) {
	req, out := c.RetrieveDomainAuthCodeRequest(input)
	err := req.Send()
	return out, err
}

const opTransferDomain = "TransferDomain"

// TransferDomainRequest generates a "aws/request.Request" representing the
// client's request for the TransferDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TransferDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TransferDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TransferDomainRequest method.
//    req, resp := client.TransferDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) TransferDomainRequest(input *TransferDomainInput) (req *request.Request, output *TransferDomainOutput) {
	op := &request.Operation{
		Name:       opTransferDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TransferDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TransferDomainOutput{}
	req.Data = output
	return
}

// TransferDomain API operation for Amazon Route 53 Domains.
//
// This operation transfers a domain from another registrar to Amazon Route
// 53. When the transfer is complete, the domain is registered with the AWS
// registrar partner, Gandi.
//
// For transfer requirements, a detailed procedure, and information about viewing
// the status of a domain transfer, see Transferring Registration for a Domain
// to Amazon Route 53 (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-transfer-to-route-53.html)
// in the Amazon Route 53 Developer Guide.
//
// If the registrar for your domain is also the DNS service provider for the
// domain, we highly recommend that you consider transferring your DNS service
// to Amazon Route 53 or to another DNS service provider before you transfer
// your registration. Some registrars provide free DNS service when you purchase
// a domain registration. When you transfer the registration, the previous registrar
// will not renew your domain registration and could end your DNS service at
// any time.
//
// Caution! If the registrar for your domain is also the DNS service provider
// for the domain and you don't transfer DNS service to another provider, your
// website, email, and the web applications associated with the domain might
// become unavailable.If the transfer is successful, this method returns an operation ID that you
// can use to track the progress and completion of the action. If the transfer
// doesn't complete successfully, the domain registrant will be notified by
// email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation TransferDomain for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
//   * DuplicateRequest
//   The request is already in progress for the domain.
//
//   * TLDRulesViolation
//   The top-level domain does not support this operation.
//
//   * DomainLimitExceeded
//   The number of domains has exceeded the allowed threshold for the account.
//
//   * OperationLimitExceeded
//   The number of operations or jobs running exceeded the allowed threshold for
//   the account.
//
func (c *Route53Domains) TransferDomain(input *TransferDomainInput) (*TransferDomainOutput, error) {
	req, out := c.TransferDomainRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDomainContact = "UpdateDomainContact"

// UpdateDomainContactRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomainContact operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateDomainContact for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateDomainContact method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateDomainContactRequest method.
//    req, resp := client.UpdateDomainContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) UpdateDomainContactRequest(input *UpdateDomainContactInput) (req *request.Request, output *UpdateDomainContactOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainContactInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateDomainContactOutput{}
	req.Data = output
	return
}

// UpdateDomainContact API operation for Amazon Route 53 Domains.
//
// This operation updates the contact information for a particular domain. Information
// for at least one contact (registrant, administrator, or technical) must be
// supplied for update.
//
// If the update is successful, this method returns an operation ID that you
// can use to track the progress and completion of the action. If the request
// is not completed successfully, the domain registrant will be notified by
// email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation UpdateDomainContact for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * DuplicateRequest
//   The request is already in progress for the domain.
//
//   * TLDRulesViolation
//   The top-level domain does not support this operation.
//
//   * OperationLimitExceeded
//   The number of operations or jobs running exceeded the allowed threshold for
//   the account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) UpdateDomainContact(input *UpdateDomainContactInput) (*UpdateDomainContactOutput, error) {
	req, out := c.UpdateDomainContactRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDomainContactPrivacy = "UpdateDomainContactPrivacy"

// UpdateDomainContactPrivacyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomainContactPrivacy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateDomainContactPrivacy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateDomainContactPrivacy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateDomainContactPrivacyRequest method.
//    req, resp := client.UpdateDomainContactPrivacyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) UpdateDomainContactPrivacyRequest(input *UpdateDomainContactPrivacyInput) (req *request.Request, output *UpdateDomainContactPrivacyOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainContactPrivacy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainContactPrivacyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateDomainContactPrivacyOutput{}
	req.Data = output
	return
}

// UpdateDomainContactPrivacy API operation for Amazon Route 53 Domains.
//
// This operation updates the specified domain contact's privacy setting. When
// the privacy option is enabled, personal information such as postal or email
// address is hidden from the results of a public WHOIS query. The privacy services
// are provided by the AWS registrar, Gandi. For more information, see the Gandi
// privacy features (http://www.gandi.net/domain/whois/?currency=USD&lang=en).
//
// This operation only affects the privacy of the specified contact type (registrant,
// administrator, or tech). Successful acceptance returns an operation ID that
// you can use with GetOperationDetail to track the progress and completion
// of the action. If the request is not completed successfully, the domain registrant
// will be notified by email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation UpdateDomainContactPrivacy for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * DuplicateRequest
//   The request is already in progress for the domain.
//
//   * TLDRulesViolation
//   The top-level domain does not support this operation.
//
//   * OperationLimitExceeded
//   The number of operations or jobs running exceeded the allowed threshold for
//   the account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) UpdateDomainContactPrivacy(input *UpdateDomainContactPrivacyInput) (*UpdateDomainContactPrivacyOutput, error) {
	req, out := c.UpdateDomainContactPrivacyRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDomainNameservers = "UpdateDomainNameservers"

// UpdateDomainNameserversRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomainNameservers operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateDomainNameservers for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateDomainNameservers method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateDomainNameserversRequest method.
//    req, resp := client.UpdateDomainNameserversRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) UpdateDomainNameserversRequest(input *UpdateDomainNameserversInput) (req *request.Request, output *UpdateDomainNameserversOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainNameservers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainNameserversInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateDomainNameserversOutput{}
	req.Data = output
	return
}

// UpdateDomainNameservers API operation for Amazon Route 53 Domains.
//
// This operation replaces the current set of name servers for the domain with
// the specified set of name servers. If you use Amazon Route 53 as your DNS
// service, specify the four name servers in the delegation set for the hosted
// zone for the domain.
//
// If successful, this operation returns an operation ID that you can use to
// track the progress and completion of the action. If the request is not completed
// successfully, the domain registrant will be notified by email.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation UpdateDomainNameservers for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * DuplicateRequest
//   The request is already in progress for the domain.
//
//   * TLDRulesViolation
//   The top-level domain does not support this operation.
//
//   * OperationLimitExceeded
//   The number of operations or jobs running exceeded the allowed threshold for
//   the account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) UpdateDomainNameservers(input *UpdateDomainNameserversInput) (*UpdateDomainNameserversOutput, error) {
	req, out := c.UpdateDomainNameserversRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateTagsForDomain = "UpdateTagsForDomain"

// UpdateTagsForDomainRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTagsForDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateTagsForDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateTagsForDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateTagsForDomainRequest method.
//    req, resp := client.UpdateTagsForDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) UpdateTagsForDomainRequest(input *UpdateTagsForDomainInput) (req *request.Request, output *UpdateTagsForDomainOutput) {
	op := &request.Operation{
		Name:       opUpdateTagsForDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTagsForDomainInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateTagsForDomainOutput{}
	req.Data = output
	return
}

// UpdateTagsForDomain API operation for Amazon Route 53 Domains.
//
// This operation adds or updates tags for a specified domain.
//
// All tag operations are eventually consistent; subsequent operations may not
// immediately represent all issued operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation UpdateTagsForDomain for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
//   * OperationLimitExceeded
//   The number of operations or jobs running exceeded the allowed threshold for
//   the account.
//
//   * UnsupportedTLD
//   Amazon Route 53 does not support this top-level domain.
//
func (c *Route53Domains) UpdateTagsForDomain(input *UpdateTagsForDomainInput) (*UpdateTagsForDomainOutput, error) {
	req, out := c.UpdateTagsForDomainRequest(input)
	err := req.Send()
	return out, err
}

const opViewBilling = "ViewBilling"

// ViewBillingRequest generates a "aws/request.Request" representing the
// client's request for the ViewBilling operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ViewBilling for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ViewBilling method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ViewBillingRequest method.
//    req, resp := client.ViewBillingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *Route53Domains) ViewBillingRequest(input *ViewBillingInput) (req *request.Request, output *ViewBillingOutput) {
	op := &request.Operation{
		Name:       opViewBilling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ViewBillingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ViewBillingOutput{}
	req.Data = output
	return
}

// ViewBilling API operation for Amazon Route 53 Domains.
//
// This operation returns all the domain-related billing records for the current
// AWS account for a specified period
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Domains's
// API operation ViewBilling for usage and error information.
//
// Returned Error Codes:
//   * InvalidInput
//   The requested item is not acceptable. For example, for an OperationId it
//   may refer to the ID of an operation that is already completed. For a domain
//   name, it may not be a valid domain name or belong to the requester account.
//
func (c *Route53Domains) ViewBilling(input *ViewBillingInput) (*ViewBillingOutput, error) {
	req, out := c.ViewBillingRequest(input)
	err := req.Send()
	return out, err
}

type BillingRecord struct {
	_ struct{} `type:"structure"`

	// The date that the operation was billed, in Unix format.
	//
	// Type: Double
	BillDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of a domain.
	//
	// Type: String
	DomainName *string `type:"string"`

	// The ID of the invoice that is associated with the billing record.
	//
	// Type: String
	InvoiceId *string `type:"string"`

	// The operation that you were charged for.
	//
	// Type: String
	//
	// Valid values: REGISTER_DOMAIN
	// TRANSFER_IN_DOMAIN
	// RENEW_DOMAIN
	// CHANGE_DOMAIN_OWNER
	Operation *string `type:"string" enum:"OperationType"`

	// The price that you were charged for the operation, in US dollars.
	//
	// Type: Double
	//
	// Example value: 12.0
	Price *float64 `type:"double"`
}

// String returns the string representation
func (s BillingRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BillingRecord) GoString() string {
	return s.String()
}

// The CheckDomainAvailability request contains the following elements.
type CheckDomainAvailabilityInput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// Reserved for future use.
	IdnLangCode *string `type:"string"`
}

// String returns the string representation
func (s CheckDomainAvailabilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckDomainAvailabilityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CheckDomainAvailabilityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CheckDomainAvailabilityInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The CheckDomainAvailability response includes the following elements.
type CheckDomainAvailabilityOutput struct {
	_ struct{} `type:"structure"`

	// Whether the domain name is available for registering.
	//
	// You can only register domains designated as AVAILABLE.
	//
	// Type: String
	//
	// Valid values:
	//
	//    * AVAILABLE – The domain name is available.
	//    * AVAILABLE_RESERVED – The domain name is reserved under specific conditions.
	//
	//    * AVAILABLE_PREORDER – The domain name is available and can be preordered.
	//
	//    * UNAVAILABLE – The domain name is not available.
	//    * UNAVAILABLE_PREMIUM – The domain name is not available.
	//    * UNAVAILABLE_RESTRICTED – The domain name is forbidden.
	//    * RESERVED – The domain name has been reserved for another person or organization.
	//
	//    * DONT_KNOW – The TLD registry didn't reply with a definitive answer about
	//    whether the domain name is available. Amazon Route 53 can return this
	//    response for a variety of reasons, for example, the registry is performing
	//    maintenance. Try again later.
	//
	// Availability is a required field
	Availability *string `type:"string" required:"true" enum:"DomainAvailability"`
}

// String returns the string representation
func (s CheckDomainAvailabilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckDomainAvailabilityOutput) GoString() string {
	return s.String()
}

// ContactDetail includes the following elements.
type ContactDetail struct {
	_ struct{} `type:"structure"`

	// First line of the contact's address.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	AddressLine1 *string `type:"string"`

	// Second line of contact's address, if any.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: No
	AddressLine2 *string `type:"string"`

	// The city of the contact's address.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	City *string `type:"string"`

	// Indicates whether the contact is a person, company, association, or public
	// organization. If you choose an option other than PERSON, you must enter an
	// organization name, and you can't enable privacy protection for the contact.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Valid values: PERSON | COMPANY | ASSOCIATION | PUBLIC_BODY
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	ContactType *string `type:"string" enum:"ContactType"`

	// Code for the country of the contact's address.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	CountryCode *string `type:"string" enum:"CountryCode"`

	// Email address of the contact.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 254 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	Email *string `type:"string"`

	// A list of name-value pairs for parameters required by certain top-level domains.
	//
	// Type: Complex
	//
	// Default: None
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Children: Name, Value
	//
	// Required: No
	ExtraParams []*ExtraParam `type:"list"`

	// Fax number of the contact.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Phone number must be specified in the format "+[country dialing
	// code].[number including any area code]". For example, a US phone number might
	// appear as "+1.1234567890".
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: No
	Fax *string `type:"string"`

	// First name of contact.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	FirstName *string `type:"string"`

	// Last name of contact.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	LastName *string `type:"string"`

	// Name of the organization for contact types other than PERSON.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters. Contact type must not be PERSON.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: No
	OrganizationName *string `type:"string"`

	// The phone number of the contact.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Phone number must be specified in the format "+[country dialing
	// code].[number including any area code>]". For example, a US phone number
	// might appear as "+1.1234567890".
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: Yes
	PhoneNumber *string `type:"string"`

	// The state or province of the contact's city.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: No
	State *string `type:"string"`

	// The zip or postal code of the contact's address.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// Parents: RegistrantContact, AdminContact, TechContact
	//
	// Required: No
	ZipCode *string `type:"string"`
}

// String returns the string representation
func (s ContactDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContactDetail) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContactDetail) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContactDetail"}
	if s.ExtraParams != nil {
		for i, v := range s.ExtraParams {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExtraParams", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The DeleteTagsForDomainRequest includes the following elements.
type DeleteTagsForDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain for which you want to delete one or more tags.
	//
	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Hyphens are allowed only when they're
	// surrounded by letters, numbers, or other hyphens. You can't specify a hyphen
	// at the beginning or end of a label. To specify an Internationalized Domain
	// Name, you must convert the name to Punycode.
	//
	// Required: Yes
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// A list of tag keys to delete.
	//
	// Type: A list that contains the keys of the tags that you want to delete.
	//
	// Default: None
	//
	// Required: No
	//
	// TagsToDelete is a required field
	TagsToDelete []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsForDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsForDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsForDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsForDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.TagsToDelete == nil {
		invalidParams.Add(request.NewErrParamRequired("TagsToDelete"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteTagsForDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsForDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsForDomainOutput) GoString() string {
	return s.String()
}

type DisableDomainAutoRenewInput struct {
	_ struct{} `type:"structure"`

	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableDomainAutoRenewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableDomainAutoRenewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableDomainAutoRenewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableDomainAutoRenewInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisableDomainAutoRenewOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableDomainAutoRenewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableDomainAutoRenewOutput) GoString() string {
	return s.String()
}

// The DisableDomainTransferLock request includes the following element.
type DisableDomainTransferLockInput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableDomainTransferLockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableDomainTransferLockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableDomainTransferLockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableDomainTransferLockInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The DisableDomainTransferLock response includes the following element.
type DisableDomainTransferLockOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableDomainTransferLockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableDomainTransferLockOutput) GoString() string {
	return s.String()
}

type DomainSuggestion struct {
	_ struct{} `type:"structure"`

	Availability *string `type:"string"`

	DomainName *string `type:"string"`
}

// String returns the string representation
func (s DomainSuggestion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainSuggestion) GoString() string {
	return s.String()
}

type DomainSummary struct {
	_ struct{} `type:"structure"`

	// Indicates whether the domain is automatically renewed upon expiration.
	//
	// Type: Boolean
	//
	// Valid values: True | False
	AutoRenew *bool `type:"boolean"`

	// The name of a domain.
	//
	// Type: String
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// Expiration date of the domain in Coordinated Universal Time (UTC).
	//
	// Type: Long
	Expiry *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Indicates whether a domain is locked from unauthorized transfer to another
	// party.
	//
	// Type: Boolean
	//
	// Valid values: True | False
	TransferLock *bool `type:"boolean"`
}

// String returns the string representation
func (s DomainSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainSummary) GoString() string {
	return s.String()
}

type EnableDomainAutoRenewInput struct {
	_ struct{} `type:"structure"`

	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableDomainAutoRenewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableDomainAutoRenewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableDomainAutoRenewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableDomainAutoRenewInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EnableDomainAutoRenewOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableDomainAutoRenewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableDomainAutoRenewOutput) GoString() string {
	return s.String()
}

// The EnableDomainTransferLock request includes the following element.
type EnableDomainTransferLockInput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableDomainTransferLockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableDomainTransferLockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableDomainTransferLockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableDomainTransferLockInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The EnableDomainTransferLock response includes the following elements.
type EnableDomainTransferLockOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableDomainTransferLockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableDomainTransferLockOutput) GoString() string {
	return s.String()
}

// ExtraParam includes the following elements.
type ExtraParam struct {
	_ struct{} `type:"structure"`

	// Name of the additional parameter required by the top-level domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Valid values: DUNS_NUMBER | BRAND_NUMBER | BIRTH_DEPARTMENT | BIRTH_DATE_IN_YYYY_MM_DD
	// | BIRTH_COUNTRY | BIRTH_CITY | DOCUMENT_NUMBER | AU_ID_NUMBER | AU_ID_TYPE
	// | CA_LEGAL_TYPE | CA_BUSINESS_ENTITY_TYPE |ES_IDENTIFICATION | ES_IDENTIFICATION_TYPE
	// | ES_LEGAL_FORM | FI_BUSINESS_NUMBER | FI_ID_NUMBER | IT_PIN | RU_PASSPORT_DATA
	// | SE_ID_NUMBER | SG_ID_NUMBER | VAT_NUMBER
	//
	// Parent: ExtraParams
	//
	// Required: Yes
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"ExtraParamName"`

	// Values corresponding to the additional parameter names required by some top-level
	// domains.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 2048 characters.
	//
	// Parent: ExtraParams
	//
	// Required: Yes
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ExtraParam) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExtraParam) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExtraParam) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExtraParam"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetContactReachabilityStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain for which you want to know whether the registrant
	// contact has confirmed that the email address is valid.
	//
	// Type: String
	//
	// Default: None
	//
	// Required: Yes
	DomainName *string `locationName:"domainName" type:"string"`
}

// String returns the string representation
func (s GetContactReachabilityStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContactReachabilityStatusInput) GoString() string {
	return s.String()
}

type GetContactReachabilityStatusOutput struct {
	_ struct{} `type:"structure"`

	// The domain name for which you requested the reachability status.
	DomainName *string `locationName:"domainName" type:"string"`

	// Whether the registrant contact has responded. PENDING indicates that we sent
	// the confirmation email and haven't received a response yet, DONE indicates
	// that we sent the email and got confirmation from the registrant contact,
	// and EXPIRED indicates that the time limit expired before the registrant contact
	// responded.
	//
	// Type: String
	//
	// Valid values: PENDING, DONE, EXPIRED
	Status *string `locationName:"status" type:"string" enum:"ReachabilityStatus"`
}

// String returns the string representation
func (s GetContactReachabilityStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContactReachabilityStatusOutput) GoString() string {
	return s.String()
}

// The GetDomainDetail request includes the following element.
type GetDomainDetailInput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetDomainDetailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainDetailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainDetailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainDetailInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The GetDomainDetail response includes the following elements.
type GetDomainDetailOutput struct {
	_ struct{} `type:"structure"`

	// Email address to contact to report incorrect contact information for a domain,
	// to report that the domain is being used to send spam, to report that someone
	// is cybersquatting on a domain name, or report some other type of abuse.
	//
	// Type: String
	AbuseContactEmail *string `type:"string"`

	// Phone number for reporting abuse.
	//
	// Type: String
	AbuseContactPhone *string `type:"string"`

	// Provides details about the domain administrative contact.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// AdminContact is a required field
	AdminContact *ContactDetail `type:"structure" required:"true"`

	// Specifies whether contact information for the admin contact is concealed
	// from WHOIS queries. If the value is true, WHOIS ("who is") queries will return
	// contact information for our registrar partner, Gandi, instead of the contact
	// information that you enter.
	//
	// Type: Boolean
	AdminPrivacy *bool `type:"boolean"`

	// Specifies whether the domain registration is set to renew automatically.
	//
	// Type: Boolean
	AutoRenew *bool `type:"boolean"`

	// The date when the domain was created as found in the response to a WHOIS
	// query. The date format is Unix time.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Reserved for future use.
	DnsSec *string `type:"string"`

	// The name of a domain.
	//
	// Type: String
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The date when the registration for the domain is set to expire. The date
	// format is Unix time.
	ExpirationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the domain.
	//
	// Type: String
	//
	// Nameservers is a required field
	Nameservers []*Nameserver `type:"list" required:"true"`

	// Provides details about the domain registrant.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// RegistrantContact is a required field
	RegistrantContact *ContactDetail `type:"structure" required:"true"`

	// Specifies whether contact information for the registrant contact is concealed
	// from WHOIS queries. If the value is true, WHOIS ("who is") queries will return
	// contact information for our registrar partner, Gandi, instead of the contact
	// information that you enter.
	//
	// Type: Boolean
	RegistrantPrivacy *bool `type:"boolean"`

	// Name of the registrar of the domain as identified in the registry. Amazon
	// Route 53 domains are registered by registrar Gandi. The value is "GANDI SAS".
	//
	// Type: String
	RegistrarName *string `type:"string"`

	// Web address of the registrar.
	//
	// Type: String
	RegistrarUrl *string `type:"string"`

	// Reserved for future use.
	RegistryDomainId *string `type:"string"`

	// Reseller of the domain. Domains registered or transferred using Amazon Route
	// 53 domains will have "Amazon" as the reseller.
	//
	// Type: String
	Reseller *string `type:"string"`

	// An array of domain name status codes, also known as Extensible Provisioning
	// Protocol (EPP) status codes.
	//
	// ICANN, the organization that maintains a central database of domain names,
	// has developed a set of domain name status codes that tell you the status
	// of a variety of operations on a domain name, for example, registering a domain
	// name, transferring a domain name to another registrar, renewing the registration
	// for a domain name, and so on. All registrars use this same set of status
	// codes.
	//
	// For a current list of domain name status codes and an explanation of what
	// each code means, go to the ICANN website (https://www.icann.org/) and search
	// for epp status codes. (Search on the ICANN website; web searches sometimes
	// return an old version of the document.)
	//
	// Type: Array of String
	StatusList []*string `type:"list"`

	// Provides details about the domain technical contact.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// TechContact is a required field
	TechContact *ContactDetail `type:"structure" required:"true"`

	// Specifies whether contact information for the tech contact is concealed from
	// WHOIS queries. If the value is true, WHOIS ("who is") queries will return
	// contact information for our registrar partner, Gandi, instead of the contact
	// information that you enter.
	//
	// Type: Boolean
	TechPrivacy *bool `type:"boolean"`

	// The last updated date of the domain as found in the response to a WHOIS query.
	// The date format is Unix time.
	UpdatedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The fully qualified name of the WHOIS server that can answer the WHOIS query
	// for the domain.
	//
	// Type: String
	WhoIsServer *string `type:"string"`
}

// String returns the string representation
func (s GetDomainDetailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainDetailOutput) GoString() string {
	return s.String()
}

type GetDomainSuggestionsInput struct {
	_ struct{} `type:"structure"`

	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// OnlyAvailable is a required field
	OnlyAvailable *bool `type:"boolean" required:"true"`

	// SuggestionCount is a required field
	SuggestionCount *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s GetDomainSuggestionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainSuggestionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainSuggestionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainSuggestionsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.OnlyAvailable == nil {
		invalidParams.Add(request.NewErrParamRequired("OnlyAvailable"))
	}
	if s.SuggestionCount == nil {
		invalidParams.Add(request.NewErrParamRequired("SuggestionCount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetDomainSuggestionsOutput struct {
	_ struct{} `type:"structure"`

	SuggestionsList []*DomainSuggestion `type:"list"`
}

// String returns the string representation
func (s GetDomainSuggestionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainSuggestionsOutput) GoString() string {
	return s.String()
}

// The GetOperationDetail request includes the following element.
type GetOperationDetailInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the operation for which you want to get the status. Amazon
	// Route 53 returned the identifier in the response to the original request.
	//
	// Type: String
	//
	// Default: None
	//
	// Required: Yes
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetOperationDetailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationDetailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOperationDetailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOperationDetailInput"}
	if s.OperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The GetOperationDetail response includes the following elements.
type GetOperationDetailOutput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	DomainName *string `type:"string"`

	// Detailed information on the status including possible errors.
	//
	// Type: String
	Message *string `type:"string"`

	// The identifier for the operation.
	//
	// Type: String
	OperationId *string `type:"string"`

	// The current status of the requested operation in the system.
	//
	// Type: String
	Status *string `type:"string" enum:"OperationStatus"`

	// The date when the request was submitted.
	SubmittedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The type of operation that was requested.
	//
	// Type: String
	Type *string `type:"string" enum:"OperationType"`
}

// String returns the string representation
func (s GetOperationDetailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationDetailOutput) GoString() string {
	return s.String()
}

// The ListDomains request includes the following elements.
type ListDomainsInput struct {
	_ struct{} `type:"structure"`

	// For an initial request for a list of domains, omit this element. If the number
	// of domains that are associated with the current AWS account is greater than
	// the value that you specified for MaxItems, you can use Marker to return additional
	// domains. Get the value of NextPageMarker from the previous response, and
	// submit another request that includes the value of NextPageMarker in the Marker
	// element.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The marker must match the value specified in the previous request.
	//
	// Required: No
	Marker *string `type:"string"`

	// Number of domains to be returned.
	//
	// Type: Integer
	//
	// Default: 20
	//
	// Constraints: A numeral between 1 and 100.
	//
	// Required: No
	MaxItems *int64 `type:"integer"`
}

// String returns the string representation
func (s ListDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsInput) GoString() string {
	return s.String()
}

// The ListDomains response includes the following elements.
type ListDomainsOutput struct {
	_ struct{} `type:"structure"`

	// A summary of domains.
	//
	// Type: Complex type containing a list of domain summaries.
	//
	// Children: AutoRenew, DomainName, Expiry, TransferLock
	//
	// Domains is a required field
	Domains []*DomainSummary `type:"list" required:"true"`

	// If there are more domains than you specified for MaxItems in the request,
	// submit another request and include the value of NextPageMarker in the value
	// of Marker.
	//
	// Type: String
	//
	// Parent: Operations
	NextPageMarker *string `type:"string"`
}

// String returns the string representation
func (s ListDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsOutput) GoString() string {
	return s.String()
}

// The ListOperations request includes the following elements.
type ListOperationsInput struct {
	_ struct{} `type:"structure"`

	// For an initial request for a list of operations, omit this element. If the
	// number of operations that are not yet complete is greater than the value
	// that you specified for MaxItems, you can use Marker to return additional
	// operations. Get the value of NextPageMarker from the previous response, and
	// submit another request that includes the value of NextPageMarker in the Marker
	// element.
	//
	// Type: String
	//
	// Default: None
	//
	// Required: No
	Marker *string `type:"string"`

	// Number of domains to be returned.
	//
	// Type: Integer
	//
	// Default: 20
	//
	// Constraints: A value between 1 and 100.
	//
	// Required: No
	MaxItems *int64 `type:"integer"`
}

// String returns the string representation
func (s ListOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOperationsInput) GoString() string {
	return s.String()
}

// The ListOperations response includes the following elements.
type ListOperationsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more operations than you specified for MaxItems in the request,
	// submit another request and include the value of NextPageMarker in the value
	// of Marker.
	//
	// Type: String
	//
	// Parent: Operations
	NextPageMarker *string `type:"string"`

	// Lists summaries of the operations.
	//
	// Type: Complex type containing a list of operation summaries
	//
	// Children: OperationId, Status, SubmittedDate, Type
	//
	// Operations is a required field
	Operations []*OperationSummary `type:"list" required:"true"`
}

// String returns the string representation
func (s ListOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOperationsOutput) GoString() string {
	return s.String()
}

// The ListTagsForDomainRequest includes the following elements.
type ListTagsForDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain for which you want to get a list of tags.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The ListTagsForDomain response includes the following elements.
type ListTagsForDomainOutput struct {
	_ struct{} `type:"structure"`

	// A list of the tags that are associated with the specified domain.
	//
	// Type: A complex type containing a list of tags
	//
	// Each tag includes the following elements.
	//
	//    * Key
	//
	// The key (name) of a tag.
	//
	// Type: String
	//
	//    * Value
	//
	// The value of a tag.
	//
	// Type: String
	//
	// TagList is a required field
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsForDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForDomainOutput) GoString() string {
	return s.String()
}

// Nameserver includes the following elements.
type Nameserver struct {
	_ struct{} `type:"structure"`

	// Glue IP address of a name server entry. Glue IP addresses are required only
	// when the name of the name server is a subdomain of the domain. For example,
	// if your domain is example.com and the name server for the domain is ns.example.com,
	// you need to specify the IP address for ns.example.com.
	//
	// Type: List of IP addresses.
	//
	// Constraints: The list can contain only one IPv4 and one IPv6 address.
	//
	// Parent: Nameservers
	GlueIps []*string `type:"list"`

	// The fully qualified host name of the name server.
	//
	// Type: String
	//
	// Constraint: Maximum 255 characterss
	//
	// Parent: Nameservers
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Nameserver) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Nameserver) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Nameserver) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Nameserver"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// OperationSummary includes the following elements.
type OperationSummary struct {
	_ struct{} `type:"structure"`

	// Identifier returned to track the requested action.
	//
	// Type: String
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`

	// The current status of the requested operation in the system.
	//
	// Type: String
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"OperationStatus"`

	// The date when the request was submitted.
	//
	// SubmittedDate is a required field
	SubmittedDate *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Type of the action requested.
	//
	// Type: String
	//
	// Valid values: REGISTER_DOMAIN | DELETE_DOMAIN | TRANSFER_IN_DOMAIN | UPDATE_DOMAIN_CONTACT
	// | UPDATE_NAMESERVER | CHANGE_PRIVACY_PROTECTION | DOMAIN_LOCK
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"OperationType"`
}

// String returns the string representation
func (s OperationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationSummary) GoString() string {
	return s.String()
}

// The RegisterDomain request includes the following elements.
type RegisterDomainInput struct {
	_ struct{} `type:"structure"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	//
	// AdminContact is a required field
	AdminContact *ContactDetail `type:"structure" required:"true"`

	// Indicates whether the domain will be automatically renewed (true) or not
	// (false). Autorenewal only takes effect after the account is charged.
	//
	// Type: Boolean
	//
	// Valid values: true | false
	//
	// Default: true
	//
	// Required: No
	AutoRenew *bool `type:"boolean"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The number of years the domain will be registered. Domains are registered
	// for a minimum of one year. The maximum period depends on the top-level domain.
	//
	// Type: Integer
	//
	// Default: 1
	//
	// Valid values: Integer from 1 to 10
	//
	// Required: Yes
	//
	// DurationInYears is a required field
	DurationInYears *int64 `min:"1" type:"integer" required:"true"`

	// Reserved for future use.
	IdnLangCode *string `type:"string"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: true
	//
	// Valid values: true | false
	//
	// Required: No
	PrivacyProtectAdminContact *bool `type:"boolean"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: true
	//
	// Valid values: true | false
	//
	// Required: No
	PrivacyProtectRegistrantContact *bool `type:"boolean"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: true
	//
	// Valid values: true | false
	//
	// Required: No
	PrivacyProtectTechContact *bool `type:"boolean"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	//
	// RegistrantContact is a required field
	RegistrantContact *ContactDetail `type:"structure" required:"true"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	//
	// TechContact is a required field
	TechContact *ContactDetail `type:"structure" required:"true"`
}

// String returns the string representation
func (s RegisterDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterDomainInput"}
	if s.AdminContact == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminContact"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DurationInYears == nil {
		invalidParams.Add(request.NewErrParamRequired("DurationInYears"))
	}
	if s.DurationInYears != nil && *s.DurationInYears < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DurationInYears", 1))
	}
	if s.RegistrantContact == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistrantContact"))
	}
	if s.TechContact == nil {
		invalidParams.Add(request.NewErrParamRequired("TechContact"))
	}
	if s.AdminContact != nil {
		if err := s.AdminContact.Validate(); err != nil {
			invalidParams.AddNested("AdminContact", err.(request.ErrInvalidParams))
		}
	}
	if s.RegistrantContact != nil {
		if err := s.RegistrantContact.Validate(); err != nil {
			invalidParams.AddNested("RegistrantContact", err.(request.ErrInvalidParams))
		}
	}
	if s.TechContact != nil {
		if err := s.TechContact.Validate(); err != nil {
			invalidParams.AddNested("TechContact", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The RegisterDomain response includes the following element.
type RegisterDomainOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterDomainOutput) GoString() string {
	return s.String()
}

// A RenewDomain request includes the number of years that you want to renew
// for and the current expiration year.
type RenewDomainInput struct {
	_ struct{} `type:"structure"`

	// The year when the registration for the domain is set to expire. This value
	// must match the current expiration date for the domain.
	//
	// Type: Integer
	//
	// Default: None
	//
	// Valid values: Integer
	//
	// Required: Yes
	//
	// CurrentExpiryYear is a required field
	CurrentExpiryYear *int64 `type:"integer" required:"true"`

	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The number of years that you want to renew the domain for. The maximum number
	// of years depends on the top-level domain. For the range of valid values for
	// your domain, see Domains that You Can Register with Amazon Route 53 (http://docs.aws.amazon.com/console/route53/domain-tld-list)
	// in the Amazon Route 53 documentation.
	//
	// Type: Integer
	//
	// Default: 1
	//
	// Valid values: Integer from 1 to 10
	//
	// Required: No
	DurationInYears *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s RenewDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RenewDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenewDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RenewDomainInput"}
	if s.CurrentExpiryYear == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentExpiryYear"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DurationInYears != nil && *s.DurationInYears < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DurationInYears", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RenewDomainOutput struct {
	_ struct{} `type:"structure"`

	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RenewDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RenewDomainOutput) GoString() string {
	return s.String()
}

type ResendContactReachabilityEmailInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain for which you want Amazon Route 53 to resend a confirmation
	// email to the registrant contact.
	//
	// Type: String
	//
	// Default: None
	//
	// Required: Yes
	DomainName *string `locationName:"domainName" type:"string"`
}

// String returns the string representation
func (s ResendContactReachabilityEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResendContactReachabilityEmailInput) GoString() string {
	return s.String()
}

type ResendContactReachabilityEmailOutput struct {
	_ struct{} `type:"structure"`

	// The domain name for which you requested a confirmation email.
	DomainName *string `locationName:"domainName" type:"string"`

	// The email address for the registrant contact at the time that we sent the
	// verification email.
	EmailAddress *string `locationName:"emailAddress" type:"string"`

	// True if the email address for the registrant contact has already been verified,
	// and false otherwise. If the email address has already been verified, we don't
	// send another confirmation email.
	IsAlreadyVerified *bool `locationName:"isAlreadyVerified" type:"boolean"`
}

// String returns the string representation
func (s ResendContactReachabilityEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResendContactReachabilityEmailOutput) GoString() string {
	return s.String()
}

// The RetrieveDomainAuthCode request includes the following element.
type RetrieveDomainAuthCodeInput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RetrieveDomainAuthCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveDomainAuthCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrieveDomainAuthCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrieveDomainAuthCodeInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The RetrieveDomainAuthCode response includes the following element.
type RetrieveDomainAuthCodeOutput struct {
	_ struct{} `type:"structure"`

	// The authorization code for the domain.
	//
	// Type: String
	//
	// AuthCode is a required field
	AuthCode *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RetrieveDomainAuthCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveDomainAuthCodeOutput) GoString() string {
	return s.String()
}

// Each tag includes the following elements.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key (name) of a tag.
	//
	// Type: String
	//
	// Default: None
	//
	// Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@"
	//
	// Constraints: Each key can be 1-128 characters long.
	//
	// Required: Yes
	Key *string `type:"string"`

	// The value of a tag.
	//
	// Type: String
	//
	// Default: None
	//
	// Valid values: A-Z, a-z, 0-9, space, ".:/=+\-@"
	//
	// Constraints: Each value can be 0-256 characters long.
	//
	// Required: Yes
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// The TransferDomain request includes the following elements.
type TransferDomainInput struct {
	_ struct{} `type:"structure"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	//
	// AdminContact is a required field
	AdminContact *ContactDetail `type:"structure" required:"true"`

	// The authorization code for the domain. You get this value from the current
	// registrar.
	//
	// Type: String
	//
	// Required: Yes
	AuthCode *string `type:"string"`

	// Indicates whether the domain will be automatically renewed (true) or not
	// (false). Autorenewal only takes effect after the account is charged.
	//
	// Type: Boolean
	//
	// Valid values: true | false
	//
	// Default: true
	//
	// Required: No
	AutoRenew *bool `type:"boolean"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The number of years the domain will be registered. Domains are registered
	// for a minimum of one year. The maximum period depends on the top-level domain.
	//
	// Type: Integer
	//
	// Default: 1
	//
	// Valid values: Integer from 1 to 10
	//
	// Required: Yes
	//
	// DurationInYears is a required field
	DurationInYears *int64 `min:"1" type:"integer" required:"true"`

	// Reserved for future use.
	IdnLangCode *string `type:"string"`

	// Contains details for the host and glue IP addresses.
	//
	// Type: Complex
	//
	// Children: GlueIps, Name
	//
	// Required: No
	Nameservers []*Nameserver `type:"list"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: true
	//
	// Valid values: true | false
	//
	// Required: No
	PrivacyProtectAdminContact *bool `type:"boolean"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: true
	//
	// Valid values: true | false
	//
	// Required: No
	PrivacyProtectRegistrantContact *bool `type:"boolean"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: true
	//
	// Valid values: true | false
	//
	// Required: No
	PrivacyProtectTechContact *bool `type:"boolean"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	//
	// RegistrantContact is a required field
	RegistrantContact *ContactDetail `type:"structure" required:"true"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	//
	// TechContact is a required field
	TechContact *ContactDetail `type:"structure" required:"true"`
}

// String returns the string representation
func (s TransferDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransferDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransferDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TransferDomainInput"}
	if s.AdminContact == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminContact"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DurationInYears == nil {
		invalidParams.Add(request.NewErrParamRequired("DurationInYears"))
	}
	if s.DurationInYears != nil && *s.DurationInYears < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DurationInYears", 1))
	}
	if s.RegistrantContact == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistrantContact"))
	}
	if s.TechContact == nil {
		invalidParams.Add(request.NewErrParamRequired("TechContact"))
	}
	if s.AdminContact != nil {
		if err := s.AdminContact.Validate(); err != nil {
			invalidParams.AddNested("AdminContact", err.(request.ErrInvalidParams))
		}
	}
	if s.Nameservers != nil {
		for i, v := range s.Nameservers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Nameservers", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RegistrantContact != nil {
		if err := s.RegistrantContact.Validate(); err != nil {
			invalidParams.AddNested("RegistrantContact", err.(request.ErrInvalidParams))
		}
	}
	if s.TechContact != nil {
		if err := s.TechContact.Validate(); err != nil {
			invalidParams.AddNested("TechContact", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The TranserDomain response includes the following element.
type TransferDomainOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TransferDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransferDomainOutput) GoString() string {
	return s.String()
}

// The UpdateDomainContact request includes the following elements.
type UpdateDomainContactInput struct {
	_ struct{} `type:"structure"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	AdminContact *ContactDetail `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	RegistrantContact *ContactDetail `type:"structure"`

	// Provides detailed contact information.
	//
	// Type: Complex
	//
	// Children: FirstName, MiddleName, LastName, ContactType, OrganizationName,
	// AddressLine1, AddressLine2, City, State, CountryCode, ZipCode, PhoneNumber,
	// Email, Fax, ExtraParams
	//
	// Required: Yes
	TechContact *ContactDetail `type:"structure"`
}

// String returns the string representation
func (s UpdateDomainContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainContactInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.AdminContact != nil {
		if err := s.AdminContact.Validate(); err != nil {
			invalidParams.AddNested("AdminContact", err.(request.ErrInvalidParams))
		}
	}
	if s.RegistrantContact != nil {
		if err := s.RegistrantContact.Validate(); err != nil {
			invalidParams.AddNested("RegistrantContact", err.(request.ErrInvalidParams))
		}
	}
	if s.TechContact != nil {
		if err := s.TechContact.Validate(); err != nil {
			invalidParams.AddNested("TechContact", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The UpdateDomainContact response includes the following element.
type UpdateDomainContactOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDomainContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainContactOutput) GoString() string {
	return s.String()
}

// The UpdateDomainContactPrivacy request includes the following elements.
type UpdateDomainContactPrivacyInput struct {
	_ struct{} `type:"structure"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: None
	//
	// Valid values: true | false
	//
	// Required: No
	AdminPrivacy *bool `type:"boolean"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: None
	//
	// Valid values: true | false
	//
	// Required: No
	RegistrantPrivacy *bool `type:"boolean"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries will return contact information for
	// our registrar partner, Gandi, instead of the contact information that you
	// enter.
	//
	// Type: Boolean
	//
	// Default: None
	//
	// Valid values: true | false
	//
	// Required: No
	TechPrivacy *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateDomainContactPrivacyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainContactPrivacyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainContactPrivacyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainContactPrivacyInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The UpdateDomainContactPrivacy response includes the following element.
type UpdateDomainContactPrivacyOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDomainContactPrivacyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainContactPrivacyOutput) GoString() string {
	return s.String()
}

// The UpdateDomainNameserver request includes the following elements.
type UpdateDomainNameserversInput struct {
	_ struct{} `type:"structure"`

	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// Required: Yes
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The authorization key for .fi domains
	FIAuthKey *string `type:"string"`

	// A list of new name servers for the domain.
	//
	// Type: Complex
	//
	// Children: Name, GlueIps
	//
	// Required: Yes
	//
	// Nameservers is a required field
	Nameservers []*Nameserver `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateDomainNameserversInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainNameserversInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainNameserversInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainNameserversInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.Nameservers == nil {
		invalidParams.Add(request.NewErrParamRequired("Nameservers"))
	}
	if s.Nameservers != nil {
		for i, v := range s.Nameservers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Nameservers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The UpdateDomainNameservers response includes the following element.
type UpdateDomainNameserversOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: Maximum 255 characters.
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDomainNameserversOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainNameserversOutput) GoString() string {
	return s.String()
}

// The UpdateTagsForDomainRequest includes the following elements.
type UpdateTagsForDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain for which you want to add or update tags.
	//
	// The name of a domain.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Hyphens are allowed only when they're
	// surrounded by letters, numbers, or other hyphens. You can't specify a hyphen
	// at the beginning or end of a label. To specify an Internationalized Domain
	// Name, you must convert the name to Punycode.
	//
	// Required: Yes
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// A list of the tag keys and values that you want to add or update. If you
	// specify a key that already exists, the corresponding value will be replaced.
	//
	// Type: A complex type containing a list of tags
	//
	// Default: None
	//
	// Required: No
	//
	// '> Each tag includes the following elements:
	//
	//    * Key
	//
	// The key (name) of a tag.
	//
	// Type: String
	//
	// Default: None
	//
	// Valid values: Unicode characters including alphanumeric, space, and ".:/=+\-@"
	//
	// Constraints: Each key can be 1-128 characters long.
	//
	// Required: Yes
	//
	//    * Value
	//
	// The value of a tag.
	//
	// Type: String
	//
	// Default: None
	//
	// Valid values: Unicode characters including alphanumeric, space, and ".:/=+\-@"
	//
	// Constraints: Each value can be 0-256 characters long.
	//
	// Required: Yes
	TagsToUpdate []*Tag `type:"list"`
}

// String returns the string representation
func (s UpdateTagsForDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTagsForDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTagsForDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTagsForDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateTagsForDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateTagsForDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTagsForDomainOutput) GoString() string {
	return s.String()
}

// The ViewBilling request includes the following elements.
type ViewBillingInput struct {
	_ struct{} `type:"structure"`

	// The end date and time for the time period for which you want a list of billing
	// records. Specify the date in Unix time format.
	//
	// Type: Double
	//
	// Default: None
	//
	// Required: Yes
	End *time.Time `type:"timestamp" timestampFormat:"unix"`

	// For an initial request for a list of billing records, omit this element.
	// If the number of billing records that are associated with the current AWS
	// account during the specified period is greater than the value that you specified
	// for MaxItems, you can use Marker to return additional billing records. Get
	// the value of NextPageMarker from the previous response, and submit another
	// request that includes the value of NextPageMarker in the Marker element.
	//
	// Type: String
	//
	// Default: None
	//
	// Constraints: The marker must match the value of NextPageMarker that was returned
	// in the previous response.
	//
	// Required: No
	Marker *string `type:"string"`

	// The number of billing records to be returned.
	//
	// Type: Integer
	//
	// Default: 20
	//
	// Constraints: A value between 1 and 100.
	//
	// Required: No
	MaxItems *int64 `type:"integer"`

	// The beginning date and time for the time period for which you want a list
	// of billing records. Specify the date in Unix time format.
	//
	// Type: Double
	//
	// Default: None
	//
	// Required: Yes
	Start *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ViewBillingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ViewBillingInput) GoString() string {
	return s.String()
}

// The ViewBilling response includes the following elements.
type ViewBillingOutput struct {
	_ struct{} `type:"structure"`

	// A summary of billing records.
	//
	// Type: Complex type containing a list of billing record summaries.
	//
	// Children: DomainName, Operation, InvoiceId, BillDate and Price
	BillingRecords []*BillingRecord `type:"list"`

	// If there are more billing records than you specified for MaxItems in the
	// request, submit another request and include the value of NextPageMarker in
	// the value of Marker.
	//
	// Type: String
	//
	// Parent: BillingRecords
	NextPageMarker *string `type:"string"`
}

// String returns the string representation
func (s ViewBillingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ViewBillingOutput) GoString() string {
	return s.String()
}

const (
	// ContactTypePerson is a ContactType enum value
	ContactTypePerson = "PERSON"

	// ContactTypeCompany is a ContactType enum value
	ContactTypeCompany = "COMPANY"

	// ContactTypeAssociation is a ContactType enum value
	ContactTypeAssociation = "ASSOCIATION"

	// ContactTypePublicBody is a ContactType enum value
	ContactTypePublicBody = "PUBLIC_BODY"

	// ContactTypeReseller is a ContactType enum value
	ContactTypeReseller = "RESELLER"
)

const (
	// CountryCodeAd is a CountryCode enum value
	CountryCodeAd = "AD"

	// CountryCodeAe is a CountryCode enum value
	CountryCodeAe = "AE"

	// CountryCodeAf is a CountryCode enum value
	CountryCodeAf = "AF"

	// CountryCodeAg is a CountryCode enum value
	CountryCodeAg = "AG"

	// CountryCodeAi is a CountryCode enum value
	CountryCodeAi = "AI"

	// CountryCodeAl is a CountryCode enum value
	CountryCodeAl = "AL"

	// CountryCodeAm is a CountryCode enum value
	CountryCodeAm = "AM"

	// CountryCodeAn is a CountryCode enum value
	CountryCodeAn = "AN"

	// CountryCodeAo is a CountryCode enum value
	CountryCodeAo = "AO"

	// CountryCodeAq is a CountryCode enum value
	CountryCodeAq = "AQ"

	// CountryCodeAr is a CountryCode enum value
	CountryCodeAr = "AR"

	// CountryCodeAs is a CountryCode enum value
	CountryCodeAs = "AS"

	// CountryCodeAt is a CountryCode enum value
	CountryCodeAt = "AT"

	// CountryCodeAu is a CountryCode enum value
	CountryCodeAu = "AU"

	// CountryCodeAw is a CountryCode enum value
	CountryCodeAw = "AW"

	// CountryCodeAz is a CountryCode enum value
	CountryCodeAz = "AZ"

	// CountryCodeBa is a CountryCode enum value
	CountryCodeBa = "BA"

	// CountryCodeBb is a CountryCode enum value
	CountryCodeBb = "BB"

	// CountryCodeBd is a CountryCode enum value
	CountryCodeBd = "BD"

	// CountryCodeBe is a CountryCode enum value
	CountryCodeBe = "BE"

	// CountryCodeBf is a CountryCode enum value
	CountryCodeBf = "BF"

	// CountryCodeBg is a CountryCode enum value
	CountryCodeBg = "BG"

	// CountryCodeBh is a CountryCode enum value
	CountryCodeBh = "BH"

	// CountryCodeBi is a CountryCode enum value
	CountryCodeBi = "BI"

	// CountryCodeBj is a CountryCode enum value
	CountryCodeBj = "BJ"

	// CountryCodeBl is a CountryCode enum value
	CountryCodeBl = "BL"

	// CountryCodeBm is a CountryCode enum value
	CountryCodeBm = "BM"

	// CountryCodeBn is a CountryCode enum value
	CountryCodeBn = "BN"

	// CountryCodeBo is a CountryCode enum value
	CountryCodeBo = "BO"

	// CountryCodeBr is a CountryCode enum value
	CountryCodeBr = "BR"

	// CountryCodeBs is a CountryCode enum value
	CountryCodeBs = "BS"

	// CountryCodeBt is a CountryCode enum value
	CountryCodeBt = "BT"

	// CountryCodeBw is a CountryCode enum value
	CountryCodeBw = "BW"

	// CountryCodeBy is a CountryCode enum value
	CountryCodeBy = "BY"

	// CountryCodeBz is a CountryCode enum value
	CountryCodeBz = "BZ"

	// CountryCodeCa is a CountryCode enum value
	CountryCodeCa = "CA"

	// CountryCodeCc is a CountryCode enum value
	CountryCodeCc = "CC"

	// CountryCodeCd is a CountryCode enum value
	CountryCodeCd = "CD"

	// CountryCodeCf is a CountryCode enum value
	CountryCodeCf = "CF"

	// CountryCodeCg is a CountryCode enum value
	CountryCodeCg = "CG"

	// CountryCodeCh is a CountryCode enum value
	CountryCodeCh = "CH"

	// CountryCodeCi is a CountryCode enum value
	CountryCodeCi = "CI"

	// CountryCodeCk is a CountryCode enum value
	CountryCodeCk = "CK"

	// CountryCodeCl is a CountryCode enum value
	CountryCodeCl = "CL"

	// CountryCodeCm is a CountryCode enum value
	CountryCodeCm = "CM"

	// CountryCodeCn is a CountryCode enum value
	CountryCodeCn = "CN"

	// CountryCodeCo is a CountryCode enum value
	CountryCodeCo = "CO"

	// CountryCodeCr is a CountryCode enum value
	CountryCodeCr = "CR"

	// CountryCodeCu is a CountryCode enum value
	CountryCodeCu = "CU"

	// CountryCodeCv is a CountryCode enum value
	CountryCodeCv = "CV"

	// CountryCodeCx is a CountryCode enum value
	CountryCodeCx = "CX"

	// CountryCodeCy is a CountryCode enum value
	CountryCodeCy = "CY"

	// CountryCodeCz is a CountryCode enum value
	CountryCodeCz = "CZ"

	// CountryCodeDe is a CountryCode enum value
	CountryCodeDe = "DE"

	// CountryCodeDj is a CountryCode enum value
	CountryCodeDj = "DJ"

	// CountryCodeDk is a CountryCode enum value
	CountryCodeDk = "DK"

	// CountryCodeDm is a CountryCode enum value
	CountryCodeDm = "DM"

	// CountryCodeDo is a CountryCode enum value
	CountryCodeDo = "DO"

	// CountryCodeDz is a CountryCode enum value
	CountryCodeDz = "DZ"

	// CountryCodeEc is a CountryCode enum value
	CountryCodeEc = "EC"

	// CountryCodeEe is a CountryCode enum value
	CountryCodeEe = "EE"

	// CountryCodeEg is a CountryCode enum value
	CountryCodeEg = "EG"

	// CountryCodeEr is a CountryCode enum value
	CountryCodeEr = "ER"

	// CountryCodeEs is a CountryCode enum value
	CountryCodeEs = "ES"

	// CountryCodeEt is a CountryCode enum value
	CountryCodeEt = "ET"

	// CountryCodeFi is a CountryCode enum value
	CountryCodeFi = "FI"

	// CountryCodeFj is a CountryCode enum value
	CountryCodeFj = "FJ"

	// CountryCodeFk is a CountryCode enum value
	CountryCodeFk = "FK"

	// CountryCodeFm is a CountryCode enum value
	CountryCodeFm = "FM"

	// CountryCodeFo is a CountryCode enum value
	CountryCodeFo = "FO"

	// CountryCodeFr is a CountryCode enum value
	CountryCodeFr = "FR"

	// CountryCodeGa is a CountryCode enum value
	CountryCodeGa = "GA"

	// CountryCodeGb is a CountryCode enum value
	CountryCodeGb = "GB"

	// CountryCodeGd is a CountryCode enum value
	CountryCodeGd = "GD"

	// CountryCodeGe is a CountryCode enum value
	CountryCodeGe = "GE"

	// CountryCodeGh is a CountryCode enum value
	CountryCodeGh = "GH"

	// CountryCodeGi is a CountryCode enum value
	CountryCodeGi = "GI"

	// CountryCodeGl is a CountryCode enum value
	CountryCodeGl = "GL"

	// CountryCodeGm is a CountryCode enum value
	CountryCodeGm = "GM"

	// CountryCodeGn is a CountryCode enum value
	CountryCodeGn = "GN"

	// CountryCodeGq is a CountryCode enum value
	CountryCodeGq = "GQ"

	// CountryCodeGr is a CountryCode enum value
	CountryCodeGr = "GR"

	// CountryCodeGt is a CountryCode enum value
	CountryCodeGt = "GT"

	// CountryCodeGu is a CountryCode enum value
	CountryCodeGu = "GU"

	// CountryCodeGw is a CountryCode enum value
	CountryCodeGw = "GW"

	// CountryCodeGy is a CountryCode enum value
	CountryCodeGy = "GY"

	// CountryCodeHk is a CountryCode enum value
	CountryCodeHk = "HK"

	// CountryCodeHn is a CountryCode enum value
	CountryCodeHn = "HN"

	// CountryCodeHr is a CountryCode enum value
	CountryCodeHr = "HR"

	// CountryCodeHt is a CountryCode enum value
	CountryCodeHt = "HT"

	// CountryCodeHu is a CountryCode enum value
	CountryCodeHu = "HU"

	// CountryCodeId is a CountryCode enum value
	CountryCodeId = "ID"

	// CountryCodeIe is a CountryCode enum value
	CountryCodeIe = "IE"

	// CountryCodeIl is a CountryCode enum value
	CountryCodeIl = "IL"

	// CountryCodeIm is a CountryCode enum value
	CountryCodeIm = "IM"

	// CountryCodeIn is a CountryCode enum value
	CountryCodeIn = "IN"

	// CountryCodeIq is a CountryCode enum value
	CountryCodeIq = "IQ"

	// CountryCodeIr is a CountryCode enum value
	CountryCodeIr = "IR"

	// CountryCodeIs is a CountryCode enum value
	CountryCodeIs = "IS"

	// CountryCodeIt is a CountryCode enum value
	CountryCodeIt = "IT"

	// CountryCodeJm is a CountryCode enum value
	CountryCodeJm = "JM"

	// CountryCodeJo is a CountryCode enum value
	CountryCodeJo = "JO"

	// CountryCodeJp is a CountryCode enum value
	CountryCodeJp = "JP"

	// CountryCodeKe is a CountryCode enum value
	CountryCodeKe = "KE"

	// CountryCodeKg is a CountryCode enum value
	CountryCodeKg = "KG"

	// CountryCodeKh is a CountryCode enum value
	CountryCodeKh = "KH"

	// CountryCodeKi is a CountryCode enum value
	CountryCodeKi = "KI"

	// CountryCodeKm is a CountryCode enum value
	CountryCodeKm = "KM"

	// CountryCodeKn is a CountryCode enum value
	CountryCodeKn = "KN"

	// CountryCodeKp is a CountryCode enum value
	CountryCodeKp = "KP"

	// CountryCodeKr is a CountryCode enum value
	CountryCodeKr = "KR"

	// CountryCodeKw is a CountryCode enum value
	CountryCodeKw = "KW"

	// CountryCodeKy is a CountryCode enum value
	CountryCodeKy = "KY"

	// CountryCodeKz is a CountryCode enum value
	CountryCodeKz = "KZ"

	// CountryCodeLa is a CountryCode enum value
	CountryCodeLa = "LA"

	// CountryCodeLb is a CountryCode enum value
	CountryCodeLb = "LB"

	// CountryCodeLc is a CountryCode enum value
	CountryCodeLc = "LC"

	// CountryCodeLi is a CountryCode enum value
	CountryCodeLi = "LI"

	// CountryCodeLk is a CountryCode enum value
	CountryCodeLk = "LK"

	// CountryCodeLr is a CountryCode enum value
	CountryCodeLr = "LR"

	// CountryCodeLs is a CountryCode enum value
	CountryCodeLs = "LS"

	// CountryCodeLt is a CountryCode enum value
	CountryCodeLt = "LT"

	// CountryCodeLu is a CountryCode enum value
	CountryCodeLu = "LU"

	// CountryCodeLv is a CountryCode enum value
	CountryCodeLv = "LV"

	// CountryCodeLy is a CountryCode enum value
	CountryCodeLy = "LY"

	// CountryCodeMa is a CountryCode enum value
	CountryCodeMa = "MA"

	// CountryCodeMc is a CountryCode enum value
	CountryCodeMc = "MC"

	// CountryCodeMd is a CountryCode enum value
	CountryCodeMd = "MD"

	// CountryCodeMe is a CountryCode enum value
	CountryCodeMe = "ME"

	// CountryCodeMf is a CountryCode enum value
	CountryCodeMf = "MF"

	// CountryCodeMg is a CountryCode enum value
	CountryCodeMg = "MG"

	// CountryCodeMh is a CountryCode enum value
	CountryCodeMh = "MH"

	// CountryCodeMk is a CountryCode enum value
	CountryCodeMk = "MK"

	// CountryCodeMl is a CountryCode enum value
	CountryCodeMl = "ML"

	// CountryCodeMm is a CountryCode enum value
	CountryCodeMm = "MM"

	// CountryCodeMn is a CountryCode enum value
	CountryCodeMn = "MN"

	// CountryCodeMo is a CountryCode enum value
	CountryCodeMo = "MO"

	// CountryCodeMp is a CountryCode enum value
	CountryCodeMp = "MP"

	// CountryCodeMr is a CountryCode enum value
	CountryCodeMr = "MR"

	// CountryCodeMs is a CountryCode enum value
	CountryCodeMs = "MS"

	// CountryCodeMt is a CountryCode enum value
	CountryCodeMt = "MT"

	// CountryCodeMu is a CountryCode enum value
	CountryCodeMu = "MU"

	// CountryCodeMv is a CountryCode enum value
	CountryCodeMv = "MV"

	// CountryCodeMw is a CountryCode enum value
	CountryCodeMw = "MW"

	// CountryCodeMx is a CountryCode enum value
	CountryCodeMx = "MX"

	// CountryCodeMy is a CountryCode enum value
	CountryCodeMy = "MY"

	// CountryCodeMz is a CountryCode enum value
	CountryCodeMz = "MZ"

	// CountryCodeNa is a CountryCode enum value
	CountryCodeNa = "NA"

	// CountryCodeNc is a CountryCode enum value
	CountryCodeNc = "NC"

	// CountryCodeNe is a CountryCode enum value
	CountryCodeNe = "NE"

	// CountryCodeNg is a CountryCode enum value
	CountryCodeNg = "NG"

	// CountryCodeNi is a CountryCode enum value
	CountryCodeNi = "NI"

	// CountryCodeNl is a CountryCode enum value
	CountryCodeNl = "NL"

	// CountryCodeNo is a CountryCode enum value
	CountryCodeNo = "NO"

	// CountryCodeNp is a CountryCode enum value
	CountryCodeNp = "NP"

	// CountryCodeNr is a CountryCode enum value
	CountryCodeNr = "NR"

	// CountryCodeNu is a CountryCode enum value
	CountryCodeNu = "NU"

	// CountryCodeNz is a CountryCode enum value
	CountryCodeNz = "NZ"

	// CountryCodeOm is a CountryCode enum value
	CountryCodeOm = "OM"

	// CountryCodePa is a CountryCode enum value
	CountryCodePa = "PA"

	// CountryCodePe is a CountryCode enum value
	CountryCodePe = "PE"

	// CountryCodePf is a CountryCode enum value
	CountryCodePf = "PF"

	// CountryCodePg is a CountryCode enum value
	CountryCodePg = "PG"

	// CountryCodePh is a CountryCode enum value
	CountryCodePh = "PH"

	// CountryCodePk is a CountryCode enum value
	CountryCodePk = "PK"

	// CountryCodePl is a CountryCode enum value
	CountryCodePl = "PL"

	// CountryCodePm is a CountryCode enum value
	CountryCodePm = "PM"

	// CountryCodePn is a CountryCode enum value
	CountryCodePn = "PN"

	// CountryCodePr is a CountryCode enum value
	CountryCodePr = "PR"

	// CountryCodePt is a CountryCode enum value
	CountryCodePt = "PT"

	// CountryCodePw is a CountryCode enum value
	CountryCodePw = "PW"

	// CountryCodePy is a CountryCode enum value
	CountryCodePy = "PY"

	// CountryCodeQa is a CountryCode enum value
	CountryCodeQa = "QA"

	// CountryCodeRo is a CountryCode enum value
	CountryCodeRo = "RO"

	// CountryCodeRs is a CountryCode enum value
	CountryCodeRs = "RS"

	// CountryCodeRu is a CountryCode enum value
	CountryCodeRu = "RU"

	// CountryCodeRw is a CountryCode enum value
	CountryCodeRw = "RW"

	// CountryCodeSa is a CountryCode enum value
	CountryCodeSa = "SA"

	// CountryCodeSb is a CountryCode enum value
	CountryCodeSb = "SB"

	// CountryCodeSc is a CountryCode enum value
	CountryCodeSc = "SC"

	// CountryCodeSd is a CountryCode enum value
	CountryCodeSd = "SD"

	// CountryCodeSe is a CountryCode enum value
	CountryCodeSe = "SE"

	// CountryCodeSg is a CountryCode enum value
	CountryCodeSg = "SG"

	// CountryCodeSh is a CountryCode enum value
	CountryCodeSh = "SH"

	// CountryCodeSi is a CountryCode enum value
	CountryCodeSi = "SI"

	// CountryCodeSk is a CountryCode enum value
	CountryCodeSk = "SK"

	// CountryCodeSl is a CountryCode enum value
	CountryCodeSl = "SL"

	// CountryCodeSm is a CountryCode enum value
	CountryCodeSm = "SM"

	// CountryCodeSn is a CountryCode enum value
	CountryCodeSn = "SN"

	// CountryCodeSo is a CountryCode enum value
	CountryCodeSo = "SO"

	// CountryCodeSr is a CountryCode enum value
	CountryCodeSr = "SR"

	// CountryCodeSt is a CountryCode enum value
	CountryCodeSt = "ST"

	// CountryCodeSv is a CountryCode enum value
	CountryCodeSv = "SV"

	// CountryCodeSy is a CountryCode enum value
	CountryCodeSy = "SY"

	// CountryCodeSz is a CountryCode enum value
	CountryCodeSz = "SZ"

	// CountryCodeTc is a CountryCode enum value
	CountryCodeTc = "TC"

	// CountryCodeTd is a CountryCode enum value
	CountryCodeTd = "TD"

	// CountryCodeTg is a CountryCode enum value
	CountryCodeTg = "TG"

	// CountryCodeTh is a CountryCode enum value
	CountryCodeTh = "TH"

	// CountryCodeTj is a CountryCode enum value
	CountryCodeTj = "TJ"

	// CountryCodeTk is a CountryCode enum value
	CountryCodeTk = "TK"

	// CountryCodeTl is a CountryCode enum value
	CountryCodeTl = "TL"

	// CountryCodeTm is a CountryCode enum value
	CountryCodeTm = "TM"

	// CountryCodeTn is a CountryCode enum value
	CountryCodeTn = "TN"

	// CountryCodeTo is a CountryCode enum value
	CountryCodeTo = "TO"

	// CountryCodeTr is a CountryCode enum value
	CountryCodeTr = "TR"

	// CountryCodeTt is a CountryCode enum value
	CountryCodeTt = "TT"

	// CountryCodeTv is a CountryCode enum value
	CountryCodeTv = "TV"

	// CountryCodeTw is a CountryCode enum value
	CountryCodeTw = "TW"

	// CountryCodeTz is a CountryCode enum value
	CountryCodeTz = "TZ"

	// CountryCodeUa is a CountryCode enum value
	CountryCodeUa = "UA"

	// CountryCodeUg is a CountryCode enum value
	CountryCodeUg = "UG"

	// CountryCodeUs is a CountryCode enum value
	CountryCodeUs = "US"

	// CountryCodeUy is a CountryCode enum value
	CountryCodeUy = "UY"

	// CountryCodeUz is a CountryCode enum value
	CountryCodeUz = "UZ"

	// CountryCodeVa is a CountryCode enum value
	CountryCodeVa = "VA"

	// CountryCodeVc is a CountryCode enum value
	CountryCodeVc = "VC"

	// CountryCodeVe is a CountryCode enum value
	CountryCodeVe = "VE"

	// CountryCodeVg is a CountryCode enum value
	CountryCodeVg = "VG"

	// CountryCodeVi is a CountryCode enum value
	CountryCodeVi = "VI"

	// CountryCodeVn is a CountryCode enum value
	CountryCodeVn = "VN"

	// CountryCodeVu is a CountryCode enum value
	CountryCodeVu = "VU"

	// CountryCodeWf is a CountryCode enum value
	CountryCodeWf = "WF"

	// CountryCodeWs is a CountryCode enum value
	CountryCodeWs = "WS"

	// CountryCodeYe is a CountryCode enum value
	CountryCodeYe = "YE"

	// CountryCodeYt is a CountryCode enum value
	CountryCodeYt = "YT"

	// CountryCodeZa is a CountryCode enum value
	CountryCodeZa = "ZA"

	// CountryCodeZm is a CountryCode enum value
	CountryCodeZm = "ZM"

	// CountryCodeZw is a CountryCode enum value
	CountryCodeZw = "ZW"
)

const (
	// DomainAvailabilityAvailable is a DomainAvailability enum value
	DomainAvailabilityAvailable = "AVAILABLE"

	// DomainAvailabilityAvailableReserved is a DomainAvailability enum value
	DomainAvailabilityAvailableReserved = "AVAILABLE_RESERVED"

	// DomainAvailabilityAvailablePreorder is a DomainAvailability enum value
	DomainAvailabilityAvailablePreorder = "AVAILABLE_PREORDER"

	// DomainAvailabilityUnavailable is a DomainAvailability enum value
	DomainAvailabilityUnavailable = "UNAVAILABLE"

	// DomainAvailabilityUnavailablePremium is a DomainAvailability enum value
	DomainAvailabilityUnavailablePremium = "UNAVAILABLE_PREMIUM"

	// DomainAvailabilityUnavailableRestricted is a DomainAvailability enum value
	DomainAvailabilityUnavailableRestricted = "UNAVAILABLE_RESTRICTED"

	// DomainAvailabilityReserved is a DomainAvailability enum value
	DomainAvailabilityReserved = "RESERVED"

	// DomainAvailabilityDontKnow is a DomainAvailability enum value
	DomainAvailabilityDontKnow = "DONT_KNOW"
)

const (
	// ExtraParamNameDunsNumber is a ExtraParamName enum value
	ExtraParamNameDunsNumber = "DUNS_NUMBER"

	// ExtraParamNameBrandNumber is a ExtraParamName enum value
	ExtraParamNameBrandNumber = "BRAND_NUMBER"

	// ExtraParamNameBirthDepartment is a ExtraParamName enum value
	ExtraParamNameBirthDepartment = "BIRTH_DEPARTMENT"

	// ExtraParamNameBirthDateInYyyyMmDd is a ExtraParamName enum value
	ExtraParamNameBirthDateInYyyyMmDd = "BIRTH_DATE_IN_YYYY_MM_DD"

	// ExtraParamNameBirthCountry is a ExtraParamName enum value
	ExtraParamNameBirthCountry = "BIRTH_COUNTRY"

	// ExtraParamNameBirthCity is a ExtraParamName enum value
	ExtraParamNameBirthCity = "BIRTH_CITY"

	// ExtraParamNameDocumentNumber is a ExtraParamName enum value
	ExtraParamNameDocumentNumber = "DOCUMENT_NUMBER"

	// ExtraParamNameAuIdNumber is a ExtraParamName enum value
	ExtraParamNameAuIdNumber = "AU_ID_NUMBER"

	// ExtraParamNameAuIdType is a ExtraParamName enum value
	ExtraParamNameAuIdType = "AU_ID_TYPE"

	// ExtraParamNameCaLegalType is a ExtraParamName enum value
	ExtraParamNameCaLegalType = "CA_LEGAL_TYPE"

	// ExtraParamNameCaBusinessEntityType is a ExtraParamName enum value
	ExtraParamNameCaBusinessEntityType = "CA_BUSINESS_ENTITY_TYPE"

	// ExtraParamNameEsIdentification is a ExtraParamName enum value
	ExtraParamNameEsIdentification = "ES_IDENTIFICATION"

	// ExtraParamNameEsIdentificationType is a ExtraParamName enum value
	ExtraParamNameEsIdentificationType = "ES_IDENTIFICATION_TYPE"

	// ExtraParamNameEsLegalForm is a ExtraParamName enum value
	ExtraParamNameEsLegalForm = "ES_LEGAL_FORM"

	// ExtraParamNameFiBusinessNumber is a ExtraParamName enum value
	ExtraParamNameFiBusinessNumber = "FI_BUSINESS_NUMBER"

	// ExtraParamNameFiIdNumber is a ExtraParamName enum value
	ExtraParamNameFiIdNumber = "FI_ID_NUMBER"

	// ExtraParamNameItPin is a ExtraParamName enum value
	ExtraParamNameItPin = "IT_PIN"

	// ExtraParamNameRuPassportData is a ExtraParamName enum value
	ExtraParamNameRuPassportData = "RU_PASSPORT_DATA"

	// ExtraParamNameSeIdNumber is a ExtraParamName enum value
	ExtraParamNameSeIdNumber = "SE_ID_NUMBER"

	// ExtraParamNameSgIdNumber is a ExtraParamName enum value
	ExtraParamNameSgIdNumber = "SG_ID_NUMBER"

	// ExtraParamNameVatNumber is a ExtraParamName enum value
	ExtraParamNameVatNumber = "VAT_NUMBER"
)

const (
	// OperationStatusSubmitted is a OperationStatus enum value
	OperationStatusSubmitted = "SUBMITTED"

	// OperationStatusInProgress is a OperationStatus enum value
	OperationStatusInProgress = "IN_PROGRESS"

	// OperationStatusError is a OperationStatus enum value
	OperationStatusError = "ERROR"

	// OperationStatusSuccessful is a OperationStatus enum value
	OperationStatusSuccessful = "SUCCESSFUL"

	// OperationStatusFailed is a OperationStatus enum value
	OperationStatusFailed = "FAILED"
)

const (
	// OperationTypeRegisterDomain is a OperationType enum value
	OperationTypeRegisterDomain = "REGISTER_DOMAIN"

	// OperationTypeDeleteDomain is a OperationType enum value
	OperationTypeDeleteDomain = "DELETE_DOMAIN"

	// OperationTypeTransferInDomain is a OperationType enum value
	OperationTypeTransferInDomain = "TRANSFER_IN_DOMAIN"

	// OperationTypeUpdateDomainContact is a OperationType enum value
	OperationTypeUpdateDomainContact = "UPDATE_DOMAIN_CONTACT"

	// OperationTypeUpdateNameserver is a OperationType enum value
	OperationTypeUpdateNameserver = "UPDATE_NAMESERVER"

	// OperationTypeChangePrivacyProtection is a OperationType enum value
	OperationTypeChangePrivacyProtection = "CHANGE_PRIVACY_PROTECTION"

	// OperationTypeDomainLock is a OperationType enum value
	OperationTypeDomainLock = "DOMAIN_LOCK"
)

const (
	// ReachabilityStatusPending is a ReachabilityStatus enum value
	ReachabilityStatusPending = "PENDING"

	// ReachabilityStatusDone is a ReachabilityStatus enum value
	ReachabilityStatusDone = "DONE"

	// ReachabilityStatusExpired is a ReachabilityStatus enum value
	ReachabilityStatusExpired = "EXPIRED"
)
