// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package workspaces_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/workspaces"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleWorkSpaces_CreateTags() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.CreateTagsInput{
		ResourceId: aws.String("NonEmptyString"), // Required
		Tags: []*workspaces.Tag{ // Required
			{ // Required
				Key:   aws.String("TagKey"), // Required
				Value: aws.String("TagValue"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_CreateWorkspaces() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.CreateWorkspacesInput{
		Workspaces: []*workspaces.WorkspaceRequest{ // Required
			{ // Required
				BundleId:                    aws.String("BundleId"),    // Required
				DirectoryId:                 aws.String("DirectoryId"), // Required
				UserName:                    aws.String("UserName"),    // Required
				RootVolumeEncryptionEnabled: aws.Bool(true),
				Tags: []*workspaces.Tag{
					{ // Required
						Key:   aws.String("TagKey"), // Required
						Value: aws.String("TagValue"),
					},
					// More values...
				},
				UserVolumeEncryptionEnabled: aws.Bool(true),
				VolumeEncryptionKey:         aws.String("VolumeEncryptionKey"),
				WorkspaceProperties: &workspaces.WorkspaceProperties{
					RunningMode:                         aws.String("RunningMode"),
					RunningModeAutoStopTimeoutInMinutes: aws.Int64(1),
				},
			},
			// More values...
		},
	}
	resp, err := svc.CreateWorkspaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_DeleteTags() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.DeleteTagsInput{
		ResourceId: aws.String("NonEmptyString"), // Required
		TagKeys: []*string{ // Required
			aws.String("NonEmptyString"), // Required
			// More values...
		},
	}
	resp, err := svc.DeleteTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_DescribeTags() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.DescribeTagsInput{
		ResourceId: aws.String("NonEmptyString"), // Required
	}
	resp, err := svc.DescribeTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_DescribeWorkspaceBundles() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.DescribeWorkspaceBundlesInput{
		BundleIds: []*string{
			aws.String("BundleId"), // Required
			// More values...
		},
		NextToken: aws.String("PaginationToken"),
		Owner:     aws.String("BundleOwner"),
	}
	resp, err := svc.DescribeWorkspaceBundles(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_DescribeWorkspaceDirectories() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.DescribeWorkspaceDirectoriesInput{
		DirectoryIds: []*string{
			aws.String("DirectoryId"), // Required
			// More values...
		},
		NextToken: aws.String("PaginationToken"),
	}
	resp, err := svc.DescribeWorkspaceDirectories(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_DescribeWorkspaces() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.DescribeWorkspacesInput{
		BundleId:    aws.String("BundleId"),
		DirectoryId: aws.String("DirectoryId"),
		Limit:       aws.Int64(1),
		NextToken:   aws.String("PaginationToken"),
		UserName:    aws.String("UserName"),
		WorkspaceIds: []*string{
			aws.String("WorkspaceId"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeWorkspaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_DescribeWorkspacesConnectionStatus() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.DescribeWorkspacesConnectionStatusInput{
		NextToken: aws.String("PaginationToken"),
		WorkspaceIds: []*string{
			aws.String("WorkspaceId"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeWorkspacesConnectionStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_ModifyWorkspaceProperties() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.ModifyWorkspacePropertiesInput{
		WorkspaceId: aws.String("WorkspaceId"), // Required
		WorkspaceProperties: &workspaces.WorkspaceProperties{ // Required
			RunningMode:                         aws.String("RunningMode"),
			RunningModeAutoStopTimeoutInMinutes: aws.Int64(1),
		},
	}
	resp, err := svc.ModifyWorkspaceProperties(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_RebootWorkspaces() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.RebootWorkspacesInput{
		RebootWorkspaceRequests: []*workspaces.RebootRequest{ // Required
			{ // Required
				WorkspaceId: aws.String("WorkspaceId"), // Required
			},
			// More values...
		},
	}
	resp, err := svc.RebootWorkspaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_RebuildWorkspaces() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.RebuildWorkspacesInput{
		RebuildWorkspaceRequests: []*workspaces.RebuildRequest{ // Required
			{ // Required
				WorkspaceId: aws.String("WorkspaceId"), // Required
			},
			// More values...
		},
	}
	resp, err := svc.RebuildWorkspaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_StartWorkspaces() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.StartWorkspacesInput{
		StartWorkspaceRequests: []*workspaces.StartRequest{ // Required
			{ // Required
				WorkspaceId: aws.String("WorkspaceId"),
			},
			// More values...
		},
	}
	resp, err := svc.StartWorkspaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_StopWorkspaces() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.StopWorkspacesInput{
		StopWorkspaceRequests: []*workspaces.StopRequest{ // Required
			{ // Required
				WorkspaceId: aws.String("WorkspaceId"),
			},
			// More values...
		},
	}
	resp, err := svc.StopWorkspaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_TerminateWorkspaces() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := workspaces.New(sess)

	params := &workspaces.TerminateWorkspacesInput{
		TerminateWorkspaceRequests: []*workspaces.TerminateRequest{ // Required
			{ // Required
				WorkspaceId: aws.String("WorkspaceId"), // Required
			},
			// More values...
		},
	}
	resp, err := svc.TerminateWorkspaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
