package scheduledqueryrules

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ConditionOperator enumerates the values for condition operator.
type ConditionOperator string

const (
	// ConditionOperatorEquals ...
	ConditionOperatorEquals ConditionOperator = "Equals"
	// ConditionOperatorGreaterThan ...
	ConditionOperatorGreaterThan ConditionOperator = "GreaterThan"
	// ConditionOperatorGreaterThanOrEqual ...
	ConditionOperatorGreaterThanOrEqual ConditionOperator = "GreaterThanOrEqual"
	// ConditionOperatorLessThan ...
	ConditionOperatorLessThan ConditionOperator = "LessThan"
	// ConditionOperatorLessThanOrEqual ...
	ConditionOperatorLessThanOrEqual ConditionOperator = "LessThanOrEqual"
)

// PossibleConditionOperatorValues returns an array of possible values for the ConditionOperator const type.
func PossibleConditionOperatorValues() []ConditionOperator {
	return []ConditionOperator{ConditionOperatorEquals, ConditionOperatorGreaterThan, ConditionOperatorGreaterThanOrEqual, ConditionOperatorLessThan, ConditionOperatorLessThanOrEqual}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// DimensionOperator enumerates the values for dimension operator.
type DimensionOperator string

const (
	// DimensionOperatorExclude ...
	DimensionOperatorExclude DimensionOperator = "Exclude"
	// DimensionOperatorInclude ...
	DimensionOperatorInclude DimensionOperator = "Include"
)

// PossibleDimensionOperatorValues returns an array of possible values for the DimensionOperator const type.
func PossibleDimensionOperatorValues() []DimensionOperator {
	return []DimensionOperator{DimensionOperatorExclude, DimensionOperatorInclude}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindLogAlert ...
	KindLogAlert Kind = "LogAlert"
	// KindLogToMetric ...
	KindLogToMetric Kind = "LogToMetric"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindLogAlert, KindLogToMetric}
}

// TimeAggregation enumerates the values for time aggregation.
type TimeAggregation string

const (
	// TimeAggregationAverage ...
	TimeAggregationAverage TimeAggregation = "Average"
	// TimeAggregationCount ...
	TimeAggregationCount TimeAggregation = "Count"
	// TimeAggregationMaximum ...
	TimeAggregationMaximum TimeAggregation = "Maximum"
	// TimeAggregationMinimum ...
	TimeAggregationMinimum TimeAggregation = "Minimum"
	// TimeAggregationTotal ...
	TimeAggregationTotal TimeAggregation = "Total"
)

// PossibleTimeAggregationValues returns an array of possible values for the TimeAggregation const type.
func PossibleTimeAggregationValues() []TimeAggregation {
	return []TimeAggregation{TimeAggregationAverage, TimeAggregationCount, TimeAggregationMaximum, TimeAggregationMinimum, TimeAggregationTotal}
}
