package maintenance

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/maintenance/mgmt/2021-09-01-preview/maintenance"

// ApplyUpdate apply Update request
type ApplyUpdate struct {
	autorest.Response `json:"-"`
	// ApplyUpdateProperties - Properties of the apply update
	*ApplyUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplyUpdate.
func (au ApplyUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if au.ApplyUpdateProperties != nil {
		objectMap["properties"] = au.ApplyUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplyUpdate struct.
func (au *ApplyUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applyUpdateProperties ApplyUpdateProperties
				err = json.Unmarshal(*v, &applyUpdateProperties)
				if err != nil {
					return err
				}
				au.ApplyUpdateProperties = &applyUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				au.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				au.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				au.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				au.SystemData = &systemData
			}
		}
	}

	return nil
}

// ApplyUpdateProperties properties for apply update
type ApplyUpdateProperties struct {
	// Status - The status. Possible values include: 'Pending', 'InProgress', 'Completed', 'RetryNow', 'RetryLater'
	Status UpdateStatus `json:"status,omitempty"`
	// ResourceID - The resourceId
	ResourceID *string `json:"resourceId,omitempty"`
	// LastUpdateTime - Last Update time
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
}

// Configuration maintenance configuration record type
type Configuration struct {
	autorest.Response `json:"-"`
	// Location - Gets or sets location of the resource
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets tags of the resource
	Tags map[string]*string `json:"tags"`
	// ConfigurationProperties - Gets or sets properties of the resource
	*ConfigurationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Configuration.
func (c Configuration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	if c.ConfigurationProperties != nil {
		objectMap["properties"] = c.ConfigurationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Configuration struct.
func (c *Configuration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		case "properties":
			if v != nil {
				var configurationProperties ConfigurationProperties
				err = json.Unmarshal(*v, &configurationProperties)
				if err != nil {
					return err
				}
				c.ConfigurationProperties = &configurationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				c.SystemData = &systemData
			}
		}
	}

	return nil
}

// ConfigurationAssignment configuration Assignment
type ConfigurationAssignment struct {
	autorest.Response `json:"-"`
	// Location - Location of the resource
	Location *string `json:"location,omitempty"`
	// ConfigurationAssignmentProperties - Properties of the configuration assignment
	*ConfigurationAssignmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationAssignment.
func (ca ConfigurationAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ca.Location != nil {
		objectMap["location"] = ca.Location
	}
	if ca.ConfigurationAssignmentProperties != nil {
		objectMap["properties"] = ca.ConfigurationAssignmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConfigurationAssignment struct.
func (ca *ConfigurationAssignment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ca.Location = &location
			}
		case "properties":
			if v != nil {
				var configurationAssignmentProperties ConfigurationAssignmentProperties
				err = json.Unmarshal(*v, &configurationAssignmentProperties)
				if err != nil {
					return err
				}
				ca.ConfigurationAssignmentProperties = &configurationAssignmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ca.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ca.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ca.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ca.SystemData = &systemData
			}
		}
	}

	return nil
}

// ConfigurationAssignmentProperties properties for configuration assignment
type ConfigurationAssignmentProperties struct {
	// MaintenanceConfigurationID - The maintenance configuration Id
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`
	// ResourceID - The unique resourceId
	ResourceID *string `json:"resourceId,omitempty"`
}

// ConfigurationProperties properties for maintenance configuration
type ConfigurationProperties struct {
	// Namespace - Gets or sets namespace of the resource
	Namespace *string `json:"namespace,omitempty"`
	// ExtensionProperties - Gets or sets extensionProperties of the maintenanceConfiguration
	ExtensionProperties map[string]*string `json:"extensionProperties"`
	// MaintenanceScope - Gets or sets maintenanceScope of the configuration. Possible values include: 'Host', 'OSImage', 'Extension', 'InGuestPatch', 'SQLDB', 'SQLManagedInstance'
	MaintenanceScope Scope `json:"maintenanceScope,omitempty"`
	// Window - Definition of a MaintenanceWindow
	*Window `json:"maintenanceWindow,omitempty"`
	// Visibility - Gets or sets the visibility of the configuration. The default value is 'Custom'. Possible values include: 'Custom', 'Public'
	Visibility Visibility `json:"visibility,omitempty"`
	// InstallPatches - The input parameters to be passed to the patch run operation.
	InstallPatches *InputPatchConfiguration `json:"installPatches,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationProperties.
func (cp ConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Namespace != nil {
		objectMap["namespace"] = cp.Namespace
	}
	if cp.ExtensionProperties != nil {
		objectMap["extensionProperties"] = cp.ExtensionProperties
	}
	if cp.MaintenanceScope != "" {
		objectMap["maintenanceScope"] = cp.MaintenanceScope
	}
	if cp.Window != nil {
		objectMap["maintenanceWindow"] = cp.Window
	}
	if cp.Visibility != "" {
		objectMap["visibility"] = cp.Visibility
	}
	if cp.InstallPatches != nil {
		objectMap["installPatches"] = cp.InstallPatches
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConfigurationProperties struct.
func (cp *ConfigurationProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "namespace":
			if v != nil {
				var namespace string
				err = json.Unmarshal(*v, &namespace)
				if err != nil {
					return err
				}
				cp.Namespace = &namespace
			}
		case "extensionProperties":
			if v != nil {
				var extensionProperties map[string]*string
				err = json.Unmarshal(*v, &extensionProperties)
				if err != nil {
					return err
				}
				cp.ExtensionProperties = extensionProperties
			}
		case "maintenanceScope":
			if v != nil {
				var maintenanceScope Scope
				err = json.Unmarshal(*v, &maintenanceScope)
				if err != nil {
					return err
				}
				cp.MaintenanceScope = maintenanceScope
			}
		case "maintenanceWindow":
			if v != nil {
				var window Window
				err = json.Unmarshal(*v, &window)
				if err != nil {
					return err
				}
				cp.Window = &window
			}
		case "visibility":
			if v != nil {
				var visibility Visibility
				err = json.Unmarshal(*v, &visibility)
				if err != nil {
					return err
				}
				cp.Visibility = visibility
			}
		case "installPatches":
			if v != nil {
				var installPatches InputPatchConfiguration
				err = json.Unmarshal(*v, &installPatches)
				if err != nil {
					return err
				}
				cp.InstallPatches = &installPatches
			}
		}
	}

	return nil
}

// Error an error response received from the Azure Maintenance service.
type Error struct {
	// Error - Details of the error
	Error *ErrorDetails `json:"error,omitempty"`
}

// ErrorDetails an error response details received from the Azure Maintenance service.
type ErrorDetails struct {
	// Code - Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of the error.
	Message *string `json:"message,omitempty"`
}

// InputLinuxParameters input properties for patching a Linux machine.
type InputLinuxParameters struct {
	// PackageNameMasksToExclude - Package names to be excluded for patching.
	PackageNameMasksToExclude *[]string `json:"packageNameMasksToExclude,omitempty"`
	// PackageNameMasksToInclude - Package names to be included for patching.
	PackageNameMasksToInclude *[]string `json:"packageNameMasksToInclude,omitempty"`
	// ClassificationsToInclude - Classification category of patches to be patched
	ClassificationsToInclude *[]string `json:"classificationsToInclude,omitempty"`
}

// InputPatchConfiguration input configuration for a patch run
type InputPatchConfiguration struct {
	// RebootSetting - Possible reboot preference as defined by the user based on which it would be decided to reboot the machine or not after the patch operation is completed. Possible values include: 'IfRequired', 'Never', 'Always'
	RebootSetting RebootOptions `json:"rebootSetting,omitempty"`
	// WindowsParameters - Input parameters specific to patching a Windows machine. For Linux machines, do not pass this property.
	WindowsParameters *InputWindowsParameters `json:"windowsParameters,omitempty"`
	// LinuxParameters - Input parameters specific to patching Linux machine. For Windows machines, do not pass this property.
	LinuxParameters *InputLinuxParameters `json:"linuxParameters,omitempty"`
	// SoftwareUpdateConfigurationTasks - Tasks information for the Software update configuration.
	*SoftwareUpdateConfigurationTasks `json:"tasks,omitempty"`
}

// MarshalJSON is the custom marshaler for InputPatchConfiguration.
func (ipc InputPatchConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipc.RebootSetting != "" {
		objectMap["rebootSetting"] = ipc.RebootSetting
	}
	if ipc.WindowsParameters != nil {
		objectMap["windowsParameters"] = ipc.WindowsParameters
	}
	if ipc.LinuxParameters != nil {
		objectMap["linuxParameters"] = ipc.LinuxParameters
	}
	if ipc.SoftwareUpdateConfigurationTasks != nil {
		objectMap["tasks"] = ipc.SoftwareUpdateConfigurationTasks
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for InputPatchConfiguration struct.
func (ipc *InputPatchConfiguration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "rebootSetting":
			if v != nil {
				var rebootSetting RebootOptions
				err = json.Unmarshal(*v, &rebootSetting)
				if err != nil {
					return err
				}
				ipc.RebootSetting = rebootSetting
			}
		case "windowsParameters":
			if v != nil {
				var windowsParameters InputWindowsParameters
				err = json.Unmarshal(*v, &windowsParameters)
				if err != nil {
					return err
				}
				ipc.WindowsParameters = &windowsParameters
			}
		case "linuxParameters":
			if v != nil {
				var linuxParameters InputLinuxParameters
				err = json.Unmarshal(*v, &linuxParameters)
				if err != nil {
					return err
				}
				ipc.LinuxParameters = &linuxParameters
			}
		case "tasks":
			if v != nil {
				var softwareUpdateConfigurationTasks SoftwareUpdateConfigurationTasks
				err = json.Unmarshal(*v, &softwareUpdateConfigurationTasks)
				if err != nil {
					return err
				}
				ipc.SoftwareUpdateConfigurationTasks = &softwareUpdateConfigurationTasks
			}
		}
	}

	return nil
}

// InputWindowsParameters input properties for patching a Windows machine.
type InputWindowsParameters struct {
	// KbNumbersToExclude - Windows KBID to be excluded for patching.
	KbNumbersToExclude *[]string `json:"kbNumbersToExclude,omitempty"`
	// KbNumbersToInclude - Windows KBID to be included for patching.
	KbNumbersToInclude *[]string `json:"kbNumbersToInclude,omitempty"`
	// ClassificationsToInclude - Classification category of patches to be patched
	ClassificationsToInclude *[]string `json:"classificationsToInclude,omitempty"`
	// ExcludeKbsRequiringReboot - Exclude patches which need reboot
	ExcludeKbsRequiringReboot *bool `json:"excludeKbsRequiringReboot,omitempty"`
}

// ListApplyUpdate response for ApplyUpdate list
type ListApplyUpdate struct {
	autorest.Response `json:"-"`
	// Value - The list of apply updates
	Value *[]ApplyUpdate `json:"value,omitempty"`
}

// ListConfigurationAssignmentsResult response for ConfigurationAssignments list
type ListConfigurationAssignmentsResult struct {
	autorest.Response `json:"-"`
	// Value - The list of configuration Assignments
	Value *[]ConfigurationAssignment `json:"value,omitempty"`
}

// ListMaintenanceConfigurationsResult response for MaintenanceConfigurations list
type ListMaintenanceConfigurationsResult struct {
	autorest.Response `json:"-"`
	// Value - The list of maintenance Configurations
	Value *[]Configuration `json:"value,omitempty"`
}

// ListUpdatesResult response for Updates list
type ListUpdatesResult struct {
	autorest.Response `json:"-"`
	// Value - The pending updates
	Value *[]Update `json:"value,omitempty"`
}

// Operation represents an operation returned by the GetOperations request
type Operation struct {
	// Name - Name of the operation
	Name *string `json:"name,omitempty"`
	// Display - Display name of the operation
	Display *OperationInfo `json:"display,omitempty"`
	// Origin - Origin of the operation
	Origin *string `json:"origin,omitempty"`
	// Properties - Properties of the operation
	Properties interface{} `json:"properties,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
}

// OperationInfo information about an operation
type OperationInfo struct {
	// Provider - Name of the provider
	Provider *string `json:"provider,omitempty"`
	// Resource - Name of the resource type
	Resource *string `json:"resource,omitempty"`
	// Operation - Name of the operation
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation
	Description *string `json:"description,omitempty"`
}

// OperationsListResult result of the List Operations operation
type OperationsListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of operations
	Value *[]Operation `json:"value,omitempty"`
}

// Resource definition of a Resource
type Resource struct {
	// ID - READ-ONLY; Fully qualified identifier of the resource
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Type of the resource
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SoftwareUpdateConfigurationTasks task properties of the software update configuration.
type SoftwareUpdateConfigurationTasks struct {
	// PreTasks - List of pre tasks. e.g. [{'source' :'runbook', 'taskScope': 'Global', 'parameters': { 'arg1': 'value1'}}]
	PreTasks *[]TaskProperties `json:"preTasks,omitempty"`
	// PostTasks - List of post tasks. e.g. [{'source' :'runbook', 'taskScope': 'Resource', 'parameters': { 'arg1': 'value1'}}]
	PostTasks *[]TaskProperties `json:"postTasks,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TaskProperties task properties of the software update configuration.
type TaskProperties struct {
	// Parameters - Gets or sets the parameters of the task.
	Parameters map[string]*string `json:"parameters"`
	// Source - Gets or sets the name of the runbook.
	Source *string `json:"source,omitempty"`
	// TaskScope - Global Task execute once when schedule trigger. Resource task execute for each VM. Possible values include: 'TaskScopeGlobal', 'TaskScopeResource'
	TaskScope TaskScope `json:"taskScope,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskProperties.
func (tp TaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.Parameters != nil {
		objectMap["parameters"] = tp.Parameters
	}
	if tp.Source != nil {
		objectMap["source"] = tp.Source
	}
	if tp.TaskScope != "" {
		objectMap["taskScope"] = tp.TaskScope
	}
	return json.Marshal(objectMap)
}

// Update maintenance update on a resource
type Update struct {
	// MaintenanceScope - The impact area. Possible values include: 'Host', 'OSImage', 'Extension', 'InGuestPatch', 'SQLDB', 'SQLManagedInstance'
	MaintenanceScope Scope `json:"maintenanceScope,omitempty"`
	// ImpactType - The impact type. Possible values include: 'None', 'Freeze', 'Restart', 'Redeploy'
	ImpactType ImpactType `json:"impactType,omitempty"`
	// Status - The status. Possible values include: 'Pending', 'InProgress', 'Completed', 'RetryNow', 'RetryLater'
	Status UpdateStatus `json:"status,omitempty"`
	// ImpactDurationInSec - Duration of impact in seconds
	ImpactDurationInSec *int32 `json:"impactDurationInSec,omitempty"`
	// NotBefore - Time when Azure will start force updates if not self-updated by customer before this time
	NotBefore *date.Time `json:"notBefore,omitempty"`
	// UpdateProperties - Properties of the apply update
	*UpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Update.
func (u Update) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.MaintenanceScope != "" {
		objectMap["maintenanceScope"] = u.MaintenanceScope
	}
	if u.ImpactType != "" {
		objectMap["impactType"] = u.ImpactType
	}
	if u.Status != "" {
		objectMap["status"] = u.Status
	}
	if u.ImpactDurationInSec != nil {
		objectMap["impactDurationInSec"] = u.ImpactDurationInSec
	}
	if u.NotBefore != nil {
		objectMap["notBefore"] = u.NotBefore
	}
	if u.UpdateProperties != nil {
		objectMap["properties"] = u.UpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Update struct.
func (u *Update) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "maintenanceScope":
			if v != nil {
				var maintenanceScope Scope
				err = json.Unmarshal(*v, &maintenanceScope)
				if err != nil {
					return err
				}
				u.MaintenanceScope = maintenanceScope
			}
		case "impactType":
			if v != nil {
				var impactType ImpactType
				err = json.Unmarshal(*v, &impactType)
				if err != nil {
					return err
				}
				u.ImpactType = impactType
			}
		case "status":
			if v != nil {
				var status UpdateStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				u.Status = status
			}
		case "impactDurationInSec":
			if v != nil {
				var impactDurationInSec int32
				err = json.Unmarshal(*v, &impactDurationInSec)
				if err != nil {
					return err
				}
				u.ImpactDurationInSec = &impactDurationInSec
			}
		case "notBefore":
			if v != nil {
				var notBefore date.Time
				err = json.Unmarshal(*v, &notBefore)
				if err != nil {
					return err
				}
				u.NotBefore = &notBefore
			}
		case "properties":
			if v != nil {
				var updateProperties UpdateProperties
				err = json.Unmarshal(*v, &updateProperties)
				if err != nil {
					return err
				}
				u.UpdateProperties = &updateProperties
			}
		}
	}

	return nil
}

// UpdateProperties properties for update
type UpdateProperties struct {
	// ResourceID - The resourceId
	ResourceID *string `json:"resourceId,omitempty"`
}

// Window definition of a MaintenanceWindow
type Window struct {
	// StartDateTime - Effective start date of the maintenance window in YYYY-MM-DD hh:mm format. The start date can be set to either the current date or future date. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone.
	StartDateTime *string `json:"startDateTime,omitempty"`
	// ExpirationDateTime - Effective expiration date of the maintenance window in YYYY-MM-DD hh:mm format. The window will be created in the time zone provided and adjusted to daylight savings according to that time zone. Expiration date must be set to a future date. If not provided, it will be set to the maximum datetime 9999-12-31 23:59:59.
	ExpirationDateTime *string `json:"expirationDateTime,omitempty"`
	// Duration - Duration of the maintenance window in HH:mm format. If not provided, default value will be used based on maintenance scope provided. Example: 05:00.
	Duration *string `json:"duration,omitempty"`
	// TimeZone - Name of the timezone. List of timezones can be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell. Example: Pacific Standard Time, UTC, W. Europe Standard Time, Korea Standard Time, Cen. Australia Standard Time.
	TimeZone *string `json:"timeZone,omitempty"`
	// RecurEvery - Rate at which a Maintenance window is expected to recur. The rate can be expressed as daily, weekly, or monthly schedules. Daily schedule are formatted as recurEvery: [Frequency as integer]['Day(s)']. If no frequency is provided, the default frequency is 1. Daily schedule examples are recurEvery: Day, recurEvery: 3Days.  Weekly schedule are formatted as recurEvery: [Frequency as integer]['Week(s)'] [Optional comma separated list of weekdays Monday-Sunday]. Weekly schedule examples are recurEvery: 3Weeks, recurEvery: Week Saturday,Sunday. Monthly schedules are formatted as [Frequency as integer]['Month(s)'] [Comma separated list of month days] or [Frequency as integer]['Month(s)'] [Week of Month (First, Second, Third, Fourth, Last)] [Weekday Monday-Sunday] [Optional Offset(No. of days)]. Offset value must be between -6 to 6 inclusive. Monthly schedule examples are recurEvery: Month, recurEvery: 2Months, recurEvery: Month day23,day24, recurEvery: Month Last Sunday, recurEvery: Month Fourth Monday, recurEvery: Month Last Sunday Offset-3, recurEvery: Month Third Sunday Offset6.
	RecurEvery *string `json:"recurEvery,omitempty"`
}
