package security

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ConnectorGovernanceRulesExecuteStatusClient is the API spec for Microsoft.Security (Azure Security Center) resource
// provider
type ConnectorGovernanceRulesExecuteStatusClient struct {
	BaseClient
}

// NewConnectorGovernanceRulesExecuteStatusClient creates an instance of the
// ConnectorGovernanceRulesExecuteStatusClient client.
func NewConnectorGovernanceRulesExecuteStatusClient(subscriptionID string) ConnectorGovernanceRulesExecuteStatusClient {
	return NewConnectorGovernanceRulesExecuteStatusClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewConnectorGovernanceRulesExecuteStatusClientWithBaseURI creates an instance of the
// ConnectorGovernanceRulesExecuteStatusClient client using a custom endpoint.  Use this when interacting with an Azure
// cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewConnectorGovernanceRulesExecuteStatusClientWithBaseURI(baseURI string, subscriptionID string) ConnectorGovernanceRulesExecuteStatusClient {
	return ConnectorGovernanceRulesExecuteStatusClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get a specific governanceRule execution status for the requested scope by ruleId and operationId
// Parameters:
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
// securityConnectorName - the security connector name.
// ruleID - the security GovernanceRule key - unique key for the standard GovernanceRule
// operationID - the security GovernanceRule execution key - unique key for the execution of GovernanceRule
func (client ConnectorGovernanceRulesExecuteStatusClient) Get(ctx context.Context, resourceGroupName string, securityConnectorName string, ruleID string, operationID string) (result ConnectorGovernanceRulesExecuteStatusGetFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectorGovernanceRulesExecuteStatusClient.Get")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.ConnectorGovernanceRulesExecuteStatusClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, securityConnectorName, ruleID, operationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.ConnectorGovernanceRulesExecuteStatusClient", "Get", nil, "Failure preparing request")
		return
	}

	result, err = client.GetSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.ConnectorGovernanceRulesExecuteStatusClient", "Get", result.Response(), "Failure sending request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client ConnectorGovernanceRulesExecuteStatusClient) GetPreparer(ctx context.Context, resourceGroupName string, securityConnectorName string, ruleID string, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"operationId":           autorest.Encode("path", operationID),
		"resourceGroupName":     autorest.Encode("path", resourceGroupName),
		"ruleId":                autorest.Encode("path", ruleID),
		"securityConnectorName": autorest.Encode("path", securityConnectorName),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-01-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/providers/Microsoft.Security/governanceRules/{ruleId}/operationResults/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ConnectorGovernanceRulesExecuteStatusClient) GetSender(req *http.Request) (future ConnectorGovernanceRulesExecuteStatusGetFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ConnectorGovernanceRulesExecuteStatusClient) GetResponder(resp *http.Response) (result ExecuteRuleStatus, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
