/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// ApplicationLoadBalancerProperties struct for ApplicationLoadBalancerProperties
type ApplicationLoadBalancerProperties struct {
	// Collection of the Application Load Balancer IP addresses. (Inbound and outbound) IPs of the 'listenerLan' are customer-reserved public IPs for the public load balancers, and private IPs for the private load balancers.
	Ips *[]string `json:"ips,omitempty"`
	// Collection of private IP addresses with the subnet mask of the Application Load Balancer. IPs must contain valid a subnet mask. If no IP is provided, the system will generate an IP with /24 subnet.
	LbPrivateIps *[]string `json:"lbPrivateIps,omitempty"`
	// The ID of the listening (inbound) LAN.
	ListenerLan *int32 `json:"listenerLan"`
	// The Application Load Balancer name.
	Name *string `json:"name"`
	// The ID of the balanced private target LAN (outbound).
	TargetLan *int32 `json:"targetLan"`
}

// NewApplicationLoadBalancerProperties instantiates a new ApplicationLoadBalancerProperties object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewApplicationLoadBalancerProperties(listenerLan int32, name string, targetLan int32) *ApplicationLoadBalancerProperties {
	this := ApplicationLoadBalancerProperties{}

	this.ListenerLan = &listenerLan
	this.Name = &name
	this.TargetLan = &targetLan

	return &this
}

// NewApplicationLoadBalancerPropertiesWithDefaults instantiates a new ApplicationLoadBalancerProperties object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewApplicationLoadBalancerPropertiesWithDefaults() *ApplicationLoadBalancerProperties {
	this := ApplicationLoadBalancerProperties{}
	return &this
}

// GetIps returns the Ips field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerProperties) GetIps() *[]string {
	if o == nil {
		return nil
	}

	return o.Ips

}

// GetIpsOk returns a tuple with the Ips field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerProperties) GetIpsOk() (*[]string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Ips, true
}

// SetIps sets field value
func (o *ApplicationLoadBalancerProperties) SetIps(v []string) {

	o.Ips = &v

}

// HasIps returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerProperties) HasIps() bool {
	if o != nil && o.Ips != nil {
		return true
	}

	return false
}

// GetLbPrivateIps returns the LbPrivateIps field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerProperties) GetLbPrivateIps() *[]string {
	if o == nil {
		return nil
	}

	return o.LbPrivateIps

}

// GetLbPrivateIpsOk returns a tuple with the LbPrivateIps field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerProperties) GetLbPrivateIpsOk() (*[]string, bool) {
	if o == nil {
		return nil, false
	}

	return o.LbPrivateIps, true
}

// SetLbPrivateIps sets field value
func (o *ApplicationLoadBalancerProperties) SetLbPrivateIps(v []string) {

	o.LbPrivateIps = &v

}

// HasLbPrivateIps returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerProperties) HasLbPrivateIps() bool {
	if o != nil && o.LbPrivateIps != nil {
		return true
	}

	return false
}

// GetListenerLan returns the ListenerLan field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerProperties) GetListenerLan() *int32 {
	if o == nil {
		return nil
	}

	return o.ListenerLan

}

// GetListenerLanOk returns a tuple with the ListenerLan field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerProperties) GetListenerLanOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.ListenerLan, true
}

// SetListenerLan sets field value
func (o *ApplicationLoadBalancerProperties) SetListenerLan(v int32) {

	o.ListenerLan = &v

}

// HasListenerLan returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerProperties) HasListenerLan() bool {
	if o != nil && o.ListenerLan != nil {
		return true
	}

	return false
}

// GetName returns the Name field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerProperties) GetName() *string {
	if o == nil {
		return nil
	}

	return o.Name

}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerProperties) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Name, true
}

// SetName sets field value
func (o *ApplicationLoadBalancerProperties) SetName(v string) {

	o.Name = &v

}

// HasName returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerProperties) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

// GetTargetLan returns the TargetLan field value
// If the value is explicit nil, nil is returned
func (o *ApplicationLoadBalancerProperties) GetTargetLan() *int32 {
	if o == nil {
		return nil
	}

	return o.TargetLan

}

// GetTargetLanOk returns a tuple with the TargetLan field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ApplicationLoadBalancerProperties) GetTargetLanOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.TargetLan, true
}

// SetTargetLan sets field value
func (o *ApplicationLoadBalancerProperties) SetTargetLan(v int32) {

	o.TargetLan = &v

}

// HasTargetLan returns a boolean if a field has been set.
func (o *ApplicationLoadBalancerProperties) HasTargetLan() bool {
	if o != nil && o.TargetLan != nil {
		return true
	}

	return false
}

func (o ApplicationLoadBalancerProperties) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Ips != nil {
		toSerialize["ips"] = o.Ips
	}

	if o.LbPrivateIps != nil {
		toSerialize["lbPrivateIps"] = o.LbPrivateIps
	}

	if o.ListenerLan != nil {
		toSerialize["listenerLan"] = o.ListenerLan
	}

	if o.Name != nil {
		toSerialize["name"] = o.Name
	}

	if o.TargetLan != nil {
		toSerialize["targetLan"] = o.TargetLan
	}

	return json.Marshal(toSerialize)
}

type NullableApplicationLoadBalancerProperties struct {
	value *ApplicationLoadBalancerProperties
	isSet bool
}

func (v NullableApplicationLoadBalancerProperties) Get() *ApplicationLoadBalancerProperties {
	return v.value
}

func (v *NullableApplicationLoadBalancerProperties) Set(val *ApplicationLoadBalancerProperties) {
	v.value = val
	v.isSet = true
}

func (v NullableApplicationLoadBalancerProperties) IsSet() bool {
	return v.isSet
}

func (v *NullableApplicationLoadBalancerProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableApplicationLoadBalancerProperties(val *ApplicationLoadBalancerProperties) *NullableApplicationLoadBalancerProperties {
	return &NullableApplicationLoadBalancerProperties{value: val, isSet: true}
}

func (v NullableApplicationLoadBalancerProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableApplicationLoadBalancerProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
