// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/containeranalysis/v1alpha1/package_vulnerability.proto

package containeranalysis

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Note provider-assigned severity/impact ranking
type VulnerabilityType_Severity int32

const (
	// Unknown Impact
	VulnerabilityType_SEVERITY_UNSPECIFIED VulnerabilityType_Severity = 0
	// Minimal Impact
	VulnerabilityType_MINIMAL VulnerabilityType_Severity = 1
	// Low Impact
	VulnerabilityType_LOW VulnerabilityType_Severity = 2
	// Medium Impact
	VulnerabilityType_MEDIUM VulnerabilityType_Severity = 3
	// High Impact
	VulnerabilityType_HIGH VulnerabilityType_Severity = 4
	// Critical Impact
	VulnerabilityType_CRITICAL VulnerabilityType_Severity = 5
)

var VulnerabilityType_Severity_name = map[int32]string{
	0: "SEVERITY_UNSPECIFIED",
	1: "MINIMAL",
	2: "LOW",
	3: "MEDIUM",
	4: "HIGH",
	5: "CRITICAL",
}
var VulnerabilityType_Severity_value = map[string]int32{
	"SEVERITY_UNSPECIFIED": 0,
	"MINIMAL":              1,
	"LOW":                  2,
	"MEDIUM":               3,
	"HIGH":                 4,
	"CRITICAL":             5,
}

func (x VulnerabilityType_Severity) String() string {
	return proto.EnumName(VulnerabilityType_Severity_name, int32(x))
}
func (VulnerabilityType_Severity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 0}
}

// Whether this is an ordinary package version or a
// sentinel MIN/MAX version.
type VulnerabilityType_Version_VersionKind int32

const (
	// A standard package version, defined by the other fields.
	VulnerabilityType_Version_NORMAL VulnerabilityType_Version_VersionKind = 0
	// A special version representing negative infinity,
	// other fields are ignored.
	VulnerabilityType_Version_MINIMUM VulnerabilityType_Version_VersionKind = 1
	// A special version representing positive infinity,
	// other fields are ignored.
	VulnerabilityType_Version_MAXIMUM VulnerabilityType_Version_VersionKind = 2
)

var VulnerabilityType_Version_VersionKind_name = map[int32]string{
	0: "NORMAL",
	1: "MINIMUM",
	2: "MAXIMUM",
}
var VulnerabilityType_Version_VersionKind_value = map[string]int32{
	"NORMAL":  0,
	"MINIMUM": 1,
	"MAXIMUM": 2,
}

func (x VulnerabilityType_Version_VersionKind) String() string {
	return proto.EnumName(VulnerabilityType_Version_VersionKind_name, int32(x))
}
func (VulnerabilityType_Version_VersionKind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 0, 0}
}

// VulnerabilityType provides metadata about a security vulnerability.
type VulnerabilityType struct {
	// The CVSS score for this Vulnerability.
	CvssScore float32 `protobuf:"fixed32,2,opt,name=cvss_score,json=cvssScore" json:"cvss_score,omitempty"`
	// Note provider assigned impact of the vulnerability
	Severity VulnerabilityType_Severity `protobuf:"varint,3,opt,name=severity,enum=google.devtools.containeranalysis.v1alpha1.VulnerabilityType_Severity" json:"severity,omitempty"`
	// All information about the package to specifically identify this
	// vulnerability. One entry per (version range and cpe_uri) the
	// package vulnerability has manifested in.
	Details []*VulnerabilityType_Detail `protobuf:"bytes,4,rep,name=details" json:"details,omitempty"`
}

func (m *VulnerabilityType) Reset()                    { *m = VulnerabilityType{} }
func (m *VulnerabilityType) String() string            { return proto.CompactTextString(m) }
func (*VulnerabilityType) ProtoMessage()               {}
func (*VulnerabilityType) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *VulnerabilityType) GetCvssScore() float32 {
	if m != nil {
		return m.CvssScore
	}
	return 0
}

func (m *VulnerabilityType) GetSeverity() VulnerabilityType_Severity {
	if m != nil {
		return m.Severity
	}
	return VulnerabilityType_SEVERITY_UNSPECIFIED
}

func (m *VulnerabilityType) GetDetails() []*VulnerabilityType_Detail {
	if m != nil {
		return m.Details
	}
	return nil
}

// Version contains structured information about the version of the package.
// For a discussion of this in Debian/Ubuntu:
// http://serverfault.com/questions/604541/debian-packages-version-convention
// For a discussion of this in Redhat/Fedora/Centos:
// http://blog.jasonantman.com/2014/07/how-yum-and-rpm-compare-versions/
type VulnerabilityType_Version struct {
	// Used to correct mistakes in the version numbering scheme.
	Epoch int32 `protobuf:"varint,1,opt,name=epoch" json:"epoch,omitempty"`
	// The main part of the version name.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// The iteration of the package build from the above version.
	Revision string `protobuf:"bytes,3,opt,name=revision" json:"revision,omitempty"`
	// Distinguish between sentinel MIN/MAX versions and normal versions.
	// If kind is not NORMAL, then the other fields are ignored.
	Kind VulnerabilityType_Version_VersionKind `protobuf:"varint,5,opt,name=kind,enum=google.devtools.containeranalysis.v1alpha1.VulnerabilityType_Version_VersionKind" json:"kind,omitempty"`
}

func (m *VulnerabilityType_Version) Reset()                    { *m = VulnerabilityType_Version{} }
func (m *VulnerabilityType_Version) String() string            { return proto.CompactTextString(m) }
func (*VulnerabilityType_Version) ProtoMessage()               {}
func (*VulnerabilityType_Version) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 0} }

func (m *VulnerabilityType_Version) GetEpoch() int32 {
	if m != nil {
		return m.Epoch
	}
	return 0
}

func (m *VulnerabilityType_Version) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VulnerabilityType_Version) GetRevision() string {
	if m != nil {
		return m.Revision
	}
	return ""
}

func (m *VulnerabilityType_Version) GetKind() VulnerabilityType_Version_VersionKind {
	if m != nil {
		return m.Kind
	}
	return VulnerabilityType_Version_NORMAL
}

// Identifies all occurrences of this vulnerability in the package for a
// specific distro/location
// For example: glibc in cpe:/o:debian:debian_linux:8 for versions 2.1 - 2.2
type VulnerabilityType_Detail struct {
	// The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/) in
	// which the vulnerability manifests.  Examples include distro or storage
	// location for vulnerable jar.
	// This field can be used as a filter in list requests.
	CpeUri string `protobuf:"bytes,1,opt,name=cpe_uri,json=cpeUri" json:"cpe_uri,omitempty"`
	// The name of the package where the vulnerability was found.
	// This field can be used as a filter in list requests.
	Package string `protobuf:"bytes,8,opt,name=package" json:"package,omitempty"`
	// The min version of the package in which the vulnerability exists.
	MinAffectedVersion *VulnerabilityType_Version `protobuf:"bytes,6,opt,name=min_affected_version,json=minAffectedVersion" json:"min_affected_version,omitempty"`
	// The max version of the package in which the vulnerability exists.
	// This field can be used as a filter in list requests.
	MaxAffectedVersion *VulnerabilityType_Version `protobuf:"bytes,7,opt,name=max_affected_version,json=maxAffectedVersion" json:"max_affected_version,omitempty"`
	// The severity (eg: distro assigned severity) for this vulnerability.
	SeverityName string `protobuf:"bytes,4,opt,name=severity_name,json=severityName" json:"severity_name,omitempty"`
	// A vendor-specific description of this note.
	Description string `protobuf:"bytes,9,opt,name=description" json:"description,omitempty"`
	// The fix for this specific package version.
	FixedLocation *VulnerabilityType_VulnerabilityLocation `protobuf:"bytes,5,opt,name=fixed_location,json=fixedLocation" json:"fixed_location,omitempty"`
	// The type of package; whether native or non native(ruby gems,
	// node.js packages etc)
	PackageType string `protobuf:"bytes,10,opt,name=package_type,json=packageType" json:"package_type,omitempty"`
}

func (m *VulnerabilityType_Detail) Reset()                    { *m = VulnerabilityType_Detail{} }
func (m *VulnerabilityType_Detail) String() string            { return proto.CompactTextString(m) }
func (*VulnerabilityType_Detail) ProtoMessage()               {}
func (*VulnerabilityType_Detail) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0, 1} }

func (m *VulnerabilityType_Detail) GetCpeUri() string {
	if m != nil {
		return m.CpeUri
	}
	return ""
}

func (m *VulnerabilityType_Detail) GetPackage() string {
	if m != nil {
		return m.Package
	}
	return ""
}

func (m *VulnerabilityType_Detail) GetMinAffectedVersion() *VulnerabilityType_Version {
	if m != nil {
		return m.MinAffectedVersion
	}
	return nil
}

func (m *VulnerabilityType_Detail) GetMaxAffectedVersion() *VulnerabilityType_Version {
	if m != nil {
		return m.MaxAffectedVersion
	}
	return nil
}

func (m *VulnerabilityType_Detail) GetSeverityName() string {
	if m != nil {
		return m.SeverityName
	}
	return ""
}

func (m *VulnerabilityType_Detail) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *VulnerabilityType_Detail) GetFixedLocation() *VulnerabilityType_VulnerabilityLocation {
	if m != nil {
		return m.FixedLocation
	}
	return nil
}

func (m *VulnerabilityType_Detail) GetPackageType() string {
	if m != nil {
		return m.PackageType
	}
	return ""
}

// Used by Occurrence to point to where the vulnerability exists and how
// to fix it.
type VulnerabilityType_VulnerabilityDetails struct {
	// The type of package; whether native or non native(ruby gems,
	// node.js packages etc)
	Type string `protobuf:"bytes,3,opt,name=type" json:"type,omitempty"`
	// Output only. The note provider assigned Severity of the vulnerability.
	Severity VulnerabilityType_Severity `protobuf:"varint,4,opt,name=severity,enum=google.devtools.containeranalysis.v1alpha1.VulnerabilityType_Severity" json:"severity,omitempty"`
	// Output only. The CVSS score of this vulnerability. CVSS score is on a
	// scale of 0-10 where 0 indicates low severity and 10 indicates high
	// severity.
	CvssScore float32 `protobuf:"fixed32,5,opt,name=cvss_score,json=cvssScore" json:"cvss_score,omitempty"`
	// The set of affected locations and their fixes (if available) within
	// the associated resource.
	PackageIssue []*VulnerabilityType_PackageIssue `protobuf:"bytes,6,rep,name=package_issue,json=packageIssue" json:"package_issue,omitempty"`
}

func (m *VulnerabilityType_VulnerabilityDetails) Reset() {
	*m = VulnerabilityType_VulnerabilityDetails{}
}
func (m *VulnerabilityType_VulnerabilityDetails) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityType_VulnerabilityDetails) ProtoMessage()    {}
func (*VulnerabilityType_VulnerabilityDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 2}
}

func (m *VulnerabilityType_VulnerabilityDetails) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *VulnerabilityType_VulnerabilityDetails) GetSeverity() VulnerabilityType_Severity {
	if m != nil {
		return m.Severity
	}
	return VulnerabilityType_SEVERITY_UNSPECIFIED
}

func (m *VulnerabilityType_VulnerabilityDetails) GetCvssScore() float32 {
	if m != nil {
		return m.CvssScore
	}
	return 0
}

func (m *VulnerabilityType_VulnerabilityDetails) GetPackageIssue() []*VulnerabilityType_PackageIssue {
	if m != nil {
		return m.PackageIssue
	}
	return nil
}

// This message wraps a location affected by a vulnerability and its
// associated fix (if one is available).
type VulnerabilityType_PackageIssue struct {
	// The location of the vulnerability.
	AffectedLocation *VulnerabilityType_VulnerabilityLocation `protobuf:"bytes,1,opt,name=affected_location,json=affectedLocation" json:"affected_location,omitempty"`
	// The location of the available fix for vulnerability.
	FixedLocation *VulnerabilityType_VulnerabilityLocation `protobuf:"bytes,2,opt,name=fixed_location,json=fixedLocation" json:"fixed_location,omitempty"`
	// The severity (eg: distro assigned severity) for this vulnerability.
	SeverityName string `protobuf:"bytes,3,opt,name=severity_name,json=severityName" json:"severity_name,omitempty"`
}

func (m *VulnerabilityType_PackageIssue) Reset()         { *m = VulnerabilityType_PackageIssue{} }
func (m *VulnerabilityType_PackageIssue) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityType_PackageIssue) ProtoMessage()    {}
func (*VulnerabilityType_PackageIssue) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 3}
}

func (m *VulnerabilityType_PackageIssue) GetAffectedLocation() *VulnerabilityType_VulnerabilityLocation {
	if m != nil {
		return m.AffectedLocation
	}
	return nil
}

func (m *VulnerabilityType_PackageIssue) GetFixedLocation() *VulnerabilityType_VulnerabilityLocation {
	if m != nil {
		return m.FixedLocation
	}
	return nil
}

func (m *VulnerabilityType_PackageIssue) GetSeverityName() string {
	if m != nil {
		return m.SeverityName
	}
	return ""
}

// The location of the vulnerability
type VulnerabilityType_VulnerabilityLocation struct {
	// The cpe_uri in [cpe format] (https://cpe.mitre.org/specification/)
	// format. Examples include distro or storage location for vulnerable jar.
	// This field can be used as a filter in list requests.
	CpeUri string `protobuf:"bytes,1,opt,name=cpe_uri,json=cpeUri" json:"cpe_uri,omitempty"`
	// The package being described.
	Package string `protobuf:"bytes,2,opt,name=package" json:"package,omitempty"`
	// The version of the package being described.
	// This field can be used as a filter in list requests.
	Version *VulnerabilityType_Version `protobuf:"bytes,4,opt,name=version" json:"version,omitempty"`
}

func (m *VulnerabilityType_VulnerabilityLocation) Reset() {
	*m = VulnerabilityType_VulnerabilityLocation{}
}
func (m *VulnerabilityType_VulnerabilityLocation) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityType_VulnerabilityLocation) ProtoMessage()    {}
func (*VulnerabilityType_VulnerabilityLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{0, 4}
}

func (m *VulnerabilityType_VulnerabilityLocation) GetCpeUri() string {
	if m != nil {
		return m.CpeUri
	}
	return ""
}

func (m *VulnerabilityType_VulnerabilityLocation) GetPackage() string {
	if m != nil {
		return m.Package
	}
	return ""
}

func (m *VulnerabilityType_VulnerabilityLocation) GetVersion() *VulnerabilityType_Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func init() {
	proto.RegisterType((*VulnerabilityType)(nil), "google.devtools.containeranalysis.v1alpha1.VulnerabilityType")
	proto.RegisterType((*VulnerabilityType_Version)(nil), "google.devtools.containeranalysis.v1alpha1.VulnerabilityType.Version")
	proto.RegisterType((*VulnerabilityType_Detail)(nil), "google.devtools.containeranalysis.v1alpha1.VulnerabilityType.Detail")
	proto.RegisterType((*VulnerabilityType_VulnerabilityDetails)(nil), "google.devtools.containeranalysis.v1alpha1.VulnerabilityType.VulnerabilityDetails")
	proto.RegisterType((*VulnerabilityType_PackageIssue)(nil), "google.devtools.containeranalysis.v1alpha1.VulnerabilityType.PackageIssue")
	proto.RegisterType((*VulnerabilityType_VulnerabilityLocation)(nil), "google.devtools.containeranalysis.v1alpha1.VulnerabilityType.VulnerabilityLocation")
	proto.RegisterEnum("google.devtools.containeranalysis.v1alpha1.VulnerabilityType_Severity", VulnerabilityType_Severity_name, VulnerabilityType_Severity_value)
	proto.RegisterEnum("google.devtools.containeranalysis.v1alpha1.VulnerabilityType_Version_VersionKind", VulnerabilityType_Version_VersionKind_name, VulnerabilityType_Version_VersionKind_value)
}

func init() {
	proto.RegisterFile("google/devtools/containeranalysis/v1alpha1/package_vulnerability.proto", fileDescriptor3)
}

var fileDescriptor3 = []byte{
	// 750 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x56, 0xcf, 0x6e, 0xda, 0x4c,
	0x10, 0xff, 0x6c, 0x0c, 0x86, 0x81, 0x44, 0xce, 0x8a, 0x4f, 0x9f, 0x85, 0xbe, 0x4a, 0x34, 0x55,
	0x25, 0xd4, 0x83, 0x51, 0xc8, 0xb1, 0x27, 0x0a, 0x24, 0x71, 0x0b, 0x24, 0x35, 0x21, 0xfd, 0x27,
	0xc5, 0xda, 0x98, 0x0d, 0x59, 0xc5, 0x78, 0x2d, 0xdb, 0xa1, 0xa1, 0xa7, 0x3e, 0x40, 0x6f, 0xbd,
	0xf7, 0xd0, 0x6b, 0x6f, 0x7d, 0xa0, 0xbe, 0x40, 0x5f, 0xa2, 0xf2, 0xda, 0x8b, 0x20, 0xb4, 0x52,
	0x24, 0x92, 0x9e, 0xf0, 0xcc, 0x78, 0x7f, 0xbf, 0x99, 0x9d, 0xdf, 0x0c, 0x86, 0xbd, 0x31, 0x63,
	0x63, 0x97, 0xd4, 0x47, 0x64, 0x1a, 0x31, 0xe6, 0x86, 0x75, 0x87, 0x79, 0x11, 0xa6, 0x1e, 0x09,
	0xb0, 0x87, 0xdd, 0x59, 0x48, 0xc3, 0xfa, 0x74, 0x07, 0xbb, 0xfe, 0x05, 0xde, 0xa9, 0xfb, 0xd8,
	0xb9, 0xc4, 0x63, 0x62, 0x4f, 0xaf, 0xdc, 0x38, 0x7e, 0x46, 0x5d, 0x1a, 0xcd, 0x0c, 0x3f, 0x60,
	0x11, 0x43, 0x4f, 0x12, 0x1c, 0x43, 0xe0, 0x18, 0x2b, 0x38, 0x86, 0xc0, 0xa9, 0xfc, 0x9f, 0x72,
	0x62, 0x9f, 0xd6, 0xb1, 0xe7, 0xb1, 0x08, 0x47, 0x94, 0x79, 0x61, 0x82, 0xb4, 0xfd, 0x63, 0x13,
	0xb6, 0x4e, 0x16, 0x19, 0x8e, 0x67, 0x3e, 0x41, 0x0f, 0x00, 0x9c, 0x69, 0x18, 0xda, 0xa1, 0xc3,
	0x02, 0xa2, 0xcb, 0x55, 0xa9, 0x26, 0x5b, 0x85, 0xd8, 0x33, 0x88, 0x1d, 0xe8, 0x0c, 0xf2, 0x21,
	0x99, 0x92, 0x80, 0x46, 0x33, 0x3d, 0x53, 0x95, 0x6a, 0x9b, 0x8d, 0x3d, 0xe3, 0xf6, 0x19, 0x19,
	0x2b, 0x7c, 0xc6, 0x20, 0x45, 0xb3, 0xe6, 0xb8, 0xe8, 0x14, 0xd4, 0x11, 0x89, 0x30, 0x75, 0x43,
	0x5d, 0xa9, 0x66, 0x6a, 0xc5, 0x46, 0x7b, 0x3d, 0x8a, 0x36, 0x07, 0xb3, 0x04, 0x68, 0xe5, 0xa7,
	0x04, 0xea, 0x09, 0x09, 0x42, 0xca, 0x3c, 0x54, 0x86, 0x2c, 0xf1, 0x99, 0x73, 0xa1, 0x4b, 0x55,
	0xa9, 0x96, 0xb5, 0x12, 0x03, 0x21, 0x50, 0x3c, 0x3c, 0x49, 0xca, 0x2f, 0x58, 0xfc, 0x19, 0x55,
	0x20, 0x1f, 0x90, 0x29, 0x8d, 0x4f, 0xf1, 0xca, 0x0b, 0xd6, 0xdc, 0x46, 0x04, 0x94, 0x4b, 0xea,
	0x8d, 0xf4, 0x2c, 0xbf, 0x91, 0x97, 0xeb, 0xa5, 0x9b, 0xa6, 0x26, 0x7e, 0x5f, 0x50, 0x6f, 0x64,
	0x71, 0xf8, 0xed, 0x5d, 0x28, 0x2e, 0x38, 0x11, 0x40, 0xae, 0x7f, 0x68, 0xf5, 0x9a, 0x5d, 0xed,
	0x1f, 0x54, 0x04, 0xb5, 0x67, 0xf6, 0xcd, 0xde, 0xb0, 0xa7, 0x49, 0xdc, 0x68, 0xbe, 0xe6, 0x86,
	0x5c, 0xf9, 0xac, 0x40, 0x2e, 0xb9, 0x01, 0xf4, 0x1f, 0xa8, 0x8e, 0x4f, 0xec, 0xab, 0x80, 0xf2,
	0x72, 0x0b, 0x56, 0xce, 0xf1, 0xc9, 0x30, 0xa0, 0x48, 0x07, 0x35, 0xd5, 0x9c, 0x9e, 0xe7, 0x01,
	0x61, 0xa2, 0xf7, 0x50, 0x9e, 0x50, 0xcf, 0xc6, 0xe7, 0xe7, 0xc4, 0x89, 0xc8, 0xc8, 0x9e, 0x26,
	0xfc, 0x7a, 0xae, 0x2a, 0xd5, 0x8a, 0x8d, 0xce, 0x9d, 0x54, 0x6a, 0xa1, 0x09, 0xf5, 0x9a, 0x29,
	0x83, 0x68, 0x4c, 0x4c, 0x8c, 0xaf, 0x57, 0x89, 0xd5, 0xbb, 0x25, 0xc6, 0xd7, 0x37, 0x89, 0x1f,
	0xc1, 0x86, 0x50, 0xa2, 0xcd, 0x45, 0xa0, 0xf0, 0x1b, 0x29, 0x09, 0x67, 0x3f, 0x16, 0x43, 0x15,
	0x8a, 0x23, 0x12, 0x3a, 0x01, 0xf5, 0xe3, 0x89, 0xd2, 0x0b, 0xfc, 0x95, 0x45, 0x17, 0xfa, 0x00,
	0x9b, 0xe7, 0xf4, 0x9a, 0x8c, 0x6c, 0x97, 0x39, 0x7c, 0xec, 0xb8, 0x38, 0x8a, 0x8d, 0xc1, 0x9a,
	0x99, 0x2f, 0x7a, 0xba, 0x29, 0xb4, 0xb5, 0xc1, 0xa9, 0x84, 0x89, 0x1e, 0x42, 0x49, 0xac, 0x90,
	0x68, 0xe6, 0x13, 0x1d, 0x92, 0xf4, 0x52, 0x5f, 0x8c, 0x53, 0xf9, 0x22, 0x43, 0x79, 0x09, 0x2b,
	0x91, 0x48, 0x18, 0x4b, 0x9f, 0x9f, 0x49, 0x24, 0xce, 0x9f, 0x97, 0x86, 0x5e, 0xb9, 0xa7, 0xa1,
	0x5f, 0xde, 0x3b, 0xd9, 0x9b, 0x7b, 0x87, 0xc1, 0x86, 0x28, 0x89, 0x86, 0xe1, 0x15, 0xd1, 0x73,
	0x7c, 0x33, 0x3c, 0x5f, 0x2f, 0x8f, 0xa3, 0x04, 0xd2, 0x8c, 0x11, 0x2d, 0x71, 0x67, 0xdc, 0xaa,
	0x7c, 0x97, 0xa1, 0xb4, 0x18, 0x46, 0x1f, 0x25, 0xd8, 0x9a, 0xab, 0x71, 0xde, 0x54, 0xe9, 0xfe,
	0x9a, 0xaa, 0x09, 0xb6, 0x79, 0x5f, 0x57, 0x35, 0x25, 0xff, 0x35, 0x4d, 0xad, 0x8c, 0x45, 0x66,
	0x75, 0x2c, 0x2a, 0xdf, 0x24, 0xf8, 0xf7, 0xb7, 0x68, 0xb7, 0x5a, 0x3d, 0xf2, 0xf2, 0xea, 0xb1,
	0x41, 0x15, 0x43, 0xaf, 0xdc, 0xe5, 0xd0, 0x0b, 0xd4, 0xed, 0x53, 0xc8, 0x0b, 0x21, 0x22, 0x1d,
	0xca, 0x83, 0xce, 0x49, 0xc7, 0x32, 0x8f, 0xdf, 0xd8, 0xc3, 0xfe, 0xe0, 0xa8, 0xd3, 0x32, 0xf7,
	0xcc, 0x4e, 0x7b, 0x61, 0xb3, 0x36, 0xbb, 0x9a, 0x84, 0x54, 0xc8, 0x74, 0x0f, 0x5f, 0x69, 0x72,
	0xbc, 0x7b, 0x7b, 0x9d, 0xb6, 0x39, 0xec, 0x69, 0x19, 0x94, 0x07, 0xe5, 0xc0, 0xdc, 0x3f, 0xd0,
	0x14, 0x54, 0x82, 0x7c, 0xcb, 0x32, 0x8f, 0xcd, 0x56, 0xb3, 0xab, 0x65, 0x9f, 0x7d, 0x92, 0xe0,
	0xb1, 0xc3, 0x26, 0x22, 0xeb, 0x3f, 0x27, 0x7b, 0x24, 0xbd, 0x7d, 0x97, 0xbe, 0x34, 0x66, 0x2e,
	0xf6, 0xc6, 0x06, 0x0b, 0xc6, 0xf5, 0x31, 0xf1, 0xf8, 0x1f, 0x75, 0x3d, 0x09, 0x61, 0x9f, 0x86,
	0xb7, 0xf9, 0x7a, 0x78, 0xba, 0x12, 0xfa, 0x2a, 0x67, 0xf6, 0x5b, 0xcd, 0xb3, 0x1c, 0x47, 0xdb,
	0xfd, 0x15, 0x00, 0x00, 0xff, 0xff, 0xe7, 0xe7, 0xb7, 0xf5, 0x8a, 0x08, 0x00, 0x00,
}
