# gozerbot/lockmanager.py
#
#

""" manages locks """

__copyright__ = 'this file is in the public domain'

from log import rlog
import thread, threading

class Lockmanager(object):

    """ place to hold locks """

    def __init__(self):
        self.locks = {}

    def allocate(self, name):
        """ allocate a new lock """
        self.locks[name] = thread.allocate_lock()
        rlog(0, 'lockmanager', 'allocated %s' % name)
        
    def get(self, name):
        """ get lock """
        if not self.locks.has_key(name):
            self.allocate(name)
        return self.locks[name]
        
    def delete(self, name):
        """ delete lock """
        if self.locks.has_key(name):
            del self.locks[name]

    def acquire(self, name):
        """ acquire lock """
        if not self.locks.has_key(name):
            self.allocate(name)
        rlog(0, 'lockmanager', 'acquire %s' % name)
        self.locks[name].acquire()

    def release(self, name):
        """ release lock """
        rlog(0, 'lockmanager', 'releasing %s' % name)
        self.locks[name].release()


class RLockManager(Lockmanager):

    def allocate(self, name):
        """ allocate a new lock """
        self.locks[name] = threading.RLock()
        rlog(0, 'lockmanager', 'allocated RLock %s' % name)

lockmanager = Lockmanager()
rlockmanager = RLockManager()
