#!/usr/bin/env python
### Copyright (C) 2010 Peter Williams <peter_ono@users.sourceforge.net>

### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; version 2 of the License only.

### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.

### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from distutils.core import setup
import os
import glob

NAME = 'gquilt'

VERSION = '0.25'

DESCRIPTION = 'a PyGTK GUI wrapper for quilt and/or Mercurial Queues (mq)'

LONG_DESCRIPTION =\
'''
Quilt (quilt) is a tool for managing patches.
Mercurial (hg) is a distributed source control tool and Mercurial Queues (mq)
is a patch management tool extension to hg.
gquilt is a PyGTK GUI wrapper for quilt and/or mq.
'''

pixmaps = glob.glob('pixmaps/*.png')

PIXMAPS = [('share/pixmaps', ['gquilt.png']), ('share/pixmaps/gquilt', pixmaps)]

COPYRIGHT = [('share/doc/gquilt', ['COPYING', 'copyright'])]

LICENSE = 'GNU General Public License (GPL) Version 2.0'

CLASSIFIERS = [
    'Development Status :: Alpha',
    'Intended Audience :: Developers',
    'License :: OSI Approved :: %s' % LICENSE,
    'Programming Language :: Python',
    'Topic :: Software Development :: Source Control',
    'Operating System :: MacOS :: MacOS X',
    'Operating System :: Microsoft :: Windows',
    'Operating System :: POSIX',
]

AUTHOR = 'Peter Williams'

AUTHOR_EMAIL = 'peter_ono@users.sourceforge.net'

URL = 'http://gquilt.sourceforge.net/'

SCRIPTS = ['gquilt']

PACKAGES = ['gquilt_pkg']

DATA_FILES = PIXMAPS + [('/etc/gquilt.d', ['gquilt_pkg/qbsfe.sh'])]

setup(
    name = NAME,
    version = VERSION,
    description = DESCRIPTION,
    long_description = LONG_DESCRIPTION,
    classifiers = CLASSIFIERS,
    license = LICENSE,
    author = AUTHOR,
    author_email = AUTHOR_EMAIL,
    url = URL,
    scripts = SCRIPTS,
    packages = PACKAGES,
    data_files = DATA_FILES
)
