/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.TypeConverterFactory;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyTypeConverter
implements TypeConverter<Object> {
    private Locale locale;

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Collection<? extends Object> convert(String input, Class<? extends Object> targetType, Collection<ValidationError> errors) {
        TypeConverter converter = this.getSingleItemTypeConverter(targetType);
        String[] splits = input.split(this.getSplitRegex());
        Collection items = this.getCollectionInstance();
        for (String split : splits) {
            Object item = converter.convert(split, targetType, errors);
            if (item == null) continue;
            items.add(item);
        }
        return items.size() > 0 ? items : null;
    }

    public Collection getCollectionInstance() {
        return new LinkedList();
    }

    protected String getSplitRegex() {
        return ",?[ ]+";
    }

    protected TypeConverter getSingleItemTypeConverter(Class targetType) {
        try {
            TypeConverterFactory factory = StripesFilter.getConfiguration().getTypeConverterFactory();
            return factory.getTypeConverter(targetType, this.locale);
        }
        catch (Exception e) {
            throw new StripesRuntimeException("You are using the OneToManyTypeConverter to convert a String to a List of items for which there is no registered converter! Please check that the TypeConverterFactory knows how to make a converter for: " + targetType, e);
        }
    }
}

