/*
 * =======================================================================================
 *
 *      Filename:  perfmon_sapphirerapids_counters.h
 *
 *      Description:  Counter Header File of perfmon module for Intel Sapphire Rapids.
 *
 *      Version:   5.3
 *      Released:  10.11.2023
 *
 *      Author:   Thomas Gruber (tr), thomas.roehl@googlemail.com
 *      Project:  likwid
 *
 *      Copyright (C) 2023 RRZE, University Erlangen-Nuremberg
 *
 *      This program is free software: you can redistribute it and/or modify it under
 *      the terms of the GNU General Public License as published by the Free Software
 *      Foundation, either version 3 of the License, or (at your option) any later
 *      version.
 *
 *      This program is distributed in the hope that it will be useful, but WITHOUT ANY
 *      WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 *      PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along with
 *      this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * =======================================================================================
 */

#include <intel_perfmon_uncore_discovery.h>

#define NUM_COUNTERS_SAPPHIRERAPIDS 1015
#define NUM_COUNTERS_CORE_SAPPHIRERAPIDS 18
#define NUM_COUNTERS_UNCORE_SAPPHIRERAPIDS 5


#define SPR_VALID_OPTIONS_FIXED EVENT_OPTION_ANYTHREAD_MASK|EVENT_OPTION_COUNT_KERNEL_MASK
#define SPR_VALID_OPTIONS_PMC EVENT_OPTION_EDGE_MASK|EVENT_OPTION_COUNT_KERNEL_MASK|EVENT_OPTION_INVERT_MASK| \
            EVENT_OPTION_ANYTHREAD_MASK|EVENT_OPTION_IN_TRANS_MASK|EVENT_OPTION_THRESHOLD_MASK

#define SPR_VALID_OPTIONS_CBOX  EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|\
                                EVENT_OPTION_THRESHOLD_MASK|EVENT_OPTION_TID_MASK
#define SPR_VALID_OPTIONS_UNCORE EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|\
                                 EVENT_OPTION_THRESHOLD_MASK

/*#define MSR_UNC_SPR_C0_PMON_BOX_CTL     0x2000*/
/*//#define MSR_UNC_SPR_C0_PMON_BOX_STATUS  0x2001*/
/*#define MSR_UNC_SPR_C0_PMON_CTL0        0x2002*/
/*#define MSR_UNC_SPR_C0_PMON_CTL1        0x2003*/
/*#define MSR_UNC_SPR_C0_PMON_CTL2        0x2004*/
/*#define MSR_UNC_SPR_C0_PMON_CTL3        0x2005*/
/*#define MSR_UNC_SPR_C0_PMON_CTR0        0x2008*/
/*#define MSR_UNC_SPR_C0_PMON_CTR1        0x2009*/
/*#define MSR_UNC_SPR_C0_PMON_CTR2        0x200A*/
/*#define MSR_UNC_SPR_C0_PMON_CTR3        0x200B*/
/*//#define MSR_UNC_SPR_C0_PMON_BOX_FILTER  0x200C*/



static RegisterMap sapphirerapids_counter_map[NUM_COUNTERS_SAPPHIRERAPIDS] = {
    /* Fixed Counters: instructions retired, cycles unhalted core */
    {"FIXC0", PMC0, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR0, 0, MSR_DEV, SPR_VALID_OPTIONS_FIXED},
    {"FIXC1", PMC1, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR1, 0, MSR_DEV, SPR_VALID_OPTIONS_FIXED},
    {"FIXC2", PMC2, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR2, 0, MSR_DEV, SPR_VALID_OPTIONS_FIXED},
    {"FIXC3", PMC3, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR3, 0, MSR_DEV, SPR_VALID_OPTIONS_FIXED},
    /* PMC Counters: 4 48bit wide */
    {"PMC0", PMC4, PMC, MSR_PERFEVTSEL0, MSR_PMC0, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC},
    {"PMC1", PMC5, PMC, MSR_PERFEVTSEL1, MSR_PMC1, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC},
    {"PMC2", PMC6, PMC, MSR_PERFEVTSEL2, MSR_PMC2, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC|EVENT_OPTION_IN_TRANS_ABORT_MASK},
    {"PMC3", PMC7, PMC, MSR_PERFEVTSEL3, MSR_PMC3, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC},
    /* Additional PMC Counters if HyperThreading is not active: 4 48bit wide */
    {"PMC4", PMC8, PMC, MSR_PERFEVTSEL4, MSR_PMC4, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC},
    {"PMC5", PMC9, PMC, MSR_PERFEVTSEL5, MSR_PMC5, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC},
    {"PMC6", PMC10, PMC, MSR_PERFEVTSEL6, MSR_PMC6, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC|EVENT_OPTION_IN_TRANS_ABORT_MASK},
    {"PMC7", PMC11, PMC, MSR_PERFEVTSEL7, MSR_PMC7, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC},
    /* Temperature Sensor*/
    {"TMP0", PMC12, THERMAL, 0, IA32_THERM_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    /* Vcore Status*/
    {"VTG0", PMC13, VOLTAGE, 0, MSR_PERF_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    /* Intel Performance Metrics */
    {"TMA0", PMC14, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA1", PMC15, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA2", PMC16, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA3", PMC17, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA4", PMC18, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA5", PMC19, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA6", PMC20, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA7", PMC21, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    /* RAPL counters */
    {"PWR0", PMC22, POWER, 0, MSR_PKG_ENERGY_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR1", PMC23, POWER, 0, MSR_PP0_ENERGY_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR2", PMC24, POWER, 0, MSR_PP1_ENERGY_STATUS,  0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR3", PMC25, POWER, 0, MSR_DRAM_ENERGY_STATUS,  0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR4", PMC26, POWER, 0, MSR_PLATFORM_ENERGY_STATUS,  0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    // Memory controllers
    {"MBOX0C0", PMC27, MBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX0C1", PMC28, MBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX0C2", PMC29, MBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX0C3", PMC30, MBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX0FIX", PMC31, MBOX0FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_0_CH_0, EVENT_OPTION_NONE_MASK},
    {"MBOX1C0", PMC32, MBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX1C1", PMC33, MBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX1C2", PMC34, MBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX1C3", PMC35, MBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX1FIX", PMC36, MBOX1FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_0_CH_1, EVENT_OPTION_NONE_MASK},
    {"MBOX2C0", PMC37, MBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX2C1", PMC38, MBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX2C2", PMC39, MBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX2C3", PMC40, MBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX2FIX", PMC41, MBOX2FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_0_CH_2, EVENT_OPTION_NONE_MASK},
    {"MBOX3C0", PMC42, MBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX3C1", PMC43, MBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX3C2", PMC44, MBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX3C3", PMC45, MBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX3FIX", PMC46, MBOX3FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_0_CH_3, EVENT_OPTION_NONE_MASK},
    {"MBOX4C0", PMC47, MBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_4, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX4C1", PMC48, MBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_4, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX4C2", PMC49, MBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_4, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX4C3", PMC50, MBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_4, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX4FIX", PMC51, MBOX4FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_0_CH_4, EVENT_OPTION_NONE_MASK},
    {"MBOX5C0", PMC52, MBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_5, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX5C1", PMC53, MBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_5, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX5C2", PMC54, MBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_5, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX5C3", PMC55, MBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_5, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX5FIX", PMC56, MBOX5FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_0_CH_5, EVENT_OPTION_NONE_MASK},
    {"MBOX6C0", PMC57, MBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_6, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX6C1", PMC58, MBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_6, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX6C2", PMC59, MBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_6, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX6C3", PMC60, MBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_6, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX6FIX", PMC61, MBOX6FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_0_CH_6, EVENT_OPTION_NONE_MASK},
    {"MBOX7C0", PMC62, MBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_7, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX7C1", PMC63, MBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_7, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX7C2", PMC64, MBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_7, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX7C3", PMC65, MBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_7, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX7FIX", PMC66, MBOX7FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_0_CH_7, EVENT_OPTION_NONE_MASK},
    {"MBOX8C0", PMC67, MBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX8C1", PMC68, MBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX8C2", PMC69, MBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX8C3", PMC70, MBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX8FIX", PMC71, MBOX8FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_1_CH_0, EVENT_OPTION_NONE_MASK},
    {"MBOX9C0", PMC72, MBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX9C1", PMC73, MBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX9C2", PMC74, MBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX9C3", PMC75, MBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX9FIX", PMC76, MBOX9FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_1_CH_1, EVENT_OPTION_NONE_MASK},
    {"MBOX10C0", PMC77, MBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX10C1", PMC78, MBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX10C2", PMC79, MBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX10C3", PMC80, MBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX10FIX", PMC81, MBOX10FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_1_CH_2, EVENT_OPTION_NONE_MASK},
    {"MBOX11C0", PMC82, MBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX11C1", PMC83, MBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX11C2", PMC84, MBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX11C3", PMC85, MBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX11FIX", PMC86, MBOX11FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_1_CH_3, EVENT_OPTION_NONE_MASK},
    {"MBOX12C0", PMC87, MBOX12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_4, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX12C1", PMC88, MBOX12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_4, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX12C2", PMC89, MBOX12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_4, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX12C3", PMC90, MBOX12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_4, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX12FIX", PMC91, MBOX12FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_1_CH_4, EVENT_OPTION_NONE_MASK},
    {"MBOX13C0", PMC92, MBOX13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_5, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX13C1", PMC93, MBOX13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_5, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX13C2", PMC94, MBOX13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_5, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX13C3", PMC95, MBOX13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_5, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX13FIX", PMC96, MBOX13FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_1_CH_5, EVENT_OPTION_NONE_MASK},
    {"MBOX14C0", PMC97, MBOX14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_6, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX14C1", PMC98, MBOX14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_6, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX14C2", PMC99, MBOX14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_6, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX14C3", PMC100, MBOX14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_6, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX14FIX", PMC101, MBOX14FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_1_CH_6, EVENT_OPTION_NONE_MASK},
    {"MBOX15C0", PMC102, MBOX15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_7, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX15C1", PMC103, MBOX15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_7, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX15C2", PMC104, MBOX15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_7, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX15C3", PMC105, MBOX15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_7, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX15FIX", PMC106, MBOX15FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_IMC_DEVICE_1_CH_7, EVENT_OPTION_NONE_MASK},
    {"MDF0C0", PMC107, MDF0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"MDF0C1", PMC108, MDF0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"MDF0C2", PMC109, MDF0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"MDF0C3", PMC110, MDF0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"MDF1C0", PMC111, MDF1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"MDF1C1", PMC112, MDF1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"MDF1C2", PMC113, MDF1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"MDF1C3", PMC114, MDF1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"MDF2C0", PMC115, MDF2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"MDF2C1", PMC116, MDF2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"MDF2C2", PMC117, MDF2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"MDF2C3", PMC118, MDF2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"MDF3C0", PMC119, MDF3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"MDF3C1", PMC120, MDF3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"MDF3C2", PMC121, MDF3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"MDF3C3", PMC122, MDF3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"MDF4C0", PMC123, MDF4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"MDF4C1", PMC124, MDF4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"MDF4C2", PMC125, MDF4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"MDF4C3", PMC126, MDF4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"MDF5C0", PMC127, MDF5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"MDF5C1", PMC128, MDF5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"MDF5C2", PMC129, MDF5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"MDF5C3", PMC130, MDF5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"MDF6C0", PMC131, MDF6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"MDF6C1", PMC132, MDF6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"MDF6C2", PMC133, MDF6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"MDF6C3", PMC134, MDF6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"MDF7C0", PMC135, MDF7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"MDF7C1", PMC136, MDF7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"MDF7C2", PMC137, MDF7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"MDF7C3", PMC138, MDF7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"MDF8C0", PMC139, MDF8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"MDF8C1", PMC140, MDF8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"MDF8C2", PMC141, MDF8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"MDF8C3", PMC142, MDF8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"MDF9C0", PMC143, MDF9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"MDF9C1", PMC144, MDF9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"MDF9C2", PMC145, MDF9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"MDF9C3", PMC146, MDF9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"MDF10C0", PMC147, MDF10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"MDF10C1", PMC148, MDF10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"MDF10C2", PMC149, MDF10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"MDF10C3", PMC150, MDF10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"MDF11C0", PMC151, MDF11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"MDF11C1", PMC152, MDF11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"MDF11C2", PMC153, MDF11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"MDF11C3", PMC154, MDF11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"MDF12C0", PMC155, MDF12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"MDF12C1", PMC156, MDF12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"MDF12C2", PMC157, MDF12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"MDF12C3", PMC158, MDF12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"MDF13C0", PMC159, MDF13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"MDF13C1", PMC160, MDF13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"MDF13C2", PMC161, MDF13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"MDF13C3", PMC162, MDF13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"MDF14C0", PMC163, MDF14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"MDF14C1", PMC164, MDF14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"MDF14C2", PMC165, MDF14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"MDF14C3", PMC166, MDF14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"MDF15C0", PMC167, MDF15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"MDF15C1", PMC168, MDF15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"MDF15C2", PMC169, MDF15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"MDF15C3", PMC170, MDF15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"MDF16C0", PMC171, MDF16, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"MDF16C1", PMC172, MDF16, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"MDF16C2", PMC173, MDF16, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"MDF16C3", PMC174, MDF16, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"MDF17C0", PMC175, MDF17, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"MDF17C1", PMC176, MDF17, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"MDF17C2", PMC177, MDF17, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"MDF17C3", PMC178, MDF17, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"MDF18C0", PMC179, MDF18, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"MDF18C1", PMC180, MDF18, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"MDF18C2", PMC181, MDF18, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"MDF18C3", PMC182, MDF18, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"MDF19C0", PMC183, MDF19, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"MDF19C1", PMC184, MDF19, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"MDF19C2", PMC185, MDF19, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"MDF19C3", PMC186, MDF19, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"MDF20C0", PMC187, MDF20, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"MDF20C1", PMC188, MDF20, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"MDF20C2", PMC189, MDF20, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"MDF20C3", PMC190, MDF20, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"MDF21C0", PMC191, MDF21, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"MDF21C1", PMC192, MDF21, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"MDF21C2", PMC193, MDF21, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"MDF21C3", PMC194, MDF21, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"MDF22C0", PMC195, MDF22, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"MDF22C1", PMC196, MDF22, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"MDF22C2", PMC197, MDF22, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"MDF22C3", PMC198, MDF22, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"MDF23C0", PMC199, MDF23, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"MDF23C1", PMC200, MDF23, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"MDF23C2", PMC201, MDF23, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"MDF23C3", PMC202, MDF23, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"MDF24C0", PMC203, MDF24, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"MDF24C1", PMC204, MDF24, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"MDF24C2", PMC205, MDF24, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"MDF24C3", PMC206, MDF24, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"MDF25C0", PMC207, MDF25, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"MDF25C1", PMC208, MDF25, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"MDF25C2", PMC209, MDF25, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"MDF25C3", PMC210, MDF25, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"MDF26C0", PMC211, MDF26, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"MDF26C1", PMC212, MDF26, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"MDF26C2", PMC213, MDF26, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"MDF26C3", PMC214, MDF26, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"MDF27C0", PMC215, MDF27, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"MDF27C1", PMC216, MDF27, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"MDF27C2", PMC217, MDF27, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"MDF27C3", PMC218, MDF27, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"MDF28C0", PMC219, MDF28, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"MDF28C1", PMC220, MDF28, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"MDF28C2", PMC221, MDF28, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"MDF28C3", PMC222, MDF28, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"MDF29C0", PMC223, MDF29, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"MDF29C1", PMC224, MDF29, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"MDF29C2", PMC225, MDF29, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"MDF29C3", PMC226, MDF29, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"MDF30C0", PMC227, MDF30, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"MDF30C1", PMC228, MDF30, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"MDF30C2", PMC229, MDF30, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"MDF30C3", PMC230, MDF30, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"MDF31C0", PMC231, MDF31, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"MDF31C1", PMC232, MDF31, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"MDF31C2", PMC233, MDF31, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"MDF31C3", PMC234, MDF31, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"MDF32C0", PMC235, MDF32, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_32, SPR_VALID_OPTIONS_UNCORE},
    {"MDF32C1", PMC236, MDF32, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_32, SPR_VALID_OPTIONS_UNCORE},
    {"MDF32C2", PMC237, MDF32, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_32, SPR_VALID_OPTIONS_UNCORE},
    {"MDF32C3", PMC238, MDF32, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_32, SPR_VALID_OPTIONS_UNCORE},
    {"MDF33C0", PMC239, MDF33, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_33, SPR_VALID_OPTIONS_UNCORE},
    {"MDF33C1", PMC240, MDF33, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_33, SPR_VALID_OPTIONS_UNCORE},
    {"MDF33C2", PMC241, MDF33, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_33, SPR_VALID_OPTIONS_UNCORE},
    {"MDF33C3", PMC242, MDF33, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_33, SPR_VALID_OPTIONS_UNCORE},
    {"MDF34C0", PMC243, MDF34, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_34, SPR_VALID_OPTIONS_UNCORE},
    {"MDF34C1", PMC244, MDF34, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_34, SPR_VALID_OPTIONS_UNCORE},
    {"MDF34C2", PMC245, MDF34, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_34, SPR_VALID_OPTIONS_UNCORE},
    {"MDF34C3", PMC246, MDF34, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_34, SPR_VALID_OPTIONS_UNCORE},
    {"MDF35C0", PMC247, MDF35, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_35, SPR_VALID_OPTIONS_UNCORE},
    {"MDF35C1", PMC248, MDF35, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_35, SPR_VALID_OPTIONS_UNCORE},
    {"MDF35C2", PMC249, MDF35, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_35, SPR_VALID_OPTIONS_UNCORE},
    {"MDF35C3", PMC250, MDF35, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_35, SPR_VALID_OPTIONS_UNCORE},
    {"MDF36C0", PMC251, MDF36, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_36, SPR_VALID_OPTIONS_UNCORE},
    {"MDF36C1", PMC252, MDF36, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_36, SPR_VALID_OPTIONS_UNCORE},
    {"MDF36C2", PMC253, MDF36, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_36, SPR_VALID_OPTIONS_UNCORE},
    {"MDF36C3", PMC254, MDF36, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_36, SPR_VALID_OPTIONS_UNCORE},
    {"MDF37C0", PMC255, MDF37, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_37, SPR_VALID_OPTIONS_UNCORE},
    {"MDF37C1", PMC256, MDF37, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_37, SPR_VALID_OPTIONS_UNCORE},
    {"MDF37C2", PMC257, MDF37, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_37, SPR_VALID_OPTIONS_UNCORE},
    {"MDF37C3", PMC258, MDF37, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_37, SPR_VALID_OPTIONS_UNCORE},
    {"MDF38C0", PMC259, MDF38, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_38, SPR_VALID_OPTIONS_UNCORE},
    {"MDF38C1", PMC260, MDF38, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_38, SPR_VALID_OPTIONS_UNCORE},
    {"MDF38C2", PMC261, MDF38, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_38, SPR_VALID_OPTIONS_UNCORE},
    {"MDF38C3", PMC262, MDF38, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_38, SPR_VALID_OPTIONS_UNCORE},
    {"MDF39C0", PMC263, MDF39, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_39, SPR_VALID_OPTIONS_UNCORE},
    {"MDF39C1", PMC264, MDF39, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_39, SPR_VALID_OPTIONS_UNCORE},
    {"MDF39C2", PMC265, MDF39, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_39, SPR_VALID_OPTIONS_UNCORE},
    {"MDF39C3", PMC266, MDF39, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_39, SPR_VALID_OPTIONS_UNCORE},
    {"MDF40C0", PMC267, MDF40, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_40, SPR_VALID_OPTIONS_UNCORE},
    {"MDF40C1", PMC268, MDF40, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_40, SPR_VALID_OPTIONS_UNCORE},
    {"MDF40C2", PMC269, MDF40, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_40, SPR_VALID_OPTIONS_UNCORE},
    {"MDF40C3", PMC270, MDF40, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_40, SPR_VALID_OPTIONS_UNCORE},
    {"MDF41C0", PMC271, MDF41, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_41, SPR_VALID_OPTIONS_UNCORE},
    {"MDF41C1", PMC272, MDF41, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_41, SPR_VALID_OPTIONS_UNCORE},
    {"MDF41C2", PMC273, MDF41, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_41, SPR_VALID_OPTIONS_UNCORE},
    {"MDF41C3", PMC274, MDF41, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_41, SPR_VALID_OPTIONS_UNCORE},
    {"MDF42C0", PMC275, MDF42, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_42, SPR_VALID_OPTIONS_UNCORE},
    {"MDF42C1", PMC276, MDF42, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_42, SPR_VALID_OPTIONS_UNCORE},
    {"MDF42C2", PMC277, MDF42, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_42, SPR_VALID_OPTIONS_UNCORE},
    {"MDF42C3", PMC278, MDF42, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_42, SPR_VALID_OPTIONS_UNCORE},
    {"MDF43C0", PMC279, MDF43, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_43, SPR_VALID_OPTIONS_UNCORE},
    {"MDF43C1", PMC280, MDF43, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_43, SPR_VALID_OPTIONS_UNCORE},
    {"MDF43C2", PMC281, MDF43, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_43, SPR_VALID_OPTIONS_UNCORE},
    {"MDF43C3", PMC282, MDF43, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_43, SPR_VALID_OPTIONS_UNCORE},
    {"MDF44C0", PMC283, MDF44, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_44, SPR_VALID_OPTIONS_UNCORE},
    {"MDF44C1", PMC284, MDF44, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_44, SPR_VALID_OPTIONS_UNCORE},
    {"MDF44C2", PMC285, MDF44, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_44, SPR_VALID_OPTIONS_UNCORE},
    {"MDF44C3", PMC286, MDF44, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_44, SPR_VALID_OPTIONS_UNCORE},
    {"MDF45C0", PMC287, MDF45, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_45, SPR_VALID_OPTIONS_UNCORE},
    {"MDF45C1", PMC288, MDF45, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_45, SPR_VALID_OPTIONS_UNCORE},
    {"MDF45C2", PMC289, MDF45, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_45, SPR_VALID_OPTIONS_UNCORE},
    {"MDF45C3", PMC290, MDF45, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_45, SPR_VALID_OPTIONS_UNCORE},
    {"MDF46C0", PMC291, MDF46, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_46, SPR_VALID_OPTIONS_UNCORE},
    {"MDF46C1", PMC292, MDF46, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_46, SPR_VALID_OPTIONS_UNCORE},
    {"MDF46C2", PMC293, MDF46, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_46, SPR_VALID_OPTIONS_UNCORE},
    {"MDF46C3", PMC294, MDF46, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_46, SPR_VALID_OPTIONS_UNCORE},
    {"MDF47C0", PMC295, MDF47, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_47, SPR_VALID_OPTIONS_UNCORE},
    {"MDF47C1", PMC296, MDF47, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_47, SPR_VALID_OPTIONS_UNCORE},
    {"MDF47C2", PMC297, MDF47, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_47, SPR_VALID_OPTIONS_UNCORE},
    {"MDF47C3", PMC298, MDF47, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_47, SPR_VALID_OPTIONS_UNCORE},
    {"MDF48C0", PMC299, MDF48, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_48, SPR_VALID_OPTIONS_UNCORE},
    {"MDF48C1", PMC300, MDF48, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_48, SPR_VALID_OPTIONS_UNCORE},
    {"MDF48C2", PMC301, MDF48, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_48, SPR_VALID_OPTIONS_UNCORE},
    {"MDF48C3", PMC302, MDF48, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_48, SPR_VALID_OPTIONS_UNCORE},
    {"MDF49C0", PMC303, MDF49, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_49, SPR_VALID_OPTIONS_UNCORE},
    {"MDF49C1", PMC304, MDF49, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_49, SPR_VALID_OPTIONS_UNCORE},
    {"MDF49C2", PMC305, MDF49, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_49, SPR_VALID_OPTIONS_UNCORE},
    {"MDF49C3", PMC306, MDF49, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_49, SPR_VALID_OPTIONS_UNCORE},
    // Caching home agent (CHa))
    {"CBOX0C0", PMC307, CBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C0, SPR_VALID_OPTIONS_CBOX},
    {"CBOX0C1", PMC308, CBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C0, SPR_VALID_OPTIONS_CBOX},
    {"CBOX0C2", PMC309, CBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C0, SPR_VALID_OPTIONS_CBOX},
    {"CBOX0C3", PMC310, CBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C0, SPR_VALID_OPTIONS_CBOX},
    {"CBOX1C0", PMC311, CBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C1, SPR_VALID_OPTIONS_CBOX},
    {"CBOX1C1", PMC312, CBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C1, SPR_VALID_OPTIONS_CBOX},
    {"CBOX1C2", PMC313, CBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C1, SPR_VALID_OPTIONS_CBOX},
    {"CBOX1C3", PMC314, CBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C1, SPR_VALID_OPTIONS_CBOX},
    {"CBOX2C0", PMC315, CBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C2, SPR_VALID_OPTIONS_CBOX},
    {"CBOX2C1", PMC316, CBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C2, SPR_VALID_OPTIONS_CBOX},
    {"CBOX2C2", PMC317, CBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C2, SPR_VALID_OPTIONS_CBOX},
    {"CBOX2C3", PMC318, CBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C2, SPR_VALID_OPTIONS_CBOX},
    {"CBOX3C0", PMC319, CBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C3, SPR_VALID_OPTIONS_CBOX},
    {"CBOX3C1", PMC320, CBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C3, SPR_VALID_OPTIONS_CBOX},
    {"CBOX3C2", PMC321, CBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C3, SPR_VALID_OPTIONS_CBOX},
    {"CBOX3C3", PMC322, CBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C3, SPR_VALID_OPTIONS_CBOX},
    {"CBOX4C0", PMC323, CBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C4, SPR_VALID_OPTIONS_CBOX},
    {"CBOX4C1", PMC324, CBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C4, SPR_VALID_OPTIONS_CBOX},
    {"CBOX4C2", PMC325, CBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C4, SPR_VALID_OPTIONS_CBOX},
    {"CBOX4C3", PMC326, CBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C4, SPR_VALID_OPTIONS_CBOX},
    {"CBOX5C0", PMC327, CBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C5, SPR_VALID_OPTIONS_CBOX},
    {"CBOX5C1", PMC328, CBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C5, SPR_VALID_OPTIONS_CBOX},
    {"CBOX5C2", PMC329, CBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C5, SPR_VALID_OPTIONS_CBOX},
    {"CBOX5C3", PMC330, CBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C5, SPR_VALID_OPTIONS_CBOX},
    {"CBOX6C0", PMC331, CBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C6, SPR_VALID_OPTIONS_CBOX},
    {"CBOX6C1", PMC332, CBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C6, SPR_VALID_OPTIONS_CBOX},
    {"CBOX6C2", PMC333, CBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C6, SPR_VALID_OPTIONS_CBOX},
    {"CBOX6C3", PMC334, CBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C6, SPR_VALID_OPTIONS_CBOX},
    {"CBOX7C0", PMC335, CBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C7, SPR_VALID_OPTIONS_CBOX},
    {"CBOX7C1", PMC336, CBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C7, SPR_VALID_OPTIONS_CBOX},
    {"CBOX7C2", PMC337, CBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C7, SPR_VALID_OPTIONS_CBOX},
    {"CBOX7C3", PMC338, CBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C7, SPR_VALID_OPTIONS_CBOX},
    {"CBOX8C0", PMC339, CBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C8, SPR_VALID_OPTIONS_CBOX},
    {"CBOX8C1", PMC340, CBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C8, SPR_VALID_OPTIONS_CBOX},
    {"CBOX8C2", PMC341, CBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C8, SPR_VALID_OPTIONS_CBOX},
    {"CBOX8C3", PMC342, CBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C8, SPR_VALID_OPTIONS_CBOX},
    {"CBOX9C0", PMC343, CBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C9, SPR_VALID_OPTIONS_CBOX},
    {"CBOX9C1", PMC344, CBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C9, SPR_VALID_OPTIONS_CBOX},
    {"CBOX9C2", PMC345, CBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C9, SPR_VALID_OPTIONS_CBOX},
    {"CBOX9C3", PMC346, CBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C9, SPR_VALID_OPTIONS_CBOX},
    {"CBOX10C0", PMC347, CBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C10, SPR_VALID_OPTIONS_CBOX},
    {"CBOX10C1", PMC348, CBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C10, SPR_VALID_OPTIONS_CBOX},
    {"CBOX10C2", PMC349, CBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C10, SPR_VALID_OPTIONS_CBOX},
    {"CBOX10C3", PMC350, CBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C10, SPR_VALID_OPTIONS_CBOX},
    {"CBOX11C0", PMC351, CBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C11, SPR_VALID_OPTIONS_CBOX},
    {"CBOX11C1", PMC352, CBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C11, SPR_VALID_OPTIONS_CBOX},
    {"CBOX11C2", PMC353, CBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C11, SPR_VALID_OPTIONS_CBOX},
    {"CBOX11C3", PMC354, CBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C11, SPR_VALID_OPTIONS_CBOX},
    {"CBOX12C0", PMC355, CBOX12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C12, SPR_VALID_OPTIONS_CBOX},
    {"CBOX12C1", PMC356, CBOX12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C12, SPR_VALID_OPTIONS_CBOX},
    {"CBOX12C2", PMC357, CBOX12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C12, SPR_VALID_OPTIONS_CBOX},
    {"CBOX12C3", PMC358, CBOX12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C12, SPR_VALID_OPTIONS_CBOX},
    {"CBOX13C0", PMC359, CBOX13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C13, SPR_VALID_OPTIONS_CBOX},
    {"CBOX13C1", PMC360, CBOX13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C13, SPR_VALID_OPTIONS_CBOX},
    {"CBOX13C2", PMC361, CBOX13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C13, SPR_VALID_OPTIONS_CBOX},
    {"CBOX13C3", PMC362, CBOX13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C13, SPR_VALID_OPTIONS_CBOX},
    {"CBOX14C0", PMC363, CBOX14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C14, SPR_VALID_OPTIONS_CBOX},
    {"CBOX14C1", PMC364, CBOX14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C14, SPR_VALID_OPTIONS_CBOX},
    {"CBOX14C2", PMC365, CBOX14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C14, SPR_VALID_OPTIONS_CBOX},
    {"CBOX14C3", PMC366, CBOX14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C14, SPR_VALID_OPTIONS_CBOX},
    {"CBOX15C0", PMC367, CBOX15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C15, SPR_VALID_OPTIONS_CBOX},
    {"CBOX15C1", PMC368, CBOX15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C15, SPR_VALID_OPTIONS_CBOX},
    {"CBOX15C2", PMC369, CBOX15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C15, SPR_VALID_OPTIONS_CBOX},
    {"CBOX15C3", PMC370, CBOX15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C15, SPR_VALID_OPTIONS_CBOX},
    {"CBOX16C0", PMC371, CBOX16, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C16, SPR_VALID_OPTIONS_CBOX},
    {"CBOX16C1", PMC372, CBOX16, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C16, SPR_VALID_OPTIONS_CBOX},
    {"CBOX16C2", PMC373, CBOX16, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C16, SPR_VALID_OPTIONS_CBOX},
    {"CBOX16C3", PMC374, CBOX16, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C16, SPR_VALID_OPTIONS_CBOX},
    {"CBOX17C0", PMC375, CBOX17, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C17, SPR_VALID_OPTIONS_CBOX},
    {"CBOX17C1", PMC376, CBOX17, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C17, SPR_VALID_OPTIONS_CBOX},
    {"CBOX17C2", PMC377, CBOX17, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C17, SPR_VALID_OPTIONS_CBOX},
    {"CBOX17C3", PMC378, CBOX17, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C17, SPR_VALID_OPTIONS_CBOX},
    {"CBOX18C0", PMC379, CBOX18, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C18, SPR_VALID_OPTIONS_CBOX},
    {"CBOX18C1", PMC380, CBOX18, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C18, SPR_VALID_OPTIONS_CBOX},
    {"CBOX18C2", PMC381, CBOX18, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C18, SPR_VALID_OPTIONS_CBOX},
    {"CBOX18C3", PMC382, CBOX18, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C18, SPR_VALID_OPTIONS_CBOX},
    {"CBOX19C0", PMC383, CBOX19, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C19, SPR_VALID_OPTIONS_CBOX},
    {"CBOX19C1", PMC384, CBOX19, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C19, SPR_VALID_OPTIONS_CBOX},
    {"CBOX19C2", PMC385, CBOX19, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C19, SPR_VALID_OPTIONS_CBOX},
    {"CBOX19C3", PMC386, CBOX19, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C19, SPR_VALID_OPTIONS_CBOX},
    {"CBOX20C0", PMC387, CBOX20, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C20, SPR_VALID_OPTIONS_CBOX},
    {"CBOX20C1", PMC388, CBOX20, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C20, SPR_VALID_OPTIONS_CBOX},
    {"CBOX20C2", PMC389, CBOX20, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C20, SPR_VALID_OPTIONS_CBOX},
    {"CBOX20C3", PMC390, CBOX20, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C20, SPR_VALID_OPTIONS_CBOX},
    {"CBOX21C0", PMC391, CBOX21, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C21, SPR_VALID_OPTIONS_CBOX},
    {"CBOX21C1", PMC392, CBOX21, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C21, SPR_VALID_OPTIONS_CBOX},
    {"CBOX21C2", PMC393, CBOX21, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C21, SPR_VALID_OPTIONS_CBOX},
    {"CBOX21C3", PMC394, CBOX21, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C21, SPR_VALID_OPTIONS_CBOX},
    {"CBOX22C0", PMC395, CBOX22, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C22, SPR_VALID_OPTIONS_CBOX},
    {"CBOX22C1", PMC396, CBOX22, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C22, SPR_VALID_OPTIONS_CBOX},
    {"CBOX22C2", PMC397, CBOX22, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C22, SPR_VALID_OPTIONS_CBOX},
    {"CBOX22C3", PMC398, CBOX22, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C22, SPR_VALID_OPTIONS_CBOX},
    {"CBOX23C0", PMC399, CBOX23, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C23, SPR_VALID_OPTIONS_CBOX},
    {"CBOX23C1", PMC400, CBOX23, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C23, SPR_VALID_OPTIONS_CBOX},
    {"CBOX23C2", PMC401, CBOX23, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C23, SPR_VALID_OPTIONS_CBOX},
    {"CBOX23C3", PMC402, CBOX23, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C23, SPR_VALID_OPTIONS_CBOX},
    {"CBOX24C0", PMC403, CBOX24, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C24, SPR_VALID_OPTIONS_CBOX},
    {"CBOX24C1", PMC404, CBOX24, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C24, SPR_VALID_OPTIONS_CBOX},
    {"CBOX24C2", PMC405, CBOX24, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C24, SPR_VALID_OPTIONS_CBOX},
    {"CBOX24C3", PMC406, CBOX24, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C24, SPR_VALID_OPTIONS_CBOX},
    {"CBOX25C0", PMC407, CBOX25, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C25, SPR_VALID_OPTIONS_CBOX},
    {"CBOX25C1", PMC408, CBOX25, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C25, SPR_VALID_OPTIONS_CBOX},
    {"CBOX25C2", PMC409, CBOX25, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C25, SPR_VALID_OPTIONS_CBOX},
    {"CBOX25C3", PMC410, CBOX25, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C25, SPR_VALID_OPTIONS_CBOX},
    {"CBOX26C0", PMC411, CBOX26, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C26, SPR_VALID_OPTIONS_CBOX},
    {"CBOX26C1", PMC412, CBOX26, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C26, SPR_VALID_OPTIONS_CBOX},
    {"CBOX26C2", PMC413, CBOX26, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C26, SPR_VALID_OPTIONS_CBOX},
    {"CBOX26C3", PMC414, CBOX26, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C26, SPR_VALID_OPTIONS_CBOX},
    {"CBOX27C0", PMC415, CBOX27, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C27, SPR_VALID_OPTIONS_CBOX},
    {"CBOX27C1", PMC416, CBOX27, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C27, SPR_VALID_OPTIONS_CBOX},
    {"CBOX27C2", PMC417, CBOX27, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C27, SPR_VALID_OPTIONS_CBOX},
    {"CBOX27C3", PMC418, CBOX27, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C27, SPR_VALID_OPTIONS_CBOX},
    {"CBOX28C0", PMC419, CBOX28, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C28, SPR_VALID_OPTIONS_CBOX},
    {"CBOX28C1", PMC420, CBOX28, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C28, SPR_VALID_OPTIONS_CBOX},
    {"CBOX28C2", PMC421, CBOX28, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C28, SPR_VALID_OPTIONS_CBOX},
    {"CBOX28C3", PMC422, CBOX28, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C28, SPR_VALID_OPTIONS_CBOX},
    {"CBOX29C0", PMC423, CBOX29, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C29, SPR_VALID_OPTIONS_CBOX},
    {"CBOX29C1", PMC424, CBOX29, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C29, SPR_VALID_OPTIONS_CBOX},
    {"CBOX29C2", PMC425, CBOX29, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C29, SPR_VALID_OPTIONS_CBOX},
    {"CBOX29C3", PMC426, CBOX29, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C29, SPR_VALID_OPTIONS_CBOX},
    {"CBOX30C0", PMC427, CBOX30, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C30, SPR_VALID_OPTIONS_CBOX},
    {"CBOX30C1", PMC428, CBOX30, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C30, SPR_VALID_OPTIONS_CBOX},
    {"CBOX30C2", PMC429, CBOX30, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C30, SPR_VALID_OPTIONS_CBOX},
    {"CBOX30C3", PMC430, CBOX30, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C30, SPR_VALID_OPTIONS_CBOX},
    {"CBOX31C0", PMC431, CBOX31, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C31, SPR_VALID_OPTIONS_CBOX},
    {"CBOX31C1", PMC432, CBOX31, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C31, SPR_VALID_OPTIONS_CBOX},
    {"CBOX31C2", PMC433, CBOX31, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C31, SPR_VALID_OPTIONS_CBOX},
    {"CBOX31C3", PMC434, CBOX31, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C31, SPR_VALID_OPTIONS_CBOX},
    {"CBOX32C0", PMC435, CBOX32, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C32, SPR_VALID_OPTIONS_CBOX},
    {"CBOX32C1", PMC436, CBOX32, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C32, SPR_VALID_OPTIONS_CBOX},
    {"CBOX32C2", PMC437, CBOX32, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C32, SPR_VALID_OPTIONS_CBOX},
    {"CBOX32C3", PMC438, CBOX32, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C32, SPR_VALID_OPTIONS_CBOX},
    {"CBOX33C0", PMC439, CBOX33, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C33, SPR_VALID_OPTIONS_CBOX},
    {"CBOX33C1", PMC440, CBOX33, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C33, SPR_VALID_OPTIONS_CBOX},
    {"CBOX33C2", PMC441, CBOX33, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C33, SPR_VALID_OPTIONS_CBOX},
    {"CBOX33C3", PMC442, CBOX33, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C33, SPR_VALID_OPTIONS_CBOX},
    {"CBOX34C0", PMC443, CBOX34, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C34, SPR_VALID_OPTIONS_CBOX},
    {"CBOX34C1", PMC444, CBOX34, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C34, SPR_VALID_OPTIONS_CBOX},
    {"CBOX34C2", PMC445, CBOX34, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C34, SPR_VALID_OPTIONS_CBOX},
    {"CBOX34C3", PMC446, CBOX34, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C34, SPR_VALID_OPTIONS_CBOX},
    {"CBOX35C0", PMC447, CBOX35, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C35, SPR_VALID_OPTIONS_CBOX},
    {"CBOX35C1", PMC448, CBOX35, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C35, SPR_VALID_OPTIONS_CBOX},
    {"CBOX35C2", PMC449, CBOX35, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C35, SPR_VALID_OPTIONS_CBOX},
    {"CBOX35C3", PMC450, CBOX35, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C35, SPR_VALID_OPTIONS_CBOX},
    {"CBOX36C0", PMC451, CBOX36, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C36, SPR_VALID_OPTIONS_CBOX},
    {"CBOX36C1", PMC452, CBOX36, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C36, SPR_VALID_OPTIONS_CBOX},
    {"CBOX36C2", PMC453, CBOX36, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C36, SPR_VALID_OPTIONS_CBOX},
    {"CBOX36C3", PMC454, CBOX36, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C36, SPR_VALID_OPTIONS_CBOX},
    {"CBOX37C0", PMC455, CBOX37, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C37, SPR_VALID_OPTIONS_CBOX},
    {"CBOX37C1", PMC456, CBOX37, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C37, SPR_VALID_OPTIONS_CBOX},
    {"CBOX37C2", PMC457, CBOX37, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C37, SPR_VALID_OPTIONS_CBOX},
    {"CBOX37C3", PMC458, CBOX37, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C37, SPR_VALID_OPTIONS_CBOX},
    {"CBOX38C0", PMC459, CBOX38, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C38, SPR_VALID_OPTIONS_CBOX},
    {"CBOX38C1", PMC460, CBOX38, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C38, SPR_VALID_OPTIONS_CBOX},
    {"CBOX38C2", PMC461, CBOX38, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C38, SPR_VALID_OPTIONS_CBOX},
    {"CBOX38C3", PMC462, CBOX38, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C38, SPR_VALID_OPTIONS_CBOX},
    {"CBOX39C0", PMC463, CBOX39, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C39, SPR_VALID_OPTIONS_CBOX},
    {"CBOX39C1", PMC464, CBOX39, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C39, SPR_VALID_OPTIONS_CBOX},
    {"CBOX39C2", PMC465, CBOX39, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C39, SPR_VALID_OPTIONS_CBOX},
    {"CBOX39C3", PMC466, CBOX39, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C39, SPR_VALID_OPTIONS_CBOX},
    {"CBOX40C0", PMC467, CBOX40, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C40, SPR_VALID_OPTIONS_CBOX},
    {"CBOX40C1", PMC468, CBOX40, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C40, SPR_VALID_OPTIONS_CBOX},
    {"CBOX40C2", PMC469, CBOX40, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C40, SPR_VALID_OPTIONS_CBOX},
    {"CBOX40C3", PMC470, CBOX40, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C40, SPR_VALID_OPTIONS_CBOX},
    {"CBOX41C0", PMC471, CBOX41, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C41, SPR_VALID_OPTIONS_CBOX},
    {"CBOX41C1", PMC472, CBOX41, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C41, SPR_VALID_OPTIONS_CBOX},
    {"CBOX41C2", PMC473, CBOX41, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C41, SPR_VALID_OPTIONS_CBOX},
    {"CBOX41C3", PMC474, CBOX41, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C41, SPR_VALID_OPTIONS_CBOX},
    {"CBOX42C0", PMC475, CBOX42, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C42, SPR_VALID_OPTIONS_CBOX},
    {"CBOX42C1", PMC476, CBOX42, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C42, SPR_VALID_OPTIONS_CBOX},
    {"CBOX42C2", PMC477, CBOX42, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C42, SPR_VALID_OPTIONS_CBOX},
    {"CBOX42C3", PMC478, CBOX42, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C42, SPR_VALID_OPTIONS_CBOX},
    {"CBOX43C0", PMC479, CBOX43, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C43, SPR_VALID_OPTIONS_CBOX},
    {"CBOX43C1", PMC480, CBOX43, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C43, SPR_VALID_OPTIONS_CBOX},
    {"CBOX43C2", PMC481, CBOX43, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C43, SPR_VALID_OPTIONS_CBOX},
    {"CBOX43C3", PMC482, CBOX43, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C43, SPR_VALID_OPTIONS_CBOX},
    {"CBOX44C0", PMC483, CBOX44, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C44, SPR_VALID_OPTIONS_CBOX},
    {"CBOX44C1", PMC484, CBOX44, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C44, SPR_VALID_OPTIONS_CBOX},
    {"CBOX44C2", PMC485, CBOX44, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C44, SPR_VALID_OPTIONS_CBOX},
    {"CBOX44C3", PMC486, CBOX44, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C44, SPR_VALID_OPTIONS_CBOX},
    {"CBOX45C0", PMC487, CBOX45, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C45, SPR_VALID_OPTIONS_CBOX},
    {"CBOX45C1", PMC488, CBOX45, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C45, SPR_VALID_OPTIONS_CBOX},
    {"CBOX45C2", PMC489, CBOX45, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C45, SPR_VALID_OPTIONS_CBOX},
    {"CBOX45C3", PMC490, CBOX45, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C45, SPR_VALID_OPTIONS_CBOX},
    {"CBOX46C0", PMC491, CBOX46, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C46, SPR_VALID_OPTIONS_CBOX},
    {"CBOX46C1", PMC492, CBOX46, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C46, SPR_VALID_OPTIONS_CBOX},
    {"CBOX46C2", PMC493, CBOX46, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C46, SPR_VALID_OPTIONS_CBOX},
    {"CBOX46C3", PMC494, CBOX46, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C46, SPR_VALID_OPTIONS_CBOX},
    {"CBOX47C0", PMC495, CBOX47, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C47, SPR_VALID_OPTIONS_CBOX},
    {"CBOX47C1", PMC496, CBOX47, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C47, SPR_VALID_OPTIONS_CBOX},
    {"CBOX47C2", PMC497, CBOX47, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C47, SPR_VALID_OPTIONS_CBOX},
    {"CBOX47C3", PMC498, CBOX47, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C47, SPR_VALID_OPTIONS_CBOX},
    {"CBOX48C0", PMC499, CBOX48, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C48, SPR_VALID_OPTIONS_CBOX},
    {"CBOX48C1", PMC500, CBOX48, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C48, SPR_VALID_OPTIONS_CBOX},
    {"CBOX48C2", PMC501, CBOX48, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C48, SPR_VALID_OPTIONS_CBOX},
    {"CBOX48C3", PMC502, CBOX48, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C48, SPR_VALID_OPTIONS_CBOX},
    {"CBOX49C0", PMC503, CBOX49, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C49, SPR_VALID_OPTIONS_CBOX},
    {"CBOX49C1", PMC504, CBOX49, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C49, SPR_VALID_OPTIONS_CBOX},
    {"CBOX49C2", PMC505, CBOX49, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C49, SPR_VALID_OPTIONS_CBOX},
    {"CBOX49C3", PMC506, CBOX49, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C49, SPR_VALID_OPTIONS_CBOX},
    {"CBOX50C0", PMC507, CBOX50, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C50, SPR_VALID_OPTIONS_CBOX},
    {"CBOX50C1", PMC508, CBOX50, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C50, SPR_VALID_OPTIONS_CBOX},
    {"CBOX50C2", PMC509, CBOX50, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C50, SPR_VALID_OPTIONS_CBOX},
    {"CBOX50C3", PMC510, CBOX50, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C50, SPR_VALID_OPTIONS_CBOX},
    {"CBOX51C0", PMC511, CBOX51, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C51, SPR_VALID_OPTIONS_CBOX},
    {"CBOX51C1", PMC512, CBOX51, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C51, SPR_VALID_OPTIONS_CBOX},
    {"CBOX51C2", PMC513, CBOX51, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C51, SPR_VALID_OPTIONS_CBOX},
    {"CBOX51C3", PMC514, CBOX51, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C51, SPR_VALID_OPTIONS_CBOX},
    {"CBOX52C0", PMC515, CBOX52, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C52, SPR_VALID_OPTIONS_CBOX},
    {"CBOX52C1", PMC516, CBOX52, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C52, SPR_VALID_OPTIONS_CBOX},
    {"CBOX52C2", PMC517, CBOX52, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C52, SPR_VALID_OPTIONS_CBOX},
    {"CBOX52C3", PMC518, CBOX52, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C52, SPR_VALID_OPTIONS_CBOX},
    {"CBOX53C0", PMC519, CBOX53, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C53, SPR_VALID_OPTIONS_CBOX},
    {"CBOX53C1", PMC520, CBOX53, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C53, SPR_VALID_OPTIONS_CBOX},
    {"CBOX53C2", PMC521, CBOX53, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C53, SPR_VALID_OPTIONS_CBOX},
    {"CBOX53C3", PMC522, CBOX53, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C53, SPR_VALID_OPTIONS_CBOX},
    {"CBOX54C0", PMC523, CBOX54, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C54, SPR_VALID_OPTIONS_CBOX},
    {"CBOX54C1", PMC524, CBOX54, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C54, SPR_VALID_OPTIONS_CBOX},
    {"CBOX54C2", PMC525, CBOX54, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C54, SPR_VALID_OPTIONS_CBOX},
    {"CBOX54C3", PMC526, CBOX54, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C54, SPR_VALID_OPTIONS_CBOX},
    {"CBOX55C0", PMC527, CBOX55, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C55, SPR_VALID_OPTIONS_CBOX},
    {"CBOX55C1", PMC528, CBOX55, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C55, SPR_VALID_OPTIONS_CBOX},
    {"CBOX55C2", PMC529, CBOX55, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C55, SPR_VALID_OPTIONS_CBOX},
    {"CBOX55C3", PMC530, CBOX55, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C55, SPR_VALID_OPTIONS_CBOX},
    {"M2M0C0", PMC531, BBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"M2M0C1", PMC532, BBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"M2M0C2", PMC533, BBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"M2M0C3", PMC534, BBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"M2M1C0", PMC535, BBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"M2M1C1", PMC536, BBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"M2M1C2", PMC537, BBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"M2M1C3", PMC538, BBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"M2M2C0", PMC539, BBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"M2M2C1", PMC540, BBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"M2M2C2", PMC541, BBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"M2M2C3", PMC542, BBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"M2M3C0", PMC543, BBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"M2M3C1", PMC544, BBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"M2M3C2", PMC545, BBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"M2M3C3", PMC546, BBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"M2M4C0", PMC547, BBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"M2M4C1", PMC548, BBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"M2M4C2", PMC549, BBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"M2M4C3", PMC550, BBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"M2M5C0", PMC551, BBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"M2M5C1", PMC552, BBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"M2M5C2", PMC553, BBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"M2M5C3", PMC554, BBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"M2M6C0", PMC555, BBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"M2M6C1", PMC556, BBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"M2M6C2", PMC557, BBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"M2M6C3", PMC558, BBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"M2M7C0", PMC559, BBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"M2M7C1", PMC560, BBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"M2M7C2", PMC561, BBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"M2M7C3", PMC562, BBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"M2M8C0", PMC563, BBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"M2M8C1", PMC564, BBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"M2M8C2", PMC565, BBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"M2M8C3", PMC566, BBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"M2M9C0", PMC567, BBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"M2M9C1", PMC568, BBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"M2M9C2", PMC569, BBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"M2M9C3", PMC570, BBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"M2M10C0", PMC571, BBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"M2M10C1", PMC572, BBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"M2M10C2", PMC573, BBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"M2M10C3", PMC574, BBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"M2M11C0", PMC575, BBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"M2M11C1", PMC576, BBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"M2M11C2", PMC577, BBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"M2M11C3", PMC578, BBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"M2M12C0", PMC579, BBOX12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"M2M12C1", PMC580, BBOX12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"M2M12C2", PMC581, BBOX12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"M2M12C3", PMC582, BBOX12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"M2M13C0", PMC583, BBOX13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"M2M13C1", PMC584, BBOX13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"M2M13C2", PMC585, BBOX13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"M2M13C3", PMC586, BBOX13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"M2M14C0", PMC587, BBOX14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"M2M14C1", PMC588, BBOX14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"M2M14C2", PMC589, BBOX14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"M2M14C3", PMC590, BBOX14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"M2M15C0", PMC591, BBOX15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"M2M15C1", PMC592, BBOX15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"M2M15C2", PMC593, BBOX15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"M2M15C3", PMC594, BBOX15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"M2M16C0", PMC595, BBOX16, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"M2M16C1", PMC596, BBOX16, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"M2M16C2", PMC597, BBOX16, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"M2M16C3", PMC598, BBOX16, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"M2M17C0", PMC599, BBOX17, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"M2M17C1", PMC600, BBOX17, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"M2M17C2", PMC601, BBOX17, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"M2M17C3", PMC602, BBOX17, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"M2M18C0", PMC603, BBOX18, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"M2M18C1", PMC604, BBOX18, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"M2M18C2", PMC605, BBOX18, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"M2M18C3", PMC606, BBOX18, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"M2M19C0", PMC607, BBOX19, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"M2M19C1", PMC608, BBOX19, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"M2M19C2", PMC609, BBOX19, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"M2M19C3", PMC610, BBOX19, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"M2M20C0", PMC611, BBOX20, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"M2M20C1", PMC612, BBOX20, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"M2M20C2", PMC613, BBOX20, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"M2M20C3", PMC614, BBOX20, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"M2M21C0", PMC615, BBOX21, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"M2M21C1", PMC616, BBOX21, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"M2M21C2", PMC617, BBOX21, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"M2M21C3", PMC618, BBOX21, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"M2M22C0", PMC619, BBOX22, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"M2M22C1", PMC620, BBOX22, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"M2M22C2", PMC621, BBOX22, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"M2M22C3", PMC622, BBOX22, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"M2M23C0", PMC623, BBOX23, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"M2M23C1", PMC624, BBOX23, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"M2M23C2", PMC625, BBOX23, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"M2M23C3", PMC626, BBOX23, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"M2M24C0", PMC627, BBOX24, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"M2M24C1", PMC628, BBOX24, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"M2M24C2", PMC629, BBOX24, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"M2M24C3", PMC630, BBOX24, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"M2M25C0", PMC631, BBOX25, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"M2M25C1", PMC632, BBOX25, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"M2M25C2", PMC633, BBOX25, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"M2M25C3", PMC634, BBOX25, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"M2M26C0", PMC635, BBOX26, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"M2M26C1", PMC636, BBOX26, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"M2M26C2", PMC637, BBOX26, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"M2M26C3", PMC638, BBOX26, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"M2M27C0", PMC639, BBOX27, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"M2M27C1", PMC640, BBOX27, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"M2M27C2", PMC641, BBOX27, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"M2M27C3", PMC642, BBOX27, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"M2M28C0", PMC643, BBOX28, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"M2M28C1", PMC644, BBOX28, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"M2M28C2", PMC645, BBOX28, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"M2M28C3", PMC646, BBOX28, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"M2M29C0", PMC647, BBOX29, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"M2M29C1", PMC648, BBOX29, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"M2M29C2", PMC649, BBOX29, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"M2M29C3", PMC650, BBOX29, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"M2M30C0", PMC651, BBOX30, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"M2M30C1", PMC652, BBOX30, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"M2M30C2", PMC653, BBOX30, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"M2M30C3", PMC654, BBOX30, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"M2M31C0", PMC655, BBOX31, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"M2M31C1", PMC656, BBOX31, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"M2M31C2", PMC657, BBOX31, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"M2M31C3", PMC658, BBOX31, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"UPI0C0", PMC659, QBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_0, SPR_VALID_OPTIONS_UNCORE},
    {"UPI0C1", PMC660, QBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_0, SPR_VALID_OPTIONS_UNCORE},
    {"UPI0C2", PMC661, QBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_0, SPR_VALID_OPTIONS_UNCORE},
    {"UPI0C3", PMC662, QBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_0, SPR_VALID_OPTIONS_UNCORE},
    {"UPI1C0", PMC663, QBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_1, SPR_VALID_OPTIONS_UNCORE},
    {"UPI1C1", PMC664, QBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_1, SPR_VALID_OPTIONS_UNCORE},
    {"UPI1C2", PMC665, QBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_1, SPR_VALID_OPTIONS_UNCORE},
    {"UPI1C3", PMC666, QBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_1, SPR_VALID_OPTIONS_UNCORE},
    {"UPI2C0", PMC667, QBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_2, SPR_VALID_OPTIONS_UNCORE},
    {"UPI2C1", PMC668, QBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_2, SPR_VALID_OPTIONS_UNCORE},
    {"UPI2C2", PMC669, QBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_2, SPR_VALID_OPTIONS_UNCORE},
    {"UPI2C3", PMC670, QBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_2, SPR_VALID_OPTIONS_UNCORE},
    {"UPI3C0", PMC671, QBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_3, SPR_VALID_OPTIONS_UNCORE},
    {"UPI3C1", PMC672, QBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_3, SPR_VALID_OPTIONS_UNCORE},
    {"UPI3C2", PMC673, QBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_3, SPR_VALID_OPTIONS_UNCORE},
    {"UPI3C3", PMC674, QBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_3, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX0C0", PMC675, RBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_0, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX0C1", PMC676, RBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_0, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX0C2", PMC677, RBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_0, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX0C3", PMC678, RBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_0, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX1C0", PMC679, RBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_1, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX1C1", PMC680, RBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_1, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX1C2", PMC681, RBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_1, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX1C3", PMC682, RBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_1, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX2C0", PMC683, RBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_2, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX2C1", PMC684, RBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_2, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX2C2", PMC685, RBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_2, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX2C3", PMC686, RBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_2, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX3C0", PMC687, RBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_3, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX3C1", PMC688, RBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_3, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX3C2", PMC689, RBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_3, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX3C3", PMC690, RBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_3, SPR_VALID_OPTIONS_UNCORE},
    {"PCU0", PMC691, WBOX, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_PCU_DEVICE, SPR_VALID_OPTIONS_UNCORE},
    {"PCU1", PMC692, WBOX, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_PCU_DEVICE, SPR_VALID_OPTIONS_UNCORE},
    {"PCU2", PMC693, WBOX, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_PCU_DEVICE, SPR_VALID_OPTIONS_UNCORE},
    {"PCU3", PMC694, WBOX, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_PCU_DEVICE, SPR_VALID_OPTIONS_UNCORE},
    {"IIO0C0", PMC695, IBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"IIO0C1", PMC696, IBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"IIO0C2", PMC697, IBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"IIO0C3", PMC698, IBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"IIO1C0", PMC699, IBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"IIO1C1", PMC700, IBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"IIO1C2", PMC701, IBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"IIO1C3", PMC702, IBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"IIO2C0", PMC703, IBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"IIO2C1", PMC704, IBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"IIO2C2", PMC705, IBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"IIO2C3", PMC706, IBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"IIO3C0", PMC707, IBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"IIO3C1", PMC708, IBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"IIO3C2", PMC709, IBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"IIO3C3", PMC710, IBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"IIO4C0", PMC711, IBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"IIO4C1", PMC712, IBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"IIO4C2", PMC713, IBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"IIO4C3", PMC714, IBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"IIO5C0", PMC715, IBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"IIO5C1", PMC716, IBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"IIO5C2", PMC717, IBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"IIO5C3", PMC718, IBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"IIO6C0", PMC719, IBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"IIO6C1", PMC720, IBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"IIO6C2", PMC721, IBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"IIO6C3", PMC722, IBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"IIO7C0", PMC723, IBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"IIO7C1", PMC724, IBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"IIO7C2", PMC725, IBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"IIO7C3", PMC726, IBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"IIO8C0", PMC727, IBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"IIO8C1", PMC728, IBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"IIO8C2", PMC729, IBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"IIO8C3", PMC730, IBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"IIO9C0", PMC731, IBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"IIO9C1", PMC732, IBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"IIO9C2", PMC733, IBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"IIO9C3", PMC734, IBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"IIO10C0", PMC735, IBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"IIO10C1", PMC736, IBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"IIO10C2", PMC737, IBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"IIO10C3", PMC738, IBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"IIO11C0", PMC739, IBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"IIO11C1", PMC740, IBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"IIO11C2", PMC741, IBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"IIO11C3", PMC742, IBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"IIO12C0", PMC743, IBOX12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"IIO12C1", PMC744, IBOX12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"IIO12C2", PMC745, IBOX12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"IIO12C3", PMC746, IBOX12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"IIO13C0", PMC747, IBOX13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"IIO13C1", PMC748, IBOX13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"IIO13C2", PMC749, IBOX13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"IIO13C3", PMC750, IBOX13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"IIO14C0", PMC751, IBOX14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"IIO14C1", PMC752, IBOX14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"IIO14C2", PMC753, IBOX14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"IIO14C3", PMC754, IBOX14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"IIO15C0", PMC755, IBOX15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"IIO15C1", PMC756, IBOX15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"IIO15C2", PMC757, IBOX15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"IIO15C3", PMC758, IBOX15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"IRP0C0", PMC759, IRP0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"IRP0C1", PMC760, IRP0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"IRP1C0", PMC761, IRP1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"IRP1C1", PMC762, IRP1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"IRP2C0", PMC763, IRP2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"IRP2C1", PMC764, IRP2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"IRP3C0", PMC765, IRP3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"IRP3C1", PMC766, IRP3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"IRP4C0", PMC767, IRP4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"IRP4C1", PMC768, IRP4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"IRP5C0", PMC769, IRP5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"IRP5C1", PMC770, IRP5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"IRP6C0", PMC771, IRP6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"IRP6C1", PMC772, IRP6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"IRP7C0", PMC773, IRP7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"IRP7C1", PMC774, IRP7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"IRP8C0", PMC775, IRP8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"IRP8C1", PMC776, IRP8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"IRP9C0", PMC777, IRP9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"IRP9C1", PMC778, IRP9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"IRP10C0", PMC779, IRP10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"IRP10C1", PMC780, IRP10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"IRP11C0", PMC781, IRP11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"IRP11C1", PMC782, IRP11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"IRP12C0", PMC783, IRP12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"IRP12C1", PMC784, IRP12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"IRP13C0", PMC785, IRP13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"IRP13C1", PMC786, IRP13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"IRP14C0", PMC787, IRP14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"IRP14C1", PMC788, IRP14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"IRP15C0", PMC789, IRP15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"IRP15C1", PMC790, IRP15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"HBM0C0", PMC791, HBM0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"HBM0C1", PMC792, HBM0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"HBM0C2", PMC793, HBM0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"HBM0C3", PMC794, HBM0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"HBM0FIX", PMC795, HBM0FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_0, EVENT_OPTION_NONE_MASK},
    {"HBM1C0", PMC796, HBM1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"HBM1C1", PMC797, HBM1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"HBM1C2", PMC798, HBM1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"HBM1C3", PMC799, HBM1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"HBM1FIX", PMC800, HBM1FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_1, EVENT_OPTION_NONE_MASK},
    {"HBM2C0", PMC801, HBM2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"HBM2C1", PMC802, HBM2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"HBM2C2", PMC803, HBM2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"HBM2C3", PMC804, HBM2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"HBM2FIX", PMC805, HBM2FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_2, EVENT_OPTION_NONE_MASK},
    {"HBM3C0", PMC806, HBM3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"HBM3C1", PMC807, HBM3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"HBM3C2", PMC808, HBM3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"HBM3C3", PMC809, HBM3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"HBM3FIX", PMC810, HBM3FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_3, EVENT_OPTION_NONE_MASK},
    {"HBM4C0", PMC811, HBM4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"HBM4C1", PMC812, HBM4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"HBM4C2", PMC813, HBM4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"HBM4C3", PMC814, HBM4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"HBM4FIX", PMC815, HBM4FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_4, EVENT_OPTION_NONE_MASK},
    {"HBM5C0", PMC816, HBM5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"HBM5C1", PMC817, HBM5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"HBM5C2", PMC818, HBM5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"HBM5C3", PMC819, HBM5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"HBM5FIX", PMC820, HBM5FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_5, EVENT_OPTION_NONE_MASK},
    {"HBM6C0", PMC821, HBM6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"HBM6C1", PMC822, HBM6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"HBM6C2", PMC823, HBM6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"HBM6C3", PMC824, HBM6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"HBM6FIX", PMC825, HBM6FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_6, EVENT_OPTION_NONE_MASK},
    {"HBM7C0", PMC826, HBM7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"HBM7C1", PMC827, HBM7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"HBM7C2", PMC828, HBM7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"HBM7C3", PMC829, HBM7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"HBM7FIX", PMC830, HBM7FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_7, EVENT_OPTION_NONE_MASK},
    {"HBM8C0", PMC831, HBM8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"HBM8C1", PMC832, HBM8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"HBM8C2", PMC833, HBM8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"HBM8C3", PMC834, HBM8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"HBM8FIX", PMC835, HBM8FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_8, EVENT_OPTION_NONE_MASK},
    {"HBM9C0", PMC836, HBM9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"HBM9C1", PMC837, HBM9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"HBM9C2", PMC838, HBM9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"HBM9C3", PMC839, HBM9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"HBM9FIX", PMC840, HBM9FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_9, EVENT_OPTION_NONE_MASK},
    {"HBM10C0", PMC841, HBM10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"HBM10C1", PMC842, HBM10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"HBM10C2", PMC843, HBM10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"HBM10C3", PMC844, HBM10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"HBM10FIX", PMC845, HBM10FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_10, EVENT_OPTION_NONE_MASK},
    {"HBM11C0", PMC846, HBM11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"HBM11C1", PMC847, HBM11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"HBM11C2", PMC848, HBM11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"HBM11C3", PMC849, HBM11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"HBM11FIX", PMC850, HBM11FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_11, EVENT_OPTION_NONE_MASK},
    {"HBM12C0", PMC851, HBM12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"HBM12C1", PMC852, HBM12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"HBM12C2", PMC853, HBM12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"HBM12C3", PMC854, HBM12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"HBM12FIX", PMC855, HBM12FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_12, EVENT_OPTION_NONE_MASK},
    {"HBM13C0", PMC856, HBM13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"HBM13C1", PMC857, HBM13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"HBM13C2", PMC858, HBM13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"HBM13C3", PMC859, HBM13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"HBM13FIX", PMC860, HBM13FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_13, EVENT_OPTION_NONE_MASK},
    {"HBM14C0", PMC861, HBM14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"HBM14C1", PMC862, HBM14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"HBM14C2", PMC863, HBM14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"HBM14C3", PMC864, HBM14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"HBM14FIX", PMC865, HBM14FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_14, EVENT_OPTION_NONE_MASK},
    {"HBM15C0", PMC866, HBM15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"HBM15C1", PMC867, HBM15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"HBM15C2", PMC868, HBM15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"HBM15C3", PMC869, HBM15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"HBM15FIX", PMC870, HBM15FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_15, EVENT_OPTION_NONE_MASK},
    {"HBM16C0", PMC871, HBM16, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"HBM16C1", PMC872, HBM16, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"HBM16C2", PMC873, HBM16, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"HBM16C3", PMC874, HBM16, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"HBM16FIX", PMC875, HBM16FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_16, EVENT_OPTION_NONE_MASK},
    {"HBM17C0", PMC876, HBM17, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"HBM17C1", PMC877, HBM17, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"HBM17C2", PMC878, HBM17, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"HBM17C3", PMC879, HBM17, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"HBM17FIX", PMC880, HBM17FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_17, EVENT_OPTION_NONE_MASK},
    {"HBM18C0", PMC881, HBM18, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"HBM18C1", PMC882, HBM18, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"HBM18C2", PMC883, HBM18, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"HBM18C3", PMC884, HBM18, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"HBM18FIX", PMC885, HBM18FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_18, EVENT_OPTION_NONE_MASK},
    {"HBM19C0", PMC886, HBM19, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"HBM19C1", PMC887, HBM19, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"HBM19C2", PMC888, HBM19, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"HBM19C3", PMC889, HBM19, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"HBM19FIX", PMC890, HBM19FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_19, EVENT_OPTION_NONE_MASK},
    {"HBM20C0", PMC891, HBM20, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"HBM20C1", PMC892, HBM20, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"HBM20C2", PMC893, HBM20, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"HBM20C3", PMC894, HBM20, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"HBM20FIX", PMC895, HBM20FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_20, EVENT_OPTION_NONE_MASK},
    {"HBM21C0", PMC896, HBM21, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"HBM21C1", PMC897, HBM21, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"HBM21C2", PMC898, HBM21, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"HBM21C3", PMC899, HBM21, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"HBM21FIX", PMC900, HBM21FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_21, EVENT_OPTION_NONE_MASK},
    {"HBM22C0", PMC901, HBM22, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"HBM22C1", PMC902, HBM22, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"HBM22C2", PMC903, HBM22, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"HBM22C3", PMC904, HBM22, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"HBM22FIX", PMC905, HBM22FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_22, EVENT_OPTION_NONE_MASK},
    {"HBM23C0", PMC906, HBM23, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"HBM23C1", PMC907, HBM23, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"HBM23C2", PMC908, HBM23, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"HBM23C3", PMC909, HBM23, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"HBM23FIX", PMC910, HBM23FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_23, EVENT_OPTION_NONE_MASK},
    {"HBM24C0", PMC911, HBM24, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"HBM24C1", PMC912, HBM24, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"HBM24C2", PMC913, HBM24, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"HBM24C3", PMC914, HBM24, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"HBM24FIX", PMC915, HBM24FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_24, EVENT_OPTION_NONE_MASK},
    {"HBM25C0", PMC916, HBM25, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"HBM25C1", PMC917, HBM25, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"HBM25C2", PMC918, HBM25, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"HBM25C3", PMC919, HBM25, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"HBM25FIX", PMC920, HBM25FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_25, EVENT_OPTION_NONE_MASK},
    {"HBM26C0", PMC921, HBM26, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"HBM26C1", PMC922, HBM26, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"HBM26C2", PMC923, HBM26, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"HBM26C3", PMC924, HBM26, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"HBM26FIX", PMC925, HBM26FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_26, EVENT_OPTION_NONE_MASK},
    {"HBM27C0", PMC926, HBM27, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"HBM27C1", PMC927, HBM27, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"HBM27C2", PMC928, HBM27, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"HBM27C3", PMC929, HBM27, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"HBM27FIX", PMC930, HBM27FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_27, EVENT_OPTION_NONE_MASK},
    {"HBM28C0", PMC931, HBM28, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"HBM28C1", PMC932, HBM28, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"HBM28C2", PMC933, HBM28, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"HBM28C3", PMC934, HBM28, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"HBM28FIX", PMC935, HBM28FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_28, EVENT_OPTION_NONE_MASK},
    {"HBM29C0", PMC936, HBM29, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"HBM29C1", PMC937, HBM29, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"HBM29C2", PMC938, HBM29, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"HBM29C3", PMC939, HBM29, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"HBM29FIX", PMC940, HBM29FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_29, EVENT_OPTION_NONE_MASK},
    {"HBM30C0", PMC941, HBM30, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"HBM30C1", PMC942, HBM30, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"HBM30C2", PMC943, HBM30, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"HBM30C3", PMC944, HBM30, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"HBM30FIX", PMC945, HBM30FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_30, EVENT_OPTION_NONE_MASK},
    {"HBM31C0", PMC946, HBM31, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"HBM31C1", PMC947, HBM31, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"HBM31C2", PMC948, HBM31, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"HBM31C3", PMC949, HBM31, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"HBM31FIX", PMC950, HBM31FIX, FAKE_UNC_FIXED_CTRL, FAKE_UNC_FIXED_CTR, 0, MMIO_HBM_DEVICE_31, EVENT_OPTION_NONE_MASK},
    {"PBOX0C0", PMC951, PBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE0, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX0C1", PMC952, PBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE0, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX0C2", PMC953, PBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE0, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX0C3", PMC954, PBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE0, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX1C0", PMC955, PBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE1, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX1C1", PMC956, PBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE1, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX1C2", PMC957, PBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE1, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX1C3", PMC958, PBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE1, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX2C0", PMC959, PBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE2, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX2C1", PMC960, PBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE2, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX2C2", PMC961, PBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE2, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX2C3", PMC962, PBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE2, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX3C0", PMC963, PBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE3, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX3C1", PMC964, PBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE3, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX3C2", PMC965, PBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE3, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX3C3", PMC966, PBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE3, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX4C0", PMC967, PBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE4, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX4C1", PMC968, PBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE4, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX4C2", PMC969, PBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE4, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX4C3", PMC970, PBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE4, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX5C0", PMC971, PBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE5, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX5C1", PMC972, PBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE5, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX5C2", PMC973, PBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE5, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX5C3", PMC974, PBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE5, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX6C0", PMC975, PBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE6, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX6C1", PMC976, PBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE6, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX6C2", PMC977, PBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE6, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX6C3", PMC978, PBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE6, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX7C0", PMC979, PBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE7, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX7C1", PMC980, PBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE7, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX7C2", PMC981, PBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE7, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX7C3", PMC982, PBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE7, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX8C0", PMC983, PBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE8, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX8C1", PMC984, PBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE8, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX8C2", PMC985, PBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE8, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX8C3", PMC986, PBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE8, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX9C0", PMC987, PBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE9, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX9C1", PMC988, PBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE9, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX9C2", PMC989, PBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE9, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX9C3", PMC990, PBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE9, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX10C0", PMC991, PBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE10, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX10C1", PMC992, PBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE10, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX10C2", PMC993, PBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE10, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX10C3", PMC994, PBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE10, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX11C0", PMC995, PBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE11, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX11C1", PMC996, PBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE11, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX11C2", PMC997, PBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE11, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX11C3", PMC998, PBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE11, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX12C0", PMC999, PBOX12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE12, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX12C1", PMC1000, PBOX12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE12, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX12C2", PMC1001, PBOX12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE12, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX12C3", PMC1002, PBOX12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE12, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX13C0", PMC1003, PBOX13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE13, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX13C1", PMC1004, PBOX13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE13, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX13C2", PMC1005, PBOX13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE13, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX13C3", PMC1006, PBOX13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE13, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX14C0", PMC1007, PBOX14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE14, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX14C1", PMC1008, PBOX14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE14, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX14C2", PMC1009, PBOX14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE14, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX14C3", PMC1010, PBOX14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE14, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX15C0", PMC1011, PBOX15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE15, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX15C1", PMC1012, PBOX15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE15, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX15C2", PMC1013, PBOX15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE15, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX15C3", PMC1014, PBOX15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE15, SPR_VALID_OPTIONS_UNCORE},
};

static BoxMap sapphirerapids_box_map[NUM_UNITS] = {
    [FIXED] =  {MSR_PERF_GLOBAL_CTRL, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS_RESET, 0, 0, 0, 48},
    [PMC] = {MSR_PERF_GLOBAL_CTRL, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS_RESET, 0, 0, 0, 48},
    [THERMAL] = {0, 0, 0, 0, 0, 0, 8},
    [POWER] = {0, 0, 0, 0, 0, 0, 32},
    [VOLTAGE] = {0, 0, 0, 0, 0, 0, 16},
    [METRICS] = {0, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS, 48, 0, 0, 8},
    [WBOX] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_PCU_DEVICE, 48},
    [MBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_0, 48},
    [MBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_1, 48},
    [MBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_2, 48},
    [MBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_3, 48},
    [MBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_4, 48},
    [MBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_5, 48},
    [MBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_6, 48},
    [MBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_7, 48},
    [MBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_0, 48},
    [MBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_1, 48},
    [MBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_2, 48},
    [MBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_3, 48},
    [MBOX12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_4, 48},
    [MBOX13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_5, 48},
    [MBOX14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_6, 48},
    [MBOX15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_7, 48},
    [HBM0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_0, 48},
    [HBM1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_1, 48},
    [HBM2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_2, 48},
    [HBM3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_3, 48},
    [HBM4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_4, 48},
    [HBM5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_5, 48},
    [HBM6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_6, 48},
    [HBM7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_7, 48},
    [HBM8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_8, 48},
    [HBM9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_9, 48},
    [HBM10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_10, 48},
    [HBM11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_11, 48},
    [HBM12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_12, 48},
    [HBM13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_13, 48},
    [HBM14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_14, 48},
    [HBM15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_15, 48},
    [HBM16] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_16, 48},
    [HBM17] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_17, 48},
    [HBM18] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_18, 48},
    [HBM19] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_19, 48},
    [HBM20] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_20, 48},
    [HBM21] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_21, 48},
    [HBM22] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_22, 48},
    [HBM23] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_23, 48},
    [HBM24] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_24, 48},
    [HBM25] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_25, 48},
    [HBM26] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_26, 48},
    [HBM27] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_27, 48},
    [HBM28] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_28, 48},
    [HBM29] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_29, 48},
    [HBM30] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_30, 48},
    [HBM31] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_31, 48},
    [MDF0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_0, 48},
    [MDF1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_1, 48},
    [MDF2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_2, 48},
    [MDF3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_3, 48},
    [MDF4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_4, 48},
    [MDF5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_5, 48},
    [MDF6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_6, 48},
    [MDF7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_7, 48},
    [MDF8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_8, 48},
    [MDF9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_9, 48},
    [MDF10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_10, 48},
    [MDF11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_11, 48},
    [MDF12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_12, 48},
    [MDF13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_13, 48},
    [MDF14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_14, 48},
    [MDF15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_15, 48},
    [MDF16] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_16, 48},
    [MDF17] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_17, 48},
    [MDF18] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_18, 48},
    [MDF19] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_19, 48},
    [MDF20] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_20, 48},
    [MDF21] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_21, 48},
    [MDF22] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_22, 48},
    [MDF23] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_23, 48},
    [MDF24] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_24, 48},
    [MDF25] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_25, 48},
    [MDF26] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_26, 48},
    [MDF27] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_27, 48},
    [MDF28] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_28, 48},
    [MDF29] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_29, 48},
    [MDF30] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_30, 48},
    [MDF31] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_31, 48},
    [MDF32] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_32, 48},
    [MDF33] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_33, 48},
    [MDF34] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_34, 48},
    [MDF35] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_35, 48},
    [MDF36] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_36, 48},
    [MDF37] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_37, 48},
    [MDF38] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_38, 48},
    [MDF39] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_39, 48},
    [MDF40] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_40, 48},
    [MDF41] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_41, 48},
    [MDF42] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_42, 48},
    [MDF43] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_43, 48},
    [MDF44] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_44, 48},
    [MDF45] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_45, 48},
    [MDF46] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_46, 48},
    [MDF47] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_47, 48},
    [MDF48] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_48, 48},
    [MDF49] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_49, 48},
    // Memory controller free-running counters currently not supported
/*    [MDEV0] = {0, 0, 0, 0, 1, MMIO_IMC_DEVICE_0_FREERUN, 64},*/
/*    [MDEV1] = {0, 0, 0, 0, 1, MMIO_IMC_DEVICE_1_FREERUN, 64},*/
/*    [MDEV2] = {0, 0, 0, 0, 1, MMIO_IMC_DEVICE_2_FREERUN, 64},*/
/*    [MDEV3] = {0, 0, 0, 0, 1, MMIO_IMC_DEVICE_3_FREERUN, 64},*/
    [BBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_0, 48},
    [BBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_1, 48},
    [BBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_2, 48},
    [BBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_3, 48},
    [BBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_4, 48},
    [BBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_5, 48},
    [BBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_6, 48},
    [BBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_7, 48},
    [BBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_8, 48},
    [BBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_9, 48},
    [BBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_10, 48},
    [BBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_11, 48},
    [BBOX12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_12, 48},
    [BBOX13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_13, 48},
    [BBOX14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_14, 48},
    [BBOX15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_15, 48},
    [BBOX16] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_16, 48},
    [BBOX17] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_17, 48},
    [BBOX18] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_18, 48},
    [BBOX19] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_19, 48},
    [BBOX20] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_20, 48},
    [BBOX21] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_21, 48},
    [BBOX22] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_22, 48},
    [BBOX23] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_23, 48},
    [BBOX24] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_24, 48},
    [BBOX25] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_25, 48},
    [BBOX26] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_26, 48},
    [BBOX27] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_27, 48},
    [BBOX28] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_28, 48},
    [BBOX29] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_29, 48},
    [BBOX30] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_30, 48},
    [BBOX31] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_31, 48},
    [CBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C0, 48, FAKE_UNC_FILTER0},
    [CBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C1, 48, FAKE_UNC_FILTER0},
    [CBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C2, 48, FAKE_UNC_FILTER0},
    [CBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C3, 48, FAKE_UNC_FILTER0},
    [CBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C4, 48, FAKE_UNC_FILTER0},
    [CBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C5, 48, FAKE_UNC_FILTER0},
    [CBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C6, 48, FAKE_UNC_FILTER0},
    [CBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C7, 48, FAKE_UNC_FILTER0},
    [CBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C8, 48, FAKE_UNC_FILTER0},
    [CBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C9, 48, FAKE_UNC_FILTER0},
    [CBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C10, 48, FAKE_UNC_FILTER0},
    [CBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C11, 48, FAKE_UNC_FILTER0},
    [CBOX12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C12, 48, FAKE_UNC_FILTER0},
    [CBOX13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C13, 48, FAKE_UNC_FILTER0},
    [CBOX14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C14, 48, FAKE_UNC_FILTER0},
    [CBOX15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C15, 48, FAKE_UNC_FILTER0},
    [CBOX16] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C16, 48, FAKE_UNC_FILTER0},
    [CBOX17] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C17, 48, FAKE_UNC_FILTER0},
    [CBOX18] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C18, 48, FAKE_UNC_FILTER0},
    [CBOX19] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C19, 48, FAKE_UNC_FILTER0},
    [CBOX20] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C20, 48, FAKE_UNC_FILTER0},
    [CBOX21] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C21, 48, FAKE_UNC_FILTER0},
    [CBOX22] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C22, 48, FAKE_UNC_FILTER0},
    [CBOX23] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C23, 48, FAKE_UNC_FILTER0},
    [CBOX24] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C24, 48, FAKE_UNC_FILTER0},
    [CBOX25] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C25, 48, FAKE_UNC_FILTER0},
    [CBOX26] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C26, 48, FAKE_UNC_FILTER0},
    [CBOX27] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C27, 48, FAKE_UNC_FILTER0},
    [CBOX28] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C28, 48, FAKE_UNC_FILTER0},
    [CBOX29] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C29, 48, FAKE_UNC_FILTER0},
    [CBOX30] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C30, 48, FAKE_UNC_FILTER0},
    [CBOX31] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C31, 48, FAKE_UNC_FILTER0},
    [CBOX32] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C32, 48, FAKE_UNC_FILTER0},
    [CBOX33] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C33, 48, FAKE_UNC_FILTER0},
    [CBOX34] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C34, 48, FAKE_UNC_FILTER0},
    [CBOX35] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C35, 48, FAKE_UNC_FILTER0},
    [CBOX36] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C36, 48, FAKE_UNC_FILTER0},
    [CBOX37] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C37, 48, FAKE_UNC_FILTER0},
    [CBOX38] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C38, 48, FAKE_UNC_FILTER0},
    [CBOX39] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C39, 48, FAKE_UNC_FILTER0},
    [CBOX40] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C40, 48, FAKE_UNC_FILTER0},
    [CBOX41] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C41, 48, FAKE_UNC_FILTER0},
    [CBOX42] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C42, 48, FAKE_UNC_FILTER0},
    [CBOX43] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C43, 48, FAKE_UNC_FILTER0},
    [CBOX44] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C44, 48, FAKE_UNC_FILTER0},
    [CBOX45] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C45, 48, FAKE_UNC_FILTER0},
    [CBOX46] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C46, 48, FAKE_UNC_FILTER0},
    [CBOX47] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C47, 48, FAKE_UNC_FILTER0},
    [CBOX48] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C48, 48, FAKE_UNC_FILTER0},
    [CBOX49] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C49, 48, FAKE_UNC_FILTER0},
    [CBOX50] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C50, 48, FAKE_UNC_FILTER0},
    [CBOX51] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C51, 48, FAKE_UNC_FILTER0},
    [CBOX52] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C52, 48, FAKE_UNC_FILTER0},
    [CBOX53] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C53, 48, FAKE_UNC_FILTER0},
    [CBOX54] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C54, 48, FAKE_UNC_FILTER0},
    [CBOX55] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C55, 48, FAKE_UNC_FILTER0},
    [QBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_0, 48},
    [QBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_1, 48},
    [QBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_2, 48},
    [QBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_3, 48},
    [RBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_0, 48},
    [RBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_1, 48},
    [RBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_2, 48},
    [RBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_3, 48},
    [IBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_0, 48},
    [IBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_1, 48},
    [IBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_2, 48},
    [IBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_3, 48},
    [IBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_4, 48},
    [IBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_5, 48},
    [IBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_6, 48},
    [IBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_7, 48},
    [IBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_8, 48},
    [IBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_9, 48},
    [IBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_10, 48},
    [IBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_11, 48},
    [IBOX12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_12, 48},
    [IBOX13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_13, 48},
    [IBOX14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_14, 48},
    [IBOX15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_15, 48},
    [IRP0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_0, 48},
    [IRP1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_1, 48},
    [IRP2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_2, 48},
    [IRP3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_3, 48},
    [IRP4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_4, 48},
    [IRP5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_5, 48},
    [IRP6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_6, 48},
    [IRP7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_7, 48},
    [IRP8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_8, 48},
    [IRP9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_9, 48},
    [IRP10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_10, 48},
    [IRP11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_11, 48},
    [IRP12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_12, 48},
    [IRP13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_13, 48},
    [IRP14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_14, 48},
    [IRP15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_15, 48},
    [PBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE0, 48},
    [PBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE1, 48},
    [PBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE2, 48},
    [PBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE3, 48},
    [PBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE4, 48},
    [PBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE5, 48},
    [PBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE6, 48},
    [PBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE7, 48},
    [PBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE8, 48},
    [PBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE9, 48},
    [PBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE10, 48},
    [PBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE11, 48},
    [PBOX12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE12, 48},
    [PBOX13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE13, 48},
    [PBOX14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE14, 48},
    [PBOX15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE15, 48},
};

static PciDevice sapphirerapids_pci_devices[MAX_NUM_PCI_DEVICES] = {
    [MSR_DEV] = {NODEVTYPE, "", "MSR", ""},
    [MMIO_IMC_DEVICE_0_CH_0] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX0", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_1] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX1", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_2] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX2", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_3] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX3", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_4] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX4", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_5] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX5", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_6] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX6", 0x3451},
    [MMIO_IMC_DEVICE_0_CH_7] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX7", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_0] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX8", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_1] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX9", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_2] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX10", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_3] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX11", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_4] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX12", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_5] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX13", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_6] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX14", 0x3451},
    [MMIO_IMC_DEVICE_1_CH_7] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX15", 0x3451},
    [MMIO_IMC_DEVICE_0_FREERUN]= {IMC, NULL, "MMAP_IMC_FREERUN_DEVICE", "MDEV0", 0x3451},
    [MMIO_IMC_DEVICE_1_FREERUN]= {IMC, NULL, "MMAP_IMC_FREERUN_DEVICE", "MDEV1", 0x3451},
    [MMIO_IMC_DEVICE_2_FREERUN]= {IMC, NULL, "MMAP_IMC_FREERUN_DEVICE", "MDEV2", 0x3451},
    [MMIO_IMC_DEVICE_3_FREERUN]= {IMC, NULL, "MMAP_IMC_FREERUN_DEVICE", "MDEV3", 0x3451},
    [PCI_HA_DEVICE_0] = {HA, NULL, "PCI_HA_DEVICE_0", "M2M0", 0x0},
    [PCI_HA_DEVICE_1] = {HA, NULL, "PCI_HA_DEVICE_1", "M2M1", 0x0},
    [PCI_HA_DEVICE_2] = {HA, NULL, "PCI_HA_DEVICE_2", "M2M2", 0x0},
    [PCI_HA_DEVICE_3] = {HA, NULL, "PCI_HA_DEVICE_3", "M2M3", 0x0},
    [PCI_HA_DEVICE_4] = {HA, NULL, "PCI_HA_DEVICE_4", "M2M4", 0x0},
    [PCI_HA_DEVICE_5] = {HA, NULL, "PCI_HA_DEVICE_5", "M2M5", 0x0},
    [PCI_HA_DEVICE_6] = {HA, NULL, "PCI_HA_DEVICE_6", "M2M6", 0x0},
    [PCI_HA_DEVICE_7] = {HA, NULL, "PCI_HA_DEVICE_7", "M2M7", 0x0},
    [PCI_HA_DEVICE_8] = {HA, NULL, "PCI_HA_DEVICE_8", "M2M8", 0x0},
    [PCI_HA_DEVICE_9] = {HA, NULL, "PCI_HA_DEVICE_9", "M2M9", 0x0},
    [PCI_HA_DEVICE_10] = {HA, NULL, "PCI_HA_DEVICE_10", "M2M10", 0x0},
    [PCI_HA_DEVICE_11] = {HA, NULL, "PCI_HA_DEVICE_11", "M2M11", 0x0},
    [PCI_HA_DEVICE_12] = {HA, NULL, "PCI_HA_DEVICE_12", "M2M12", 0x0},
    [PCI_HA_DEVICE_13] = {HA, NULL, "PCI_HA_DEVICE_13", "M2M13", 0x0},
    [PCI_HA_DEVICE_14] = {HA, NULL, "PCI_HA_DEVICE_14", "M2M14", 0x0},
    [PCI_HA_DEVICE_15] = {HA, NULL, "PCI_HA_DEVICE_15", "M2M15", 0x0},
    [PCI_HA_DEVICE_16] = {HA, NULL, "PCI_HA_DEVICE_16", "M2M16", 0x0},
    [PCI_HA_DEVICE_17] = {HA, NULL, "PCI_HA_DEVICE_17", "M2M17", 0x0},
    [PCI_HA_DEVICE_18] = {HA, NULL, "PCI_HA_DEVICE_18", "M2M18", 0x0},
    [PCI_HA_DEVICE_19] = {HA, NULL, "PCI_HA_DEVICE_19", "M2M19", 0x0},
    [PCI_HA_DEVICE_20] = {HA, NULL, "PCI_HA_DEVICE_20", "M2M20", 0x0},
    [PCI_HA_DEVICE_21] = {HA, NULL, "PCI_HA_DEVICE_21", "M2M21", 0x0},
    [PCI_HA_DEVICE_22] = {HA, NULL, "PCI_HA_DEVICE_22", "M2M22", 0x0},
    [PCI_HA_DEVICE_23] = {HA, NULL, "PCI_HA_DEVICE_23", "M2M23", 0x0},
    [PCI_HA_DEVICE_24] = {HA, NULL, "PCI_HA_DEVICE_24", "M2M24", 0x0},
    [PCI_HA_DEVICE_25] = {HA, NULL, "PCI_HA_DEVICE_25", "M2M25", 0x0},
    [PCI_HA_DEVICE_26] = {HA, NULL, "PCI_HA_DEVICE_26", "M2M26", 0x0},
    [PCI_HA_DEVICE_27] = {HA, NULL, "PCI_HA_DEVICE_27", "M2M27", 0x0},
    [PCI_HA_DEVICE_28] = {HA, NULL, "PCI_HA_DEVICE_28", "M2M28", 0x0},
    [PCI_HA_DEVICE_29] = {HA, NULL, "PCI_HA_DEVICE_29", "M2M29", 0x0},
    [PCI_HA_DEVICE_30] = {HA, NULL, "PCI_HA_DEVICE_30", "M2M30", 0x0},
    [PCI_HA_DEVICE_31] = {HA, NULL, "PCI_HA_DEVICE_31", "M2M31", 0x0},
    [PCI_QPI_DEVICE_PORT_0] = {QPI, NULL, "PCI_QPI_DEVICE_PORT_0", "UPI0", 0x0},
    [PCI_QPI_DEVICE_PORT_1] = {QPI, NULL, "PCI_QPI_DEVICE_PORT_1", "UPI1", 0x0},
    [PCI_QPI_DEVICE_PORT_2] = {QPI, NULL, "PCI_QPI_DEVICE_PORT_2", "UPI2", 0x0},
    [PCI_QPI_DEVICE_PORT_3] = {QPI, NULL, "PCI_QPI_DEVICE_PORT_3", "UPI3", 0x0},
    [PCI_R3QPI_DEVICE_LINK_0] = {R3QPI, NULL, "PCI_R3QPI_DEVICE_LINK_0", "RBOX0", 0x0},
    [PCI_R3QPI_DEVICE_LINK_1] = {R3QPI, NULL, "PCI_R3QPI_DEVICE_LINK_1", "RBOX1", 0x0},
    [PCI_R3QPI_DEVICE_LINK_2] = {R3QPI, NULL, "PCI_R3QPI_DEVICE_LINK_2", "RBOX2", 0x0},
    [PCI_R3QPI_DEVICE_LINK_3] = {R3QPI, NULL, "PCI_R3QPI_DEVICE_LINK_3", "RBOX3", 0x0},
    [MSR_PCU_DEVICE] = {PCU, NULL, "MSR_PCU_DEVICE", "PCU", 0x0},
    [MSR_IIO_DEVICE_0] = {IIO, NULL, "MSR_IIO_DEVICE_0", "IIO0", 0x0},
    [MSR_IIO_DEVICE_1] = {IIO, NULL, "MSR_IIO_DEVICE_1", "IIO1", 0x0},
    [MSR_IIO_DEVICE_2] = {IIO, NULL, "MSR_IIO_DEVICE_2", "IIO2", 0x0},
    [MSR_IIO_DEVICE_3] = {IIO, NULL, "MSR_IIO_DEVICE_3", "IIO3", 0x0},
    [MSR_IIO_DEVICE_4] = {IIO, NULL, "MSR_IIO_DEVICE_4", "IIO4", 0x0},
    [MSR_IIO_DEVICE_5] = {IIO, NULL, "MSR_IIO_DEVICE_5", "IIO5", 0x0},
    [MSR_IIO_DEVICE_6] = {IIO, NULL, "MSR_IIO_DEVICE_6", "IIO6", 0x0},
    [MSR_IIO_DEVICE_7] = {IIO, NULL, "MSR_IIO_DEVICE_7", "IIO7", 0x0},
    [MSR_IIO_DEVICE_8] = {IIO, NULL, "MSR_IIO_DEVICE_8", "IIO8", 0x0},
    [MSR_IIO_DEVICE_9] = {IIO, NULL, "MSR_IIO_DEVICE_9", "IIO9", 0x0},
    [MSR_IIO_DEVICE_10] = {IIO, NULL, "MSR_IIO_DEVICE_10", "IIO10", 0x0},
    [MSR_IIO_DEVICE_11] = {IIO, NULL, "MSR_IIO_DEVICE_11", "IIO11", 0x0},
    [MSR_IIO_DEVICE_12] = {IIO, NULL, "MSR_IIO_DEVICE_12", "IIO12", 0x0},
    [MSR_IIO_DEVICE_13] = {IIO, NULL, "MSR_IIO_DEVICE_13", "IIO13", 0x0},
    [MSR_IIO_DEVICE_14] = {IIO, NULL, "MSR_IIO_DEVICE_14", "IIO14", 0x0},
    [MSR_IIO_DEVICE_15] = {IIO, NULL, "MSR_IIO_DEVICE_15", "IIO15", 0x0},
    [MSR_IRP_DEVICE_0] = {IRP, NULL, "MSR_IRP_DEVICE_0", "IRP0", 0x0},
    [MSR_IRP_DEVICE_1] = {IRP, NULL, "MSR_IRP_DEVICE_1", "IRP1", 0x0},
    [MSR_IRP_DEVICE_2] = {IRP, NULL, "MSR_IRP_DEVICE_2", "IRP2", 0x0},
    [MSR_IRP_DEVICE_3] = {IRP, NULL, "MSR_IRP_DEVICE_3", "IRP3", 0x0},
    [MSR_IRP_DEVICE_4] = {IRP, NULL, "MSR_IRP_DEVICE_4", "IRP4", 0x0},
    [MSR_IRP_DEVICE_5] = {IRP, NULL, "MSR_IRP_DEVICE_5", "IRP5", 0x0},
    [MSR_IRP_DEVICE_6] = {IRP, NULL, "MSR_IRP_DEVICE_6", "IRP6", 0x0},
    [MSR_IRP_DEVICE_7] = {IRP, NULL, "MSR_IRP_DEVICE_7", "IRP7", 0x0},
    [MSR_IRP_DEVICE_8] = {IRP, NULL, "MSR_IRP_DEVICE_8", "IRP8", 0x0},
    [MSR_IRP_DEVICE_9] = {IRP, NULL, "MSR_IRP_DEVICE_9", "IRP9", 0x0},
    [MSR_IRP_DEVICE_10] = {IRP, NULL, "MSR_IRP_DEVICE_10", "IRP10", 0x0},
    [MSR_IRP_DEVICE_11] = {IRP, NULL, "MSR_IRP_DEVICE_11", "IRP11", 0x0},
    [MSR_IRP_DEVICE_12] = {IRP, NULL, "MSR_IRP_DEVICE_12", "IRP12", 0x0},
    [MSR_IRP_DEVICE_13] = {IRP, NULL, "MSR_IRP_DEVICE_13", "IRP13", 0x0},
    [MSR_IRP_DEVICE_14] = {IRP, NULL, "MSR_IRP_DEVICE_14", "IRP14", 0x0},
    [MSR_IRP_DEVICE_15] = {IRP, NULL, "MSR_IRP_DEVICE_15", "IRP15", 0x0},
    [PCI_R2PCIE_DEVICE0] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE0", "PBOX0", 0x0},
    [PCI_R2PCIE_DEVICE1] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE1", "PBOX1", 0x0},
    [PCI_R2PCIE_DEVICE2] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE2", "PBOX2", 0x0},
    [PCI_R2PCIE_DEVICE3] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE3", "PBOX3", 0x0},
    [PCI_R2PCIE_DEVICE4] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE4", "PBOX4", 0x0},
    [PCI_R2PCIE_DEVICE5] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE5", "PBOX5", 0x0},
    [PCI_R2PCIE_DEVICE6] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE6", "PBOX6", 0x0},
    [PCI_R2PCIE_DEVICE7] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE7", "PBOX7", 0x0},
    [PCI_R2PCIE_DEVICE8] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE8", "PBOX8", 0x0},
    [PCI_R2PCIE_DEVICE9] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE9", "PBOX9", 0x0},
    [PCI_R2PCIE_DEVICE10] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE10", "PBOX10", 0x0},
    [PCI_R2PCIE_DEVICE11] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE11", "PBOX11", 0x0},
    [PCI_R2PCIE_DEVICE12] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE12", "PBOX12", 0x0},
    [PCI_R2PCIE_DEVICE13] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE13", "PBOX13", 0x0},
    [PCI_R2PCIE_DEVICE14] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE14", "PBOX14", 0x0},
    [PCI_R2PCIE_DEVICE15] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE15", "PBOX15", 0x0},
};

static char* sapphirerapids_translate_types[NUM_UNITS] = {
    [FIXED] = "/sys/bus/event_source/devices/cpu",
    [PMC] = "/sys/bus/event_source/devices/cpu",
    // I don't get it to work, so no TMA metrics with perf_event at the moment
    //[METRICS] = "/sys/bus/event_source/devices/cpu",
    [POWER] = "/sys/bus/event_source/devices/power",
    [WBOX] = "/sys/bus/event_source/devices/uncore_pcu",
    [QBOX0] = "/sys/bus/event_source/devices/uncore_upi_0",
    [QBOX1] = "/sys/bus/event_source/devices/uncore_upi_1",
    [QBOX2] = "/sys/bus/event_source/devices/uncore_upi_2",
    [RBOX0] = "/sys/bus/event_source/devices/uncore_m3upi_0",
    [RBOX1] = "/sys/bus/event_source/devices/uncore_m3upi_1",
    [RBOX2] = "/sys/bus/event_source/devices/uncore_m3upi_2",
    [RBOX3] = "/sys/bus/event_source/devices/uncore_m3upi_2",
    [MBOX0] = "/sys/bus/event_source/devices/uncore_imc_0",
    [MBOX1] = "/sys/bus/event_source/devices/uncore_imc_1",
    [MBOX2] = "/sys/bus/event_source/devices/uncore_imc_2",
    [MBOX3] = "/sys/bus/event_source/devices/uncore_imc_3",
    [MBOX4] = "/sys/bus/event_source/devices/uncore_imc_4",
    [MBOX5] = "/sys/bus/event_source/devices/uncore_imc_5",
    [MBOX6] = "/sys/bus/event_source/devices/uncore_imc_6",
    [MBOX7] = "/sys/bus/event_source/devices/uncore_imc_7",
    [MBOX8] = "/sys/bus/event_source/devices/uncore_imc_8",
    [MBOX9] = "/sys/bus/event_source/devices/uncore_imc_9",
    [MBOX10] = "/sys/bus/event_source/devices/uncore_imc_10",
    [MBOX11] = "/sys/bus/event_source/devices/uncore_imc_11",
    [MBOX12] = "/sys/bus/event_source/devices/uncore_imc_12",
    [MBOX13] = "/sys/bus/event_source/devices/uncore_imc_13",
    [MBOX14] = "/sys/bus/event_source/devices/uncore_imc_14",
    [MBOX15] = "/sys/bus/event_source/devices/uncore_imc_15",
    [HBM0] = "/sys/bus/event_source/devices/uncore_hbm_0",
    [HBM0FIX] = "/sys/bus/event_source/devices/uncore_hbm_0",
    [HBM1] = "/sys/bus/event_source/devices/uncore_hbm_1",
    [HBM1FIX] = "/sys/bus/event_source/devices/uncore_hbm_1",
    [HBM2] = "/sys/bus/event_source/devices/uncore_hbm_2",
    [HBM2FIX] = "/sys/bus/event_source/devices/uncore_hbm_2",
    [HBM3] = "/sys/bus/event_source/devices/uncore_hbm_3",
    [HBM3FIX] = "/sys/bus/event_source/devices/uncore_hbm_3",
    [HBM4] = "/sys/bus/event_source/devices/uncore_hbm_4",
    [HBM4FIX] = "/sys/bus/event_source/devices/uncore_hbm_4",
    [HBM5] = "/sys/bus/event_source/devices/uncore_hbm_5",
    [HBM5FIX] = "/sys/bus/event_source/devices/uncore_hbm_5",
    [HBM6] = "/sys/bus/event_source/devices/uncore_hbm_6",
    [HBM6FIX] = "/sys/bus/event_source/devices/uncore_hbm_6",
    [HBM7] = "/sys/bus/event_source/devices/uncore_hbm_7",
    [HBM7FIX] = "/sys/bus/event_source/devices/uncore_hbm_7",
    [HBM8] = "/sys/bus/event_source/devices/uncore_hbm_8",
    [HBM8FIX] = "/sys/bus/event_source/devices/uncore_hbm_8",
    [HBM9] = "/sys/bus/event_source/devices/uncore_hbm_9",
    [HBM9FIX] = "/sys/bus/event_source/devices/uncore_hbm_9",
    [HBM10] = "/sys/bus/event_source/devices/uncore_hbm_10",
    [HBM10FIX] = "/sys/bus/event_source/devices/uncore_hbm_10",
    [HBM11] = "/sys/bus/event_source/devices/uncore_hbm_11",
    [HBM11FIX] = "/sys/bus/event_source/devices/uncore_hbm_11",
    [HBM12] = "/sys/bus/event_source/devices/uncore_hbm_12",
    [HBM12FIX] = "/sys/bus/event_source/devices/uncore_hbm_12",
    [HBM13] = "/sys/bus/event_source/devices/uncore_hbm_13",
    [HBM13FIX] = "/sys/bus/event_source/devices/uncore_hbm_13",
    [HBM14] = "/sys/bus/event_source/devices/uncore_hbm_14",
    [HBM14FIX] = "/sys/bus/event_source/devices/uncore_hbm_14",
    [HBM15] = "/sys/bus/event_source/devices/uncore_hbm_15",
    [HBM15FIX] = "/sys/bus/event_source/devices/uncore_hbm_15",
    [HBM16] = "/sys/bus/event_source/devices/uncore_hbm_16",
    [HBM16FIX] = "/sys/bus/event_source/devices/uncore_hbm_16",
    [HBM17] = "/sys/bus/event_source/devices/uncore_hbm_17",
    [HBM17FIX] = "/sys/bus/event_source/devices/uncore_hbm_17",
    [HBM18] = "/sys/bus/event_source/devices/uncore_hbm_18",
    [HBM18FIX] = "/sys/bus/event_source/devices/uncore_hbm_18",
    [HBM19] = "/sys/bus/event_source/devices/uncore_hbm_19",
    [HBM19FIX] = "/sys/bus/event_source/devices/uncore_hbm_19",
    [HBM20] = "/sys/bus/event_source/devices/uncore_hbm_20",
    [HBM20FIX] = "/sys/bus/event_source/devices/uncore_hbm_20",
    [HBM21] = "/sys/bus/event_source/devices/uncore_hbm_21",
    [HBM21FIX] = "/sys/bus/event_source/devices/uncore_hbm_21",
    [HBM22] = "/sys/bus/event_source/devices/uncore_hbm_22",
    [HBM22FIX] = "/sys/bus/event_source/devices/uncore_hbm_22",
    [HBM23] = "/sys/bus/event_source/devices/uncore_hbm_23",
    [HBM23FIX] = "/sys/bus/event_source/devices/uncore_hbm_23",
    [HBM24] = "/sys/bus/event_source/devices/uncore_hbm_24",
    [HBM24FIX] = "/sys/bus/event_source/devices/uncore_hbm_24",
    [HBM25] = "/sys/bus/event_source/devices/uncore_hbm_25",
    [HBM25FIX] = "/sys/bus/event_source/devices/uncore_hbm_25",
    [HBM26] = "/sys/bus/event_source/devices/uncore_hbm_26",
    [HBM26FIX] = "/sys/bus/event_source/devices/uncore_hbm_26",
    [HBM27] = "/sys/bus/event_source/devices/uncore_hbm_27",
    [HBM27FIX] = "/sys/bus/event_source/devices/uncore_hbm_27",
    [HBM28] = "/sys/bus/event_source/devices/uncore_hbm_28",
    [HBM28FIX] = "/sys/bus/event_source/devices/uncore_hbm_28",
    [HBM29] = "/sys/bus/event_source/devices/uncore_hbm_29",
    [HBM29FIX] = "/sys/bus/event_source/devices/uncore_hbm_29",
    [HBM30] = "/sys/bus/event_source/devices/uncore_hbm_30",
    [HBM30FIX] = "/sys/bus/event_source/devices/uncore_hbm_30",
    [HBM31] = "/sys/bus/event_source/devices/uncore_hbm_31",
    [HBM31FIX] = "/sys/bus/event_source/devices/uncore_hbm_31",
    [MDEV0] = "/sys/bus/event_source/devices/uncore_imc_free_running_0",
    [MDEV1] = "/sys/bus/event_source/devices/uncore_imc_free_running_1",
    [MDEV2] = "/sys/bus/event_source/devices/uncore_imc_free_running_2",
    [MDEV3] = "/sys/bus/event_source/devices/uncore_imc_free_running_3",
    [CBOX0] = "/sys/bus/event_source/devices/uncore_cha_0",
    [CBOX1] = "/sys/bus/event_source/devices/uncore_cha_1",
    [CBOX2] = "/sys/bus/event_source/devices/uncore_cha_2",
    [CBOX3] = "/sys/bus/event_source/devices/uncore_cha_3",
    [CBOX4] = "/sys/bus/event_source/devices/uncore_cha_4",
    [CBOX5] = "/sys/bus/event_source/devices/uncore_cha_5",
    [CBOX6] = "/sys/bus/event_source/devices/uncore_cha_6",
    [CBOX7] = "/sys/bus/event_source/devices/uncore_cha_7",
    [CBOX8] = "/sys/bus/event_source/devices/uncore_cha_8",
    [CBOX9] = "/sys/bus/event_source/devices/uncore_cha_9",
    [CBOX10] = "/sys/bus/event_source/devices/uncore_cha_10",
    [CBOX11] = "/sys/bus/event_source/devices/uncore_cha_11",
    [CBOX12] = "/sys/bus/event_source/devices/uncore_cha_12",
    [CBOX13] = "/sys/bus/event_source/devices/uncore_cha_13",
    [CBOX14] = "/sys/bus/event_source/devices/uncore_cha_14",
    [CBOX15] = "/sys/bus/event_source/devices/uncore_cha_15",
    [CBOX16] = "/sys/bus/event_source/devices/uncore_cha_16",
    [CBOX17] = "/sys/bus/event_source/devices/uncore_cha_17",
    [CBOX18] = "/sys/bus/event_source/devices/uncore_cha_18",
    [CBOX19] = "/sys/bus/event_source/devices/uncore_cha_19",
    [CBOX20] = "/sys/bus/event_source/devices/uncore_cha_20",
    [CBOX21] = "/sys/bus/event_source/devices/uncore_cha_21",
    [CBOX22] = "/sys/bus/event_source/devices/uncore_cha_22",
    [CBOX23] = "/sys/bus/event_source/devices/uncore_cha_23",
    [CBOX24] = "/sys/bus/event_source/devices/uncore_cha_24",
    [CBOX25] = "/sys/bus/event_source/devices/uncore_cha_25",
    [CBOX26] = "/sys/bus/event_source/devices/uncore_cha_26",
    [CBOX27] = "/sys/bus/event_source/devices/uncore_cha_27",
    [CBOX28] = "/sys/bus/event_source/devices/uncore_cha_28",
    [CBOX29] = "/sys/bus/event_source/devices/uncore_cha_29",
    [CBOX30] = "/sys/bus/event_source/devices/uncore_cha_30",
    [CBOX31] = "/sys/bus/event_source/devices/uncore_cha_31",
    [CBOX32] = "/sys/bus/event_source/devices/uncore_cha_32",
    [CBOX33] = "/sys/bus/event_source/devices/uncore_cha_33",
    [CBOX34] = "/sys/bus/event_source/devices/uncore_cha_34",
    [CBOX35] = "/sys/bus/event_source/devices/uncore_cha_35",
    [CBOX36] = "/sys/bus/event_source/devices/uncore_cha_36",
    [CBOX37] = "/sys/bus/event_source/devices/uncore_cha_37",
    [CBOX38] = "/sys/bus/event_source/devices/uncore_cha_38",
    [CBOX39] = "/sys/bus/event_source/devices/uncore_cha_39",
    [CBOX40] = "/sys/bus/event_source/devices/uncore_cha_40",
    [CBOX41] = "/sys/bus/event_source/devices/uncore_cha_41",
    [CBOX42] = "/sys/bus/event_source/devices/uncore_cha_42",
    [CBOX43] = "/sys/bus/event_source/devices/uncore_cha_43",
    [CBOX44] = "/sys/bus/event_source/devices/uncore_cha_44",
    [CBOX45] = "/sys/bus/event_source/devices/uncore_cha_45",
    [CBOX46] = "/sys/bus/event_source/devices/uncore_cha_46",
    [CBOX47] = "/sys/bus/event_source/devices/uncore_cha_47",
    [CBOX48] = "/sys/bus/event_source/devices/uncore_cha_48",
    [CBOX49] = "/sys/bus/event_source/devices/uncore_cha_49",
    [CBOX50] = "/sys/bus/event_source/devices/uncore_cha_50",
    [CBOX51] = "/sys/bus/event_source/devices/uncore_cha_51",
    [CBOX52] = "/sys/bus/event_source/devices/uncore_cha_52",
    [CBOX53] = "/sys/bus/event_source/devices/uncore_cha_53",
    [CBOX54] = "/sys/bus/event_source/devices/uncore_cha_54",
    [CBOX55] = "/sys/bus/event_source/devices/uncore_cha_55",
    [MDF0] = "/sys/bus/event_source/devices/uncore_mdf_0",
    [MDF1] = "/sys/bus/event_source/devices/uncore_mdf_1",
    [MDF2] = "/sys/bus/event_source/devices/uncore_mdf_2",
    [MDF3] = "/sys/bus/event_source/devices/uncore_mdf_3",
    [MDF4] = "/sys/bus/event_source/devices/uncore_mdf_4",
    [MDF5] = "/sys/bus/event_source/devices/uncore_mdf_5",
    [MDF6] = "/sys/bus/event_source/devices/uncore_mdf_6",
    [MDF7] = "/sys/bus/event_source/devices/uncore_mdf_7",
    [MDF8] = "/sys/bus/event_source/devices/uncore_mdf_8",
    [MDF9] = "/sys/bus/event_source/devices/uncore_mdf_9",
    [MDF10] = "/sys/bus/event_source/devices/uncore_mdf_10",
    [MDF11] = "/sys/bus/event_source/devices/uncore_mdf_11",
    [MDF12] = "/sys/bus/event_source/devices/uncore_mdf_12",
    [MDF13] = "/sys/bus/event_source/devices/uncore_mdf_13",
    [MDF14] = "/sys/bus/event_source/devices/uncore_mdf_14",
    [MDF15] = "/sys/bus/event_source/devices/uncore_mdf_15",
    [MDF16] = "/sys/bus/event_source/devices/uncore_mdf_16",
    [MDF17] = "/sys/bus/event_source/devices/uncore_mdf_17",
    [MDF18] = "/sys/bus/event_source/devices/uncore_mdf_18",
    [MDF19] = "/sys/bus/event_source/devices/uncore_mdf_19",
    [MDF20] = "/sys/bus/event_source/devices/uncore_mdf_20",
    [MDF21] = "/sys/bus/event_source/devices/uncore_mdf_21",
    [MDF22] = "/sys/bus/event_source/devices/uncore_mdf_22",
    [MDF23] = "/sys/bus/event_source/devices/uncore_mdf_23",
    [MDF24] = "/sys/bus/event_source/devices/uncore_mdf_24",
    [MDF25] = "/sys/bus/event_source/devices/uncore_mdf_25",
    [MDF26] = "/sys/bus/event_source/devices/uncore_mdf_26",
    [MDF27] = "/sys/bus/event_source/devices/uncore_mdf_27",
    [MDF28] = "/sys/bus/event_source/devices/uncore_mdf_28",
    [MDF29] = "/sys/bus/event_source/devices/uncore_mdf_29",
    [MDF30] = "/sys/bus/event_source/devices/uncore_mdf_30",
    [MDF31] = "/sys/bus/event_source/devices/uncore_mdf_31",
    [MDF32] = "/sys/bus/event_source/devices/uncore_mdf_32",
    [MDF33] = "/sys/bus/event_source/devices/uncore_mdf_33",
    [MDF34] = "/sys/bus/event_source/devices/uncore_mdf_34",
    [MDF35] = "/sys/bus/event_source/devices/uncore_mdf_35",
    [MDF36] = "/sys/bus/event_source/devices/uncore_mdf_36",
    [MDF37] = "/sys/bus/event_source/devices/uncore_mdf_37",
    [MDF38] = "/sys/bus/event_source/devices/uncore_mdf_38",
    [MDF39] = "/sys/bus/event_source/devices/uncore_mdf_39",
    [MDF40] = "/sys/bus/event_source/devices/uncore_mdf_40",
    [MDF41] = "/sys/bus/event_source/devices/uncore_mdf_41",
    [MDF42] = "/sys/bus/event_source/devices/uncore_mdf_42",
    [MDF43] = "/sys/bus/event_source/devices/uncore_mdf_43",
    [MDF44] = "/sys/bus/event_source/devices/uncore_mdf_44",
    [MDF45] = "/sys/bus/event_source/devices/uncore_mdf_45",
    [MDF46] = "/sys/bus/event_source/devices/uncore_mdf_46",
    [MDF47] = "/sys/bus/event_source/devices/uncore_mdf_47",
    [MDF48] = "/sys/bus/event_source/devices/uncore_mdf_48",
    [MDF49] = "/sys/bus/event_source/devices/uncore_mdf_49",
    [BBOX0] = "/sys/bus/event_source/devices/uncore_m2m_0",
    [BBOX1] = "/sys/bus/event_source/devices/uncore_m2m_1",
    [BBOX2] = "/sys/bus/event_source/devices/uncore_m2m_2",
    [BBOX3] = "/sys/bus/event_source/devices/uncore_m2m_3",
    [BBOX4] = "/sys/bus/event_source/devices/uncore_m2m_4",
    [BBOX5] = "/sys/bus/event_source/devices/uncore_m2m_5",
    [BBOX6] = "/sys/bus/event_source/devices/uncore_m2m_6",
    [BBOX7] = "/sys/bus/event_source/devices/uncore_m2m_7",
    [BBOX8] = "/sys/bus/event_source/devices/uncore_m2m_8",
    [BBOX9] = "/sys/bus/event_source/devices/uncore_m2m_9",
    [BBOX10] = "/sys/bus/event_source/devices/uncore_m2m_10",
    [BBOX11] = "/sys/bus/event_source/devices/uncore_m2m_11",
    [BBOX12] = "/sys/bus/event_source/devices/uncore_m2m_12",
    [BBOX13] = "/sys/bus/event_source/devices/uncore_m2m_13",
    [BBOX14] = "/sys/bus/event_source/devices/uncore_m2m_14",
    [BBOX15] = "/sys/bus/event_source/devices/uncore_m2m_15",
    [BBOX16] = "/sys/bus/event_source/devices/uncore_m2m_16",
    [BBOX17] = "/sys/bus/event_source/devices/uncore_m2m_17",
    [BBOX18] = "/sys/bus/event_source/devices/uncore_m2m_18",
    [BBOX19] = "/sys/bus/event_source/devices/uncore_m2m_19",
    [BBOX20] = "/sys/bus/event_source/devices/uncore_m2m_20",
    [BBOX21] = "/sys/bus/event_source/devices/uncore_m2m_21",
    [BBOX22] = "/sys/bus/event_source/devices/uncore_m2m_22",
    [BBOX23] = "/sys/bus/event_source/devices/uncore_m2m_23",
    [BBOX24] = "/sys/bus/event_source/devices/uncore_m2m_24",
    [BBOX25] = "/sys/bus/event_source/devices/uncore_m2m_25",
    [BBOX26] = "/sys/bus/event_source/devices/uncore_m2m_26",
    [BBOX27] = "/sys/bus/event_source/devices/uncore_m2m_27",
    [BBOX28] = "/sys/bus/event_source/devices/uncore_m2m_28",
    [BBOX29] = "/sys/bus/event_source/devices/uncore_m2m_29",
    [BBOX30] = "/sys/bus/event_source/devices/uncore_m2m_30",
    [BBOX31] = "/sys/bus/event_source/devices/uncore_m2m_31",
    [IBOX0] = "/sys/bus/event_source/devices/uncore_iio_0",
    [IBOX1] = "/sys/bus/event_source/devices/uncore_iio_1",
    [IBOX2] = "/sys/bus/event_source/devices/uncore_iio_2",
    [IBOX3] = "/sys/bus/event_source/devices/uncore_iio_3",
    [IBOX4] = "/sys/bus/event_source/devices/uncore_iio_4",
    [IBOX5] = "/sys/bus/event_source/devices/uncore_iio_5",
    [IBOX6] = "/sys/bus/event_source/devices/uncore_iio_6",
    [IBOX7] = "/sys/bus/event_source/devices/uncore_iio_7",
    [IBOX8] = "/sys/bus/event_source/devices/uncore_iio_8",
    [IBOX9] = "/sys/bus/event_source/devices/uncore_iio_9",
    [IBOX10] = "/sys/bus/event_source/devices/uncore_iio_10",
    [IBOX11] = "/sys/bus/event_source/devices/uncore_iio_11",
    [IBOX12] = "/sys/bus/event_source/devices/uncore_iio_12",
    [IBOX13] = "/sys/bus/event_source/devices/uncore_iio_13",
    [IBOX14] = "/sys/bus/event_source/devices/uncore_iio_14",
    [IBOX15] = "/sys/bus/event_source/devices/uncore_iio_15",
    [IRP0] = "/sys/bus/event_source/devices/uncore_irp_0",
    [IRP1] = "/sys/bus/event_source/devices/uncore_irp_1",
    [IRP2] = "/sys/bus/event_source/devices/uncore_irp_2",
    [IRP3] = "/sys/bus/event_source/devices/uncore_irp_3",
    [IRP4] = "/sys/bus/event_source/devices/uncore_irp_4",
    [IRP5] = "/sys/bus/event_source/devices/uncore_irp_5",
    [IRP6] = "/sys/bus/event_source/devices/uncore_irp_6",
    [IRP7] = "/sys/bus/event_source/devices/uncore_irp_7",
    [IRP8] = "/sys/bus/event_source/devices/uncore_irp_8",
    [IRP9] = "/sys/bus/event_source/devices/uncore_irp_9",
    [IRP10] = "/sys/bus/event_source/devices/uncore_irp_10",
    [IRP11] = "/sys/bus/event_source/devices/uncore_irp_11",
    [IRP12] = "/sys/bus/event_source/devices/uncore_irp_12",
    [IRP13] = "/sys/bus/event_source/devices/uncore_irp_13",
    [IRP14] = "/sys/bus/event_source/devices/uncore_irp_14",
    [IRP15] = "/sys/bus/event_source/devices/uncore_irp_15",
    [PBOX0] = "/sys/bus/event_source/devices/uncore_m2pcie_0",
    [PBOX1] = "/sys/bus/event_source/devices/uncore_m2pcie_1",
    [PBOX2] = "/sys/bus/event_source/devices/uncore_m2pcie_2",
    [PBOX3] = "/sys/bus/event_source/devices/uncore_m2pcie_3",
    [PBOX4] = "/sys/bus/event_source/devices/uncore_m2pcie_4",
    [PBOX5] = "/sys/bus/event_source/devices/uncore_m2pcie_5",
    [PBOX6] = "/sys/bus/event_source/devices/uncore_m2pcie_6",
    [PBOX7] = "/sys/bus/event_source/devices/uncore_m2pcie_7",
    [PBOX8] = "/sys/bus/event_source/devices/uncore_m2pcie_8",
    [PBOX9] = "/sys/bus/event_source/devices/uncore_m2pcie_9",
    [PBOX10] = "/sys/bus/event_source/devices/uncore_m2pcie_10",
    [PBOX11] = "/sys/bus/event_source/devices/uncore_m2pcie_11",
    [PBOX12] = "/sys/bus/event_source/devices/uncore_m2pcie_12",
    [PBOX13] = "/sys/bus/event_source/devices/uncore_m2pcie_13",
    [PBOX14] = "/sys/bus/event_source/devices/uncore_m2pcie_14",
    [PBOX15] = "/sys/bus/event_source/devices/uncore_m2pcie_15",
    [IBOX0FIX] = "/sys/bus/event_source/devices/uncore_iio_free_running_0",
};

static char* registerTypeNamesSapphireRapids[MAX_UNITS] = {
    [BBOX0] = "Mesh to memory controller Interface 0",
    [BBOX1] = "Mesh to memory controller Interface 1",
    [BBOX2] = "Mesh to memory controller Interface 2",
    [BBOX3] = "Mesh to memory controller Interface 3",
    [BBOX4] = "Mesh to memory controller Interface 4",
    [BBOX5] = "Mesh to memory controller Interface 5",
    [BBOX6] = "Mesh to memory controller Interface 6",
    [BBOX7] = "Mesh to memory controller Interface 7",
    [BBOX8] = "Mesh to memory controller Interface 8",
    [BBOX9] = "Mesh to memory controller Interface 9",
    [BBOX10] = "Mesh to memory controller Interface 10",
    [BBOX11] = "Mesh to memory controller Interface 11",
    [BBOX12] = "Mesh to memory controller Interface 12",
    [BBOX13] = "Mesh to memory controller Interface 13",
    [BBOX14] = "Mesh to memory controller Interface 14",
    [BBOX15] = "Mesh to memory controller Interface 15",
    [BBOX16] = "Mesh to memory controller Interface 16",
    [BBOX17] = "Mesh to memory controller Interface 17",
    [BBOX18] = "Mesh to memory controller Interface 18",
    [BBOX19] = "Mesh to memory controller Interface 19",
    [BBOX20] = "Mesh to memory controller Interface 20",
    [BBOX21] = "Mesh to memory controller Interface 21",
    [BBOX22] = "Mesh to memory controller Interface 22",
    [BBOX23] = "Mesh to memory controller Interface 23",
    [BBOX24] = "Mesh to memory controller Interface 24",
    [BBOX25] = "Mesh to memory controller Interface 25",
    [BBOX26] = "Mesh to memory controller Interface 26",
    [BBOX27] = "Mesh to memory controller Interface 27",
    [BBOX28] = "Mesh to memory controller Interface 28",
    [BBOX29] = "Mesh to memory controller Interface 29",
    [BBOX30] = "Mesh to memory controller Interface 30",
    [BBOX31] = "Mesh to memory controller Interface 31",
    [RBOX0] = "Mesh to UPI Interface 0",
    [RBOX1] = "Mesh to UPI Interface 1",
    [RBOX2] = "Mesh to UPI Interface 2",
    [RBOX3] = "Mesh to UPI Interface 3",
    [QBOX0] = "UPI link layer Interface 0",
    [QBOX1] = "UPI link layer Interface 1",
    [QBOX2] = "UPI link layer Interface 2",
    [QBOX3] = "UPI link layer Interface 3",
    [MBOX0] = "Memory Controller 0 Channel 0",
    [MBOX1] = "Memory Controller 0 Channel 1",
    [MBOX2] = "Memory Controller 1 Channel 0",
    [MBOX3] = "Memory Controller 1 Channel 1",
    [MBOX4] = "Memory Controller 2 Channel 0",
    [MBOX5] = "Memory Controller 2 Channel 1",
    [MBOX6] = "Memory Controller 3 Channel 0",
    [MBOX7] = "Memory Controller 3 Channel 1",
    [MBOX0FIX] = "Memory Controller 0 Channel 0 Fixed Counter",
    [MBOX1FIX] = "Memory Controller 0 Channel 1 Fixed Counter",
    [MBOX2FIX] = "Memory Controller 1 Channel 0 Fixed Counter",
    [MBOX3FIX] = "Memory Controller 1 Channel 1 Fixed Counter",
    [MBOX4FIX] = "Memory Controller 2 Channel 0 Fixed Counter",
    [MBOX5FIX] = "Memory Controller 2 Channel 1 Fixed Counter",
    [MBOX6FIX] = "Memory Controller 3 Channel 0 Fixed Counter",
    [MBOX7FIX] = "Memory Controller 3 Channel 1 Fixed Counter",
    [MDEV0] = "Memory Controller 0",
    [MDEV1] = "Memory Controller 1",
    [MDEV2] = "Memory Controller 2",
    [MDEV3] = "Memory Controller 3",
    [IBOX0FIX] = "IIO Bandwidth In Interface 0 Free-Running Counter",
    [IBOX1FIX] = "IIO Bandwidth In Interface 1 Free-Running Counter",
    [IBOX2FIX] = "IIO Bandwidth In Interface 2 Free-Running Counter",
    [IBOX3FIX] = "IIO Bandwidth In Interface 3 Free-Running Counter",
    [IBOX4FIX] = "IIO Bandwidth In Interface 4 Free-Running Counter",
    [IBOX5FIX] = "IIO Bandwidth In Interface 5 Free-Running Counter",
    [HBM0] = "High bandwidth memory controller Interface 0",
    [HBM1] = "High bandwidth memory controller Interface 1",
    [HBM2] = "High bandwidth memory controller Interface 2",
    [HBM3] = "High bandwidth memory controller Interface 3",
    [HBM4] = "High bandwidth memory controller Interface 4",
    [HBM5] = "High bandwidth memory controller Interface 5",
    [HBM6] = "High bandwidth memory controller Interface 6",
    [HBM7] = "High bandwidth memory controller Interface 7",
    [HBM8] = "High bandwidth memory controller Interface 8",
    [HBM9] = "High bandwidth memory controller Interface 9",
    [HBM10] = "High bandwidth memory controller Interface 10",
    [HBM11] = "High bandwidth memory controller Interface 11",
    [HBM12] = "High bandwidth memory controller Interface 12",
    [HBM13] = "High bandwidth memory controller Interface 13",
    [HBM14] = "High bandwidth memory controller Interface 14",
    [HBM15] = "High bandwidth memory controller Interface 15",
    [HBM16] = "High bandwidth memory controller Interface 16",
    [HBM17] = "High bandwidth memory controller Interface 17",
    [HBM18] = "High bandwidth memory controller Interface 18",
    [HBM19] = "High bandwidth memory controller Interface 19",
    [HBM20] = "High bandwidth memory controller Interface 20",
    [HBM21] = "High bandwidth memory controller Interface 21",
    [HBM22] = "High bandwidth memory controller Interface 22",
    [HBM23] = "High bandwidth memory controller Interface 23",
    [HBM24] = "High bandwidth memory controller Interface 24",
    [HBM25] = "High bandwidth memory controller Interface 25",
    [HBM26] = "High bandwidth memory controller Interface 26",
    [HBM27] = "High bandwidth memory controller Interface 27",
    [HBM28] = "High bandwidth memory controller Interface 28",
    [HBM29] = "High bandwidth memory controller Interface 29",
    [HBM30] = "High bandwidth memory controller Interface 30",
    [HBM31] = "High bandwidth memory controller Interface 31",
    [HBM0FIX] = "High bandwidth memory controller Interface 0 fixed counters",
    [HBM1FIX] = "High bandwidth memory controller Interface 1 fixed counters",
    [HBM2FIX] = "High bandwidth memory controller Interface 2 fixed counters",
    [HBM3FIX] = "High bandwidth memory controller Interface 3 fixed counters",
    [HBM4FIX] = "High bandwidth memory controller Interface 4 fixed counters",
    [HBM5FIX] = "High bandwidth memory controller Interface 5 fixed counters",
    [HBM6FIX] = "High bandwidth memory controller Interface 6 fixed counters",
    [HBM7FIX] = "High bandwidth memory controller Interface 7 fixed counters",
    [HBM8FIX] = "High bandwidth memory controller Interface 8 fixed counters",
    [HBM9FIX] = "High bandwidth memory controller Interface 9 fixed counters",
    [HBM10FIX] = "High bandwidth memory controller Interface 10 fixed counters",
    [HBM11FIX] = "High bandwidth memory controller Interface 11 fixed counters",
    [HBM12FIX] = "High bandwidth memory controller Interface 12 fixed counters",
    [HBM13FIX] = "High bandwidth memory controller Interface 13 fixed counters",
    [HBM14FIX] = "High bandwidth memory controller Interface 14 fixed counters",
    [HBM15FIX] = "High bandwidth memory controller Interface 15 fixed counters",
    [HBM16FIX] = "High bandwidth memory controller Interface 16 fixed counters",
    [HBM17FIX] = "High bandwidth memory controller Interface 17 fixed counters",
    [HBM18FIX] = "High bandwidth memory controller Interface 18 fixed counters",
    [HBM19FIX] = "High bandwidth memory controller Interface 19 fixed counters",
    [HBM20FIX] = "High bandwidth memory controller Interface 20 fixed counters",
    [HBM21FIX] = "High bandwidth memory controller Interface 21 fixed counters",
    [HBM22FIX] = "High bandwidth memory controller Interface 22 fixed counters",
    [HBM23FIX] = "High bandwidth memory controller Interface 23 fixed counters",
    [HBM24FIX] = "High bandwidth memory controller Interface 24 fixed counters",
    [HBM25FIX] = "High bandwidth memory controller Interface 25 fixed counters",
    [HBM26FIX] = "High bandwidth memory controller Interface 26 fixed counters",
    [HBM27FIX] = "High bandwidth memory controller Interface 27 fixed counters",
    [HBM28FIX] = "High bandwidth memory controller Interface 28 fixed counters",
    [HBM29FIX] = "High bandwidth memory controller Interface 29 fixed counters",
    [HBM30FIX] = "High bandwidth memory controller Interface 30 fixed counters",
    [HBM31FIX] = "High bandwidth memory controller Interface 31 fixed counters",
    [MDF0] = "Embedded Multi-die Interconnect Bridge Interface 0",
    [MDF1] = "Embedded Multi-die Interconnect Bridge Interface 1",
    [MDF2] = "Embedded Multi-die Interconnect Bridge Interface 2",
    [MDF3] = "Embedded Multi-die Interconnect Bridge Interface 3",
    [MDF4] = "Embedded Multi-die Interconnect Bridge Interface 4",
    [MDF5] = "Embedded Multi-die Interconnect Bridge Interface 5",
    [MDF6] = "Embedded Multi-die Interconnect Bridge Interface 6",
    [MDF7] = "Embedded Multi-die Interconnect Bridge Interface 7",
    [MDF8] = "Embedded Multi-die Interconnect Bridge Interface 8",
    [MDF9] = "Embedded Multi-die Interconnect Bridge Interface 9",
    [MDF10] = "Embedded Multi-die Interconnect Bridge Interface 10",
    [MDF11] = "Embedded Multi-die Interconnect Bridge Interface 11",
    [MDF12] = "Embedded Multi-die Interconnect Bridge Interface 12",
    [MDF13] = "Embedded Multi-die Interconnect Bridge Interface 13",
    [MDF14] = "Embedded Multi-die Interconnect Bridge Interface 14",
    [MDF15] = "Embedded Multi-die Interconnect Bridge Interface 15",
    [MDF16] = "Embedded Multi-die Interconnect Bridge Interface 16",
    [MDF17] = "Embedded Multi-die Interconnect Bridge Interface 17",
    [MDF18] = "Embedded Multi-die Interconnect Bridge Interface 18",
    [MDF19] = "Embedded Multi-die Interconnect Bridge Interface 19",
    [MDF20] = "Embedded Multi-die Interconnect Bridge Interface 20",
    [MDF21] = "Embedded Multi-die Interconnect Bridge Interface 21",
    [MDF22] = "Embedded Multi-die Interconnect Bridge Interface 22",
    [MDF23] = "Embedded Multi-die Interconnect Bridge Interface 23",
    [MDF24] = "Embedded Multi-die Interconnect Bridge Interface 24",
    [MDF25] = "Embedded Multi-die Interconnect Bridge Interface 25",
    [MDF26] = "Embedded Multi-die Interconnect Bridge Interface 26",
    [MDF27] = "Embedded Multi-die Interconnect Bridge Interface 27",
    [MDF28] = "Embedded Multi-die Interconnect Bridge Interface 28",
    [MDF29] = "Embedded Multi-die Interconnect Bridge Interface 29",
    [MDF30] = "Embedded Multi-die Interconnect Bridge Interface 30",
    [MDF31] = "Embedded Multi-die Interconnect Bridge Interface 31",
    [MDF32] = "Embedded Multi-die Interconnect Bridge Interface 32",
    [MDF33] = "Embedded Multi-die Interconnect Bridge Interface 33",
    [MDF34] = "Embedded Multi-die Interconnect Bridge Interface 34",
    [MDF35] = "Embedded Multi-die Interconnect Bridge Interface 35",
    [MDF36] = "Embedded Multi-die Interconnect Bridge Interface 36",
    [MDF37] = "Embedded Multi-die Interconnect Bridge Interface 37",
    [MDF38] = "Embedded Multi-die Interconnect Bridge Interface 38",
    [MDF39] = "Embedded Multi-die Interconnect Bridge Interface 39",
    [MDF40] = "Embedded Multi-die Interconnect Bridge Interface 40",
    [MDF41] = "Embedded Multi-die Interconnect Bridge Interface 41",
    [MDF42] = "Embedded Multi-die Interconnect Bridge Interface 42",
    [MDF43] = "Embedded Multi-die Interconnect Bridge Interface 43",
    [MDF44] = "Embedded Multi-die Interconnect Bridge Interface 44",
    [MDF45] = "Embedded Multi-die Interconnect Bridge Interface 45",
    [MDF46] = "Embedded Multi-die Interconnect Bridge Interface 46",
    [MDF47] = "Embedded Multi-die Interconnect Bridge Interface 47",
    [MDF48] = "Embedded Multi-die Interconnect Bridge Interface 48",
    [MDF49] = "Embedded Multi-die Interconnect Bridge Interface 49",
    [PBOX0] = "Interface between mesh and IIO stacks",
    [PBOX1] = "Interface between mesh and IIO stacks",
    [PBOX2] = "Interface between mesh and IIO stacks",
    [PBOX3] = "Interface between mesh and IIO stacks",
    [PBOX4] = "Interface between mesh and IIO stacks",
    [PBOX5] = "Interface between mesh and IIO stacks",
    [PBOX6] = "Interface between mesh and IIO stacks",
    [PBOX7] = "Interface between mesh and IIO stacks",
    [PBOX8] = "Interface between mesh and IIO stacks",
    [PBOX9] = "Interface between mesh and IIO stacks",
    [PBOX10] = "Interface between mesh and IIO stacks",
    [PBOX11] = "Interface between mesh and IIO stacks",
    [PBOX12] = "Interface between mesh and IIO stacks",
    [PBOX13] = "Interface between mesh and IIO stacks",
    [PBOX14] = "Interface between mesh and IIO stacks",
    [PBOX15] = "Interface between mesh and IIO stacks",

};

