/* Copyright (c) 2012-2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
#ifndef DSI_HOST_V2_H
#define DSI_HOST_V2_H

#include <linux/bitops.h>

#define DSI_INTR_ERROR_MASK			BIT(25)
#define DSI_INTR_ERROR				BIT(24)
#define DSI_INTR_VIDEO_DONE_MASK		BIT(17)
#define DSI_INTR_VIDEO_DONE			BIT(16)
#define DSI_INTR_CMD_MDP_DONE_MASK		BIT(9)
#define DSI_INTR_CMD_MDP_DONE			BIT(8)
#define DSI_INTR_CMD_DMA_DONE_MASK		BIT(1)
#define DSI_INTR_CMD_DMA_DONE			BIT(0)

#define DSI_CTRL				0x0000
#define DSI_STATUS				0x0004
#define DSI_FIFO_STATUS			0x0008
#define DSI_VIDEO_MODE_CTRL			0x000C
#define DSI_VIDEO_MODE_DATA_CTRL		0x001C
#define DSI_VIDEO_MODE_ACTIVE_H			0x0020
#define DSI_VIDEO_MODE_ACTIVE_V		0x0024
#define DSI_VIDEO_MODE_TOTAL		0x0028
#define DSI_VIDEO_MODE_HSYNC			0x002C
#define DSI_VIDEO_MODE_VSYNC			0x0030
#define DSI_VIDEO_MODE_VSYNC_VPOS		0x0034
#define DSI_COMMAND_MODE_DMA_CTRL		0x0038
#define DSI_COMMAND_MODE_MDP_CTRL		0x003C
#define DSI_COMMAND_MODE_MDP_DCS_CMD_CTRL	0x0040
#define DSI_DMA_CMD_OFFSET			0x0044
#define DSI_DMA_CMD_LENGTH			0x0048
#define DSI_DMA_FIFO_CTRL			0x004C
#define DSI_COMMAND_MODE_MDP_STREAM0_CTRL	0x0054
#define DSI_COMMAND_MODE_MDP_STREAM0_TOTAL	0x0058
#define DSI_COMMAND_MODE_MDP_STREAM1_CTRL	0x005C
#define DSI_COMMAND_MODE_MDP_STREAM1_TOTAL	0x0060
#define DSI_ACK_ERR_STATUS			0x0064
#define DSI_RDBK_DATA0				0x0068
#define DSI_RDBK_DATA1				0x006C
#define DSI_RDBK_DATA2				0x0070
#define DSI_RDBK_DATA3				0x0074
#define DSI_RDBK_DATATYPE0			0x0078
#define DSI_RDBK_DATATYPE1			0x007C
#define DSI_TRIG_CTRL				0x0080
#define DSI_EXT_MUX				0x0084
#define DSI_EXT_TE_PULSE_DETECT_CTRL		0x0088
#define DSI_CMD_MODE_DMA_SW_TRIGGER		0x008C
#define DSI_CMD_MODE_MDP_SW_TRIGGER		0x0090
#define DSI_CMD_MODE_BTA_SW_TRIGGER		0x0094
#define DSI_RESET_SW_TRIGGER			0x0098
#define DSI_LANE_CTRL				0x00A8
#define DSI_LANE_SWAP_CTRL			0x00AC
#define DSI_DLN0_PHY_ERR			0x00B0
#define DSI_TIMEOUT_STATUS			0x00BC
#define DSI_CLKOUT_TIMING_CTRL			0x00C0
#define DSI_EOT_PACKET				0x00C4
#define DSI_EOT_PACKET_CTRL			0x00C8
#define DSI_ERR_INT_MASK0			0x0108
#define DSI_INT_CTRL				0x010c
#define DSI_SOFT_RESET				0x0114
#define DSI_CLK_CTRL				0x0118
#define DSI_CLK_STATUS				0x011C
#define DSI_PHY_SW_RESET			0x0128
#define DSI_COMMAND_MODE_MDP_IDLE_CTRL		0x0190
#define DSI_VERSION				0x01F0

#define DSI_DSIPHY_PLL_CTRL_0			0x0200
#define DSI_DSIPHY_PLL_CTRL_1			0x0204
#define DSI_DSIPHY_PLL_CTRL_2			0x0208
#define DSI_DSIPHY_PLL_CTRL_3			0x020C
#define DSI_DSIPHY_PLL_CTRL_4			0x0210
#define DSI_DSIPHY_PLL_CTRL_5			0x0214
#define DSI_DSIPHY_PLL_CTRL_6			0x0218
#define DSI_DSIPHY_PLL_CTRL_7			0x021C
#define DSI_DSIPHY_PLL_CTRL_8			0x0220
#define DSI_DSIPHY_PLL_CTRL_9			0x0224
#define DSI_DSIPHY_PLL_CTRL_10			0x0228
#define DSI_DSIPHY_PLL_CTRL_11			0x022C
#define DSI_DSIPHY_PLL_CTRL_12			0x0230
#define DSI_DSIPHY_PLL_CTRL_13			0x0234
#define DSI_DSIPHY_PLL_CTRL_14			0x0238
#define DSI_DSIPHY_PLL_CTRL_15			0x023C
#define DSI_DSIPHY_PLL_CTRL_16			0x0240
#define DSI_DSIPHY_PLL_CTRL_17			0x0244
#define DSI_DSIPHY_PLL_CTRL_18			0x0248
#define DSI_DSIPHY_PLL_CTRL_19			0x024C
#define DSI_DSIPHY_ANA_CTRL0			0x0260
#define DSI_DSIPHY_ANA_CTRL1			0x0264
#define DSI_DSIPHY_ANA_CTRL2			0x0268
#define DSI_DSIPHY_ANA_CTRL3			0x026C
#define DSI_DSIPHY_ANA_CTRL4			0x0270
#define DSI_DSIPHY_ANA_CTRL5			0x0274
#define DSI_DSIPHY_ANA_CTRL6			0x0278
#define DSI_DSIPHY_ANA_CTRL7			0x027C
#define DSI_DSIPHY_PLL_RDY			0x0280
#define DSI_DSIPHY_PLL_ANA_STATUS0		0x0294
#define DSI_DSIPHY_PLL_ANA_STATUS1		0x0298
#define DSI_DSIPHY_PLL_ANA_STATUS2		0x029C
#define DSI_DSIPHY_LN0_CFG0			0x0300
#define DSI_DSIPHY_LN0_CFG1			0x0304
#define DSI_DSIPHY_LN0_CFG2			0x0308
#define DSI_DSIPHY_LN1_CFG0			0x0340
#define DSI_DSIPHY_LN1_CFG1			0x0344
#define DSI_DSIPHY_LN1_CFG2			0x0348
#define DSI_DSIPHY_LN2_CFG0			0x0380
#define DSI_DSIPHY_LN2_CFG1			0x0384
#define DSI_DSIPHY_LN2_CFG2			0x0388
#define DSI_DSIPHY_LN3_CFG0			0x03C0
#define DSI_DSIPHY_LN3_CFG1			0x03C4
#define DSI_DSIPHY_LN3_CFG2			0x03C8
#define DSI_DSIPHY_LNCK_CFG0			0x0400
#define DSI_DSIPHY_LNCK_CFG1			0x0404
#define DSI_DSIPHY_LNCK_CFG2			0x0408
#define DSI_DSIPHY_TIMING_CTRL_0		0x0440
#define DSI_DSIPHY_TIMING_CTRL_1		0x0444
#define DSI_DSIPHY_TIMING_CTRL_2		0x0448
#define DSI_DSIPHY_TIMING_CTRL_3		0x044C
#define DSI_DSIPHY_TIMING_CTRL_4		0x0450
#define DSI_DSIPHY_TIMING_CTRL_5		0x0454
#define DSI_DSIPHY_TIMING_CTRL_6		0x0458
#define DSI_DSIPHY_TIMING_CTRL_7		0x045C
#define DSI_DSIPHY_TIMING_CTRL_8		0x0460
#define DSI_DSIPHY_TIMING_CTRL_9		0x0464
#define DSI_DSIPHY_TIMING_CTRL_10		0x0468
#define DSI_DSIPHY_TIMING_CTRL_11		0x046C
#define DSI_DSIPHY_CTRL_0			0x0470
#define DSI_DSIPHY_CTRL_1			0x0474
#define DSI_DSIPHY_CTRL_2			0x0478
#define DSI_DSIPHY_CTRL_3			0x047C
#define DSI_DSIPHY_STRENGTH_CTRL_0		0x0480
#define DSI_DSIPHY_STRENGTH_CTRL_1		0x0484
#define DSI_DSIPHY_STRENGTH_CTRL_2		0x0488
#define DSI_DSIPHY_LDO_CNTRL			0x04B0
#define DSI_DSIPHY_REGULATOR_CTRL_0		0x0500
#define DSI_DSIPHY_REGULATOR_CTRL_1		0x0504
#define DSI_DSIPHY_REGULATOR_CTRL_2		0x0508
#define DSI_DSIPHY_REGULATOR_CTRL_3		0x050C
#define DSI_DSIPHY_REGULATOR_CTRL_4		0x0510
#define DSI_DSIPHY_REGULATOR_TEST		0x0514
#define DSI_DSIPHY_REGULATOR_CAL_PWR_CFG	0x0518
#define DSI_DSIPHY_CAL_HW_TRIGGER		0x0528
#define DSI_DSIPHY_CAL_SW_CFG0			0x052C
#define DSI_DSIPHY_CAL_SW_CFG1			0x0530
#define DSI_DSIPHY_CAL_SW_CFG2			0x0534
#define DSI_DSIPHY_CAL_HW_CFG0			0x0538
#define DSI_DSIPHY_CAL_HW_CFG1			0x053C
#define DSI_DSIPHY_CAL_HW_CFG2			0x0540
#define DSI_DSIPHY_CAL_HW_CFG3			0x0544
#define DSI_DSIPHY_CAL_HW_CFG4			0x0548
#define DSI_DSIPHY_REGULATOR_CAL_STATUS0	0x0550
#define DSI_DSIPHY_BIST_CTRL0			0x048C
#define DSI_DSIPHY_BIST_CTRL1			0x0490
#define DSI_DSIPHY_BIST_CTRL2			0x0494
#define DSI_DSIPHY_BIST_CTRL3			0x0498
#define DSI_DSIPHY_BIST_CTRL4			0x049C
#define DSI_DSIPHY_BIST_CTRL5			0x04A0

#endif /* DSI_HOST_V2_H */
