; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+zve64d,+f,+d,+zfh,+experimental-zvfh \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare void @llvm.riscv.vssseg2.nxv16i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, i32, i32)
declare void @llvm.riscv.vssseg2.mask.nxv16i16(<vscale x 16 x i16>,<vscale x 16 x i16>, i16*, i32, <vscale x 16 x i1>, i32)

define void @test_vssseg2_nxv16i16(<vscale x 16 x i16> %val, i16* %base, i32 %offset, i32 %vl) {
; CHECK-LABEL: test_vssseg2_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, mu
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.nxv16i16(<vscale x 16 x i16> %val,<vscale x 16 x i16> %val, i16* %base, i32 %offset, i32 %vl)
  ret void
}

define void @test_vssseg2_mask_nxv16i16(<vscale x 16 x i16> %val, i16* %base, i32 %offset, <vscale x 16 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vssseg2_mask_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8m4 killed $v8m4 def $v8m4_v12m4
; CHECK-NEXT:    vmv4r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a2, e16, m4, ta, mu
; CHECK-NEXT:    vssseg2e16.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.nxv16i16(<vscale x 16 x i16> %val,<vscale x 16 x i16> %val, i16* %base, i32 %offset, <vscale x 16 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vssseg2.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, i32)
declare void @llvm.riscv.vssseg2.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, <vscale x 1 x i1>, i32)

define void @test_vssseg2_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %offset, i32 %vl) {
; CHECK-LABEL: test_vssseg2_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %offset, i32 %vl)
  ret void
}

define void @test_vssseg2_mask_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %offset, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vssseg2_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vssseg2e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg2.mask.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %offset, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vssseg3.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, i32)
declare void @llvm.riscv.vssseg3.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, <vscale x 1 x i1>, i32)

define void @test_vssseg3_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %offset, i32 %vl) {
; CHECK-LABEL: test_vssseg3_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vssseg3e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %offset, i32 %vl)
  ret void
}

define void @test_vssseg3_mask_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %offset, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vssseg3_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vssseg3e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg3.mask.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %offset, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vssseg4.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, i32)
declare void @llvm.riscv.vssseg4.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, <vscale x 1 x i1>, i32)

define void @test_vssseg4_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %offset, i32 %vl) {
; CHECK-LABEL: test_vssseg4_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vssseg4e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %offset, i32 %vl)
  ret void
}

define void @test_vssseg4_mask_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %offset, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vssseg4_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vssseg4e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg4.mask.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %offset, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vssseg5.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, i32)
declare void @llvm.riscv.vssseg5.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, <vscale x 1 x i1>, i32)

define void @test_vssseg5_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %offset, i32 %vl) {
; CHECK-LABEL: test_vssseg5_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vssseg5e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %offset, i32 %vl)
  ret void
}

define void @test_vssseg5_mask_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %offset, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vssseg5_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vssseg5e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg5.mask.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %offset, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vssseg6.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, i32)
declare void @llvm.riscv.vssseg6.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, <vscale x 1 x i1>, i32)

define void @test_vssseg6_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %offset, i32 %vl) {
; CHECK-LABEL: test_vssseg6_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vssseg6e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %offset, i32 %vl)
  ret void
}

define void @test_vssseg6_mask_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %offset, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vssseg6_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vssseg6e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg6.mask.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %offset, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vssseg7.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, i32)
declare void @llvm.riscv.vssseg7.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, <vscale x 1 x i1>, i32)

define void @test_vssseg7_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %offset, i32 %vl) {
; CHECK-LABEL: test_vssseg7_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vssseg7e8.v v8, (a0), a1
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %offset, i32 %vl)
  ret void
}

define void @test_vssseg7_mask_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %offset, <vscale x 1 x i1> %mask, i32 %vl) {
; CHECK-LABEL: test_vssseg7_mask_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $v8 killed $v8 def $v8_v9_v10_v11_v12_v13_v14
; CHECK-NEXT:    vmv1r.v v9, v8
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    vmv1r.v v11, v8
; CHECK-NEXT:    vmv1r.v v12, v8
; CHECK-NEXT:    vmv1r.v v13, v8
; CHECK-NEXT:    vmv1r.v v14, v8
; CHECK-NEXT:    vsetvli zero, a2, e8, mf8, ta, mu
; CHECK-NEXT:    vssseg7e8.v v8, (a0), a1, v0.t
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.vssseg7.mask.nxv1i8(<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val,<vscale x 1 x i8> %val, i8* %base, i32 %offset, <vscale x 1 x i1> %mask, i32 %vl)
  ret void
}

declare void @llvm.riscv.vssseg8.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, i32)
declare void @llvm.riscv.vssseg8.mask.nxv1i8(<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>,<vscale x 1 x i8>, i8*, i32, <vscale x 1 x i1>, i32)

define void @test_vssseg8_nxv1i8(<vscale x 1 x i8> %val, i8* %base, i32 %offset, i32 %vl) {
; CHECK-LABEL: test_vssseg8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $