; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+sse2 | FileCheck %s --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+avx2 | FileCheck %s --check-prefix=AVX2

define void @trunc_shl_7_v4i32_v4i64(<4 x i32> addrspace(1)* %out, <4 x i64> addrspace(1)* %in) {
; SSE2-LABEL: trunc_shl_7_v4i32_v4i64:
; SSE2:       # BB#0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = mem[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = mem[0,2,2,3]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE2-NEXT:    pslld $7, %xmm1
; SSE2-NEXT:    movdqa %xmm1, (%rdi)
; SSE2-NEXT:    retq
;
; AVX2-LABEL: trunc_shl_7_v4i32_v4i64:
; AVX2:       # BB#0:
; AVX2-NEXT:    vpshufd {{.*#+}} ymm0 = mem[0,2,2,3,4,6,6,7]
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpslld $7, %xmm0, %xmm0
; AVX2-NEXT:    vmovdqa %xmm0, (%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %val = load <4 x i64>, <4 x i64> addrspace(1)* %in
  %shl = shl <4 x i64> %val, <i64 7, i64 7, i64 7, i64 7>
  %trunc = trunc <4 x i64> %shl to <4 x i32>
  store <4 x i32> %trunc, <4 x i32> addrspace(1)* %out
  ret void
}
