# Copyright (C) 2010 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
import unittest
import sys
import testtools

try:
    import nose
except ImportError:
    print """nose is required. Install the package python-nose.
Exiting..."""
    sys.exit(1)

from mago.application import TestApplication
from mago.config import get_config

# Available Nose plugins
from mago.noseplugins.maybe import Maybe # Just a test plugin
from mago.noseplugins.magoxml import MagoXML
PLUGINS = [ Maybe(), MagoXML() ]

# Global configuration
# defaults to ~/.magorc (defined in config.py)
CONFIGFILE = None

# Global Configuration
magoConfig = get_config()

from inspect import getfile, getmodule

class TestCase(testtools.TestCase):
    """Base class for desktop testing"""
    setupOnce = False

    # Set it static because LDTP can run only one app at once.
    application = None

    # Class and Test Configuration
    # This configuration is specific to the run and different from the
    # global configuration.
    # By default the name $(basename MODULEFILEPATH).ini
    testConfig = None

    def __init__(self, methodName = 'testMethod'):
        """Construct a TestCase instance

        Loads the configuration for the application and the test
        """
        super(TestCase, self).__init__(methodName)
        #self.magoConfig = get_config()

        moduleFile = getfile(getmodule(self))
        classConfigFile = '.'.join(moduleFile.split('.')[:-1]) + ".ini"
        self.testConfig = get_config(classConfigFile)


    @classmethod
    def setUpClass(self):
        """setUpClass

        Called once for all the tests in a TestCase.
        set setupOnce to True to activate it.
        This is used if you want to launch the application to test only once
        at the beginning of the test session or want to do some extensive setup
        """
        super(TestCase, self).setUpClass()

    def setUp(self):
        """setUp

        Launch the application when setupOnce is set to False
        """
        super(TestCase, self).setUp()

        if not hasattr(TestCase, 'application'):
            TestCase.application = None

        application = TestCase.application
        # Check mandatory propertys, launcher, launcher_args and window_name

        if not application:
            TestCase.application =\
                    TestApplication(self.launcher, window_name = self.window_name)
            #TestCase.application.launch()
        else:
            if not application.isRunning:
                TestCase.application.launch()

    @classmethod
    def tearDownClass(self):
        """tearDownClass

        Called once at the end of the class to close the application and
        cleanup the environment and destroy the application.
        Only called if setupOnce is set to True.
        """
        super(TestCase, self).tearDownClass()
        if self.setupOnce and TestCase.application:
            del TestCase.application

    def tearDown(self):
        """tearDown

        Called once at the end of the test to close the application and
        cleanup the environment and destroy the application.
        Only called if setupOnce is set to False.
        """
        super(TestCase, self).tearDown()
        if not self.setupOnce and TestCase.application:
            del TestCase.application

    def getapplication(self):
        return self.application


class TestResult(testtools.TestResult):
    showAll = True
    def __init__(self, stream=sys.stderr, descriptions=True, verbosity=1):
        super(TestResult, self).__init__()
        print "TestResult::__init__"
        self.stream = stream
        self.descriptions = descriptions

    def getDescription(self, test):
        doc_first_line = test.shortDescription()
        if self.descriptions and doc_first_line:
            return '\n'.join((str(test), doc_first_line))
        else:
            return str(test)

    def startTest(self, test):
        super(TestResult, self).startTest(test)
        if self.showAll:
            self.stream.write(self.getDescription(test))
            self.stream.write(" ... ")
            self.stream.flush()

    def addSuccess(self, test):
        super(TestResult, self).addSuccess(test)
        if self.showAll:
            self.stream.write(self.getDescription(test))
            self.stream.write(" Success ")
            self.stream.flush()


class TextTestRunner(unittest.TextTestRunner):
    resultclass = TestResult

    #def __init__(self, stream=sys.stderr, descriptions=True, verbosity=1, resultclass=None):
    #    super(TextTestRunner, self).__init__(stream, descriptions, verbosity, resultclass)
    #    print "TestRunner::__init__"

#main = nose.main

def main():
    global PLUGINS

    nose.main(addplugins = PLUGINS)


if __name__ == '__main__':
    main()
