/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import org.mariadb.jdbc.BlobOutputStream;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.Utils;

public class MariaDbBlob
implements Blob,
Serializable {
    private static final long serialVersionUID = 8557003556592493381L;
    protected byte[] blobContent;
    protected int actualSize;

    public MariaDbBlob() {
        this.blobContent = new byte[0];
    }

    public MariaDbBlob(byte[] bytes) {
        if (bytes == null) {
            throw new AssertionError((Object)"byte array is null");
        }
        this.blobContent = bytes;
        this.actualSize = bytes.length;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.actualSize);
        if (this.actualSize > 0) {
            out.write(this.blobContent, 0, this.actualSize);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.actualSize = in.readInt();
        this.blobContent = new byte[this.actualSize];
        if (this.actualSize > 0) {
            in.readFully(this.blobContent, 0, this.actualSize);
        }
    }

    @Override
    public long length() throws SQLException {
        return this.actualSize;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw ExceptionMapper.getSqlException("Pos starts at 1");
        }
        int arrayPos = (int)(pos - 1L);
        return Utils.copyRange(this.blobContent, arrayPos, arrayPos + length);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.getBinaryStream(1L, this.actualSize);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (pos < 1L) {
            throw ExceptionMapper.getSqlException("Out of range (position should be > 0)");
        }
        if (pos - 1L > (long)this.actualSize) {
            throw ExceptionMapper.getSqlException("Out of range (position > stream size)");
        }
        if (pos + length - 1L > (long)this.actualSize) {
            throw ExceptionMapper.getSqlException("Out of range (position + length - 1 > streamSize)");
        }
        return new ByteArrayInputStream(this.blobContent, (int)pos - 1, (int)length);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (start < 1L) {
            throw ExceptionMapper.getSqlException("Start should be > 0, first position is 1.");
        }
        if (start > (long)this.actualSize) {
            throw ExceptionMapper.getSqlException("Start should be <= " + this.actualSize);
        }
        long actualStart = start - 1L;
        for (int i2 = (int)actualStart; i2 < this.actualSize; ++i2) {
            if (this.blobContent[i2] != pattern[0]) continue;
            boolean isEqual = true;
            for (int j2 = 1; j2 < pattern.length; ++j2) {
                if (i2 + j2 >= this.actualSize) {
                    return -1L;
                }
                if (this.blobContent[i2 + j2] == pattern[j2]) continue;
                isEqual = false;
            }
            if (!isEqual) continue;
            return i2 + 1;
        }
        return -1L;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        int bytesWritten;
        int arrayPos = (int)pos - 1;
        if (this.blobContent == null) {
            this.blobContent = new byte[arrayPos + bytes.length];
            this.actualSize = bytesWritten = this.blobContent.length;
        } else if (this.blobContent.length > arrayPos + bytes.length) {
            bytesWritten = bytes.length;
        } else {
            this.blobContent = Utils.copyWithLength(this.blobContent, arrayPos + bytes.length);
            this.actualSize = this.blobContent.length;
            bytesWritten = bytes.length;
        }
        System.arraycopy(bytes, 0, this.blobContent, arrayPos, bytes.length);
        return bytesWritten;
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        int bytesWritten = 0;
        if (this.blobContent == null) {
            this.blobContent = new byte[(int)(pos + (long)bytes.length) - (len - offset)];
            for (int i2 = (int)pos + offset; i2 < len; ++i2) {
                this.blobContent[(int)(pos + (long)i2)] = bytes[i2];
                ++bytesWritten;
            }
        } else if ((long)this.blobContent.length < pos + (long)bytes.length - (long)(len - offset)) {
            for (int i3 = (int)pos + offset; i3 < len; ++i3) {
                this.blobContent[(int)(pos + (long)i3)] = bytes[i3];
                ++bytesWritten;
            }
        }
        this.actualSize += bytesWritten;
        return bytesWritten;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (pos < 1L) {
            throw ExceptionMapper.getSqlException("Invalid position in blob");
        }
        return new BlobOutputStream(this, (int)(pos - 1L));
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.blobContent = Utils.copyWithLength(this.blobContent, (int)len);
        this.actualSize = (int)len;
    }

    @Override
    public void free() {
        this.blobContent = null;
        this.actualSize = 0;
    }
}

