/*-------------------------------------------------------------------------
 * Copyright (c) 2000-2002 Kenneth W. Sodemann (stufflehead@bigfoot.com)
 *-------------------------------------------------------------------------
 * support
 *
 * Synopsis:
 *   Support functions.  This code was originally generated by glade.
 *   I have since modified some functions and added others.
 *
 * $Id: support.c,v 1.3 2002/02/17 19:59:30 stuffle Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to
 * Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330 
 * Boston, MA  02111-1307  USA
 *
 *-------------------------------------------------------------------------
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "support.h"


/* 
 * file_exists 
 *
 * Determine if a file exists.  Added by KWS.
 */
static gboolean
file_exists (const gchar *path)
{
   struct stat s;
   gint        status;

   status = stat (path, &s);
   if (status == 0 && S_ISREG (s.st_mode))
      {
      return TRUE;
      }

   return FALSE;
}


/*
 * I don't pollute the gnome pixmap dir with misc. graphics, and crap,
 * so just look in this application's DATA dir.
 */
GdkPixmap *
load_pixmap (const gchar *filename)
{
   GdkPixmap *ret = NULL;
   GdkPixbuf *im;
   GString   *fullname = g_string_new (filename);

   /* 
    * Build the path to the file.  If the file does not exist,
    * just bail...
    */
   fullname = g_string_prepend_c (fullname, G_DIR_SEPARATOR);
   fullname = g_string_prepend (fullname, "pixmaps");
   fullname = g_string_prepend_c (fullname, G_DIR_SEPARATOR);
   fullname = g_string_prepend (fullname, PACKAGE_DATA_DIR);
   if (!file_exists (fullname->str))
      {
      g_string_free (fullname, TRUE);
      return NULL;
      }

   /*
    * Use pixbuf to load and render the file.
    */
   im = gdk_pixbuf_new_from_file (fullname->str);
   if (im != NULL)
      {
      gdk_pixbuf_render_pixmap_and_mask (im, &ret, NULL, 127);
                                         gdk_pixbuf_unref (im);
      }

   return ret;
}


/* Below here is code generated by Glade, which modifications as noted. */
/* This is an internally used function to create pixmaps. */
static GtkWidget* create_dummy_pixmap  (GtkWidget       *widget,
                                        gboolean         gnome_pixmap);

GtkWidget*
lookup_widget                          (GtkWidget       *widget,
                                        const gchar     *widget_name)
{
  GtkWidget *parent, *found_widget;

  for (;;)
    {
      if (GTK_IS_MENU (widget))
        parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
      else
        parent = widget->parent;
      if (parent == NULL)
        break;
      widget = parent;
    }

  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

/* This is a dummy pixmap we use when a pixmap can't be found. */
static char *dummy_pixmap_xpm[] = {
/* columns rows colors chars-per-pixel */
"1 1 1 1",
"  c None",
/* pixels */
" ",
" "
};

/* This is an internally used function to create pixmaps. */
static GtkWidget*
create_dummy_pixmap                    (GtkWidget       *widget,
                                        gboolean         gnome_pixmap)
{
  GdkColormap *colormap;
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  GtkWidget *pixmap;

  if (gnome_pixmap)
    {
      return gnome_pixmap_new_from_xpm_d (dummy_pixmap_xpm);
    }

  colormap = gtk_widget_get_colormap (widget);
  gdkpixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL, colormap, &mask,
                                                     NULL, dummy_pixmap_xpm);
  if (gdkpixmap == NULL)
    g_error ("Couldn't create replacement pixmap.");
  pixmap = gtk_pixmap_new (gdkpixmap, mask);
  gdk_pixmap_unref (gdkpixmap);
  gdk_bitmap_unref (mask);
  return pixmap;
}

/* This is an internally used function to create pixmaps. */
GtkWidget*
create_pixmap                          (GtkWidget       *widget,
                                        const gchar     *filename,
                                        gboolean         gnome_pixmap)
{
  GtkWidget *pixmap;
  GdkColormap *colormap;
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  gchar *pathname;

  if (!filename || !filename[0])
      return create_dummy_pixmap (widget, gnome_pixmap);

  pathname = gnome_pixmap_file (filename);
  /*
   * NOTE:  Changed by KWS...
   *
   * If gnome_pixmap_file() cannot find it, use the PACAKAGE_DATA_DIR
   * before giving up.
   */
  if (!pathname)
     {
     pathname = g_malloc (strlen (PACKAGE_DATA_DIR) + 1 +
                          strlen ("pixmaps") + 1 +
                          strlen (filename) + 1);
     sprintf (pathname, "%s%cpixmaps%c%s", PACKAGE_DATA_DIR, 
              G_DIR_SEPARATOR, G_DIR_SEPARATOR, filename);
     if (!file_exists (pathname))
        {
        g_free (pathname);
        pathname = NULL;
        }
     }
  if (!pathname)
    {
      g_warning (_("Couldn't find pixmap file: %s"), filename);
      return create_dummy_pixmap (widget, gnome_pixmap);
    }

  if (gnome_pixmap)
    {
      pixmap = gnome_pixmap_new_from_file (pathname);
      g_free (pathname);
      return pixmap;
    }

  colormap = gtk_widget_get_colormap (widget);
  gdkpixmap = gdk_pixmap_colormap_create_from_xpm (NULL, colormap, &mask,
                                                   NULL, pathname);
  if (gdkpixmap == NULL)
    {
      g_warning (_("Couldn't create pixmap from file: %s"), pathname);
      g_free (pathname);
      return create_dummy_pixmap (widget, gnome_pixmap);
    }
  g_free (pathname);

  pixmap = gtk_pixmap_new (gdkpixmap, mask);
  gdk_pixmap_unref (gdkpixmap);
  gdk_bitmap_unref (mask);
  return pixmap;
}

/* This is an internally used function to create imlib images. */
GdkImlibImage*
create_image                           (const gchar     *filename)
{
  GdkImlibImage *image;
  gchar *pathname;

  pathname = gnome_pixmap_file (filename);
  if (!pathname)
    {
      g_warning (_("Couldn't find pixmap file: %s"), filename);
      return NULL;
    }

  image = gdk_imlib_load_image (pathname);
  g_free (pathname);
  return image;
}

