/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "Service.h"
#include "MetviewService.h"
#include "ShellService.h"

typedef map<string,Service*> Map;
static Map* services = 0;

Service::Service(const string& name):
	name_(name)
{
	if(services == 0)
		services = new Map();
	(*services)[name] = this;
}

Service::~Service()
{
}
string Service::name()
{
   return name_;
}

Service* Service::find(const string &name)
{
	if(services)
	{
		Map::iterator j = services->find(name);

		if(j != services->end())
			return (*j).second;
	}

	if(name[0] == '(')
		return new ShellService(name);
	else
		return new MetviewService(name);
}

void Service::print(ostream& s) const
{
	s << name_;
}
