"use strict";

var moment = require("../../");
var tz = moment.tz;

exports.countries = {

	zone_countries : function (test) {

		test.deepEqual(tz.zone('Africa/Abidjan').countries(), ["BF","CI","GM","GN","ML","MR","SH","SL","SN","TG"]);
		test.deepEqual(tz.zone('Africa/Accra').countries(), ["GH"]);
		test.deepEqual(tz.zone('Africa/Addis_Ababa').countries(), ["ET"]);
		test.deepEqual(tz.zone('Africa/Algiers').countries(), ["DZ"]);
		test.deepEqual(tz.zone('Africa/Asmara').countries(), ["ER"]);
		test.deepEqual(tz.zone('Africa/Asmera').countries(), []);
		test.deepEqual(tz.zone('Africa/Bamako').countries(), ["ML"]);
		test.deepEqual(tz.zone('Africa/Bangui').countries(), ["CF"]);
		test.deepEqual(tz.zone('Africa/Banjul').countries(), ["GM"]);
		test.deepEqual(tz.zone('Africa/Bissau').countries(), ["GW"]);
		test.deepEqual(tz.zone('Africa/Blantyre').countries(), ["MW"]);
		test.deepEqual(tz.zone('Africa/Brazzaville').countries(), ["CG"]);
		test.deepEqual(tz.zone('Africa/Bujumbura').countries(), ["BI"]);
		test.deepEqual(tz.zone('Africa/Cairo').countries(), ["EG"]);
		test.deepEqual(tz.zone('Africa/Casablanca').countries(), ["MA"]);
		test.deepEqual(tz.zone('Africa/Ceuta').countries(), ["ES"]);
		test.deepEqual(tz.zone('Africa/Conakry').countries(), ["GN"]);
		test.deepEqual(tz.zone('Africa/Dakar').countries(), ["SN"]);
		test.deepEqual(tz.zone('Africa/Dar_es_Salaam').countries(), ["TZ"]);
		test.deepEqual(tz.zone('Africa/Djibouti').countries(), ["DJ"]);
		test.deepEqual(tz.zone('Africa/Douala').countries(), ["CM"]);
		test.deepEqual(tz.zone('Africa/El_Aaiun').countries(), ["EH"]);
		test.deepEqual(tz.zone('Africa/Freetown').countries(), ["SL"]);
		test.deepEqual(tz.zone('Africa/Gaborone').countries(), ["BW"]);
		test.deepEqual(tz.zone('Africa/Harare').countries(), ["ZW"]);
		test.deepEqual(tz.zone('Africa/Johannesburg').countries(), ["LS","SZ","ZA"]);
		test.deepEqual(tz.zone('Africa/Juba').countries(), ["SS"]);
		test.deepEqual(tz.zone('Africa/Kampala').countries(), ["UG"]);
		test.deepEqual(tz.zone('Africa/Khartoum').countries(), ["SD"]);
		test.deepEqual(tz.zone('Africa/Kigali').countries(), ["RW"]);
		test.deepEqual(tz.zone('Africa/Kinshasa').countries(), ["CD"]);
		test.deepEqual(tz.zone('Africa/Lagos').countries(), ["AO","BJ","CD","CF","CG","CM","GA","GQ","NE","NG"]);
		test.deepEqual(tz.zone('Africa/Libreville').countries(), ["GA"]);
		test.deepEqual(tz.zone('Africa/Lome').countries(), ["TG"]);
		test.deepEqual(tz.zone('Africa/Luanda').countries(), ["AO"]);
		test.deepEqual(tz.zone('Africa/Lubumbashi').countries(), ["CD"]);
		test.deepEqual(tz.zone('Africa/Lusaka').countries(), ["ZM"]);
		test.deepEqual(tz.zone('Africa/Malabo').countries(), ["GQ"]);
		test.deepEqual(tz.zone('Africa/Maputo').countries(), ["BI","BW","CD","MW","MZ","RW","ZM","ZW"]);
		test.deepEqual(tz.zone('Africa/Maseru').countries(), ["LS"]);
		test.deepEqual(tz.zone('Africa/Mbabane').countries(), ["SZ"]);
		test.deepEqual(tz.zone('Africa/Mogadishu').countries(), ["SO"]);
		test.deepEqual(tz.zone('Africa/Monrovia').countries(), ["LR"]);
		test.deepEqual(tz.zone('Africa/Nairobi').countries(), ["DJ","ER","ET","KE","KM","MG","SO","TZ","UG","YT"]);
		test.deepEqual(tz.zone('Africa/Ndjamena').countries(), ["TD"]);
		test.deepEqual(tz.zone('Africa/Niamey').countries(), ["NE"]);
		test.deepEqual(tz.zone('Africa/Nouakchott').countries(), ["MR"]);
		test.deepEqual(tz.zone('Africa/Ouagadougou').countries(), ["BF"]);
		test.deepEqual(tz.zone('Africa/Porto-Novo').countries(), ["BJ"]);
		test.deepEqual(tz.zone('Africa/Sao_Tome').countries(), ["ST"]);
		test.deepEqual(tz.zone('Africa/Timbuktu').countries(), []);
		test.deepEqual(tz.zone('Africa/Tripoli').countries(), ["LY"]);
		test.deepEqual(tz.zone('Africa/Tunis').countries(), ["TN"]);
		test.deepEqual(tz.zone('Africa/Windhoek').countries(), ["NA"]);
		test.deepEqual(tz.zone('America/Adak').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Anchorage').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Anguilla').countries(), ["AI"]);
		test.deepEqual(tz.zone('America/Antigua').countries(), ["AG"]);
		test.deepEqual(tz.zone('America/Araguaina').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Argentina/Buenos_Aires').countries(), ["AR"]);
		test.deepEqual(tz.zone('America/Argentina/Catamarca').countries(), ["AR"]);
		test.deepEqual(tz.zone('America/Argentina/ComodRivadavia').countries(), []);
		test.deepEqual(tz.zone('America/Argentina/Cordoba').countries(), ["AR"]);
		test.deepEqual(tz.zone('America/Argentina/Jujuy').countries(), ["AR"]);
		test.deepEqual(tz.zone('America/Argentina/La_Rioja').countries(), ["AR"]);
		test.deepEqual(tz.zone('America/Argentina/Mendoza').countries(), ["AR"]);
		test.deepEqual(tz.zone('America/Argentina/Rio_Gallegos').countries(), ["AR"]);
		test.deepEqual(tz.zone('America/Argentina/Salta').countries(), ["AR"]);
		test.deepEqual(tz.zone('America/Argentina/San_Juan').countries(), ["AR"]);
		test.deepEqual(tz.zone('America/Argentina/San_Luis').countries(), ["AR"]);
		test.deepEqual(tz.zone('America/Argentina/Tucuman').countries(), ["AR"]);
		test.deepEqual(tz.zone('America/Argentina/Ushuaia').countries(), ["AR"]);
		test.deepEqual(tz.zone('America/Aruba').countries(), ["AW"]);
		test.deepEqual(tz.zone('America/Asuncion').countries(), ["PY"]);
		test.deepEqual(tz.zone('America/Atikokan').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Atka').countries(), []);
		test.deepEqual(tz.zone('America/Bahia').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Bahia_Banderas').countries(), ["MX"]);
		test.deepEqual(tz.zone('America/Barbados').countries(), ["BB"]);
		test.deepEqual(tz.zone('America/Belem').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Belize').countries(), ["BZ"]);
		test.deepEqual(tz.zone('America/Blanc-Sablon').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Boa_Vista').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Bogota').countries(), ["CO"]);
		test.deepEqual(tz.zone('America/Boise').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Buenos_Aires').countries(), []);
		test.deepEqual(tz.zone('America/Cambridge_Bay').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Campo_Grande').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Cancun').countries(), ["MX"]);
		test.deepEqual(tz.zone('America/Caracas').countries(), ["VE"]);
		test.deepEqual(tz.zone('America/Catamarca').countries(), []);
		test.deepEqual(tz.zone('America/Cayenne').countries(), ["GF"]);
		test.deepEqual(tz.zone('America/Cayman').countries(), ["KY"]);
		test.deepEqual(tz.zone('America/Chicago').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Chihuahua').countries(), ["MX"]);
		test.deepEqual(tz.zone('America/Coral_Harbour').countries(), []);
		test.deepEqual(tz.zone('America/Cordoba').countries(), []);
		test.deepEqual(tz.zone('America/Costa_Rica').countries(), ["CR"]);
		test.deepEqual(tz.zone('America/Creston').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Cuiaba').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Curacao').countries(), ["AW","BQ","CW","SX"]);
		test.deepEqual(tz.zone('America/Danmarkshavn').countries(), ["GL"]);
		test.deepEqual(tz.zone('America/Dawson').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Dawson_Creek').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Denver').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Detroit').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Dominica').countries(), ["DM"]);
		test.deepEqual(tz.zone('America/Edmonton').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Eirunepe').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/El_Salvador').countries(), ["SV"]);
		test.deepEqual(tz.zone('America/Ensenada').countries(), []);
		test.deepEqual(tz.zone('America/Fort_Nelson').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Fort_Wayne').countries(), []);
		test.deepEqual(tz.zone('America/Fortaleza').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Glace_Bay').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Godthab').countries(), []);
		test.deepEqual(tz.zone('America/Goose_Bay').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Grand_Turk').countries(), ["TC"]);
		test.deepEqual(tz.zone('America/Grenada').countries(), ["GD"]);
		test.deepEqual(tz.zone('America/Guadeloupe').countries(), ["GP"]);
		test.deepEqual(tz.zone('America/Guatemala').countries(), ["GT"]);
		test.deepEqual(tz.zone('America/Guayaquil').countries(), ["EC"]);
		test.deepEqual(tz.zone('America/Guyana').countries(), ["GY"]);
		test.deepEqual(tz.zone('America/Halifax').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Havana').countries(), ["CU"]);
		test.deepEqual(tz.zone('America/Hermosillo').countries(), ["MX"]);
		test.deepEqual(tz.zone('America/Indiana/Indianapolis').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Indiana/Knox').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Indiana/Marengo').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Indiana/Petersburg').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Indiana/Tell_City').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Indiana/Vevay').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Indiana/Vincennes').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Indiana/Winamac').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Indianapolis').countries(), []);
		test.deepEqual(tz.zone('America/Inuvik').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Iqaluit').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Jamaica').countries(), ["JM"]);
		test.deepEqual(tz.zone('America/Jujuy').countries(), []);
		test.deepEqual(tz.zone('America/Juneau').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Kentucky/Louisville').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Kentucky/Monticello').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Knox_IN').countries(), []);
		test.deepEqual(tz.zone('America/Kralendijk').countries(), ["BQ"]);
		test.deepEqual(tz.zone('America/La_Paz').countries(), ["BO"]);
		test.deepEqual(tz.zone('America/Lima').countries(), ["PE"]);
		test.deepEqual(tz.zone('America/Los_Angeles').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Louisville').countries(), []);
		test.deepEqual(tz.zone('America/Lower_Princes').countries(), ["SX"]);
		test.deepEqual(tz.zone('America/Maceio').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Managua').countries(), ["NI"]);
		test.deepEqual(tz.zone('America/Manaus').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Marigot').countries(), ["MF"]);
		test.deepEqual(tz.zone('America/Martinique').countries(), ["MQ"]);
		test.deepEqual(tz.zone('America/Matamoros').countries(), ["MX"]);
		test.deepEqual(tz.zone('America/Mazatlan').countries(), ["MX"]);
		test.deepEqual(tz.zone('America/Mendoza').countries(), []);
		test.deepEqual(tz.zone('America/Menominee').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Merida').countries(), ["MX"]);
		test.deepEqual(tz.zone('America/Metlakatla').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Mexico_City').countries(), ["MX"]);
		test.deepEqual(tz.zone('America/Miquelon').countries(), ["PM"]);
		test.deepEqual(tz.zone('America/Moncton').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Monterrey').countries(), ["MX"]);
		test.deepEqual(tz.zone('America/Montevideo').countries(), ["UY"]);
		test.deepEqual(tz.zone('America/Montreal').countries(), []);
		test.deepEqual(tz.zone('America/Montserrat').countries(), ["MS"]);
		test.deepEqual(tz.zone('America/Nassau').countries(), ["BS"]);
		test.deepEqual(tz.zone('America/New_York').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Nipigon').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Nome').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Noronha').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/North_Dakota/Beulah').countries(), ["US"]);
		test.deepEqual(tz.zone('America/North_Dakota/Center').countries(), ["US"]);
		test.deepEqual(tz.zone('America/North_Dakota/New_Salem').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Ojinaga').countries(), ["MX"]);
		test.deepEqual(tz.zone('America/Panama').countries(), ["KY","PA"]);
		test.deepEqual(tz.zone('America/Pangnirtung').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Paramaribo').countries(), ["SR"]);
		test.deepEqual(tz.zone('America/Phoenix').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Port-au-Prince').countries(), ["HT"]);
		test.deepEqual(tz.zone('America/Port_of_Spain').countries(), ["AG","AI","BL","DM","GD","GP","KN","LC","MF","MS","TT","VC","VG","VI"]);
		test.deepEqual(tz.zone('America/Porto_Acre').countries(), []);
		test.deepEqual(tz.zone('America/Porto_Velho').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Puerto_Rico').countries(), ["PR"]);
		test.deepEqual(tz.zone('America/Punta_Arenas').countries(), ["CL"]);
		test.deepEqual(tz.zone('America/Rainy_River').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Rankin_Inlet').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Recife').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Regina').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Resolute').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Rio_Branco').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Rosario').countries(), []);
		test.deepEqual(tz.zone('America/Santa_Isabel').countries(), []);
		test.deepEqual(tz.zone('America/Santarem').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Santiago').countries(), ["CL"]);
		test.deepEqual(tz.zone('America/Santo_Domingo').countries(), ["DO"]);
		test.deepEqual(tz.zone('America/Sao_Paulo').countries(), ["BR"]);
		test.deepEqual(tz.zone('America/Scoresbysund').countries(), ["GL"]);
		test.deepEqual(tz.zone('America/Shiprock').countries(), []);
		test.deepEqual(tz.zone('America/Sitka').countries(), ["US"]);
		test.deepEqual(tz.zone('America/St_Barthelemy').countries(), ["BL"]);
		test.deepEqual(tz.zone('America/St_Johns').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/St_Kitts').countries(), ["KN"]);
		test.deepEqual(tz.zone('America/St_Lucia').countries(), ["LC"]);
		test.deepEqual(tz.zone('America/St_Thomas').countries(), ["VI"]);
		test.deepEqual(tz.zone('America/St_Vincent').countries(), ["VC"]);
		test.deepEqual(tz.zone('America/Swift_Current').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Tegucigalpa').countries(), ["HN"]);
		test.deepEqual(tz.zone('America/Thule').countries(), ["GL"]);
		test.deepEqual(tz.zone('America/Thunder_Bay').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Tijuana').countries(), ["MX"]);
		test.deepEqual(tz.zone('America/Toronto').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Tortola').countries(), ["VG"]);
		test.deepEqual(tz.zone('America/Vancouver').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Virgin').countries(), []);
		test.deepEqual(tz.zone('America/Whitehorse').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Winnipeg').countries(), ["CA"]);
		test.deepEqual(tz.zone('America/Yakutat').countries(), ["US"]);
		test.deepEqual(tz.zone('America/Yellowknife').countries(), ["CA"]);
		test.deepEqual(tz.zone('Antarctica/Casey').countries(), ["AQ"]);
		test.deepEqual(tz.zone('Antarctica/Davis').countries(), ["AQ"]);
		test.deepEqual(tz.zone('Antarctica/DumontDUrville').countries(), ["AQ"]);
		test.deepEqual(tz.zone('Antarctica/Macquarie').countries(), ["AU"]);
		test.deepEqual(tz.zone('Antarctica/Mawson').countries(), ["AQ"]);
		test.deepEqual(tz.zone('Antarctica/McMurdo').countries(), ["AQ"]);
		test.deepEqual(tz.zone('Antarctica/Palmer').countries(), ["AQ"]);
		test.deepEqual(tz.zone('Antarctica/Rothera').countries(), ["AQ"]);
		test.deepEqual(tz.zone('Antarctica/South_Pole').countries(), []);
		test.deepEqual(tz.zone('Antarctica/Syowa').countries(), ["AQ"]);
		test.deepEqual(tz.zone('Antarctica/Troll').countries(), ["AQ"]);
		test.deepEqual(tz.zone('Antarctica/Vostok').countries(), ["AQ"]);
		test.deepEqual(tz.zone('Arctic/Longyearbyen').countries(), ["SJ"]);
		test.deepEqual(tz.zone('Asia/Aden').countries(), ["YE"]);
		test.deepEqual(tz.zone('Asia/Almaty').countries(), ["KZ"]);
		test.deepEqual(tz.zone('Asia/Amman').countries(), ["JO"]);
		test.deepEqual(tz.zone('Asia/Anadyr').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Aqtau').countries(), ["KZ"]);
		test.deepEqual(tz.zone('Asia/Aqtobe').countries(), ["KZ"]);
		test.deepEqual(tz.zone('Asia/Ashgabat').countries(), ["TM"]);
		test.deepEqual(tz.zone('Asia/Ashkhabad').countries(), []);
		test.deepEqual(tz.zone('Asia/Atyrau').countries(), ["KZ"]);
		test.deepEqual(tz.zone('Asia/Baghdad').countries(), ["IQ"]);
		test.deepEqual(tz.zone('Asia/Bahrain').countries(), ["BH"]);
		test.deepEqual(tz.zone('Asia/Baku').countries(), ["AZ"]);
		test.deepEqual(tz.zone('Asia/Bangkok').countries(), ["KH","LA","TH","VN"]);
		test.deepEqual(tz.zone('Asia/Barnaul').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Beirut').countries(), ["LB"]);
		test.deepEqual(tz.zone('Asia/Bishkek').countries(), ["KG"]);
		test.deepEqual(tz.zone('Asia/Brunei').countries(), ["BN"]);
		test.deepEqual(tz.zone('Asia/Calcutta').countries(), []);
		test.deepEqual(tz.zone('Asia/Chita').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Choibalsan').countries(), ["MN"]);
		test.deepEqual(tz.zone('Asia/Chongqing').countries(), []);
		test.deepEqual(tz.zone('Asia/Chungking').countries(), []);
		test.deepEqual(tz.zone('Asia/Colombo').countries(), ["LK"]);
		test.deepEqual(tz.zone('Asia/Dacca').countries(), []);
		test.deepEqual(tz.zone('Asia/Damascus').countries(), ["SY"]);
		test.deepEqual(tz.zone('Asia/Dhaka').countries(), ["BD"]);
		test.deepEqual(tz.zone('Asia/Dili').countries(), ["TL"]);
		test.deepEqual(tz.zone('Asia/Dubai').countries(), ["AE","OM"]);
		test.deepEqual(tz.zone('Asia/Dushanbe').countries(), ["TJ"]);
		test.deepEqual(tz.zone('Asia/Famagusta').countries(), ["CY"]);
		test.deepEqual(tz.zone('Asia/Gaza').countries(), ["PS"]);
		test.deepEqual(tz.zone('Asia/Harbin').countries(), []);
		test.deepEqual(tz.zone('Asia/Hebron').countries(), ["PS"]);
		test.deepEqual(tz.zone('Asia/Ho_Chi_Minh').countries(), ["VN"]);
		test.deepEqual(tz.zone('Asia/Hong_Kong').countries(), ["HK"]);
		test.deepEqual(tz.zone('Asia/Hovd').countries(), ["MN"]);
		test.deepEqual(tz.zone('Asia/Irkutsk').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Istanbul').countries(), []);
		test.deepEqual(tz.zone('Asia/Jakarta').countries(), ["ID"]);
		test.deepEqual(tz.zone('Asia/Jayapura').countries(), ["ID"]);
		test.deepEqual(tz.zone('Asia/Jerusalem').countries(), ["IL"]);
		test.deepEqual(tz.zone('Asia/Kabul').countries(), ["AF"]);
		test.deepEqual(tz.zone('Asia/Kamchatka').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Karachi').countries(), ["PK"]);
		test.deepEqual(tz.zone('Asia/Kashgar').countries(), []);
		test.deepEqual(tz.zone('Asia/Kathmandu').countries(), ["NP"]);
		test.deepEqual(tz.zone('Asia/Katmandu').countries(), []);
		test.deepEqual(tz.zone('Asia/Khandyga').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Kolkata').countries(), ["IN"]);
		test.deepEqual(tz.zone('Asia/Krasnoyarsk').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Kuala_Lumpur').countries(), ["MY"]);
		test.deepEqual(tz.zone('Asia/Kuching').countries(), ["MY"]);
		test.deepEqual(tz.zone('Asia/Kuwait').countries(), ["KW"]);
		test.deepEqual(tz.zone('Asia/Macao').countries(), []);
		test.deepEqual(tz.zone('Asia/Macau').countries(), ["MO"]);
		test.deepEqual(tz.zone('Asia/Magadan').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Makassar').countries(), ["ID"]);
		test.deepEqual(tz.zone('Asia/Manila').countries(), ["PH"]);
		test.deepEqual(tz.zone('Asia/Muscat').countries(), ["OM"]);
		test.deepEqual(tz.zone('Asia/Nicosia').countries(), ["CY"]);
		test.deepEqual(tz.zone('Asia/Novokuznetsk').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Novosibirsk').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Omsk').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Oral').countries(), ["KZ"]);
		test.deepEqual(tz.zone('Asia/Phnom_Penh').countries(), ["KH"]);
		test.deepEqual(tz.zone('Asia/Pontianak').countries(), ["ID"]);
		test.deepEqual(tz.zone('Asia/Pyongyang').countries(), ["KP"]);
		test.deepEqual(tz.zone('Asia/Qatar').countries(), ["BH","QA"]);
		test.deepEqual(tz.zone('Asia/Qostanay').countries(), ["KZ"]);
		test.deepEqual(tz.zone('Asia/Qyzylorda').countries(), ["KZ"]);
		test.deepEqual(tz.zone('Asia/Rangoon').countries(), []);
		test.deepEqual(tz.zone('Asia/Riyadh').countries(), ["KW","SA","YE"]);
		test.deepEqual(tz.zone('Asia/Saigon').countries(), []);
		test.deepEqual(tz.zone('Asia/Sakhalin').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Samarkand').countries(), ["UZ"]);
		test.deepEqual(tz.zone('Asia/Seoul').countries(), ["KR"]);
		test.deepEqual(tz.zone('Asia/Shanghai').countries(), ["CN"]);
		test.deepEqual(tz.zone('Asia/Singapore').countries(), ["SG"]);
		test.deepEqual(tz.zone('Asia/Srednekolymsk').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Taipei').countries(), ["TW"]);
		test.deepEqual(tz.zone('Asia/Tashkent').countries(), ["UZ"]);
		test.deepEqual(tz.zone('Asia/Tbilisi').countries(), ["GE"]);
		test.deepEqual(tz.zone('Asia/Tehran').countries(), ["IR"]);
		test.deepEqual(tz.zone('Asia/Tel_Aviv').countries(), []);
		test.deepEqual(tz.zone('Asia/Thimbu').countries(), []);
		test.deepEqual(tz.zone('Asia/Thimphu').countries(), ["BT"]);
		test.deepEqual(tz.zone('Asia/Tokyo').countries(), ["JP"]);
		test.deepEqual(tz.zone('Asia/Tomsk').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Ujung_Pandang').countries(), []);
		test.deepEqual(tz.zone('Asia/Ulaanbaatar').countries(), ["MN"]);
		test.deepEqual(tz.zone('Asia/Ulan_Bator').countries(), []);
		test.deepEqual(tz.zone('Asia/Urumqi').countries(), ["CN"]);
		test.deepEqual(tz.zone('Asia/Ust-Nera').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Vientiane').countries(), ["LA"]);
		test.deepEqual(tz.zone('Asia/Vladivostok').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Yakutsk').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Yangon').countries(), ["MM"]);
		test.deepEqual(tz.zone('Asia/Yekaterinburg').countries(), ["RU"]);
		test.deepEqual(tz.zone('Asia/Yerevan').countries(), ["AM"]);
		test.deepEqual(tz.zone('Atlantic/Azores').countries(), ["PT"]);
		test.deepEqual(tz.zone('Atlantic/Bermuda').countries(), ["BM"]);
		test.deepEqual(tz.zone('Atlantic/Canary').countries(), ["ES"]);
		test.deepEqual(tz.zone('Atlantic/Cape_Verde').countries(), ["CV"]);
		test.deepEqual(tz.zone('Atlantic/Faeroe').countries(), []);
		test.deepEqual(tz.zone('Atlantic/Faroe').countries(), ["FO"]);
		test.deepEqual(tz.zone('Atlantic/Jan_Mayen').countries(), []);
		test.deepEqual(tz.zone('Atlantic/Madeira').countries(), ["PT"]);
		test.deepEqual(tz.zone('Atlantic/Reykjavik').countries(), ["IS"]);
		test.deepEqual(tz.zone('Atlantic/South_Georgia').countries(), ["GS"]);
		test.deepEqual(tz.zone('Atlantic/St_Helena').countries(), ["SH"]);
		test.deepEqual(tz.zone('Atlantic/Stanley').countries(), ["FK"]);
		test.deepEqual(tz.zone('Australia/ACT').countries(), []);
		test.deepEqual(tz.zone('Australia/Adelaide').countries(), ["AU"]);
		test.deepEqual(tz.zone('Australia/Brisbane').countries(), ["AU"]);
		test.deepEqual(tz.zone('Australia/Broken_Hill').countries(), ["AU"]);
		test.deepEqual(tz.zone('Australia/Canberra').countries(), []);
		test.deepEqual(tz.zone('Australia/Currie').countries(), []);
		test.deepEqual(tz.zone('Australia/Darwin').countries(), ["AU"]);
		test.deepEqual(tz.zone('Australia/Eucla').countries(), ["AU"]);
		test.deepEqual(tz.zone('Australia/Hobart').countries(), ["AU"]);
		test.deepEqual(tz.zone('Australia/LHI').countries(), []);
		test.deepEqual(tz.zone('Australia/Lindeman').countries(), ["AU"]);
		test.deepEqual(tz.zone('Australia/Lord_Howe').countries(), ["AU"]);
		test.deepEqual(tz.zone('Australia/Melbourne').countries(), ["AU"]);
		test.deepEqual(tz.zone('Australia/NSW').countries(), []);
		test.deepEqual(tz.zone('Australia/North').countries(), []);
		test.deepEqual(tz.zone('Australia/Perth').countries(), ["AU"]);
		test.deepEqual(tz.zone('Australia/Queensland').countries(), []);
		test.deepEqual(tz.zone('Australia/South').countries(), []);
		test.deepEqual(tz.zone('Australia/Sydney').countries(), ["AU"]);
		test.deepEqual(tz.zone('Australia/Tasmania').countries(), []);
		test.deepEqual(tz.zone('Australia/Victoria').countries(), []);
		test.deepEqual(tz.zone('Australia/West').countries(), []);
		test.deepEqual(tz.zone('Australia/Yancowinna').countries(), []);
		test.deepEqual(tz.zone('Brazil/Acre').countries(), []);
		test.deepEqual(tz.zone('Brazil/DeNoronha').countries(), []);
		test.deepEqual(tz.zone('Brazil/East').countries(), []);
		test.deepEqual(tz.zone('Brazil/West').countries(), []);
		test.deepEqual(tz.zone('CET').countries(), []);
		test.deepEqual(tz.zone('CST6CDT').countries(), []);
		test.deepEqual(tz.zone('Canada/Atlantic').countries(), []);
		test.deepEqual(tz.zone('Canada/Central').countries(), []);
		test.deepEqual(tz.zone('Canada/Eastern').countries(), []);
		test.deepEqual(tz.zone('Canada/Mountain').countries(), []);
		test.deepEqual(tz.zone('Canada/Newfoundland').countries(), []);
		test.deepEqual(tz.zone('Canada/Pacific').countries(), []);
		test.deepEqual(tz.zone('Canada/Saskatchewan').countries(), []);
		test.deepEqual(tz.zone('Canada/Yukon').countries(), []);
		test.deepEqual(tz.zone('Chile/Continental').countries(), []);
		test.deepEqual(tz.zone('Chile/EasterIsland').countries(), []);
		test.deepEqual(tz.zone('Cuba').countries(), []);
		test.deepEqual(tz.zone('EET').countries(), []);
		test.deepEqual(tz.zone('EST').countries(), []);
		test.deepEqual(tz.zone('EST5EDT').countries(), []);
		test.deepEqual(tz.zone('Egypt').countries(), []);
		test.deepEqual(tz.zone('Eire').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT+0').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT+1').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT+10').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT+11').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT+12').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT+2').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT+3').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT+4').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT+5').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT+6').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT+7').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT+8').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT+9').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-0').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-1').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-10').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-11').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-12').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-13').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-14').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-2').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-3').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-4').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-5').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-6').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-7').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-8').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT-9').countries(), []);
		test.deepEqual(tz.zone('Etc/GMT0').countries(), []);
		test.deepEqual(tz.zone('Etc/Greenwich').countries(), []);
		test.deepEqual(tz.zone('Etc/UCT').countries(), []);
		test.deepEqual(tz.zone('Etc/UTC').countries(), []);
		test.deepEqual(tz.zone('Etc/Universal').countries(), []);
		test.deepEqual(tz.zone('Etc/Zulu').countries(), []);
		test.deepEqual(tz.zone('Europe/Amsterdam').countries(), ["NL"]);
		test.deepEqual(tz.zone('Europe/Andorra').countries(), ["AD"]);
		test.deepEqual(tz.zone('Europe/Astrakhan').countries(), ["RU"]);
		test.deepEqual(tz.zone('Europe/Athens').countries(), ["GR"]);
		test.deepEqual(tz.zone('Europe/Belfast').countries(), []);
		test.deepEqual(tz.zone('Europe/Belgrade').countries(), ["BA","HR","ME","MK","RS","SI"]);
		test.deepEqual(tz.zone('Europe/Berlin').countries(), ["DE"]);
		test.deepEqual(tz.zone('Europe/Bratislava').countries(), ["SK"]);
		test.deepEqual(tz.zone('Europe/Brussels').countries(), ["BE"]);
		test.deepEqual(tz.zone('Europe/Bucharest').countries(), ["RO"]);
		test.deepEqual(tz.zone('Europe/Budapest').countries(), ["HU"]);
		test.deepEqual(tz.zone('Europe/Busingen').countries(), ["DE"]);
		test.deepEqual(tz.zone('Europe/Chisinau').countries(), ["MD"]);
		test.deepEqual(tz.zone('Europe/Copenhagen').countries(), ["DK"]);
		test.deepEqual(tz.zone('Europe/Dublin').countries(), ["IE"]);
		test.deepEqual(tz.zone('Europe/Gibraltar').countries(), ["GI"]);
		test.deepEqual(tz.zone('Europe/Guernsey').countries(), ["GG"]);
		test.deepEqual(tz.zone('Europe/Helsinki').countries(), ["AX","FI"]);
		test.deepEqual(tz.zone('Europe/Isle_of_Man').countries(), ["IM"]);
		test.deepEqual(tz.zone('Europe/Istanbul').countries(), ["TR"]);
		test.deepEqual(tz.zone('Europe/Jersey').countries(), ["JE"]);
		test.deepEqual(tz.zone('Europe/Kaliningrad').countries(), ["RU"]);
		test.deepEqual(tz.zone('Europe/Kiev').countries(), ["UA"]);
		test.deepEqual(tz.zone('Europe/Kirov').countries(), ["RU"]);
		test.deepEqual(tz.zone('Europe/Lisbon').countries(), ["PT"]);
		test.deepEqual(tz.zone('Europe/Ljubljana').countries(), ["SI"]);
		test.deepEqual(tz.zone('Europe/London').countries(), ["GB","GG","IM","JE"]);
		test.deepEqual(tz.zone('Europe/Luxembourg').countries(), ["LU"]);
		test.deepEqual(tz.zone('Europe/Madrid').countries(), ["ES"]);
		test.deepEqual(tz.zone('Europe/Malta').countries(), ["MT"]);
		test.deepEqual(tz.zone('Europe/Mariehamn').countries(), ["AX"]);
		test.deepEqual(tz.zone('Europe/Minsk').countries(), ["BY"]);
		test.deepEqual(tz.zone('Europe/Monaco').countries(), ["MC"]);
		test.deepEqual(tz.zone('Europe/Moscow').countries(), ["RU"]);
		test.deepEqual(tz.zone('Europe/Nicosia').countries(), []);
		test.deepEqual(tz.zone('Europe/Oslo').countries(), ["NO","SJ"]);
		test.deepEqual(tz.zone('Europe/Paris').countries(), ["FR"]);
		test.deepEqual(tz.zone('Europe/Podgorica').countries(), ["ME"]);
		test.deepEqual(tz.zone('Europe/Prague').countries(), ["CZ","SK"]);
		test.deepEqual(tz.zone('Europe/Riga').countries(), ["LV"]);
		test.deepEqual(tz.zone('Europe/Rome').countries(), ["IT","SM","VA"]);
		test.deepEqual(tz.zone('Europe/Samara').countries(), ["RU"]);
		test.deepEqual(tz.zone('Europe/San_Marino').countries(), ["SM"]);
		test.deepEqual(tz.zone('Europe/Sarajevo').countries(), ["BA"]);
		test.deepEqual(tz.zone('Europe/Saratov').countries(), ["RU"]);
		test.deepEqual(tz.zone('Europe/Simferopol').countries(), ["RU","UA"]);
		test.deepEqual(tz.zone('Europe/Skopje').countries(), ["MK"]);
		test.deepEqual(tz.zone('Europe/Sofia').countries(), ["BG"]);
		test.deepEqual(tz.zone('Europe/Stockholm').countries(), ["SE"]);
		test.deepEqual(tz.zone('Europe/Tallinn').countries(), ["EE"]);
		test.deepEqual(tz.zone('Europe/Tirane').countries(), ["AL"]);
		test.deepEqual(tz.zone('Europe/Tiraspol').countries(), []);
		test.deepEqual(tz.zone('Europe/Ulyanovsk').countries(), ["RU"]);
		test.deepEqual(tz.zone('Europe/Uzhgorod').countries(), ["UA"]);
		test.deepEqual(tz.zone('Europe/Vaduz').countries(), ["LI"]);
		test.deepEqual(tz.zone('Europe/Vatican').countries(), ["VA"]);
		test.deepEqual(tz.zone('Europe/Vienna').countries(), ["AT"]);
		test.deepEqual(tz.zone('Europe/Vilnius').countries(), ["LT"]);
		test.deepEqual(tz.zone('Europe/Volgograd').countries(), ["RU"]);
		test.deepEqual(tz.zone('Europe/Warsaw').countries(), ["PL"]);
		test.deepEqual(tz.zone('Europe/Zagreb').countries(), ["HR"]);
		test.deepEqual(tz.zone('Europe/Zaporozhye').countries(), ["UA"]);
		test.deepEqual(tz.zone('Europe/Zurich').countries(), ["CH","DE","LI"]);
		test.deepEqual(tz.zone('GB').countries(), []);
		test.deepEqual(tz.zone('GB-Eire').countries(), []);
		test.deepEqual(tz.zone('GMT').countries(), []);
		test.deepEqual(tz.zone('GMT+0').countries(), []);
		test.deepEqual(tz.zone('GMT-0').countries(), []);
		test.deepEqual(tz.zone('GMT0').countries(), []);
		test.deepEqual(tz.zone('Greenwich').countries(), []);
		test.deepEqual(tz.zone('HST').countries(), []);
		test.deepEqual(tz.zone('Hongkong').countries(), []);
		test.deepEqual(tz.zone('Iceland').countries(), []);
		test.deepEqual(tz.zone('Indian/Antananarivo').countries(), ["MG"]);
		test.deepEqual(tz.zone('Indian/Chagos').countries(), ["IO"]);
		test.deepEqual(tz.zone('Indian/Christmas').countries(), ["CX"]);
		test.deepEqual(tz.zone('Indian/Cocos').countries(), ["CC"]);
		test.deepEqual(tz.zone('Indian/Comoro').countries(), ["KM"]);
		test.deepEqual(tz.zone('Indian/Kerguelen').countries(), ["TF"]);
		test.deepEqual(tz.zone('Indian/Mahe').countries(), ["SC"]);
		test.deepEqual(tz.zone('Indian/Maldives').countries(), ["MV"]);
		test.deepEqual(tz.zone('Indian/Mauritius').countries(), ["MU"]);
		test.deepEqual(tz.zone('Indian/Mayotte').countries(), ["YT"]);
		test.deepEqual(tz.zone('Indian/Reunion').countries(), ["RE","TF"]);
		test.deepEqual(tz.zone('Iran').countries(), []);
		test.deepEqual(tz.zone('Israel').countries(), []);
		test.deepEqual(tz.zone('Jamaica').countries(), []);
		test.deepEqual(tz.zone('Japan').countries(), []);
		test.deepEqual(tz.zone('Kwajalein').countries(), []);
		test.deepEqual(tz.zone('Libya').countries(), []);
		test.deepEqual(tz.zone('MET').countries(), []);
		test.deepEqual(tz.zone('MST').countries(), []);
		test.deepEqual(tz.zone('MST7MDT').countries(), []);
		test.deepEqual(tz.zone('Mexico/BajaNorte').countries(), []);
		test.deepEqual(tz.zone('Mexico/BajaSur').countries(), []);
		test.deepEqual(tz.zone('Mexico/General').countries(), []);
		test.deepEqual(tz.zone('NZ').countries(), []);
		test.deepEqual(tz.zone('NZ-CHAT').countries(), []);
		test.deepEqual(tz.zone('Navajo').countries(), []);
		test.deepEqual(tz.zone('PRC').countries(), []);
		test.deepEqual(tz.zone('PST8PDT').countries(), []);
		test.deepEqual(tz.zone('Pacific/Apia').countries(), ["WS"]);
		test.deepEqual(tz.zone('Pacific/Auckland').countries(), ["AQ","NZ"]);
		test.deepEqual(tz.zone('Pacific/Bougainville').countries(), ["PG"]);
		test.deepEqual(tz.zone('Pacific/Chatham').countries(), ["NZ"]);
		test.deepEqual(tz.zone('Pacific/Chuuk').countries(), ["FM"]);
		test.deepEqual(tz.zone('Pacific/Easter').countries(), ["CL"]);
		test.deepEqual(tz.zone('Pacific/Efate').countries(), ["VU"]);
		test.deepEqual(tz.zone('Pacific/Enderbury').countries(), ["KI"]);
		test.deepEqual(tz.zone('Pacific/Fakaofo').countries(), ["TK"]);
		test.deepEqual(tz.zone('Pacific/Fiji').countries(), ["FJ"]);
		test.deepEqual(tz.zone('Pacific/Funafuti').countries(), ["TV"]);
		test.deepEqual(tz.zone('Pacific/Galapagos').countries(), ["EC"]);
		test.deepEqual(tz.zone('Pacific/Gambier').countries(), ["PF"]);
		test.deepEqual(tz.zone('Pacific/Guadalcanal').countries(), ["SB"]);
		test.deepEqual(tz.zone('Pacific/Guam').countries(), ["GU","MP"]);
		test.deepEqual(tz.zone('Pacific/Honolulu').countries(), ["UM","US"]);
		test.deepEqual(tz.zone('Pacific/Johnston').countries(), []);
		test.deepEqual(tz.zone('Pacific/Kiritimati').countries(), ["KI"]);
		test.deepEqual(tz.zone('Pacific/Kosrae').countries(), ["FM"]);
		test.deepEqual(tz.zone('Pacific/Kwajalein').countries(), ["MH"]);
		test.deepEqual(tz.zone('Pacific/Majuro').countries(), ["MH"]);
		test.deepEqual(tz.zone('Pacific/Marquesas').countries(), ["PF"]);
		test.deepEqual(tz.zone('Pacific/Midway').countries(), ["UM"]);
		test.deepEqual(tz.zone('Pacific/Nauru').countries(), ["NR"]);
		test.deepEqual(tz.zone('Pacific/Niue').countries(), ["NU"]);
		test.deepEqual(tz.zone('Pacific/Norfolk').countries(), ["NF"]);
		test.deepEqual(tz.zone('Pacific/Noumea').countries(), ["NC"]);
		test.deepEqual(tz.zone('Pacific/Pago_Pago').countries(), ["AS","UM"]);
		test.deepEqual(tz.zone('Pacific/Palau').countries(), ["PW"]);
		test.deepEqual(tz.zone('Pacific/Pitcairn').countries(), ["PN"]);
		test.deepEqual(tz.zone('Pacific/Pohnpei').countries(), ["FM"]);
		test.deepEqual(tz.zone('Pacific/Ponape').countries(), []);
		test.deepEqual(tz.zone('Pacific/Port_Moresby').countries(), ["PG"]);
		test.deepEqual(tz.zone('Pacific/Rarotonga').countries(), ["CK"]);
		test.deepEqual(tz.zone('Pacific/Saipan').countries(), ["MP"]);
		test.deepEqual(tz.zone('Pacific/Samoa').countries(), []);
		test.deepEqual(tz.zone('Pacific/Tahiti').countries(), ["PF"]);
		test.deepEqual(tz.zone('Pacific/Tarawa').countries(), ["KI"]);
		test.deepEqual(tz.zone('Pacific/Tongatapu').countries(), ["TO"]);
		test.deepEqual(tz.zone('Pacific/Truk').countries(), []);
		test.deepEqual(tz.zone('Pacific/Wake').countries(), ["UM"]);
		test.deepEqual(tz.zone('Pacific/Wallis').countries(), ["WF"]);
		test.deepEqual(tz.zone('Pacific/Yap').countries(), []);
		test.deepEqual(tz.zone('Poland').countries(), []);
		test.deepEqual(tz.zone('Portugal').countries(), []);
		test.deepEqual(tz.zone('ROC').countries(), []);
		test.deepEqual(tz.zone('ROK').countries(), []);
		test.deepEqual(tz.zone('Singapore').countries(), []);
		test.deepEqual(tz.zone('Turkey').countries(), []);
		test.deepEqual(tz.zone('UCT').countries(), []);
		test.deepEqual(tz.zone('US/Alaska').countries(), []);
		test.deepEqual(tz.zone('US/Aleutian').countries(), []);
		test.deepEqual(tz.zone('US/Arizona').countries(), []);
		test.deepEqual(tz.zone('US/Central').countries(), []);
		test.deepEqual(tz.zone('US/East-Indiana').countries(), []);
		test.deepEqual(tz.zone('US/Eastern').countries(), []);
		test.deepEqual(tz.zone('US/Hawaii').countries(), []);
		test.deepEqual(tz.zone('US/Indiana-Starke').countries(), []);
		test.deepEqual(tz.zone('US/Michigan').countries(), []);
		test.deepEqual(tz.zone('US/Mountain').countries(), []);
		test.deepEqual(tz.zone('US/Pacific').countries(), []);
		test.deepEqual(tz.zone('US/Samoa').countries(), []);
		test.deepEqual(tz.zone('UTC').countries(), []);
		test.deepEqual(tz.zone('Universal').countries(), []);
		test.deepEqual(tz.zone('W-SU').countries(), []);
		test.deepEqual(tz.zone('WET').countries(), []);
		test.deepEqual(tz.zone('Zulu').countries(), []);

		test.done();
	},

	country_zones : function (test) {

		test.deepEqual(tz.zonesForCountry("AD"), ["Europe/Andorra"]);
		test.deepEqual(tz.zonesForCountry("AE"), ["Asia/Dubai"]);
		test.deepEqual(tz.zonesForCountry("AF"), ["Asia/Kabul"]);
		test.deepEqual(tz.zonesForCountry("AG"), ["America/Antigua","America/Port_of_Spain"]);
		test.deepEqual(tz.zonesForCountry("AI"), ["America/Anguilla","America/Port_of_Spain"]);
		test.deepEqual(tz.zonesForCountry("AL"), ["Europe/Tirane"]);
		test.deepEqual(tz.zonesForCountry("AM"), ["Asia/Yerevan"]);
		test.deepEqual(tz.zonesForCountry("AO"), ["Africa/Lagos","Africa/Luanda"]);
		test.deepEqual(tz.zonesForCountry("AQ"), ["Antarctica/Casey","Antarctica/Davis","Antarctica/DumontDUrville","Antarctica/Mawson","Antarctica/McMurdo","Antarctica/Palmer","Antarctica/Rothera","Antarctica/Syowa","Antarctica/Troll","Antarctica/Vostok","Pacific/Auckland"]);
		test.deepEqual(tz.zonesForCountry("AR"), ["America/Argentina/Buenos_Aires","America/Argentina/Catamarca","America/Argentina/Cordoba","America/Argentina/Jujuy","America/Argentina/La_Rioja","America/Argentina/Mendoza","America/Argentina/Rio_Gallegos","America/Argentina/Salta","America/Argentina/San_Juan","America/Argentina/San_Luis","America/Argentina/Tucuman","America/Argentina/Ushuaia"]);
		test.deepEqual(tz.zonesForCountry("AS"), ["Pacific/Pago_Pago"]);
		test.deepEqual(tz.zonesForCountry("AT"), ["Europe/Vienna"]);
		test.deepEqual(tz.zonesForCountry("AU"), ["Antarctica/Macquarie","Australia/Adelaide","Australia/Brisbane","Australia/Broken_Hill","Australia/Darwin","Australia/Eucla","Australia/Hobart","Australia/Lindeman","Australia/Lord_Howe","Australia/Melbourne","Australia/Perth","Australia/Sydney"]);
		test.deepEqual(tz.zonesForCountry("AW"), ["America/Aruba","America/Curacao"]);
		test.deepEqual(tz.zonesForCountry("AX"), ["Europe/Helsinki","Europe/Mariehamn"]);
		test.deepEqual(tz.zonesForCountry("AZ"), ["Asia/Baku"]);
		test.deepEqual(tz.zonesForCountry("BA"), ["Europe/Belgrade","Europe/Sarajevo"]);
		test.deepEqual(tz.zonesForCountry("BB"), ["America/Barbados"]);
		test.deepEqual(tz.zonesForCountry("BD"), ["Asia/Dhaka"]);
		test.deepEqual(tz.zonesForCountry("BE"), ["Europe/Brussels"]);
		test.deepEqual(tz.zonesForCountry("BF"), ["Africa/Abidjan","Africa/Ouagadougou"]);
		test.deepEqual(tz.zonesForCountry("BG"), ["Europe/Sofia"]);
		test.deepEqual(tz.zonesForCountry("BH"), ["Asia/Bahrain","Asia/Qatar"]);
		test.deepEqual(tz.zonesForCountry("BI"), ["Africa/Bujumbura","Africa/Maputo"]);
		test.deepEqual(tz.zonesForCountry("BJ"), ["Africa/Lagos","Africa/Porto-Novo"]);
		test.deepEqual(tz.zonesForCountry("BL"), ["America/Port_of_Spain","America/St_Barthelemy"]);
		test.deepEqual(tz.zonesForCountry("BM"), ["Atlantic/Bermuda"]);
		test.deepEqual(tz.zonesForCountry("BN"), ["Asia/Brunei"]);
		test.deepEqual(tz.zonesForCountry("BO"), ["America/La_Paz"]);
		test.deepEqual(tz.zonesForCountry("BQ"), ["America/Curacao","America/Kralendijk"]);
		test.deepEqual(tz.zonesForCountry("BR"), ["America/Araguaina","America/Bahia","America/Belem","America/Boa_Vista","America/Campo_Grande","America/Cuiaba","America/Eirunepe","America/Fortaleza","America/Maceio","America/Manaus","America/Noronha","America/Porto_Velho","America/Recife","America/Rio_Branco","America/Santarem","America/Sao_Paulo"]);
		test.deepEqual(tz.zonesForCountry("BS"), ["America/Nassau"]);
		test.deepEqual(tz.zonesForCountry("BT"), ["Asia/Thimphu"]);
		test.deepEqual(tz.zonesForCountry("BW"), ["Africa/Gaborone","Africa/Maputo"]);
		test.deepEqual(tz.zonesForCountry("BY"), ["Europe/Minsk"]);
		test.deepEqual(tz.zonesForCountry("BZ"), ["America/Belize"]);
		test.deepEqual(tz.zonesForCountry("CA"), ["America/Atikokan","America/Blanc-Sablon","America/Cambridge_Bay","America/Creston","America/Dawson","America/Dawson_Creek","America/Edmonton","America/Fort_Nelson","America/Glace_Bay","America/Goose_Bay","America/Halifax","America/Inuvik","America/Iqaluit","America/Moncton","America/Nipigon","America/Pangnirtung","America/Rainy_River","America/Rankin_Inlet","America/Regina","America/Resolute","America/St_Johns","America/Swift_Current","America/Thunder_Bay","America/Toronto","America/Vancouver","America/Whitehorse","America/Winnipeg","America/Yellowknife"]);
		test.deepEqual(tz.zonesForCountry("CC"), ["Indian/Cocos"]);
		test.deepEqual(tz.zonesForCountry("CD"), ["Africa/Kinshasa","Africa/Lagos","Africa/Lubumbashi","Africa/Maputo"]);
		test.deepEqual(tz.zonesForCountry("CF"), ["Africa/Bangui","Africa/Lagos"]);
		test.deepEqual(tz.zonesForCountry("CG"), ["Africa/Brazzaville","Africa/Lagos"]);
		test.deepEqual(tz.zonesForCountry("CH"), ["Europe/Zurich"]);
		test.deepEqual(tz.zonesForCountry("CI"), ["Africa/Abidjan"]);
		test.deepEqual(tz.zonesForCountry("CK"), ["Pacific/Rarotonga"]);
		test.deepEqual(tz.zonesForCountry("CL"), ["America/Punta_Arenas","America/Santiago","Pacific/Easter"]);
		test.deepEqual(tz.zonesForCountry("CM"), ["Africa/Douala","Africa/Lagos"]);
		test.deepEqual(tz.zonesForCountry("CN"), ["Asia/Shanghai","Asia/Urumqi"]);
		test.deepEqual(tz.zonesForCountry("CO"), ["America/Bogota"]);
		test.deepEqual(tz.zonesForCountry("CR"), ["America/Costa_Rica"]);
		test.deepEqual(tz.zonesForCountry("CU"), ["America/Havana"]);
		test.deepEqual(tz.zonesForCountry("CV"), ["Atlantic/Cape_Verde"]);
		test.deepEqual(tz.zonesForCountry("CW"), ["America/Curacao"]);
		test.deepEqual(tz.zonesForCountry("CX"), ["Indian/Christmas"]);
		test.deepEqual(tz.zonesForCountry("CY"), ["Asia/Famagusta","Asia/Nicosia"]);
		test.deepEqual(tz.zonesForCountry("CZ"), ["Europe/Prague"]);
		test.deepEqual(tz.zonesForCountry("DE"), ["Europe/Berlin","Europe/Busingen","Europe/Zurich"]);
		test.deepEqual(tz.zonesForCountry("DJ"), ["Africa/Djibouti","Africa/Nairobi"]);
		test.deepEqual(tz.zonesForCountry("DK"), ["Europe/Copenhagen"]);
		test.deepEqual(tz.zonesForCountry("DM"), ["America/Dominica","America/Port_of_Spain"]);
		test.deepEqual(tz.zonesForCountry("DO"), ["America/Santo_Domingo"]);
		test.deepEqual(tz.zonesForCountry("DZ"), ["Africa/Algiers"]);
		test.deepEqual(tz.zonesForCountry("EC"), ["America/Guayaquil","Pacific/Galapagos"]);
		test.deepEqual(tz.zonesForCountry("EE"), ["Europe/Tallinn"]);
		test.deepEqual(tz.zonesForCountry("EG"), ["Africa/Cairo"]);
		test.deepEqual(tz.zonesForCountry("EH"), ["Africa/El_Aaiun"]);
		test.deepEqual(tz.zonesForCountry("ER"), ["Africa/Asmara","Africa/Nairobi"]);
		test.deepEqual(tz.zonesForCountry("ES"), ["Africa/Ceuta","Atlantic/Canary","Europe/Madrid"]);
		test.deepEqual(tz.zonesForCountry("ET"), ["Africa/Addis_Ababa","Africa/Nairobi"]);
		test.deepEqual(tz.zonesForCountry("FI"), ["Europe/Helsinki"]);
		test.deepEqual(tz.zonesForCountry("FJ"), ["Pacific/Fiji"]);
		test.deepEqual(tz.zonesForCountry("FK"), ["Atlantic/Stanley"]);
		test.deepEqual(tz.zonesForCountry("FM"), ["Pacific/Chuuk","Pacific/Kosrae","Pacific/Pohnpei"]);
		test.deepEqual(tz.zonesForCountry("FO"), ["Atlantic/Faroe"]);
		test.deepEqual(tz.zonesForCountry("FR"), ["Europe/Paris"]);
		test.deepEqual(tz.zonesForCountry("GA"), ["Africa/Lagos","Africa/Libreville"]);
		test.deepEqual(tz.zonesForCountry("GB"), ["Europe/London"]);
		test.deepEqual(tz.zonesForCountry("GD"), ["America/Grenada","America/Port_of_Spain"]);
		test.deepEqual(tz.zonesForCountry("GE"), ["Asia/Tbilisi"]);
		test.deepEqual(tz.zonesForCountry("GF"), ["America/Cayenne"]);
		test.deepEqual(tz.zonesForCountry("GG"), ["Europe/Guernsey","Europe/London"]);
		test.deepEqual(tz.zonesForCountry("GH"), ["Africa/Accra"]);
		test.deepEqual(tz.zonesForCountry("GI"), ["Europe/Gibraltar"]);
		test.deepEqual(tz.zonesForCountry("GL"), ["America/Danmarkshavn","America/Nuuk","America/Scoresbysund","America/Thule"]);
		test.deepEqual(tz.zonesForCountry("GM"), ["Africa/Abidjan","Africa/Banjul"]);
		test.deepEqual(tz.zonesForCountry("GN"), ["Africa/Abidjan","Africa/Conakry"]);
		test.deepEqual(tz.zonesForCountry("GP"), ["America/Guadeloupe","America/Port_of_Spain"]);
		test.deepEqual(tz.zonesForCountry("GQ"), ["Africa/Lagos","Africa/Malabo"]);
		test.deepEqual(tz.zonesForCountry("GR"), ["Europe/Athens"]);
		test.deepEqual(tz.zonesForCountry("GS"), ["Atlantic/South_Georgia"]);
		test.deepEqual(tz.zonesForCountry("GT"), ["America/Guatemala"]);
		test.deepEqual(tz.zonesForCountry("GU"), ["Pacific/Guam"]);
		test.deepEqual(tz.zonesForCountry("GW"), ["Africa/Bissau"]);
		test.deepEqual(tz.zonesForCountry("GY"), ["America/Guyana"]);
		test.deepEqual(tz.zonesForCountry("HK"), ["Asia/Hong_Kong"]);
		test.deepEqual(tz.zonesForCountry("HN"), ["America/Tegucigalpa"]);
		test.deepEqual(tz.zonesForCountry("HR"), ["Europe/Belgrade","Europe/Zagreb"]);
		test.deepEqual(tz.zonesForCountry("HT"), ["America/Port-au-Prince"]);
		test.deepEqual(tz.zonesForCountry("HU"), ["Europe/Budapest"]);
		test.deepEqual(tz.zonesForCountry("ID"), ["Asia/Jakarta","Asia/Jayapura","Asia/Makassar","Asia/Pontianak"]);
		test.deepEqual(tz.zonesForCountry("IE"), ["Europe/Dublin"]);
		test.deepEqual(tz.zonesForCountry("IL"), ["Asia/Jerusalem"]);
		test.deepEqual(tz.zonesForCountry("IM"), ["Europe/Isle_of_Man","Europe/London"]);
		test.deepEqual(tz.zonesForCountry("IN"), ["Asia/Kolkata"]);
		test.deepEqual(tz.zonesForCountry("IO"), ["Indian/Chagos"]);
		test.deepEqual(tz.zonesForCountry("IQ"), ["Asia/Baghdad"]);
		test.deepEqual(tz.zonesForCountry("IR"), ["Asia/Tehran"]);
		test.deepEqual(tz.zonesForCountry("IS"), ["Atlantic/Reykjavik"]);
		test.deepEqual(tz.zonesForCountry("IT"), ["Europe/Rome"]);
		test.deepEqual(tz.zonesForCountry("JE"), ["Europe/Jersey","Europe/London"]);
		test.deepEqual(tz.zonesForCountry("JM"), ["America/Jamaica"]);
		test.deepEqual(tz.zonesForCountry("JO"), ["Asia/Amman"]);
		test.deepEqual(tz.zonesForCountry("JP"), ["Asia/Tokyo"]);
		test.deepEqual(tz.zonesForCountry("KE"), ["Africa/Nairobi"]);
		test.deepEqual(tz.zonesForCountry("KG"), ["Asia/Bishkek"]);
		test.deepEqual(tz.zonesForCountry("KH"), ["Asia/Bangkok","Asia/Phnom_Penh"]);
		test.deepEqual(tz.zonesForCountry("KI"), ["Pacific/Enderbury","Pacific/Kiritimati","Pacific/Tarawa"]);
		test.deepEqual(tz.zonesForCountry("KM"), ["Africa/Nairobi","Indian/Comoro"]);
		test.deepEqual(tz.zonesForCountry("KN"), ["America/Port_of_Spain","America/St_Kitts"]);
		test.deepEqual(tz.zonesForCountry("KP"), ["Asia/Pyongyang"]);
		test.deepEqual(tz.zonesForCountry("KR"), ["Asia/Seoul"]);
		test.deepEqual(tz.zonesForCountry("KW"), ["Asia/Kuwait","Asia/Riyadh"]);
		test.deepEqual(tz.zonesForCountry("KY"), ["America/Cayman","America/Panama"]);
		test.deepEqual(tz.zonesForCountry("KZ"), ["Asia/Almaty","Asia/Aqtau","Asia/Aqtobe","Asia/Atyrau","Asia/Oral","Asia/Qostanay","Asia/Qyzylorda"]);
		test.deepEqual(tz.zonesForCountry("LA"), ["Asia/Bangkok","Asia/Vientiane"]);
		test.deepEqual(tz.zonesForCountry("LB"), ["Asia/Beirut"]);
		test.deepEqual(tz.zonesForCountry("LC"), ["America/Port_of_Spain","America/St_Lucia"]);
		test.deepEqual(tz.zonesForCountry("LI"), ["Europe/Vaduz","Europe/Zurich"]);
		test.deepEqual(tz.zonesForCountry("LK"), ["Asia/Colombo"]);
		test.deepEqual(tz.zonesForCountry("LR"), ["Africa/Monrovia"]);
		test.deepEqual(tz.zonesForCountry("LS"), ["Africa/Johannesburg","Africa/Maseru"]);
		test.deepEqual(tz.zonesForCountry("LT"), ["Europe/Vilnius"]);
		test.deepEqual(tz.zonesForCountry("LU"), ["Europe/Luxembourg"]);
		test.deepEqual(tz.zonesForCountry("LV"), ["Europe/Riga"]);
		test.deepEqual(tz.zonesForCountry("LY"), ["Africa/Tripoli"]);
		test.deepEqual(tz.zonesForCountry("MA"), ["Africa/Casablanca"]);
		test.deepEqual(tz.zonesForCountry("MC"), ["Europe/Monaco"]);
		test.deepEqual(tz.zonesForCountry("MD"), ["Europe/Chisinau"]);
		test.deepEqual(tz.zonesForCountry("ME"), ["Europe/Belgrade","Europe/Podgorica"]);
		test.deepEqual(tz.zonesForCountry("MF"), ["America/Marigot","America/Port_of_Spain"]);
		test.deepEqual(tz.zonesForCountry("MG"), ["Africa/Nairobi","Indian/Antananarivo"]);
		test.deepEqual(tz.zonesForCountry("MH"), ["Pacific/Kwajalein","Pacific/Majuro"]);
		test.deepEqual(tz.zonesForCountry("MK"), ["Europe/Belgrade","Europe/Skopje"]);
		test.deepEqual(tz.zonesForCountry("ML"), ["Africa/Abidjan","Africa/Bamako"]);
		test.deepEqual(tz.zonesForCountry("MM"), ["Asia/Yangon"]);
		test.deepEqual(tz.zonesForCountry("MN"), ["Asia/Choibalsan","Asia/Hovd","Asia/Ulaanbaatar"]);
		test.deepEqual(tz.zonesForCountry("MO"), ["Asia/Macau"]);
		test.deepEqual(tz.zonesForCountry("MP"), ["Pacific/Guam","Pacific/Saipan"]);
		test.deepEqual(tz.zonesForCountry("MQ"), ["America/Martinique"]);
		test.deepEqual(tz.zonesForCountry("MR"), ["Africa/Abidjan","Africa/Nouakchott"]);
		test.deepEqual(tz.zonesForCountry("MS"), ["America/Montserrat","America/Port_of_Spain"]);
		test.deepEqual(tz.zonesForCountry("MT"), ["Europe/Malta"]);
		test.deepEqual(tz.zonesForCountry("MU"), ["Indian/Mauritius"]);
		test.deepEqual(tz.zonesForCountry("MV"), ["Indian/Maldives"]);
		test.deepEqual(tz.zonesForCountry("MW"), ["Africa/Blantyre","Africa/Maputo"]);
		test.deepEqual(tz.zonesForCountry("MX"), ["America/Bahia_Banderas","America/Cancun","America/Chihuahua","America/Hermosillo","America/Matamoros","America/Mazatlan","America/Merida","America/Mexico_City","America/Monterrey","America/Ojinaga","America/Tijuana"]);
		test.deepEqual(tz.zonesForCountry("MY"), ["Asia/Kuala_Lumpur","Asia/Kuching"]);
		test.deepEqual(tz.zonesForCountry("MZ"), ["Africa/Maputo"]);
		test.deepEqual(tz.zonesForCountry("NA"), ["Africa/Windhoek"]);
		test.deepEqual(tz.zonesForCountry("NC"), ["Pacific/Noumea"]);
		test.deepEqual(tz.zonesForCountry("NE"), ["Africa/Lagos","Africa/Niamey"]);
		test.deepEqual(tz.zonesForCountry("NF"), ["Pacific/Norfolk"]);
		test.deepEqual(tz.zonesForCountry("NG"), ["Africa/Lagos"]);
		test.deepEqual(tz.zonesForCountry("NI"), ["America/Managua"]);
		test.deepEqual(tz.zonesForCountry("NL"), ["Europe/Amsterdam"]);
		test.deepEqual(tz.zonesForCountry("NO"), ["Europe/Oslo"]);
		test.deepEqual(tz.zonesForCountry("NP"), ["Asia/Kathmandu"]);
		test.deepEqual(tz.zonesForCountry("NR"), ["Pacific/Nauru"]);
		test.deepEqual(tz.zonesForCountry("NU"), ["Pacific/Niue"]);
		test.deepEqual(tz.zonesForCountry("NZ"), ["Pacific/Auckland","Pacific/Chatham"]);
		test.deepEqual(tz.zonesForCountry("OM"), ["Asia/Dubai","Asia/Muscat"]);
		test.deepEqual(tz.zonesForCountry("PA"), ["America/Panama"]);
		test.deepEqual(tz.zonesForCountry("PE"), ["America/Lima"]);
		test.deepEqual(tz.zonesForCountry("PF"), ["Pacific/Gambier","Pacific/Marquesas","Pacific/Tahiti"]);
		test.deepEqual(tz.zonesForCountry("PG"), ["Pacific/Bougainville","Pacific/Port_Moresby"]);
		test.deepEqual(tz.zonesForCountry("PH"), ["Asia/Manila"]);
		test.deepEqual(tz.zonesForCountry("PK"), ["Asia/Karachi"]);
		test.deepEqual(tz.zonesForCountry("PL"), ["Europe/Warsaw"]);
		test.deepEqual(tz.zonesForCountry("PM"), ["America/Miquelon"]);
		test.deepEqual(tz.zonesForCountry("PN"), ["Pacific/Pitcairn"]);
		test.deepEqual(tz.zonesForCountry("PR"), ["America/Puerto_Rico"]);
		test.deepEqual(tz.zonesForCountry("PS"), ["Asia/Gaza","Asia/Hebron"]);
		test.deepEqual(tz.zonesForCountry("PT"), ["Atlantic/Azores","Atlantic/Madeira","Europe/Lisbon"]);
		test.deepEqual(tz.zonesForCountry("PW"), ["Pacific/Palau"]);
		test.deepEqual(tz.zonesForCountry("PY"), ["America/Asuncion"]);
		test.deepEqual(tz.zonesForCountry("QA"), ["Asia/Qatar"]);
		test.deepEqual(tz.zonesForCountry("RE"), ["Indian/Reunion"]);
		test.deepEqual(tz.zonesForCountry("RO"), ["Europe/Bucharest"]);
		test.deepEqual(tz.zonesForCountry("RS"), ["Europe/Belgrade"]);
		test.deepEqual(tz.zonesForCountry("RU"), ["Asia/Anadyr","Asia/Barnaul","Asia/Chita","Asia/Irkutsk","Asia/Kamchatka","Asia/Khandyga","Asia/Krasnoyarsk","Asia/Magadan","Asia/Novokuznetsk","Asia/Novosibirsk","Asia/Omsk","Asia/Sakhalin","Asia/Srednekolymsk","Asia/Tomsk","Asia/Ust-Nera","Asia/Vladivostok","Asia/Yakutsk","Asia/Yekaterinburg","Europe/Astrakhan","Europe/Kaliningrad","Europe/Kirov","Europe/Moscow","Europe/Samara","Europe/Saratov","Europe/Simferopol","Europe/Ulyanovsk","Europe/Volgograd"]);
		test.deepEqual(tz.zonesForCountry("RW"), ["Africa/Kigali","Africa/Maputo"]);
		test.deepEqual(tz.zonesForCountry("SA"), ["Asia/Riyadh"]);
		test.deepEqual(tz.zonesForCountry("SB"), ["Pacific/Guadalcanal"]);
		test.deepEqual(tz.zonesForCountry("SC"), ["Indian/Mahe"]);
		test.deepEqual(tz.zonesForCountry("SD"), ["Africa/Khartoum"]);
		test.deepEqual(tz.zonesForCountry("SE"), ["Europe/Stockholm"]);
		test.deepEqual(tz.zonesForCountry("SG"), ["Asia/Singapore"]);
		test.deepEqual(tz.zonesForCountry("SH"), ["Africa/Abidjan","Atlantic/St_Helena"]);
		test.deepEqual(tz.zonesForCountry("SI"), ["Europe/Belgrade","Europe/Ljubljana"]);
		test.deepEqual(tz.zonesForCountry("SJ"), ["Arctic/Longyearbyen","Europe/Oslo"]);
		test.deepEqual(tz.zonesForCountry("SK"), ["Europe/Bratislava","Europe/Prague"]);
		test.deepEqual(tz.zonesForCountry("SL"), ["Africa/Abidjan","Africa/Freetown"]);
		test.deepEqual(tz.zonesForCountry("SM"), ["Europe/Rome","Europe/San_Marino"]);
		test.deepEqual(tz.zonesForCountry("SN"), ["Africa/Abidjan","Africa/Dakar"]);
		test.deepEqual(tz.zonesForCountry("SO"), ["Africa/Mogadishu","Africa/Nairobi"]);
		test.deepEqual(tz.zonesForCountry("SR"), ["America/Paramaribo"]);
		test.deepEqual(tz.zonesForCountry("SS"), ["Africa/Juba"]);
		test.deepEqual(tz.zonesForCountry("ST"), ["Africa/Sao_Tome"]);
		test.deepEqual(tz.zonesForCountry("SV"), ["America/El_Salvador"]);
		test.deepEqual(tz.zonesForCountry("SX"), ["America/Curacao","America/Lower_Princes"]);
		test.deepEqual(tz.zonesForCountry("SY"), ["Asia/Damascus"]);
		test.deepEqual(tz.zonesForCountry("SZ"), ["Africa/Johannesburg","Africa/Mbabane"]);
		test.deepEqual(tz.zonesForCountry("TC"), ["America/Grand_Turk"]);
		test.deepEqual(tz.zonesForCountry("TD"), ["Africa/Ndjamena"]);
		test.deepEqual(tz.zonesForCountry("TF"), ["Indian/Kerguelen","Indian/Reunion"]);
		test.deepEqual(tz.zonesForCountry("TG"), ["Africa/Abidjan","Africa/Lome"]);
		test.deepEqual(tz.zonesForCountry("TH"), ["Asia/Bangkok"]);
		test.deepEqual(tz.zonesForCountry("TJ"), ["Asia/Dushanbe"]);
		test.deepEqual(tz.zonesForCountry("TK"), ["Pacific/Fakaofo"]);
		test.deepEqual(tz.zonesForCountry("TL"), ["Asia/Dili"]);
		test.deepEqual(tz.zonesForCountry("TM"), ["Asia/Ashgabat"]);
		test.deepEqual(tz.zonesForCountry("TN"), ["Africa/Tunis"]);
		test.deepEqual(tz.zonesForCountry("TO"), ["Pacific/Tongatapu"]);
		test.deepEqual(tz.zonesForCountry("TR"), ["Europe/Istanbul"]);
		test.deepEqual(tz.zonesForCountry("TT"), ["America/Port_of_Spain"]);
		test.deepEqual(tz.zonesForCountry("TV"), ["Pacific/Funafuti"]);
		test.deepEqual(tz.zonesForCountry("TW"), ["Asia/Taipei"]);
		test.deepEqual(tz.zonesForCountry("TZ"), ["Africa/Dar_es_Salaam","Africa/Nairobi"]);
		test.deepEqual(tz.zonesForCountry("UA"), ["Europe/Kiev","Europe/Simferopol","Europe/Uzhgorod","Europe/Zaporozhye"]);
		test.deepEqual(tz.zonesForCountry("UG"), ["Africa/Kampala","Africa/Nairobi"]);
		test.deepEqual(tz.zonesForCountry("UM"), ["Pacific/Honolulu","Pacific/Midway","Pacific/Pago_Pago","Pacific/Wake"]);
		test.deepEqual(tz.zonesForCountry("US"), ["America/Adak","America/Anchorage","America/Boise","America/Chicago","America/Denver","America/Detroit","America/Indiana/Indianapolis","America/Indiana/Knox","America/Indiana/Marengo","America/Indiana/Petersburg","America/Indiana/Tell_City","America/Indiana/Vevay","America/Indiana/Vincennes","America/Indiana/Winamac","America/Juneau","America/Kentucky/Louisville","America/Kentucky/Monticello","America/Los_Angeles","America/Menominee","America/Metlakatla","America/New_York","America/Nome","America/North_Dakota/Beulah","America/North_Dakota/Center","America/North_Dakota/New_Salem","America/Phoenix","America/Sitka","America/Yakutat","Pacific/Honolulu"]);
		test.deepEqual(tz.zonesForCountry("UY"), ["America/Montevideo"]);
		test.deepEqual(tz.zonesForCountry("UZ"), ["Asia/Samarkand","Asia/Tashkent"]);
		test.deepEqual(tz.zonesForCountry("VA"), ["Europe/Rome","Europe/Vatican"]);
		test.deepEqual(tz.zonesForCountry("VC"), ["America/Port_of_Spain","America/St_Vincent"]);
		test.deepEqual(tz.zonesForCountry("VE"), ["America/Caracas"]);
		test.deepEqual(tz.zonesForCountry("VG"), ["America/Port_of_Spain","America/Tortola"]);
		test.deepEqual(tz.zonesForCountry("VI"), ["America/Port_of_Spain","America/St_Thomas"]);
		test.deepEqual(tz.zonesForCountry("VN"), ["Asia/Bangkok","Asia/Ho_Chi_Minh"]);
		test.deepEqual(tz.zonesForCountry("VU"), ["Pacific/Efate"]);
		test.deepEqual(tz.zonesForCountry("WF"), ["Pacific/Wallis"]);
		test.deepEqual(tz.zonesForCountry("WS"), ["Pacific/Apia"]);
		test.deepEqual(tz.zonesForCountry("YE"), ["Asia/Aden","Asia/Riyadh"]);
		test.deepEqual(tz.zonesForCountry("YT"), ["Africa/Nairobi","Indian/Mayotte"]);
		test.deepEqual(tz.zonesForCountry("ZA"), ["Africa/Johannesburg"]);
		test.deepEqual(tz.zonesForCountry("ZM"), ["Africa/Lusaka","Africa/Maputo"]);
		test.deepEqual(tz.zonesForCountry("ZW"), ["Africa/Harare","Africa/Maputo"]);

		test.done();
	}
};
