---
Name: Samtools
URL: http://www.htslib.org
Description: >
  Samtools is a suite of programs for interacting with high-throughput
  sequencing data.
---

The Samtools module parses results generated by
[Samtools](http://www.htslib.org),
a suite of programs for interacting with high-throughput
sequencing data.

Supported commands:

- `stats`
- `flagstats`
- `idxstats`
- `rmdup`

### idxstats

The `samtools idxstats` prints its results to standard
out (no consistent file name) and has no header lines
(no way to recognise from content of file). As such, `idxstats`
result files must have the string `idxstat` somewhere in the filename.

There are a few MultiQC config options that you can add to
customise how the idxstats module works. A typical configuration
could look as follows:

```yaml
# Always include these chromosomes in the plot
samtools_idxstats_always:
  - X
  - Y

# Never include these chromosomes in the plot
samtools_idxstats_ignore:
  - MT

# Threshold where chromosomes are ignored in the plot.
# Should be a fraction, default is 0.001 (0.1% of total)
samtools_idxstats_fraction_cutoff: 0.001

# Name of the X and Y chromosomes.
# If not specified, MultiQC will search for any chromosome
# names that look like x, y, chrx or chry (case insensitive search)
samtools_idxstats_xchr: myXchr
samtools_idxstats_ychr: myYchr
```
