import pprint

import databases
import ormar
import sqlalchemy

database = databases.Database("sqlite:///db.sqlite")
metadata = sqlalchemy.MetaData()


class Course(ormar.Model):
    ormar_config = ormar.OrmarConfig(
        database=database,
        metadata=metadata,
    )

    id: int = ormar.Integer(primary_key=True)
    name: str = ormar.String(max_length=100)
    completed: bool = ormar.Boolean(default=False)


pprint.pp({x: v.__dict__ for x, v in Course.ormar_config.model_fields.items()})
"""
Will produce:
{'id': {'__type__': <class 'int'>,
        '__pydantic_type__': <class 'int'>,
        '__sample__': 0,
        'related_name': None,
        'column_type': Integer(),
        'constraints': [],
        'name': 'id',
        'db_alias': None,
        'primary_key': True,
        'autoincrement': True,
        'nullable': True,
        'sql_nullable': False,
        'index': False,
        'unique': False,
        'virtual': None,
        'is_multi': None,
        'is_relation': None,
        'is_through': False,
        'through_relation_name': None,
        'through_reverse_relation_name': None,
        'skip_reverse': False,
        'skip_field': False,
        'owner': <class '__main__.Course'>,
        'to': None,
        'to_pk_only': None,
        'through': None,
        'self_reference': False,
        'self_reference_primary': None,
        'orders_by': None,
        'related_orders_by': None,
        'encrypt_secret': None,
        'encrypt_backend': <EncryptBackends.NONE: 0>,
        'encrypt_custom_backend': None,
        'ormar_default': None,
        'server_default': None,
        'comment': None,
        'represent_as_base64_str': False,
        'minimum': None,
        'maximum': None,
        'multiple_of': None,
        'ge': None,
        'le': None},
 'name': {'__type__': <class 'str'>,
          '__pydantic_type__': <class 'str'>,
          '__sample__': 'string',
          'related_name': None,
          'column_type': String(length=100),
          'constraints': [],
          'name': 'name',
          'db_alias': None,
          'primary_key': False,
          'autoincrement': False,
          'nullable': False,
          'sql_nullable': False,
          'index': False,
          'unique': False,
          'virtual': None,
          'is_multi': None,
          'is_relation': None,
          'is_through': False,
          'through_relation_name': None,
          'through_reverse_relation_name': None,
          'skip_reverse': False,
          'skip_field': False,
          'owner': <class '__main__.Course'>,
          'to': None,
          'to_pk_only': None,
          'through': None,
          'self_reference': False,
          'self_reference_primary': None,
          'orders_by': None,
          'related_orders_by': None,
          'encrypt_secret': None,
          'encrypt_backend': <EncryptBackends.NONE: 0>,
          'encrypt_custom_backend': None,
          'ormar_default': None,
          'server_default': None,
          'comment': None,
          'represent_as_base64_str': False,
          'max_length': 100,
          'min_length': None,
          'regex': None},
 'completed': {'__type__': <class 'bool'>,
               '__pydantic_type__': <class 'bool'>,
               '__sample__': True,
               'related_name': None,
               'column_type': Boolean(),
               'constraints': [],
               'name': 'completed',
               'db_alias': None,
               'primary_key': False,
               'autoincrement': False,
               'nullable': True,
               'sql_nullable': True,
               'index': False,
               'unique': False,
               'virtual': None,
               'is_multi': None,
               'is_relation': None,
               'is_through': False,
               'through_relation_name': None,
               'through_reverse_relation_name': None,
               'skip_reverse': False,
               'skip_field': False,
               'owner': <class '__main__.Course'>,
               'to': None,
               'to_pk_only': None,
               'through': None,
               'self_reference': False,
               'self_reference_primary': None,
               'orders_by': None,
               'related_orders_by': None,
               'encrypt_secret': None,
               'encrypt_backend': <EncryptBackends.NONE: 0>,
               'encrypt_custom_backend': None,
               'ormar_default': False,
               'server_default': None,
               'comment': None,
               'represent_as_base64_str': False}}
"""
