/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Properties;
import org.web3d.util.BooleanStack;
import org.web3d.util.IntStack;
import org.web3d.util.SimpleStack;
import org.web3d.vrml.export.Exporter;
import org.web3d.vrml.lang.UnsupportedSpecVersionException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.proto.AbstractProto;
import org.web3d.vrml.nodes.proto.ExternalPrototypeDecl;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.parser.FieldParserFactory;
import org.web3d.vrml.parser.VRMLFieldReader;
import org.web3d.vrml.renderer.DefaultNodeFactory;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.SAVException;

public class X3DXMLExporter
extends Exporter {
    protected static final String CONTAINER_PROPS_FILE = "XMLcontainerfields.properties";
    protected static final String CONTAINER_ATTR = "containerField";
    public static final int INDENT_SIZE = 4;
    private PrintWriter pw;
    private HashMap nodeNum;
    private HashMap defTable;
    private HashMap defRemapTable;
    private HashMap defNumTable;
    private int lastDef;
    private VRMLNodeFactory nodeFactory;
    protected static VRMLFieldReader fieldParser;
    private SimpleStack currentNode;
    private String currentNodeName;
    private SimpleStack currentField;
    private IntStack inFieldType;
    private IntStack fieldCnt;
    private IntStack nodeCnt;
    private SimpleStack currentIS;
    private boolean inCData;
    private int ilevel;
    private int nlevel;
    private IntStack fieldDeclCnt;
    private String istring;
    private boolean upgrading;
    private HashMap nodeMap;
    protected HashMap protoMap;
    protected HashMap externProtoMap;
    private SimpleStack protoDeclStack;
    private SimpleStack protoMapStack;
    private AbstractProto currentProto;
    private BooleanStack isProto;
    protected VRMLScriptNodeType currentScript;
    private SimpleStack attribs;
    private StringBuffer currentAttribs;
    private SimpleStack nodes;
    private StringBuffer currentNodes;
    private boolean lastStartField;
    private boolean lastIS;
    private boolean gotFieldValue;
    private int major;
    private int minor;
    private Properties containerFields;

    public X3DXMLExporter(OutputStream outputStream, int n, int n2) {
        super(n, n2);
        this.pw = new PrintWriter(outputStream, false);
        this.currentNode = new SimpleStack();
        this.currentField = new SimpleStack();
        this.currentIS = new SimpleStack();
        this.attribs = new SimpleStack();
        this.nodes = new SimpleStack();
        this.fieldCnt = new IntStack();
        this.nodeCnt = new IntStack();
        this.inFieldType = new IntStack();
        this.protoDeclStack = new SimpleStack();
        this.protoMapStack = new SimpleStack();
        this.fieldDeclCnt = new IntStack();
        this.isProto = new BooleanStack();
        this.containerFields = new Properties();
        this.nodeFactory = DefaultNodeFactory.newInstance("null");
        this.nodeFactory.setSpecVersion(n, n2);
        this.nodeFactory.setProfile("Immersive");
        FieldParserFactory fieldParserFactory = FieldParserFactory.getFieldParserFactory();
        fieldParser = fieldParserFactory.newFieldParser(n, n2);
        this.ilevel = 0;
        this.nlevel = 0;
        this.inCData = false;
        this.upgrading = false;
        this.lastStartField = false;
        this.lastIS = false;
        this.gotFieldValue = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append(' ');
        }
        this.istring = stringBuffer.toString();
        this.nodeMap = new HashMap(50);
        this.protoMap = new HashMap();
        this.externProtoMap = new HashMap();
        this.defTable = new HashMap();
        this.defRemapTable = new HashMap();
        this.defNumTable = new HashMap();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument(String string, String string2, String string3, String string4, String string5, String string6) throws SAVException, VRMLException {
        if (string5.equals("V2.0")) {
            this.upgrading = true;
            System.out.println("Upgrading content from VRML to X3D");
        }
        int n = string5.indexOf(46);
        String string7 = string5.substring(1, n);
        String string8 = string5.substring(n + 1);
        this.major = Integer.parseInt(string7);
        int n2 = Integer.parseInt(string8);
        if (this.containerFields.size() == 0 || n2 != this.minor) {
            this.loadContainerProperties(string5.substring(1));
        }
        this.minor = n2;
        this.nodeFactory.setSpecVersion(this.major, this.minor);
        this.pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.pw.print("<!DOCTYPE X3D PUBLIC ");
        if (this.upgrading) {
            String string9 = this.getPublicId(this.major, this.minor);
            String string10 = this.getSystemId(this.major, this.minor);
            this.pw.print("\"");
            this.pw.print(string9);
            this.pw.print("\" \"");
            this.pw.print(string10);
            this.pw.println("\">\n<X3D profile=\"Immersive\">\n");
            this.pw.println("<Scene>");
        }
    }

    public void profileDecl(String string) throws SAVException, VRMLException {
        this.nodeFactory.setProfile(string);
        String string2 = this.getPublicId(this.major, this.minor);
        String string3 = this.getSystemId(this.major, this.minor);
        this.pw.print("\"");
        this.pw.print(string2);
        this.pw.print("\" \"");
        this.pw.print(string3);
        this.pw.print("\">\n<X3D profile=\"");
        this.pw.print(string);
        this.pw.print("\">\n");
        this.pw.println("<Scene>");
    }

    public void componentDecl(String string) throws SAVException, VRMLException {
        int n = string.indexOf(":");
        if (n < 0) {
            System.out.println("Invalid component info");
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        this.nodeFactory.addComponent(string2, Integer.parseInt(string3));
        this.pw.print("<component name=\"");
        this.pw.print(string2);
        this.pw.print("\" level=\"");
        this.pw.print(string3);
        this.pw.println("\" />");
    }

    public void metaDecl(String string, String string2) throws SAVException, VRMLException {
        this.pw.print("<meta name=\"");
        this.pw.print(string);
        this.pw.print("=\"");
        this.pw.print(string2);
        this.pw.println("\"");
    }

    public void importDecl(String string, String string2, String string3) throws SAVException, VRMLException {
        this.pw.print("IMPORT ");
        this.pw.print(string);
        this.pw.print(".");
        this.pw.print(string2);
        this.pw.print(" AS ");
        this.pw.println(string3);
    }

    public void exportDecl(String string, String string2) throws SAVException, VRMLException {
        this.pw.print("EXPORT ");
        this.pw.print(string);
        this.pw.print(" AS ");
        this.pw.print(string2);
    }

    public void endDocument() throws SAVException, VRMLException {
        this.pw.println("</Scene>");
        this.pw.println("</X3D>");
        this.pw.flush();
    }

    public void startNode(String string, String string2) throws SAVException, VRMLException {
        this.lastStartField = false;
        this.currentNodes = new StringBuffer();
        this.currentNodeName = string;
        this.currentAttribs = new StringBuffer();
        ++this.nlevel;
        if (!this.inFieldType.isEmpty()) {
            int n = this.inFieldType.peek();
            int n2 = this.nodeCnt.pop();
            this.nodeCnt.push(++n2);
        }
        this.lastIS = false;
        VRMLNode vRMLNode = (VRMLNode)this.nodeMap.get(string);
        if (this.protoMap.containsKey(string) || this.externProtoMap.containsKey(string)) {
            this.isProto.push(true);
        } else {
            this.isProto.push(false);
        }
        if (vRMLNode == null) {
            if (this.protoMap.containsKey(string) || this.externProtoMap.containsKey(string)) {
                PrototypeDecl prototypeDecl = null;
                prototypeDecl = (PrototypeDecl)this.protoMap.get(string);
                if (prototypeDecl == null) {
                    ExternalPrototypeDecl externalPrototypeDecl = (ExternalPrototypeDecl)this.externProtoMap.get(string);
                    this.currentNode.push(externalPrototypeDecl);
                } else {
                    this.currentNode.push(prototypeDecl);
                }
            } else {
                vRMLNode = this.nodeFactory.createVRMLNode(string, false);
                this.nodeMap.put(string, vRMLNode);
                this.currentNode.push(vRMLNode);
            }
        } else {
            this.currentNode.push(vRMLNode);
        }
        this.fieldCnt.push(0);
        ++this.ilevel;
        if (string2 != null) {
            if (this.defTable.get(string2) != null) {
                Integer n = (Integer)this.defNumTable.get(string2);
                n = n != null ? new Integer(n + 1) : new Integer(1);
                this.defNumTable.put(string2, n);
                String string3 = string2 + "_DUP" + n;
                System.out.println("Duplicate DEF detected, renamed to: " + string3);
                this.defRemapTable.put(string2, string3);
                string2 = string3;
            } else {
                this.defTable.put(string2, string);
            }
            this.currentAttribs.append(" DEF=\"");
            this.currentAttribs.append(string2);
            this.currentAttribs.append("\"");
        }
        this.nodes.push(this.currentNodes);
        this.attribs.push(this.currentAttribs);
        this.currentIS.push(new StringBuffer());
    }

    public void endNode() throws SAVException, VRMLException {
        --this.ilevel;
        --this.nlevel;
        Object object = this.currentNode.pop();
        int n = this.fieldCnt.pop();
        if (n > 0 && !this.lastIS && !this.inFieldType.isEmpty()) {
            int n2 = this.inFieldType.pop();
            if (n2 < 2) {
                int n3 = this.nodeCnt.pop();
                this.currentField.pop();
                if (n2 == 0) {
                    this.indent();
                    --this.ilevel;
                }
            } else if (!this.gotFieldValue && !this.lastIS) {
                this.nodeCnt.pop();
                this.currentField.pop();
            }
        }
        this.indent();
        String string = null;
        this.currentAttribs = (StringBuffer)this.attribs.pop();
        this.currentNodes = (StringBuffer)this.nodes.pop();
        if (object instanceof VRMLNodeType) {
            string = ((VRMLNodeType)object).getVRMLNodeName();
        } else if (object instanceof PrototypeDecl) {
            string = ((PrototypeDecl)object).getVRMLNodeName();
            this.currentAttribs.append(" name=\"");
            this.currentAttribs.append(string);
            this.currentAttribs.append("\"");
            string = "ProtoInstance";
        } else {
            string = ((ExternalPrototypeDecl)object).getVRMLNodeName();
        }
        StringBuffer stringBuffer = (StringBuffer)this.currentIS.pop();
        if (stringBuffer.length() > 0) {
            this.currentNodes.insert(0, "</IS>");
            this.currentNodes.insert(0, stringBuffer.toString());
            this.currentNodes.insert(0, "<IS>");
        }
        this.currentNodes.insert(0, ">");
        this.currentNodes.insert(0, this.currentAttribs.toString());
        this.currentNodes.insert(0, string);
        this.currentNodes.insert(0, "<");
        this.currentNodes.append("</");
        this.currentNodes.append(string);
        this.currentNodes.append(">");
        StringBuffer stringBuffer2 = null;
        if (!this.nodes.isEmpty()) {
            stringBuffer2 = (StringBuffer)this.nodes.pop();
        }
        if (stringBuffer2 == null) {
            this.pw.println(this.currentNodes.toString());
        } else {
            stringBuffer2.append(this.currentNodes.toString());
            this.nodes.push(stringBuffer2);
        }
        this.isProto.pop();
        this.lastIS = false;
    }

    public void startField(String string) throws SAVException, VRMLException {
        int n;
        this.lastStartField = true;
        int n2 = this.fieldCnt.pop();
        int n3 = 0;
        if (!this.fieldDeclCnt.isEmpty()) {
            n3 = this.fieldDeclCnt.peek();
        }
        if (n3 == this.nlevel) {
            this.fieldDeclCnt.pop();
            this.currentNodes = (StringBuffer)this.nodes.pop();
            this.currentAttribs = (StringBuffer)this.attribs.pop();
            this.currentNodes.insert(0, ">");
            this.currentNodes.insert(0, this.currentAttribs.toString());
            this.currentNodes.insert(0, "field");
            this.currentNodes.insert(0, "<");
            this.currentNodes.append("</field>");
            StringBuffer stringBuffer = null;
            if (!this.nodes.isEmpty()) {
                stringBuffer = (StringBuffer)this.nodes.pop();
            }
            if (stringBuffer == null) {
                this.pw.println(this.currentNodes.toString());
            } else {
                stringBuffer.append(this.currentNodes.toString());
                this.nodes.push(stringBuffer);
            }
        }
        if (n2 > 0 && !this.lastIS && !this.inFieldType.isEmpty()) {
            int n4 = this.inFieldType.pop();
            if (n4 < 2) {
                n = this.nodeCnt.pop();
                this.currentField.pop();
                if (n4 == 0) {
                    this.indent();
                    --this.ilevel;
                }
            } else if (!this.gotFieldValue && !this.lastIS) {
                this.nodeCnt.pop();
                this.currentField.pop();
            }
        }
        this.fieldCnt.push(++n2);
        this.lastIS = false;
        this.gotFieldValue = false;
        this.indent();
        Object object = this.currentNode.peek();
        n = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldIndex(string) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldIndex(string) : ((ExternalPrototypeDecl)object).getFieldIndex(string));
        this.currentField.push(new Integer(n));
        int n5 = -1;
        if (this.isField(12)) {
            n5 = 0;
            ++this.ilevel;
            this.indent();
        } else {
            n5 = this.isField(11) ? 1 : (this.isSFField() ? 2 : 3);
        }
        this.inFieldType.push(n5);
        if (n5 > 1) {
            if (string.equals("url") && ((VRMLNodeType)object).getVRMLNodeName().equals("Script")) {
                this.inCData = true;
                this.currentNodes = (StringBuffer)this.nodes.peek();
                this.currentAttribs = (StringBuffer)this.attribs.peek();
            } else {
                this.inCData = false;
                this.currentNodes = (StringBuffer)this.nodes.peek();
                this.currentAttribs = (StringBuffer)this.attribs.peek();
            }
        }
        this.nodeCnt.push(0);
    }

    public void fieldValue(String string) throws SAVException, VRMLException {
        this.gotFieldValue = true;
        Object object = this.currentNode.peek();
        int n = (Integer)this.currentField.peek();
        VRMLFieldDeclaration vRMLFieldDeclaration = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldDeclaration(n) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldDeclaration(n) : ((ExternalPrototypeDecl)object).getFieldDeclaration(n));
        String string2 = vRMLFieldDeclaration.getName();
        if (!this.inCData) {
            boolean bl = this.isProto.peek();
            if (!bl) {
                this.currentAttribs.append("\n");
                this.currentAttribs.append(string2);
                this.currentAttribs.append("=");
                if (string == null) {
                    this.currentAttribs.append("\"");
                    this.currentAttribs.append("\"");
                } else if (string != null) {
                    if (this.isField(1)) {
                        this.currentAttribs.append("\"");
                        this.currentAttribs.append(string.toLowerCase());
                        this.currentAttribs.append("\"");
                    } else if (this.isField(27) || this.isField(28)) {
                        if (string.startsWith("\"")) {
                            this.currentAttribs.append(string);
                        } else {
                            this.currentAttribs.append("\"");
                            this.currentAttribs.append(string);
                            this.currentAttribs.append("\"");
                        }
                    } else {
                        this.currentAttribs.append("\"");
                        this.currentAttribs.append(string);
                        this.currentAttribs.append("\"");
                    }
                }
            } else {
                this.currentNodes.append("<fieldValue name=\"");
                this.currentNodes.append(string2);
                this.currentNodes.append("\" value=");
                if (string != null) {
                    if (this.isField(1)) {
                        this.currentNodes.append("\"");
                        this.currentNodes.append(string.toLowerCase());
                        this.currentNodes.append("\"");
                    } else if (this.isField(27) || this.isField(28)) {
                        if (string.startsWith("\"")) {
                            this.currentAttribs.append(string);
                        } else {
                            this.currentAttribs.append("\"");
                            this.currentAttribs.append(string);
                            this.currentAttribs.append("\"");
                        }
                    } else {
                        this.currentNodes.append("\"");
                        this.currentNodes.append(string);
                        this.currentNodes.append("\"");
                    }
                }
                this.currentNodes.append("/>\n");
            }
        } else {
            this.currentNodes.append("<![CDATA[\n");
            string = string.substring(1, string.length() - 1);
            this.currentNodes.append(string);
            this.currentNodes.append("\n]]>");
        }
        this.currentField.pop();
        this.nodeCnt.pop();
    }

    public void fieldValue(String[] stringArray) throws SAVException, VRMLException {
        this.gotFieldValue = true;
        int n = (Integer)this.currentField.peek();
        if (!this.inCData) {
            boolean bl = this.isProto.peek();
            Object object = this.currentNode.peek();
            VRMLFieldDeclaration vRMLFieldDeclaration = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldDeclaration(n) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldDeclaration(n) : ((ExternalPrototypeDecl)object).getFieldDeclaration(n));
            if (!bl) {
                this.currentAttribs.append("\n");
                this.currentAttribs.append(vRMLFieldDeclaration.getName());
                this.currentAttribs.append("=");
                this.currentAttribs.append("'");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.currentAttribs.append(stringArray[i]);
                    this.currentAttribs.append(" ");
                }
                this.currentAttribs.append("'\n");
            } else {
                this.currentNodes.append("<fieldValue name=\"");
                this.currentNodes.append(vRMLFieldDeclaration.getName());
                this.currentNodes.append("\" value=");
                this.currentNodes.append("'");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.currentNodes.append("\"");
                    this.currentNodes.append(stringArray[i]);
                    this.currentNodes.append("\"");
                }
                this.currentNodes.append("'\n/>");
            }
        } else {
            this.currentNodes.append("<![CDATA[\n");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].substring(1, stringArray[i].length() - 1);
                this.currentNodes.append(stringArray[i]);
            }
            this.currentNodes.append("\n]]>");
        }
        this.currentField.pop();
        this.nodeCnt.pop();
    }

    public void useDecl(String string) throws SAVException, VRMLException {
        int n = this.nodeCnt.pop();
        this.nodeCnt.push(++n);
        this.currentNodes.append("<");
        String string2 = (String)this.defTable.get(string);
        this.currentNodes.append(string2);
        String string3 = (String)this.defRemapTable.get(string);
        if (string3 != null) {
            string = string3;
        }
        this.currentNodes.append(" USE=\"");
        this.currentNodes.append(string);
        this.currentNodes.append("\"");
        this.currentNodes.append("/>");
    }

    public void endField() throws SAVException, VRMLException {
    }

    public void routeDecl(String string, String string2, String string3, String string4) throws SAVException, VRMLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<ROUTE fromNode=\"");
        stringBuffer.append(string);
        stringBuffer.append("\" fromField=\"");
        stringBuffer.append(string2);
        stringBuffer.append("\" toNode=\"");
        stringBuffer.append(string3);
        stringBuffer.append("\" toField=\"");
        stringBuffer.append(string4);
        stringBuffer.append("\"/>\n");
        if (!this.nodes.isEmpty()) {
            this.currentNodes = (StringBuffer)this.nodes.peek();
            this.currentNodes.append(stringBuffer.toString());
        } else {
            this.pw.print(stringBuffer.toString());
        }
    }

    public void startScriptDecl() throws SAVException, VRMLException {
        this.currentScript = (VRMLScriptNodeType)this.currentNode.peek();
        this.fieldCnt.push(0);
    }

    public void endScriptDecl() throws SAVException, VRMLException {
        int n = this.fieldCnt.pop();
        int n2 = 0;
        if (!this.fieldDeclCnt.isEmpty()) {
            n2 = this.fieldDeclCnt.peek();
        }
        if (n2 == this.nlevel) {
            this.fieldDeclCnt.pop();
            this.currentNodes = (StringBuffer)this.nodes.pop();
            this.currentAttribs = (StringBuffer)this.attribs.pop();
            this.currentNodes.insert(0, ">");
            this.currentNodes.insert(0, this.currentAttribs.toString());
            this.currentNodes.insert(0, "field");
            this.currentNodes.insert(0, "<");
            this.currentNodes.append("</field>");
            StringBuffer stringBuffer = null;
            if (!this.nodes.isEmpty()) {
                stringBuffer = (StringBuffer)this.nodes.pop();
            }
            if (stringBuffer == null) {
                this.pw.println(this.currentNodes.toString());
            } else {
                stringBuffer.append(this.currentNodes.toString());
                this.nodes.push(stringBuffer);
            }
        }
        if (n > 0 && !this.inFieldType.isEmpty()) {
            int n3 = this.inFieldType.pop();
            if (n3 < 2) {
                int n4 = this.nodeCnt.pop();
                this.currentField.pop();
            } else if (!this.gotFieldValue && !this.lastIS) {
                this.nodeCnt.pop();
                this.currentField.pop();
            }
        }
    }

    public void scriptFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(n, string, string2);
        this.currentScript.appendField(vRMLFieldDeclaration);
        this.printFieldDecl(n, string, string2, this.currentScript.getFieldIndex(string2), object);
    }

    public void startProtoDecl(String string) throws SAVException, VRMLException {
        this.indent();
        ++this.ilevel;
        ++this.nlevel;
        this.currentNodes = new StringBuffer();
        this.currentAttribs = new StringBuffer();
        this.currentAttribs.append(" name=\"");
        this.currentAttribs.append(string);
        this.currentAttribs.append("\"");
        this.nodes.push(this.currentNodes);
        this.attribs.push(this.currentAttribs);
        this.currentNodes = new StringBuffer();
        this.currentAttribs = new StringBuffer();
        this.nodes.push(this.currentNodes);
        this.attribs.push(this.currentAttribs);
        PrototypeDecl prototypeDecl = new PrototypeDecl(string, this.majorVersion, this.minorVersion, null);
        this.protoMap.put(string, prototypeDecl);
        this.protoDeclStack.push(prototypeDecl);
        this.currentProto = prototypeDecl;
        this.fieldCnt.push(0);
    }

    public void endProtoDecl() throws SAVException, VRMLException {
        int n;
        int n2 = 0;
        if (!this.fieldDeclCnt.isEmpty()) {
            n2 = this.fieldDeclCnt.peek();
        }
        if (n2 == this.nlevel) {
            this.fieldDeclCnt.pop();
            this.currentNodes = (StringBuffer)this.nodes.pop();
            this.currentAttribs = (StringBuffer)this.attribs.pop();
            this.currentNodes.insert(0, ">");
            this.currentNodes.insert(0, this.currentAttribs.toString());
            this.currentNodes.insert(0, "field");
            this.currentNodes.insert(0, "<");
            this.currentNodes.append("</field>");
            StringBuffer stringBuffer = null;
            if (!this.nodes.isEmpty()) {
                stringBuffer = (StringBuffer)this.nodes.pop();
            }
            if (stringBuffer == null) {
                this.pw.println(this.currentNodes.toString());
            } else {
                stringBuffer.append(this.currentNodes.toString());
                this.nodes.push(stringBuffer);
            }
        }
        if ((n = this.fieldCnt.pop()) > 0 && !this.inFieldType.isEmpty()) {
            int n3 = this.inFieldType.pop();
            if (n3 < 2) {
                int n4 = this.nodeCnt.pop();
                this.currentField.pop();
            } else if (!this.gotFieldValue && !this.lastIS) {
                this.nodeCnt.pop();
                this.currentField.pop();
            }
        }
        this.currentNodes = (StringBuffer)this.nodes.pop();
        this.currentAttribs = (StringBuffer)this.attribs.pop();
        this.currentNodes.insert(0, ">");
        this.currentNodes.insert(0, this.currentAttribs.toString());
        this.currentNodes.insert(0, "ProtoInterface");
        this.currentNodes.insert(0, "<");
        this.currentNodes.append("</ProtoInterface>\n");
        StringBuffer stringBuffer = (StringBuffer)this.nodes.pop();
        stringBuffer.append(this.currentNodes.toString());
        this.nodes.push(stringBuffer);
        --this.ilevel;
        --this.nlevel;
        this.indent();
    }

    public void protoFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(n, string, string2);
        this.currentProto.appendField(vRMLFieldDeclaration);
        this.printFieldDecl(n, string, string2, this.currentProto.getFieldIndex(string2), object);
    }

    public void protoIsDecl(String string) throws SAVException, VRMLException {
        int n = this.inFieldType.pop();
        int n2 = -1;
        if (this.lastStartField || n < 2) {
            this.nodeCnt.pop();
            n2 = (Integer)this.currentField.pop();
        }
        if (n2 == -1) {
            System.out.println("*** Can't find field: " + string);
            n2 = 0;
        }
        if (this.lastStartField) {
            StringBuffer stringBuffer = (StringBuffer)this.currentIS.peek();
            stringBuffer.append("<connect nodeField=\"");
            Object object = this.currentNode.peek();
            VRMLFieldDeclaration vRMLFieldDeclaration = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldDeclaration(n2) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldDeclaration(n2) : ((ExternalPrototypeDecl)object).getFieldDeclaration(n2));
            stringBuffer.append(vRMLFieldDeclaration.getName());
            stringBuffer.append("\" protoField=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"/>\n");
        } else {
            this.currentNodes.append("<IS>");
            this.currentNodes.append("<connect nodeField=\"");
            Object object = this.currentNode.peek();
            VRMLFieldDeclaration vRMLFieldDeclaration = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldDeclaration(n2) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldDeclaration(n2) : ((ExternalPrototypeDecl)object).getFieldDeclaration(n2));
            this.currentNodes.append(vRMLFieldDeclaration.getName());
            this.currentNodes.append("\" protoField=\"");
            this.currentNodes.append(string);
            this.currentNodes.append("\"/>\n");
            this.currentNodes.append("</IS>");
        }
        this.lastIS = true;
    }

    public void startProtoBody() throws SAVException, VRMLException {
        this.indent();
        ++this.ilevel;
        this.protoMapStack.push(this.protoMap);
        this.protoMap = new HashMap();
        this.currentNodes = new StringBuffer();
        this.currentAttribs = new StringBuffer();
        this.currentNodes.append("<ProtoBody>");
        this.nodes.push(this.currentNodes);
        this.attribs.push(this.currentAttribs);
    }

    public void endProtoBody() throws SAVException, VRMLException {
        --this.ilevel;
        this.indent();
        this.protoMap = this.protoMapStack.size() > 0 ? (HashMap)this.protoMapStack.pop() : new HashMap();
        StringBuffer stringBuffer = (StringBuffer)this.nodes.pop();
        stringBuffer.append("</ProtoBody>\n");
        this.currentAttribs = (StringBuffer)this.attribs.pop();
        this.currentNodes = (StringBuffer)this.nodes.pop();
        this.currentAttribs = (StringBuffer)this.attribs.pop();
        this.currentNodes.append(stringBuffer.toString());
        this.currentNodes.insert(0, ">");
        this.currentNodes.insert(0, this.currentAttribs.toString());
        this.currentNodes.insert(0, "ProtoDeclare");
        this.currentNodes.insert(0, "<");
        this.currentNodes.append("</ProtoDeclare>\n");
        stringBuffer = null;
        if (!this.nodes.isEmpty()) {
            stringBuffer = (StringBuffer)this.nodes.pop();
        }
        if (stringBuffer == null) {
            this.pw.println(this.currentNodes.toString());
        } else {
            stringBuffer.append(this.currentNodes.toString());
            this.nodes.push(stringBuffer);
        }
    }

    public void startExternProtoDecl(String string) throws SAVException, VRMLException {
        this.indent();
        this.pw.print("EXTERNPROTO ");
        this.pw.print(string);
        this.pw.println(" [");
        ++this.ilevel;
        ExternalPrototypeDecl externalPrototypeDecl = new ExternalPrototypeDecl(string, this.majorVersion, this.minorVersion, null);
        this.externProtoMap.put(string, externalPrototypeDecl);
        this.currentProto = externalPrototypeDecl;
    }

    public void endExternProtoDecl() throws SAVException, VRMLException {
        this.indent();
        this.pw.print("] ");
        --this.ilevel;
    }

    public void externProtoURI(String[] stringArray) throws SAVException, VRMLException {
        this.pw.print("\"");
        for (int i = 0; i < stringArray.length; ++i) {
            this.pw.print(stringArray[i]);
        }
        this.pw.println("\"\n");
    }

    private void indent() {
        for (int i = 0; i < this.ilevel; ++i) {
        }
    }

    private void printFieldDecl(int n, String string, String string2, int n2, Object object) {
        int n3;
        int n4;
        int n5 = 0;
        if (!this.fieldDeclCnt.isEmpty()) {
            n5 = this.fieldDeclCnt.peek();
        }
        if (n5 == this.nlevel) {
            this.fieldDeclCnt.pop();
            this.currentNodes = (StringBuffer)this.nodes.pop();
            this.currentAttribs = (StringBuffer)this.attribs.pop();
            this.currentNodes.insert(0, ">");
            this.currentNodes.insert(0, this.currentAttribs.toString());
            this.currentNodes.insert(0, "field");
            this.currentNodes.insert(0, "<");
            this.currentNodes.append("</field>\n");
            StringBuffer stringBuffer = null;
            if (!this.nodes.isEmpty()) {
                stringBuffer = (StringBuffer)this.nodes.pop();
            }
            if (stringBuffer == null) {
                this.pw.println(this.currentNodes.toString());
            } else {
                stringBuffer.append(this.currentNodes.toString());
                this.nodes.push(stringBuffer);
            }
        }
        this.fieldDeclCnt.push(this.nlevel);
        int n6 = this.fieldCnt.pop();
        if (n6 > 0 && !this.lastIS && !this.inFieldType.isEmpty()) {
            n4 = this.inFieldType.pop();
            if (n4 != 2) {
                n3 = this.nodeCnt.pop();
                this.currentField.pop();
                if (n4 == 0) {
                    this.indent();
                    --this.ilevel;
                }
            } else if (!this.gotFieldValue && !this.lastIS) {
                this.nodeCnt.pop();
                this.currentField.pop();
            }
        }
        this.fieldCnt.push(++n6);
        this.indent();
        this.currentNodes = new StringBuffer();
        this.currentAttribs = new StringBuffer();
        this.nodes.push(this.currentNodes);
        this.attribs.push(this.currentAttribs);
        this.currentAttribs.append(" name=\"");
        this.currentAttribs.append(string2);
        this.currentAttribs.append("\"");
        this.currentAttribs.append(" accessType=");
        switch (n) {
            case 2: {
                this.currentAttribs.append("\"initializeOnly\"");
                break;
            }
            case 3: {
                this.currentAttribs.append("\"inputOutput\"");
                break;
            }
            case 1: {
                this.currentAttribs.append("\"inputOnly\"");
                break;
            }
            case 4: {
                this.currentAttribs.append("\"outputOnly\"");
                break;
            }
            default: {
                System.out.println("Unknown field type in X3DXMLExporter: " + n);
            }
        }
        this.currentAttribs.append(" type=\"");
        this.currentAttribs.append(string);
        this.currentAttribs.append("\"");
        n4 = string.equals("MFNode") ? 0 : (string.equals("SFNode") ? 1 : 2);
        this.inFieldType.push(n4);
        if (n4 != 2) {
            this.nodeCnt.push(0);
            this.currentField.push(new Integer(n2));
            ++n5;
        }
        if (object instanceof String) {
            if (string.equals("SFString")) {
                this.currentAttribs.append(" value=");
                this.currentAttribs.append(object);
            } else {
                this.currentAttribs.append(" value=");
                this.currentAttribs.append("\"");
                this.currentAttribs.append(object);
                this.currentAttribs.append("\"");
            }
        } else if (object instanceof String[]) {
            this.currentAttribs.append(" value='");
            for (n3 = 0; n3 < ((String[])object).length; ++n3) {
                this.pw.print(((String[])object)[n3]);
            }
            this.currentAttribs.append("'");
        }
        this.pw.println();
        this.lastIS = false;
        this.gotFieldValue = true;
    }

    private boolean isMFField() {
        Object object = this.currentNode.peek();
        int n = (Integer)this.currentField.peek();
        VRMLFieldDeclaration vRMLFieldDeclaration = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldDeclaration(n) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldDeclaration(n) : ((ExternalPrototypeDecl)object).getFieldDeclaration(n));
        if (vRMLFieldDeclaration == null) {
            System.out.println("No decl for: " + object + " idx: " + n);
        }
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 4: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    private boolean isSFField() {
        Object object = this.currentNode.peek();
        int n = (Integer)this.currentField.peek();
        VRMLFieldDeclaration vRMLFieldDeclaration = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldDeclaration(n) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldDeclaration(n) : ((ExternalPrototypeDecl)object).getFieldDeclaration(n));
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 3: 
            case 5: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    private boolean isField(int n) {
        Object object = this.currentNode.peek();
        int n2 = (Integer)this.currentField.peek();
        VRMLFieldDeclaration vRMLFieldDeclaration = object instanceof VRMLNodeType ? ((VRMLNodeType)object).getFieldDeclaration(n2) : (object instanceof PrototypeDecl ? ((PrototypeDecl)object).getFieldDeclaration(n2) : ((ExternalPrototypeDecl)object).getFieldDeclaration(n2));
        return n == vRMLFieldDeclaration.getFieldType();
    }

    private String getPublicId(int n, int n2) {
        switch (n2) {
            case 0: {
                return "ISO//Web3D//DTD X3D 3.0//EN";
            }
            case 1: {
                return "ISO//Web3D//DTD X3D 3.1//EN";
            }
            case 2: {
                return "ISO//Web3D//DTD X3D 3.2//EN";
            }
        }
        throw new UnsupportedSpecVersionException("Unhandled minor version: " + n2);
    }

    private String getSystemId(int n, int n2) {
        switch (n2) {
            case 0: {
                return "http://www.web3d.org/specifications/x3d-3.0.dtd";
            }
            case 1: {
                return "http://www.web3d.org/specifications/x3d-3.1.dtd";
            }
            case 2: {
                return "http://www.web3d.org/specifications/x3d-3.2.dtd";
            }
        }
        throw new UnsupportedSpecVersionException("Unhandled minor version: " + n2);
    }

    protected void loadContainerProperties(final String string) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string2 = "config/" + string + "/" + X3DXMLExporter.CONTAINER_PROPS_FILE;
                try {
                    ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                    InputStream inputStream = ClassLoader.getSystemResourceAsStream(string2);
                    if (inputStream == null) {
                        inputStream = X3DXMLExporter.class.getClassLoader().getResourceAsStream(string2);
                    }
                    if (inputStream != null) {
                        X3DXMLExporter.this.containerFields.load(inputStream);
                    } else {
                        System.out.println("Couldn't find container properties file: " + string2);
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Error reading container properties file");
                }
                return null;
            }
        });
    }
}

