/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.uri;

import java.io.IOException;
import java.io.Serializable;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.RDSManager;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.ResourceManager;
import org.ietf.uri.URC;
import org.ietf.uri.URIConstants;
import org.ietf.uri.URIResolverServiceFactory;
import org.ietf.uri.URIResourceStreamFactory;
import org.ietf.uri.URIUtils;
import org.ietf.uri.URL;
import org.ietf.uri.URN;
import org.ietf.uri.UnsupportedServiceException;

public abstract class URI
implements URIConstants,
Serializable {
    public abstract String toExternalForm();

    public abstract ResourceConnection getResource() throws UnsupportedServiceException, IOException;

    public abstract ResourceConnection[] getResourceList() throws UnsupportedServiceException, IOException;

    public abstract URL getURL() throws UnsupportedServiceException, IOException;

    public abstract URL[] getURLList() throws UnsupportedServiceException, IOException;

    public abstract URC getURC() throws UnsupportedServiceException, IOException;

    public abstract URC[] getURCList() throws UnsupportedServiceException, IOException;

    public abstract URN getURN() throws UnsupportedServiceException, IOException;

    public abstract URN[] getURNList() throws UnsupportedServiceException, IOException;

    public static void setURIResolverServiceFactory(URIResolverServiceFactory uRIResolverServiceFactory) {
        RDSManager.setURIResolverServiceFactory(uRIResolverServiceFactory);
    }

    public static URIResolverServiceFactory getURIResolverServiceFactory() {
        return RDSManager.getURIResolverServiceFactory();
    }

    public static void setURIResourceStreamFactory(URIResourceStreamFactory uRIResourceStreamFactory) {
        ResourceManager.setProtocolHandlerFactory(uRIResourceStreamFactory);
    }

    public static URIResourceStreamFactory getURIResourceStreamFactory() {
        return ResourceManager.getProtocolHandlerFactory();
    }

    public static void setContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) {
        ResourceManager.setContentHandlerFactory(contentHandlerFactory);
    }

    public static ContentHandlerFactory getContentHandlerFactory() {
        return ResourceManager.getContentHandlerFactory();
    }

    public static void setFileNameMap(FileNameMap fileNameMap) {
        ResourceManager.setFileNameMap(fileNameMap);
    }

    public static FileNameMap getFileNameMap() {
        return ResourceManager.getFileNameMap();
    }

    public static String getScheme(String string) {
        int n;
        String string2 = null;
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        for (n = 0; n < n2 && cArray[n] != ':' && cArray[n] != '/' && cArray[n] != '?' && cArray[n] != '#'; ++n) {
        }
        if (n > 0 && n < n2 && cArray[n] == ':') {
            string2 = new String(cArray, 0, n).toLowerCase();
        }
        return string2;
    }

    public static int getDefaultPort(String string) {
        return URIUtils.getDefaultPort(string);
    }
}

