Description: Use Pd64-safe types
Author: IOhannes m zmölnig
Origin: Debian
Bug: https://github.com/ericlyon/pd-lyonpotpourri/issues/26
Last-Update: 2024-06-18
---
This patch header follows DEP-3: http://dep.debian.net/deps/dep3/
--- pd-lyonpotpourri.orig/adsr~.c
+++ pd-lyonpotpourri/adsr~.c
@@ -7,12 +7,12 @@
 typedef struct _adsr
 {
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   // Variables Here
-  float a;
-  float d;
-  float s;
-  float r;
+  t_float a;
+  t_float d;
+  t_float s;
+  t_float r;
   int ebreak1;
   int ebreak2;
   int ebreak3;
@@ -24,16 +24,16 @@
   int dsamps_last;
   int ssamps_last;
   int rsamps_last;
-  float tempo;
-  float egain1;
-  float egain2;
+  t_float tempo;
+  t_float egain1;
+  t_float egain2;
   int tempomode;
   int beat_subdiv;
   int tsamps;
   int counter;
-  float srate;
+  t_float srate;
   short manual_override;
-  float click_gain; // input click sets volume too
+  t_float click_gain; // input click sets volume too
   short mute;
 } t_adsr;
 
@@ -55,7 +55,7 @@
 // static void set_tempo(t_adsr *x, t_floatarg f);
 static void adsr_mute(t_adsr *x, t_floatarg f);
 
-//void atom_arg_getfloat(float *c, long idx, long ac, t_atom *av);
+//void atom_arg_getfloat(t_float *c, long idx, long ac, t_atom *av);
 //void atom_arg_getsym(t_symbol **c, long idx, long ac, t_atom *av);
 
 void adsr_tilde_setup(void) {
@@ -259,17 +259,17 @@
   int ebreak1 = x->ebreak1;
   int ebreak2 = x->ebreak2;
   int ebreak3 = x->ebreak3;
-  float egain1 = x->egain1;
-  float egain2 = x->egain2;
+  t_float egain1 = x->egain1;
+  t_float egain2 = x->egain2;
   int asamps = x->asamps;
   int dsamps = x->dsamps;
   int ssamps = x->ssamps;
   int rsamps = x->rsamps;
   //  short manual_override = x->manual_override;
-  float click_gain = x->click_gain;
-  float etmp;
-  float env_val;
-  float input_val;
+  t_float click_gain = x->click_gain;
+  t_float etmp;
+  t_float env_val;
+  t_float input_val;
   /*********************************************/
   if(x->mute) {
     while(n--) *out++ = 0.0;
@@ -284,15 +284,15 @@
 
 
     if( counter < ebreak1 ) {
-      env_val = (float) counter / (float) asamps;
+      env_val = (t_float) counter / (t_float) asamps;
     } else if (counter < ebreak2) {
-      etmp = (float) (counter - ebreak1) / (float) dsamps;
+      etmp = (t_float) (counter - ebreak1) / (t_float) dsamps;
       env_val = (1.0 - etmp) + (egain1 * etmp);
     } else if (counter < ebreak3) {
-      etmp = (float) (counter - ebreak2) / (float) ssamps;
+      etmp = (t_float) (counter - ebreak2) / (t_float) ssamps;
       env_val = (egain1 * (1.0 - etmp)) + (egain2 * etmp);
     } else if( counter < tsamps ) {
-      env_val = ((float)(tsamps-counter)/(float)rsamps) * egain2 ;
+      env_val = ((t_float)(tsamps-counter)/(t_float)rsamps) * egain2 ;
     } else {
       env_val = 0.0;
     }
--- pd-lyonpotpourri.orig/bashfest.h
+++ pd-lyonpotpourri/bashfest.h
@@ -38,7 +38,7 @@
 
 typedef struct
 {
-  float *data;//contains cycle data
+  t_float *data;//contains cycle data
   int len;//length of array
   int p;//position pointer
 } t_cycle;
@@ -47,13 +47,13 @@
 {
   long phase; // current phase in frames
   double phasef; // current phase in frames
-  float gain; // gain for this note
-  float gainL;// left gain
-  float gainR;// right gain
+  t_float gain; // gain for this note
+  t_float gainL;// left gain
+  t_float gainR;// right gain
   short status;// status of this event slot
-  float *workbuffer;//sample processing space (both input and output)
-  float *inbuf;//pointer to input part of workbuffer
-  float *outbuf;//pointer to output part of workbuffer
+  t_float *workbuffer;//sample processing space (both input and output)
+  t_float *inbuf;//pointer to input part of workbuffer
+  t_float *outbuf;//pointer to output part of workbuffer
   int in_start;// location in workbuffer to read from input
   int out_start;// location in workbuffer to write output
   int sample_frames;//actual size in frames of sample, which changes if it gets bigger
@@ -67,13 +67,13 @@
 typedef struct _bashfest
 {
   t_object x_obj;
-  float x_f;
-  float sr; // sampling rate
+  t_float x_f;
+  t_float sr; // sampling rate
   t_symbol *wavename; // name of waveform buffer
   short hosed; // buffers are bad
-  float fadeout; // fadeout time in sample frames (if truncation)
-  float sync; // input from groove sync signal
-  float increment; // read increment
+  t_float fadeout; // fadeout time in sample frames (if truncation)
+  t_float sync; // input from groove sync signal
+  t_float increment; // read increment
   int most_recent_event; // position in array where last note was initiated
   long b_nchans; // channels of buffer
   long b_valid; // state of buffer
@@ -86,47 +86,47 @@
   int halfbuffer;//buf_samps / 2
   int buf_frames;// number of sample frames in workbuffer
   int latency_samples;// amount of samples to count down before playing sample
-  float *params; // parameter list
-  float *odds;// odds for each process happening
+  t_float *params; // parameter list
+  t_float *odds;// odds for each process happening
   int max_process_per_note;//what it says
   int min_process_per_note;//ditto
   int new_slot;//position for newest note
-  float new_gain;//recently assigned gain
+  t_float new_gain;//recently assigned gain
   short verbose;//toggle Max window error reporting
-  float work_buffer_size;// size in ms of work buffers
+  t_float work_buffer_size;// size in ms of work buffers
   t_cycle tcycle;//contains an optional transposition cycle
   short block_dsp;//flag to turn off all dsp and play straight from MSP buffer
   short sound_lock;//keep current processed sound in buffer
   short grab;//flag to copy immediate processed buffer into MSP buffer
   char sound_name[256];
-  float *trigger_vec;//stores incoming trigger vectors
+  t_float *trigger_vec;//stores incoming trigger vectors
   int vs;//Max/MSP vector size
 
   /* stuff for bashfest DSP */
-  float *sinewave;
+  t_float *sinewave;
   int sinelen;
   short mute;
-  float maxdelay;
-  float *delayline1;
-  float *delayline2;
+  t_float maxdelay;
+  t_float *delayline1;
+  t_float *delayline2;
   LSTRUCT *eel; // for ellipse processor
-  float *mini_delay[4]; // small delay lines for allpass filter
-  float max_mini_delay ;
-  float *transfer_function;
+  t_float *mini_delay[4]; // small delay lines for allpass filter
+  t_float max_mini_delay ;
+  t_float *transfer_function;
   int tf_len; // length of transfer function
-  float *feedfunc1;
-  float *feedfunc2;
-  float *feedfunc3;
-  float *feedfunc4;
+  t_float *feedfunc1;
+  t_float *feedfunc2;
+  t_float *feedfunc3;
+  t_float *feedfunc4;
   int feedfunclen;
   int flamfunc1len;
-  float *flamfunc1;
+  t_float *flamfunc1;
   CMIXCOMB *combies;
   CMIXADSR *adsr;
-  float max_comb_lpt;
-  float *reverb_ellipse_data;
-  float **ellipse_data;
-  float *dcflt;
+  t_float max_comb_lpt;
+  t_float *reverb_ellipse_data;
+  t_float **ellipse_data;
+  t_float *dcflt;
   CMIXOSC oscar;
   CMIXRESON resies[2];
 
@@ -135,51 +135,51 @@
 
 
 /*function prototypes*/
-void lpp_putsine (float *arr, int len);
-float lpp_boundrand(float min, float max);
-void lpp_mycombset(float loopt,float rvt,int init,float *a,float srate);
-float lpp_mycomb(float samp,float *a);
-void lpp_setweights(float *a, int len);
-void lpp_delset2(float *a,int *l,float xmax, float srate);
-void lpp_delput2(float x,float *a,int *l);
-float lpp_dliget2(float *a,float dwait,int *l,float srate);
-void lpp_butterLopass( float *in, float *out, float cutoff, int frames, int channels, float srate);
-void lpp_butterBandpass(float *in, float *out,  float center, float bandwidth, int frames,int  channels, float srate);
-void lpp_butterHipass(float *in, float *out,  float cutoff, int frames,int channels, float srate);
-void lpp_butset(float *a);
-void lpp_lobut(float *a, float cutoff,float SR);
-void lpp_hibut(float *a, float cutoff, float SR);
-void lpp_bpbut(float *a, float formant, float bandwidth, float SR);
-void lpp_butter_filter(float *in,float *out,float *a, int frames, int channels, int channel);
-void lpp_rsnset2(float cf,float bw,float scl,float xinit,float *a,float srate);
-float lpp_reson(float x,float *a);
-
-void lpp_ellipset(float *list, LSTRUCT *eel, int  *nsects, float *xnorm);
-float lpp_ellipse(float x, LSTRUCT *eel, int nsects, float xnorm);
-float lpp_allpass(float samp,float *a);
-void lpp_init_reverb_data(float *a);
-void lpp_init_ellipse_data(float **a);
-
-void lpp_setExpFlamFunc(float *arr, int flen, float v1,float v2,float alpha);
-void lpp_setflamfunc1(float *arr, int flen);
-void lpp_funcgen1(float *outArray, int outlen, float duration, float outMin, float outMax,
-              float speed1, float speed2, float gain1, float gain2, float *phs1, float *phs2,
-              float *sine, int sinelen);
-void lpp_normtab(float *inarr,float *outarr, float min, float max, int len);
-float lpp_mapp(float in,float imin,float imax,float omin,float omax);
-float lpp_oscil(float amp,float si,float *farray,int len,float *phs);
-void lpp_set_dcflt(float *a);
-
-void lpp_set_distortion_table(float *arr, float cut, float max, int len);
-float lpp_dlookup(float samp,float *arr,int len);
-void lpp_do_compdist(float *in,float *out,int sampFrames,int nchans,int channel,
-                 float cutoff,float maxmult,int lookupflag,float *table,int range,float bufMaxamp);
-float lpp_getmaxamp(float *arr, int len);
+void lpp_putsine (t_float *arr, int len);
+t_float lpp_boundrand(t_float min, t_float max);
+void lpp_mycombset(t_float loopt,t_float rvt,int init,t_float *a,t_float srate);
+t_float lpp_mycomb(t_float samp,t_float *a);
+void lpp_setweights(t_float *a, int len);
+void lpp_delset2(t_float *a,int *l,t_float xmax, t_float srate);
+void lpp_delput2(t_float x,t_float *a,int *l);
+t_float lpp_dliget2(t_float *a,t_float dwait,int *l,t_float srate);
+void lpp_butterLopass( t_float *in, t_float *out, t_float cutoff, int frames, int channels, t_float srate);
+void lpp_butterBandpass(t_float *in, t_float *out,  t_float center, t_float bandwidth, int frames,int  channels, t_float srate);
+void lpp_butterHipass(t_float *in, t_float *out,  t_float cutoff, int frames,int channels, t_float srate);
+void lpp_butset(t_float *a);
+void lpp_lobut(t_float *a, t_float cutoff,t_float SR);
+void lpp_hibut(t_float *a, t_float cutoff, t_float SR);
+void lpp_bpbut(t_float *a, t_float formant, t_float bandwidth, t_float SR);
+void lpp_butter_filter(t_float *in,t_float *out,t_float *a, int frames, int channels, int channel);
+void lpp_rsnset2(t_float cf,t_float bw,t_float scl,t_float xinit,t_float *a,t_float srate);
+t_float lpp_reson(t_float x,t_float *a);
+
+void lpp_ellipset(t_float *list, LSTRUCT *eel, int  *nsects, t_float *xnorm);
+t_float lpp_ellipse(t_float x, LSTRUCT *eel, int nsects, t_float xnorm);
+t_float lpp_allpass(t_float samp,t_float *a);
+void lpp_init_reverb_data(t_float *a);
+void lpp_init_ellipse_data(t_float **a);
+
+void lpp_setExpFlamFunc(t_float *arr, int flen, t_float v1,t_float v2,t_float alpha);
+void lpp_setflamfunc1(t_float *arr, int flen);
+void lpp_funcgen1(t_float *outArray, int outlen, t_float duration, t_float outMin, t_float outMax,
+              t_float speed1, t_float speed2, t_float gain1, t_float gain2, t_float *phs1, t_float *phs2,
+              t_float *sine, int sinelen);
+void lpp_normtab(t_float *inarr,t_float *outarr, t_float min, t_float max, int len);
+t_float lpp_mapp(t_float in,t_float imin,t_float imax,t_float omin,t_float omax);
+t_float lpp_oscil(t_float amp,t_float si,t_float *farray,int len,t_float *phs);
+void lpp_set_dcflt(t_float *a);
+
+void lpp_set_distortion_table(t_float *arr, t_float cut, t_float max, int len);
+t_float lpp_dlookup(t_float samp,t_float *arr,int len);
+void lpp_do_compdist(t_float *in,t_float *out,int sampFrames,int nchans,int channel,
+                 t_float cutoff,t_float maxmult,int lookupflag,t_float *table,int range,t_float bufMaxamp);
+t_float lpp_getmaxamp(t_float *arr, int len);
 void lpp_buildadsr(CMIXADSR *a);
 /*bashfest dsp functions */
-void lpp_feed1(float *inbuf, float *outbuf, int in_frames, int out_frames,int channels, float *functab1,
-           float *functab2,float *functab3,float *functab4,int funclen,
-           float duration, float maxDelay, t_bashfest *x);
-void lpp_reverb1me(float *in, float *out, int inFrames, int out_frames, int nchans,
-               int channel, float revtime, float dry, t_bashfest *x);
-void lpp_killdc( float *inbuf, int in_frames, int channels, t_bashfest *x);
+void lpp_feed1(t_float *inbuf, t_float *outbuf, int in_frames, int out_frames,int channels, t_float *functab1,
+           t_float *functab2,t_float *functab3,t_float *functab4,int funclen,
+           t_float duration, t_float maxDelay, t_bashfest *x);
+void lpp_reverb1me(t_float *in, t_float *out, int inFrames, int out_frames, int nchans,
+               int channel, t_float revtime, t_float dry, t_bashfest *x);
+void lpp_killdc( t_float *inbuf, int in_frames, int channels, t_bashfest *x);
--- pd-lyonpotpourri.orig/buffet~.c
+++ pd-lyonpotpourri/buffet~.c
@@ -27,34 +27,34 @@
 typedef struct _buffet
 {
     t_object x_obj;
-    float x_f;
+    t_float x_f;
     t_symbol *wavename; // name of waveform buffer
     t_guffer *wavebuf; // holds waveform samples
     t_guffer *destbuf; // for copying to another buffer
     
-    float sr; // sampling rate
+    t_float sr; // sampling rate
     short hosed; // buffers are bad
-    float minframes; // minimum replacement block in sample frames
-    float maxframes; // maximum replacement block in sample frames
+    t_float minframes; // minimum replacement block in sample frames
+    t_float maxframes; // maximum replacement block in sample frames
     long storage_maxframes; // maxframe limit that current memory can handle
-    float *storage; //temporary memory to store replacement block (set to maxframes * channels)
+    t_float *storage; //temporary memory to store replacement block (set to maxframes * channels)
     long storage_bytes; // amount of currently allocated memory
-    float fade; // fadein/fadeout time in sample frames
-    float sync; // input from groove sync signal
+    t_float fade; // fadein/fadeout time in sample frames
+    t_float sync; // input from groove sync signal
     long swapframes; // number of frames in swap block
     long r1startframe; //start frame for block 1
     long r2startframe; // start frame for block 2
-    float dc_coef; // filter coefficient
-    float dc_gain; // normalization factor
+    t_float dc_coef; // filter coefficient
+    t_float dc_gain; // normalization factor
     short initialized; // first time or not
-    float *rmsbuf;// for onset analysis
-    float rmschunk; // store lowest rms value in buffer
+    t_float *rmsbuf;// for onset analysis
+    t_float rmschunk; // store lowest rms value in buffer
     void *list; // for start/end list
     void *bang; // completion bang
     void *floater; // outputs noise floor
     t_atom *listdata;// to report est. start/stop times of events in buffer
-    float *analbuf; // contain overall envelope
-    float *onset; // contain attack times for percussive evaluations
+    t_float *analbuf; // contain overall envelope
+    t_float *onset; // contain attack times for percussive evaluations
     short autoredraw; // to kill redraw if it impacts performance
 } t_buffet;
 
@@ -62,7 +62,7 @@
 static void *buffet_new(t_symbol *msg, int argc, t_atom *argv);
 static t_int *buffet_perform(t_int *w);
 static void buffet_dsp(t_buffet *x, t_signal **sp);
-static float buffet_boundrand(float min, float max);
+static t_float buffet_boundrand(t_float min, t_float max);
 static void buffet_assist (t_buffet *x, void *b, long msg, long arg, char *dst);
 static void buffet_dsp_free(t_buffet *x);
 static void buffet_swap(t_buffet *x);
@@ -175,22 +175,22 @@
     int b_frames;
     t_atom *listdata = x->listdata;
     
-    float bufsize;
-    float onthresh;
-    float offthresh;
+    t_float bufsize;
+    t_float onthresh;
+    t_float offthresh;
     long bufsamps;
     long aframes; // frames to analyze
-    float tadv;
+    t_float tadv;
     
     long i,j;
-    float meansq;
-    float rmsval;
+    t_float meansq;
+    t_float rmsval;
     long bindex;
-    float ipos;
+    t_float ipos;
     short activated = 0;
-    float realtime = 0.0;
+    t_float realtime = 0.0;
     int event_count = 0;
-    float buffer_duration;
+    t_float buffer_duration;
     
     buffet_setbuf(x, x->wavename);
     b_samples = x->wavebuf->b_samples;
@@ -198,7 +198,7 @@
     b_frames = x->wavebuf->b_frames;
     
     // duration in ms.
-    buffer_duration = 1000.0 * (float)b_frames / x->sr;
+    buffer_duration = 1000.0 * (t_float)b_frames / x->sr;
     
     bufsize = .001 * atom_getfloatarg(0,argc,argv);
     if(bufsize > MAX_RMS_BUFFER) {
@@ -214,9 +214,9 @@
     bufsamps = x->sr * bufsize;
     
     bufsamps = bufsize * x->sr;
-    tadv = (float)bufsamps / x->sr;
+    tadv = (t_float)bufsamps / x->sr;
     //  post("actual window size: %f",tadv);
-    aframes = (long) ( (float) b_frames / (float)bufsamps ) - 1;
+    aframes = (long) ( (t_float) b_frames / (t_float)bufsamps ) - 1;
     if(aframes < 2) {
         pd_error(0, "%s: this buffer is too short to analyze",OBJECT_NAME);
         return;
@@ -230,7 +230,7 @@
             bindex = ipos + j;
             meansq += b_samples[bindex].w_float * b_samples[bindex].w_float;
         }
-        meansq /= (float) bufsamps;
+        meansq /= (t_float) bufsamps;
         rmsval = sqrt(meansq);
         realtime += tadv;
         if(rmsval > onthresh && ! activated) {
@@ -268,27 +268,27 @@
     int b_frames;
     t_atom *listdata = x->listdata;
     
-    float bufsize;
-    //float onthresh;
-    //float offthresh;
-    float diffthresh;
+    t_float bufsize;
+    //t_float onthresh;
+    //t_float offthresh;
+    t_float diffthresh;
     long bufsamps;
     long aframes; // frames to analyze
-    float tadv;
+    t_float tadv;
     //long current_frame = 0;
     long i,j;
-    float meansq;
-    float rmsval;
+    t_float meansq;
+    t_float rmsval;
     long bindex;
-    float ipos;
+    t_float ipos;
     //short activated = 0;
-    float realtime = 0.0;
+    t_float realtime = 0.0;
     int event_count = 0;
-//    float buffer_duration;
-    float mindiff, maxdiff, absdiff,rmsdiff;
-    float *analbuf = x->analbuf;
-    float *onset = x->onset;
-    //float endtime;
+//    t_float buffer_duration;
+    t_float mindiff, maxdiff, absdiff,rmsdiff;
+    t_float *analbuf = x->analbuf;
+    t_float *onset = x->onset;
+    //t_float endtime;
     
     buffet_setbuf(x, x->wavename);
     b_samples = x->wavebuf->b_samples;
@@ -296,7 +296,7 @@
     b_frames = x->wavebuf->b_frames;
     
     // duration in ms.
-//    buffer_duration = 1000.0 * (float)b_frames / x->sr;
+//    buffer_duration = 1000.0 * (t_float)b_frames / x->sr;
     
     bufsize = .001 * atom_getfloatarg(0,argc,argv);
     if(bufsize > MAX_RMS_BUFFER) {
@@ -311,9 +311,9 @@
     bufsamps = x->sr * bufsize;
     
     bufsamps = bufsize * x->sr;
-    tadv = (float)bufsamps / x->sr;
+    tadv = (t_float)bufsamps / x->sr;
     
-    aframes = (long) ( (float) b_frames / (float)bufsamps );
+    aframes = (long) ( (t_float) b_frames / (t_float)bufsamps );
     if(aframes < 2) {
         pd_error(0, "%s: this buffer is too short to analyze",OBJECT_NAME);
         return;
@@ -331,7 +331,7 @@
             bindex = ipos + j;
             meansq += b_samples[bindex].w_float * b_samples[bindex].w_float;
         }
-        meansq /= (float) bufsamps;
+        meansq /= (t_float) bufsamps;
         analbuf[i] = rmsval = sqrt(meansq);
         realtime += tadv;
         
@@ -382,7 +382,7 @@
     long fadeframes;
     long totalframes;
     int i,j,k;
-    float env;
+    t_float env;
     t_word *b_samples;
     long b_nchans;
     long startframe;
@@ -416,7 +416,7 @@
     fadeframes = endframe - startframe;
     
     for(i = (endframe-1) * b_nchans , k = 0; k < fadeframes ; i -= b_nchans, k++ ) {
-        env = (float) k / (float) fadeframes;
+        env = (t_float) k / (t_float) fadeframes;
         for(j = 0; j < b_nchans; j++) {
             b_samples[i + j].w_float *= env;
         }
@@ -429,7 +429,7 @@
     long fadeframes;
     long totalframes;
     int i,j,k;
-    float env;
+    t_float env;
     t_word *b_samples;
     long b_nchans;
     long startframe;
@@ -463,7 +463,7 @@
     fadeframes = endframe - startframe;
     
     for(i = startframe * b_nchans , k = 0; k < fadeframes ; i += b_nchans, k++ ) {
-        env = (float) k / (float) fadeframes;
+        env = (t_float) k / (t_float) fadeframes;
         for(j = 0; j < b_nchans; j++) {
             b_samples[i + j].w_float *= env;
         }
@@ -475,11 +475,11 @@
 {
     
     int i,j;
-    //  float env;
+    //  t_float env;
     t_word *b_samples;
     long b_nchans;
     long b_frames;
-    float tmpsamp;
+    t_float tmpsamp;
     long lenm1;
     
     buffet_setbuf(x, x->wavename);
@@ -549,10 +549,10 @@
     long endframe;
     long chunkframes;
     
-    float fadein,fadeout;
+    t_float fadein,fadeout;
     int fadeframes;
     // totalframes;
-    float env;
+    t_float env;
     int i,j,k;
     
     buffet_setbuf(x, x->wavename);
@@ -593,7 +593,7 @@
     for(i = 0; i < b_dest_frames; i++) {
         b_dest_samples[i].w_float = 0.0;
     }
-    // memset((char *)b_dest_samples, 0, b_dest_frames * b_dest_nchans * sizeof(float));
+    // memset((char *)b_dest_samples, 0, b_dest_frames * b_dest_nchans * sizeof(t_float));
     
     /* now copy segment */
     for(i = 0; i < chunkframes; i++) {
@@ -601,7 +601,7 @@
     }
     
     /* memcpy(b_dest_samples, b_samples + (startframe * b_nchans),
-     chunkframes * b_nchans * sizeof(float) ); */
+     chunkframes * b_nchans * sizeof(t_float) ); */
     
     if(argc == 5) {
         //    post("enveloping");
@@ -618,7 +618,7 @@
             
             
             for(i = 0 , k = 0; k < fadeframes ; i += b_dest_nchans, k++ ) {
-                env = (float) k / (float) fadeframes;
+                env = (t_float) k / (t_float) fadeframes;
                 for(j = 0; j < b_dest_nchans; j++) {
                     b_dest_samples[i + j].w_float *= env;
                 }
@@ -642,7 +642,7 @@
             //    fadeframes = endframe - startframe; // we already know this
             
             for(i = (chunkframes-1) * b_dest_nchans , k = 0; k < fadeframes ; i -= b_dest_nchans, k++ ) {
-                env = (float) k / (float) fadeframes;
+                env = (t_float) k / (t_float) fadeframes;
                 for(j = 0; j < b_dest_nchans; j++) {
                     b_dest_samples[i + j].w_float *= env;
                 }
@@ -687,11 +687,11 @@
     
     long bufsamps;
     long i;
-    float meansq;
-    float rmsval;
+    t_float meansq;
+    t_float rmsval;
     long bindex;
     
-//    float buffer_duration;
+//    t_float buffer_duration;
     long startframe;
     long endframe;
     
@@ -701,7 +701,7 @@
     b_frames = x->wavebuf->b_frames;
     
     // duration in ms.
-//    buffer_duration = 1000.0 * (float)b_frames / x->sr;
+//    buffer_duration = 1000.0 * (t_float)b_frames / x->sr;
     
     
     startframe = .001 * x->sr * atom_getfloatarg(0,argc,argv);
@@ -731,7 +731,7 @@
         
     }
     
-    meansq /= (float) bufsamps;
+    meansq /= (t_float) bufsamps;
     rmsval = sqrt(meansq);
     
     x->rmschunk = rmsval;
@@ -779,10 +779,10 @@
         oldmem = x->storage_bytes;
         //  post("old memory %d", oldmem);
         x->storage_maxframes = newframes;
-        x->storage_bytes = (x->storage_maxframes + 1) * 2 * sizeof(float);
+        x->storage_bytes = (x->storage_maxframes + 1) * 2 * sizeof(t_float);
         //  post("new memory %d", x->storage_bytes);
         
-        x->storage = (float *) resizebytes((char *)x->storage, oldmem, x->storage_bytes);
+        x->storage = (t_float *) resizebytes((char *)x->storage, oldmem, x->storage_bytes);
     }
     x->maxframes = newframes;
 }
@@ -837,13 +837,13 @@
 void buffet_rotatetozero(t_buffet *x, t_floatarg f)
 {
     int i;
-    float target = (float) f;
+    t_float target = (t_float) f;
     long shiftframes = (long) (target * 0.001 * x->sr);
     
     t_word *b_samples;
     long b_nchans;
     long b_frames;
-    float *tmpmem;
+    t_float *tmpmem;
     
     
     
@@ -861,7 +861,7 @@
         return;
     }
     
-    tmpmem = (float *) getbytes(shiftframes * b_nchans * sizeof(float));
+    tmpmem = (t_float *) getbytes(shiftframes * b_nchans * sizeof(t_float));
     
     /* copy shift block to tmp */
     for(i = 0; i < shiftframes; i++) {
@@ -879,21 +879,21 @@
         b_samples[(b_frames - shiftframes)+i].w_float = tmpmem[i];
     }
 
-    freebytes(tmpmem, shiftframes * b_nchans * sizeof(float));
+    freebytes(tmpmem, shiftframes * b_nchans * sizeof(t_float));
     buffet_update(x);
 }
 
 void buffet_normalize(t_buffet *x, t_floatarg f)
 {
     
-    float target = (float) f;
+    t_float target = (t_float) f;
     t_word *b_samples;
     long b_nchans;
     long b_frames;
     long i;
-    float maxamp = 0.0;
-    float amptest;
-    float rescale;
+    t_float maxamp = 0.0;
+    t_float amptest;
+    t_float rescale;
     
     if(target <= 0.0) {
         pd_error(0, "%s: normalize target %f is too low",OBJECT_NAME,target);
@@ -934,7 +934,7 @@
     long fadeframes;
     long totalframes;
     int i,j,k;
-    float env;
+    t_float env;
     t_word *b_samples;
     long b_nchans;
     
@@ -960,7 +960,7 @@
         return;
     }
     for(i = 0, k = 0;i < fadeframes * b_nchans; i += b_nchans, k++ ) {
-        env = (float) k / (float) fadeframes;
+        env = (t_float) k / (t_float) fadeframes;
         for(j = 0; j < b_nchans; j++) {
             b_samples[i + j].w_float *= env;
         }
@@ -973,7 +973,7 @@
     long fadeframes;
     long totalframes;
     int i,j,k;
-    float env;
+    t_float env;
     t_word *b_samples;
     long b_nchans;
     
@@ -998,7 +998,7 @@
         return;
     }
     for(i = (totalframes-1) * b_nchans , k = 0; k < fadeframes ; i -= b_nchans, k++ ) {
-        env = (float) k / (float) fadeframes;
+        env = (t_float) k / (t_float) fadeframes;
         for(j = 0; j < b_nchans; j++) {
             b_samples[i + j].w_float *= env;
         }
@@ -1015,11 +1015,11 @@
     int i,j;
     t_word *b_samples;
     long b_nchans;
-    float dc_coef = x->dc_coef;
-    float a0[MAX_CHANNELS];
-    float a1[MAX_CHANNELS];
-    float b0[MAX_CHANNELS];
-    float b1[MAX_CHANNELS];
+    t_float dc_coef = x->dc_coef;
+    t_float a0[MAX_CHANNELS];
+    t_float a1[MAX_CHANNELS];
+    t_float b0[MAX_CHANNELS];
+    t_float b1[MAX_CHANNELS];
     
     buffet_setbuf(x, x->wavename);
     if(x->hosed) {
@@ -1090,27 +1090,27 @@
         x->minframes *= .001 * x->sr;
         x->storage_maxframes = x->maxframes *= .001 * x->sr;
         x->fade = .001 * 20 * x->sr; // 20 ms fadetime to start
-        x->storage_bytes = (x->maxframes + 1) * 2 * sizeof(float); // stereo storage frames
-        x->storage = (float *) getbytes(x->storage_bytes);
+        x->storage_bytes = (x->maxframes + 1) * 2 * sizeof(t_float); // stereo storage frames
+        x->storage = (t_float *) getbytes(x->storage_bytes);
         x->dc_coef = .995; // for dc blocker
         x->dc_gain = 4.0;
         x->autoredraw = 1;
-        x->rmsbuf = (float *) getbytes(MAX_RMS_BUFFER * x->sr * sizeof(float));
-        memset((char *)x->rmsbuf, 0, MAX_RMS_BUFFER * x->sr * sizeof(float));
+        x->rmsbuf = (t_float *) getbytes(MAX_RMS_BUFFER * x->sr * sizeof(t_float));
+        memset((char *)x->rmsbuf, 0, MAX_RMS_BUFFER * x->sr * sizeof(t_float));
         x->listdata = (t_atom *)getbytes(MAX_EVENTS * sizeof(t_atom));// lots of events
-        x->analbuf = (float *) getbytes(MAX_RMS_FRAMES * sizeof(float));
-        memset((char *)x->analbuf, 0, MAX_RMS_FRAMES * sizeof(float));
-        x->onset = (float *) getbytes(MAX_EVENTS * sizeof(float));
+        x->analbuf = (t_float *) getbytes(MAX_RMS_FRAMES * sizeof(t_float));
+        memset((char *)x->analbuf, 0, MAX_RMS_FRAMES * sizeof(t_float));
+        x->onset = (t_float *) getbytes(MAX_EVENTS * sizeof(t_float));
         x->wavebuf = (t_guffer *) getbytes(1 * sizeof(t_guffer));
         x->destbuf = (t_guffer *) getbytes(1 * sizeof(t_guffer));
     } else {
         x->minframes *= .001 * x->sr;
         x->storage_maxframes = x->maxframes *= .001 * x->sr;
         x->fade = .001 * 20 * x->sr; // 20 ms fadetime to start
-        x->storage_bytes = (x->maxframes + 1) * 2 * sizeof(float); // stereo storage frames
-        x->storage = (float *) resizebytes((char *)x->storage_bytes,0,x->storage_bytes);
-        x->rmsbuf = (float *)resizebytes((char *)x->rmsbuf,0,MAX_RMS_BUFFER * x->sr * sizeof(float));
-        memset((char *)x->rmsbuf, 0, MAX_RMS_BUFFER * x->sr * sizeof(float));
+        x->storage_bytes = (x->maxframes + 1) * 2 * sizeof(t_float); // stereo storage frames
+        x->storage = (t_float *) resizebytes((char *)x->storage_bytes,0,x->storage_bytes);
+        x->rmsbuf = (t_float *)resizebytes((char *)x->rmsbuf,0,MAX_RMS_BUFFER * x->sr * sizeof(t_float));
+        memset((char *)x->rmsbuf, 0, MAX_RMS_BUFFER * x->sr * sizeof(t_float));
     }
 }
 
@@ -1119,8 +1119,8 @@
 {
     long totalframes = x->wavebuf->b_frames;
     
-    float minframes = x->minframes;
-    float maxframes = x->maxframes;
+    t_float minframes = x->minframes;
+    t_float maxframes = x->maxframes;
     long swapframes = x->swapframes;
     long r1startframe = x->r1startframe;
     long r2startframe = x->r2startframe;
@@ -1131,19 +1131,19 @@
     
     
     swapframes = buffet_boundrand(minframes, maxframes);
-    r1startframe = buffet_boundrand(0.0, (float)(totalframes-swapframes));
+    r1startframe = buffet_boundrand(0.0, (t_float)(totalframes-swapframes));
     r1endframe = r1startframe + swapframes;
     region1 = r1startframe;
     region2 = totalframes - r1endframe;
     if(swapframes > region1) {
-        r2startframe = buffet_boundrand((float)r1endframe,(float)(totalframes-swapframes));
+        r2startframe = buffet_boundrand((t_float)r1endframe,(t_float)(totalframes-swapframes));
     } else if(swapframes > region2) {
-        r2startframe = buffet_boundrand(0.0,(float)(r1startframe-swapframes));
+        r2startframe = buffet_boundrand(0.0,(t_float)(r1startframe-swapframes));
     } else { // either region ok
         if(buffet_boundrand(0.0,1.0) > 0.5) {
-            r2startframe = buffet_boundrand(0.0,(float)(r1startframe-swapframes));
+            r2startframe = buffet_boundrand(0.0,(t_float)(r1startframe-swapframes));
         } else {
-            r2startframe = buffet_boundrand((float)r1endframe,(float)(totalframes-swapframes));
+            r2startframe = buffet_boundrand((t_float)r1endframe,(t_float)(totalframes-swapframes));
         }
     }
     r2endframe = r2startframe + swapframes;
@@ -1166,18 +1166,18 @@
 void buffet_swap(t_buffet *x)
 {
     
-    float maxframes = x->maxframes;
-    float fade = x->fade;
+    t_float maxframes = x->maxframes;
+    t_float fade = x->fade;
     long totalframes;
     long swapframes;
     long start_sample1;
     long start_sample2;
-    float *storage = x->storage;
+    t_float *storage = x->storage;
     t_word *b_samples;
-    float mix_sample;
-    float fadein_gain;
-    float fadeout_gain;
-    float fadephase;
+    t_float mix_sample;
+    t_float fadein_gain;
+    t_float fadeout_gain;
+    t_float fadephase;
     long b_nchans;
     int i,j,k;
     buffet_setbuf(x, x->wavename);
@@ -1213,7 +1213,7 @@
     // swap block2 into block1 location, fadein
     
     for(i = 0, k = 0; i < fade * b_nchans; i += b_nchans, k++) {
-        fadephase = ((float)k / (float) fade) * PIOVERTWO;
+        fadephase = ((t_float)k / (t_float) fade) * PIOVERTWO;
         fadein_gain = sin(fadephase);
         fadeout_gain = cos(fadephase);
         for(j = 0; j < b_nchans; j++) {
@@ -1231,7 +1231,7 @@
     // fade out
     
     for(i = (swapframes-fade) * b_nchans, k = 0; i < swapframes * b_nchans; i += b_nchans, k++) {
-        fadephase = ((float)k / (float) fade) * PIOVERTWO;
+        fadephase = ((t_float)k / (t_float) fade) * PIOVERTWO;
         fadein_gain = sin(fadephase);
         fadeout_gain = cos(fadephase);
         for(j = 0; j < b_nchans; j++) {
@@ -1243,7 +1243,7 @@
     // swap block2 into block1 location, fadein
     
     for(i = 0, k = 0; i < fade * b_nchans; i += b_nchans, k++) {
-        fadein_gain = (float)k / (float) fade;
+        fadein_gain = (t_float)k / (t_float) fade;
         fadeout_gain = 1.0 - fadein_gain;
         for(j = 0; j < b_nchans; j++) {
             mix_sample = fadein_gain * storage[i + j] + fadeout_gain * b_samples[start_sample2 + i + j].w_float;
@@ -1260,7 +1260,7 @@
     // fade out
     
     for(i = (swapframes-fade) * b_nchans, k = 0; i < swapframes * b_nchans; i += b_nchans, k++) {
-        fadein_gain = (float)k / (float) fade;
+        fadein_gain = (t_float)k / (t_float) fade;
         fadeout_gain = 1.0 - fadein_gain;
         for(j = 0; j < b_nchans; j++) {
             mix_sample = fadeout_gain * storage[i + j] + fadein_gain * b_samples[start_sample2 + i + j].w_float;
@@ -1273,9 +1273,9 @@
 
 void buffet_specswap(t_buffet *x, t_symbol *msg, int argc, t_atom *argv)
 {
-    //  float minframes = x->minframes;
-    float maxframes = x->maxframes;
-    float fade = x->fade;
+    //  t_float minframes = x->minframes;
+    t_float maxframes = x->maxframes;
+    t_float fade = x->fade;
     long totalframes;
     long swapframes;
     long r1startframe;
@@ -1286,12 +1286,12 @@
     long region2;
     long start_sample1;
     long start_sample2;
-    float *storage = x->storage;
+    t_float *storage = x->storage;
     t_word *b_samples;
-    float mix_sample;
-    float fadein_gain;
-    float fadeout_gain;
-    float fadephase;
+    t_float mix_sample;
+    t_float fadein_gain;
+    t_float fadeout_gain;
+    t_float fadephase;
     long b_nchans;
     int i,j,k;
     buffet_setbuf(x, x->wavename);
@@ -1356,7 +1356,7 @@
     // swap block2 into block1 location, fadein
     
     for(i = 0, k = 0; i < fade * b_nchans; i += b_nchans, k++) {
-        fadephase = ((float)k / (float) fade) * PIOVERTWO;
+        fadephase = ((t_float)k / (t_float) fade) * PIOVERTWO;
         fadein_gain = sin(fadephase);
         fadeout_gain = cos(fadephase);
         for(j = 0; j < b_nchans; j++) {
@@ -1374,7 +1374,7 @@
     // fade out
     
     for(i = (swapframes-fade) * b_nchans, k = 0; i < swapframes * b_nchans; i += b_nchans, k++) {
-        fadephase = ((float)k / (float) fade) * PIOVERTWO;
+        fadephase = ((t_float)k / (t_float) fade) * PIOVERTWO;
         fadein_gain = sin(fadephase);
         fadeout_gain = cos(fadephase);
         for(j = 0; j < b_nchans; j++) {
@@ -1386,7 +1386,7 @@
     // swap block2 into block1 location, fadein
     
     for(i = 0, k = 0; i < fade * b_nchans; i += b_nchans, k++) {
-        fadein_gain = (float)k / (float) fade;
+        fadein_gain = (t_float)k / (t_float) fade;
         fadeout_gain = 1.0 - fadein_gain;
         for(j = 0; j < b_nchans; j++) {
             mix_sample = fadein_gain * storage[i + j] + fadeout_gain * b_samples[start_sample2 + i + j].w_float;
@@ -1403,7 +1403,7 @@
     // fade out
     
     for(i = (swapframes-fade) * b_nchans, k = 0; i < swapframes * b_nchans; i += b_nchans, k++) {
-        fadein_gain = (float)k / (float) fade;
+        fadein_gain = (t_float)k / (t_float) fade;
         fadeout_gain = 1.0 - fadein_gain;
         for(j = 0; j < b_nchans; j++) {
             mix_sample = fadeout_gain * storage[i + j] + fadein_gain * b_samples[start_sample2 + i + j].w_float;
@@ -1416,20 +1416,20 @@
 
 void buffet_retroblock(t_buffet *x)
 {
-    float minframes = x->minframes;
-    float maxframes = x->maxframes;
-    float fade = x->fade;
+    t_float minframes = x->minframes;
+    t_float maxframes = x->maxframes;
+    t_float fade = x->fade;
     long totalframes;
     long swapframes;
     long r1startframe;
     long r1endframe;
     long start_sample1;
-    float *storage = x->storage;
+    t_float *storage = x->storage;
     t_word *b_samples;
-    float mix_sample;
-    float fadein_gain;
-    float fadeout_gain;
-    //  float fadephase;
+    t_float mix_sample;
+    t_float fadein_gain;
+    t_float fadeout_gain;
+    //  t_float fadephase;
     long ub1, lb1;
     long ub2, lb2;
     long block1size,block2size;
@@ -1455,7 +1455,7 @@
     syncframe = x->sync * totalframes;
     swapframes = buffet_boundrand(minframes, maxframes);
     if(x->sync <= 0.0 ){ // either no sync signal or it is zero
-        r1startframe = buffet_boundrand(0.0, (float)(totalframes-swapframes));
+        r1startframe = buffet_boundrand(0.0, (t_float)(totalframes-swapframes));
         r1endframe = r1startframe + swapframes;
     } else {
         // avoid swapping where we are playing from buffer
@@ -1472,14 +1472,14 @@
         }
         if(block1size >= maxframes && block2size >= maxframes) {
             if(buffet_boundrand(0.0,1.0) > 0.5) {
-                r1startframe = buffet_boundrand(0.0, (float)(ub1-swapframes));
+                r1startframe = buffet_boundrand(0.0, (t_float)(ub1-swapframes));
             } else {
-                r1startframe = buffet_boundrand((float)lb2, (float)(ub2-swapframes));
+                r1startframe = buffet_boundrand((t_float)lb2, (t_float)(ub2-swapframes));
             }
         } else if(block1size < maxframes) {
-            r1startframe = buffet_boundrand((float)lb2, (float)(ub2-swapframes));
+            r1startframe = buffet_boundrand((t_float)lb2, (t_float)(ub2-swapframes));
         } else {
-            r1startframe = buffet_boundrand(0.0, (float)(ub1-swapframes));
+            r1startframe = buffet_boundrand(0.0, (t_float)(ub1-swapframes));
         }
         r1endframe = r1startframe + swapframes;
     }
@@ -1502,7 +1502,7 @@
     // swap block2 into block1 location, fadein
     
     for(i = 0, k = 0; i < fade * b_nchans; i += b_nchans, k++) {
-        fadein_gain = (float)k / (float) fade;
+        fadein_gain = (t_float)k / (t_float) fade;
         fadeout_gain = 1.0 - fadein_gain;
         for(j = 0; j < b_nchans; j++) {
             mix_sample = fadein_gain * storage[i + j] + fadeout_gain * b_samples[start_sample1 + i + j].w_float;
@@ -1520,7 +1520,7 @@
     // fade out
     
     for(i = (swapframes-fade) * b_nchans, k = 0; i < swapframes * b_nchans; i += b_nchans, k++) {
-        fadein_gain = (float)k / (float) fade;
+        fadein_gain = (t_float)k / (t_float) fade;
         fadeout_gain = 1.0 - fadein_gain;
         for(j = 0; j < b_nchans; j++) {
             mix_sample = fadeout_gain * storage[i + j] + fadein_gain * b_samples[start_sample1 + i + j].w_float;
@@ -1546,7 +1546,7 @@
     long region2;
     long start_sample1;
     long start_sample2;
-    float *storage = x->storage;
+    t_float *storage = x->storage;
     t_word *b_samples;
     long b_nchans;
     int i,j;
@@ -1564,21 +1564,21 @@
         pd_error(0, "buffet~ only accepts stereo buffers");
         return;
     }
-    swapframes = buffet_boundrand((float)minframes, (float)maxframes);
-    r1startframe = buffet_boundrand(0.0, (float)(totalframes-swapframes));
+    swapframes = buffet_boundrand((t_float)minframes, (t_float)maxframes);
+    r1startframe = buffet_boundrand(0.0, (t_float)(totalframes-swapframes));
     r1endframe = r1startframe + swapframes;
     region1 = r1startframe;
     region2 = totalframes - r1endframe;
     
     if(swapframes > region1) {
-        r2startframe = buffet_boundrand((float)r1endframe,(float)(totalframes-swapframes));
+        r2startframe = buffet_boundrand((t_float)r1endframe,(t_float)(totalframes-swapframes));
     } else if(swapframes > region2) {
-        r2startframe = buffet_boundrand(0.0,(float)(r1startframe-swapframes));
+        r2startframe = buffet_boundrand(0.0,(t_float)(r1startframe-swapframes));
     } else {
         if(buffet_boundrand(0.0,1.0) > 0.5) {
-            r2startframe = buffet_boundrand(0.0,(float)(r1startframe-swapframes));
+            r2startframe = buffet_boundrand(0.0,(t_float)(r1startframe-swapframes));
         } else {
-            r2startframe = buffet_boundrand((float)r1endframe,(float)(totalframes-swapframes));
+            r2startframe = buffet_boundrand((t_float)r1endframe,(t_float)(totalframes-swapframes));
         }
     }
     r2endframe = r2startframe + swapframes;
@@ -1642,7 +1642,7 @@
 t_int *buffet_perform(t_int *w)
 {
     t_buffet *x = (t_buffet *) (w[1]);
-    float *sync = (t_float *)(w[2]);
+    t_float *sync = (t_float *)(w[2]);
     int n = (int) w[3];
     
     while(n--) {
@@ -1653,9 +1653,9 @@
 }
 
 
-float buffet_boundrand(float min, float max)
+t_float buffet_boundrand(t_float min, t_float max)
 {
-    return min + (max-min) * ((float) (rand() % RAND_MAX)/ (float) RAND_MAX);
+    return min + (max-min) * ((t_float) (rand() % RAND_MAX)/ (t_float) RAND_MAX);
 }
 
 void buffet_detect_onsets(t_buffet *x, t_symbol *msg, int argc, t_atom *argv)
@@ -1676,41 +1676,41 @@
     int Nw2 = Nw / 2;
     int D = N / 2;
     int i,j,k,m;
-    //  float sb1,sb2,sb3,sb4,energy=0,lastenergy;
-    float freqcenter=0;
-    float tmp;
-    float fave; // freq average
+    //  t_float sb1,sb2,sb3,sb4,energy=0,lastenergy;
+    t_float freqcenter=0;
+    t_float tmp;
+    t_float fave; // freq average
     short first = 1;
-    float dsum;
+    t_float dsum;
     short suppress = 0;
-    float suppressrt = 0;
+    t_float suppressrt = 0;
     
-    float rt, rtadv;
+    t_float rt, rtadv;
     int inCount;
-    float *Wanal;
-    float *Wsyn;
-    float *input;
-    float *Hwin;
-    float *buffer;
-    float *channel;
-    float *output;
-    float *input_vec;
-    float *specdiff;
-    float *freqdiff;
-    float *hfc;
-    float *freqs, *amps;
-    float lastfreqs[5];
-    float fdiffs[5];
-    float *onsets;
-    float **loveboat;
-    float *c_lastphase_in;
-    float *c_lastphase_out;
-    float c_fundamental;
-    float c_factor_in;
-    float *trigland;
+    t_float *Wanal;
+    t_float *Wsyn;
+    t_float *input;
+    t_float *Hwin;
+    t_float *buffer;
+    t_float *channel;
+    t_float *output;
+    t_float *input_vec;
+    t_float *specdiff;
+    t_float *freqdiff;
+    t_float *hfc;
+    t_float *freqs, *amps;
+    t_float lastfreqs[5];
+    t_float fdiffs[5];
+    t_float *onsets;
+    t_float **loveboat;
+    t_float *c_lastphase_in;
+    t_float *c_lastphase_out;
+    t_float c_fundamental;
+    t_float c_factor_in;
+    t_float *trigland;
     int *bitshuffle;
     int topanalbin;
-    float threshold;
+    t_float threshold;
     int bytesize;
     
     int MAX_ONSETS = 2048;
@@ -1741,56 +1741,56 @@
     sample_frames = endframe - startframe;
     fft_frames = sample_frames / D;
     
-    c_fundamental = (float)R / (float)N;
+    c_fundamental = (t_float)R / (t_float)N;
     inCount = -Nw;
-    c_factor_in = (float)R/((float)D * TWOPI);
+    c_factor_in = (t_float)R/((t_float)D * TWOPI);
     
     rt = startframe * 1000.0 / x->sr;
-    rtadv = 1000. * (float)D/(float)R;
+    rtadv = 1000. * (t_float)D/(t_float)R;
     
     post("we will analyze %d FFT frames",fft_frames);
     
-    Wanal = (float *) getbytes(Nw * sizeof(float));
-    Wsyn = (float *) getbytes(Nw * sizeof(float));
-    Hwin = (float *) getbytes(Nw * sizeof(float));
-    input = (float *) getbytes(Nw * sizeof(float) );
-    output = (float *) getbytes(Nw * sizeof(float) );
-    buffer = (float *) getbytes(N * sizeof(float));
-    channel = (float *) getbytes((N+2) * sizeof(float) );
+    Wanal = (t_float *) getbytes(Nw * sizeof(t_float));
+    Wsyn = (t_float *) getbytes(Nw * sizeof(t_float));
+    Hwin = (t_float *) getbytes(Nw * sizeof(t_float));
+    input = (t_float *) getbytes(Nw * sizeof(t_float) );
+    output = (t_float *) getbytes(Nw * sizeof(t_float) );
+    buffer = (t_float *) getbytes(N * sizeof(t_float));
+    channel = (t_float *) getbytes((N+2) * sizeof(t_float) );
     bitshuffle = (int *) getbytes(N * 2 * sizeof(int));
-    bytesize = N * 2 * sizeof(float);
-    //  post("allocing %d bytes to trigland",N * 2 * sizeof(float));
+    bytesize = N * 2 * sizeof(t_float);
+    //  post("allocing %d bytes to trigland",N * 2 * sizeof(t_float));
     
-    trigland = (float *) getbytes(N * 2 * sizeof(float));
-    //    post("cleaning %d bytes in trigland",N * 2 * sizeof(float));
+    trigland = (t_float *) getbytes(N * 2 * sizeof(t_float));
+    //    post("cleaning %d bytes in trigland",N * 2 * sizeof(t_float));
     
     
-    c_lastphase_in = (float *) getbytes((N2+1) * sizeof(float));
-    c_lastphase_out = (float *) getbytes((N2+1) * sizeof(float));
+    c_lastphase_in = (t_float *) getbytes((N2+1) * sizeof(t_float));
+    c_lastphase_out = (t_float *) getbytes((N2+1) * sizeof(t_float));
     
-    input_vec = (float *) getbytes(D * sizeof(float));
-    onsets = (float *) getbytes(MAX_ONSETS * sizeof(float));
-    specdiff = (float *) getbytes(fft_frames * sizeof(float));
-    freqdiff = (float *) getbytes(fft_frames * sizeof(float));
-    hfc = (float *) getbytes(fft_frames * sizeof(float));
-    loveboat = (float **) getbytes(fft_frames * sizeof(float *));
+    input_vec = (t_float *) getbytes(D * sizeof(t_float));
+    onsets = (t_float *) getbytes(MAX_ONSETS * sizeof(t_float));
+    specdiff = (t_float *) getbytes(fft_frames * sizeof(t_float));
+    freqdiff = (t_float *) getbytes(fft_frames * sizeof(t_float));
+    hfc = (t_float *) getbytes(fft_frames * sizeof(t_float));
+    loveboat = (t_float **) getbytes(fft_frames * sizeof(t_float *));
     
-    freqs = (float *) getbytes(N * sizeof(float));
-    amps = (float *) getbytes(N * sizeof(float));
+    freqs = (t_float *) getbytes(N * sizeof(t_float));
+    amps = (t_float *) getbytes(N * sizeof(t_float));
     for(i = 0; i < fft_frames; i++) {
-        loveboat[i] = (float *) getbytes((N+2) * sizeof(float));
+        loveboat[i] = (t_float *) getbytes((N+2) * sizeof(t_float));
         if(loveboat[i] == NULL) {
             pd_error(0, "memory error");
             return;
         }
-        // memset((char *)loveboat[i],0,(N+2)*sizeof(float));
+        // memset((char *)loveboat[i],0,(N+2)*sizeof(t_float));
     }
     
-    memset((char *)trigland,0, N * 2 * sizeof(float));
-    memset((char *)input,0,Nw * sizeof(float));
-    memset((char *)output,0,Nw * sizeof(float));
-    memset((char *)c_lastphase_in,0,(N2+1) * sizeof(float));
-    memset((char *)c_lastphase_out,0,(N2+1) * sizeof(float));
+    memset((char *)trigland,0, N * 2 * sizeof(t_float));
+    memset((char *)input,0,Nw * sizeof(t_float));
+    memset((char *)output,0,Nw * sizeof(t_float));
+    memset((char *)c_lastphase_in,0,(N2+1) * sizeof(t_float));
+    memset((char *)c_lastphase_out,0,(N2+1) * sizeof(t_float));
     memset((char *)bitshuffle,0, 2 * N * sizeof(int));
     
     
@@ -1914,38 +1914,38 @@
     int minbin,maxbin;
     
     
-    float rt, rtadv;
+    t_float rt, rtadv;
     int inCount;
-    float *Wanal;
-    float *Wsyn;
-    float *input;
-    float *Hwin;
-    float *buffer;
- //   float *channel;
-    float *output;
-    float *input_vec;
- //   float *specdiff;
- //   float *freqdiff;
-    float *hfc;
-    float *freqs, *amps;
+    t_float *Wanal;
+    t_float *Wsyn;
+    t_float *input;
+    t_float *Hwin;
+    t_float *buffer;
+ //   t_float *channel;
+    t_float *output;
+    t_float *input_vec;
+ //   t_float *specdiff;
+ //   t_float *freqdiff;
+    t_float *hfc;
+    t_float *freqs, *amps;
     
-    float subband_energy[5];
-    float subband_freqdiff[5];
+    t_float subband_energy[5];
+    t_float subband_freqdiff[5];
     int subband_bincuts[6];
     
-    float *onsets;
-    float **loveboat;
+    t_float *onsets;
+    t_float **loveboat;
     
-    float *c_lastphase_in;
-    float *c_lastphase_out;
-    float c_fundamental;
-    float c_factor_in;
+    t_float *c_lastphase_in;
+    t_float *c_lastphase_out;
+    t_float c_fundamental;
+    t_float c_factor_in;
     
-    float *trigland;
+    t_float *trigland;
     int *bitshuffle;
     
     
-    float threshold;
+    t_float threshold;
     
     
     int MAX_ONSETS = 2048;
@@ -1977,12 +1977,12 @@
     sample_frames = endframe - startframe;
     fft_frames = sample_frames / D;
     
-    c_fundamental = (float)R / (float)N;
+    c_fundamental = (t_float)R / (t_float)N;
     inCount = -Nw;
-    c_factor_in = (float)R/((float)D * TWOPI);
+    c_factor_in = (t_float)R/((t_float)D * TWOPI);
     
     rt = startframe * 1000.0 / x->sr;
-    rtadv = 1000. * (float)D/(float)R;
+    rtadv = 1000. * (t_float)D/(t_float)R;
     
     post("we will analyze %d FFT frames",fft_frames);
     subband_bincuts[0] = 1;
@@ -1992,41 +1992,41 @@
     subband_bincuts[4] = (int) (4000.0 / c_fundamental);
     subband_bincuts[5] = (int) (8000.0 / c_fundamental);
     
-    Wanal = (float *) getbytes(Nw * sizeof(float));
-    Wsyn = (float *) getbytes(Nw * sizeof(float));
-    Hwin = (float *) getbytes(Nw * sizeof(float));
-    input = (float *) getbytes(Nw * sizeof(float) );
-    output = (float *) getbytes(Nw * sizeof(float) );
-    buffer = (float *) getbytes(N * sizeof(float));
-//    channel = (float *) getbytes((N+2) * sizeof(float) );
+    Wanal = (t_float *) getbytes(Nw * sizeof(t_float));
+    Wsyn = (t_float *) getbytes(Nw * sizeof(t_float));
+    Hwin = (t_float *) getbytes(Nw * sizeof(t_float));
+    input = (t_float *) getbytes(Nw * sizeof(t_float) );
+    output = (t_float *) getbytes(Nw * sizeof(t_float) );
+    buffer = (t_float *) getbytes(N * sizeof(t_float));
+//    channel = (t_float *) getbytes((N+2) * sizeof(t_float) );
     bitshuffle = (int *) getbytes(N * 2 * sizeof(int));
-    trigland = (float *) getbytes(N * 2 * sizeof(float));
-    c_lastphase_in = (float *) getbytes((N2+1) * sizeof(float));
-    c_lastphase_out = (float *) getbytes((N2+1) * sizeof(float));
-    
-    input_vec = (float *) getbytes(D * sizeof(float));
-    onsets = (float *) getbytes(MAX_ONSETS * sizeof(float));
-//    specdiff = (float *) getbytes(fft_frames * sizeof(float));
-//    freqdiff = (float *) getbytes(fft_frames * sizeof(float));
-    hfc = (float *) getbytes(fft_frames * sizeof(float));
-    loveboat = (float **) getbytes(fft_frames * sizeof(float *));
+    trigland = (t_float *) getbytes(N * 2 * sizeof(t_float));
+    c_lastphase_in = (t_float *) getbytes((N2+1) * sizeof(t_float));
+    c_lastphase_out = (t_float *) getbytes((N2+1) * sizeof(t_float));
+    
+    input_vec = (t_float *) getbytes(D * sizeof(t_float));
+    onsets = (t_float *) getbytes(MAX_ONSETS * sizeof(t_float));
+//    specdiff = (t_float *) getbytes(fft_frames * sizeof(t_float));
+//    freqdiff = (t_float *) getbytes(fft_frames * sizeof(t_float));
+    hfc = (t_float *) getbytes(fft_frames * sizeof(t_float));
+    loveboat = (t_float **) getbytes(fft_frames * sizeof(t_float *));
     
-    freqs = (float *) getbytes(N * sizeof(float));
-    amps = (float *) getbytes(N * sizeof(float));
+    freqs = (t_float *) getbytes(N * sizeof(t_float));
+    amps = (t_float *) getbytes(N * sizeof(t_float));
     for(i = 0; i < fft_frames; i++) {
-        loveboat[i] = (float *) getbytes((N+2) * sizeof(float));
+        loveboat[i] = (t_float *) getbytes((N+2) * sizeof(t_float));
         if(loveboat[i] == NULL) {
             pd_error(0, "memory error");
             return;
         }
-        // memset((char *)loveboat[i],0,(N+2)*sizeof(float));
+        // memset((char *)loveboat[i],0,(N+2)*sizeof(t_float));
     }
     /*
-    memset((char *)trigland,0, N * 2 * sizeof(float));
-    memset((char *)input,0,Nw * sizeof(float));
-    memset((char *)output,0,Nw * sizeof(float));
-    memset((char *)c_lastphase_in,0,(N2+1) * sizeof(float));
-    memset((char *)c_lastphase_out,0,(N2+1) * sizeof(float));
+    memset((char *)trigland,0, N * 2 * sizeof(t_float));
+    memset((char *)input,0,Nw * sizeof(t_float));
+    memset((char *)output,0,Nw * sizeof(t_float));
+    memset((char *)c_lastphase_in,0,(N2+1) * sizeof(t_float));
+    memset((char *)c_lastphase_out,0,(N2+1) * sizeof(t_float));
     memset((char *)bitshuffle,0, 2 * N * sizeof(int));
     */
     
--- pd-lyonpotpourri.orig/bvplay~.c
+++ pd-lyonpotpourri/bvplay~.c
@@ -16,24 +16,24 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   t_symbol *sfname; // name of soundfile
   t_guffer *wavebuf; // store needed buffer or garray data
 
   long object_chans; // number of channels for a given instantiation
-  float taper_dur;
+  t_float taper_dur;
   int R;
   int framesize;
-  float *notedata;
+  t_float *notedata;
   int active;
-  float buffer_duration;
+  t_float buffer_duration;
   int taper_frames;
-  float amp;
+  t_float amp;
   int start_frame;
   int note_frames;
   int end_frame;
-  float increment;
-  float findex;
+  t_float increment;
+  t_float findex;
   int index ;
   short verbose;
   short mute;
@@ -67,7 +67,7 @@
 void bvplay_taper(t_bvplay *x, t_floatarg t)
 {
   if(t>0) {
-    x->taper_dur = (float)t/1000.0;
+    x->taper_dur = (t_float)t/1000.0;
     x->taper_frames = x->R * x->taper_dur;
   }
 }
@@ -145,19 +145,19 @@
   int n = (int) w[3];
   t_word *tab;
   long iindex = x->index;
-  float findex = x->findex;
+  t_float findex = x->findex;
   int end_frame = x->end_frame;
-  float increment = x->increment;
+  t_float increment = x->increment;
   int start_frame = x->start_frame;
   int taper_frames = x->taper_frames;
-  float noteamp = x->amp;
-  float frac, amp;
+  t_float noteamp = x->amp;
+  t_float frac, amp;
   /**********************/
   bvplay_set(x,x->sfname);
 
   if(!x->wavebuf->b_valid) {
     post("invalid buffer");
-    memset(out, 0, sizeof(float) * n);
+    memset(out, 0, sizeof(t_float) * n);
     return (w+4);
   }
   tab = x->wavebuf->b_samples;
@@ -169,9 +169,9 @@
         // envelope
         if( increment > 0 ) {
           if( findex < start_frame + taper_frames ) {
-            amp = noteamp * ((findex - (float) start_frame) / (float) taper_frames );
+            amp = noteamp * ((findex - (t_float) start_frame) / (t_float) taper_frames );
           } else if ( findex > end_frame - taper_frames) {
-            amp = noteamp * (((float)end_frame - findex) / (float) taper_frames);
+            amp = noteamp * (((t_float)end_frame - findex) / (t_float) taper_frames);
           } else {
             amp = noteamp;
           }
@@ -249,7 +249,7 @@
     pd_error(0, "zero sampling rate - set to 44100");
     x->R = 44100;
   }
-  x->notedata = (float *) getbytes(4 * sizeof(float));
+  x->notedata = (t_float *) getbytes(4 * sizeof(t_float));
   x->wavebuf = (t_guffer *) getbytes(1 * sizeof(t_guffer));
   x->taper_dur = taperdur;
   x->taper_frames = x->R * x->taper_dur;
@@ -266,7 +266,7 @@
 
 void bvplay_dsp_free(t_bvplay *x)
 {
-  freebytes(x->notedata, 4 * sizeof(float));
+  freebytes(x->notedata, 4 * sizeof(t_float));
   freebytes(x->wavebuf, 1 * sizeof(t_guffer));
 }
 
--- pd-lyonpotpourri.orig/chameleon_pd.h
+++ pd-lyonpotpourri/chameleon_pd.h
@@ -215,8 +215,8 @@
 
 typedef struct _chameleon {
     t_object x_obj;
-    float x_f;
-    float sr; // sampling rate
+    t_float x_f;
+    t_float sr; // sampling rate
     long vs;//Max/MSP vector size
     long vecsize; // Max signal vector size
     long pcount; // number of parameters
@@ -224,7 +224,7 @@
     double fadeout; // fadeout time in sample frames (if truncation)
     t_double *chan1buf; // work vector buffer inside of perform routine
     t_double *chan2buf; // work vector buffer inside of perform routine
-    float *odds;// odds for each process happening
+    t_float *odds;// odds for each process happening
     int max_process_per_note;//what it says
     int min_process_per_note;//ditto
     int new_slot;//position for newest note
--- pd-lyonpotpourri.orig/channel~.c
+++ pd-lyonpotpourri/channel~.c
@@ -7,7 +7,7 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   void *float_outlet;
   int channel;
 } t_channel;
@@ -61,7 +61,7 @@
   t_float *out_vec = (t_float *)(w[3]);
   int n = (int) w[4];
   int channel = x->channel;
-  float value;
+  t_float value;
 
   if(channel < 0 || channel > n) {
     return w + 5;
--- pd-lyonpotpourri.orig/chopper~.c
+++ pd-lyonpotpourri/chopper~.c
@@ -9,17 +9,17 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   t_symbol *l_sym;
   long l_chan;
-  float increment;
+  t_float increment;
   double fbindex;
-  float buffer_duration;
-  float minseg;
-  float maxseg;
-  float segdur;
-  float minincr;
-  float maxincr;
+  t_float buffer_duration;
+  t_float minseg;
+  t_float maxseg;
+  t_float segdur;
+  t_float minincr;
+  t_float maxincr;
   int loop_samps;
   int samps_to_go ;
   int loop_start;
@@ -27,9 +27,9 @@
   int taper_samps;
   int loop_min_samps;
   int loop_max_samps;
-  float R;
-  float ldev;
-  float st_dev ;
+  t_float R;
+  t_float ldev;
+  t_float st_dev ;
   int lock_loop;
   int force_new_loop;
   int framesize;
@@ -38,24 +38,24 @@
   int setup_chans;
   int *stored_starts;
   int *stored_samps;
-  float *stored_increments;
+  t_float *stored_increments;
   short preempt;
   short loop_engaged;
   short data_recalled;
   short initialize_loop;
   short fixed_increment_on;
-  float fixed_increment;
-  float retro_odds;
-  float fade_level;
+  t_float fixed_increment;
+  t_float retro_odds;
+  t_float fade_level;
   int transp_loop_samps;
-  float taper_duration;
+  t_float taper_duration;
   short lock_terminated;
   int preempt_samps;
   int preempt_count;
   short recalling_loop;
-  float jitter_factor;
-  float rdur_factor;
-  float rinc_factor;
+  t_float jitter_factor;
+  t_float rdur_factor;
+  t_float rinc_factor;
   short increment_adjusts_loop ;
   short loop_adjust_inverse;
   long b_frames;
@@ -84,7 +84,7 @@
 static void chopper_fixed_increment(t_chopper *x, t_floatarg f);
 static void chopper_lockme(t_chopper *x, t_floatarg n);
 static void chopper_force_new(t_chopper *x);
-static float chopper_boundrand(float min, float max);
+static t_float chopper_boundrand(t_float min, t_float max);
 //static void chopper_assist(t_chopper *x, void *b, long m, long a, char *s);
 //static void chopper_dblclick(t_chopper *x);
 static void chopper_show_loop(t_chopper *x);
@@ -111,7 +111,7 @@
 
 void chopper_testrand(t_chopper *x)
 {
-  float rval = chopper_boundrand(0.0, 1.0);
+  t_float rval = chopper_boundrand(0.0, 1.0);
   post("random btwn 0.0 1.0: %f",rval);
 }
 
@@ -168,8 +168,8 @@
 
 void chopper_fixed_increment(t_chopper *x, t_floatarg f)
 {
-  float new_samps = 0;
-  float rectf;
+  t_float new_samps = 0;
+  t_float rectf;
 
   x->fixed_increment = f;
   if( f ) {
@@ -183,9 +183,9 @@
   if( x->lock_loop && rectf > 0.0 ) {
 
     if( x->loop_adjust_inverse ) {
-      new_samps = (float) x->loop_samps * rectf ;
+      new_samps = (t_float) x->loop_samps * rectf ;
     } else {
-      new_samps = (float) x->loop_samps / rectf ;
+      new_samps = (t_float) x->loop_samps / rectf ;
     }
     if( f > 0 ) {
       if( x->loop_start + new_samps >= x->framesize ) {
@@ -321,7 +321,7 @@
   f /= 1000.0;
 
   if( f > 0 ) {
-    x->taper_samps = (float) x->R * f ;
+    x->taper_samps = (t_float) x->R * f ;
   }
   if( x->taper_samps < 2 )
     x->taper_samps = 2;
@@ -403,9 +403,9 @@
 
 void chopper_jitterme(t_chopper *x)
 {
-  float new_start;
-  float jitter_factor = x->jitter_factor;
-  new_start = (1.0 + chopper_boundrand(-jitter_factor, jitter_factor) ) * (float) x->loop_start ;
+  t_float new_start;
+  t_float jitter_factor = x->jitter_factor;
+  new_start = (1.0 + chopper_boundrand(-jitter_factor, jitter_factor) ) * (t_float) x->loop_start ;
 
   if( new_start < 0 ) {
 //    pd_error(0, "jitter loop %d out of range", new_start);
@@ -422,10 +422,10 @@
 
 void chopper_rdurme(t_chopper *x)
 {
-  float new_dur;
-  float rdur_factor = x->rdur_factor;
+  t_float new_dur;
+  t_float rdur_factor = x->rdur_factor;
 
-  new_dur = (1.0 + chopper_boundrand( -rdur_factor, rdur_factor)) * (float) x->transp_loop_samps;
+  new_dur = (1.0 + chopper_boundrand( -rdur_factor, rdur_factor)) * (t_float) x->transp_loop_samps;
   if( new_dur > x->loop_max_samps )
     new_dur = x->loop_max_samps;
   if( new_dur < x->loop_min_samps )
@@ -436,10 +436,10 @@
 
 void chopper_rincme(t_chopper *x )
 {
-  float new_inc = 0;
+  t_float new_inc = 0;
 //  int count = 0;
   int new_samps;
-  float rinc_factor = x->rinc_factor;
+  t_float rinc_factor = x->rinc_factor;
 
   /* test generate a new increment */
   new_inc = (1.0 + chopper_boundrand( 0.0, rinc_factor)) ;
@@ -459,7 +459,7 @@
   }
 
   if(x->increment_adjusts_loop) {
-    new_samps = (float) x->transp_loop_samps / new_inc ;
+    new_samps = (t_float) x->transp_loop_samps / new_inc ;
   } else {
     new_samps = x->transp_loop_samps;
   }
@@ -482,24 +482,24 @@
 {
   int framesize = x->b_frames;//test
 //  long bindex = x->fbindex;
-  float segdur = x->segdur;
+  t_float segdur = x->segdur;
   int loop_start = x->loop_start;
   int loop_samps = x->loop_samps;
   int transp_loop_samps = x->transp_loop_samps;
   int samps_to_go = x->samps_to_go;
-  float increment = x->increment;
+  t_float increment = x->increment;
 //  int taper_samps = x->taper_samps ;
-//  float taper_duration = x->taper_duration;
-  float minincr = x->minincr;
-  float maxincr = x->maxincr;
-  float minseg = x->minseg;
-  float maxseg = x->maxseg;
-  float buffer_duration = x->buffer_duration;
-  float R = x->R;
-  float fixed_increment = x->fixed_increment;
+//  t_float taper_duration = x->taper_duration;
+  t_float minincr = x->minincr;
+  t_float maxincr = x->maxincr;
+  t_float minseg = x->minseg;
+  t_float maxseg = x->maxseg;
+  t_float buffer_duration = x->buffer_duration;
+  t_float R = x->R;
+  t_float fixed_increment = x->fixed_increment;
 
   short fixed_increment_on = x->fixed_increment_on;
-  float retro_odds = x->retro_odds;
+  t_float retro_odds = x->retro_odds;
 
   if(fixed_increment_on) {
     increment = fixed_increment;
@@ -543,7 +543,7 @@
 t_int *chopper_pd_perform(t_int *w)
 {
   int bindex;
-  float sample1, m1, m2;
+  t_float sample1, m1, m2;
   t_chopper *x = (t_chopper *)(w[1]);
   t_float *out1 = (t_float *)(w[2]);
   int n = (int) w[3];
@@ -553,24 +553,24 @@
   t_word *tab = x->b_samples;
   long b_frames = x->b_frames;
   long nc = x->b_nchans;
-  float segdur = x->segdur;
+  t_float segdur = x->segdur;
   int taper_samps = x->taper_samps ;
-  float taper_duration = x->taper_duration;
-  float minseg = x->minseg;
-  float maxseg = x->maxseg;
+  t_float taper_duration = x->taper_duration;
+  t_float minseg = x->minseg;
+  t_float maxseg = x->maxseg;
   int lock_loop = x->lock_loop;
   int force_new_loop = x->force_new_loop;
-  float R = x->R;
+  t_float R = x->R;
   short initialize_loop = x->initialize_loop;
-  float fade_level = x->fade_level;
+  t_float fade_level = x->fade_level;
   short preempt = x->preempt;
   int preempt_count = x->preempt_count;
   int preempt_samps = x->preempt_samps;
   short recalling_loop = x->recalling_loop;
-  float preempt_gain;
-  float jitter_factor = x->jitter_factor;
-  float rdur_factor = x->rdur_factor;
-  float rinc_factor = x->rinc_factor;
+  t_float preempt_gain;
+  t_float jitter_factor = x->jitter_factor;
+  t_float rdur_factor = x->rdur_factor;
+  t_float rinc_factor = x->rinc_factor;
 
   if(x->mute) {
     while(n--) { *out1++ = 0.0; }
@@ -591,12 +591,12 @@
 
   if(x->framesize != b_frames) {
     x->framesize = b_frames ;
-    x->buffer_duration = (float)  b_frames / R ;
+    x->buffer_duration = (t_float)  b_frames / R ;
     initialize_loop = 1;
   }
   else if(x->buffer_duration <= 0.0) { /* THIS WILL HAPPEN THE FIRST TIME */
     x->framesize = b_frames ;
-    x->buffer_duration = (float)  b_frames / R ;
+    x->buffer_duration = (t_float)  b_frames / R ;
     initialize_loop = 1;
 //  post("initializing from perform method");
   }
@@ -623,7 +623,7 @@
         bindex = x->fbindex ;
         x->fbindex += x->increment;
         --preempt_count;
-        preempt_gain = fade_level  * ((float) preempt_count / (float) preempt_samps);
+        preempt_gain = fade_level  * ((t_float) preempt_count / (t_float) preempt_samps);
         *out1++ = tab[bindex].w_float * preempt_gain;
         if( preempt_count <= 0) {
           bindex = x->fbindex = x->loop_start;
@@ -640,7 +640,7 @@
         if( preempt && preempt_samps > x->samps_to_go ){ /* PREEMPT FADE */
 
           --preempt_count;
-          preempt_gain = fade_level  * ( (float) preempt_count / (float) preempt_samps );
+          preempt_gain = fade_level  * ( (t_float) preempt_count / (t_float) preempt_samps );
           bindex = x->fbindex ;
           x->fbindex += x->increment;
 
@@ -668,10 +668,10 @@
             x->samps_to_go = x->transp_loop_samps;
           }
           if( x->samps_to_go > x->transp_loop_samps - taper_samps ) {
-            fade_level =  (float)(x->transp_loop_samps - x->samps_to_go)/(float)taper_samps ;
+            fade_level =  (t_float)(x->transp_loop_samps - x->samps_to_go)/(t_float)taper_samps ;
             *out1++ = tab[bindex].w_float * fade_level;
           } else if( x->samps_to_go < taper_samps ) {
-            fade_level = (float)(x->samps_to_go)/(float)taper_samps;
+            fade_level = (t_float)(x->samps_to_go)/(t_float)taper_samps;
             *out1++ = tab[bindex].w_float * fade_level;
           } else {
             fade_level = 1.0;
@@ -717,11 +717,11 @@
           sample1 = m1 * tab[bindex].w_float + m2 * tab[bindex + 1].w_float;
         }
         if( x->samps_to_go > x->transp_loop_samps - taper_samps ) {
-          fade_level =  (float)(x->transp_loop_samps - x->samps_to_go)/(float)taper_samps ;
+          fade_level =  (t_float)(x->transp_loop_samps - x->samps_to_go)/(t_float)taper_samps ;
           *out1++ = sample1 * fade_level;
         }
         else if( x->samps_to_go < taper_samps ) {
-          fade_level = (float)(x->samps_to_go)/(float)taper_samps;
+          fade_level = (t_float)(x->samps_to_go)/(t_float)taper_samps;
           *out1++ = sample1 * fade_level;
         }
         else {
@@ -736,7 +736,7 @@
       bindex = x->fbindex ;
       x->fbindex += x->increment;
       --preempt_count;
-      preempt_gain = fade_level  * ( (float) preempt_count / (float) preempt_samps );
+      preempt_gain = fade_level  * ( (t_float) preempt_count / (t_float) preempt_samps );
 
       *out1++ = tab[bindex].w_float * preempt_gain;
       if( preempt_count <= 0) {
@@ -766,11 +766,11 @@
         x->fbindex += x->increment;
 
         if( x->samps_to_go > x->transp_loop_samps - taper_samps ) {
-          fade_level =  (float)(x->transp_loop_samps - x->samps_to_go)/(float)taper_samps ;
+          fade_level =  (t_float)(x->transp_loop_samps - x->samps_to_go)/(t_float)taper_samps ;
           *out1++ = tab[bindex].w_float * fade_level;
         }
         else if(x->samps_to_go < taper_samps) {
-          fade_level = (float)(x->samps_to_go)/(float)taper_samps;
+          fade_level = (t_float)(x->samps_to_go)/(t_float)taper_samps;
           *out1++ = tab[bindex].w_float * fade_level;
         }
         else {
@@ -901,7 +901,7 @@
 }
 
 
-float chopper_boundrand(float min, float max)
+t_float chopper_boundrand(t_float min, t_float max)
 {
-  return min + (max-min) * ((float) (rand() % RAND_MAX)/(float)RAND_MAX);
+  return min + (max-min) * ((t_float) (rand() % RAND_MAX)/(t_float)RAND_MAX);
 }
--- pd-lyonpotpourri.orig/clean_selector~.c
+++ pd-lyonpotpourri/clean_selector~.c
@@ -10,20 +10,20 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   // Variables Here
   short input_chans;
   short active_chan;
   short last_chan;
   int samps_to_fade;
   int fadesamps;
-  float fadetime;
-  float pi_over_two;
+  t_float fadetime;
+  t_float pi_over_two;
   short fadetype;
   short *connected_list;
-  float **bulk ; // array to point to all input audio channels
-  float sr;
-  float vs;
+  t_float **bulk ; // array to point to all input audio channels
+  t_float sr;
+  t_float vs;
   int inlet_count;
 } t_clean_selector;
 
@@ -110,7 +110,7 @@
 
 void clean_selector_fadetime(t_clean_selector *x, t_floatarg f)
 {
-  float fades = (float)f / 1000.0;
+  t_float fades = (t_float)f / 1000.0;
 
   if( fades < .0001 || fades > 1000.0 ) {
     pd_error(0, "fade time is constrained to 0.1 - 1000000, but you wanted %f",f );
@@ -133,11 +133,11 @@
   short active_chan = x->active_chan;
   short last_chan = x->last_chan;
   int samps_to_fade = x->samps_to_fade;
-  float m1, m2;
-  float **bulk = x->bulk;
-  float pi_over_two = x->pi_over_two;
+  t_float m1, m2;
+  t_float **bulk = x->bulk;
+  t_float pi_over_two = x->pi_over_two;
   short fadetype = x->fadetype;
-  float phase;
+  t_float phase;
   int inlet_count = x->inlet_count;
 
   for ( i = 0; i < inlet_count; i++ ) {
@@ -151,7 +151,7 @@
     while( n-- ) {
       if ( samps_to_fade >= 0 ) {
         if( fadetype == CS_POWER ) {
-          phase = pi_over_two * (1.0 - (samps_to_fade / (float) fadesamps)) ;
+          phase = pi_over_two * (1.0 - (samps_to_fade / (t_float) fadesamps)) ;
           m1 = sin( phase );
           m2 = cos( phase );
           --samps_to_fade;
--- pd-lyonpotpourri.orig/click2bang~.c
+++ pd-lyonpotpourri/click2bang~.c
@@ -7,7 +7,7 @@
 typedef struct _click2bang
 {
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   void *bang;
   void *clock;
 } t_click2bang;
--- pd-lyonpotpourri.orig/click2float~.c
+++ pd-lyonpotpourri/click2float~.c
@@ -8,7 +8,7 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   void *float_outlet;
   void *clock;
   double float_value;
--- pd-lyonpotpourri.orig/clickhold~.c
+++ pd-lyonpotpourri/clickhold~.c
@@ -7,8 +7,8 @@
 typedef struct _clickhold
 {
   t_object x_obj;
-  float x_f;
-  float hold_value;
+  t_float x_f;
+  t_float hold_value;
 } t_clickhold;
 
 static void *clickhold_new(void);
@@ -40,7 +40,7 @@
   t_float *out_vec = (t_float *)(w[3]);
   int n = (int) w[4];
 
-  float hold_value = x->hold_value;
+  t_float hold_value = x->hold_value;
 
   while( n-- ) {
     if(*in_vec) {
--- pd-lyonpotpourri.orig/click~.c
+++ pd-lyonpotpourri/click~.c
@@ -5,9 +5,9 @@
 typedef struct _click
 {
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   void *float_outlet;
-  float float_value;
+  t_float float_value;
   long status;
 } t_click;
 
--- pd-lyonpotpourri.orig/convolver~.c
+++ pd-lyonpotpourri/convolver~.c
@@ -27,28 +27,28 @@
 typedef struct _convolver
 {
     t_object x_obj;
-    float x_f;
+    t_float x_f;
     t_buffy *impulse; // impulse buffer
     t_buffy *source; // source buffer
     t_buffy *dest; // output buffer
     void *bang; // completion bang
-    float sr;
+    t_float sr;
     // convolution stuff
-    float *tbuf;
-    float *sbuf;
-    float *filt;
+    t_float *tbuf;
+    t_float *sbuf;
+    t_float *filt;
     long N;
     long N2;
     long last_N;
     // for fast fft
-    float mult;
-    float *trigland;
+    t_float mult;
+    t_float *trigland;
     int *bitshuffle;
     short static_memory; // flag to avoid dynamic memory manipulation
 } t_convolver;
 
 
-static float boundrand(float min, float max);
+static t_float boundrand(t_float min, t_float max);
 static void convolver_setbuf(t_buffy *trybuf);
 static void *convolver_new(t_symbol *msg, int argc, t_atom *argv);
 static t_int *convolver_perform(t_int *w);
@@ -58,11 +58,11 @@
 static void convolver_convolve(t_convolver *x);
 static void convolver_convolvechans(t_convolver *x, t_symbol *msg, int argc, t_atom *argv);
 static void convolver_noiseimp(t_convolver *x, t_floatarg curve);
-static void rfft( float *x, int N, int forward );
-static void cfft( float *x, int NC, int forward );
-static void rdft(int n, int isgn, float *a, int *ip, float *w);
-static void bitreverse( float *x, int N );
-static void init_rdft(int n, int *ip, float *w);
+static void rfft( t_float *x, int N, int forward );
+static void cfft( t_float *x, int NC, int forward );
+static void rdft(int n, int isgn, t_float *a, int *ip, t_float *w);
+static void bitreverse( t_float *x, int N );
+static void init_rdft(int n, int *ip, t_float *w);
 static void convolver_static_memory(t_convolver *x, t_floatarg toggle);
 
 void convolver_tilde_setup(void) {
@@ -80,11 +80,11 @@
 {
     
     long memcount = 0;
-    float *tbuf = x->tbuf;
-    float *sbuf = x->sbuf;
-    float *filt = x->filt;
+    t_float *tbuf = x->tbuf;
+    t_float *sbuf = x->sbuf;
+    t_float *filt = x->filt;
     int *bitshuffle = x->bitshuffle;
-    float *trigland = x->trigland;
+    t_float *trigland = x->trigland;
     t_buffy *impulse = x->impulse;
     long N, N2;
     
@@ -103,22 +103,22 @@
         
         post("%s: memory is now static - do not reload your impulse buffer",OBJECT_NAME);
         
-        if ((sbuf = (float *) getbytes((N+2) * sizeof(float))) == NULL)
+        if ((sbuf = (t_float *) getbytes((N+2) * sizeof(t_float))) == NULL)
             pd_error(0, "%s: insufficient memory", OBJECT_NAME);
-        memcount += (N+2) * sizeof(float);
-        if ((tbuf = (float *) getbytes(N2 * sizeof(float))) == NULL)
+        memcount += (N+2) * sizeof(t_float);
+        if ((tbuf = (t_float *) getbytes(N2 * sizeof(t_float))) == NULL)
             pd_error(0, "%s: insufficient memory",OBJECT_NAME);
-        memcount += (N2) * sizeof(float);
-        if ((filt = (float *) getbytes((N+2) * sizeof(float))) == NULL)
+        memcount += (N2) * sizeof(t_float);
+        if ((filt = (t_float *) getbytes((N+2) * sizeof(t_float))) == NULL)
             pd_error(0, "%s: insufficient memory",OBJECT_NAME);
-        memcount += (N+2) * sizeof(float);
+        memcount += (N+2) * sizeof(t_float);
         if( (bitshuffle = (int *) getbytes((N*2) * sizeof(int))) == NULL)
             pd_error(0, "%s: insufficient memory",OBJECT_NAME);
-        memcount += (N2) * sizeof(float);
-        if( (trigland = (float *) getbytes((N*2) * sizeof(float))) == NULL)
+        memcount += (N2) * sizeof(t_float);
+        if( (trigland = (t_float *) getbytes((N*2) * sizeof(t_float))) == NULL)
             pd_error(0, "%s: insufficient memory",OBJECT_NAME);
-        memcount += (N2) * sizeof(float);
-        post("%s: allocated %f Megabytes for %s", OBJECT_NAME, (float)memcount / 1000000.0, impulse->myname->s_name);
+        memcount += (N2) * sizeof(t_float);
+        post("%s: allocated %f Megabytes for %s", OBJECT_NAME, (t_float)memcount / 1000000.0, impulse->myname->s_name);
         x->N = N;
         x->N2 = N2;
     }
@@ -176,24 +176,24 @@
 
 void convolver_convolvechans(t_convolver *x, t_symbol *msg, int argc, t_atom *argv)
 {
-    float *tbuf = x->tbuf;
-    float *sbuf = x->sbuf;
-    float *filt = x->filt;
+    t_float *tbuf = x->tbuf;
+    t_float *sbuf = x->sbuf;
+    t_float *filt = x->filt;
     long N = x->N;
     long N2 = x->N2;
     long i, j, ip, ip1;
     long ifr_cnt = 0, ofr_cnt = 0;
     int target_frames = 2;
     short copacetic; // loop enabler
-    float a,b,temp,max=0.0,gain=1.0; //,thresh=.0000000001,fmag;
+    t_float a,b,temp,max=0.0,gain=1.0; //,thresh=.0000000001,fmag;
     int readframes, writeframes;
     t_buffy *impulse = x->impulse;
     t_buffy *source = x->source;
     t_buffy *dest = x->dest;
     int *bitshuffle = x->bitshuffle;
-    float *trigland = x->trigland;
+    t_float *trigland = x->trigland;
     long source_chan, impulse_chan, dest_chan;
-    float rescale = 0.5 / (float) N;
+    t_float rescale = 0.5 / (t_float) N;
     (void)msg;
     //  t_atom newsize;
     
@@ -235,19 +235,19 @@
     
     // post("size of N for convolution is %d", N);
     if(! x->static_memory ) {
-        if ((sbuf = (float *) getbytes((N+2) * sizeof(float))) == NULL)
+        if ((sbuf = (t_float *) getbytes((N+2) * sizeof(t_float))) == NULL)
             pd_error(0, "%s: insufficient memory", OBJECT_NAME);
-        if ((tbuf = (float *) getbytes(N2 * sizeof(float))) == NULL)
+        if ((tbuf = (t_float *) getbytes(N2 * sizeof(t_float))) == NULL)
             pd_error(0, "%s: insufficient memory",OBJECT_NAME);
-        if ((filt = (float *) getbytes((N+2) * sizeof(float))) == NULL)
+        if ((filt = (t_float *) getbytes((N+2) * sizeof(t_float))) == NULL)
             pd_error(0, "%s: insufficient memory",OBJECT_NAME);
         if( (bitshuffle = (int *) getbytes((N*2) * sizeof(int))) == NULL)
             pd_error(0, "%s: insufficient memory",OBJECT_NAME);
-        if( (trigland = (float *) getbytes((N*2) * sizeof(float))) == NULL)
+        if( (trigland = (t_float *) getbytes((N*2) * sizeof(t_float))) == NULL)
             pd_error(0, "%s: insufficient memory",OBJECT_NAME);
     }
     
-    x->mult = 1. / (float) N;
+    x->mult = 1. / (t_float) N;
     x->last_N = N;
     init_rdft(N, bitshuffle, trigland);
     
@@ -298,9 +298,9 @@
     if( dest->b_frames < target_frames) {
         
         
-        //SETFLOAT(&newsize, (float) target_frames);
+        //SETFLOAT(&newsize, (t_float) target_frames);
         // typedmess((void *) x->dest->b, gensym("sizeinsamps"),1, &newsize);
-        garray_resize(x->dest->b,(float)target_frames );
+        garray_resize(x->dest->b,(t_float)target_frames );
         post("%s: destination buffer was too small and has been resized",OBJECT_NAME);
         convolver_attach_buffers( x );
     }
@@ -384,11 +384,11 @@
     //  return;
     
     if(! x->static_memory ) {
-        freebytes(sbuf,(N+2) * sizeof(float));
-        freebytes(tbuf,N2 * sizeof(float));
-        freebytes(filt,(N+2) * sizeof(float));
+        freebytes(sbuf,(N+2) * sizeof(t_float));
+        freebytes(tbuf,N2 * sizeof(t_float));
+        freebytes(filt,(N+2) * sizeof(t_float));
         freebytes(bitshuffle,(N*2) * sizeof(int));
-        freebytes(trigland,(N*2) * sizeof(float));
+        freebytes(trigland,(N*2) * sizeof(t_float));
     } else {
         x->N = N;
         x->N2 =  N2;
@@ -402,13 +402,13 @@
 {
     long b_frames;
     t_word *b_samples;
-    float sr = x->sr;
+    t_float sr = x->sr;
     int i;
     int count;
     //  int position;
-    float guess;
-    float level = 1.0, endLevel = 0.001;
-    float grow, a1, a2, b1;
+    t_float guess;
+    t_float level = 1.0, endLevel = 0.001;
+    t_float grow, a1, a2, b1;
     
     if(fabs(curve) < 0.001) {
         curve = 0.001;
@@ -424,7 +424,7 @@
         return;
     }
     // zero out buffer
-    //dur = (float) b_frames / sr;
+    //dur = (t_float) b_frames / sr;
     count = b_frames;
     if(b_frames < 20) {
         post("impulse buffer too small!");
@@ -432,7 +432,7 @@
     }
     
     
-    //  memset((char *)b_samples, 0, b_nchans * b_frames * sizeof(float));
+    //  memset((char *)b_samples, 0, b_nchans * b_frames * sizeof(t_float));
     // return;
     
     level = 1.0;
@@ -460,12 +460,12 @@
     long b_nchans;
     long b_frames;
     t_word *b_samples;
-    float sr = x->sr;
+    t_float sr = x->sr;
     int i, j;
     int count;
     int position;
-    float gain, guess;
-    float dur;
+    t_float gain, guess;
+    t_float dur;
     
     // let's be current
     convolver_attach_buffers(x);
@@ -478,9 +478,9 @@
         return;
     }
     // zero out buffer
-    dur = (float) b_frames / sr;
+    dur = (t_float) b_frames / sr;
     count = density * dur;
-    // memset((char *)b_samples, 0, b_nchans * b_frames * sizeof(float));
+    // memset((char *)b_samples, 0, b_nchans * b_frames * sizeof(t_float));
     // assume mono forever
     for(i = 0; i < b_frames; i++){
         b_samples[i].w_float = 0.0;
@@ -507,9 +507,9 @@
     outlet_bang(x->bang);
 }
 
-float boundrand(float min, float max)
+t_float boundrand(t_float min, t_float max)
 {
-    return min + (max-min) * ((float) (rand() % RAND_MAX)/ (float) RAND_MAX);
+    return min + (max-min) * ((t_float) (rand() % RAND_MAX)/ (t_float) RAND_MAX);
 }
 
 
@@ -584,11 +584,11 @@
     freebytes(x->source, sizeof(t_buffy));
     freebytes(x->dest, sizeof(t_buffy));
     if( x->static_memory ) {
-        freebytes(x->sbuf, (N+2) * sizeof(float));
-        freebytes(x->tbuf, N2 * sizeof(float));
-        freebytes(x->filt, (N+2) * sizeof(float));
+        freebytes(x->sbuf, (N+2) * sizeof(t_float));
+        freebytes(x->tbuf, N2 * sizeof(t_float));
+        freebytes(x->filt, (N+2) * sizeof(t_float));
         freebytes(x->bitshuffle, (N*2) * sizeof(int));
-        freebytes(x->trigland, (N*2) * sizeof(float));
+        freebytes(x->trigland, (N*2) * sizeof(t_float));
        //  outlet_bang(x->bang);
     }
 }
@@ -606,10 +606,10 @@
 
 
 
-void cfft( float *x, int NC, int forward )
+void cfft( t_float *x, int NC, int forward )
 
 {
-    float   wr,wi,
+    t_float   wr,wi,
     wpr,wpi,
     theta,
     scale;
@@ -631,7 +631,7 @@
         wr = 1.;
         wi = 0.;
         for ( m = 0; m < mmax; m += 2 ) {
-            register float rtemp, itemp;
+            register t_float rtemp, itemp;
             for ( i = m; i < ND; i += delta ) {
                 j = i + mmax;
                 rtemp = wr*x[j] - wi*x[j+1];
@@ -649,19 +649,19 @@
     /* scale output */
     
     scale = forward ? 1./ND : 2.;
-    { register float *xi=x, *xe=x+ND;
+    { register t_float *xi=x, *xe=x+ND;
         while ( xi < xe )
             *xi++ *= scale;
     }
 }
 
-/* bitreverse places float array x containing N/2 complex values
+/* bitreverse places t_float array x containing N/2 complex values
  into bit-reversed order */
 
-void bitreverse( float *x, int N )
+void bitreverse( t_float *x, int N )
 
 {
-    float   rtemp,itemp;
+    t_float   rtemp,itemp;
     int     i,j,
     m;
     
@@ -676,14 +676,14 @@
     }
 }
 
-void init_rdft(int n, int *ip, float *w)
+void init_rdft(int n, int *ip, t_float *w)
 {
     
     int nw,
     nc;
     
-    //  void  makewt(int nw, int *ip, float *w);
-    //  void  makect(int nc, int *ip, float *c);
+    //  void  makewt(int nw, int *ip, t_float *w);
+    //  void  makect(int nc, int *ip, t_float *c);
     
     nw = n >> 2;
     lpp_makewt(nw, ip, w);
@@ -695,18 +695,18 @@
 }
 
 
-void rdft(int n, int isgn, float *a, int *ip, float *w)
+void rdft(int n, int isgn, t_float *a, int *ip, t_float *w)
 {
     
     int   j,
     nw,
     nc;
     
-    float   xi;
+    t_float   xi;
     
-    // void   bitrv2(int n, int *ip, float *a),
-    //    cftsub(int n, float *a, float *w),
-    //    rftsub(int n, float *a, int nc, float *c);
+    // void   bitrv2(int n, int *ip, t_float *a),
+    //    cftsub(int n, t_float *a, t_float *w),
+    //    rftsub(int n, t_float *a, int nc, t_float *c);
     
     
     nw = ip[0];
@@ -751,10 +751,10 @@
 }
 
 
-void bitrv2(int n, int *ip, float *a)
+void bitrv2(int n, int *ip, t_float *a)
 {
     int j, jj1, k, k1, l, m, m2;
-    float xr, xi;
+    t_float xr, xi;
     
     ip[0] = 0;
     l = n;
@@ -813,11 +813,11 @@
 }
 
 
-void cftsub(int n, float *a, float *w)
+void cftsub(int n, t_float *a, t_float *w)
 {
     int j, jj1, j2, j3, k, k1, ks, l, m;
-    float wk1r, wk1i, wk2r, wk2i, wk3r, wk3i;
-    float x0r, x0i, x1r, x1i, x2r, x2i, x3r, x3i;
+    t_float wk1r, wk1i, wk2r, wk2i, wk3r, wk3i;
+    t_float x0r, x0i, x1r, x1i, x2r, x2i, x3r, x3i;
     
     l = 2;
     
@@ -936,10 +936,10 @@
 }
 
 
-void rftsub(int n, float *a, int nc, float *c)
+void rftsub(int n, t_float *a, int nc, t_float *c)
 {
     int j, k, kk, ks;
-    float wkr, wki, xr, xi, yr, yi;
+    t_float wkr, wki, xr, xi, yr, yi;
     
     ks = (nc << 2) / n;
     kk = 0;
@@ -961,11 +961,11 @@
 }
 
 
-void makewt(int nw, int *ip, float *w)
+void makewt(int nw, int *ip, t_float *w)
 {
-    //    void bitrv2(int n, int *ip, float *a);
+    //    void bitrv2(int n, int *ip, t_float *a);
     int nwh, j;
-    float delta, x, y;
+    t_float delta, x, y;
     
     ip[0] = nw;
     ip[1] = 1;
@@ -989,10 +989,10 @@
 }
 
 
-void makect(int nc, int *ip, float *c)
+void makect(int nc, int *ip, t_float *c)
 {
     int nch, j;
-    float delta;
+    t_float delta;
     
     ip[1] = nc;
     if (nc > 1) {
--- pd-lyonpotpourri.orig/counter~.c
+++ pd-lyonpotpourri/counter~.c
@@ -10,7 +10,7 @@
 typedef struct _counter
 {
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   long current;
   long min;
   long max;
@@ -66,7 +66,7 @@
 
 void *counter_new(t_symbol *s, int argc, t_atom *argv)
 {
-  float farg;
+  t_float farg;
   t_counter *x = (t_counter *)pd_new(counter_class);
   (void)s;
   outlet_new(&x->x_obj, gensym("signal"));
--- pd-lyonpotpourri.orig/distortion~.c
+++ pd-lyonpotpourri/distortion~.c
@@ -10,10 +10,10 @@
 {
 
   t_object x_obj;
-  float x_f;
-  float knee;
-  float cut;
-  float rescale ;
+  t_float x_f;
+  t_float knee;
+  t_float cut;
+  t_float rescale ;
   short mute ;
   short case1;
 } t_distortion;
@@ -66,16 +66,16 @@
 t_int *distortion1_perform(t_int *w)
 {
 
-  float rectified_sample, in_sample;
+  t_float rectified_sample, in_sample;
 
   t_distortion *x = (t_distortion *) (w[1]);
-  float *in = (t_float *)(w[2]);
-  float *out = (t_float *)(w[5]);
+  t_float *in = (t_float *)(w[2]);
+  t_float *out = (t_float *)(w[5]);
   int n = (int)(w[6]);
 
-  float knee = x->knee;
-  float cut = x->cut;
-  float rescale = x->rescale;
+  t_float knee = x->knee;
+  t_float cut = x->cut;
+  t_float rescale = x->rescale;
 
 
   if( x->mute ) {
@@ -107,19 +107,19 @@
 t_int *distortion2_perform(t_int *w)
 {
 
-  float rectified_sample, in_sample;
+  t_float rectified_sample, in_sample;
 
   t_distortion *x = (t_distortion *) (w[1]);
-  float *in = (t_float *)(w[2]);
-  float *data1 = (t_float *)(w[3]);
-  float *data2 = (t_float *)(w[4]);
-  float *out = (t_float *)(w[5]);
+  t_float *in = (t_float *)(w[2]);
+  t_float *data1 = (t_float *)(w[3]);
+  t_float *data2 = (t_float *)(w[4]);
+  t_float *out = (t_float *)(w[5]);
   int n = (int)(w[6]);
   //  double fabs();
 
-  float knee = x->knee;
-  float cut = x->cut;
-  float rescale = x->rescale;
+  t_float knee = x->knee;
+  t_float cut = x->cut;
+  t_float rescale = x->rescale;
 
 
   if( x->mute ) {
@@ -159,19 +159,19 @@
 t_int *distortion3_perform(t_int *w)
 {
 
-  float rectified_sample, in_sample;
+  t_float rectified_sample, in_sample;
 
   t_distortion *x = (t_distortion *) (w[1]);
-  float *in = (t_float *)(w[2]);
-  float *data1 = (t_float *)(w[3]);
-  float *data2 = (t_float *)(w[4]);
-  float *out = (t_float *)(w[5]);
+  t_float *in = (t_float *)(w[2]);
+  t_float *data1 = (t_float *)(w[3]);
+  t_float *data2 = (t_float *)(w[4]);
+  t_float *out = (t_float *)(w[5]);
   int n = (int)(w[6]);
   //  double fabs();
 
-  float knee = x->knee;
-  float cut = x->cut;
-  float rescale = x->rescale;
+  t_float knee = x->knee;
+  t_float cut = x->cut;
+  t_float rescale = x->rescale;
   short case1 = x->case1;
 
   if( x->mute ) {
--- pd-lyonpotpourri.orig/dmach~.c
+++ pd-lyonpotpourri/dmach~.c
@@ -12,9 +12,9 @@
 
 typedef struct
 {
-  float trigger_point;
-  float increment;
-  float amplitude;
+  t_float trigger_point;
+  t_float increment;
+  t_float amplitude;
 } t_attack;
 
 typedef struct
@@ -27,8 +27,8 @@
 
 typedef struct
 {
-  float beats; // how many beats in this pattern
-  float dsamps; //duration of pattern in samples
+  t_float beats; // how many beats in this pattern
+  t_float dsamps; //duration of pattern in samples
   t_drumline *drumlines;
 } t_pattern;
 
@@ -36,22 +36,22 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
 
   short mute; // global mute
-  float clocker; // global sample counter clock
-  float tempo;
-  float tempo_factor; // multiplier to get actual beat duration
+  t_float clocker; // global sample counter clock
+  t_float tempo;
+  t_float tempo_factor; // multiplier to get actual beat duration
   t_pattern *patterns; // contains all drum patterns
   short *stored_patterns;// which locations contain a pattern
-  float *gtranspose;// transpose factor for each individual drum slot
-  float *gains; // gain factor for each individual drum slot
-  float *current_increment;// maintains increment for sustained output
+  t_float *gtranspose;// transpose factor for each individual drum slot
+  t_float *gains; // gain factor for each individual drum slot
+  t_float *current_increment;// maintains increment for sustained output
   int this_pattern; // number of current pattern
   int next_pattern; // number of pattern to call at end of current pattern
-  float global_gain;
-  float global_transpose;
-  float sr;
+  t_float global_gain;
+  t_float global_transpose;
+  t_float sr;
   int drum_count; // number of drum slots to instantiate
   int outlet_count; // number of outlets on object
   short virgin; // no patterns stored - turn off performance
@@ -61,7 +61,7 @@
   int *sequence; // contains the sequence of bars to play
   int sequence_length; // how many bars are stored in sequence
   int seqptr; // keep track of current sequencer position
-  float zeroalias; // use this to send a coded "zero" message (i.e. bar number is zero)
+  t_float zeroalias; // use this to send a coded "zero" message (i.e. bar number is zero)
   t_atom *listdata; // for list output
   void *listraw_outlet;// send a list
   short clickincr; //flag that click increment is on (i.e. no sample and hold)
@@ -239,10 +239,10 @@
 void dmach_gain(t_dmach *x, t_floatarg slotf, t_floatarg new_gain_factor)
 {
   int slot = slotf;
-  //  float ratio;
-  //  float gain_factor;
+  //  t_float ratio;
+  //  t_float gain_factor;
   //  short *stored_patterns = x->stored_patterns;
-  float *gains = x->gains;
+  t_float *gains = x->gains;
   //  t_pattern *p = x->patterns;
   int drum_count = x->drum_count;
   //  int i,j,k;
@@ -263,7 +263,7 @@
 void dmach_transpose(t_dmach *x, t_floatarg slotf, t_floatarg new_transpose_factor)
 {
   int slot = slotf;
-  float *gtranspose = x->gtranspose;
+  t_float *gtranspose = x->gtranspose;
   int drum_count = x->drum_count;
 
   if(slot < 0 || slot > drum_count - 1) {
@@ -331,13 +331,13 @@
 
 void dmach_tempo(t_dmach *x, t_floatarg new_tempo)
 {
-  float ratio;
+  t_float ratio;
   int i, j, k;
   short *stored_patterns = x->stored_patterns;
   t_pattern *p = x->patterns;
   int drum_count = x->drum_count;
-  float sr = x->sr;
-  float tempo_factor = x->tempo_factor;
+  t_float sr = x->sr;
+  t_float tempo_factor = x->tempo_factor;
   if(new_tempo <= 0.0) {
     pd_error(0, "tempo must be greater than zero, but was %f",new_tempo);
     return;
@@ -402,9 +402,9 @@
   t_pattern *p = x->patterns;
   t_attack *ptr;
   int drum_count = x->drum_count;
-  float normalized_trigger;
-  float tempo_factor = x->tempo_factor;
-  float sr = x->sr;
+  t_float normalized_trigger;
+  t_float tempo_factor = x->tempo_factor;
+  t_float sr = x->sr;
 
   if(pnum < 0 || pnum > MAX_PATTERNS-1) {
     pd_error(0, "illegal pattern number: %d",pnum);
@@ -444,9 +444,9 @@
   t_pattern *p = x->patterns;
   t_attack *ptr;
   int drum_count = x->drum_count;
-  float normalized_trigger;
-  float tempo_factor = x->tempo_factor;
-  float sr = x->sr;
+  t_float normalized_trigger;
+  t_float tempo_factor = x->tempo_factor;
+  t_float sr = x->sr;
   int ldex = 0;
   t_atom *listdata = x->listdata;
 
@@ -475,14 +475,14 @@
 
   SETSYMBOL(listdata + ldex, gensym("readraw")); ++ldex;
 
-  SETFLOAT(listdata + ldex, (float)pnum);  ++ldex;
+  SETFLOAT(listdata + ldex, (t_float)pnum);  ++ldex;
   SETFLOAT(listdata + ldex, p[pnum].beats);  ++ldex;
 
   for(j = 0; j < drum_count; j++) {
     if(p[pnum].drumlines[j].active) {
       ptr = p[pnum].drumlines[j].attacks;
-      SETFLOAT(listdata + ldex, (float)j); ++ldex;
-      SETFLOAT(listdata + ldex, (float)(p[pnum].drumlines[j].attack_count)); ++ldex;
+      SETFLOAT(listdata + ldex, (t_float)j); ++ldex;
+      SETFLOAT(listdata + ldex, (t_float)(p[pnum].drumlines[j].attack_count)); ++ldex;
 
       for(i = 0; i < p[pnum].drumlines[j].attack_count; i++) {
         normalized_trigger = ptr->trigger_point / (tempo_factor * sr);
@@ -554,8 +554,8 @@
   t_pattern *p = x->patterns;
   t_attack *ptr;
   //  int drum_count = x->drum_count;
-  float tempo_factor = x->tempo_factor;
-  float sr = x->sr;
+  t_float tempo_factor = x->tempo_factor;
+  t_float sr = x->sr;
   short mutein;
 
   mutein = x->mute;
@@ -603,19 +603,19 @@
 {
   int pdex,i;
   int slot = 0;
-  float beatseg;
-  //  float tmpbeats;
-  float subdiv;
-  float beat_samps;
-  float tempo_factor;
+  t_float beatseg;
+  //  t_float tmpbeats;
+  t_float subdiv;
+  t_float beat_samps;
+  t_float tempo_factor;
   int attack_count;
   int local_attacks;
-  float trigger_point;
-  float val;
+  t_float trigger_point;
+  t_float val;
   int pnum;
   t_pattern *p = x->patterns;
-  float tempo = x->tempo;
-  float sr = x->sr;
+  t_float tempo = x->tempo;
+  t_float sr = x->sr;
   t_attack *tmpatks = x->tmpatks;
 
 
@@ -695,19 +695,19 @@
 {
   int pdex,i;
   int slot = 0;
-  float beatseg;
-  float tmpbeats;
-  float subdiv;
-  float beat_samps;
-  float tempo_factor;
+  t_float beatseg;
+  t_float tmpbeats;
+  t_float subdiv;
+  t_float beat_samps;
+  t_float tempo_factor;
   int attack_count;
   int local_attacks;
-  float trigger_point;
-  float val;
+  t_float trigger_point;
+  t_float val;
   int pnum;
   t_pattern *p = x->patterns;
-  float tempo = x->tempo;
-  float sr = x->sr;
+  t_float tempo = x->tempo;
+  t_float sr = x->sr;
 
   if(argc > MAX_ATTACKS + 1) {
     post("%s: %d is too long an atk message",OBJECT_NAME,argc);
@@ -820,19 +820,19 @@
 {
   int pdex,i;
   int slot = 0;
-  float beatseg;
-  float tmpbeats;
-  float subdiv;
-  float beat_samps;
-  float tempo_factor = x->tempo_factor;
+  t_float beatseg;
+  t_float tmpbeats;
+  t_float subdiv;
+  t_float beat_samps;
+  t_float tempo_factor = x->tempo_factor;
   int attack_count;
   int local_attacks;
-  float trigger_point;
-  float val;
+  t_float trigger_point;
+  t_float val;
   int pnum;
   t_pattern *p = x->patterns;
-  float tempo = x->tempo;
-  float sr = x->sr;
+  t_float tempo = x->tempo;
+  t_float sr = x->sr;
 
 
 
@@ -944,9 +944,9 @@
   /* need some freeing action here! */
   freebytes(x->patterns,MAX_PATTERNS * sizeof(t_pattern));
   freebytes(x->stored_patterns,MAX_PATTERNS * sizeof(short));
-  freebytes(x->current_increment,x->drum_count * sizeof(float));
-  freebytes(x->gtranspose,x->drum_count * sizeof(float));
-  freebytes(x->gains,x->drum_count * sizeof(float));
+  freebytes(x->current_increment,x->drum_count * sizeof(t_float));
+  freebytes(x->gtranspose,x->drum_count * sizeof(t_float));
+  freebytes(x->gains,x->drum_count * sizeof(t_float));
   freebytes(x->sequence,1024 * sizeof(int));
   freebytes(x->listdata,1024 * sizeof(t_atom));
   freebytes(x->connected,1024 * sizeof(short));
@@ -994,9 +994,9 @@
   x->listraw_outlet = outlet_new(&x->x_obj, gensym("list"));
   x->patterns = (t_pattern *) getbytes(MAX_PATTERNS * sizeof(t_pattern));
   x->stored_patterns = (short *) getbytes(MAX_PATTERNS * sizeof(short));
-  x->current_increment = (float *) getbytes(x->drum_count * sizeof(float)); // for sample + hold of increment
-  x->gtranspose = (float *) getbytes(x->drum_count * sizeof(float));
-  x->gains = (float *) getbytes(x->drum_count * sizeof(float));
+  x->current_increment = (t_float *) getbytes(x->drum_count * sizeof(t_float)); // for sample + hold of increment
+  x->gtranspose = (t_float *) getbytes(x->drum_count * sizeof(t_float));
+  x->gains = (t_float *) getbytes(x->drum_count * sizeof(t_float));
   x->sequence = (int *) getbytes(1024 * sizeof(int));
   x->listdata = (t_atom *) getbytes(1024 * sizeof(t_atom));
   x->connected = (short *) getbytes(1024 * sizeof(short));
@@ -1056,9 +1056,9 @@
   int this_pattern = x->this_pattern;
   int next_pattern = x->next_pattern;
   t_pattern *p = x->patterns;
-  float *current_increment = x->current_increment;
-  float clocker = x->clocker;
-  float dsamps = p[this_pattern].dsamps;
+  t_float *current_increment = x->current_increment;
+  t_float clocker = x->clocker;
+  t_float dsamps = p[this_pattern].dsamps;
   int drum_count = x->drum_count;
   int adex;
   /* sequence stuff */
@@ -1070,18 +1070,18 @@
   int sequence_length = x->sequence_length;
   short *connected = x->connected;
   short *muted = x->muted;
-  float *gtranspose = x->gtranspose;
-  float *gains = x->gains;
+  t_float *gtranspose = x->gtranspose;
+  t_float *gains = x->gains;
 
   /* clean pnum click outlet */
-  memset((void *)sync, 0, n * sizeof(float));
+  memset((void *)sync, 0, n * sizeof(t_float));
 
   if( x->mute || x->virgin ) {
     for(i = 0; i < drum_count; i++) {
       if(connected[i * 2 + 1]) {
         // post("cleaning outlet pair %d", i);
         trig_outlet = (t_float *) w[i * 2 + 3];
-        memset((void *)trig_outlet, 0, n * sizeof(float));
+        memset((void *)trig_outlet, 0, n * sizeof(t_float));
       }
     }
     return w + (outlet_count + 4);
@@ -1091,7 +1091,7 @@
   for(i = 0; i < drum_count; i++) {
     if(connected[i * 2 + 1]) {
       trig_outlet = (t_float *) w[i * 2 + 3];
-      memset((void *)trig_outlet, 0, n * sizeof(float));
+      memset((void *)trig_outlet, 0, n * sizeof(t_float));
     }
   }
 
@@ -1137,7 +1137,7 @@
       sync[j] = 0;
     }
     for(i = 0; i < drum_count; i++) {
-      // float locamp;
+      // t_float locamp;
       if(p[this_pattern].drumlines[i].active && ! muted[i]) {
         trig_outlet = (t_float *) w[i * 2 + 3];
         incr_outlet = (t_float *) w[i * 2 + 4];
--- pd-lyonpotpourri.orig/epluribus~.c
+++ pd-lyonpotpourri/epluribus~.c
@@ -10,7 +10,7 @@
 typedef struct _epluribus
 {
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   int incount; // how many inlets (must be at least 2)
   short inverse; // flag to look for minimum instead
 } t_epluribus;
--- pd-lyonpotpourri.orig/expflam~.c
+++ pd-lyonpotpourri/expflam~.c
@@ -13,11 +13,11 @@
 typedef struct
 {
   int attack_count; // number of triggers per flam event
-  float *attack_times; // trigger times in seconds
+  t_float *attack_times; // trigger times in seconds
   int *attack_points; // trigger times in samples
   int fdex; // current flam
-  float gainatten; // attenuation factor
-  float amp; // current amp
+  t_float gainatten; // attenuation factor
+  t_float amp; // current amp
   int atks;// number of attacks per flam
   long counter; // internal clock
   short active; // flag that flam is turned on
@@ -29,16 +29,16 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   t_flam *flams; // contain flams
-  float start_delay; // initial flam delay
-  float end_delay;// end delay
-  float atten; // attenuation factor
-  float slope;// slope of curve
+  t_float start_delay; // initial flam delay
+  t_float end_delay;// end delay
+  t_float atten; // attenuation factor
+  t_float slope;// slope of curve
   int atks;// number of attacks per flam
-  float sr;
-  float *trigvec; // hold input vector (to protect from memory sharing)
-  float *bypvec; // ditto for flamgate vector
+  t_float sr;
+  t_float *trigvec; // hold input vector (to protect from memory sharing)
+  t_float *bypvec; // ditto for flamgate vector
   short flamall; // flag to put a flam on everything
   short bypass; // flag to copy input to output without flam
   short flamgate_connected; // flag that a flamgate logical signal is connected to inlet 2
@@ -100,12 +100,12 @@
   outlet_new(&x->x_obj, gensym("signal"));
   x->flams = (t_flam *) getbytes(MAXFLAMS * sizeof(t_flam));
   for(i = 0; i < MAXFLAMS; i++) {
-    x->flams[i].attack_times = (float *) getbytes(MAXATTACKS * sizeof(float));
+    x->flams[i].attack_times = (t_float *) getbytes(MAXATTACKS * sizeof(t_float));
     x->flams[i].attack_points = (int *) getbytes(MAXATTACKS * sizeof(int));
   }
 
-  x->trigvec = (float *) getbytes(8192 * sizeof(float)); // maximum vector size
-  x->bypvec = (float *) getbytes(8192 * sizeof(float)); // maximum vector size
+  x->trigvec = (t_float *) getbytes(8192 * sizeof(t_float)); // maximum vector size
+  x->bypvec = (t_float *) getbytes(8192 * sizeof(t_float)); // maximum vector size
   x->sr = sys_getsr();
   x->start_delay = .025;
   x->end_delay = 0.1;
@@ -147,10 +147,10 @@
 {
   int i;
 
-  freebytes(x->trigvec, 8192 * sizeof(float));
-  freebytes(x->bypvec, 8192 * sizeof(float));
+  freebytes(x->trigvec, 8192 * sizeof(t_float));
+  freebytes(x->bypvec, 8192 * sizeof(t_float));
   for(i = 0; i < MAXFLAMS; i++) {
-    freebytes(x->flams[i].attack_times, MAXATTACKS * sizeof(float));
+    freebytes(x->flams[i].attack_times, MAXATTACKS * sizeof(t_float));
     freebytes(x->flams[i].attack_points, MAXATTACKS * sizeof(int));
   }
   freebytes(x->flams, MAXFLAMS * sizeof(t_flam));
@@ -161,32 +161,32 @@
 {
   int i,j,k;
   t_expflam *x = (t_expflam *) (w[1]);
-  float *in_vec = (t_float *)(w[2]);
-  float *in2_vec = (t_float *)(w[3]);
-  float *out_vec = (t_float *)(w[4]);
+  t_float *in_vec = (t_float *)(w[2]);
+  t_float *in2_vec = (t_float *)(w[3]);
+  t_float *out_vec = (t_float *)(w[4]);
   int n = (int) w[5];
 
-  float *trigvec = x->trigvec;
-  float *flamgate_vec = x->bypvec;
+  t_float *trigvec = x->trigvec;
+  t_float *flamgate_vec = x->bypvec;
   t_flam *flams = x->flams;
   int atks = x->atks;
-  float atten = x->atten;
-  float slope = x->slope;
-  float start_delay = x->start_delay;
-  float end_delay = x->end_delay;
-  float sr = x->sr;
+  t_float atten = x->atten;
+  t_float slope = x->slope;
+  t_float start_delay = x->start_delay;
+  t_float end_delay = x->end_delay;
+  t_float sr = x->sr;
   short flamgate_connected = x->flamgate_connected;
   short flamall = x->flamall;
 
   /* in flamgate mode copy input to output and return */
   if(x->bypass) {
-    memcpy( (void *)out_vec, (void *)in_vec, n * sizeof(float) );
+    memcpy( (void *)out_vec, (void *)in_vec, n * sizeof(t_float) );
     return (w+6);
   }
   /* copy input vectors */
-  memcpy( (void *)flamgate_vec, (void *)in2_vec, n * sizeof(float) );// the order of these mcopies matters
-  memcpy( (void *)trigvec, (void *)in_vec, n * sizeof(float) );
-  memcpy( (void *)out_vec, (void *)in_vec, n * sizeof(float) );// copy triggers to output for a start
+  memcpy( (void *)flamgate_vec, (void *)in2_vec, n * sizeof(t_float) );// the order of these mcopies matters
+  memcpy( (void *)trigvec, (void *)in_vec, n * sizeof(t_float) );
+  memcpy( (void *)out_vec, (void *)in_vec, n * sizeof(t_float) );// copy triggers to output for a start
 
   /* look for activation triggers */
   for(i = 0; i < n; i++) {
@@ -211,7 +211,7 @@
         flams[j].atks = atks;
 
         for(k = 1; k < atks; k++) {
-          flams[j].attack_times[k] = start_delay + (end_delay - start_delay) * ((1.0 - exp((float)k * slope/((float)atks-1.0)))/(1.0-exp(slope)));
+          flams[j].attack_times[k] = start_delay + (end_delay - start_delay) * ((1.0 - exp((t_float)k * slope/((t_float)atks-1.0)))/(1.0-exp(slope)));
           flams[j].attack_times[k] += flams[j].attack_times[k - 1];
           flams[j].attack_points[k] = flams[j].attack_times[k] * sr + i;
         }
--- pd-lyonpotpourri.orig/flanjah~.c
+++ pd-lyonpotpourri/flanjah~.c
@@ -14,32 +14,32 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   //
-  float *sinetab;
-  float si_factor;
-  float osc1_phs;
-  float osc1_si;
-  float si1;
-  float osc2_phs;
-  float osc2_si;
-  float si2;
+  t_float *sinetab;
+  t_float si_factor;
+  t_float osc1_phs;
+  t_float osc1_si;
+  t_float si1;
+  t_float osc2_phs;
+  t_float osc2_si;
+  t_float si2;
   //
-  float speed1;
-  float speed2;
-  float feedback;
-  float maxdel;
-  float depth;
+  t_float speed1;
+  t_float speed2;
+  t_float feedback;
+  t_float maxdel;
+  t_float depth;
   //
-  float *ddl1 ;
+  t_float *ddl1 ;
   int ddl1_len;
   int ddl1_phs;
-  float *ddl2 ;
+  t_float *ddl2 ;
   int ddl2_len;
   int ddl2_phs;
   //
-  float tap1;
-  float tap2;
+  t_float tap1;
+  t_float tap2;
   //
   int feedback_connected;
   int speed1_connected;
@@ -48,7 +48,7 @@
   short connected[8];
   int feedback_protect;
   short mute;
-  float sr;
+  t_float sr;
 } t_flanjah;
 
 t_int *flanjah_perform(t_int *w);
@@ -85,9 +85,9 @@
 }
 
 void flanjah_dsp_free( t_flanjah *x ) {
-  freebytes(x->sinetab, F_LEN * sizeof(float));
-  freebytes(x->ddl1, (x->ddl1_len + 2) * sizeof(float));
-  freebytes(x->ddl2, (x->ddl2_len + 2) * sizeof(float));
+  freebytes(x->sinetab, F_LEN * sizeof(t_float));
+  freebytes(x->ddl1, (x->ddl1_len + 2) * sizeof(t_float));
+  freebytes(x->ddl2, (x->ddl2_len + 2) * sizeof(t_float));
 }
 
 
@@ -101,34 +101,34 @@
   t_float *depth_vec = (t_float *)(w[6]);
   t_float *out1 = (t_float *)(w[7]);
   int n = (int) w[8];
-  float fdelay1, fdelay2;
+  t_float fdelay1, fdelay2;
   int idelay1, idelay2;
-  float insamp1;//, insamp2;
-  float frac;
+  t_float insamp1;//, insamp2;
+  t_float frac;
   int index1, index2;
-  float m1, m2;
+  t_float m1, m2;
   //
-  float osc2_phs = x->osc2_phs;
+  t_float osc2_phs = x->osc2_phs;
   int ddl2_len = x->ddl2_len;
-  float osc2_si = x->osc2_si;
-  float *ddl2 = x->ddl2;
+  t_float osc2_si = x->osc2_si;
+  t_float *ddl2 = x->ddl2;
   int ddl2_phs = x->ddl2_phs;
-  float *ddl1 = x->ddl1;
-  float *sinetab = x->sinetab;
+  t_float *ddl1 = x->ddl1;
+  t_float *sinetab = x->sinetab;
   int ddl1_phs = x->ddl1_phs;
   int ddl1_len = x->ddl1_len;
-  float osc1_phs = x->osc1_phs;
-  float osc1_si = x->osc1_si;
-  float tap1 = x->tap1;
-  float tap2 = x->tap2;
-  float feedback = x->feedback;
+  t_float osc1_phs = x->osc1_phs;
+  t_float osc1_si = x->osc1_si;
+  t_float tap1 = x->tap1;
+  t_float tap2 = x->tap2;
+  t_float feedback = x->feedback;
   int feedback_connected = x->feedback_connected;
   int speed1_connected = x->speed1_connected;
   int speed2_connected = x->speed2_connected;
   int depth_connected = x->depth_connected;
-  float si_factor = x->si_factor;
+  t_float si_factor = x->si_factor;
   int feedback_protect = x->feedback_protect;
-  float depth_factor = x->depth;
+  t_float depth_factor = x->depth;
   /**********************/
 
   if( x->mute ) {
@@ -169,8 +169,8 @@
       depth_factor = 1.;
     }
 
-    fdelay1 = sinetab[ (int) osc1_phs ] * (float) ddl1_len * depth_factor;
-    fdelay2 = sinetab[ (int) osc2_phs ] * (float) ddl2_len * depth_factor;
+    fdelay1 = sinetab[ (int) osc1_phs ] * (t_float) ddl1_len * depth_factor;
+    fdelay2 = sinetab[ (int) osc2_phs ] * (t_float) ddl2_len * depth_factor;
 
     // DSP Proper
 
@@ -266,7 +266,7 @@
     pd_error(0, "above maximum of 360 seconds");
   }
 
-  x->si_factor = (float)F_LEN / x->sr;
+  x->si_factor = (t_float)F_LEN / x->sr;
   x->ddl1_len = x->maxdel * x->sr ;
   x->ddl1_phs = 0;
   x->ddl2_len = x->maxdel * x->sr ;
@@ -278,15 +278,15 @@
 
   x->tap1 = x->tap2 = 0;
   if(!initialized) {
-    x->ddl1 = (float *) getbytes((x->ddl1_len + 2) * sizeof(float));
-    x->ddl2 = (float *) getbytes((x->ddl2_len + 2) * sizeof(float));
-    x->sinetab = (float *) getbytes(F_LEN * sizeof(float));
+    x->ddl1 = (t_float *) getbytes((x->ddl1_len + 2) * sizeof(t_float));
+    x->ddl2 = (t_float *) getbytes((x->ddl2_len + 2) * sizeof(t_float));
+    x->sinetab = (t_float *) getbytes(F_LEN * sizeof(t_float));
     for( i = 0; i < F_LEN ; i++ ) {
-      x->sinetab[i] = 0.51 - 0.47 * cos( TWOPI * (float) i / (float) F_LEN);
+      x->sinetab[i] = 0.51 - 0.47 * cos( TWOPI * (t_float) i / (t_float) F_LEN);
     }
   } else {
-    x->ddl1 = (float *) realloc(x->ddl1,(x->ddl1_len + 2) * sizeof(float));
-    x->ddl2 = (float *) realloc(x->ddl2,(x->ddl2_len + 2) * sizeof(float));
+    x->ddl1 = (t_float *) realloc(x->ddl1,(x->ddl1_len + 2) * sizeof(t_float));
+    x->ddl2 = (t_float *) realloc(x->ddl2,(x->ddl2_len + 2) * sizeof(t_float));
   }
 }
 
--- pd-lyonpotpourri.orig/granola~.c
+++ pd-lyonpotpourri/granola~.c
@@ -9,23 +9,23 @@
 {
     
     t_object x_obj;
-    float x_f;
-    float *gbuf;
+    t_float x_f;
+    t_float *gbuf;
     long grainsamps;
     long grainsamps_old;
     long buflen; // length of buffer
     long buflen_old;
     int maxgrainsamps; // set maximum delay in ms.
-    float grain_duration; // user grain duration in seconds
-    float sr;
-    float *grainenv;
+    t_float grain_duration; // user grain duration in seconds
+    t_float sr;
+    t_float *grainenv;
     long gpt1; // grain pointer 1
     long gpt2; // grain pointer 2
     long gpt3; // grain pointer 3
-    float phs1; // phase 1
-    float phs2; // phase 2
-    float phs3; // phase 3
-    float incr;
+    t_float phs1; // phase 1
+    t_float phs2; // phase 2
+    t_float phs3; // phase 3
+    t_float incr;
     long curdel;
     short mute_me;
     short iconnect;
@@ -62,8 +62,8 @@
 */
 void granola_dsp_free(t_granola *x)
 {
-    freebytes(x->gbuf,x->buflen * sizeof(float));
-    freebytes(x->grainenv,x->grainsamps * sizeof(float));
+    freebytes(x->gbuf,x->buflen * sizeof(t_float));
+    freebytes(x->grainenv,x->grainsamps * sizeof(t_float));
 }
 
 
@@ -92,7 +92,7 @@
     x->grainsamps = newsamps; // will use for shrinkage
     x->buflen = x->grainsamps * 4;
     for(i = 0; i < x->grainsamps; i++ ) {
-        x->grainenv[i] = .5 + (-.5 * cos( TWOPI * ((float)i/(float)x->grainsamps) ) );
+        x->grainenv[i] = .5 + (-.5 * cos( TWOPI * ((t_float)i/(t_float)x->grainsamps) ) );
     }
     x->gpt1 = 0;
     x->gpt2 = x->grainsamps / 3.;
@@ -136,19 +136,19 @@
     x->buflen = x->grainsamps * 4;
     // first time only
     if(x->gbuf == NULL) {
-        x->gbuf = (float *) getbytes(x->buflen * sizeof(float));
-        x->grainenv = (float *) getbytes(x->grainsamps * sizeof(float));
+        x->gbuf = (t_float *) getbytes(x->buflen * sizeof(t_float));
+        x->grainenv = (t_float *) getbytes(x->grainsamps * sizeof(t_float));
         x->incr = .5;
         x->mute_me = 0;
     }
     // or realloc if necessary
     // *resizebytes(void *x, size_t oldsize, size_t newsize);
     else {
-        x->gbuf = (float *) resizebytes(x->gbuf, x->buflen_old * sizeof(float), x->buflen * sizeof(float));
-        x->grainenv = (float *) resizebytes(x->grainenv, x->grainsamps_old * sizeof(float), x->grainsamps * sizeof(float));
+        x->gbuf = (t_float *) resizebytes(x->gbuf, x->buflen_old * sizeof(t_float), x->buflen * sizeof(t_float));
+        x->grainenv = (t_float *) resizebytes(x->grainenv, x->grainsamps_old * sizeof(t_float), x->grainsamps * sizeof(t_float));
     }
     for(i = 0; i < x->grainsamps; i++ ) {
-        x->grainenv[i] = .5 + (-.5 * cos(TWOPI * ((float)i/(float)x->grainsamps)));
+        x->grainenv[i] = .5 + (-.5 * cos(TWOPI * ((t_float)i/(t_float)x->grainsamps)));
     }
     x->gpt1 = 0;
     x->gpt2 = x->grainsamps / 3.;
@@ -162,9 +162,9 @@
 
 t_int *granola_perform(t_int *w)
 {
-    float  outsamp ;
+    t_float  outsamp ;
     int iphs_a, iphs_b;
-    float frac;
+    t_float frac;
     
     
     /****/
@@ -177,15 +177,15 @@
     long gpt1 = x->gpt1;
     long gpt2 = x->gpt2;
     long gpt3 = x->gpt3;
-    float phs1 = x->phs1;
-    float phs2 = x->phs2;
-    float phs3 = x->phs3;
+    t_float phs1 = x->phs1;
+    t_float phs2 = x->phs2;
+    t_float phs3 = x->phs3;
     long curdel = x->curdel;
     long buflen = x->buflen;
     long grainsamps = x->grainsamps;
-    float *grainenv = x->grainenv;
-    float *gbuf = x->gbuf;
-    float incr = x->incr;
+    t_float *grainenv = x->grainenv;
+    t_float *gbuf = x->gbuf;
+    t_float incr = x->incr;
     
     if( x->mute_me ) {
         while( n-- ) {
--- pd-lyonpotpourri.orig/granulesf~.c
+++ pd-lyonpotpourri/granulesf~.c
@@ -8,16 +8,16 @@
 static t_class *granulesf_class;
 
 typedef struct {
-  float amplitude;
-  float panL;
-  float panR;
+  t_float amplitude;
+  t_float panL;
+  t_float panR;
   long delay; // samples to wait until event starts
   long duration;// length in samples of event
-  float phase; // phase for frequency oscillator
-  float ephase; // phase for envelope
-  float si; // sampling increment for frequency
-  float esi; // sampling increment for envelope
-  float endframe;//boundary frame (extremes are 0 or size-1); approach depends on sign of si
+  t_float phase; // phase for frequency oscillator
+  t_float ephase; // phase for envelope
+  t_float si; // sampling increment for frequency
+  t_float esi; // sampling increment for envelope
+  t_float endframe;//boundary frame (extremes are 0 or size-1); approach depends on sign of si
   short active;//status of this slot (inactives are available for new grains)
 } t_grain;
 
@@ -32,44 +32,44 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   t_pdbuffer *wavebuf; // holds waveform samples
   t_pdbuffer *windowbuf; // holds window samples
   t_symbol *wavename; // name of waveform buffer
   t_symbol *windowname; // name of window buffer
 
-  float sr; // sampling rate
+  t_float sr; // sampling rate
   short mute;
   short hosed; // buffers are bad
   /* Global grain data*/
   long events; // number of events in a block
   long horizon; // length of block for random events
-  float min_incr; // minimum frequency for a grain
-  float max_incr; // maximum frequency for a grain
-  float minpan; // minimum pan for a grain
-  float maxpan; // maximum pan for a grain
-  float minamp; // minimum amplitude for a grain
-  float maxamp; // maximum amplitude for a grain
-  float mindur; // minimum duration for a grain
-  float maxdur; // maximum duration for a grain
+  t_float min_incr; // minimum frequency for a grain
+  t_float max_incr; // maximum frequency for a grain
+  t_float minpan; // minimum pan for a grain
+  t_float maxpan; // maximum pan for a grain
+  t_float minamp; // minimum amplitude for a grain
+  t_float maxamp; // maximum amplitude for a grain
+  t_float mindur; // minimum duration for a grain
+  t_float maxdur; // maximum duration for a grain
   t_grain *grains; // stores grain data
-  float *pitchscale; // contains a frequency grid for pitch constraint
+  t_float *pitchscale; // contains a frequency grid for pitch constraint
   int pitchsteps; // number of members in scale
-  float transpose; // factor for scaling all pitches
-  float pitch_deviation; // factor to adjust scaled pitches
+  t_float transpose; // factor for scaling all pitches
+  t_float pitch_deviation; // factor to adjust scaled pitches
   short steady; // toggles pulsed rhythmic activity
-  float lowblock_increment; //lowest allowed frequency
-  float highblock_increment;// highest allowed frequency
-  float mindur_ms;//store duration in ms
-  float maxdur_ms;//ditto
-  float horizon_ms;//ditto
+  t_float lowblock_increment; //lowest allowed frequency
+  t_float highblock_increment;// highest allowed frequency
+  t_float mindur_ms;//store duration in ms
+  t_float maxdur_ms;//ditto
+  t_float horizon_ms;//ditto
   short constrain_scale;//flag to only use bounded portion of scale rather than all of it
   short nopan;//stereo channels go straight out, mono goes to center
   long minskip;//minimum inskip in samples (default = zero)
   long maxskip;//maximum inskip in samples (default = maximum possible given dur/increment of note)
   long b_nchans;//channels in buffer (always 1 for Pd, at least today)
   long b_frames;//frames in waveform buffer
-  float retro_odds;//odds to play sample backwards
+  t_float retro_odds;//odds to play sample backwards
   short interpolate;//flag to interpolate samples - on by default
   short interpolate_envelope;//flag to interpolate envelope
 } t_granulesf;
@@ -88,7 +88,7 @@
 static void granulesf_lowblock(t_granulesf *x, t_floatarg f);
 static void granulesf_highblock(t_granulesf *x, t_floatarg f);
 static void granulesf_events(t_granulesf *x, t_floatarg e);
-static float granulesf_boundrand(float min, float max);
+static t_float granulesf_boundrand(t_float min, t_float max);
 static void *granulesf_grist(t_granulesf *x, t_symbol *msg, int argc, t_atom *argv);
 static void *granulesf_grain(t_granulesf *x, t_symbol *msg, int argc, t_atom *argv);
 static void *granulesf_setscale(t_granulesf *x, t_symbol *msg, int argc, t_atom *argv);
@@ -98,7 +98,7 @@
 static void granulesf_constrain_scale(t_granulesf *x, t_floatarg toggle);
 static void granulesf_dsp_free(t_granulesf *x);
 static void granulesf_init(t_granulesf *x,short initialized);
-static void granulesf_constrain(int *index_min, int *index_max, float min_incr, float max_incr, float *scale, int steps);
+static void granulesf_constrain(int *index_min, int *index_max, t_float min_incr, t_float max_incr, t_float *scale, int steps);
 static void granulesf_interpolate(t_granulesf *x, t_floatarg toggle);
 static void granulesf_nopan(t_granulesf *x, t_floatarg toggle);
 static void granulesf_retro_odds(t_granulesf *x, t_floatarg o);
@@ -222,7 +222,7 @@
 void *granulesf_setscale(t_granulesf *x, t_symbol *msg, int argc, t_atom *argv)
 {
   int i;
-  float *pitchscale = x->pitchscale;
+  t_float *pitchscale = x->pitchscale;
   if( argc >= MAXSCALE ) {
     pd_error(0, "%d is the maximum size scale", MAXSCALE);
     return 0;
@@ -238,7 +238,7 @@
   return 0;
 }
 
-void granulesf_constrain(int *index_min, int *index_max, float min_incr, float max_incr, float *scale, int steps)
+void granulesf_constrain(int *index_min, int *index_max, t_float min_incr, t_float max_incr, t_float *scale, int steps)
 {
   int imax = steps - 1;
   int imin = 0;
@@ -272,33 +272,33 @@
   long eframes = x->windowbuf->b_frames;
   long minskip = x->minskip;
   long maxskip = x->maxskip;
-  float retro_odds = x->retro_odds;
+  t_float retro_odds = x->retro_odds;
   long horizon = x->horizon; // length of block for random events
-  float mindur = x->mindur;
-  float maxdur = x->maxdur;
-  float min_incr = x->min_incr; // minimum frequency for a grain
-  float max_incr = x->max_incr; // maximum frequency for a grain
-  float minpan = x->minpan; // minimum pan for a grain
-  float maxpan = x->maxpan; // maximum pan for a grain
-  float minamp = x->minamp; // minimum amplitude for a grain
-  float maxamp = x->maxamp; // maximum amplitude for a grain
-  float transpose = x->transpose; // pitch scalar
-  float lowblock_increment = x->lowblock_increment;
-  float highblock_increment = x->highblock_increment;
+  t_float mindur = x->mindur;
+  t_float maxdur = x->maxdur;
+  t_float min_incr = x->min_incr; // minimum frequency for a grain
+  t_float max_incr = x->max_incr; // maximum frequency for a grain
+  t_float minpan = x->minpan; // minimum pan for a grain
+  t_float maxpan = x->maxpan; // maximum pan for a grain
+  t_float minamp = x->minamp; // minimum amplitude for a grain
+  t_float maxamp = x->maxamp; // maximum amplitude for a grain
+  t_float transpose = x->transpose; // pitch scalar
+  t_float lowblock_increment = x->lowblock_increment;
+  t_float highblock_increment = x->highblock_increment;
   short steady = x->steady;
-  float pitch_deviation = x->pitch_deviation;
-  float pdev = 0;
-  float pdev_invert = 0;
-  //  float pscale;
-  float pan;
+  t_float pitch_deviation = x->pitch_deviation;
+  t_float pdev = 0;
+  t_float pdev_invert = 0;
+  //  t_float pscale;
+  t_float pan;
   int index_min, index_max;
   int steps = x->pitchsteps;
-  float *scale = x->pitchscale;
+  t_float *scale = x->pitchscale;
   int windex;
   short inserted = 0;
   short constrain_scale = x->constrain_scale;
   t_grain *grains = x->grains;
-  float tmp;
+  t_float tmp;
 
   if( steps < 2 ) {
     pd_error(0, "scale is undefined");
@@ -313,9 +313,9 @@
     for(j = 0; j < MAXGRAINS; j++ ) {
       if(!grains[j].active) {
         if(steady) {
-          grains[j].delay = (float)(i * horizon) / (float) x->events ;
+          grains[j].delay = (t_float)(i * horizon) / (t_float) x->events ;
         } else {
-          grains[j].delay = granulesf_boundrand(0.0,(float) horizon);
+          grains[j].delay = granulesf_boundrand(0.0,(t_float) horizon);
         }
         grains[j].duration = (long) granulesf_boundrand(mindur, maxdur);
         grains[j].phase = 0.0;
@@ -329,14 +329,14 @@
 
         if(constrain_scale) {
           granulesf_constrain(&index_min,&index_max,min_incr, max_incr, scale, steps);
-          windex = (int) granulesf_boundrand((float)index_min, (float)index_max);
+          windex = (int) granulesf_boundrand((t_float)index_min, (t_float)index_max);
         } else {
-          windex = (int) granulesf_boundrand(0.0, (float)(steps));
+          windex = (int) granulesf_boundrand(0.0, (t_float)(steps));
         }
         grains[j].si = transpose * scale[windex];
         //  post("windex %d scale[w] %f transpose %f si %f",windex, scale[windex], transpose, grains[j].si );
         grainframes = grains[j].duration * grains[j].si;
-        grains[j].esi =  (float) eframes / (float) grains[j].duration;
+        grains[j].esi =  (t_float) eframes / (t_float) grains[j].duration;
 
         if( pitch_deviation ) {
           grains[j].si *= granulesf_boundrand(pdev_invert,pdev);
@@ -371,10 +371,10 @@
           grains[j].endframe = grainframes - 1;
         } else {
           if(maxskip > b_frames - grainframes) {
-            grains[j].phase = granulesf_boundrand((float)minskip, (float) (b_frames - grainframes));
+            grains[j].phase = granulesf_boundrand((t_float)minskip, (t_float) (b_frames - grainframes));
             //post("1. minskip %d maxskip %d",minskip,b_frames - grainframes);
           } else {
-            grains[j].phase = granulesf_boundrand((float)minskip, (float)maxskip);
+            grains[j].phase = granulesf_boundrand((t_float)minskip, (t_float)maxskip);
             //post("2. minskip %d maxskip %d",minskip,maxskip);
           }
           grains[j].endframe = grains[j].phase + grainframes - 1;
@@ -409,25 +409,25 @@
   long eframes = x->windowbuf->b_frames;
   long b_frames = x->wavebuf->b_frames;
   //  long b_nchans = x->wavebuf->b_nchans;
-  //  float sr = x->sr;
+  //  t_float sr = x->sr;
   long horizon = x->horizon; // length of block for random events
-  float mindur = x->mindur;
-  float maxdur = x->maxdur;
-  float min_incr = x->min_incr; // minimum incr for a grain (must be positive!)
-  float max_incr = x->max_incr; // maximum incr for a grain (must be positive!)
-  float minpan = x->minpan; // minimum pan for a grain
-  float maxpan = x->maxpan; // maximum pan for a grain
-  float minamp = x->minamp; // minimum amplitude for a grain
-  float maxamp = x->maxamp; // maximum amplitude for a grain
-  float transpose = x->transpose; // pitch scalar
+  t_float mindur = x->mindur;
+  t_float maxdur = x->maxdur;
+  t_float min_incr = x->min_incr; // minimum incr for a grain (must be positive!)
+  t_float max_incr = x->max_incr; // maximum incr for a grain (must be positive!)
+  t_float minpan = x->minpan; // minimum pan for a grain
+  t_float maxpan = x->maxpan; // maximum pan for a grain
+  t_float minamp = x->minamp; // minimum amplitude for a grain
+  t_float maxamp = x->maxamp; // maximum amplitude for a grain
+  t_float transpose = x->transpose; // pitch scalar
   long minskip = x->minskip;
   long maxskip = x->maxskip;
   short steady = x->steady;
-  float retro_odds = x->retro_odds;
-  float pan;
+  t_float retro_odds = x->retro_odds;
+  t_float pan;
   t_grain *grains = x->grains;
   short inserted;
-  float tmp;
+  t_float tmp;
 
   for( i = 0; i < x->events; i++ ) {
     inserted = 0;
@@ -435,9 +435,9 @@
       if(!grains[j].active) {
         grains[j].active = 1;
         if(steady) {
-          grains[j].delay = (float)(i * horizon) / (float) x->events ;
+          grains[j].delay = (t_float)(i * horizon) / (t_float) x->events ;
         } else {
-          grains[j].delay = granulesf_boundrand(0.0,(float) horizon);
+          grains[j].delay = granulesf_boundrand(0.0,(t_float) horizon);
         }
         grains[j].duration = (long) granulesf_boundrand(mindur, maxdur);//frames for this grain
         grains[j].ephase = 0.0;
@@ -449,8 +449,8 @@
         grains[j].si = transpose * granulesf_boundrand(min_incr, max_incr);
 
         grainframes = grains[j].duration * grains[j].si;//frames to be read from buffer
-        // grains[j].esi =  (float) eframes / (float) grainframes;
-        grains[j].esi =  (float) eframes / (float) grains[j].duration;
+        // grains[j].esi =  (t_float) eframes / (t_float) grainframes;
+        grains[j].esi =  (t_float) eframes / (t_float) grains[j].duration;
         if(grainframes >= b_frames ) {
           pd_error(0, "grain size %.0ld is too long for buffer which is %ld",grainframes, b_frames);
           grains[j].active = 0;
@@ -462,10 +462,10 @@
           grains[j].endframe = grainframes - 1;
         } else {
           if(maxskip > b_frames - grainframes) {
-            grains[j].phase = granulesf_boundrand((float)minskip, (float) (b_frames - grainframes));
+            grains[j].phase = granulesf_boundrand((t_float)minskip, (t_float) (b_frames - grainframes));
             //post("1. minskip %d maxskip %d",minskip,b_frames - grainframes);
           } else {
-            grains[j].phase = granulesf_boundrand((float)minskip, (float)maxskip);
+            grains[j].phase = granulesf_boundrand((t_float)minskip, (t_float)maxskip);
             //post("2. minskip %d maxskip %d",minskip,maxskip);
           }
           grains[j].endframe = grains[j].phase + grainframes - 1;
@@ -496,12 +496,12 @@
 {
   short inserted;
   int j;
-  float duration, incr, amplitude, pan;
+  t_float duration, incr, amplitude, pan;
   t_grain *grains;
   long eframes;
   long frames;
-  float sr;
-  float skip;
+  t_float sr;
+  t_float skip;
 
   grains = x->grains;
   eframes = x->windowbuf->b_frames;
@@ -548,7 +548,7 @@
       grains[j].amplitude = amplitude * .707;
       grains[j].panL = amplitude * cos(pan * PIOVERTWO);
       grains[j].panR = amplitude * sin(pan * PIOVERTWO);
-      grains[j].esi =  (float)eframes / (float)grains[j].duration;
+      grains[j].esi =  (t_float)eframes / (t_float)grains[j].duration;
       grains[j].si = incr;
       grains[j].active = 1;
       return 0;
@@ -560,9 +560,9 @@
 
 }
 
-float granulesf_boundrand(float min, float max)
+t_float granulesf_boundrand(t_float min, t_float max)
 {
-  return min + (max-min) * ((float) (rand() % RAND_MAX)/ (float) RAND_MAX);
+  return min + (max-min) * ((t_float) (rand() % RAND_MAX)/ (t_float) RAND_MAX);
 }
 
 
@@ -575,7 +575,7 @@
   x->wavebuf = (t_pdbuffer*)getbytes(sizeof(t_pdbuffer));
   x->windowbuf = (t_pdbuffer*)getbytes(sizeof(t_pdbuffer));
   srand(time(0)); //need "seed" message
-  x->pitchscale = (float *) getbytes(MAXSCALE * sizeof(float));
+  x->pitchscale = (t_float *) getbytes(MAXSCALE * sizeof(t_float));
   x->grains = (t_grain *) getbytes(MAXGRAINS * sizeof(t_grain));
 
   // default names
@@ -748,8 +748,8 @@
 t_int *granulesf_performhose(t_int *w)
 {
   //  t_granulesf *x = (t_granulesf *) (w[1]);
-  float *outputL = (t_float *)(w[3]);
-  float *outputR = (t_float *)(w[4]);
+  t_float *outputL = (t_float *)(w[3]);
+  t_float *outputR = (t_float *)(w[4]);
   int n = (int) w[5];
   while(n--) *outputL++ = *outputR++ = 0;
   return (w+6);
@@ -758,9 +758,9 @@
 t_int *granulesf_perform_no_interpolation(t_int *w)
 {
   t_granulesf *x = (t_granulesf *) (w[1]);
-  //  float *in = (t_float *)(w[2]); // ignoring input
-  float *outputL = (t_float *)(w[3]);
-  float *outputR = (t_float *)(w[4]);
+  //  t_float *in = (t_float *)(w[2]); // ignoring input
+  t_float *outputL = (t_float *)(w[3]);
+  t_float *outputR = (t_float *)(w[4]);
   int n = (int) w[5];
 
   t_pdbuffer *wavebuf = x->wavebuf;
@@ -771,14 +771,14 @@
   long b_nchans = x->b_nchans;
   long b_frames = wavebuf->b_frames;
   short nopan = x->nopan;
-  float sample1, sample2;
-  float envelope;
-  float amplitude;
-  float panL, panR;
-  float si;
-  float esi;
-  float phase;
-  float ephase;
+  t_float sample1, sample2;
+  t_float envelope;
+  t_float amplitude;
+  t_float panL, panR;
+  t_float si;
+  t_float esi;
+  t_float phase;
+  t_float ephase;
   long delay;
   long eframes = windowbuf->b_frames;
   long current_index;
@@ -883,9 +883,9 @@
 t_int *granulesf_perform(t_int *w)
 {
   t_granulesf *x = (t_granulesf *) (w[1]);
-  //  float *in = (t_float *)(w[2]); // ignoring input
-  float *outputL = (t_float *)(w[3]);
-  float *outputR = (t_float *)(w[4]);
+  //  t_float *in = (t_float *)(w[2]); // ignoring input
+  t_float *outputL = (t_float *)(w[3]);
+  t_float *outputR = (t_float *)(w[4]);
   int n = (int) w[5];
 
   t_pdbuffer *wavebuf = x->wavebuf;
@@ -897,19 +897,19 @@
   long b_frames = wavebuf->b_frames;
   short nopan = x->nopan;
   short interpolate_envelope = x->interpolate_envelope;
-  float sample1, sample2;
-  float envelope;
-  float amplitude;
-  float panL, panR;
-  float si;
-  float esi;
-  float phase;
-  float ephase;
+  t_float sample1, sample2;
+  t_float envelope;
+  t_float amplitude;
+  t_float panL, panR;
+  t_float si;
+  t_float esi;
+  t_float phase;
+  t_float ephase;
   long delay;
   long eframes = windowbuf->b_frames;
   long current_index;
-  float tsmp1, tsmp2;
-  float frac;
+  t_float tsmp1, tsmp2;
+  t_float frac;
   int i,j;
 
   if( x->mute ) {
@@ -1041,7 +1041,7 @@
 void granulesf_dsp_free(t_granulesf *x)
 {
   freebytes(x->grains, MAXGRAINS * sizeof(t_grain));
-  freebytes(x->pitchscale, MAXSCALE * sizeof(float));
+  freebytes(x->pitchscale, MAXSCALE * sizeof(t_float));
 }
 
 void granulesf_dsp(t_granulesf *x, t_signal **sp)
--- pd-lyonpotpourri.orig/granule~.c
+++ pd-lyonpotpourri/granule~.c
@@ -10,15 +10,15 @@
 
 
 typedef struct {
-  float amplitude;
-  float panL;
-  float panR;
+  t_float amplitude;
+  t_float panL;
+  t_float panR;
   long delay; // samples to wait until event starts
   long duration;// length in samples of event
-  float phase; // phase for frequency oscillator
-  float ephase; // phase for envelope
-  float si; // sampling increment for frequency
-  float esi; // sampling increment for envelope
+  t_float phase; // phase for frequency oscillator
+  t_float ephase; // phase for envelope
+  t_float si; // sampling increment for frequency
+  t_float esi; // sampling increment for envelope
 } t_grain;
 
 typedef struct {
@@ -32,37 +32,37 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   t_pdbuffer *wavebuf; // holds waveform samples
   t_pdbuffer *windowbuf; // holds window samples
   t_symbol *wavename; // name of waveform buffer
   t_symbol *windowname; // name of window buffer
 
-  float sr; // sampling rate
+  t_float sr; // sampling rate
   short mute;
   short hosed; // buffers are bad
   /* Global grain data*/
   long events; // number of events in a block
   long horizon; // length of block for random events
-  float minfreq; // minimum frequency for a grain
-  float maxfreq; // maximum frequency for a grain
-  float minpan; // minimum pan for a grain
-  float maxpan; // maximum pan for a grain
-  float minamp; // minimum amplitude for a grain
-  float maxamp; // maximum amplitude for a grain
-  float mindur; // minimum duration for a grain
-  float maxdur; // maximum duration for a grain
+  t_float minfreq; // minimum frequency for a grain
+  t_float maxfreq; // maximum frequency for a grain
+  t_float minpan; // minimum pan for a grain
+  t_float maxpan; // maximum pan for a grain
+  t_float minamp; // minimum amplitude for a grain
+  t_float maxamp; // maximum amplitude for a grain
+  t_float mindur; // minimum duration for a grain
+  t_float maxdur; // maximum duration for a grain
   t_grain *grains; // stores grain data
-  float *pitchscale; // contains a frequency grid for pitch constraint
+  t_float *pitchscale; // contains a frequency grid for pitch constraint
   int pitchsteps; // number of members in scale
-  float transpose; // factor for scaling all pitches
-  float pitch_deviation; // factor to adjust scaled pitches
+  t_float transpose; // factor for scaling all pitches
+  t_float pitch_deviation; // factor to adjust scaled pitches
   short steady; // toggles pulsed rhythmic activity
-  float lowblock_freq; //lowest allowed frequency
-  float highblock_freq;// highest allowed frequency
-  float mindur_ms;//store duration in ms
-  float maxdur_ms;//ditto
-  float horizon_ms;//ditto
+  t_float lowblock_freq; //lowest allowed frequency
+  t_float highblock_freq;// highest allowed frequency
+  t_float mindur_ms;//store duration in ms
+  t_float maxdur_ms;//ditto
+  t_float horizon_ms;//ditto
   short constrain_scale;//flag to only use bounded portion of scale rather than all of it
 } t_granule;
 
@@ -79,7 +79,7 @@
 static void granule_lowblock(t_granule *x, t_floatarg f);
 static void granule_highblock(t_granule *x, t_floatarg f);
 static void granule_events(t_granule *x, t_floatarg e);
-static float granule_boundrand(float min, float max);
+static t_float granule_boundrand(t_float min, t_float max);
 static void *granule_grist(t_granule *x, t_symbol *msg, int argc, t_atom *argv);
 static void *granule_grain(t_granule *x, t_symbol *msg, int argc, t_atom *argv);
 static void *granule_setscale(t_granule *x, t_symbol *msg, int argc, t_atom *argv);
@@ -89,7 +89,7 @@
 static void granule_constrain_scale(t_granule *x, t_floatarg toggle);
 static void granule_dsp_free(t_granule *x);
 static void granule_init(t_granule *x,short initialized);
-static void granule_constrain(int *index_min, int *index_max, float minfreq, float maxfreq, float *scale, int steps);
+static void granule_constrain(int *index_min, int *index_max, t_float minfreq, t_float maxfreq, t_float *scale, int steps);
 
 void granule_tilde_setup(void) {
   granule_class = class_new(gensym("granule~"), (t_newmethod)granule_new,
@@ -158,7 +158,7 @@
     return;
   }
   x->events = e;
-  //  x->steady_dur = x->horizon / (float) x->events;
+  //  x->steady_dur = x->horizon / (t_float) x->events;
 }
 
 void granule_transpose(t_granule *x, t_floatarg t)
@@ -173,7 +173,7 @@
 void *granule_setscale(t_granule *x, t_symbol *msg, int argc, t_atom *argv)
 {
   int i;
-  float *pitchscale = x->pitchscale;
+  t_float *pitchscale = x->pitchscale;
   if( argc >= MAXSCALE ) {
     pd_error(0, "%d is the maximum size scale", MAXSCALE);
     return 0;
@@ -190,7 +190,7 @@
   return 0;
 }
 
-void granule_constrain(int *index_min, int *index_max, float minfreq, float maxfreq, float *scale, int steps)
+void granule_constrain(int *index_min, int *index_max, t_float minfreq, t_float maxfreq, t_float *scale, int steps)
 {
   int imax = steps - 1;
   int imin = 0;
@@ -222,28 +222,28 @@
 
   long eframes = x->windowbuf->b_frames;
   long frames = x->wavebuf->b_frames;
-  float sr = x->sr;
+  t_float sr = x->sr;
   long horizon = x->horizon; // length of block for random events
-  float mindur = x->mindur;
-  float maxdur = x->maxdur;
-  float minfreq = x->minfreq; // minimum frequency for a grain
-  float maxfreq = x->maxfreq; // maximum frequency for a grain
-  float minpan = x->minpan; // minimum pan for a grain
-  float maxpan = x->maxpan; // maximum pan for a grain
-  float minamp = x->minamp; // minimum amplitude for a grain
-  float maxamp = x->maxamp; // maximum amplitude for a grain
-  float transpose = x->transpose; // pitch scalar
-  float lowblock_freq = x->lowblock_freq;
-  float highblock_freq = x->highblock_freq;
+  t_float mindur = x->mindur;
+  t_float maxdur = x->maxdur;
+  t_float minfreq = x->minfreq; // minimum frequency for a grain
+  t_float maxfreq = x->maxfreq; // maximum frequency for a grain
+  t_float minpan = x->minpan; // minimum pan for a grain
+  t_float maxpan = x->maxpan; // maximum pan for a grain
+  t_float minamp = x->minamp; // minimum amplitude for a grain
+  t_float maxamp = x->maxamp; // maximum amplitude for a grain
+  t_float transpose = x->transpose; // pitch scalar
+  t_float lowblock_freq = x->lowblock_freq;
+  t_float highblock_freq = x->highblock_freq;
   short steady = x->steady;
-  float pitch_deviation = x->pitch_deviation;
-  float pdev = 0;
-  float pdev_invert = 0;
-  //  float pscale;
-  float pan;
+  t_float pitch_deviation = x->pitch_deviation;
+  t_float pdev = 0;
+  t_float pdev_invert = 0;
+  //  t_float pscale;
+  t_float pan;
   int index_min, index_max;
   int steps = x->pitchsteps;
-  float *scale = x->pitchscale;
+  t_float *scale = x->pitchscale;
   int windex;
   short inserted = 0;
   short constrain_scale = x->constrain_scale;
@@ -263,9 +263,9 @@
     for(j = 0; j < MAXGRAINS; j++ ) {
       if( grains[j].ephase >= eframes ) {
         if(steady) {
-          grains[j].delay = (float)(i * horizon) / (float) x->events ;
+          grains[j].delay = (t_float)(i * horizon) / (t_float) x->events ;
         } else {
-          grains[j].delay = granule_boundrand(0.0,(float) horizon);
+          grains[j].delay = granule_boundrand(0.0,(t_float) horizon);
         }
         grains[j].duration = (long) granule_boundrand(mindur, maxdur);
         grains[j].phase = 0.0;
@@ -274,14 +274,14 @@
         grains[j].panL = cos(pan * PIOVERTWO);
         grains[j].panR = sin(pan * PIOVERTWO);
         grains[j].amplitude = granule_boundrand(minamp, maxamp);
-        grains[j].esi =  (float) eframes / (float) grains[j].duration ;
+        grains[j].esi =  (t_float) eframes / (t_float) grains[j].duration ;
         if(constrain_scale) {
           granule_constrain(&index_min,&index_max,minfreq, maxfreq, scale, steps);
-          windex = (int) granule_boundrand((float)index_min, (float)index_max);
+          windex = (int) granule_boundrand((t_float)index_min, (t_float)index_max);
         } else {
-          windex = (int) granule_boundrand(0.0, (float)(steps-1));
+          windex = (int) granule_boundrand(0.0, (t_float)(steps-1));
         }
-        grains[j].si = transpose * scale[windex] * (float) frames / sr;
+        grains[j].si = transpose * scale[windex] * (t_float) frames / sr;
         if( pitch_deviation ) {
           grains[j].si *= granule_boundrand(pdev_invert,pdev);
         }
@@ -317,20 +317,20 @@
   int i,j;
   long eframes = x->windowbuf->b_frames;
   long frames = x->wavebuf->b_frames;
-  float sr = x->sr;
+  t_float sr = x->sr;
   long horizon = x->horizon; // length of block for random events
-  float mindur = x->mindur;
-  float maxdur = x->maxdur;
-  float minfreq = x->minfreq; // minimum frequency for a grain
-  float maxfreq = x->maxfreq; // maximum frequency for a grain
-  float minpan = x->minpan; // minimum pan for a grain
-  float maxpan = x->maxpan; // maximum pan for a grain
-  float minamp = x->minamp; // minimum amplitude for a grain
-  float maxamp = x->maxamp; // maximum amplitude for a grain
-  float transpose = x->transpose; // pitch scalar
-  //  float steady_dur = x->steady_dur;
+  t_float mindur = x->mindur;
+  t_float maxdur = x->maxdur;
+  t_float minfreq = x->minfreq; // minimum frequency for a grain
+  t_float maxfreq = x->maxfreq; // maximum frequency for a grain
+  t_float minpan = x->minpan; // minimum pan for a grain
+  t_float maxpan = x->maxpan; // maximum pan for a grain
+  t_float minamp = x->minamp; // minimum amplitude for a grain
+  t_float maxamp = x->maxamp; // maximum amplitude for a grain
+  t_float transpose = x->transpose; // pitch scalar
+  //  t_float steady_dur = x->steady_dur;
   short steady = x->steady;
-  float pan;
+  t_float pan;
   t_grain *grains = x->grains;
   short inserted;
 
@@ -339,9 +339,9 @@
     for(j = 0; j < MAXGRAINS; j++ ) {
       if( grains[j].ephase >= eframes ) {
         if(steady) {
-          grains[j].delay = (float)(i * horizon) / (float) x->events ;
+          grains[j].delay = (t_float)(i * horizon) / (t_float) x->events ;
         } else {
-          grains[j].delay = granule_boundrand(0.0,(float) horizon);
+          grains[j].delay = granule_boundrand(0.0,(t_float) horizon);
         }
         grains[j].duration = (long) granule_boundrand(mindur, maxdur);
         grains[j].phase = 0.0;
@@ -350,8 +350,8 @@
         grains[j].panL = cos(pan * PIOVERTWO);
         grains[j].panR = sin(pan * PIOVERTWO);
         grains[j].amplitude = granule_boundrand(minamp, maxamp);
-        grains[j].esi =  (float) eframes / (float) grains[j].duration ;
-        grains[j].si = transpose * granule_boundrand(minfreq, maxfreq) * (float) frames / sr;
+        grains[j].esi =  (t_float) eframes / (t_float) grains[j].duration ;
+        grains[j].si = transpose * granule_boundrand(minfreq, maxfreq) * (t_float) frames / sr;
         inserted = 1;
         goto nextgrain;
       }
@@ -368,11 +368,11 @@
 {
   short inserted;
   int j;
-  float duration, frequency, amplitude, pan;
+  t_float duration, frequency, amplitude, pan;
   t_grain *grains;
   long eframes;
   long frames;
-  float sr;
+  t_float sr;
 
   grains = x->grains;
   eframes = x->windowbuf->b_frames;
@@ -410,8 +410,8 @@
       grains[j].panL = cos(pan * PIOVERTWO);
       grains[j].panR = sin(pan * PIOVERTWO);
       grains[j].amplitude = amplitude;
-      grains[j].esi =  (float) eframes / (float) grains[j].duration ;
-      grains[j].si = frequency * (float) frames / sr;
+      grains[j].esi =  (t_float) eframes / (t_float) grains[j].duration ;
+      grains[j].si = frequency * (t_float) frames / sr;
       return 0;
     }
   }
@@ -421,9 +421,9 @@
 
 }
 
-float granule_boundrand(float min, float max)
+t_float granule_boundrand(t_float min, t_float max)
 {
-  return min + (max-min) * ((float) (rand() % RAND_MAX)/ (float) RAND_MAX);
+  return min + (max-min) * ((t_float) (rand() % RAND_MAX)/ (t_float) RAND_MAX);
 }
 
 
@@ -437,7 +437,7 @@
   x->windowbuf = (t_pdbuffer*)getbytes(sizeof(t_pdbuffer));
   srand(time(0));
 
-  x->pitchscale = (float *) getbytes(MAXSCALE * sizeof(float));
+  x->pitchscale = (t_float *) getbytes(MAXSCALE * sizeof(t_float));
   x->grains = (t_grain *) getbytes(MAXGRAINS * sizeof(t_grain));
 
 
@@ -601,8 +601,8 @@
 t_int *granule_performhose(t_int *w)
 {
   //  t_granule *x = (t_granule *) (w[1]);
-  float *outputL = (t_float *)(w[3]);
-  float *outputR = (t_float *)(w[4]);
+  t_float *outputL = (t_float *)(w[3]);
+  t_float *outputR = (t_float *)(w[4]);
   int n = (int) w[5];
   while(n--) *outputL++ = *outputR++ = 0;
   return (w+6);
@@ -611,9 +611,9 @@
 t_int *granule_perform(t_int *w)
 {
   t_granule *x = (t_granule *) (w[1]);
-  //  float *in = (t_float *)(w[2]); // ignoring input
-  float *outputL = (t_float *)(w[3]);
-  float *outputR = (t_float *)(w[4]);
+  //  t_float *in = (t_float *)(w[2]); // ignoring input
+  t_float *outputL = (t_float *)(w[3]);
+  t_float *outputR = (t_float *)(w[4]);
   int n = (int) w[5];
 
   t_pdbuffer *wavebuf = x->wavebuf;
@@ -621,14 +621,14 @@
   t_word *wavetable = wavebuf->b_samples;
   t_word *window = windowbuf->b_samples;
   t_grain *grains = x->grains;
-  float sample;
-  float envelope;
-  float amplitude;
-  float panL, panR;
-  float si;
-  float esi;
-  float phase;
-  float ephase;
+  t_float sample;
+  t_float envelope;
+  t_float amplitude;
+  t_float panL, panR;
+  t_float si;
+  t_float esi;
+  t_float phase;
+  t_float ephase;
   long delay;
   long frames = wavebuf->b_frames;
   long eframes = windowbuf->b_frames;
@@ -704,7 +704,7 @@
 {
 
   freebytes(x->grains, MAXGRAINS * sizeof(t_grain));
-  freebytes(x->pitchscale, MAXSCALE * sizeof(float));
+  freebytes(x->pitchscale, MAXSCALE * sizeof(t_float));
 }
 
 void granule_dsp(t_granule *x, t_signal **sp)
--- pd-lyonpotpourri.orig/kbuffer~.c
+++ pd-lyonpotpourri/kbuffer~.c
@@ -8,24 +8,24 @@
 {
 
   t_object x_obj;
-  float x_f;
-  float ksrate;
-  float srate;
-  float si;
-  float phase;
-  float duration;
+  t_float x_f;
+  t_float ksrate;
+  t_float srate;
+  t_float si;
+  t_float phase;
+  t_float duration;
   int iphase;
   int lastphase;
   int length;
-  float *data;
-  float fval;
-  float lastval;
+  t_float *data;
+  t_float fval;
+  t_float lastval;
   short record_flag;
   short play_flag;
   short dump_flag;
   short loop_flag;
-  float sync ;
-  float speed ;
+  t_float sync ;
+  t_float speed ;
   short in_connected;
   int memsize;
 } t_kbuffer;
@@ -75,9 +75,9 @@
   if(ms < 1)
     ms = 1;
   x->duration = ms / 1000.0 ;
-  x->memsize = x->ksrate * x->duration * sizeof(float);
+  x->memsize = x->ksrate * x->duration * sizeof(t_float);
   x->length = x->duration * x->ksrate ;
-  x->data = (float*) realloc(x->data,x->memsize*sizeof(float));
+  x->data = (t_float*) realloc(x->data,x->memsize*sizeof(t_float));
   for( i = 0; i < x->length; i++) {
     x->data[i] = 0.0;
   }
@@ -88,10 +88,10 @@
   if( ksrate < 1 )
     ksrate = 1 ;
   x->ksrate = ksrate ;
-  x->memsize = x->ksrate * x->duration * sizeof(float);
+  x->memsize = x->ksrate * x->duration * sizeof(t_float);
   x->length = x->duration * x->ksrate ;
   x->si = x->ksrate / x->srate;
-  x->data = (float*) realloc(x->data,x->memsize*sizeof(float));
+  x->data = (t_float*) realloc(x->data,x->memsize*sizeof(t_float));
   for( i = 0; i < x->length; i++) {
     x->data[i] = 0.0;
   }
@@ -154,7 +154,7 @@
 }
 
 void kbuffer_dsp_free(t_kbuffer *x) {
-  freebytes(x->data, x->memsize * sizeof(float));
+  freebytes(x->data, x->memsize * sizeof(t_float));
 }
 
 t_int *kbuffer_perform(t_int *w)
@@ -172,13 +172,13 @@
   int length = x->length;
   int iphase = x->iphase;
   int lastphase = x->lastphase;
-  float phase = x->phase;
-  float *data = x->data;
-  float si = x->si;
-  float speed = x->speed;
-  float sample;
+  t_float phase = x->phase;
+  t_float *data = x->data;
+  t_float si = x->si;
+  t_float speed = x->speed;
+  t_float sample;
   short in_connected = x->in_connected;
-  float fval = x->fval;
+  t_float fval = x->fval;
   /*********************/
 
   while( n-- ) {
@@ -199,7 +199,7 @@
         lastphase = iphase ;
         data[ iphase ] = sample ;
       }
-      *sync_out++ = phase / (float) length ;
+      *sync_out++ = phase / (t_float) length ;
       *out++ = sample ; // mirror input to output
     } else if ( play_flag ) {
       iphase = phase;
@@ -214,7 +214,7 @@
       else {
         *out++ = data[ iphase ] ;
       }
-      *sync_out++ = phase / (float) length ;
+      *sync_out++ = phase / (t_float) length ;
     }
     else if ( loop_flag ) {
       iphase = phase;
@@ -225,7 +225,7 @@
         phase = iphase = length - 1;
       }
       *out++ = data[ iphase ] ;
-      *sync_out++ = phase / (float) length ;
+      *sync_out++ = phase / (t_float) length ;
 
     }
     else if ( dump_flag ) {
@@ -286,9 +286,9 @@
     x->loop_flag = 0;
     x->fval = 0;
     x->speed = 1.0 ;
-    x->memsize = x->ksrate * x->duration * sizeof(float);
+    x->memsize = x->ksrate * x->duration * sizeof(t_float);
     x->length = x->duration * x->ksrate;
-    x->data = (float *) getbytes(x->memsize * sizeof(float));
+    x->data = (t_float *) getbytes(x->memsize * sizeof(t_float));
   }
   x->si = x->ksrate / x->srate;
 }
--- pd-lyonpotpourri.orig/killdc~.c
+++ pd-lyonpotpourri/killdc~.c
@@ -7,16 +7,16 @@
 static t_class *killdc_class;
 
 typedef struct {
-  float ps[4][MAXSECTS];
-  float c[4][MAXSECTS];
+  t_float ps[4][MAXSECTS];
+  t_float c[4][MAXSECTS];
   int nsects ;
-  float xnorm;
+  t_float xnorm;
 } COEFS ;
 
 typedef struct _killdc
 {
   t_object x_obj;
-  float x_f;
+  t_float x_f;
 
   COEFS fdata;
 } t_killdc;
@@ -82,10 +82,10 @@
 t_int *killdc_perform(t_int *w)
 {
   t_float *in1,*out;
-  float sample ;
+  t_float sample ;
   int n;
   int m;
-  float op;
+  t_float op;
   //  int lcount = 0;
   /********/
   t_killdc *x = (t_killdc *) (w[1]);
--- pd-lyonpotpourri.orig/magfreq_analysis~.c
+++ pd-lyonpotpourri/magfreq_analysis~.c
@@ -7,16 +7,16 @@
 #define MAX_N2 8192
 #define MAX_Nw 16384
 
-static void convert(float *S, float *C, int N2, float *lastphase, float fundamental, float factor );
-static void fold( float *I, float *W, int Nw, float *O, int N, int n );
-static void init_rdft(int n, int *ip, float *w);
-static void rdft(int n, int isgn, float *a, int *ip, float *w);
-static void bitrv2(int n, int *ip, float *a);
-static void cftsub(int n, float *a, float *w);
-static void rftsub(int n, float *a, int nc, float *c);
-static void makewt(int nw, int *ip, float *w);
-static void makect(int nc, int *ip, float *c);
-static void makehanning( float *H, float *A, float *S, int Nw, int N, int I,int odd );
+static void convert(t_float *S, t_float *C, int N2, t_float *lastphase, t_float fundamental, t_float factor );
+static void fold( t_float *I, t_float *W, int Nw, t_float *O, int N, int n );
+static void init_rdft(int n, int *ip, t_float *w);
+static void rdft(int n, int isgn, t_float *a, int *ip, t_float *w);
+static void bitrv2(int n, int *ip, t_float *a);
+static void cftsub(int n, t_float *a, t_float *w);
+static void rftsub(int n, t_float *a, int nc, t_float *c);
+static void makewt(int nw, int *ip, t_float *w);
+static void makect(int nc, int *ip, t_float *c);
+static void makehanning( t_float *H, t_float *A, t_float *S, int Nw, int N, int I,int odd );
 static int power_of_two(int test);
 
 static t_class *magfreq_analysis_class;
@@ -26,8 +26,8 @@
 typedef struct _magfreq_analysis
 {
     t_object x_obj;
-    float x_f;
-    float R;
+    t_float x_f;
+    t_float R;
     int N;
     int N2;
     int Nw;
@@ -35,41 +35,41 @@
     int D;
     int i;
     int inCount;
-    float *Wanal;
-    float *Wsyn;
-    float *input;
-    float *Hwin;
-    float *buffer;
-    float *channel;
-    float *output;
+    t_float *Wanal;
+    t_float *Wsyn;
+    t_float *input;
+    t_float *Hwin;
+    t_float *buffer;
+    t_float *channel;
+    t_float *output;
     // for convert
-    float *c_lastphase_in;
-    float *c_lastphase_out;
-    float c_fundamental;
-    float c_factor_in;
-    float c_factor_out;
+    t_float *c_lastphase_in;
+    t_float *c_lastphase_out;
+    t_float c_fundamental;
+    t_float c_factor_in;
+    t_float c_factor_out;
     // for oscbank
     int NP;
-    float P;
+    t_float P;
     int L;
     int first;
-    float Iinv;
-    float *lastamp;
-    float *lastfreq;
-    float *index;
-    float *table;
-    float myPInc;
-    float ffac;
+    t_float Iinv;
+    t_float *lastamp;
+    t_float *lastfreq;
+    t_float *index;
+    t_float *table;
+    t_float myPInc;
+    t_float ffac;
     //
-    float lofreq;
-    float hifreq;
+    t_float lofreq;
+    t_float hifreq;
     int lo_bin;
     int hi_bin;
-    float topfreq;
-    float synt;
+    t_float topfreq;
+    t_float synt;
     // for fast fft
-    float mult;
-    float *trigland;
+    t_float mult;
+    t_float *trigland;
     int *bitshuffle;
     //
     int bypass_state;
@@ -149,26 +149,26 @@
 }
 
 void magfreq_analysis_free(t_magfreq_analysis *x ) {
-    freebytes(x->c_lastphase_in,(MAX_N2+1) * sizeof(float));
-    freebytes(x->c_lastphase_out,(MAX_N2+1) * sizeof(float));
-    freebytes(x->trigland,MAX_N * 2 * sizeof( float ));
+    freebytes(x->c_lastphase_in,(MAX_N2+1) * sizeof(t_float));
+    freebytes(x->c_lastphase_out,(MAX_N2+1) * sizeof(t_float));
+    freebytes(x->trigland,MAX_N * 2 * sizeof( t_float ));
     freebytes(x->bitshuffle,MAX_N * 2 * sizeof( int ));
-    freebytes(x->Wanal,(MAX_Nw) * sizeof(float));
-    freebytes(x->Wsyn,(MAX_Nw) * sizeof(float));
-    freebytes(x->input,MAX_Nw * sizeof(float));
-    freebytes(x->Hwin,(MAX_Nw) * sizeof(float));
-    freebytes(x->buffer,MAX_N * sizeof(float));
-    freebytes(x->channel,(MAX_N+2) * sizeof(float));
-    freebytes(x->output,MAX_Nw * sizeof(float));
-    freebytes(x->lastamp,(MAX_N+1) * sizeof(float));
-    freebytes(x->lastfreq,(MAX_N+1) * sizeof(float));
-    freebytes(x->index,(MAX_N+1) * sizeof(float));
-    freebytes(x->table,x->L * sizeof(float));
+    freebytes(x->Wanal,(MAX_Nw) * sizeof(t_float));
+    freebytes(x->Wsyn,(MAX_Nw) * sizeof(t_float));
+    freebytes(x->input,MAX_Nw * sizeof(t_float));
+    freebytes(x->Hwin,(MAX_Nw) * sizeof(t_float));
+    freebytes(x->buffer,MAX_N * sizeof(t_float));
+    freebytes(x->channel,(MAX_N+2) * sizeof(t_float));
+    freebytes(x->output,MAX_Nw * sizeof(t_float));
+    freebytes(x->lastamp,(MAX_N+1) * sizeof(t_float));
+    freebytes(x->lastfreq,(MAX_N+1) * sizeof(t_float));
+    freebytes(x->index,(MAX_N+1) * sizeof(t_float));
+    freebytes(x->table,x->L * sizeof(t_float));
 }
 
 void magfreq_analysis_highfreq(t_magfreq_analysis *x, t_floatarg f)
 {
-    float curfreq;
+    t_float curfreq;
     
     if(f < x->lofreq) {
         pd_error(0, "current minimum is %f",x->lofreq);
@@ -188,7 +188,7 @@
 
 void magfreq_analysis_lowfreq(t_magfreq_analysis *x, t_floatarg f)
 {
-    float curfreq;
+    t_float curfreq;
     
     if(f > x->hifreq) {
         pd_error(0, "current maximum is %f",x->lofreq);
@@ -210,7 +210,7 @@
 void magfreq_analysis_init(t_magfreq_analysis *x, short initialized)
 {
     int i;
-    float curfreq;
+    t_float curfreq;
     x->R = sys_getsr();
     x->D = sys_getblksize();
    
@@ -235,49 +235,49 @@
     x->Nw2 = x->Nw / 2;
     x->inCount = -(x->Nw);
     x->bypass_state = 0;
-    x->mult = 1. / (float) x->N;
+    x->mult = 1. / (t_float) x->N;
     x->pitch_connected = 0;
     x->synt_connected = 0;
     x->L = 8192 ;
-    x->c_fundamental =  x->R/(float)( (x->N2)<<1 );
-    x->c_factor_in =  x->R/((float)x->D * TWOPI);
-    x->c_factor_out = TWOPI * (float)  x->D / (float) x->R;
-    x->Iinv = 1./(float)x->D;
+    x->c_fundamental =  x->R/(t_float)( (x->N2)<<1 );
+    x->c_factor_in =  x->R/((t_float)x->D * TWOPI);
+    x->c_factor_out = TWOPI * (t_float)  x->D / (t_float) x->R;
+    x->Iinv = 1./(t_float)x->D;
     x->myPInc = x->P*x->L/x->R;
-    x->ffac = x->P * PI/(float)x->N;
+    x->ffac = x->P * PI/(t_float)x->N;
 
     if(!initialized) {
-        x->Wanal = (float *) getbytes( (MAX_Nw) * sizeof(float));
-        x->Wsyn = (float *) getbytes( (MAX_Nw) * sizeof(float));
-        x->Hwin = (float *) getbytes( (MAX_Nw) * sizeof(float));
-        x->input = (float *) getbytes(MAX_Nw * sizeof(float) );
-        x->output = (float *) getbytes(MAX_Nw * sizeof(float) );
-        x->buffer = (float *) getbytes(MAX_N * sizeof(float) );
-        x->channel = (float *) getbytes( (MAX_N+2) * sizeof(float) );
+        x->Wanal = (t_float *) getbytes( (MAX_Nw) * sizeof(t_float));
+        x->Wsyn = (t_float *) getbytes( (MAX_Nw) * sizeof(t_float));
+        x->Hwin = (t_float *) getbytes( (MAX_Nw) * sizeof(t_float));
+        x->input = (t_float *) getbytes(MAX_Nw * sizeof(t_float) );
+        x->output = (t_float *) getbytes(MAX_Nw * sizeof(t_float) );
+        x->buffer = (t_float *) getbytes(MAX_N * sizeof(t_float) );
+        x->channel = (t_float *) getbytes( (MAX_N+2) * sizeof(t_float) );
         x->bitshuffle = (int *) getbytes(MAX_N * 2 * sizeof( int ) );
-        x->trigland = (float *) getbytes(MAX_N * 2 * sizeof( float ) );
-        x->c_lastphase_in = (float *) getbytes( (MAX_N2+1) * sizeof(float) );
-        x->c_lastphase_out = (float *) getbytes( (MAX_N2+1) * sizeof(float) );
-        x->lastamp = (float *) getbytes( (MAX_N+1) * sizeof(float) );
-        x->lastfreq = (float *) getbytes( (MAX_N+1) * sizeof(float) );
-        x->index = (float *) getbytes( (MAX_N+1) * sizeof(float) );
-        x->table = (float *) getbytes( x->L * sizeof(float) );
+        x->trigland = (t_float *) getbytes(MAX_N * 2 * sizeof( t_float ) );
+        x->c_lastphase_in = (t_float *) getbytes( (MAX_N2+1) * sizeof(t_float) );
+        x->c_lastphase_out = (t_float *) getbytes( (MAX_N2+1) * sizeof(t_float) );
+        x->lastamp = (t_float *) getbytes( (MAX_N+1) * sizeof(t_float) );
+        x->lastfreq = (t_float *) getbytes( (MAX_N+1) * sizeof(t_float) );
+        x->index = (t_float *) getbytes( (MAX_N+1) * sizeof(t_float) );
+        x->table = (t_float *) getbytes( x->L * sizeof(t_float) );
         x->P = 1.0;
-        x->ffac = x->P * PI/(float)MAX_N;
+        x->ffac = x->P * PI/(t_float)MAX_N;
         x->mute = 0;
         //    x->threshgen = .0001;
     }
 /*
-    memset((char *)x->input,0,x->Nw * sizeof(float));
-    memset((char *)x->output,0,x->Nw * sizeof(float));
-    memset((char *)x->c_lastphase_in,0,(x->N2+1) * sizeof(float));
-    memset((char *)x->c_lastphase_out,0,(x->N2+1) * sizeof(float));
-    memset((char *)x->lastamp,0,(x->N+1) * sizeof(float));
-    memset((char *)x->lastfreq,0,(x->N+1) * sizeof(float));
-    memset((char *)x->index,0,(x->N+1) * sizeof(float));
+    memset((char *)x->input,0,x->Nw * sizeof(t_float));
+    memset((char *)x->output,0,x->Nw * sizeof(t_float));
+    memset((char *)x->c_lastphase_in,0,(x->N2+1) * sizeof(t_float));
+    memset((char *)x->c_lastphase_out,0,(x->N2+1) * sizeof(t_float));
+    memset((char *)x->lastamp,0,(x->N+1) * sizeof(t_float));
+    memset((char *)x->lastfreq,0,(x->N+1) * sizeof(t_float));
+    memset((char *)x->index,0,(x->N+1) * sizeof(t_float));
 */
     for ( i = 0; i < x->L; i++ ) {
-        x->table[i] = (float) x->N * cos((float)i * TWOPI / (float)x->L);
+        x->table[i] = (t_float) x->N * cos((t_float)i * TWOPI / (t_float)x->L);
     }
     init_rdft( x->N, x->bitshuffle, x->trigland);
     
@@ -357,17 +357,17 @@
     int Nw = x->Nw;
     int N = x->N ;
     int N2 = x-> N2;
-    float fundamental = x->c_fundamental;
-    float factor_in =  x->c_factor_in;
+    t_float fundamental = x->c_fundamental;
+    t_float factor_in =  x->c_factor_in;
     int *bitshuffle = x->bitshuffle;
-    float *trigland = x->trigland;
-    float *lastphase_in = x->c_lastphase_in;
+    t_float *trigland = x->trigland;
+    t_float *lastphase_in = x->c_lastphase_in;
     
     
-    float *Wanal = x->Wanal;
-    float *input = x->input;;
-    float *buffer = x->buffer;
-    float *channel = x->channel;
+    t_float *Wanal = x->Wanal;
+    t_float *input = x->input;;
+    t_float *buffer = x->buffer;
+    t_float *channel = x->channel;
     in = on = x->inCount ;
     
     
@@ -464,10 +464,10 @@
   return 0;
 }
 
-void makehanning( float *H, float *A, float *S, int Nw, int N, int I, int odd )
+void makehanning( t_float *H, t_float *A, t_float *S, int Nw, int N, int I, int odd )
 {
  int i;
- float sum ;
+ t_float sum ;
  
  
  if (odd) {
@@ -483,7 +483,7 @@
  }
      
     if ( Nw > N ) {
-     float x ;
+     t_float x ;
 
     x = -(Nw - 1)/2. ;
     for ( i = 0 ; i < Nw ; i++, x += 1. )
@@ -497,8 +497,8 @@
     sum += A[i] ;
 
     for ( i = 0 ; i < Nw ; i++ ) {
-     float afac = 2./sum ;
-     float sfac = Nw > N ? 1./afac : afac ;
+     t_float afac = 2./sum ;
+     t_float sfac = Nw > N ? 1./afac : afac ;
     A[i] *= afac ;
     S[i] *= sfac ;
     }
@@ -511,7 +511,7 @@
     }
 }
 
-void fold( float *I, float *W, int Nw, float *O, int N, int n )
+void fold( t_float *I, t_float *W, int Nw, t_float *O, int N, int n )
 
 {
  
@@ -531,15 +531,15 @@
 }
 
 
-void convert(float *S, float *C, int N2, float *lastphase, float fundamental, float factor )
+void convert(t_float *S, t_float *C, int N2, t_float *lastphase, t_float fundamental, t_float factor )
 {
-  float     phase,
+  t_float     phase,
         phasediff;
   int         real,
         imag,
         amp,
         freq;
-  float     a,
+  t_float     a,
         b;
   int         i;
     for ( i = 0; i <= N2; i++ ) {
@@ -563,14 +563,14 @@
     }
 }
 // more libraries
-void init_rdft(int n, int *ip, float *w)
+void init_rdft(int n, int *ip, t_float *w)
 {
 
   int    nw,
     nc;
 
-  void    makewt(int nw, int *ip, float *w);
-  void    makect(int nc, int *ip, float *c);
+  void    makewt(int nw, int *ip, t_float *w);
+  void    makect(int nc, int *ip, t_float *c);
 
   nw = n >> 2;
   makewt(nw, ip, w);
@@ -582,18 +582,18 @@
 }
 
 
-void rdft(int n, int isgn, float *a, int *ip, float *w)
+void rdft(int n, int isgn, t_float *a, int *ip, t_float *w)
 {
 
   int        j,
         nw,
         nc;
 
-  float        xi;
+  t_float        xi;
 
-  void        bitrv2(int n, int *ip, float *a),
-        cftsub(int n, float *a, float *w),
-        rftsub(int n, float *a, int nc, float *c);
+  void        bitrv2(int n, int *ip, t_float *a),
+        cftsub(int n, t_float *a, t_float *w),
+        rftsub(int n, t_float *a, int nc, t_float *c);
 
     
   nw = ip[0];
@@ -638,10 +638,10 @@
 }
 
 
-void bitrv2(int n, int *ip, float *a)
+void bitrv2(int n, int *ip, t_float *a)
 {
   int j, jj1, k, k1, l, m, m2;
-  float xr, xi;
+  t_float xr, xi;
     
   ip[0] = 0;
   l = n;
@@ -700,11 +700,11 @@
 }
 
 
-void cftsub(int n, float *a, float *w)
+void cftsub(int n, t_float *a, t_float *w)
 {
   int j, jj1, j2, j3, k, k1, ks, l, m;
-  float wk1r, wk1i, wk2r, wk2i, wk3r, wk3i;
-  float x0r, x0i, x1r, x1i, x2r, x2i, x3r, x3i;
+  t_float wk1r, wk1i, wk2r, wk2i, wk3r, wk3i;
+  t_float x0r, x0i, x1r, x1i, x2r, x2i, x3r, x3i;
     
   l = 2;
 
@@ -823,10 +823,10 @@
 }
 
 
-void rftsub(int n, float *a, int nc, float *c)
+void rftsub(int n, t_float *a, int nc, t_float *c)
 {
   int j, k, kk, ks;
-  float wkr, wki, xr, xi, yr, yi;
+  t_float wkr, wki, xr, xi, yr, yi;
     
   ks = (nc << 2) / n;
   kk = 0;
@@ -848,11 +848,11 @@
 }
 
 
-void makewt(int nw, int *ip, float *w)
+void makewt(int nw, int *ip, t_float *w)
 {
-    void bitrv2(int n, int *ip, float *a);
+    void bitrv2(int n, int *ip, t_float *a);
     int nwh, j;
-    float delta, x, y;
+    t_float delta, x, y;
     
     ip[0] = nw;
     ip[1] = 1;
@@ -876,10 +876,10 @@
 }
 
 
-void makect(int nc, int *ip, float *c)
+void makect(int nc, int *ip, t_float *c)
 {
     int nch, j;
-    float delta;
+    t_float delta;
     
     ip[1] = nc;
     if (nc > 1) {
--- pd-lyonpotpourri.orig/markov~.c
+++ pd-lyonpotpourri/markov~.c
@@ -7,21 +7,21 @@
 typedef struct _markov
 {
     t_object x_obj;
-    float x_f;
+    t_float x_f;
     // for markov
     int event_count;
     int maximum_length;
-    float **event_weights;
+    t_float **event_weights;
     int current_event;
-    float *values;
-    float current_value;
+    t_float *values;
+    t_float current_value;
     // for rhythm
     int count;
     int event_samples;
     int subdiv;
-    float tempo;
+    t_float tempo;
     
-    float sr;
+    t_float sr;
     short manual_override;
     short trigger;
 } t_markov;
@@ -30,7 +30,7 @@
 static void *markov_new(t_floatarg event_count);
 static t_int *markov_perform(t_int *w);
 static void markov_dsp(t_markov *x, t_signal **sp);
-static int markov_domarkov( int current_event, float **event_weights, int event_count );
+static int markov_domarkov( int current_event, t_float **event_weights, int event_count );
 static void markov_subdiv(t_markov *x, t_floatarg subdiv);
 static void markov_tempo(t_markov *x, t_floatarg tempo);
 static void markov_set_length(t_markov *x, t_floatarg length);
@@ -60,10 +60,10 @@
 {
     int i;
     for( i = 0; i < 10; i++ ) {
-        freebytes(x->event_weights[i], x->maximum_length * sizeof(float));
+        freebytes(x->event_weights[i], x->maximum_length * sizeof(t_float));
     }
-    freebytes(x->values, x->maximum_length * sizeof(float));
-    freebytes(x->event_weights, x->maximum_length * sizeof(float *));
+    freebytes(x->values, x->maximum_length * sizeof(t_float));
+    freebytes(x->event_weights, x->maximum_length * sizeof(t_float *));
 }
 
 void markov_manual_override(t_markov *x, t_floatarg toggle)
@@ -93,9 +93,9 @@
 {
     int i;
     int event;
-    float sum = 0.0;
+    t_float sum = 0.0;
     
-    float **event_weights = x->event_weights;
+    t_float **event_weights = x->event_weights;
     
     if( argc != x->event_count + 1) {
         pd_error(0, "there must be %d values in this list", x->event_count + 1);
@@ -134,7 +134,7 @@
 void markov_tempo(t_markov *x, t_floatarg tempo)
 {
     x->tempo = tempo;
-    x->event_samples = x->sr * (60.0/x->tempo) / (float) x->subdiv;
+    x->event_samples = x->sr * (60.0/x->tempo) / (t_float) x->subdiv;
 }
 
 void markov_subdiv(t_markov *x, t_floatarg subdiv)
@@ -142,7 +142,7 @@
     x->subdiv = (int) subdiv;
     if( subdiv < 1 || subdiv > 128)
         subdiv = 1;
-    x->event_samples = x->sr * (60.0/x->tempo) / (float) x->subdiv;
+    x->event_samples = x->sr * (60.0/x->tempo) / (t_float) x->subdiv;
 }
 
 void *markov_new(t_floatarg event_count)
@@ -163,11 +163,11 @@
     x->event_count = 4; // default pattern
     x->count = 0;
     
-    x->event_weights = (float **) getbytes(x->maximum_length * sizeof(float *));
+    x->event_weights = (t_float **) getbytes(x->maximum_length * sizeof(t_float *));
     for( i = 0; i < 10; i++ ) {
-        x->event_weights[i] = (float *) getbytes(x->maximum_length * sizeof(float));
+        x->event_weights[i] = (t_float *) getbytes(x->maximum_length * sizeof(t_float));
     }
-    x->values = (float *) getbytes(x->maximum_length * sizeof(float));
+    x->values = (t_float *) getbytes(x->maximum_length * sizeof(t_float));
     
     x->current_event = 0;
     x->values[0] = 300;
@@ -200,7 +200,7 @@
         x->sr = 44100;
     }
     x->subdiv = 1;
-    x->event_samples = x->sr * (60.0/x->tempo) / (float) x->subdiv;
+    x->event_samples = x->sr * (60.0/x->tempo) / (t_float) x->subdiv;
     
     x->trigger = 0;
     
@@ -219,10 +219,10 @@
     int count = x->count;
     int event_samples = x->event_samples;
     int event_count = x->event_count;
-    float **event_weights = x->event_weights;
+    t_float **event_weights = x->event_weights;
     int current_event = x->current_event;
-    float *values = x->values;
-    float current_value = x->current_value;
+    t_float *values = x->values;
+    t_float current_value = x->current_value;
     
     
     if( x->manual_override ) {
@@ -247,7 +247,7 @@
             count = 0;
         }
         
-        *sync++ = (float) count / (float) event_samples;
+        *sync++ = (t_float) count / (t_float) event_samples;
         
         *out++ = current_value;
         
@@ -260,9 +260,9 @@
     return (w+6);
 }
 
-int markov_domarkov(int current_event, float **event_weights, int event_count)
+int markov_domarkov(int current_event, t_float **event_weights, int event_count)
 {
-    float randval;
+    t_float randval;
     int i;
     
     randval =  rand() % 32768 ;
@@ -283,7 +283,7 @@
     //  long i;
     if(x->sr!=sp[0]->s_sr) {
         x->sr=sp[0]->s_sr;// BUG!!! in MSP code was !=
-        x->event_samples = x->sr * (60.0/x->tempo) / (float) x->subdiv;
+        x->event_samples = x->sr * (60.0/x->tempo) / (t_float) x->subdiv;
         x->count = 0;
     }
     dsp_add(markov_perform, 5, x, sp[0]->s_vec , sp[1]->s_vec, sp[2]->s_vec,
--- pd-lyonpotpourri.orig/mask~.c
+++ pd-lyonpotpourri/mask~.c
@@ -10,7 +10,7 @@
 
 typedef struct
 {
-  float *pat; // mask pattern
+  t_float *pat; // mask pattern
   int length;// length of pattern
 } t_maskpat;
 
@@ -24,7 +24,7 @@
 typedef struct _mask
 {
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   short mute;// stops all computation (try z-disable)
   short gate; // continues masking but inhibits all output
   short phaselock; // indicates all patterns are the same size and use the same phase count
@@ -36,7 +36,7 @@
   int *stored_masks;// a list of patterns stored
   int pattern_count;//how many patterns are stored
   short noloop;// flag to play pattern only once
-  float *in_vec;//copy space for input to avoid dreaded vector sharing override
+  t_float *in_vec;//copy space for input to avoid dreaded vector sharing override
 } t_mask;
 
 static void *mask_new(t_symbol *msg, int argc, t_atom *argv);
@@ -210,7 +210,7 @@
     return;
   }
   if(x->masks[location].pat == NULL) {
-    x->masks[location].pat = (float *) getbytes(MAXLEN * sizeof(float));
+    x->masks[location].pat = (t_float *) getbytes(MAXLEN * sizeof(t_float));
     x->stored_masks[x->pattern_count++] = location;
   } else {
     //    post("replacing pattern stored at location %d", location);
@@ -227,7 +227,7 @@
 {
     int i;
     for(i=0;i<x->pattern_count;i++){
-        freebytes(x->masks[i].pat, MAXLEN * sizeof(float));
+        freebytes(x->masks[i].pat, MAXLEN * sizeof(t_float));
     }
     freebytes(x->masks,MAXMASKS * sizeof(t_maskpat));
     freebytes(x->stored_masks, MAXMASKS * sizeof(int));
@@ -261,8 +261,8 @@
   }
   if(argc > 0) {
     //  post("reading initial mask from argument list, with %d members",argc);
-    x->masks[0].pat = (float *) getbytes(MAXLEN * sizeof(float));
-    //    post("allocated %d bytes for this pattern", MAXLEN * sizeof(float));
+    x->masks[0].pat = (t_float *) getbytes(MAXLEN * sizeof(t_float));
+    //    post("allocated %d bytes for this pattern", MAXLEN * sizeof(t_float));
     x->masks[0].length = argc;
     for(i=0; i<argc; i++) {
       x->masks[0].pat[i] = atom_getfloatarg(i,argc,argv);
@@ -286,8 +286,8 @@
 {
   int i;
   t_mask *x = (t_mask *) (w[1]);
-  float *inlet = (t_float *) (w[2]);
-  float *outlet = (t_float *) (w[3]);
+  t_float *inlet = (t_float *) (w[2]);
+  t_float *outlet = (t_float *) (w[3]);
   int n = (int) w[4];
 
   int phase = x->phase;
@@ -297,7 +297,7 @@
   int current_mask = x->current_mask;
   t_maskpat *masks = x->masks;
   t_sequence sequence = x->sequence;
-  float *in_vec = x->in_vec;
+  t_float *in_vec = x->in_vec;
 
 
   if( x->mute || current_mask < 0) {
--- pd-lyonpotpourri.orig/npan~.c
+++ pd-lyonpotpourri/npan~.c
@@ -10,7 +10,7 @@
   t_object x_obj;
   double pi_over_two;
   double twopi;
-  float x_f;
+  t_float x_f;
   int outcount;
   t_float *input_locvec;
   t_float *panner_locvec;
--- pd-lyonpotpourri.orig/oscil~.c
+++ pd-lyonpotpourri/oscil~.c
@@ -29,25 +29,25 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   int table_length;
-  float *wavetable;
+  t_float *wavetable;
   int harmonic_count;
-  float *harmonic_weights;
-  float *harmonic_phases;
+  t_float *harmonic_weights;
+  t_float *harmonic_phases;
   double phase;
   double phase_offset;
   double si_factor;
   double si;
   int bl_harms;
-  float piotwo;
-  float twopi;
-  float sr;
+  t_float piotwo;
+  t_float twopi;
+  t_float sr;
   short mute;
   short connected[4];
-  float *old_wavetable;
+  t_float *old_wavetable;
   short dirty;
-  float fade_ms;
+  t_float fade_ms;
   int fade_samples;
   int fade_countdown;
   short fadetype;
@@ -104,7 +104,7 @@
 {
   short i;
   int harmonic_count = 0;
-  float *harmonic_weights = x->harmonic_weights;
+  t_float *harmonic_weights = x->harmonic_weights;
   for (i=0; i < argc; i++) {
     harmonic_weights[harmonic_count] = atom_getfloatarg(i, argc, argv);
     ++harmonic_count;
@@ -117,8 +117,8 @@
 {
   short i;
   int harmonic_count = 0;
-  float *harmonic_weights = x->harmonic_weights;
-  float *harmonic_phases = x->harmonic_phases;
+  t_float *harmonic_weights = x->harmonic_weights;
+  t_float *harmonic_phases = x->harmonic_phases;
   if(argc < 1) {
     return;
   }
@@ -185,7 +185,7 @@
 
 void *oscil_new(t_symbol *s, int argc, t_atom *argv)
 {
-  float init_freq;
+  t_float init_freq;
   t_symbol *init_waveform_symbol;
 
   t_oscil *x = (t_oscil *)pd_new(oscil_class);
@@ -255,11 +255,11 @@
   x->twopi = 8.0 * atan(1.0);
 
 
-  x->old_wavetable = (float *) t_getbytes( x->table_length * sizeof(float) );
+  x->old_wavetable = (t_float *) t_getbytes( x->table_length * sizeof(t_float) );
 
-  x->wavetable = (float *) t_getbytes( x->table_length * sizeof(float) );
-  x->harmonic_weights = (float *) t_getbytes( OSCIL_MAXIMUM_HARMONICS * sizeof(float) );
-  x->harmonic_phases = (float *) t_getbytes( OSCIL_MAXIMUM_HARMONICS * sizeof(float) );
+  x->wavetable = (t_float *) t_getbytes( x->table_length * sizeof(t_float) );
+  x->harmonic_weights = (t_float *) t_getbytes( OSCIL_MAXIMUM_HARMONICS * sizeof(t_float) );
+  x->harmonic_phases = (t_float *) t_getbytes( OSCIL_MAXIMUM_HARMONICS * sizeof(t_float) );
   x->phase = 0;
   x->mute = 0;
   x->dirty = 0;
@@ -268,7 +268,7 @@
     x->sr = 44100;
     pd_error(0, "zero sampling rate - set to 44100");
   }
-  x->si_factor = (float) x->table_length / x->sr;
+  x->si_factor = (t_float) x->table_length / x->sr;
   x->si = init_freq * x->si_factor ;
   x->fade_countdown = 0;
   x->fade_ms = 50. ;
@@ -298,18 +298,18 @@
 
 void build_amph_waveform( t_oscil *x )
 {
-  float rescale;
+  t_float rescale;
   int i, j;
-  float max = 0.0;
-  float *wavetable = x->wavetable;
-  float *old_wavetable = x->old_wavetable;
-  float *harmonic_weights = x->harmonic_weights;
-  float *harmonic_phases = x->harmonic_phases;
+  t_float max = 0.0;
+  t_float *wavetable = x->wavetable;
+  t_float *old_wavetable = x->old_wavetable;
+  t_float *harmonic_weights = x->harmonic_weights;
+  t_float *harmonic_phases = x->harmonic_phases;
   int harmonic_count = x->harmonic_count;
   int table_length = x->table_length;
-  float twopi = x->twopi;
-  //  float testsum = 0.0;
-  float addphase;
+  t_float twopi = x->twopi;
+  //  t_float testsum = 0.0;
+  t_float addphase;
 
   if( x->fade_in_progress ) {
     // pd_error(0, "Crossfade in progress. Cannot generate waveform");
@@ -332,7 +332,7 @@
     old_wavetable[i] = wavetable[i];
     }
   */
-  memcpy(old_wavetable, wavetable, table_length * sizeof(float) );
+  memcpy(old_wavetable, wavetable, table_length * sizeof(t_float) );
 
   x->dirty = 1 ;
 
@@ -347,7 +347,7 @@
       //      post("amp %f phase %f twopi phase %f",harmonic_weights[i],harmonic_phases[i],addphase);
       for( j = 0; j < table_length; j++ ) {
         wavetable[j] +=
-          harmonic_weights[i] * sin( twopi * ((float)i * ((float)j/(float)table_length)) + addphase ) ;
+          harmonic_weights[i] * sin( twopi * ((t_float)i * ((t_float)j/(t_float)table_length)) + addphase ) ;
       }
     }
   }
@@ -377,16 +377,16 @@
 }
 
 void build_waveform( t_oscil *x ) {
-  float rescale;
+  t_float rescale;
   int i, j;
-  float max = 0.0;
-  float *wavetable = x->wavetable;
-  float *old_wavetable = x->old_wavetable;
-  float *harmonic_weights = x->harmonic_weights;
+  t_float max = 0.0;
+  t_float *wavetable = x->wavetable;
+  t_float *old_wavetable = x->old_wavetable;
+  t_float *harmonic_weights = x->harmonic_weights;
   int harmonic_count = x->harmonic_count;
   int table_length = x->table_length;
-  float twopi = x->twopi;
-  //  float testsum = 0.0;
+  t_float twopi = x->twopi;
+  //  t_float testsum = 0.0;
 
   if( x->fade_in_progress ) {
     // pd_error(0, "Crossfade in progress. Cannot generate waveform");
@@ -409,7 +409,7 @@
     old_wavetable[i] = wavetable[i];
     }
   */
-  memcpy(old_wavetable, wavetable, table_length * sizeof(float) );
+  memcpy(old_wavetable, wavetable, table_length * sizeof(t_float) );
 
   x->dirty = 1 ;
 
@@ -421,7 +421,7 @@
   for( i = 1 ; i < harmonic_count; i++ ) {
     if( harmonic_weights[i] ) {
       for( j = 0; j < table_length; j++ ) {
-        wavetable[j] += harmonic_weights[i] * sin( twopi * ( (float) i * ((float) j /(float)table_length)) ) ;
+        wavetable[j] += harmonic_weights[i] * sin( twopi * ( (t_float) i * ((t_float) j /(t_float)table_length)) ) ;
       }
     }
   }
@@ -464,19 +464,19 @@
   double phase = x->phase;
   double phase_offset = x->phase_offset;
   int table_length = x->table_length;
-  float *wavetable = x->wavetable;
-  float *old_wavetable = x->old_wavetable;
+  t_float *wavetable = x->wavetable;
+  t_float *old_wavetable = x->old_wavetable;
   short *connected = x->connected ;
   int fade_countdown = x->fade_countdown;
   int iphase, iphase2;
   int fade_samples = x->fade_samples;
   short fadetype = x->fadetype;
-  float m1, m2;
-  float frac;
+  t_float m1, m2;
+  t_float frac;
   double fphase;
-  float sample1, sample2, outsamp1, outsamp2;
+  t_float sample1, sample2, outsamp1, outsamp2;
 
-  float piotwo = x->piotwo;
+  t_float piotwo = x->piotwo;
 
   if( x->mute ) {
     while (n--) {
@@ -491,7 +491,7 @@
         si = *freq_vec++ * si_factor;
 
       if(connected[1]) {
-        phase_offset = (float)table_length * *phase_vec++;
+        phase_offset = (t_float)table_length * *phase_vec++;
 
       }
 
@@ -523,7 +523,7 @@
         sample2 = old_wavetable[ iphase2 ];
         outsamp2 = sample1 + frac * (sample2 - sample1);
 
-        m2 = (float) fade_countdown / (float) fade_samples ;
+        m2 = (t_float) fade_countdown / (t_float) fade_samples ;
         m1 = 1.0 - m2 ;
         --fade_countdown;
         if( fadetype == 1 ) {
@@ -558,7 +558,7 @@
         si = *freq_vec++ * si_factor;
 
       if(connected[1]) {
-        phase_offset = (float)table_length * *phase_vec++;
+        phase_offset = (t_float)table_length * *phase_vec++;
 
       }
 
@@ -574,7 +574,7 @@
         *out++ = old_wavetable[ iphase ] ;
       }
       else if( fade_countdown ) {
-        m2 = (float) fade_countdown / (float) fade_samples ;
+        m2 = (t_float) fade_countdown / (t_float) fade_samples ;
         m1 = 1.0 - m2 ;
         --fade_countdown;
         if( fadetype == 1 ) {
@@ -623,15 +623,15 @@
   double phase = x->phase;
   double phase_offset = x->phase_offset;
   int table_length = x->table_length;
-  float *wavetable = x->wavetable;
-  float *old_wavetable = x->old_wavetable;
+  t_float *wavetable = x->wavetable;
+  t_float *old_wavetable = x->old_wavetable;
   short *connected = x->connected ;
   int fade_countdown = x->fade_countdown;
   int iphase;
   int fade_samples = x->fade_samples;
   short fadetype = x->fadetype;
-  float m1, m2;
-  float piotwo = x->piotwo;
+  t_float m1, m2;
+  t_float piotwo = x->piotwo;
 
   if( x->mute ) {
     while (n--) {
@@ -645,7 +645,7 @@
       si = *freq_vec++ * si_factor;
 
     if(connected[1]) {
-      phase_offset = (float)table_length * *phase_vec++;
+      phase_offset = (t_float)table_length * *phase_vec++;
 
     }
 
@@ -661,7 +661,7 @@
       *out++ = old_wavetable[ iphase ] ;
     }
     else if( fade_countdown ) {
-      m2 = (float) fade_countdown / (float) fade_samples ;
+      m2 = (t_float) fade_countdown / (t_float) fade_samples ;
       m1 = 1.0 - m2 ;
       --fade_countdown;
       if( fadetype == 1 ) {
@@ -697,12 +697,12 @@
 void oscil_sawtooth(t_oscil *x)
 {
   int i;
-  float sign = 1.0;
+  t_float sign = 1.0;
 
   x->harmonic_weights[0] = 0.0; // DC
   x->harmonic_count = x->bl_harms;
   for( i = 1 ; i < x->bl_harms; i++ ) {
-    x->harmonic_weights[i] = sign * 1.0/(float)i;
+    x->harmonic_weights[i] = sign * 1.0/(t_float)i;
     sign *= -1. ;
   }
   build_waveform(x);
@@ -710,11 +710,11 @@
 void oscil_triangle(t_oscil *x)
 {
   int i;
-  float sign = 1.0;
+  t_float sign = 1.0;
   x->harmonic_weights[0] = 0.0; // DC
   x->harmonic_count = x->bl_harms;
   for( i = 1 ; i < x->bl_harms; i += 2 ) {
-    x->harmonic_weights[i] = sign * 1.0/((float)i * (float)i);
+    x->harmonic_weights[i] = sign * 1.0/((t_float)i * (t_float)i);
     x->harmonic_weights[i + 1] = 0.0;
     sign *= -1;
   }
@@ -735,7 +735,7 @@
   x->harmonic_weights[0] = 0.0; // DC
   x->harmonic_count = x->bl_harms;
   for( i = 1 ; i < x->bl_harms  ; i += 2 ) {
-    x->harmonic_weights[i] = 1.0/(float)i;
+    x->harmonic_weights[i] = 1.0/(t_float)i;
     x->harmonic_weights[i + 1] = 0.0;
   }
   build_waveform(x);
@@ -755,10 +755,10 @@
 void oscil_dsp_free(t_oscil *x)
 {
 
-  t_freebytes(x->wavetable, x->table_length * sizeof(float));
-  t_freebytes(x->old_wavetable, x->table_length * sizeof(float));
-  t_freebytes(x->harmonic_weights, OSCIL_MAXIMUM_HARMONICS * sizeof(float));
-  t_freebytes(x->harmonic_phases, OSCIL_MAXIMUM_HARMONICS * sizeof(float));
+  t_freebytes(x->wavetable, x->table_length * sizeof(t_float));
+  t_freebytes(x->old_wavetable, x->table_length * sizeof(t_float));
+  t_freebytes(x->harmonic_weights, OSCIL_MAXIMUM_HARMONICS * sizeof(t_float));
+  t_freebytes(x->harmonic_phases, OSCIL_MAXIMUM_HARMONICS * sizeof(t_float));
 }
 
 void oscil_dsp(t_oscil *x, t_signal **sp)
@@ -773,7 +773,7 @@
     }
     x->si *= sp[0]->s_sr / x->sr ;
     x->sr = sp[0]->s_sr;
-    x->si_factor = (float) x->table_length / x->sr;
+    x->si_factor = (t_float) x->table_length / x->sr;
   }
 
   x->connected[0] = 1;
--- pd-lyonpotpourri.orig/phasemod~.c
+++ pd-lyonpotpourri/phasemod~.c
@@ -10,18 +10,18 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   t_float x_val;
-  float mygain;
-  float *wavetab;
-  float phs;
-  float bendphs;
-  float frequency;
-  float alpha;
+  t_float mygain;
+  t_float *wavetab;
+  t_float phs;
+  t_float bendphs;
+  t_float frequency;
+  t_float alpha;
   short mute;
   short connections[4];
-  float si_fac;
-  float sr;
+  t_float si_fac;
+  t_float sr;
 } t_phasemod;
 
 static void *phasemod_new(t_symbol *s, int argc, t_atom *argv);
@@ -53,10 +53,10 @@
   if (msg==1) {
     switch (arg) {
     case 0:
-      sprintf(dst,"(signal/float) Frequency ");
+      sprintf(dst,"(signal/t_float) Frequency ");
       break;
     case 1:
-      sprintf(dst,"(signal/float) Slope Factor ");
+      sprintf(dst,"(signal/t_float) Slope Factor ");
       break;
     }
   } else if (msg==2) {
@@ -89,7 +89,7 @@
 t_int *phasemod_perform(t_int *w)
 {
 
-  float phs;
+  t_float phs;
 
   t_phasemod *x = (t_phasemod *) (w[1]);
   t_float *frequency_vec = (t_float *)(w[2]);
@@ -98,12 +98,12 @@
   int n = (int) w[5];
 
   short *connections = x->connections;
-  float bendphs = x->bendphs;
-  float *wavetab = x->wavetab;
-  float si_fac = x->si_fac;
+  t_float bendphs = x->bendphs;
+  t_float *wavetab = x->wavetab;
+  t_float si_fac = x->si_fac;
 
-  float incr = x->frequency * si_fac ;
-  float alpha = x->alpha;
+  t_float incr = x->frequency * si_fac ;
+  t_float alpha = x->alpha;
 
   if( x->mute ) {
     while(n--) {
--- pd-lyonpotpourri.orig/player~.c
+++ pd-lyonpotpourri/player~.c
@@ -21,22 +21,22 @@
 
 typedef struct
 {
-  float phase; // current phase in frames
-  float gain; // gain for this note
+  t_float phase; // current phase in frames
+  t_float gain; // gain for this note
   short status;// status of this event slot
-  float increment;// first increment noted (only if using static increments)
+  t_float increment;// first increment noted (only if using static increments)
 } t_event;
 
 typedef struct _player
 {
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   t_symbol *wavename; // name of waveform buffer
-  float sr; // sampling rate
+  t_float sr; // sampling rate
   short hosed; // buffers are bad
-  float fadeout; // fadeout time in sample frames (if truncation)
-  float sync; // input from groove sync signal
-  float increment; // read increment
+  t_float fadeout; // fadeout time in sample frames (if truncation)
+  t_float sync; // input from groove sync signal
+  t_float increment; // read increment
   short direction; // forwards or backwards
   int most_recent_event; // position in array where last note was initiated
   long b_nchans; // channels of buffer
@@ -68,7 +68,7 @@
 // static t_int *pd_player(t_int *w);
 
 static void player_dsp(t_player *x, t_signal **sp);
-// static float player_boundrand(float min, float max);
+// static t_float player_boundrand(t_float min, t_float max);
 static void player_dsp_free(t_player *x);
 //static void player_float(t_player *x, double f);
 // static void player_interpolation(t_player *x, t_float f);
@@ -174,8 +174,8 @@
     for(i = 0; i < x->overlap_max; i++) {
       x->events[i].status = INACTIVE;
     }
-    // x->increment_vec = realloc(x->increment_vec, x->vs * sizeof(float));
-    // x->trigger_vec = realloc(x->trigger_vec, x->vs * sizeof(float));
+    // x->increment_vec = realloc(x->increment_vec, x->vs * sizeof(t_float));
+    // x->trigger_vec = realloc(x->trigger_vec, x->vs * sizeof(t_float));
   }
 
 }
@@ -217,10 +217,10 @@
 {
 
   //  t_player *x = (t_player *) (w[1]);
-  float *outchan = (t_float *)(w[4]);
+  t_float *outchan = (t_float *)(w[4]);
   int n = (int) w[5];
 
-  memset((void *)outchan,0,sizeof(float) * n);
+  memset((void *)outchan,0,sizeof(t_float) * n);
   return(w+6);
 }
 
@@ -228,13 +228,13 @@
 {
 
   //  t_player *x = (t_player *) (w[1]);
-  float *out1 = (t_float *)(w[4]);
-  float *out2 = (t_float *)(w[5]);
+  t_float *out1 = (t_float *)(w[4]);
+  t_float *out2 = (t_float *)(w[5]);
   int n = (int) w[6];
 
   //  while(n--) *outchan++ = 0.0;
-  memset((void *)out1,0,sizeof(float) * n);
-  memset((void *)out2,0,sizeof(float) * n);
+  memset((void *)out1,0,sizeof(t_float) * n);
+  memset((void *)out2,0,sizeof(t_float) * n);
   return(w+7);
 }
 
@@ -252,11 +252,11 @@
   long b_nchans;
   t_event *events = x->events;
 
-  float increment = x->increment;
+  t_float increment = x->increment;
   int overlap_max = x->overlap_max;
   int iphase;
-  float fphase;
-  float gain;
+  t_float fphase;
+  t_float gain;
   short insert_success;
   int new_insert;
   int i,j,k;
@@ -264,16 +264,16 @@
   t_float *increment_vec = x->increment_vec;
   short bail;
   short static_increment = x->static_increment;
-  float maxphase;
-  float frac;
+  t_float maxphase;
+  t_float frac;
   int theft_candidate;
   int flimit;
-  float samp1, samp2;
+  t_float samp1, samp2;
   long b_frames;
-  float vincrement;
+  t_float vincrement;
 
   if(x->mute || x->hosed) {
-    memset((void *)outchan,0,sizeof(float) * n);
+    memset((void *)outchan,0,sizeof(t_float) * n);
     return(w+6);
   }
   player_setbuf(x, x->wavename);
@@ -283,7 +283,7 @@
 
   if(! x->b_valid) {
     player_stop(x);
-    memset((void *)outchan,0,sizeof(float) * n);
+    memset((void *)outchan,0,sizeof(t_float) * n);
     return(w+6);
   }
 
@@ -309,7 +309,7 @@
     }
   }
   if(bail) {
-    memset((void *)outchan,0,sizeof(float) * n);
+    memset((void *)outchan,0,sizeof(t_float) * n);
     return(w+6);
   }
 
@@ -317,7 +317,7 @@
 
   vincrement = increment_vec[0];
 
-  memset((void *)outchan,0,sizeof(float) * n);
+  memset((void *)outchan,0,sizeof(t_float) * n);
   flimit = (b_frames - 1) * 2;
   for(i = 0; i < overlap_max; i++) {
     if(events[i].status == ACTIVE) {
@@ -467,9 +467,9 @@
 
 
 
-float player_boundrand(float min, float max)
+t_float player_boundrand(t_float min, t_float max)
 {
-  return min + (max-min) * ((float) (rand() % RAND_MAX)/ (float) RAND_MAX);
+  return min + (max-min) * ((t_float) (rand() % RAND_MAX)/ (t_float) RAND_MAX);
 }
 
 
--- pd-lyonpotpourri.orig/pulser~.c
+++ pd-lyonpotpourri/pulser~.c
@@ -13,18 +13,18 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   int components;
-  float global_gain;
-  float *wavetab;
+  t_float global_gain;
+  t_float *wavetab;
 
-  float *phases;
-  float frequency;
-  float pulsewidth;
-  float si_fac;
+  t_float *phases;
+  t_float frequency;
+  t_float pulsewidth;
+  t_float si_fac;
   short mute;
   short connected[4];
-  float sr;
+  t_float sr;
 } t_pulser;
 
 static void *pulser_new(t_symbol *s, int argc, t_atom *argv);
@@ -57,18 +57,18 @@
     return;
   }
   x->components = c;
-  x->global_gain = 1.0 / (float) x->components ;
+  x->global_gain = 1.0 / (t_float) x->components ;
   // reset phases too?
 }
 
 void pulser_free(t_pulser *x)
 {
     /*
-     x->phases = (float *) getbytes(MAX_COMPONENTS * sizeof(float));
-     x->wavetab = (float *) getbytes(FUNC_LEN * sizeof(float));
+     x->phases = (t_float *) getbytes(MAX_COMPONENTS * sizeof(t_float));
+     x->wavetab = (t_float *) getbytes(FUNC_LEN * sizeof(t_float));
      */
-  freebytes(x->phases,MAX_COMPONENTS * sizeof(float));
-  freebytes(x->wavetab,FUNC_LEN * sizeof(float));
+  freebytes(x->phases,MAX_COMPONENTS * sizeof(t_float));
+  freebytes(x->wavetab,FUNC_LEN * sizeof(t_float));
 }
 
 void *pulser_new(t_symbol *s, int argc, t_atom *argv)
@@ -94,18 +94,18 @@
   if( argc > 1 )
     x->components = atom_getfloatarg(1,argc,argv);
 
-  x->si_fac = ((float)FUNC_LEN/x->sr) ;
+  x->si_fac = ((t_float)FUNC_LEN/x->sr) ;
 
   if(x->components <= 0 || x->components > MAX_COMPONENTS) {
     pd_error(0, "%d is an illegal number of components, setting to 8",x->components );
     x->components = 8;
   }
-  x->global_gain = 1.0 / (float) x->components ;
-  x->phases = (float *) getbytes(MAX_COMPONENTS * sizeof(float));
-  x->wavetab = (float *) getbytes(FUNC_LEN * sizeof(float));
+  x->global_gain = 1.0 / (t_float) x->components ;
+  x->phases = (t_float *) getbytes(MAX_COMPONENTS * sizeof(t_float));
+  x->wavetab = (t_float *) getbytes(FUNC_LEN * sizeof(t_float));
 
   for(i = 0 ; i < FUNC_LEN; i++) {
-    x->wavetab[i] = sin(TWOPI * ((float)i/(float) FUNC_LEN)) ;
+    x->wavetab[i] = sin(TWOPI * ((t_float)i/(t_float) FUNC_LEN)) ;
   }
   return (x);
 }
@@ -115,10 +115,10 @@
 {
 
   int i,j;
-  float gain;
-  float incr;
+  t_float gain;
+  t_float incr;
 
-  float outsamp;
+  t_float outsamp;
   int lookdex;
   t_pulser *x = (t_pulser *) (w[1]);
   t_float *frequency_vec = (t_float *)(w[2]);
@@ -127,14 +127,14 @@
   int n = (int) w[5];
 
 
-  float *wavetab = x->wavetab;
-  float si_fac = x->si_fac;
+  t_float *wavetab = x->wavetab;
+  t_float si_fac = x->si_fac;
 
-  float *phases = x->phases;
+  t_float *phases = x->phases;
   int components = x->components;
-  float global_gain = x->global_gain;
-  float pulsewidth = x->pulsewidth;
-  float frequency = x->frequency;
+  t_float global_gain = x->global_gain;
+  t_float pulsewidth = x->pulsewidth;
+  t_float frequency = x->frequency;
   short *connected = x->connected;
 
   if( x->mute )
@@ -166,7 +166,7 @@
 
     for( i = 0, j = 1; i < components; i++, j++ ) {
 
-      lookdex = (float)FUNC_LEN_OVER2 * pulsewidth * (float)j;
+      lookdex = (t_float)FUNC_LEN_OVER2 * pulsewidth * (t_float)j;
 
       while( lookdex >= FUNC_LEN ) {
         lookdex -= FUNC_LEN;
@@ -174,7 +174,7 @@
 
       gain = wavetab[ lookdex ] ;
 
-      phases[i] += incr * (float) j;
+      phases[i] += incr * (t_float) j;
       while( phases[i] < 0.0 ) {
         phases[i] += FUNC_LEN;
       }
@@ -202,7 +202,7 @@
 
   if(x->sr != sp[0]->s_sr) {
     x->sr = sp[0]->s_sr;
-    x->si_fac = ((float)FUNC_LEN/x->sr);
+    x->si_fac = ((t_float)FUNC_LEN/x->sr);
     for(i=0;i<MAX_COMPONENTS;i++) {
       x->phases[i] = 0.0;
     }
--- pd-lyonpotpourri.orig/rtrig~.c
+++ pd-lyonpotpourri/rtrig~.c
@@ -13,11 +13,11 @@
 typedef struct
 {
   int attack_count; // number of triggers per flam event
-  float *attack_times; // trigger times in seconds
+  t_float *attack_times; // trigger times in seconds
   int *attack_points; // trigger times in samples
   int fdex; // current flam
-  float gainatten; // attenuation factor
-  float amp; // current amp
+  t_float gainatten; // attenuation factor
+  t_float amp; // current amp
   int atks;// number of attacks per flam
   long counter; // internal clock
   short active; // flag that flam is turned on
@@ -29,11 +29,11 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
   short mute;
-  float min;
-  float max;
-  float odds;
+  t_float min;
+  t_float max;
+  t_float odds;
 
 } t_rtrig;
 
@@ -68,17 +68,17 @@
 
 void rtrig_min(t_rtrig *x, t_floatarg v)
 {
-  x->min = (float) v;
+  x->min = (t_float) v;
 }
 
 void rtrig_max(t_rtrig *x, t_floatarg v)
 {
-  x->max = (float) v;
+  x->max = (t_float) v;
 }
 
 void rtrig_odds(t_rtrig *x, t_floatarg v)
 {
-  x->odds = (float) v;
+  x->odds = (t_float) v;
 }
 
 
@@ -106,23 +106,23 @@
 {
 
   t_rtrig *x = (t_rtrig *) (w[1]);
-  float *out_vec = (t_float *)(w[2]);
+  t_float *out_vec = (t_float *)(w[2]);
   int n = (int) w[3];
 
-  float rval;
-  float min = x->min;
-  float max = x->max;
-  float odds = x->odds;
+  t_float rval;
+  t_float min = x->min;
+  t_float max = x->max;
+  t_float odds = x->odds;
 
   if(x->mute) {
-    memset( (void *)out_vec, 0, n * sizeof(float) );
+    memset( (void *)out_vec, 0, n * sizeof(t_float) );
     return (w+4);
   }
 
   while( n-- ) {
-    rval = (float) rand() / (float) RAND_MAX2;
+    rval = (t_float) rand() / (t_float) RAND_MAX2;
     if(rval < odds) {
-      rval = min + (max-min) * ((float) rand() / (float) RAND_MAX2);
+      rval = min + (max-min) * ((t_float) rand() / (t_float) RAND_MAX2);
       *out_vec++ = rval;
     } else {
       *out_vec++ = 0.0;
--- pd-lyonpotpourri.orig/samm~.c
+++ pd-lyonpotpourri/samm~.c
@@ -10,7 +10,7 @@
 typedef struct _samm
 {
     t_object x_obj;
-    float x_f;
+    t_float x_f;
     double tempo; /* current tempo */
     double onebeat_samps; /* number of samples for a single beat */
     double *beats; /* amount of beats for each active tempo outlet */
@@ -18,7 +18,7 @@
     double *metro_beatdurs;/* number of beats for each metro time interval */
     double *metro;/* current countdown for each time interval */
     int metro_count; /* number of metronomes to keep track of */
-    float sr; /* current sampling rate */
+    t_float sr; /* current sampling rate */
     short pause;
     short mute;
     // Pd only */
@@ -336,7 +336,7 @@
 t_int *samm_perform(t_int *w)
 {
     int i, j, k;
-    //  float outval;
+    //  t_float outval;
     t_samm *x = (t_samm *) (w[1]);
     t_float *inlet = (t_float *) (w[2]);
     t_float *beat_outlet;
@@ -345,7 +345,7 @@
     
     int metro_count = x->metro_count;
     double *metro = x->metro;
-    float *trigger_vec = x->trigger_vec;
+    t_float *trigger_vec = x->trigger_vec;
     short pause = x->pause;
     
     n = (int) w[metro_count + 3];
--- pd-lyonpotpourri.orig/sigseq~.c
+++ pd-lyonpotpourri/sigseq~.c
@@ -13,31 +13,31 @@
 {
 
   t_object x_obj;
-  float x_f;
+  t_float x_f;
 
   // Variables Here
-  float *sequence;
-  float *trigger_vec; // stores vector with trigger click
+  t_float *sequence;
+  t_float *trigger_vec; // stores vector with trigger click
   int seq_len;
   int seq_ptr;// position in sequence
   short bang_ptr;
-  float tempo;
+  t_float tempo;
   int beat_subdiv;
   int tsamps;
   int counter;
-  float val;
+  t_float val;
   void *mybang;
   void *m_outlet; // NEW
   void *m_clock; // NEW
-  float flat_gain;
-  float last_val;
+  t_float flat_gain;
+  t_float last_val;
   short retro_state;
   short rand_state;
   // ADSR
-  float a;
-  float d;
-  float s;
-  float r;
+  t_float a;
+  t_float d;
+  t_float s;
+  t_float r;
   int ebreak1;
   int ebreak2;
   int ebreak3;
@@ -45,13 +45,13 @@
   int dsamps;
   int ssamps;
   int rsamps;
-  float egain;
+  t_float egain;
   int do_envelope;
   int bang_on;
   short mute;
   int rval;
   int method; //synthesis method to use
-  float sr;
+  t_float sr;
 } t_sigseq;
 
 static void *sigseq_new(t_symbol *s, int argc, t_atom *argv);
@@ -138,7 +138,7 @@
 void sigseq_readfile(t_sigseq *x, t_symbol *filename)
 {
   FILE *fp;
-  float data;
+  t_float data;
   post("requested path: %s", filename->s_name);
   fp = fopen(filename->s_name, "r");
   if( fp == NULL ) {
@@ -182,13 +182,13 @@
 
 void sigseq_tempo(t_sigseq *x, t_symbol *msg, int argc, t_atom *argv)
 {
-  float beatdur;
+  t_float beatdur;
 
   x->tempo = atom_getfloatarg(0,argc,argv);
   if(!x->tempo)
     x->tempo = 120;
 
-  beatdur = (60. / x->tempo ) / (float) x->beat_subdiv ;
+  beatdur = (60. / x->tempo ) / (t_float) x->beat_subdiv ;
   x->tsamps = x->sr * beatdur;
 
   x->asamps = x->sr * x->a;
@@ -234,13 +234,13 @@
 
 void sigseq_init(t_sigseq *x,short initialized)
 {
-  float beatdur;
+  t_float beatdur;
   int asamp, dsamp, ssamp, rsamp;
   //  int i;
 
   if(!initialized) {
-    x->sequence = (float *) t_getbytes(MAX_SEQ * sizeof(float));
-    x->trigger_vec = (float *) t_getbytes(MAX_VEC * sizeof(float));
+    x->sequence = (t_float *) t_getbytes(MAX_SEQ * sizeof(t_float));
+    x->trigger_vec = (t_float *) t_getbytes(MAX_VEC * sizeof(t_float));
     x->seq_len = 3;
     x->seq_ptr = 0;
     x->bang_ptr = 0;
@@ -259,7 +259,7 @@
     x->mute = 0;
   }
 
-  beatdur = (60. / x->tempo ) / (float) x->beat_subdiv;
+  beatdur = (60. / x->tempo ) / (t_float) x->beat_subdiv;
   x->tsamps = x->sr * beatdur;
   x->counter = x->tsamps ;
   x->last_val = 666.6661;
@@ -344,19 +344,19 @@
   t_float *adsr = (t_float *)(w[4]);
   int n = (int) w[5];
   /*********************************************/
-  float *sequence = x->sequence;
+  t_float *sequence = x->sequence;
   int seq_len = x->seq_len;
   int seq_ptr = x->seq_ptr;
   int tsamps = x->tsamps;
   int counter = x->counter;
-  float val = x->val;
-  float last_val = x->last_val;
+  t_float val = x->val;
+  t_float last_val = x->last_val;
   int ebreak1 = x->ebreak1;
   int ebreak2 = x->ebreak2;
   int ebreak3 = x->ebreak3;
-  float egain = x->egain;
-  float env_val;
-  float flat_gain = x->flat_gain;
+  t_float egain = x->egain;
+  t_float env_val;
+  t_float flat_gain = x->flat_gain;
   int do_envelope = x->do_envelope;
   int asamps = x->asamps;
   int dsamps = x->dsamps;
@@ -366,9 +366,9 @@
   short bang_ptr = x->bang_ptr;
   short retro_state = x->retro_state;
   short rand_state = x->rand_state;
-  float etmp;
+  t_float etmp;
   //  short bang_me_now = 0 ;
-  float trand;
+  t_float trand;
   /*********************************************/
   if(x->mute) {
     while (n--) {
@@ -382,7 +382,7 @@
         counter = 0;
         bang_ptr = (bang_ptr + 1) % seq_len ;
         if (rand_state) {
-          trand = (float) ( rand() % 32768 / 32768.0) * (float) seq_len;
+          trand = (t_float) ( rand() % 32768 / 32768.0) * (t_float) seq_len;
           x->rval = trand ;
           seq_ptr = x->rval % seq_len;
 
@@ -408,14 +408,14 @@
       *out++ = val;
       if( do_envelope ) {
         if( counter < ebreak1 ) {
-          env_val = (float) counter / (float) asamps;
+          env_val = (t_float) counter / (t_float) asamps;
         } else if (counter < ebreak2) {
-          etmp = (float) (counter - ebreak1) / (float) dsamps;
+          etmp = (t_float) (counter - ebreak1) / (t_float) dsamps;
           env_val = (1.0 - etmp) + (egain * etmp);
         } else if (counter < ebreak3) {
           env_val = egain;
         } else {
-          env_val = ((float)(tsamps-counter)/(float)rsamps) * egain ;
+          env_val = ((t_float)(tsamps-counter)/(t_float)rsamps) * egain ;
         }
         *adsr++ = env_val;
       } else {
@@ -447,19 +447,19 @@
   t_float *adsr = (t_float *)(w[4]);
   int n = (int) w[5];
   /*********************************************/
-  float *sequence = x->sequence;
+  t_float *sequence = x->sequence;
   int seq_len = x->seq_len;
   int seq_ptr = x->seq_ptr;
   int tsamps = x->tsamps;
   int counter = x->counter;
-  //  float val = x->val;
-  float last_val = x->last_val;
+  //  t_float val = x->val;
+  t_float last_val = x->last_val;
   int ebreak1 = x->ebreak1;
   int ebreak2 = x->ebreak2;
   int ebreak3 = x->ebreak3;
-  float egain = x->egain;
-  float env_val;
-  float flat_gain = x->flat_gain;
+  t_float egain = x->egain;
+  t_float env_val;
+  t_float flat_gain = x->flat_gain;
   int do_envelope = x->do_envelope;
   int asamps = x->asamps;
   int dsamps = x->dsamps;
@@ -469,10 +469,10 @@
   short bang_ptr = x->bang_ptr;
   short retro_state = x->retro_state;
   short rand_state = x->rand_state;
-  float *trigger_vec = x->trigger_vec;
-  float etmp;
+  t_float *trigger_vec = x->trigger_vec;
+  t_float etmp;
   //  short bang_me_now = 0 ;
-  float trand;
+  t_float trand;
   int i;
   /*********************************************/
   if(x->mute) {
@@ -491,7 +491,7 @@
       //     bang_ptr = (bang_ptr + 1) % seq_len ;
 
       if (rand_state) {
-        trand = (float) ( rand() % 32768 / 32768.0) * (float) seq_len;
+        trand = (t_float) ( rand() % 32768 / 32768.0) * (t_float) seq_len;
         x->rval = trand ;
         x->seq_ptr = x->rval % seq_len;
 
@@ -516,14 +516,14 @@
     out[i] = x->val;
     if( do_envelope ) {
       if( counter < ebreak1 ) {
-        env_val = (float) counter / (float) asamps;
+        env_val = (t_float) counter / (t_float) asamps;
       } else if (counter < ebreak2) {
-        etmp = (float) (counter - ebreak1) / (float) dsamps;
+        etmp = (t_float) (counter - ebreak1) / (t_float) dsamps;
         env_val = (1.0 - etmp) + (egain * etmp);
       } else if (counter < ebreak3) {
         env_val = egain;
       } else if(counter < tsamps) {
-        env_val = ((float)(tsamps-counter)/(float)rsamps) * egain ;
+        env_val = ((t_float)(tsamps-counter)/(t_float)rsamps) * egain ;
       } else {
         env_val = 0;
       }
@@ -547,8 +547,8 @@
 
 void sigseq_free(t_sigseq *x)
 {
-    t_freebytes(x->sequence, MAX_SEQ * sizeof(float));
-    t_freebytes(x->trigger_vec, MAX_VEC * sizeof(float));
+    t_freebytes(x->sequence, MAX_SEQ * sizeof(t_float));
+    t_freebytes(x->trigger_vec, MAX_VEC * sizeof(t_float));
     clock_free(x->m_clock);
 }
 
--- pd-lyonpotpourri.orig/vdb~.c
+++ pd-lyonpotpourri/vdb~.c
@@ -6,9 +6,9 @@
 
 typedef struct
 {
-    float coef;
-    float cutoff;
-    float x1;
+    t_float coef;
+    t_float cutoff;
+    t_float x1;
 } t_lpf;
 
 typedef struct {
@@ -23,21 +23,21 @@
 {
     
     t_object x_obj;
-    float x_f;
+    t_float x_f;
     
-    float sr;
+    t_float sr;
     t_lpf lpf;
     short filter;
     //
-    float speed;
-    float feedback;
-    float delay_time;
-    float delay_samps;
-    float maxdelay; // maximum delay in seconds (cannot be larger than buffer)
+    t_float speed;
+    t_float feedback;
+    t_float delay_time;
+    t_float delay_samps;
+    t_float maxdelay; // maximum delay in seconds (cannot be larger than buffer)
     long maxdelay_len; // framelength of usable region of buffer
     long len; // framelength of buffer
     long phs; // current phase
-    float tap;
+    t_float tap;
     short *connections;
     short feedback_protect;
     short mute;
@@ -150,7 +150,7 @@
 
 void vdb_coef(t_vdb *x, t_floatarg f)
 {
-    x->lpf.coef = (float)f;
+    x->lpf.coef = (t_float)f;
 }
 
 void vdb_show(t_vdb *x)
@@ -169,23 +169,23 @@
     t_vdb *x = (t_vdb *)(w[1]);
     int n;
     
-    float fdelay;
-    float insamp; //, insamp2;
-    float outsamp;
-    float frac;
+    t_float fdelay;
+    t_float insamp; //, insamp2;
+    t_float outsamp;
+    t_float frac;
     t_word *delay_line = x->b_samples;
     
     int phs = x->phs;
     long maxdelay_len = x->maxdelay_len;
     
-    float feedback = x->feedback;
+    t_float feedback = x->feedback;
     short *connections = x->connections;
-    float sr = x->sr;
+    t_float sr = x->sr;
     short feedback_protect = x->feedback_protect;
     short interpolate = x->interpolate;
     short inf_hold = x->inf_hold;
     short infhold_buffer_rollout = x->infhold_buffer_rollout;
-    float x1,x2;
+    t_float x1,x2;
     int idelay;
     int dphs,dphs1,dphs2;
     long b_nchans = x->b_nchans;
--- pd-lyonpotpourri.orig/vdp~.c
+++ pd-lyonpotpourri/vdp~.c
@@ -9,9 +9,9 @@
 
 typedef struct
 {
-  float coef;
-  float cutoff;
-  float x1;
+  t_float coef;
+  t_float cutoff;
+  t_float x1;
 } t_lpf;
 
 typedef struct {
@@ -26,25 +26,25 @@
 {
 
   t_object x_obj;
-  float x_f;
-  float sr;
+  t_float x_f;
+  t_float sr;
 
   t_lpf lpf;
   short filter;
 
-  float speed;
-  float feedback;
-  float delay_time;
-  float delay_samps;
-  float maxdel;
+  t_float speed;
+  t_float feedback;
+  t_float delay_time;
+  t_float delay_samps;
+  t_float maxdel;
 
   t_float *delay_line ;
-  float *write_ptr; // location to write current input
-  float *startmem; // first address in delay line
-  float *endmem; // last address to read in delay line
+  t_float *write_ptr; // location to write current input
+  t_float *startmem; // first address in delay line
+  t_float *endmem; // last address to read in delay line
   int len;
   int phs;
-  float tap;
+  t_float tap;
   short connections[4];
 
   short feedback_protect;
@@ -55,7 +55,7 @@
   t_guffer *destbuf; /* for copying to another buffer */
   /* tapering */
   long taper_count;
-  float taper_feedback;
+  t_float taper_feedback;
 } t_vdp;
 
 static t_int *vdp_perform(t_int *w);
@@ -115,7 +115,7 @@
 
 void vdp_coef(t_vdp *x, t_floatarg f)
 {
-  x->lpf.coef = (float)f;
+  x->lpf.coef = (t_float)f;
 }
 
 void vdp_show(t_vdp *x)
@@ -138,26 +138,26 @@
   t_float *output = (t_float *)(w[5]);
   int n = (int) w[6];
 
-  float fdelay;
-  float insamp;
-  float outsamp = 0.0;
-  float frac;
-  float *write_ptr = x->write_ptr;
-  float *read_ptr;
-  float *startmem = x->startmem;
-  float *endmem = x->endmem;
+  t_float fdelay;
+  t_float insamp;
+  t_float outsamp = 0.0;
+  t_float frac;
+  t_float *write_ptr = x->write_ptr;
+  t_float *read_ptr;
+  t_float *startmem = x->startmem;
+  t_float *endmem = x->endmem;
   int len = x->len;
-  float tap = x->tap;
-  float feedback = x->feedback;
-  float delay_samps = x->delay_samps;
+  t_float tap = x->tap;
+  t_float feedback = x->feedback;
+  t_float delay_samps = x->delay_samps;
   short *connections = x->connections;
-  float sr = x->sr;
-  float msr = sr * 0.001;
+  t_float sr = x->sr;
+  t_float msr = sr * 0.001;
   short feedback_protect = x->feedback_protect;
   short interpolate = x->interpolate;
   t_lpf lpf = x->lpf;
   short filter = x->filter;
-  float x1,x2;
+  t_float x1,x2;
   int idelay;
 
   short inf_hold = x->inf_hold;
@@ -169,7 +169,7 @@
     /* while(n--) {
      *output++ = 0.0;
      } */
-    memset( (char *)output, 0, n * sizeof(float) );
+    memset( (char *)output, 0, n * sizeof(t_float) );
     return (w+7);
   }
 
@@ -363,7 +363,7 @@
 
   x->write_ptr = x->startmem;
   /*
-    post("startmem %d endmem %d len %d diff %d diffback %d", x->startmem, x->endmem, x->len, x->endmem - x->startmem, ( x->endmem - x->startmem) /sizeof(float));
+    post("startmem %d endmem %d len %d diff %d diffback %d", x->startmem, x->endmem, x->len, x->endmem - x->startmem, ( x->endmem - x->startmem) /sizeof(t_float));
   */
 }
 
--- pd-lyonpotpourri.orig/waveshape~.c
+++ pd-lyonpotpourri/waveshape~.c
@@ -11,12 +11,12 @@
 {
     
     t_object x_obj;
-    float x_f;
+    t_float x_f;
     int flen;
-    float *wavetab;
-    float *tempeh; // work function
+    t_float *wavetab;
+    t_float *tempeh; // work function
     int hcount;
-    float *harms;
+    t_float *harms;
     short mute;
 } t_waveshape;
 
@@ -25,7 +25,7 @@
 static void waveshape_dsp(t_waveshape *x, t_signal **sp);
 static void waveshape_list (t_waveshape *x, t_symbol *msg, int argc, t_atom *argv);
 static void update_waveshape_function( t_waveshape *x );
-//float mapp();
+//t_float mapp();
 static void waveshape_mute(t_waveshape *x, t_floatarg tog);
 static void waveshape_free(t_waveshape *x);
 
@@ -43,9 +43,9 @@
 
 void waveshape_free(t_waveshape *x)
 {
-    freebytes(x->wavetab, x->flen * sizeof(float));
-    freebytes(x->tempeh, x->flen * sizeof(float));
-    freebytes(x->harms, ws_MAXHARMS * sizeof(float));
+    freebytes(x->wavetab, x->flen * sizeof(t_float));
+    freebytes(x->tempeh, x->flen * sizeof(t_float));
+    freebytes(x->harms, ws_MAXHARMS * sizeof(t_float));
 }
 
 
@@ -77,9 +77,9 @@
     outlet_new(&x->x_obj, gensym("signal"));
     
     x->flen = 65536;
-    x->wavetab = (float *) getbytes(x->flen * sizeof(float));
-    x->tempeh = (float *) getbytes(x->flen * sizeof(float));
-    x->harms = (float *) getbytes(ws_MAXHARMS * sizeof(float));
+    x->wavetab = (t_float *) getbytes(x->flen * sizeof(t_float));
+    x->tempeh = (t_float *) getbytes(x->flen * sizeof(t_float));
+    x->harms = (t_float *) getbytes(ws_MAXHARMS * sizeof(t_float));
     
     x->hcount = 4;
     x->harms[0] = 0;
@@ -92,17 +92,17 @@
 }
 
 void update_waveshape_function( t_waveshape *x ) {
-    float point;
+    t_float point;
     int i, j;
-    float min, max;
+    t_float min, max;
     for( i = 0; i < x->flen; i++ ) {
         x->tempeh[i] = 0;
     }
     for( i = 0 ; i < x->hcount; i++ ) {
         if( x->harms[i] > 0.0 ) {
             for( j = 0; j < x->flen; j++ ) {
-                point = -1.0 + 2.0 * ( (float) j / (float) x->flen) ;
-                x->tempeh[j] += x->harms[i] * cos( (float) i * acos( point ) );
+                point = -1.0 + 2.0 * ( (t_float) j / (t_float) x->flen) ;
+                x->tempeh[j] += x->harms[i] * cos( (t_float) i * acos( point ) );
             }
         }
     }
@@ -130,7 +130,7 @@
 
 t_int *waveshape_perform(t_int *w)
 {
-    float insamp; // , waveshape, ingain ;
+    t_float insamp; // , waveshape, ingain ;
     int windex ;
     
     t_waveshape *x = (t_waveshape *) (w[1]);
@@ -138,7 +138,7 @@
     t_float *out = (t_float *)(w[3]);
     int n = (int) w[4];
     int flenm1 = x->flen - 1;
-    float *wavetab = x->wavetab;
+    t_float *wavetab = x->wavetab;
     
     if(x->mute) {
         while(n--) {
@@ -155,7 +155,7 @@
         else if(insamp < -1.0) {
             insamp = -1.0;
         }
-        windex = ((insamp + 1.0)/2.0) * (float)flenm1 ;
+        windex = ((insamp + 1.0)/2.0) * (t_float)flenm1 ;
         *out++ = wavetab[windex] ;
     }
     
--- pd-lyonpotpourri.orig/MSPd.h
+++ pd-lyonpotpourri/MSPd.h
@@ -29,7 +29,7 @@
 
 
 #include "m_pd.h"
-// #define t_floatarg float
+// #define t_floatarg t_float
 #define t_double double
 
 #define atom_getsymarg atom_getsymbolarg
@@ -46,7 +46,7 @@
 #endif
 
 /*** MSP helper functions **/
-void atom_arg_getfloat(float *c, long idx, long ac, t_atom *av);
+void atom_arg_getfloat(t_float *c, long idx, long ac, t_atom *av);
 void atom_arg_getsym(t_symbol **c, long idx, long ac, t_atom *av);
 
 // #define potpourri_announce(objname)  post("( %s )\t%s",objname,LYONPOTPOURRI_MSG)
--- pd-lyonpotpourri.orig/PenroseOscil.c
+++ pd-lyonpotpourri/PenroseOscil.c
@@ -2,25 +2,25 @@
 #include "PenroseOscil.h"
 
 
-float frequencyToIncrement( float samplingRate, float frequency, int bufferLength ) {
-  return (frequency / samplingRate) * (float) bufferLength;
+t_float frequencyToIncrement( t_float samplingRate, t_float frequency, int bufferLength ) {
+  return (frequency / samplingRate) * (t_float) bufferLength;
 }
 
-void makeSineBuffer( float *buffer, int bufferLength ) {
+void makeSineBuffer( t_float *buffer, int bufferLength ) {
   int   i;
-  float myTwoPi = 8. * atan(1.);
+  t_float myTwoPi = 8. * atan(1.);
 
   for ( i=0; i <= bufferLength; i++ )
-    *(buffer+i) = sin( myTwoPi * ((float) i / (float) bufferLength) );
+    *(buffer+i) = sin( myTwoPi * ((t_float) i / (t_float) bufferLength) );
 
   return;
 }
 
 
-float bufferOscil( float *phase, float increment, float *buffer,
+t_float bufferOscil( t_float *phase, t_float increment, t_float *buffer,
                    int bufferLength )
 {
-  float sample;
+  t_float sample;
 
   while ( *phase > bufferLength )
     *phase -= bufferLength;
--- pd-lyonpotpourri.orig/PenroseOscil.h
+++ pd-lyonpotpourri/PenroseOscil.h
@@ -1,8 +1,8 @@
 
-float frequencyToIncrement( float samplingRate, float frequency,
+t_float frequencyToIncrement( t_float samplingRate, t_float frequency,
                             int bufferLength );
 
-void makeSineBuffer( float *buffer, int bufferLength );
+void makeSineBuffer( t_float *buffer, int bufferLength );
 
-float bufferOscil( float *phase, float increment, float *buffer,
+t_float bufferOscil( t_float *phase, t_float increment, t_float *buffer,
                    int bufferLength );
--- pd-lyonpotpourri.orig/PenroseRand.c
+++ pd-lyonpotpourri/PenroseRand.c
@@ -1,13 +1,13 @@
 #include "PenroseRand.h"
 
-float rrand(int *seed)
+t_float rrand(int *seed)
 {
   int i = ((*seed = *seed * 1103515245 + 12345)>>16) & 077777;
-  return((float)i/16384. - 1.);
+  return((t_float)i/16384. - 1.);
 }
 
-float prand(int *seed)
+t_float prand(int *seed)
 {
   int i = ((*seed = *seed * 1103515245 + 12345)>>16) & 077777;
-  return((float)i/32768.);
+  return((t_float)i/32768.);
 }
--- pd-lyonpotpourri.orig/PenroseRand.h
+++ pd-lyonpotpourri/PenroseRand.h
@@ -1,3 +1,3 @@
 
-float rrand(int *seed);
-float prand(int *seed);
+t_float rrand(int *seed);
+t_float prand(int *seed);
--- pd-lyonpotpourri.orig/bashfest_dsp.c
+++ pd-lyonpotpourri/bashfest_dsp.c
@@ -2,24 +2,24 @@
 
 void lpp_transpose(t_bashfest *x, int slot, int *pcount)
 {
-    float *inbuf;
-    float *outbuf;
+    t_float *inbuf;
+    t_float *outbuf;
     int i;
     int iphs = 0;
     int ip2;
-    float m1, m2;
-    float phs = 0;
+    t_float m1, m2;
+    t_float phs = 0;
     int out_frames;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
-    float *params = x->params;
-    //  float srate = x->sr;
+    t_float *params = x->params;
+    //  t_float srate = x->sr;
     int buflen = x->buf_samps;
     int halfbuffer = x->halfbuffer;
     int buf_frames = x->buf_frames;
-    float tfac;
+    t_float tfac;
     
     ++(*pcount);
     tfac = params[ (*pcount)++ ];
@@ -30,7 +30,7 @@
     outbuf = x->events[slot].workbuffer + out_start;
     
     //  fprintf(stderr,"TRANSPOSE: in %d out %d\n", w->in_start, w->out_start);
-    out_frames = (float) in_frames / tfac ;
+    out_frames = (t_float) in_frames / tfac ;
     if( out_frames > buf_frames / 2 ) {
         out_frames = buf_frames / 2 ;
     }
@@ -61,22 +61,22 @@
 
 void lpp_ringmod(t_bashfest *x, int slot, int *pcount)
 {
-    float *sinewave = x->sinewave;
-    float *inbuf, *outbuf;
+    t_float *sinewave = x->sinewave;
+    t_float *inbuf, *outbuf;
     int sinelen = x->sinelen;
     int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
-    float *params = x->params;
-    float srate = x->sr;
+    t_float *params = x->params;
+    t_float srate = x->sr;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     //  int in_frames = x->events[slot].sample_frames;
     int buflen = x->buf_samps;
     int halfbuffer = x->halfbuffer;
     int i;
-    float phase = 0.0;
-    float si;
-    float rmodFreq;
+    t_float phase = 0.0;
+    t_float si;
+    t_float rmodFreq;
     
     ++(*pcount);
     rmodFreq = params[(*pcount)++];
@@ -88,7 +88,7 @@
     outbuf = x->events[slot].workbuffer + out_start;
     
     
-    si = ((float) sinelen / srate) * rmodFreq ;
+    si = ((t_float) sinelen / srate) * rmodFreq ;
     
     //  inbuf = inbuf + in_start ;
     
@@ -110,13 +110,13 @@
     
     int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
-    //  float *params = x->params;
-    //  float srate = x->sr;
+    //  t_float *params = x->params;
+    //  t_float srate = x->sr;
     int i ;
     int swap1, swap2;
-    float tmpsamp;
+    t_float tmpsamp;
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -129,7 +129,7 @@
     inbuf = x->events[slot].workbuffer + in_start;
     outbuf = x->events[slot].workbuffer + out_start;
     
-    memcpy(outbuf, inbuf, in_frames * channels * sizeof(float) );
+    memcpy(outbuf, inbuf, in_frames * channels * sizeof(t_float) );
     
     if( channels == 1 ) {
         for(i = 0; i < (frames/2)  ; i++ ) {
@@ -164,20 +164,20 @@
 void lpp_comber(t_bashfest *x, int slot, int *pcount)
 {
     int channels = x->events[slot].out_channels;
-    float *params = x->params;
-    float srate = x->sr;
-    float *delayline1 = x->delayline1;
-    float *delayline2 = x->delayline2;
-    float max_delay = x->maxdelay ;
+    t_float *params = x->params;
+    t_float srate = x->sr;
+    t_float *delayline1 = x->delayline1;
+    t_float *delayline2 = x->delayline2;
+    t_float max_delay = x->maxdelay ;
     int buf_frames = x->buf_frames;
     int out_frames ;
-    float overhang, revtime, delay ;
+    t_float overhang, revtime, delay ;
     int i;
     int fade_frames;
-    float fadegain;
+    t_float fadegain;
     int fadestart;
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -231,7 +231,7 @@
     fade_frames = COMBFADE * srate;
     fadestart = (out_frames - fade_frames) * channels ;
     for( i = 0; i < fade_frames * channels; i += channels ) {
-        fadegain = 1.0 - (float) i / (float) (fade_frames * channels)  ;
+        fadegain = 1.0 - (t_float) i / (t_float) (fade_frames * channels)  ;
         *(inbuf + fadestart + i) *= fadegain;
         if(channels == 2) {
             *(inbuf + fadestart + i + 1) *= fadegain;
@@ -248,31 +248,31 @@
 void lpp_flange(t_bashfest *x, int slot, int *pcount)
 {
     int i;
-    float si;
-    float mindel, maxdel;
-    float fac1, fac2;
+    t_float si;
+    t_float mindel, maxdel;
+    t_float fac1, fac2;
     int dv1[2], dv2[2]; /* cmix bookkeeping */
-    float delsamp1, delsamp2 ;
-    float delay_time;
-    //  float dliget2();
-    float speed, feedback, phase, minres, maxres;
-    float hangover ;
+    t_float delsamp1, delsamp2 ;
+    t_float delay_time;
+    //  t_float dliget2();
+    t_float speed, feedback, phase, minres, maxres;
+    t_float hangover ;
     int hangframes ;
     
-    //  float *inbuf = x->events[slot].workbuffer;
+    //  t_float *inbuf = x->events[slot].workbuffer;
     //  int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
     //  int buflen = x->buf_samps;
-    float *params = x->params;
-    float srate = x->sr;
+    t_float *params = x->params;
+    t_float srate = x->sr;
     //  int in_start = x->events[slot].in_start;
-    float *delayline1 = x->delayline1;
-    float *delayline2 = x->delayline2;
-    float max_delay = x->maxdelay ;
-    float *sinewave = x->sinewave;
+    t_float *delayline1 = x->delayline1;
+    t_float *delayline2 = x->delayline2;
+    t_float max_delay = x->maxdelay ;
+    t_float *sinewave = x->sinewave;
     int sinelen = x->sinelen ;
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -312,7 +312,7 @@
     }
     
     
-    si = ((float) sinelen/srate) * speed ;
+    si = ((t_float) sinelen/srate) * speed ;
     
     if( phase > 1.0 ) {
         phase = 0;
@@ -370,12 +370,12 @@
 {
     
     int ftype;
-    float cutoff, cf, bw;
+    t_float cutoff, cf, bw;
     int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
-    float *params = x->params;
-    float srate = x->sr;
-    float *inbuf, *outbuf;
+    t_float *params = x->params;
+    t_float srate = x->sr;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     //  int in_frames = x->events[slot].sample_frames;
@@ -414,18 +414,18 @@
 
 void lpp_truncateme(t_bashfest *x, int slot, int *pcount)
 {
-    float shortdur ;
+    t_float shortdur ;
     int out_frames;
     int i;
-    float fadegain ;
+    t_float fadegain ;
     int fade_frames;
     int fadestart;
-    float fadeout;
+    t_float fadeout;
     int channels = x->events[slot].out_channels;
-    float *params = x->params;
-    float srate = x->sr;
+    t_float *params = x->params;
+    t_float srate = x->sr;
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start;
     int out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -458,12 +458,12 @@
         fade_frames = out_frames;
     }
     
-    memcpy(outbuf, inbuf, in_frames * sizeof(float) );
+    memcpy(outbuf, inbuf, in_frames * sizeof(t_float) );
     
     fadestart = (out_frames - fade_frames) * channels ;
     
     for( i = 0; i < fade_frames * channels; i += channels ) {
-        fadegain = 1.0 - (float) i / (float) (fade_frames * channels)  ;
+        fadegain = 1.0 - (t_float) i / (t_float) (fade_frames * channels)  ;
         outbuf[fadestart + i]   *= fadegain;
         if( channels == 2 ) {
             outbuf[ fadestart + i + 1] *= fadegain;
@@ -479,21 +479,21 @@
 void lpp_sweepreson(t_bashfest *x, int slot, int *pcount)
 {
     int i;
-    float bwfac;
-    float minfreq, maxfreq, speed, phase;
-    float q1[5], q2[5];
-    float cf, bw;
-    float si;
-    float fac1, fac2;
-    //  float inmax, outmax, rescale ;
+    t_float bwfac;
+    t_float minfreq, maxfreq, speed, phase;
+    t_float q1[5], q2[5];
+    t_float cf, bw;
+    t_float si;
+    t_float fac1, fac2;
+    //  t_float inmax, outmax, rescale ;
     //  int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
-    float *params = x->params;
-    float srate = x->sr;
-    float *sinewave = x->sinewave;
+    t_float *params = x->params;
+    t_float srate = x->sr;
+    t_float *sinewave = x->sinewave;
     int sinelen = x->sinelen ;
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -512,7 +512,7 @@
     inbuf = x->events[slot].workbuffer + in_start;
     outbuf = x->events[slot].workbuffer + out_start;
     
-    si = ((float) sinelen / srate) * speed ;
+    si = ((t_float) sinelen / srate) * speed ;
     
     if( phase > 1.0 ) {
         phase = 0;
@@ -564,28 +564,28 @@
 
 void lpp_slidecomb(t_bashfest *x, int slot, int *pcount)
 {
-    float overhang, feedback, delay1, delay2;
+    t_float overhang, feedback, delay1, delay2;
     int i;
     int fade_frames;
-    float fadegain;
+    t_float fadegain;
     int fadestart;
     int dv1[2], dv2[2];   /* cmix bookkeeping */
-    float delsamp1 = 0, delsamp2 = 0;
-    float m1, m2;
-    float delay_time;
+    t_float delsamp1 = 0, delsamp2 = 0;
+    t_float m1, m2;
+    t_float delay_time;
     int out_frames ;
     
     int channels = x->events[slot].out_channels;
     int buf_frames = x->buf_frames;
-    float *params = x->params;
-    float srate = x->sr;
-    //  float *sinewave = x->sinewave;
+    t_float *params = x->params;
+    t_float srate = x->sr;
+    //  t_float *sinewave = x->sinewave;
     //  int sinelen = x->sinelen ;
-    float max_delay = x->maxdelay;
-    float *delayline1 = x->delayline1;
-    float *delayline2 = x->delayline2;
+    t_float max_delay = x->maxdelay;
+    t_float *delayline1 = x->delayline1;
+    t_float *delayline2 = x->delayline2;
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -620,7 +620,7 @@
     
     
     for( i = 0; i < in_frames*channels; i += channels) {
-        m2 = (float) i / (float) (out_frames * channels) ;
+        m2 = (t_float) i / (t_float) (out_frames * channels) ;
         m1 = 1. - m2;
         delay_time = delay1 * m1 + delay2 * m2 ;
         lpp_delput2(*inbuf +delsamp1*feedback, delayline1, dv1);
@@ -634,7 +634,7 @@
     }
     
     for( i = in_frames * channels; i < out_frames*channels; i += channels) {
-        m2 = (float) i / (float) (out_frames * channels) ;
+        m2 = (t_float) i / (t_float) (out_frames * channels) ;
         m1 = 1. - m2;
         delay_time = delay1 * m1 + delay2 * m2 ;
         lpp_delput2( delsamp1*feedback, delayline1, dv1);
@@ -648,7 +648,7 @@
     fade_frames = COMBFADE * srate;
     fadestart = (out_frames - fade_frames) * channels ;
     for( i = 0; i < fade_frames * channels; i += channels ) {
-        fadegain = 1.0 - (float) i / (float) (fade_frames * channels)  ;
+        fadegain = 1.0 - (t_float) i / (t_float) (fade_frames * channels)  ;
         *(outbuf + fadestart + i) *= fadegain;
         if( channels == 2 ) {
             *(outbuf + fadestart + i + 1) *= fadegain;
@@ -664,17 +664,17 @@
 void lpp_reverb1(t_bashfest *x, int slot, int *pcount)
 {
     
-    float revtime, overhang;
+    t_float revtime, overhang;
     int channel_to_compute;
-    float drygain;
+    t_float drygain;
     int out_frames;
     //  int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
     int buf_frames = x->buf_frames;
-    float *params = x->params;
-    float srate = x->sr;
+    t_float *params = x->params;
+    t_float srate = x->sr;
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -716,19 +716,19 @@
 {
     int i,j;
     int nsects;
-    float xnorm;
+    t_float xnorm;
     int filtercode ;
-    float *fltdata;
+    t_float *fltdata;
     
     //  int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
     //  int buf_frames = x->buf_frames;
-    float *params = x->params;
-    //  float srate = x->sr;
-    float **flts = x->ellipse_data;
+    t_float *params = x->params;
+    //  t_float srate = x->sr;
+    t_float **flts = x->ellipse_data;
     LSTRUCT *eel = x->eel;
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -762,31 +762,31 @@
 void lpp_feed1me(t_bashfest *x, int slot, int *pcount)
 {
     //  int i;
-    float mindelay, maxdelay, speed1, speed2;
-    float phz1 = .13, phz2 = .251;
-    float dur;
-    float minfeedback = .1, maxfeedback = .7;
-    float desired_dur;
-    float overhang;
+    t_float mindelay, maxdelay, speed1, speed2;
+    t_float phz1 = .13, phz2 = .251;
+    t_float dur;
+    t_float minfeedback = .1, maxfeedback = .7;
+    t_float desired_dur;
+    t_float overhang;
     /* main variables */
     
     //  int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
     int buf_frames = x->buf_frames;
-    float *params = x->params;
-    float srate = x->sr;
+    t_float *params = x->params;
+    t_float srate = x->sr;
     int out_frames;
     /* process specific */
     int flen = x->feedfunclen ;
-    float *func1 = x->feedfunc1;
-    float *func2 = x->feedfunc2;
-    float *func3 = x->feedfunc3;
-    float *func4 = x->feedfunc4;
-    float my_max_delay = x->max_mini_delay;
-    float *sinewave = x->sinewave;
+    t_float *func1 = x->feedfunc1;
+    t_float *func2 = x->feedfunc2;
+    t_float *func3 = x->feedfunc3;
+    t_float *func4 = x->feedfunc4;
+    t_float my_max_delay = x->max_mini_delay;
+    t_float *sinewave = x->sinewave;
     int sinelen = x->sinelen ;
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -818,19 +818,19 @@
     lpp_funcgen1( func1, flen, desired_dur, mindelay, maxdelay,
              speed1, speed2, 1.0, 1.0, &phz1, &phz2, sinewave, sinelen);
     
-    phz1 /= (float) flen; phz2 /= (float) flen;
+    phz1 /= (t_float) flen; phz2 /= (t_float) flen;
     
     
     lpp_funcgen1( func2, flen, desired_dur, mindelay*.5, maxdelay*2.0,
              speed1*1.25, speed2*.75, 1.0, 1.0, &phz1, &phz2, sinewave, sinelen);
     
-    phz1 /= (float) flen; phz2 /= (float) flen;
+    phz1 /= (t_float) flen; phz2 /= (t_float) flen;
     
     
     lpp_funcgen1( func3, flen, desired_dur, minfeedback, maxfeedback,
              speed1*.35, speed2*1.25, 1.0, 1.0, &phz1, &phz2, sinewave, sinelen);
     
-    phz1 /= (float) flen; phz2 /= (float) flen;
+    phz1 /= (t_float) flen; phz2 /= (t_float) flen;
     
     lpp_funcgen1( func4,flen, desired_dur, minfeedback, maxfeedback,
              speed1*.55, speed2*2.25, 1.0, 1.0, &phz1, &phz2, sinewave, sinelen);
@@ -847,22 +847,22 @@
 {
     //  int channel_to_compute;
     int attacks;
-    float gain2;
-    float gainatten;
-    float delay;
-    float gain = 1.0;
+    t_float gain2;
+    t_float gainatten;
+    t_float delay;
+    t_float gain = 1.0;
     int i, j, k, delaysamps, delayoffset = 0;
-    //  float inputmax;
+    //  t_float inputmax;
     int delay_frames;
     /* main variables */
-    float *inbuf;
-    float *outbuf;
+    t_float *inbuf;
+    t_float *outbuf;
     //  int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
     int buflen = x->buf_samps;
     int buf_frames = x->buf_frames;
-    float *params = x->params;
-    float srate = x->sr;
+    t_float *params = x->params;
+    t_float srate = x->sr;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -888,7 +888,7 @@
     
     delay_frames = srate * delay + 0.5;
     delaysamps = channels * delay_frames;
-    out_frames = in_frames + (srate * delay * (float) (attacks - 1));
+    out_frames = in_frames + (srate * delay * (t_float) (attacks - 1));
     if( out_frames > buf_frames / 2 ) {
         out_frames = buf_frames / 2 ;
     }
@@ -924,33 +924,33 @@
 {
     //  int channel_to_compute;
     int attacks;
-    float gain2;
-    float gainatten;
-    float delay1,delay2;
-    float gain = 1.0;
+    t_float gain2;
+    t_float gainatten;
+    t_float delay1,delay2;
+    t_float gain = 1.0;
     int i, j, k, delaysamps, delayoffset = 0;
     int f_endpoint;
-    //  float inputmax, outputmax, rescale;
+    //  t_float inputmax, outputmax, rescale;
     int delay_frames;
-    float now = 0.0;
+    t_float now = 0.0;
     int findex;
-    float inval;
-    float curdelay;
+    t_float inval;
+    t_float curdelay;
     /* main variables */
-    float *inbuf;
-    float *outbuf;
+    t_float *inbuf;
+    t_float *outbuf;
     int out_frames;
     //  int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
     int buflen = x->buf_samps;
     int buf_frames = x->buf_frames;
-    float *params = x->params;
-    float srate = x->sr;
+    t_float *params = x->params;
+    t_float srate = x->sr;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
     int halfbuffer = x->halfbuffer;
-    float *flamfunc1 = x->flamfunc1;
+    t_float *flamfunc1 = x->flamfunc1;
     int flamfunclen = x->flamfunc1len;
     /* process specific */
     
@@ -970,7 +970,7 @@
     outbuf = x->events[slot].workbuffer + out_start;
     
     for( i = 0; i < attacks - 1; i++ ) {
-        findex = ((float)i/(float)attacks) * (float)flamfunclen ;
+        findex = ((t_float)i/(t_float)attacks) * (t_float)flamfunclen ;
         inval = flamfunc1[findex];
         curdelay = lpp_mapp(inval, 0., 1., delay2, delay1);
         now += curdelay;
@@ -987,7 +987,7 @@
     f_endpoint = in_frames;
     // first time delay_offset is zero
     for( i = 0; i < attacks; i++ ) {
-        findex = ((float)i/(float)attacks) * (float)flamfunclen ;
+        findex = ((t_float)i/(t_float)attacks) * (t_float)flamfunclen ;
         inval = flamfunc1[findex];
         curdelay = lpp_mapp(inval, 0., 1., delay2, delay1);
         
@@ -1019,33 +1019,33 @@
 void lpp_expflam(t_bashfest *x, int slot, int *pcount)
 {
     int attacks;
-    float gain2;
-    float gainatten;
-    float delay1,delay2;
-    float gain = 1.0;
+    t_float gain2;
+    t_float gainatten;
+    t_float delay1,delay2;
+    t_float gain = 1.0;
     int i, j, k, delaysamps, delayoffset = 0, f_endpoint;
-    //  float inputmax, outputmax, rescale;
+    //  t_float inputmax, outputmax, rescale;
     int delay_frames;
-    float now = 0.0;
+    t_float now = 0.0;
     //  int findex;
-    //  float inval;
-    float curdelay;
-    float slope;
+    //  t_float inval;
+    t_float curdelay;
+    t_float slope;
     /* main variables */
-    float *inbuf;
-    float *outbuf;
+    t_float *inbuf;
+    t_float *outbuf;
     int out_frames;
     //  int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
     int buflen = x->buf_samps;
     int buf_frames = x->buf_frames;
-    float *params = x->params;
-    float srate = x->sr;
+    t_float *params = x->params;
+    t_float srate = x->sr;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
     int halfbuffer = x->halfbuffer;
-    float *expfunc = x->feedfunc1;
+    t_float *expfunc = x->feedfunc1;
     //  int funclen = x->feedfunclen;
     /* process specific */
     
@@ -1111,27 +1111,27 @@
 
 void lpp_comb4(t_bashfest *x, int slot, int *pcount)
 {
-    float overhang, revtime ;
+    t_float overhang, revtime ;
     int i, j, k;
     int fadeFrames;
-    float fadegain;
+    t_float fadegain;
     int fadestart;
-    float input_sample;
-    float rez;
+    t_float input_sample;
+    t_float rez;
     /* main variables */
     
     int out_frames;
     //  int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
     int buf_frames = x->buf_frames;
-    float *params = x->params;
-    float srate = x->sr;
+    t_float *params = x->params;
+    t_float srate = x->sr;
     
     /* process specific */
     CMIXCOMB *combies = x->combies;
-    float maxloop = x->max_comb_lpt;
+    t_float maxloop = x->max_comb_lpt;
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -1191,7 +1191,7 @@
     fadeFrames = COMBFADE * srate; // ok - this is just the fadeout
     fadestart = (out_frames - fadeFrames) * channels ;
     for( i = 0; i < fadeFrames * channels; i += channels ) {
-        fadegain = 1.0 - (float) i / (float) (fadeFrames * channels)  ;
+        fadegain = 1.0 - (t_float) i / (t_float) (fadeFrames * channels)  ;
         *(outbuf + fadestart + i) *= fadegain;
         if( channels == 2 ) {
             *(outbuf + fadestart + i + 1) *= fadegain;
@@ -1206,23 +1206,23 @@
 
 void lpp_compdist(t_bashfest *x, int slot, int *pcount)
 {
-    float cutoff, maxmult;
+    t_float cutoff, maxmult;
     int lookupflag;
     int channel_to_compute;
-    float maxamp;
+    t_float maxamp;
     /* main variables */
     
     //  int out_frames;
     //  int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
     //  int buf_frames = x->buf_frames;
-    float *params = x->params;
-    //  float srate = x->sr;
+    t_float *params = x->params;
+    //  t_float srate = x->sr;
     /* function specific */
     int range = x->tf_len;
-    float *table = x->transfer_function;
+    t_float *table = x->transfer_function;
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -1256,29 +1256,29 @@
 
 void lpp_ringfeed(t_bashfest *x, int slot, int *pcount)
 {
-    float overhang;
+    t_float overhang;
     int i, j;
     int fade_frames;
-    float fadegain;
+    t_float fadegain;
     int fadestart;
-    float input_sample;
-    float rez ;
+    t_float input_sample;
+    t_float rez ;
     /* main variables */
     int out_frames;
     //  int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
     int buf_frames = x->buf_frames;
-    float *params = x->params;
-    float srate = x->sr;
+    t_float *params = x->params;
+    t_float srate = x->sr;
     /* function specific */
-    float *sinewave = x->sinewave;
+    t_float *sinewave = x->sinewave;
     int sinelen = x->sinelen ;
     CMIXCOMB *combies = x->combies;
     CMIXRESON *resies = x->resies;
     CMIXOSC oscar = x->oscar;
-    float maxloop = x->max_comb_lpt;
+    t_float maxloop = x->max_comb_lpt;
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -1293,7 +1293,7 @@
     
     oscar.func = sinewave;
     oscar.len = sinelen;
-    oscar.si = params[(*pcount)++] * ((float)oscar.len / srate);
+    oscar.si = params[(*pcount)++] * ((t_float)oscar.len / srate);
     oscar.phs = 0;
     rez = params[(*pcount)++] ;
     if( rez > 0 )
@@ -1349,7 +1349,7 @@
     fade_frames = COMBFADE * srate;
     fadestart = (out_frames - fade_frames) * channels ;
     for( i = 0; i < fade_frames * channels; i += channels ) {
-        fadegain = 1.0 - (float) i / (float) (fade_frames * channels)  ;
+        fadegain = 1.0 - (t_float) i / (t_float) (fade_frames * channels)  ;
         *(outbuf + fadestart + i) *= fadegain;
         if( channels == 2 ) {
             *(outbuf + fadestart + i + 1) *= fadegain;
@@ -1364,12 +1364,12 @@
 void lpp_resonadsr(t_bashfest *x, int slot, int *pcount)
 {
     int i;
-    float bwfac;
-    float q1[5], q2[5];
-    float cf, bw;
-    float si;
-    float notedur;
-    float phase = 0.;
+    t_float bwfac;
+    t_float q1[5], q2[5];
+    t_float cf, bw;
+    t_float si;
+    t_float notedur;
+    t_float phase = 0.;
     //  int j = 0;
     /* main variables */
     
@@ -1377,11 +1377,11 @@
     //  int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
     //  int buf_frames = x->buf_frames;
-    float *params = x->params;
-    float srate = x->sr;
+    t_float *params = x->params;
+    t_float srate = x->sr;
     
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     int in_frames = x->events[slot].sample_frames;
@@ -1391,7 +1391,7 @@
     /* function specific */
     CMIXADSR *a = x->adsr;
     int funclen = a->len;
-    float *adsrfunc = a->func;
+    t_float *adsrfunc = a->func;
     
     ++(*pcount);
     a->a = params[(*pcount)++];
@@ -1407,13 +1407,13 @@
     inbuf = x->events[slot].workbuffer + in_start;
     outbuf = x->events[slot].workbuffer + out_start;
     
-    notedur = (float) in_frames / srate ;
+    notedur = (t_float) in_frames / srate ;
     a->s = notedur - (a->a+a->d+a->r);
     if( a->s <= 0.0 ) {
         a->a=a->d=a->s=a->r= notedur/ 4. ;
     }
     lpp_buildadsr(a);
-    si = ((float) funclen / srate) / notedur ;
+    si = ((t_float) funclen / srate) / notedur ;
     
     phase = 0;
     
@@ -1450,23 +1450,23 @@
     int frames = x->events[slot].sample_frames;
     int channels = x->events[slot].out_channels;
     //  int buf_frames = x->buf_frames;
-    float *params = x->params;
-    float srate = x->sr;
+    t_float *params = x->params;
+    t_float srate = x->sr;
     /* function specific */
-    float *sinewave = x->sinewave;
+    t_float *sinewave = x->sinewave;
     int sinelen = x->sinelen ;
-    float *delayline1 = x->delayline1;
-    float *delayline2 = x->delayline2;
-    float max_delay = x->maxdelay ;
+    t_float *delayline1 = x->delayline1;
+    t_float *delayline2 = x->delayline2;
+    t_float max_delay = x->maxdelay ;
     CMIXOSC osc1, osc2; // put into main object structure
-    float mindel, maxdel;
-    float fac1, fac2;
+    t_float mindel, maxdel;
+    t_float fac1, fac2;
     int dv1[2], dv2[2]; /* cmix bookkeeping */
-    float delay_time;
-    float speed1, speed2, depth ;
-    //  float max;
+    t_float delay_time;
+    t_float speed1, speed2, depth ;
+    //  t_float max;
     
-    float *inbuf, *outbuf;
+    t_float *inbuf, *outbuf;
     int in_start = x->events[slot].in_start;
     int out_start = x->events[slot].out_start;
     //  int in_frames = x->events[slot].sample_frames;
@@ -1497,13 +1497,13 @@
     
     osc1.func = sinewave;
     osc1.len = sinelen;
-    osc1.si = ((float) sinelen / srate ) * speed1 ;
+    osc1.si = ((t_float) sinelen / srate ) * speed1 ;
     osc1.phs = 0;
     osc1.amp = fac2;
     
     osc2.func = sinewave;
     osc2.len = sinelen;
-    osc2.si = ((float) sinelen / srate ) * speed2 ;
+    osc2.si = ((t_float) sinelen / srate ) * speed2 ;
     osc2.phs = 0;
     osc2.amp = fac2;
     
--- pd-lyonpotpourri.orig/bashfest_helper.c
+++ pd-lyonpotpourri/bashfest_helper.c
@@ -1,11 +1,11 @@
 #include "bashfest.h"
 #include "stdlib.h"
 
-void lpp_putsine (float *arr, int len);
-float lpp_boundrand(float min, float max);
+void lpp_putsine (t_float *arr, int len);
+t_float lpp_boundrand(t_float min, t_float max);
 
 
-void lpp_putsine (float *arr, int len)
+void lpp_putsine (t_float *arr, int len)
 {
     int i;
     double twopi;
@@ -16,13 +16,13 @@
     }
 }
 
-float lpp_boundrand(float min, float max)
+t_float lpp_boundrand(t_float min, t_float max)
 {
-    return min + (max-min) * ((float)rand()/MY_MAX);
+    return min + (max-min) * ((t_float)rand()/MY_MAX);
 }
 
 
-void lpp_mycombset(float loopt,float rvt,int init,float *a,float srate)
+void lpp_mycombset(t_float loopt,t_float rvt,int init,t_float *a,t_float srate)
 {
     int j;
     
@@ -35,9 +35,9 @@
     }
 }
 
-float lpp_mycomb(float samp,float *a)
+t_float lpp_mycomb(t_float samp,t_float *a)
 {
-    float temp,*aptr;
+    t_float temp,*aptr;
     if ( a[2] >= (int) a[0])
         a[2] = 3;
     aptr = a + (int)a[2];
@@ -47,9 +47,9 @@
     return(temp);
 }
 
-void lpp_setweights(float *a, int len)
+void lpp_setweights(t_float *a, int len)
 {
-    float sum = 0.0;
+    t_float sum = 0.0;
     int i;
     for(i=0;i<len;i++)
     sum += a[i];
@@ -62,9 +62,9 @@
     a[i] += a[i-1];
 }
 
-void  lpp_delset2(float *a,int *l,float xmax, float srate)
+void  lpp_delset2(t_float *a,int *l,t_float xmax, t_float srate)
 {
-    /* delay initialization.  a is address of float array, l is size-2 int
+    /* delay initialization.  a is address of t_float array, l is size-2 int
      * array for bookkeeping variables, xmax, is maximum expected delay */
     
     int i;
@@ -73,22 +73,22 @@
     for(i = 0; i < *(l+1); i++) *(a+i) = 0;
 }
 
-void lpp_delput2(float x,float *a,int *l)
+void lpp_delput2(t_float x,t_float *a,int *l)
 {
     
-    /* put value in delay line. See delset. x is float */
+    /* put value in delay line. See delset. x is t_float */
     
     *(a + (*l)++) = x;
     if(*(l) >= *(l+1)) *l -= *(l+1);
 }
 
-float lpp_dliget2(float *a,float wait,int *l,float srate)
+t_float lpp_dliget2(t_float *a,t_float wait,int *l,t_float srate)
 {
     /* get interpolated value from delay line, wait seconds old */
     register int im1;
-    float x = wait * srate;
+    t_float x = wait * srate;
     register int i = x;
-    float frac = x - i;
+    t_float frac = x - i;
     i = *l - i;
     im1 = i - 1;
     if(i <= 0) {
@@ -99,11 +99,11 @@
     return(*(a+i) + frac * (*(a+im1) - *(a+i)));
 }
 
-void lpp_butterLopass( float *in, float *out, float cutoff, int frames, int channels, float srate)
+void lpp_butterLopass( t_float *in, t_float *out, t_float cutoff, int frames, int channels, t_float srate)
 
 {
     int channel_to_compute;
-    float data[8];
+    t_float data[8];
     
     for( channel_to_compute = 0; channel_to_compute < channels; channel_to_compute++) {
         lpp_butset( data );
@@ -113,10 +113,10 @@
     
 }
 
-void lpp_butterBandpass(float *in, float *out, float center, float bandwidth, int frames,int  channels, float srate)
+void lpp_butterBandpass(t_float *in, t_float *out, t_float center, t_float bandwidth, int frames,int  channels, t_float srate)
 {
     int channel_to_compute;
-    float data[8];
+    t_float data[8];
     
     for( channel_to_compute = 0; channel_to_compute < channels; channel_to_compute++) {
         lpp_butset( data );
@@ -127,10 +127,10 @@
 }
 
 
-void lpp_butterHipass(float *in, float *out, float cutoff, int frames,int channels, float srate)
+void lpp_butterHipass(t_float *in, t_float *out, t_float cutoff, int frames,int channels, t_float srate)
 {
     int channel_to_compute;
-    float data[8];
+    t_float data[8];
     
     for( channel_to_compute = 0; channel_to_compute < channels; channel_to_compute++) {
         lpp_butset( data );
@@ -140,14 +140,14 @@
     
 }
 
-void lpp_butset(float *a)
+void lpp_butset(t_float *a)
 {
     a[6] = a[7] = 0.0;
 }
 
-void lpp_lobut(float *a, float cutoff,float SR)
+void lpp_lobut(t_float *a, t_float cutoff,t_float SR)
 {
-    register float   c;
+    register t_float   c;
     
     c = 1.0 / tan( PI * cutoff / SR);
     a[1] = 1.0 / ( 1.0 + ROOT2 * c + c * c);
@@ -159,10 +159,10 @@
     
 }
 
-void lpp_hibut(float *a, float cutoff, float SR)
+void lpp_hibut(t_float *a, t_float cutoff, t_float SR)
 {
     
-    register float  c;
+    register t_float  c;
     
     c = tan( PI * cutoff / SR);
     a[1] = 1.0 / ( 1.0 + ROOT2 * c + c * c);
@@ -173,9 +173,9 @@
     
 }
 
-void lpp_bpbut(float *a, float formant, float bandwidth,float  SR)
+void lpp_bpbut(t_float *a, t_float formant, t_float bandwidth,t_float  SR)
 {
-    register float  c, d;
+    register t_float  c, d;
     
     c = 1.0 / tan( PI * bandwidth / SR);
     d = 2.0 * cos( 2.0 * PI * formant / SR);
@@ -188,11 +188,11 @@
 }
 /* in array can == out array */
 
-void lpp_butter_filter(float *in,float *out,float *a, int frames, int channels, int channel)
+void lpp_butter_filter(t_float *in,t_float *out,t_float *a, int frames, int channels, int channel)
 {
     
     int i;
-    float t ,y ;
+    t_float t ,y ;
     
     for( i = channel ; i < frames * channels; i+= channels )
     {
@@ -204,10 +204,10 @@
     }
 }
 
-void lpp_rsnset2(float cf,float bw,float scl,float xinit,float *a,float srate)
+void lpp_rsnset2(t_float cf,t_float bw,t_float scl,t_float xinit,t_float *a,t_float srate)
 {
     //  double exp(),cos(),sqrt();
-    float c,temp;
+    t_float c,temp;
     if(!xinit) {
         a[4] = 0;
         a[3] = 0;
@@ -221,18 +221,18 @@
     if(!scl) a[0] = temp*sqrt(1.-a[1]*a[1]/(4.*a[2]));
 }
 
-float lpp_reson(float x,float *a)
+t_float lpp_reson(t_float x,t_float *a)
 {
-    float temp;
+    t_float temp;
     temp = *a * x + *(a+1) * *(a+3) - *(a+2) * *(a+4);
     *(a+4) = *(a+3);
     *(a+3) = temp;
     return(temp);
 }
 
-float lpp_allpass(float samp,float *a)
+t_float lpp_allpass(t_float samp,t_float *a)
 {
-    float temp,*aptr;
+    t_float temp,*aptr;
     if ( a[STARTM1] >= (int) a[0]) a[STARTM1] = START;
     aptr = a + (int)a[STARTM1];
     a[STARTM1] ++;
@@ -241,7 +241,7 @@
     return(temp - a[1] * *aptr);
 }
 
-void lpp_init_reverb_data(float *a)
+void lpp_init_reverb_data(t_float *a)
 {
     a[0] = 2;
     a[1] = -0.61043329;
@@ -255,24 +255,24 @@
     a[9] = 0.035888535;
 }
 
-void lpp_reverb1me(float *in, float *out, int inFrames, int out_frames, int nchans,
-                   int channel, float revtime, float dry, t_bashfest *x)
+void lpp_reverb1me(t_float *in, t_float *out, int inFrames, int out_frames, int nchans,
+                   int channel, t_float revtime, t_float dry, t_bashfest *x)
 {
-    float dels[4];// stick into main structure
-    float **alpo = x->mini_delay ;
-    float a1,a2,a3,a4;
+    t_float dels[4];// stick into main structure
+    t_float **alpo = x->mini_delay ;
+    t_float a1,a2,a3,a4;
     int i;
     //  int alsmp ;
-    float *fltdata = x->reverb_ellipse_data;
+    t_float *fltdata = x->reverb_ellipse_data;
     
     int nsects;
-    float xnorm;
+    t_float xnorm;
     LSTRUCT *eel = x->eel;
     
-    float wet;
-    //  float max;
-    float srate = x->sr;
-    //  float max_del = x->max_mini_delay ;
+    t_float wet;
+    //  t_float max;
+    t_float srate = x->sr;
+    //  t_float max_del = x->max_mini_delay ;
     
     wet = cos(1.570796 * dry);
     dry = sin(1.570796 * dry);
@@ -312,23 +312,23 @@
     
 }
 
-void lpp_feed1(float *inbuf, float *outbuf, int in_frames, int out_frames,int channels, float *functab1,
-               float *functab2,float *functab3,float *functab4,int funclen,
-               float duration, float maxDelay, t_bashfest *x)
+void lpp_feed1(t_float *inbuf, t_float *outbuf, int in_frames, int out_frames,int channels, t_float *functab1,
+               t_float *functab2,t_float *functab3,t_float *functab4,int funclen,
+               t_float duration, t_float maxDelay, t_bashfest *x)
 {
     int i;
-    float srate = x->sr;
-    float *delayLine1a = x->mini_delay[0];
-    float *delayLine2a = x->mini_delay[1];
-    float *delayLine1b = x->mini_delay[2];
-    float *delayLine2b = x->mini_delay[3];
+    t_float srate = x->sr;
+    t_float *delayLine1a = x->mini_delay[0];
+    t_float *delayLine2a = x->mini_delay[1];
+    t_float *delayLine1b = x->mini_delay[2];
+    t_float *delayLine2b = x->mini_delay[3];
     int dv1a[2], dv2a[2];   /* cmix bookkeeping */
     int dv1b[2], dv2b[2];   /* cmix bookkeeping */
-    float delsamp1a=0, delsamp2a=0 ;
-    float delsamp1b=0, delsamp2b=0 ;
-    float delay1, delay2, feedback1, feedback2;
-    float funcSi, funcPhs;
-    float putsamp;
+    t_float delsamp1a=0, delsamp2a=0 ;
+    t_float delsamp1b=0, delsamp2b=0 ;
+    t_float delay1, delay2, feedback1, feedback2;
+    t_float funcSi, funcPhs;
+    t_float putsamp;
     
     /***************************/
     
@@ -336,7 +336,7 @@
     
     // read once during note
     
-    funcSi = ((float) funclen / srate) / duration ;
+    funcSi = ((t_float) funclen / srate) / duration ;
     
     
     lpp_delset2(delayLine1a, dv1a, maxDelay,srate);
@@ -357,7 +357,7 @@
         feedback2 = functab4[ (int) funcPhs ];
         
         funcPhs += funcSi;
-        if( funcPhs >= (float) funclen )
+        if( funcPhs >= (t_float) funclen )
             funcPhs = 0;
         
         putsamp = i < in_frames * channels ? inbuf[i] + delsamp1a*feedback1 : 0.0;
@@ -386,18 +386,18 @@
     }
 }
 
-void lpp_setflamfunc1(float *arr, int flen)
+void lpp_setflamfunc1(t_float *arr, int flen)
 {
     int i;
-    float x;
+    t_float x;
     for ( i = 0; i < flen; i++) {
-        x = (float)i / (float) flen ;
+        x = (t_float)i / (t_float) flen ;
         *(arr + i) = ((x - 1) / (x + 1)) * -1.  ;
     }
 }
 
 
-void lpp_setExpFlamFunc(float *arr, int flen, float v1,float v2,float alpha)
+void lpp_setExpFlamFunc(t_float *arr, int flen, t_float v1,t_float v2,t_float alpha)
 {
     int i;
     
@@ -405,23 +405,23 @@
         alpha = .00000001 ;
     
     for ( i = 0; i < flen; i++) {
-        *(arr + i) = v1 + (v2-v1) * ((1-exp((float)i*alpha/((float)flen-1.)))/(1-exp(alpha)));
+        *(arr + i) = v1 + (v2-v1) * ((1-exp((t_float)i*alpha/((t_float)flen-1.)))/(1-exp(alpha)));
     }
 }
 
-void lpp_funcgen1(float *outArray, int outlen, float duration, float outMin, float outMax,
-                  float speed1, float speed2, float gain1, float gain2, float *phs1, float *phs2,
-                  float *sine, int sinelen)
+void lpp_funcgen1(t_float *outArray, int outlen, t_float duration, t_float outMin, t_float outMax,
+                  t_float speed1, t_float speed2, t_float gain1, t_float gain2, t_float *phs1, t_float *phs2,
+                  t_float *sine, int sinelen)
 {
-    float si1, si2;
-    float localSR;
+    t_float si1, si2;
+    t_float localSR;
     int i;
     
-    localSR = duration * (float) outlen ;
-    *phs1 *= (float) sinelen;
-    *phs2 *= (float) sinelen;
-    si1 = ((float)sinelen/localSR)  * speed1;
-    si2 = ((float)sinelen/localSR)  * speed2;
+    localSR = duration * (t_float) outlen ;
+    *phs1 *= (t_float) sinelen;
+    *phs2 *= (t_float) sinelen;
+    si1 = ((t_float)sinelen/localSR)  * speed1;
+    si2 = ((t_float)sinelen/localSR)  * speed2;
     
     for( i = 0; i < outlen; i++ ) {
         *(outArray + i) = lpp_oscil(gain1, si1, sine, sinelen, phs1) ;
@@ -431,11 +431,11 @@
 }
 
 
-void lpp_normtab(float *inarr,float *outarr, float min, float max, int len)
+void lpp_normtab(t_float *inarr,t_float *outarr, t_float min, t_float max, int len)
 {
     int i;
     
-    float imin=9999999999., imax=-9999999999.;
+    t_float imin=9999999999., imax=-9999999999.;
     
     for(i = 0; i < len ; i++) {
         if( imin > inarr[i] )
@@ -447,7 +447,7 @@
     outarr[i] = lpp_mapp(inarr[i], imin, imax, min, max);
 }
 
-float lpp_mapp(float in,float imin,float imax,float omin,float omax)
+t_float lpp_mapp(t_float in,t_float imin,t_float imax,t_float omin,t_float omax)
 {
     if( imax == 0.0 )
     {
@@ -456,7 +456,7 @@
     return( omin+((omax-omin)*((in-imin)/(imax-imin))) );
 }
 
-float lpp_oscil(float amp,float si,float *farray,int len,float *phs)
+t_float lpp_oscil(t_float amp,t_float si,t_float *farray,int len,t_float *phs)
 {
     register int i =  *phs;
     *phs += si;
@@ -465,15 +465,15 @@
     return(*(farray+i) * amp);
 }
 
-void lpp_killdc( float *inbuf, int in_frames, int channels, t_bashfest *x)
+void lpp_killdc( t_float *inbuf, int in_frames, int channels, t_bashfest *x)
 {
     int i,j=1;
     LSTRUCT *eel = x->eel;
     int nsects;
-    float xnorm;
-    float *dcflt = x->dcflt;
+    t_float xnorm;
+    t_float *dcflt = x->dcflt;
     
-    /* float dcflt[64] =
+    /* t_float dcflt[64] =
      {3, -1.9999924    , -1.9992482    ,  1.0000000
      ,  .99928019    ,
      -1.9999956    , -1.9964080    ,  1.0000000    ,  .99645999    ,
@@ -489,7 +489,7 @@
     }
 }
 
-void lpp_set_dcflt(float *a)
+void lpp_set_dcflt(t_float *a)
 {
     a[0] = 3;
     a[1] = -1.9999924;
@@ -507,14 +507,14 @@
     a[13] = 0.98817413;
 }
 
-void lpp_set_distortion_table(float *arr, float cut, float max, int len)
+void lpp_set_distortion_table(t_float *arr, t_float cut, t_float max, int len)
 {
     int i, len2;
-    float samp;
+    t_float samp;
     
     len2 = len>>1 ;
     for( i = len2; i < len; i++ ) {
-        samp = (float)(i - len2) / (float) len2 ;
+        samp = (t_float)(i - len2) / (t_float) len2 ;
         if( samp > cut )
             samp = lpp_mapp( samp, cut, 1.0,  cut, max );
         *(arr + i) = samp;
@@ -523,16 +523,16 @@
     *(arr + i) = - *(arr + len - (i+1));
 }
 
-float lpp_dlookup(float samp,float *arr,int len)
+t_float lpp_dlookup(t_float samp,t_float *arr,int len)
 {
-    return arr[(int) (((samp+1.0)/2.0) * (float) len)];
+    return arr[(int) (((samp+1.0)/2.0) * (t_float) len)];
 }
 
-void lpp_do_compdist(float *in,float *out,int sampFrames,int nchans,int channel,
-                     float cutoff,float maxmult,int lookupflag,float *table,int range,float bufMaxamp)
+void lpp_do_compdist(t_float *in,t_float *out,int sampFrames,int nchans,int channel,
+                     t_float cutoff,t_float maxmult,int lookupflag,t_float *table,int range,t_float bufMaxamp)
 {
     int i;
-    float rectsamp;
+    t_float rectsamp;
     
     for( i = channel ; i < sampFrames * nchans; i+= nchans ) {
         if( lookupflag) {
@@ -547,10 +547,10 @@
     }
 }
 
-float lpp_getmaxamp(float *arr, int len)
+t_float lpp_getmaxamp(t_float *arr, int len)
 {
     int i;
-    float max = 0;
+    t_float max = 0;
     
     for(i = 0; i < len; i++ ) {
         if( fabs(arr[i]) > max )
@@ -561,22 +561,22 @@
 
 void lpp_buildadsr(CMIXADSR *a)
 {
-    float A = a->a;
-    float D = a->d;
-    float S = a->s;
-    float R = a->r;
-    float f1 = a->v1;
-    float f2 = a->v2;
-    float f3 = a->v3;
-    float f4 = a->v4;
+    t_float A = a->a;
+    t_float D = a->d;
+    t_float S = a->s;
+    t_float R = a->r;
+    t_float f1 = a->v1;
+    t_float f2 = a->v2;
+    t_float f3 = a->v3;
+    t_float f4 = a->v4;
     
     int funclen = a->len;
-    float *func = a->func;
-    float total;
+    t_float *func = a->func;
+    t_float total;
     int ipoint = 0;
     int i;
     int segs[4];
-    float m1,m2;
+    t_float m1,m2;
     total = A + D + S + R ;
     
     segs[0] = (A/total) * funclen;
@@ -604,28 +604,28 @@
     }
     
     for( i = 0 ; i < segs[0]; i++ ) {
-        m1 = 1.-(float)i/(float)(segs[0]);
+        m1 = 1.-(t_float)i/(t_float)(segs[0]);
         m2 = 1. - m1;
         *(func +i ) = f1 * m1 + f2 * m2;
     }
     ipoint = i;
     
     for( i = 0 ; i < segs[1]; i++ ) {
-        m1 = 1.-(float)i/(float)(segs[1]);
+        m1 = 1.-(t_float)i/(t_float)(segs[1]);
         m2 = 1. - m1;
         *(func + i + ipoint) = f2 * m1 + f3 * m2;
     }
     ipoint += i;
     
     for( i = 0 ; i < segs[2]; i++ ) {
-        m1 = 1.-(float)i/(float)(segs[2]);
+        m1 = 1.-(t_float)i/(t_float)(segs[2]);
         m2 = 1. - m1;
         *(func + i + ipoint) = f3;
     }
     ipoint += i;
     
     for( i = 0 ; i < segs[3]; i++ ) {
-        m1 = 1.-(float)i/(float)(segs[3]);
+        m1 = 1.-(t_float)i/(t_float)(segs[3]);
         m2 = 1. - m1;
         *(func + ipoint + i) = f3 * m1 + f4 * m2;
     }
--- pd-lyonpotpourri.orig/bashfest~.c
+++ pd-lyonpotpourri/bashfest~.c
@@ -24,7 +24,7 @@
 static t_int *bashfest_perform_hosed(t_int *w);
 static void bashfest_dsp(t_bashfest *x, t_signal **sp);
 static void bashfest_dsp_free(t_bashfest *x);
-static int bashfest_set_parameters(t_bashfest *x,float *params);
+static int bashfest_set_parameters(t_bashfest *x,t_float *params);
 static t_int *bashfest_perform(t_int *w);
 static void bashfest_deploy_dsp(t_bashfest *x);
 static void bashfest_copy_to_MSP_buffer(t_bashfest *x, int slot);
@@ -47,7 +47,7 @@
 static void bashfest_tcycle(t_bashfest *x,t_symbol *msg, int argc, t_atom *argv);
 /* function code */
 
-void lpp_killdc( float *inbuf, int in_frames, int channels, t_bashfest *x);
+void lpp_killdc( t_float *inbuf, int in_frames, int channels, t_bashfest *x);
 void lpp_ringmod(t_bashfest *x, int slot, int *pcount);
 void lpp_retrograde(t_bashfest *x, int slot, int *pcount);
 void lpp_comber(t_bashfest *x, int slot, int *pcount);
@@ -70,7 +70,7 @@
 void lpp_compdist(t_bashfest *x, int slot, int *pcount);
 
 
-void atom_arg_getfloat(float *c, long idx, long ac, t_atom *av);
+void atom_arg_getfloat(t_float *c, long idx, long ac, t_atom *av);
 void atom_arg_getsym(t_symbol **c, long idx, long ac, t_atom *av);
 
 
@@ -135,7 +135,7 @@
         return;
     }
     /*  if(n > x->latency_samples) {
-     x->trigger_buffer = (float *) realloc(x->trigger_buffer, n * sizeof(float));
+     x->trigger_buffer = (t_float *) realloc(x->trigger_buffer, n * sizeof(t_float));
      }
      x->tb_inpt = 0;
      x->tb_outpt = x->latency_samples - x->vs;*/
@@ -167,7 +167,7 @@
 {
     t_cycle tcycle = x->tcycle;
     int i;
-    float data=1.0;
+    t_float data=1.0;
     
     if(argc < 1) {
         pd_error(0, "no data for tcycle!");
@@ -257,7 +257,7 @@
     
     int i;
     long membytes = 0;
-    float tmpfloat;
+    t_float tmpfloat;
     srand(time(0));
     
     x->sr = sys_getsr();
@@ -310,81 +310,81 @@
     x->maxdelay = 1.0; // in seconds
     /*memory allocation */
     x->events = (t_event *) t_getbytes(x->overlap_max * sizeof(t_event));
-    x->trigger_vec = (float *) t_getbytes(MAX_VEC * sizeof(float));
-    x->sinewave = t_getbytes(x->sinelen * sizeof(float));
-    x->params = t_getbytes(MAX_PARAMETERS * sizeof(float));
-    x->odds = t_getbytes(64 * sizeof(float));
-    //  x->trigger_buffer = calloc(x->latency_samples, sizeof(float));
+    x->trigger_vec = (t_float *) t_getbytes(MAX_VEC * sizeof(t_float));
+    x->sinewave = t_getbytes(x->sinelen * sizeof(t_float));
+    x->params = t_getbytes(MAX_PARAMETERS * sizeof(t_float));
+    x->odds = t_getbytes(64 * sizeof(t_float));
+    //  x->trigger_buffer = calloc(x->latency_samples, sizeof(t_float));
     
     for(i=0;i<64;i++)
     x->odds[i] = 0;
     lpp_putsine(x->sinewave, x->sinelen);
     for(i=0;i<x->overlap_max;i++) {
-        x->events[i].workbuffer = (float *) t_getbytes(x->buf_samps * sizeof(float));
+        x->events[i].workbuffer = (t_float *) t_getbytes(x->buf_samps * sizeof(t_float));
     }
-    x->delayline1 = (float *) t_getbytes(x->maxdelay * x->sr * sizeof(float));
-    x->delayline2 = (float *) t_getbytes(x->maxdelay * x->sr * sizeof(float));
+    x->delayline1 = (t_float *) t_getbytes(x->maxdelay * x->sr * sizeof(t_float));
+    x->delayline2 = (t_float *) t_getbytes(x->maxdelay * x->sr * sizeof(t_float));
     x->max_mini_delay = .25;
     x->eel = (LSTRUCT *) t_getbytes(MAXSECTS * sizeof(LSTRUCT));
     for( i = 0; i < 4 ; i++ ) {
         x->mini_delay[i] =
-        (float *) t_getbytes(((int)(x->sr * x->max_mini_delay) + 1)  * sizeof(float));
+        (t_float *) t_getbytes(((int)(x->sr * x->max_mini_delay) + 1)  * sizeof(t_float));
     }
-    x->reverb_ellipse_data = (float *) t_getbytes(16 * sizeof(float));
+    x->reverb_ellipse_data = (t_float *) t_getbytes(16 * sizeof(t_float));
     
-    x->ellipse_data = (float **) t_getbytes(MAXFILTER * sizeof(float *));
+    x->ellipse_data = (t_float **) t_getbytes(MAXFILTER * sizeof(t_float *));
     for(i=0;i<MAXFILTER;i++) {
-        x->ellipse_data[i] = (float *) t_getbytes(MAX_COEF * sizeof(float));
+        x->ellipse_data[i] = (t_float *) t_getbytes(MAX_COEF * sizeof(t_float));
     }
     x->tf_len = 1;
     x->tf_len <<= 16;
-    x->transfer_function = (float *) t_getbytes(x->tf_len * sizeof(float) );
+    x->transfer_function = (t_float *) t_getbytes(x->tf_len * sizeof(t_float) );
     x->feedfunclen = 8192 ;
-    x->feedfunc1 = (float *) t_getbytes( x->feedfunclen * sizeof(float) );
-    x->feedfunc2 = (float *) t_getbytes( x->feedfunclen * sizeof(float) );
-    x->feedfunc3 = (float *) t_getbytes( x->feedfunclen * sizeof(float) );
-    x->feedfunc4 = (float *) t_getbytes( x->feedfunclen * sizeof(float) );
+    x->feedfunc1 = (t_float *) t_getbytes( x->feedfunclen * sizeof(t_float) );
+    x->feedfunc2 = (t_float *) t_getbytes( x->feedfunclen * sizeof(t_float) );
+    x->feedfunc3 = (t_float *) t_getbytes( x->feedfunclen * sizeof(t_float) );
+    x->feedfunc4 = (t_float *) t_getbytes( x->feedfunclen * sizeof(t_float) );
     x->flamfunc1len = 8192 ;
-    x->flamfunc1 = (float *) t_getbytes( x->flamfunc1len * sizeof(float));
+    x->flamfunc1 = (t_float *) t_getbytes( x->flamfunc1len * sizeof(t_float));
     lpp_setflamfunc1(x->flamfunc1,x->flamfunc1len);
     x->max_comb_lpt = 0.15 ;// watch out here
     x->combies = (CMIXCOMB *) t_getbytes(4 * sizeof(CMIXCOMB));
     for( i = 0; i < 4; i++ ) {
         x->combies[i].len = x->sr * x->max_comb_lpt + 2;
-        x->combies[i].arr = (float *) t_getbytes(x->combies[i].len * sizeof(float));
+        x->combies[i].arr = (t_float *) t_getbytes(x->combies[i].len * sizeof(t_float));
     }
     x->adsr = (CMIXADSR *) t_getbytes(1 * sizeof(CMIXADSR));
     x->adsr->len = 32768 ;
-    x->adsr->func = (float *) t_getbytes(x->adsr->len * sizeof(float) );
-    x->dcflt = (float *) t_getbytes(16 * sizeof(float));
-    x->tcycle.data = (float *) t_getbytes(CYCLE_MAX * sizeof(float));
+    x->adsr->func = (t_float *) t_getbytes(x->adsr->len * sizeof(t_float) );
+    x->dcflt = (t_float *) t_getbytes(16 * sizeof(t_float));
+    x->tcycle.data = (t_float *) t_getbytes(CYCLE_MAX * sizeof(t_float));
     x->tcycle.len = 0;
     for(i=0;i<x->overlap_max;i++) {
         x->events[i].phasef = x->events[i].phase = 0.0;
     }
     
     membytes = x->overlap_max * sizeof(t_event);
-    membytes += x->sinelen * sizeof(float);
-    membytes += MAX_PARAMETERS * sizeof(float);
-    membytes += 64 * sizeof(float);
-    membytes += x->buf_samps * sizeof(float) * x->overlap_max;
-    membytes += x->maxdelay * x->sr * sizeof(float) * 2;
+    membytes += x->sinelen * sizeof(t_float);
+    membytes += MAX_PARAMETERS * sizeof(t_float);
+    membytes += 64 * sizeof(t_float);
+    membytes += x->buf_samps * sizeof(t_float) * x->overlap_max;
+    membytes += x->maxdelay * x->sr * sizeof(t_float) * 2;
     membytes += MAXSECTS * sizeof(LSTRUCT);
-    membytes += ((int)(x->sr * x->max_mini_delay) + 1)  * sizeof(float) * 4;
-    membytes += 16 * sizeof(float);
-    membytes += MAXFILTER * sizeof(float *);
-    membytes += MAX_COEF * sizeof(float) * MAXFILTER;
-    membytes += x->tf_len * sizeof(float);
-    membytes += x->feedfunclen * sizeof(float) * 4;
-    membytes += x->flamfunc1len * sizeof(float);
+    membytes += ((int)(x->sr * x->max_mini_delay) + 1)  * sizeof(t_float) * 4;
+    membytes += 16 * sizeof(t_float);
+    membytes += MAXFILTER * sizeof(t_float *);
+    membytes += MAX_COEF * sizeof(t_float) * MAXFILTER;
+    membytes += x->tf_len * sizeof(t_float);
+    membytes += x->feedfunclen * sizeof(t_float) * 4;
+    membytes += x->flamfunc1len * sizeof(t_float);
     membytes += 4 * sizeof(CMIXCOMB);
-    membytes += x->combies[0].len * sizeof(float) * 4;
+    membytes += x->combies[0].len * sizeof(t_float) * 4;
     membytes += sizeof(CMIXADSR);
-    membytes += x->adsr->len * sizeof(float);
-    membytes += 16 * sizeof(float);
-    membytes += CYCLE_MAX * sizeof(float);
+    membytes += x->adsr->len * sizeof(t_float);
+    membytes += 16 * sizeof(t_float);
+    membytes += CYCLE_MAX * sizeof(t_float);
     
-    // post("total memory for this bashfest %.2f MBytes",(float)membytes/1000000.);
+    // post("total memory for this bashfest %.2f MBytes",(t_float)membytes/1000000.);
     
     /* be sure to finish clearing memory */
     lpp_set_dcflt(x->dcflt);
@@ -445,15 +445,15 @@
 {
     
     //  t_bashfest *x = (t_bashfest *) (w[1]);
-    //  float *trigger = (t_float *)(w[2]);
-    float *outchanL = (t_float *)(w[3]);
-    float *outchanR = (t_float *)(w[4]);
+    //  t_float *trigger = (t_float *)(w[2]);
+    t_float *outchanL = (t_float *)(w[3]);
+    t_float *outchanR = (t_float *)(w[4]);
     int n = (int) w[5];
     
     // try bzero
     //  while(n--) *outchanL++ = *outchanR++ = 0.0;
-    memset((char *)outchanL, 0, sizeof(float) * n);
-    memset((char *)outchanR, 0, sizeof(float) * n);
+    memset((char *)outchanL, 0, sizeof(t_float) * n);
+    memset((char *)outchanR, 0, sizeof(t_float) * n);
     return(w+6);
     
 }
@@ -463,9 +463,9 @@
 t_int *bashfest_perform(t_int *w)
 {
     t_bashfest *x = (t_bashfest *) (w[1]);
-    float *t_vec = (t_float *)(w[2]);
-    float *outchanL = (t_float *)(w[3]);
-    float *outchanR = (t_float *)(w[4]);
+    t_float *t_vec = (t_float *)(w[2]);
+    t_float *outchanL = (t_float *)(w[3]);
+    t_float *outchanR = (t_float *)(w[4]);
     int n = (int) w[5];
     
     t_word *b_samples;
@@ -475,7 +475,7 @@
     
     t_event *events = x->events;
     //  int active_events = x->active_events;
-    float increment = x->increment;
+    t_float increment = x->increment;
     int overlap_max = x->overlap_max;
     int iphase;
     int flimit;
@@ -483,18 +483,18 @@
     int new_insert;
     int i,j,k;
     t_cycle tcycle = x->tcycle;
-    float gain;
+    t_float gain;
     //  short bail;
-    float frac;
-    float samp1, samp2;
-    float maxphase;
+    t_float frac;
+    t_float samp1, samp2;
+    t_float maxphase;
     int theft_candidate;
     int out_channels;
-    float *processed_drum;
+    t_float *processed_drum;
     char *sound_name = x->sound_name;
     
     int latency_samples = x->latency_samples;
-    float *trigger_vec = x->trigger_vec;
+    t_float *trigger_vec = x->trigger_vec;
     
     for(i = 0; i < n; i++)
     trigger_vec[i] = t_vec[i];
@@ -789,7 +789,7 @@
     for(i = 0; i < overlap_max; i++) {
         if( events[i].status == ACTIVE) {
             out_channels = events[i].out_channels;
-            /* assign the output part of work buffer to the local float buffer */
+            /* assign the output part of work buffer to the local t_float buffer */
             
             processed_drum = events[i].workbuffer + events[i].in_start;
             
@@ -911,7 +911,7 @@
     long b_nchans = x->b_nchans;
     long b_frames = x->b_frames;
     t_word *b_samples = x->b_samples;
-    float *processed_drum;
+    t_float *processed_drum;
     
     processed_drum = events[slot].workbuffer + events[slot].in_start;
     
@@ -937,17 +937,17 @@
     long b_nchans = x->b_nchans;
     long b_frames = x->b_frames;
     t_event *events = x->events;
-    float pan;
+    t_float pan;
     int i; //,j;
-    float *params = x->params;
+    t_float *params = x->params;
     int pcount;
     int buf_samps = x->buf_samps;
     int curarg = 0;
-    float maxamp;
-    float rescale;
-    float *inbuf;
+    t_float maxamp;
+    t_float rescale;
+    t_float *inbuf;
     int slot = x->new_slot;
-    float gain = x->new_gain;
+    t_float gain = x->new_gain;
     
     events[slot].completed = 1;// for testing only
     
@@ -1077,18 +1077,18 @@
         pd_error(0, "deploy_dsp: failed to conclude in time; need more latency");
 }
 
-int bashfest_set_parameters(t_bashfest *x,float *params)
+int bashfest_set_parameters(t_bashfest *x,t_float *params)
 {
-    float rval;
+    t_float rval;
     int pcount = 0;
     int events;
     int i, j;
     int type;
-    float cf;//, bw;
-    float *odds = x->odds;
+    t_float cf;//, bw;
+    t_float *odds = x->odds;
     int maxproc  = x->max_process_per_note;
     int minproc = x->min_process_per_note;
-    float tval;
+    t_float tval;
     t_cycle tcycle = x->tcycle;
     
     /* preliminary transposition will be set here */
@@ -1270,40 +1270,40 @@
 {
     int i;
     
-    t_freebytes(x->sinewave, x->sinelen * sizeof(float));
-    t_freebytes(x->params, MAX_PARAMETERS * sizeof(float));
-    t_freebytes(x->odds, 64 * sizeof(float));
-    t_freebytes(x->delayline1, x->maxdelay * x->sr * sizeof(float));
-    t_freebytes(x->delayline2, x->maxdelay * x->sr * sizeof(float));
+    t_freebytes(x->sinewave, x->sinelen * sizeof(t_float));
+    t_freebytes(x->params, MAX_PARAMETERS * sizeof(t_float));
+    t_freebytes(x->odds, 64 * sizeof(t_float));
+    t_freebytes(x->delayline1, x->maxdelay * x->sr * sizeof(t_float));
+    t_freebytes(x->delayline2, x->maxdelay * x->sr * sizeof(t_float));
     
     for(i=0;i<x->overlap_max;i++) {
-        t_freebytes(x->events[i].workbuffer, x->buf_samps * sizeof(float));
+        t_freebytes(x->events[i].workbuffer, x->buf_samps * sizeof(t_float));
     }
     t_freebytes(x->events, x->overlap_max * sizeof(t_event));
     
     t_freebytes(x->eel,MAXSECTS * sizeof(LSTRUCT));
     for( i = 0; i < 4 ; i++ ) {
-        t_freebytes(x->mini_delay[i], ((int)(x->sr * x->max_mini_delay) + 1) * sizeof(float));
+        t_freebytes(x->mini_delay[i], ((int)(x->sr * x->max_mini_delay) + 1) * sizeof(t_float));
     }
-    t_freebytes(x->reverb_ellipse_data, 16 * sizeof(float));
+    t_freebytes(x->reverb_ellipse_data, 16 * sizeof(t_float));
     for(i=0;i<MAXFILTER;i++) {
-        t_freebytes(x->ellipse_data[i], MAX_COEF * sizeof(float));
+        t_freebytes(x->ellipse_data[i], MAX_COEF * sizeof(t_float));
     }
-    t_freebytes(x->ellipse_data, MAXFILTER * sizeof(float *));
-    t_freebytes(x->transfer_function,x->tf_len * sizeof(float));
-    t_freebytes(x->feedfunc1, x->feedfunclen * sizeof(float));
-    t_freebytes(x->feedfunc2, x->feedfunclen * sizeof(float));
-    t_freebytes(x->feedfunc3, x->feedfunclen * sizeof(float));
-    t_freebytes(x->feedfunc4, x->feedfunclen * sizeof(float));
-    t_freebytes(x->flamfunc1, x->flamfunc1len * sizeof(float));
+    t_freebytes(x->ellipse_data, MAXFILTER * sizeof(t_float *));
+    t_freebytes(x->transfer_function,x->tf_len * sizeof(t_float));
+    t_freebytes(x->feedfunc1, x->feedfunclen * sizeof(t_float));
+    t_freebytes(x->feedfunc2, x->feedfunclen * sizeof(t_float));
+    t_freebytes(x->feedfunc3, x->feedfunclen * sizeof(t_float));
+    t_freebytes(x->feedfunc4, x->feedfunclen * sizeof(t_float));
+    t_freebytes(x->flamfunc1, x->flamfunc1len * sizeof(t_float));
     for( i = 0; i < 4; i++ ) {
-        t_freebytes(x->combies[i].arr, x->combies[i].len * sizeof(float));
+        t_freebytes(x->combies[i].arr, x->combies[i].len * sizeof(t_float));
     }
     t_freebytes(x->combies,4 * sizeof(CMIXCOMB));
-    t_freebytes(x->adsr->func, x->adsr->len * sizeof(float));
+    t_freebytes(x->adsr->func, x->adsr->len * sizeof(t_float));
     t_freebytes(x->adsr,sizeof(CMIXADSR));
-    t_freebytes(x->tcycle.data,CYCLE_MAX * sizeof(float));
-    t_freebytes(x->trigger_vec, MAX_VEC * sizeof(float));
+    t_freebytes(x->tcycle.data,CYCLE_MAX * sizeof(t_float));
+    t_freebytes(x->trigger_vec, MAX_VEC * sizeof(t_float));
 }
 
 void bashfest_dsp(t_bashfest *x, t_signal **sp)
--- pd-lyonpotpourri.orig/bloscbank.c
+++ pd-lyonpotpourri/bloscbank.c
@@ -1,12 +1,12 @@
 
 #include "fftease.h"
 
-void bloscbank( float *S, float *O, int D, float iD, float *lf, float *la, float *index, float *tab,
-                int len, float synt, int lo, int hi )
+void bloscbank( t_float *S, t_float *O, int D, t_float iD, t_float *lf, t_float *la, t_float *index, t_float *tab,
+                int len, t_float synt, int lo, int hi )
 {
   int    amp,freq,chan, i;
 
-  float    a,ainc,f,finc,address;
+  t_float    a,ainc,f,finc,address;
 
   for ( chan = lo; chan < hi; chan++ ) {
 
--- pd-lyonpotpourri.orig/chameleon~.c
+++ pd-lyonpotpourri/chameleon~.c
@@ -94,10 +94,10 @@
 /*function prototypes*/
 
 static void putsine (double *arr, long len);
-static float boundrand(float min, float max);
+static t_float boundrand(t_float min, t_float max);
 static void mycombset(double loopt,double rvt,int init,double *a,double srate);
 static double mycomb(double samp,double *a);
-static void setweights(float *a, int len);
+static void setweights(t_float *a, int len);
 static void  delset2(double *a,int *l,double xmax, double srate);
 static void  delset3(double *a,int *l,double xmax,double srate, double alloc_max);
 static void delput2(double x,double *a,int *l);
@@ -115,7 +115,7 @@
 static void init_reverb_data(double *a);
 static void init_ellipse_data(double **a);
 static void killdc( double *inbuf, int in_frames, int channels, t_chameleon *x);
-// static void setExpFlamFunc(float *arr, int flen, float v1,float v2,float alpha);
+// static void setExpFlamFunc(t_float *arr, int flen, t_float v1,t_float v2,t_float alpha);
 static void setflamfunc1(double *arr, int flen);
 static void funcgen1(double *outArray, int outlen, double duration, double outMin, double outMax,
               double speed1, double speed2, double gain1, double gain2, double *phs1, double *phs2,
@@ -135,7 +135,7 @@
            double *functab2,double *functab3,double *functab4,int funclen,
            double duration, double maxDelay, t_chameleon *x);
 static void reverb1me(double *in, double *out, int inFrames, int out_frames, int nchans, int channel, double revtime, double dry, t_chameleon *x);
-// static void atom_arg_getfloat(float *c, long idx, long ac, t_atom *av);
+// static void atom_arg_getfloat(t_float *c, long idx, long ac, t_atom *av);
 
 /* Main Pure Data code */
 
@@ -196,8 +196,8 @@
     for(i = 0; i < MAX_SLOTS; i++){
         if( slots[i].pcount > 0 ){
             SETSYMBOL(data+data_index, loadslot); data_index++;
-            SETFLOAT(data+data_index, (float)i); data_index++;
-            SETFLOAT(data+data_index, (float)slots[i].pcount); data_index++;
+            SETFLOAT(data+data_index, (t_float)i); data_index++;
+            SETFLOAT(data+data_index, (t_float)slots[i].pcount); data_index++;
             for(j = 0; j < slots[i].pcount; j++){
                 SETFLOAT(data+data_index, slots[i].params[j]); data_index++;
             }
@@ -402,7 +402,7 @@
     membytes += (x->sinelen + 1) * sizeof(double);
     x->params = (double *) getbytes(MAX_PARAMETERS * sizeof(double));
     membytes += MAX_PARAMETERS * sizeof(double);
-    x->odds = (float *) getbytes(64 * sizeof(float));
+    x->odds = (t_float *) getbytes(64 * sizeof(t_float));
     x->distortion_length = 32768;
     x->distortion_function = (double *) getbytes(x->distortion_length * sizeof(double));
     membytes += x->distortion_length * sizeof(double);
@@ -601,7 +601,7 @@
         x->resonadsr_units[i].adsr = (CMIXADSR *)getbytes(sizeof(CMIXADSR));
         membytes += sizeof(CMIXADSR);
         x->resonadsr_units[i].adsr->func = (double *)getbytes(8192 * sizeof(double));
-        membytes += 8192 * sizeof(float);
+        membytes += 8192 * sizeof(t_float);
         x->resonadsr_units[i].adsr->len = 8192;
     }
     
@@ -700,7 +700,7 @@
 
 void chameleon_memory(t_chameleon *x)
 {
-    post("Memory allocation for this instance of chameleon~ is %.2f MBytes",(float)x->membytes/1000000.0);
+    post("Memory allocation for this instance of chameleon~ is %.2f MBytes",(t_float)x->membytes/1000000.0);
 }
 
 void chameleon_dsp_free(t_chameleon *x)
@@ -711,7 +711,7 @@
     freebytes(x->data,1024 * sizeof(t_atom));
     freebytes(x->sinewave,(x->sinelen + 1) * sizeof(double));
     freebytes(x->params,MAX_PARAMETERS * sizeof(double));
-    freebytes(x->odds,64 * sizeof(float));
+    freebytes(x->odds,64 * sizeof(t_float));
     
     // free combs
     for(i= 0; i < max_dsp_units; i++){
@@ -1016,8 +1016,8 @@
     }
     // HERE GOES THE OUTPUT. Downgrade Chameleon doubles to Pd single-precision floats
     for(i = 0; i < n; i++){
-        outchanL[i] = (float) chan1[i];
-        outchanR[i] = (float) chan2[i];
+        outchanL[i] = (t_float) chan1[i];
+        outchanR[i] = (t_float) chan2[i];
     }
 panic:
     ;
@@ -1841,7 +1841,7 @@
         }
     }
     
-//    events = floor( boundrand( (float)minproc, (float) maxproc) );
+//    events = floor( boundrand( (t_float)minproc, (t_float) maxproc) );
 
     x->pcount = pcount;
 }
@@ -1849,12 +1849,12 @@
 void chameleon_set_parameters_exec(t_chameleon *x)
 {
     long max_dsp_units = x->max_dsp_units;
-    float rval;
+    t_float rval;
     int events;
     int i, j;
     int ftype;
     double cf, bw;//, bw;
-    float *odds = x->odds;
+    t_float *odds = x->odds;
     int maxproc  = x->max_process_per_note;
     int minproc = x->min_process_per_note;
     double delay, revtime;
@@ -1905,7 +1905,7 @@
         return;
     }
     
-    events = floor( boundrand( (float)minproc, (float) maxproc) );
+    events = floor( boundrand( (t_float)minproc, (t_float) maxproc) );
 
     pcount = 0;
     if( DEBUG_CHAMELEON ){
@@ -2229,7 +2229,7 @@
 
 void chameleon_dsp(t_chameleon *x, t_signal **sp)
 {
-    float samplerate;
+    t_float samplerate;
     x->vs = sp[0]->s_n;
     samplerate = sys_getsr();
     // post("chameleon - dsp blocksize %d, and sample rate %f", x->vs, samplerate);
@@ -2525,9 +2525,9 @@
 }
 
 
-float boundrand(float min, float max)
+t_float boundrand(t_float min, t_float max)
 {
-    return min + (max-min) * ((float)rand()/MY_MAX);
+    return min + (max-min) * ((t_float)rand()/MY_MAX);
 }
 
 
@@ -2557,9 +2557,9 @@
     return(temp);
 }
 
-void setweights(float *a, int len)
+void setweights(t_float *a, int len)
 {
-    float sum = 0.0;
+    t_float sum = 0.0;
     int i;
     for(i=0;i<len;i++)
         sum += a[i];
@@ -2576,7 +2576,7 @@
 
 void  delset2(double *a,int *l,double xmax, double srate)
 {
-    /* delay initialization.  a is address of float array, l is size-2 int
+    /* delay initialization.  a is address of t_float array, l is size-2 int
      * array for bookkeeping variables, xmax, is maximum expected delay */
     
     int i;
@@ -2590,7 +2590,7 @@
 
 void  delset3(double *a,int *l,double xmax,double srate, double alloc_max)
 {
-    /* delay initialization.  a is address of float array, l is size-2 int
+    /* delay initialization.  a is address of t_float array, l is size-2 int
      * array for bookkeeping variables, xmax, is maximum expected delay */
     
     int i;
@@ -2608,7 +2608,7 @@
 void delput2(double x,double *a,int *l)
 {
     
-    /* put value in delay line. See delset. x is float */
+    /* put value in delay line. See delset. x is t_float */
     
     if( ((*l) >= 0)  && ((*l) < *(l+1)) ){
         *(a + (*l)++) = x;
@@ -2635,14 +2635,14 @@
     return(*(a+i) + frac * (*(a+im1) - *(a+i)));
 }
 
-void butset(float *a)
+void butset(t_float *a)
 {
     a[6] = a[7] = 0.0;
 }
 
 void lobut(double *a, double cutoff, double SR)
 {
-    register float     c;
+    register t_float     c;
     
     c = 1.0 / tan( PI * cutoff / SR);
     a[1] = 1.0 / ( 1.0 + ROOT2 * c + c * c);
@@ -2655,7 +2655,7 @@
 
 void hibut(double *a, double cutoff, double SR)
 {
-    register float    c;
+    register t_float    c;
     
     c = tan( PI * cutoff / SR);
     a[1] = 1.0 / ( 1.0 + ROOT2 * c + c * c);
@@ -2669,7 +2669,7 @@
 
 void bpbut(double *a, double formant, double bandwidth, double SR)
 {
-    register float  c, d;
+    register t_float  c, d;
     
     c = 1.0 / tan( PI * bandwidth / SR);
     d = 2.0 * cos( 2.0 * PI * formant / SR);
@@ -2758,7 +2758,7 @@
 }
 
 
-void setExpFlamFunc(float *arr, int flen, float v1,float v2,float alpha)
+void setExpFlamFunc(t_float *arr, int flen, t_float v1,t_float v2,t_float alpha)
 {
     int i;
 //    double exp();
@@ -2767,7 +2767,7 @@
         alpha = .00000001 ;
     
     for ( i = 0; i < flen; i++){
-        *(arr + i) = v1 + (v2-v1) * ((1-exp((float)i*alpha/((float)flen-1.)))/(1-exp(alpha)));
+        *(arr + i) = v1 + (v2-v1) * ((1-exp((t_float)i*alpha/((t_float)flen-1.)))/(1-exp(alpha)));
     }
 }
 
@@ -2798,7 +2798,7 @@
 {
     int i;
     
-    float imin=9999999999., imax=-9999999999.;
+    t_float imin=9999999999., imax=-9999999999.;
     
     for(i = 0; i < len ; i++){
         if( imin > inarr[i] )
@@ -2900,7 +2900,7 @@
     
     int i;
     
-    float rectsamp;
+    t_float rectsamp;
     
     for( i = channel ; i < sampFrames * nchans; i+= nchans )
     {
@@ -2975,28 +2975,28 @@
     }
     
     for( i = 0 ; i < segs[0]; i++ ){
-        m1 = 1.-(float)i/(float)(segs[0]);
+        m1 = 1.-(t_float)i/(t_float)(segs[0]);
         m2 = 1. - m1;
         *(func +i ) = f1 * m1 + f2 * m2;
     }
     ipoint = i;
     
     for( i = 0 ; i < segs[1]; i++ ){
-        m1 = 1.-(float)i/(float)(segs[1]);
+        m1 = 1.-(t_float)i/(t_float)(segs[1]);
         m2 = 1. - m1;
         *(func + i + ipoint) = f2 * m1 + f3 * m2;
     }
     ipoint += i;
     
     for( i = 0 ; i < segs[2]; i++ ){
-        m1 = 1.-(float)i/(float)(segs[2]);
+        m1 = 1.-(t_float)i/(t_float)(segs[2]);
         m2 = 1. - m1;
         *(func + i + ipoint) = f3;
     }
     ipoint += i;
     
     for( i = 0 ; i < segs[3]; i++ ){
-        m1 = 1.-(float)i/(float)(segs[3]);
+        m1 = 1.-(t_float)i/(t_float)(segs[3]);
         m2 = 1. - m1;
         *(func + ipoint + i) = f3 * m1 + f4 * m2;
     }
@@ -3010,7 +3010,7 @@
     double *sinewave = x->sinewave;
     int sinelen = x->sinelen;
     double *params = x->params;
-    float srate = x->sr;
+    t_float srate = x->sr;
     long vs = x->vs;
     int i;
     double phase = 0.0;
@@ -3043,7 +3043,7 @@
     double *sinewave = x->sinewave;
     int sinelen = x->sinelen;
     double *params = x->params;
-    float srate = x->sr;
+    t_float srate = x->sr;
     long vs = x->vs;
     int i;
     double phase = 0.0;
@@ -3561,7 +3561,7 @@
 
 void reverb1(t_chameleon *x, long *pcount, t_double *buf1, t_double *buf2)
 {
-    float revtime;
+    t_float revtime;
     double *params = x->params;
     long vs = x->vs;
     int reverb1_count;
@@ -3912,13 +3912,13 @@
 void resonadsr(t_chameleon *x, long *pcount, t_double *buf1, t_double *buf2)
 {
     int i;
-    float bwfac;
+    t_float bwfac;
     double *q1, *q2;
-    float cf, bw;
-    float si;
+    t_float cf, bw;
+    t_float si;
     double phase;
     double *params = x->params;
-    float srate = x->sr;
+    t_float srate = x->sr;
     long vs = x->vs;
     int resonadsr_count;
     double a,d,r,v1,v2,v3,v4,notedur;
@@ -3983,7 +3983,7 @@
     int i;
     /* main variables */
     double *params = x->params;
-    float srate = x->sr;
+    t_float srate = x->sr;
     long vs = x->vs;
     int stv_count;
 
--- pd-lyonpotpourri.orig/convert.c
+++ pd-lyonpotpourri/convert.c
@@ -11,14 +11,14 @@
    analysis channel; decimation rate D and sampling rate R are used
    to render these frequency values directly in Hz. */
 
-void lpp_convert(float *S, float *C, int N2, float *lastphase, float fundamental, float factor )
+void lpp_convert(t_float *S, t_float *C, int N2, t_float *lastphase, t_float fundamental, t_float factor )
 {
-  float   phase, phasediff;
+  t_float   phase, phasediff;
   int     real, imag, amp,freq;
-  float   a, b;
+  t_float   a, b;
   int     i;
 
-/*  float myTWOPI, myPI; */
+/*  t_float myTWOPI, myPI; */
 /*  double sin(), cos(), atan(), hypot();*/
 
 /*  myTWOPI = 8.*atan(1.);
--- pd-lyonpotpourri.orig/dynss~.c
+++ pd-lyonpotpourri/dynss~.c
@@ -20,7 +20,7 @@
   t_double freq; // frequency
   long counter; // count samples
   long period_samples; // how many samples in a period
-  float srate; // sampling rate
+  t_float srate; // sampling rate
   long current_point; // which point are we on
   t_double *values;
   long *point_breaks;
@@ -35,7 +35,7 @@
 static t_int *dynss_perform(t_int *w);
 static void dynss_dsp(t_dynss *x, t_signal **sp);
 static void version(void);
-static float boundrand(float min, float max);
+static t_float boundrand(t_float min, t_float max);
 static void dynss_init(t_dynss *x,short initialized);
 static void dynss_devx(t_dynss *x, t_floatarg f);
 static void dynss_devy(t_dynss *x, t_floatarg f);
@@ -150,15 +150,15 @@
 }
 
 
-float boundrand(float min, float max)
+t_float boundrand(t_float min, t_float max)
 {
-  return min + (max-min) * ((float) (rand() % RAND_MAX)/ (float) RAND_MAX);
+  return min + (max-min) * ((t_float) (rand() % RAND_MAX)/ (t_float) RAND_MAX);
 }
 
 void dynss_init(t_dynss *x,short initialized)
 {
   int i,j;
-  float findex;
+  t_float findex;
   long point_count = x->point_count;
   t_double *values = x->values;
   t_double *norm_breaks = x->norm_breaks;
@@ -195,7 +195,7 @@
     }
     // now generate sample break points;
     for(i = 0; i < point_count; i++) {
-      point_breaks[i] = (long) ( (float)x->period_samples * norm_breaks[i] );
+      point_breaks[i] = (long) ( (t_float)x->period_samples * norm_breaks[i] );
       // post("%i %f %f",point_breaks[i], norm_breaks[i], values[i]);
     }
     // set y deviation maxes
@@ -213,9 +213,9 @@
 t_int *dynss_perform(t_int *w)
 {
   //int i, j, k;
-  //  float outval;
+  //  t_float outval;
   int i,j;
-  float findex1,findex2;
+  t_float findex1,findex2;
   t_dynss *x = (t_dynss *) (w[1]);
 //  t_float *inlet = (t_float *) (w[2]);
   t_float *outlet = (t_float *) (w[3]);
@@ -229,9 +229,9 @@
   long period_samples = x->period_samples;
   long current_point = x->current_point;
   long point_count = x->point_count;
-  float sample;
-  float frak;
-  float dev, newval;
+  t_float sample;
+  t_float frak;
+  t_float dev, newval;
   long segsamps;
 
   while(n--) {
@@ -250,7 +250,7 @@
         frak = 0.0;
       }
       else {
-        frak = (float)(counter - point_breaks[current_point]) / (float)segsamps;
+        frak = (t_float)(counter - point_breaks[current_point]) / (t_float)segsamps;
         //post("frak %f counter %d point break %d diff %d",frak, counter, point_breaks[current_point],counter - point_breaks[current_point] );
         if( frak < 0.0 || frak > 1.0 ) {
           post("bad fraction: %f",frak);
@@ -310,7 +310,7 @@
 
       // now generate sample breaks
       for(i = 0; i < point_count; i++) {
-        point_breaks[i] = (long) ( (float)period_samples * norm_breaks[i] );
+        point_breaks[i] = (long) ( (t_float)period_samples * norm_breaks[i] );
       }
     }
     *outlet++ = sample;
--- pd-lyonpotpourri.orig/ellipse.c
+++ pd-lyonpotpourri/ellipse.c
@@ -1,9 +1,9 @@
 #include "bashfest.h"
 
-float lpp_ellipse(float x, LSTRUCT *eel, int nsects, float xnorm)
+t_float lpp_ellipse(t_float x, LSTRUCT *eel, int nsects, t_float xnorm)
 {
   register int m;
-  float op;
+  t_float op;
 
   for(m=0;m<nsects;m++) {
     op = x + eel[m].c0 * eel[m].ps0 + eel[m].c2 * eel[m].ps1
@@ -17,7 +17,7 @@
   return(x*xnorm);
 }
 
-void lpp_ellipset(float *list, LSTRUCT *eel, int  *nsects, float *xnorm)
+void lpp_ellipset(t_float *list, LSTRUCT *eel, int  *nsects, t_float *xnorm)
 {
 /* the first argument in the list is the number of sections */
   int m,i;
@@ -37,7 +37,7 @@
   *xnorm = list[i];
 }
 /*set biquad coefficients one time*/
-void lpp_init_ellipse_data(float **a)
+void lpp_init_ellipse_data(t_float **a)
 {
   /* 0: hipass at 200 */
   a[0][0] = 4;
--- pd-lyonpotpourri.orig/fft.c
+++ pd-lyonpotpourri/fft.c
@@ -10,22 +10,22 @@
    positive frequency spectrum arranged as before, and replaces it with
    2*N real values.  N MUST be a power of 2. */
 
-void lpp_rfft( float *x, int N, int forward )
+void lpp_rfft( t_float *x, int N, int forward )
 
 {
-  float   c1,c2,
+  t_float   c1,c2,
     h1r,h1i,
     h2r,h2i,
     wr,wi,
     wpr,wpi,
     temp,
     theta;
-  float   xr,xi;
+  t_float   xr,xi;
   int     i,
     i1,i2,i3,i4,
     N2p1;
   static int  first = 1;
-/*float PI, TWOPI;*/
+/*t_float PI, TWOPI;*/
 //  void cfft();
 
   if ( first ) {
@@ -84,17 +84,17 @@
     lpp_cfft( x, N, forward );
 }
 
-/* cfft replaces float array x containing NC complex values
-   (2*NC float values alternating real, imagininary, etc.)
+/* cfft replaces t_float array x containing NC complex values
+   (2*NC t_float values alternating real, imagininary, etc.)
    by its Fourier transform if forward is true, or by its
    inverse Fourier transform if forward is false, using a
    recursive Fast Fourier transform method due to Danielson
    and Lanczos.  NC MUST be a power of 2. */
 
-void lpp_cfft( float *x, int NC, int forward )
+void lpp_cfft( t_float *x, int NC, int forward )
 
 {
-  float   wr,wi,
+  t_float   wr,wi,
     wpr,wpi,
     theta,
     scale;
@@ -116,7 +116,7 @@
     wr = 1.;
     wi = 0.;
     for ( m = 0; m < mmax; m += 2 ) {
-      register float rtemp, itemp;
+      register t_float rtemp, itemp;
       for ( i = m; i < ND; i += delta ) {
         j = i + mmax;
         rtemp = wr*x[j] - wi*x[j+1];
@@ -134,19 +134,19 @@
 /* scale output */
 
   scale = forward ? 1./ND : 2.;
-  { register float *xi=x, *xe=x+ND;
+  { register t_float *xi=x, *xe=x+ND;
     while ( xi < xe )
       *xi++ *= scale;
   }
 }
 
-/* bitreverse places float array x containing N/2 complex values
+/* bitreverse places t_float array x containing N/2 complex values
    into bit-reversed order */
 
-void lpp_bitreverse( float *x, int N )
+void lpp_bitreverse( t_float *x, int N )
 
 {
-  float   rtemp,itemp;
+  t_float   rtemp,itemp;
   int     i,j,
     m;
 
--- pd-lyonpotpourri.orig/fft4.c
+++ pd-lyonpotpourri/fft4.c
@@ -1,14 +1,14 @@
 #include <math.h>
 #include "fftease.h"
 
-void lpp_init_rdft(int n, int *ip, float *w)
+void lpp_init_rdft(int n, int *ip, t_float *w)
 {
 
   int nw,
     nc;
 
-  void  makewt(int nw, int *ip, float *w);
-  void  makect(int nc, int *ip, float *c);
+  void  makewt(int nw, int *ip, t_float *w);
+  void  makect(int nc, int *ip, t_float *c);
 
   nw = n >> 2;
   makewt(nw, ip, w);
@@ -20,18 +20,18 @@
 }
 
 
-void lpp_rdft(int n, int isgn, float *a, int *ip, float *w)
+void lpp_rdft(int n, int isgn, t_float *a, int *ip, t_float *w)
 {
 
   int   j,
     nw,
     nc;
 
-  float   xi;
+  t_float   xi;
 /*
-  void    bitrv2(int n, int *ip, float *a),
-    cftsub(int n, float *a, float *w),
-    rftsub(int n, float *a, int nc, float *c);
+  void    bitrv2(int n, int *ip, t_float *a),
+    cftsub(int n, t_float *a, t_float *w),
+    rftsub(int n, t_float *a, int nc, t_float *c);
 */
 
   nw = ip[0];
@@ -76,10 +76,10 @@
 }
 
 
-void lpp_bitrv2(int n, int *ip, float *a)
+void lpp_bitrv2(int n, int *ip, t_float *a)
 {
   int j, j1, k, k1, l, m, m2;
-  float xr, xi;
+  t_float xr, xi;
 
   ip[0] = 0;
   l = n;
@@ -138,11 +138,11 @@
 }
 
 
-void lpp_cftsub(int n, float *a, float *w)
+void lpp_cftsub(int n, t_float *a, t_float *w)
 {
   int j, j1, j2, j3, k, k1, ks, l, m;
-  float wk1r, wk1i, wk2r, wk2i, wk3r, wk3i;
-  float x0r, x0i, x1r, x1i, x2r, x2i, x3r, x3i;
+  t_float wk1r, wk1i, wk2r, wk2i, wk3r, wk3i;
+  t_float x0r, x0i, x1r, x1i, x2r, x2i, x3r, x3i;
 
   l = 2;
 
@@ -261,10 +261,10 @@
 }
 
 
-void lpp_rftsub(int n, float *a, int nc, float *c)
+void lpp_rftsub(int n, t_float *a, int nc, t_float *c)
 {
   int j, k, kk, ks;
-  float wkr, wki, xr, xi, yr, yi;
+  t_float wkr, wki, xr, xi, yr, yi;
 
   ks = (nc << 2) / n;
   kk = 0;
@@ -286,11 +286,11 @@
 }
 
 
-void lpp_makewt(int nw, int *ip, float *w)
+void lpp_makewt(int nw, int *ip, t_float *w)
 {
-//  void bitrv2(int n, int *ip, float *a);
+//  void bitrv2(int n, int *ip, t_float *a);
   int nwh, j;
-  float delta, x, y;
+  t_float delta, x, y;
 
   ip[0] = nw;
   ip[1] = 1;
@@ -314,10 +314,10 @@
 }
 
 
-void lpp_makect(int nc, int *ip, float *c)
+void lpp_makect(int nc, int *ip, t_float *c)
 {
   int nch, j;
-  float delta;
+  t_float delta;
 
   ip[1] = nc;
   if (nc > 1) {
--- pd-lyonpotpourri.orig/fftease.h
+++ pd-lyonpotpourri/fftease.h
@@ -2,6 +2,7 @@
 #include <math.h>
 #include <stdlib.h>
 #include <string.h>
+#include <m_pd.h>
 
 
 /*
@@ -26,29 +27,29 @@
 #define MAX_N2 (MAX_N/2)
 #define MAX_Nw (MAX_N * 4)
 
-void lpp_convert(float *S, float *C, int N2, float *lastphase, float fundamental, float factor );
-void lpp_unconvert( float *C, float *S, int N2, float *lastphase, float fundamental,  float factor );
-void lpp_rfft( float *x, int N, int forward );
-void lpp_cfft( float *x, int NC, int forward );
-void lpp_bitreverse( float *x, int N );
-void lpp_fold( float *I, float *W, int Nw, float *O, int N, int n );
-void lpp_init_rdft(int n, int *ip, float *w);
-void lpp_rdft(int n, int isgn, float *a, int *ip, float *w);
-void lpp_bitrv2(int n, int *ip, float *a);
-void lpp_cftsub(int n, float *a, float *w);
-void lpp_rftsub(int n, float *a, int nc, float *c);
-void lpp_makewt(int nw, int *ip, float *w);
-void lpp_makect(int nc, int *ip, float *c);
-void lpp_leanconvert( float *S, float *C, int N2 );
-void lpp_leanunconvert( float *C, float *S, int N2 );
-void lpp_makewindows( float *H, float *A, float *S, int Nw, int N, int I );
-void lpp_makehamming( float *H, float *A, float *S, int Nw, int N, int I,int odd );
-void lpp_makehanning( float *H, float *A, float *S, int Nw, int N, int I,int odd );
-void lpp_overlapadd( float *I, int N, float *W, float *O, int Nw, int n );
-void lpp_bloscbank( float *S, float *O, int D, float iD, float *lf, float *la,
-                float *bindex, float *tab, int len, float synt, int lo, int hi );
+void lpp_convert(t_float *S, t_float *C, int N2, t_float *lastphase, t_float fundamental, t_float factor );
+void lpp_unconvert( t_float *C, t_float *S, int N2, t_float *lastphase, t_float fundamental,  t_float factor );
+void lpp_rfft( t_float *x, int N, int forward );
+void lpp_cfft( t_float *x, int NC, int forward );
+void lpp_bitreverse( t_float *x, int N );
+void lpp_fold( t_float *I, t_float *W, int Nw, t_float *O, int N, int n );
+void lpp_init_rdft(int n, int *ip, t_float *w);
+void lpp_rdft(int n, int isgn, t_float *a, int *ip, t_float *w);
+void lpp_bitrv2(int n, int *ip, t_float *a);
+void lpp_cftsub(int n, t_float *a, t_float *w);
+void lpp_rftsub(int n, t_float *a, int nc, t_float *c);
+void lpp_makewt(int nw, int *ip, t_float *w);
+void lpp_makect(int nc, int *ip, t_float *c);
+void lpp_leanconvert( t_float *S, t_float *C, int N2 );
+void lpp_leanunconvert( t_float *C, t_float *S, int N2 );
+void lpp_makewindows( t_float *H, t_float *A, t_float *S, int Nw, int N, int I );
+void lpp_makehamming( t_float *H, t_float *A, t_float *S, int Nw, int N, int I,int odd );
+void lpp_makehanning( t_float *H, t_float *A, t_float *S, int Nw, int N, int I,int odd );
+void lpp_overlapadd( t_float *I, int N, t_float *W, t_float *O, int Nw, int n );
+void lpp_bloscbank( t_float *S, t_float *O, int D, t_float iD, t_float *lf, t_float *la,
+                t_float *bindex, t_float *tab, int len, t_float synt, int lo, int hi );
 
-float lpp_randf( float min, float max );
+t_float lpp_randf( t_float min, t_float max );
 int lpp_randi( int min, int max );
 int lpp_power_of_two(int test);
 
--- pd-lyonpotpourri.orig/fold.c
+++ pd-lyonpotpourri/fold.c
@@ -6,7 +6,7 @@
  * into output array O of (FFT) length N according to current
  * input time n
  */
-void lpp_fold( float *I, float *W, int Nw, float *O, int N, int n )
+void lpp_fold( t_float *I, t_float *W, int Nw, t_float *O, int N, int n )
 {
   int i;
 
--- pd-lyonpotpourri.orig/from_msp.c
+++ pd-lyonpotpourri/from_msp.c
@@ -1,6 +1,6 @@
 
 #include "MSPd.h"
-void atom_arg_getfloat(float *c, long idx, long ac, t_atom *av)
+void atom_arg_getfloat(t_float *c, long idx, long ac, t_atom *av)
 {
   if (c&&ac&&av&&(idx<ac)) {
     *c = atom_getfloat(av+idx);
--- pd-lyonpotpourri.orig/function~.c
+++ pd-lyonpotpourri/function~.c
@@ -381,7 +381,7 @@
     b_samples = x->b_samples;
     b_frames = x->b_frames;
     amp = atom_getfloatarg(0,argc,argv);
-    // post("harmonic: 0, weight: %.12f", (float)amp);
+    // post("harmonic: 0, weight: %.12f", (t_float)amp);
     for(i=0;i<b_frames;i++) {
         b_samples[i].w_float = amp;
     }
--- pd-lyonpotpourri.orig/leanconvert.c
+++ pd-lyonpotpourri/leanconvert.c
@@ -1,9 +1,9 @@
 #include "fftease.h"
 
-void leanconvert( float *S, float *C, int N2 )
+void leanconvert( t_float *S, t_float *C, int N2 )
 {
   int    real, imag, amp, phase;
-  float  a, b;
+  t_float  a, b;
   int    i;
   double hypot(), atan2();
 
--- pd-lyonpotpourri.orig/leanunconvert.c
+++ pd-lyonpotpourri/leanunconvert.c
@@ -6,7 +6,7 @@
    in output array S; sampling rate R and interpolation factor
    I are used to recompute phase values from frequencies */
 
-void leanunconvert( float *C, float *S, int N2 )
+void leanunconvert( t_float *C, t_float *S, int N2 )
 
 {
   double cos(), sin();
--- pd-lyonpotpourri.orig/lpp.h
+++ pd-lyonpotpourri/lpp.h
@@ -27,10 +27,10 @@
 
 /*** MSP helper functions, thanks JKC! ***/
 
-void atom_arg_getfloat(float *c, long idx, long ac, t_atom *av);
+void atom_arg_getfloat(t_float *c, long idx, long ac, t_atom *av);
 void atom_arg_getsym(t_symbol **c, long idx, long ac, t_atom *av);
 
-void atom_arg_getfloat(float *c, long idx, long ac, t_atom *av)
+void atom_arg_getfloat(t_float *c, long idx, long ac, t_atom *av)
 {
   if (c&&ac&&av&&(idx<ac)) {
     *c = atom_getfloat(av+idx);
--- pd-lyonpotpourri.orig/makewindows.c
+++ pd-lyonpotpourri/makewindows.c
@@ -1,16 +1,16 @@
 #include "fftease.h"
 
-void lpp_makewindows( float *H, float *A, float *S, int Nw, int N, int I )
+void lpp_makewindows( t_float *H, t_float *A, t_float *S, int Nw, int N, int I )
 
 {
   int i ;
-  float sum ;
+  t_float sum ;
 
   for ( i = 0 ; i < Nw ; i++ )
     H[i] = A[i] = S[i] = 0.54 - 0.46*cos( TWOPI*i/(Nw - 1) ) ;
 
   if ( Nw > N ) {
-    float x ;
+    t_float x ;
 
     x = -(Nw - 1)/2. ;
     for ( i = 0 ; i < Nw ; i++, x += 1. )
@@ -25,8 +25,8 @@
     sum += A[i] ;
 
   for ( i = 0 ; i < Nw ; i++ ) {
-    float afac = 2./sum ;
-    float sfac = Nw > N ? 1./afac : afac ;
+    t_float afac = 2./sum ;
+    t_float sfac = Nw > N ? 1./afac : afac ;
     A[i] *= afac ;
     S[i] *= sfac ;
   }
@@ -39,11 +39,11 @@
   }
 }
 
-void lpp_makehamming( float *H, float *A, float *S, int Nw, int N, int I, int odd )
+void lpp_makehamming( t_float *H, t_float *A, t_float *S, int Nw, int N, int I, int odd )
 
 {
   int i;
-  float sum ;
+  t_float sum ;
 
 
 
@@ -60,7 +60,7 @@
   }
 
   if ( Nw > N ) {
-    float x ;
+    t_float x ;
 
     x = -(Nw - 1)/2. ;
     for ( i = 0 ; i < Nw ; i++, x += 1. )
@@ -74,8 +74,8 @@
     sum += A[i] ;
 
   for ( i = 0 ; i < Nw ; i++ ) {
-    float afac = 2./sum ;
-    float sfac = Nw > N ? 1./afac : afac ;
+    t_float afac = 2./sum ;
+    t_float sfac = Nw > N ? 1./afac : afac ;
     A[i] *= afac ;
     S[i] *= sfac ;
   }
@@ -89,10 +89,10 @@
 }
 
 
-void lpp_makehanning( float *H, float *A, float *S, int Nw, int N, int I, int odd )
+void lpp_makehanning( t_float *H, t_float *A, t_float *S, int Nw, int N, int I, int odd )
 {
   int i;
-  float sum ;
+  t_float sum ;
 
 
   if (odd) {
@@ -108,7 +108,7 @@
   }
 
   if ( Nw > N ) {
-    float x ;
+    t_float x ;
 
     x = -(Nw - 1)/2. ;
     for ( i = 0 ; i < Nw ; i++, x += 1. )
@@ -122,8 +122,8 @@
     sum += A[i] ;
 
   for ( i = 0 ; i < Nw ; i++ ) {
-    float afac = 2./sum ;
-    float sfac = Nw > N ? 1./afac : afac ;
+    t_float afac = 2./sum ;
+    t_float sfac = Nw > N ? 1./afac : afac ;
     A[i] *= afac ;
     S[i] *= sfac ;
   }
--- pd-lyonpotpourri.orig/overlapadd.c
+++ pd-lyonpotpourri/overlapadd.c
@@ -6,7 +6,7 @@
 
 #include "fftease.h"
 
-void overlapadd( float *I, int N, float *W, float *O, int Nw, int n )
+void overlapadd( t_float *I, int N, t_float *W, t_float *O, int Nw, int n )
 
 {
   int i ;
--- pd-lyonpotpourri.orig/quadpan~.c
+++ pd-lyonpotpourri/quadpan~.c
@@ -71,24 +71,24 @@
 
 t_int *quadpan_perform(t_int *w)
 {
-  float gain1, gain2, gain3, gain4;
-  float xval, yval;
-  float xsquared, ysquared, ix, iy, ixsquared, iysquared;
+  t_float gain1, gain2, gain3, gain4;
+  t_float xval, yval;
+  t_float xsquared, ysquared, ix, iy, ixsquared, iysquared;
   int i;
 
   t_quadpan *x = (t_quadpan *) (w[1]);
-  float *in = x->in;
-  float *Xin = x->Xin;
-  float *Yin = x->Yin;
+  t_float *in = x->in;
+  t_float *Xin = x->Xin;
+  t_float *Yin = x->Yin;
 
-  float *in_loc = (t_float *)(w[2]);
-  float *Xin_loc = (t_float *)(w[3]);
-  float *Yin_loc = (t_float *)(w[4]);
+  t_float *in_loc = (t_float *)(w[2]);
+  t_float *Xin_loc = (t_float *)(w[3]);
+  t_float *Yin_loc = (t_float *)(w[4]);
 
-  float *out1 = (t_float *)(w[5]);
-  float *out2 = (t_float *)(w[6]);
-  float *out3 = (t_float *)(w[7]);
-  float *out4 = (t_float *)(w[8]);
+  t_float *out1 = (t_float *)(w[5]);
+  t_float *out2 = (t_float *)(w[6]);
+  t_float *out3 = (t_float *)(w[7]);
+  t_float *out4 = (t_float *)(w[8]);
   int n = (int)(w[9]);
 
   // copy buffers to avoid writeovers in shared memory
--- pd-lyonpotpourri.orig/sarec~.c
+++ pd-lyonpotpourri/sarec~.c
@@ -24,14 +24,14 @@
     int overdub; // 0 ? write over track, 1: overdub into track
     int *armed_chans; // 1, armed, 0, protected
     long counter; // sample counter
-    float sync; // position in recording
+    t_float sync; // position in recording
     long start_frame; // start time in samples
     long end_frame; // end time in samples
     long fadesamps; // number of samples for fades on PUNCH mode
     long regionsamps; // use for fade
     int channel_count; // number of channels (hopefully!) in buffer
-    float sr;
-    float syncphase;
+    t_float sr;
+    t_float syncphase;
     t_symbol *bufname; // name of recording buffer
     t_garray *recbuf;
 } t_sarec;
@@ -137,8 +137,8 @@
     long fadesamps = x->fadesamps;
     long regionsamps = x->regionsamps;
     int clickval;
-    float frak;
-    float goin_up, goin_down;
+    t_float frak;
+    t_float goin_up, goin_down;
     long counter_msf;
     sync = (t_float *) (w[3 + channel_count]);
     n = (int) w[4 + channel_count];
@@ -216,7 +216,7 @@
                     if( counter_msf < fadesamps ) {
                         
                         // fade in
-                        frak = (float)counter_msf / (float)fadesamps;
+                        frak = (t_float)counter_msf / (t_float)fadesamps;
                         goin_up = sin(PIOVERTWO * frak);
                         goin_down = cos(PIOVERTWO * frak);
                         //post("fadein: %d, up: %f, down: %f", counter_msf, goin_up, goin_down);
@@ -224,10 +224,10 @@
                         (samples[ (counter * channel_count) + j].w_float * goin_down)
                         + (record_inlet[i] * goin_up);
                     } else if ( counter_msf >= (regionsamps - fadesamps) ) {
-                        frak = (float) (regionsamps - counter_msf) / (float) fadesamps;
+                        frak = (t_float) (regionsamps - counter_msf) / (t_float) fadesamps;
                         // fade out
                         
-                        // frak = (float)counter_msf / (float)fadesamps;
+                        // frak = (t_float)counter_msf / (t_float)fadesamps;
                         goin_up = cos(PIOVERTWO * frak);
                         goin_down = sin(PIOVERTWO * frak);
                         //post("fadeout: %d, up: %f, down: %f", counter_msf, goin_up, goin_down);
@@ -244,7 +244,7 @@
             counter++;
         }
         
-        sync[i] = (float) counter / (float) b_frames;
+        sync[i] = (t_float) counter / (t_float) b_frames;
     }
     if(status) {
         x->display_counter += n;
@@ -315,7 +315,7 @@
 {
     long b_frames = x->b_frames;
     long start_frame, end_frame;
-    float sr = x->sr;
+    t_float sr = x->sr;
     // convert milliseconds to samples:
     start_frame = (long) (sr * 0.001 * start_time );
     end_frame = (long) (sr * 0.001 * end_time );
--- pd-lyonpotpourri.orig/splitbank~.c
+++ pd-lyonpotpourri/splitbank~.c
@@ -19,42 +19,42 @@
   int vector_size;
   int i;
   int in_count;
-  float *Wanal;
-  float *Wsyn;
-  float *input_buffer;
-  float *Hwin;
-  float *complex_spectrum;
-  float *interleaved_spectrum;
-  float *output_buffer;
+  t_float *Wanal;
+  t_float *Wsyn;
+  t_float *input_buffer;
+  t_float *Hwin;
+  t_float *complex_spectrum;
+  t_float *interleaved_spectrum;
+  t_float *output_buffer;
   // for convert
-  float *c_lastphase_in;
-  float *c_lastphase_out;
-  float c_fundamental;
-  float c_factor_in;
-  float c_factor_out;
-  float P;
+  t_float *c_lastphase_in;
+  t_float *c_lastphase_out;
+  t_float c_fundamental;
+  t_float c_factor_in;
+  t_float c_factor_out;
+  t_float P;
   int table_length;
-  float table_si;
+  t_float table_si;
   int first;
-  float i_vector_size;
-  float *lastamp;
-  float *lastfreq;
-  float *index;
-  float *table;
-  float pitch_increment;
+  t_float i_vector_size;
+  t_float *lastamp;
+  t_float *lastfreq;
+  t_float *index;
+  t_float *table;
+  t_float pitch_increment;
 
   int lo_bin;
   int hi_bin;
-  float synthesis_threshold;
+  t_float synthesis_threshold;
 
   int overlap;
   int winfac;
-  float user_lofreq;
-  float user_hifreq;
-  float curfreq;
+  t_float user_lofreq;
+  t_float user_hifreq;
+  t_float curfreq;
   // faster FFT
-  float mult;
-  float *trigland;
+  t_float mult;
+  t_float *trigland;
   int *bitshuffle;
 
 } t_oscbank;
@@ -73,23 +73,23 @@
   int *bin_tmp;
   int ramp_frames;
   int frames_left;
-  float frame_duration;
+  t_float frame_duration;
   int vector_size;
   int table_offset;
   int bin_offset;
-  float *last_mag;
-  float *current_mag;
+  t_float *last_mag;
+  t_float *current_mag;
   int *last_binsplit;
   int *current_binsplit;
   int **stored_binsplits;
   short *stored_slots;
-  float *in_amps;
+  t_float *in_amps;
   short new_distribution;
   short interpolation_completed;
 //    short bypass;
   short initialize;
   short manual_override;
-  float manual_control_value;
+  t_float manual_control_value;
   short mute;
   short powerfade;
   int channel_count;
@@ -118,36 +118,36 @@
 static void splitbank_fftinfo( t_splitbank *x);
 static void splitbank_free( t_splitbank *x );
 static void splitbank_overlap( t_splitbank *x, t_floatarg ofac );
-static void splitbank_spliti( t_splitbank *x,  float *dest_mag, int start, int end, float oldfrac);
-static void splitbank_split(t_splitbank *x, int *binsplit, float *dest_mag, int start, int end );
+static void splitbank_spliti( t_splitbank *x,  t_float *dest_mag, int start, int end, t_float oldfrac);
+static void splitbank_split(t_splitbank *x, int *binsplit, t_float *dest_mag, int start, int end );
 static int splitbank_closestPowerOfTwo(int p);
 static void fftease_obank_analyze( t_oscbank *x ) ;
-static void fftease_obank_initialize ( t_oscbank *x, float lo_freq, float hi_freq, int overlap,
+static void fftease_obank_initialize ( t_oscbank *x, t_float lo_freq, t_float hi_freq, int overlap,
                                 int R, int vector_size, int N);
 // static void fftease_obank_transpose( t_oscbank *x );
 static void fftease_obank_synthesize( t_oscbank *x );
 static void fftease_obank_destroy( t_oscbank *x );
-static void fftease_shiftin( t_oscbank *x, float *input );
-static void fftease_shiftout( t_oscbank *x, float *output );
-static void fftease_obank_topfreq( t_oscbank *x, float topfreq );
-static void fftease_obank_bottomfreq( t_oscbank *x, float bottomfreq );
-
-
-static void rfft( float *x, int N, int forward );
-static void cfft( float *x, int NC, int forward );
-static void bitreverse( float *x, int N );
-static void fold( float *I, float *W, int Nw, float *O, int N, int n );
-static void init_rdft(int n, int *ip, float *w);
-static void rdft(int n, int isgn, float *a, int *ip, float *w);
-static void bitrv2(int n, int *ip, float *a);
-static void cftsub(int n, float *a, float *w);
-static void rftsub(int n, float *a, int nc, float *c);
-static void makewt(int nw, int *ip, float *w);
-static void makect(int nc, int *ip, float *c);
-static void makewindows( float *H, float *A, float *S, int Nw, int N, int I );
-static void makehamming( float *H, float *A, float *S, int Nw, int N, int I,int odd );
-static void makehanning( float *H, float *A, float *S, int Nw, int N, int I,int odd );
-static void convert(float *S, float *C, int N2, float *lastphase, float fundamental, float factor );
+static void fftease_shiftin( t_oscbank *x, t_float *input );
+static void fftease_shiftout( t_oscbank *x, t_float *output );
+static void fftease_obank_topfreq( t_oscbank *x, t_float topfreq );
+static void fftease_obank_bottomfreq( t_oscbank *x, t_float bottomfreq );
+
+
+static void rfft( t_float *x, int N, int forward );
+static void cfft( t_float *x, int NC, int forward );
+static void bitreverse( t_float *x, int N );
+static void fold( t_float *I, t_float *W, int Nw, t_float *O, int N, int n );
+static void init_rdft(int n, int *ip, t_float *w);
+static void rdft(int n, int isgn, t_float *a, int *ip, t_float *w);
+static void bitrv2(int n, int *ip, t_float *a);
+static void cftsub(int n, t_float *a, t_float *w);
+static void rftsub(int n, t_float *a, int nc, t_float *c);
+static void makewt(int nw, int *ip, t_float *w);
+static void makect(int nc, int *ip, t_float *c);
+static void makewindows( t_float *H, t_float *A, t_float *S, int Nw, int N, int I );
+static void makehamming( t_float *H, t_float *A, t_float *S, int Nw, int N, int I,int odd );
+static void makehanning( t_float *H, t_float *A, t_float *S, int Nw, int N, int I,int odd );
+static void convert(t_float *S, t_float *C, int N2, t_float *lastphase, t_float fundamental, t_float factor );
 
 //////////
 void splitbank_tilde_setup(void) {
@@ -208,11 +208,11 @@
         freebytes(x->list_data, (x->N + 2) * sizeof(t_atom)) ;
         freebytes(x->current_binsplit, x->N2 * sizeof(int));
         freebytes(x->last_binsplit, x->N2 * sizeof(int));
-        freebytes(x->current_mag, x->N2 * sizeof(float));
-        freebytes(x->last_mag, x->N2 * sizeof(float));
+        freebytes(x->current_mag, x->N2 * sizeof(t_float));
+        freebytes(x->last_mag, x->N2 * sizeof(t_float));
         freebytes(x->bin_tmp, x->N2 * sizeof(int));
         freebytes(x->stored_slots, x->N2 * sizeof(short));
-        freebytes(x->in_amps, (x->N +2) * sizeof(float));
+        freebytes(x->in_amps, (x->N +2) * sizeof(t_float));
         for( i = 0; i < MAXSTORE; i++ ) {
             freebytes(x->stored_binsplits[i], x->N2 * sizeof(int));
         }
@@ -352,16 +352,16 @@
 {
 
   int i,j;
-  float frac = 0.0;
+  t_float frac = 0.0;
   t_splitbank *x = (t_splitbank *) (w[1]);
 
   int channel_count = x->channel_count;
-  float *input;
-  float *synthesis_threshold;
-  float *t_offset;
-  float *b_offset;
-  float *manual_control;
-  float *sync = (t_float *)(w[(channel_count * 2) + 7]);
+  t_float *input;
+  t_float *synthesis_threshold;
+  t_float *t_offset;
+  t_float *b_offset;
+  t_float *manual_control;
+  t_float *sync = (t_float *)(w[(channel_count * 2) + 7]);
   int n = (int) w[(channel_count * 2) + 8];
 
   int N2 = x->N2;
@@ -373,8 +373,8 @@
   int *current_binsplit = x->current_binsplit;
   int *last_binsplit = x->last_binsplit;
 
-  float *in_amps = x->in_amps;
-  float manual_control_value = x->manual_control_value;
+  t_float *in_amps = x->in_amps;
+  t_float manual_control_value = x->manual_control_value;
 
   long counter = x->counter;
   long countdown_samps = x->countdown_samps;
@@ -479,7 +479,7 @@
     }
     frac = 1.0;
   } else {
-    frac = (float) counter / (float) countdown_samps;
+    frac = (t_float) counter / (t_float) countdown_samps;
 
     for(i = 0; i < channel_count; i++) {
       splitbank_spliti( x, obanks[i]->interleaved_spectrum,
@@ -593,7 +593,7 @@
 }
 
 void splitbank_ramptime (t_splitbank *x, t_symbol *msg, int argc, t_atom *argv) {
-  float rampdur;
+  t_float rampdur;
   rampdur = atom_getfloatarg(0,argc,argv) * 0.001;
   x->countdown_samps = rampdur * x->R;
   x->counter = 0;
@@ -684,12 +684,12 @@
   }
   }
 */
-void splitbank_split(t_splitbank *x, int *binsplit, float *dest_mag, int start, int end )
+void splitbank_split(t_splitbank *x, int *binsplit, t_float *dest_mag, int start, int end )
 {
   int i;
   int bindex;
   int n = x->N2;
-  float *in_amps = x->in_amps;
+  t_float *in_amps = x->in_amps;
   int table_offset = x->table_offset;
   int bin_offset = x->bin_offset;
 
@@ -706,20 +706,20 @@
 }
 
 
-void splitbank_spliti( t_splitbank *x, float *dest_mag, int start, int end, float oldfrac)
+void splitbank_spliti( t_splitbank *x, t_float *dest_mag, int start, int end, t_float oldfrac)
 {
   int i;
   int bindex;
   int *current_binsplit = x->current_binsplit;
   int *last_binsplit = x->last_binsplit;
-  float *current_mag = x->current_mag;
-  float *last_mag = x->last_mag;
-  float *in_amps = x->in_amps;
+  t_float *current_mag = x->current_mag;
+  t_float *last_mag = x->last_mag;
+  t_float *in_amps = x->in_amps;
   int bin_offset = x->bin_offset;
   int table_offset = x->table_offset;
   int n = x->N2;
-  float newfrac;
-  float phase;
+  t_float newfrac;
+  t_float phase;
 
 
   if( oldfrac < 0 )
@@ -819,8 +819,8 @@
     x->last_binsplit = getbytes(x->N2 * sizeof(int));
     x->current_binsplit = getbytes(x->N2 * sizeof(int));
     x->bin_tmp = getbytes(x->N2 * sizeof(int));
-    x->last_mag = getbytes(x->N2 * sizeof(float));
-    x->current_mag = getbytes(x->N2 * sizeof(float));
+    x->last_mag = getbytes(x->N2 * sizeof(t_float));
+    x->current_mag = getbytes(x->N2 * sizeof(t_float));
     x->stored_slots = getbytes(x->N2 * sizeof(short));
     x->stored_binsplits = getbytes(MAXSTORE * sizeof(int *));
     for( i = 0; i < MAXSTORE; i++ ) {
@@ -835,7 +835,7 @@
       fftease_obank_initialize(obanks[i], lo_freq, hi_freq, overlap, R, vector_size,x->N);
     }
 
-    x->in_amps = getbytes((x->N +2) * sizeof(float));
+    x->in_amps = getbytes((x->N +2) * sizeof(t_float));
     x->initialize = 0;
   }
   x->hopsamps = x->N / x->overlap;
@@ -847,25 +847,25 @@
 /**************************************************/
 void fftease_obank_destroy( t_oscbank *x )
 {
-  freebytes(x->Wanal, x->Nw * sizeof(float));
-    freebytes(x->Wsyn, x->Nw * sizeof(float));
-    freebytes(x->Hwin, x->Nw * sizeof(float));
-    freebytes(x->complex_spectrum, x->N * sizeof(float));
-    freebytes(x->interleaved_spectrum, (x->N + 2) * sizeof(float));
-    freebytes(x->input_buffer, x->Nw * sizeof(float));
-    freebytes(x->output_buffer, x->Nw * sizeof(float));
-    freebytes(x->c_lastphase_in, (x->N2+1) * sizeof(float));
-    freebytes(x->c_lastphase_out, (x->N2+1) * sizeof(float));
-    freebytes(x->lastamp, (x->N+1) * sizeof(float));
-    freebytes(x->lastfreq, (x->N+1) * sizeof(float));
-    freebytes(x->index, (x->N+1) * sizeof(float));
-    freebytes(x->table, x->table_length * sizeof(float));
+  freebytes(x->Wanal, x->Nw * sizeof(t_float));
+    freebytes(x->Wsyn, x->Nw * sizeof(t_float));
+    freebytes(x->Hwin, x->Nw * sizeof(t_float));
+    freebytes(x->complex_spectrum, x->N * sizeof(t_float));
+    freebytes(x->interleaved_spectrum, (x->N + 2) * sizeof(t_float));
+    freebytes(x->input_buffer, x->Nw * sizeof(t_float));
+    freebytes(x->output_buffer, x->Nw * sizeof(t_float));
+    freebytes(x->c_lastphase_in, (x->N2+1) * sizeof(t_float));
+    freebytes(x->c_lastphase_out, (x->N2+1) * sizeof(t_float));
+    freebytes(x->lastamp, (x->N+1) * sizeof(t_float));
+    freebytes(x->lastfreq, (x->N+1) * sizeof(t_float));
+    freebytes(x->index, (x->N+1) * sizeof(t_float));
+    freebytes(x->table, x->table_length * sizeof(t_float));
     freebytes(x->bitshuffle, (x->N * 2) * sizeof(int));
-    freebytes(x->trigland, (x->N * 2) * sizeof(float));
+    freebytes(x->trigland, (x->N * 2) * sizeof(t_float));
   free(x);
 }
 /**************************************************/
-void fftease_obank_initialize ( t_oscbank *x, float lo_freq, float hi_freq, int overlap,
+void fftease_obank_initialize ( t_oscbank *x, t_float lo_freq, t_float hi_freq, int overlap,
                                 int R, int vector_size, int N)
 {
   int i;
@@ -888,24 +888,24 @@
   x->user_hifreq = hi_freq;
 
   x->synthesis_threshold = .000001;
-  x->table_si = (float) x->table_length/ (float) x->R;
-  x->Wanal = (float *) getbytes(x->Nw * sizeof(float));
-  x->Wsyn = (float *) getbytes(x->Nw * sizeof(float));
-  x->Hwin = (float *) getbytes(x->Nw * sizeof(float));
-  x->complex_spectrum = (float *) getbytes(x->N * sizeof(float));
-  x->interleaved_spectrum = (float *) getbytes((x->N + 2) * sizeof(float));
-  x->input_buffer = (float *) getbytes(x->Nw * sizeof(float));
-  x->output_buffer = (float *) getbytes(x->Nw * sizeof(float));
-  x->c_lastphase_in = (float *) getbytes((x->N2+1) * sizeof(float));
-  x->c_lastphase_out = (float *) getbytes((x->N2+1) * sizeof(float));
-  x->lastamp = (float *) getbytes((x->N+1) * sizeof(float));
-  x->lastfreq = (float *) getbytes((x->N+1) * sizeof(float));
-  x->index = (float *) getbytes((x->N+1) * sizeof(float) );
-  x->table = (float *) getbytes(x->table_length * sizeof(float));
+  x->table_si = (t_float) x->table_length/ (t_float) x->R;
+  x->Wanal = (t_float *) getbytes(x->Nw * sizeof(t_float));
+  x->Wsyn = (t_float *) getbytes(x->Nw * sizeof(t_float));
+  x->Hwin = (t_float *) getbytes(x->Nw * sizeof(t_float));
+  x->complex_spectrum = (t_float *) getbytes(x->N * sizeof(t_float));
+  x->interleaved_spectrum = (t_float *) getbytes((x->N + 2) * sizeof(t_float));
+  x->input_buffer = (t_float *) getbytes(x->Nw * sizeof(t_float));
+  x->output_buffer = (t_float *) getbytes(x->Nw * sizeof(t_float));
+  x->c_lastphase_in = (t_float *) getbytes((x->N2+1) * sizeof(t_float));
+  x->c_lastphase_out = (t_float *) getbytes((x->N2+1) * sizeof(t_float));
+  x->lastamp = (t_float *) getbytes((x->N+1) * sizeof(t_float));
+  x->lastfreq = (t_float *) getbytes((x->N+1) * sizeof(t_float));
+  x->index = (t_float *) getbytes((x->N+1) * sizeof(t_float) );
+  x->table = (t_float *) getbytes(x->table_length * sizeof(t_float));
   x->bitshuffle = (int *) getbytes((x->N * 2) * sizeof(int));
-  x->trigland = (float *) getbytes((x->N * 2) * sizeof(float));
+  x->trigland = (t_float *) getbytes((x->N * 2) * sizeof(t_float));
 
-  x->mult = 1. / (float) x->N;
+  x->mult = 1. / (t_float) x->N;
 
   for( i = 0; i < x->N2 + 1; i++) {
     x->c_lastphase_in[i] = x->c_lastphase_out[i] = 0.0;
@@ -923,8 +923,8 @@
   makehanning( x->Hwin, x->Wanal, x->Wsyn, x->Nw, x->N, x->vector_size, 0);
 
 
-  x->c_fundamental =  (float) x->R/(float)x->N ;
-  x->c_factor_in =  (float) x->R/((float)x->vector_size * TWOPI);
+  x->c_fundamental =  (t_float) x->R/(t_float)x->N ;
+  x->c_factor_in =  (t_float) x->R/((t_float)x->vector_size * TWOPI);
   x->c_factor_out = 1.0 / x->c_factor_in;
 
 
@@ -951,7 +951,7 @@
     x->hi_bin = x->N2 ;
 
   for ( i = 0; i < x->table_length; i++ ) {
-    x->table[i] = (float) x->N * cos(  (float)i * TWOPI / (float)x->table_length );
+    x->table[i] = (t_float) x->N * cos(  (t_float)i * TWOPI / (t_float)x->table_length );
   }
 
   x->P = 1.0 ;
@@ -967,7 +967,7 @@
   */
 }
 /**************************************************/
-void  fftease_obank_topfreq( t_oscbank *x, float topfreq )
+void  fftease_obank_topfreq( t_oscbank *x, t_float topfreq )
 {
   if( topfreq < x->c_fundamental ) {
     topfreq = OSCBANK_DEFAULT_TOPFREQ ;
@@ -983,7 +983,7 @@
     x->hi_bin = x->N2 ;
 }
 /**************************************************/
-void  fftease_obank_bottomfreq( t_oscbank *x, float bottomfreq )
+void  fftease_obank_bottomfreq( t_oscbank *x, t_float bottomfreq )
 {
 
 
@@ -1007,12 +1007,12 @@
 
 }
 /**************************************************/
-void fftease_shiftin( t_oscbank *x, float *input )
+void fftease_shiftin( t_oscbank *x, t_float *input )
 {
   int i;
   int vector_size = x->vector_size;
   int Nw = x->Nw;
-  float *input_buffer = x->input_buffer;
+  t_float *input_buffer = x->input_buffer;
 
   for ( i = 0 ; i < (Nw - vector_size) ; i++ ) {
     input_buffer[i] = input_buffer[i + vector_size];
@@ -1023,13 +1023,13 @@
 
 }
 /**************************************************/
-void fftease_shiftout( t_oscbank *x, float *output )
+void fftease_shiftout( t_oscbank *x, t_float *output )
 {
   int i;
   int vector_size = x->vector_size;
   int Nw = x->Nw;
-  float *output_buffer = x->output_buffer;
-  float mult = x->mult;
+  t_float *output_buffer = x->output_buffer;
+  t_float mult = x->mult;
 
   for ( i = 0; i < vector_size; i++ ) {
     *output++ = output_buffer[i] * mult;
@@ -1047,22 +1047,22 @@
 void fftease_obank_synthesize( t_oscbank *x )
 {
   int amp, chan, freq;
-  float    a,ainc,f,finc,address;
+  t_float    a,ainc,f,finc,address;
   int n;
 
-  float synthesis_threshold = x->synthesis_threshold;
-  float *lastfreq = x->lastfreq;
-  float *lastamp = x->lastamp;
+  t_float synthesis_threshold = x->synthesis_threshold;
+  t_float *lastfreq = x->lastfreq;
+  t_float *lastamp = x->lastamp;
   int table_length = x->table_length;
-  float *output_buffer = x->output_buffer;
+  t_float *output_buffer = x->output_buffer;
   int vector_size = x->vector_size;
-  float i_vector_size = x->i_vector_size;
+  t_float i_vector_size = x->i_vector_size;
   int lo_bin = x->lo_bin;
   int hi_bin = x->hi_bin;
-  float *interleaved_spectrum = x->interleaved_spectrum;
-  float pitch_increment = x->pitch_increment;
-  float *index = x->index;
-  float *table = x->table;
+  t_float *interleaved_spectrum = x->interleaved_spectrum;
+  t_float pitch_increment = x->pitch_increment;
+  t_float *index = x->index;
+  t_float *table = x->table;
 
   for ( chan = lo_bin; chan < hi_bin; chan++ ) {
 
@@ -1090,14 +1090,14 @@
   }
 }
 ////////////////////////
-void init_rdft(int n, int *ip, float *w)
+void init_rdft(int n, int *ip, t_float *w)
 {
 
   int nw,
     nc;
 
-  void  makewt(int nw, int *ip, float *w);
-  void  makect(int nc, int *ip, float *c);
+  void  makewt(int nw, int *ip, t_float *w);
+  void  makect(int nc, int *ip, t_float *c);
 
   nw = n >> 2;
   makewt(nw, ip, w);
@@ -1109,18 +1109,18 @@
 }
 
 
-void rdft(int n, int isgn, float *a, int *ip, float *w)
+void rdft(int n, int isgn, t_float *a, int *ip, t_float *w)
 {
 
   int   j,
     nw,
     nc;
 
-  float   xi;
+  t_float   xi;
 
-  void    bitrv2(int n, int *ip, float *a),
-    cftsub(int n, float *a, float *w),
-    rftsub(int n, float *a, int nc, float *c);
+  void    bitrv2(int n, int *ip, t_float *a),
+    cftsub(int n, t_float *a, t_float *w),
+    rftsub(int n, t_float *a, int nc, t_float *c);
 
 
   nw = ip[0];
@@ -1165,10 +1165,10 @@
 }
 
 
-void bitrv2(int n, int *ip, float *a)
+void bitrv2(int n, int *ip, t_float *a)
 {
   int j, j1, k, k1, l, m, m2;
-  float xr, xi;
+  t_float xr, xi;
 
   ip[0] = 0;
   l = n;
@@ -1227,11 +1227,11 @@
 }
 
 
-void cftsub(int n, float *a, float *w)
+void cftsub(int n, t_float *a, t_float *w)
 {
   int j, j1, j2, j3, k, k1, ks, l, m;
-  float wk1r, wk1i, wk2r, wk2i, wk3r, wk3i;
-  float x0r, x0i, x1r, x1i, x2r, x2i, x3r, x3i;
+  t_float wk1r, wk1i, wk2r, wk2i, wk3r, wk3i;
+  t_float x0r, x0i, x1r, x1i, x2r, x2i, x3r, x3i;
 
   l = 2;
 
@@ -1350,10 +1350,10 @@
 }
 
 
-void rftsub(int n, float *a, int nc, float *c)
+void rftsub(int n, t_float *a, int nc, t_float *c)
 {
   int j, k, kk, ks;
-  float wkr, wki, xr, xi, yr, yi;
+  t_float wkr, wki, xr, xi, yr, yi;
 
   ks = (nc << 2) / n;
   kk = 0;
@@ -1375,11 +1375,11 @@
 }
 
 
-void makewt(int nw, int *ip, float *w)
+void makewt(int nw, int *ip, t_float *w)
 {
-  void bitrv2(int n, int *ip, float *a);
+  void bitrv2(int n, int *ip, t_float *a);
   int nwh, j;
-  float delta, x, y;
+  t_float delta, x, y;
 
   ip[0] = nw;
   ip[1] = 1;
@@ -1403,10 +1403,10 @@
 }
 
 
-void makect(int nc, int *ip, float *c)
+void makect(int nc, int *ip, t_float *c)
 {
   int nch, j;
-  float delta;
+  t_float delta;
 
   ip[1] = nc;
   if (nc > 1) {
@@ -1420,19 +1420,19 @@
     }
   }
 }
-void convert(float *S, float *C, int N2, float *lastphase, float fundamental, float factor )
+void convert(t_float *S, t_float *C, int N2, t_float *lastphase, t_float fundamental, t_float factor )
 {
-  float   phase,
+  t_float   phase,
     phasediff;
   int     real,
     imag,
     amp,
     freq;
-  float   a,
+  t_float   a,
     b;
   int     i;
 
-  /*  float myTWOPI, myPI; */
+  /*  t_float myTWOPI, myPI; */
   /*  double sin(), cos(), atan(), hypot();*/
 
   /*  myTWOPI = 8.*atan(1.);
@@ -1459,7 +1459,7 @@
     C[freq] = phasediff*factor + i*fundamental;
   }
 }
-void fold( float *I, float *W, int Nw, float *O, int N, int n )
+void fold( t_float *I, t_float *W, int Nw, t_float *O, int N, int n )
 {
   int i;
 
@@ -1476,10 +1476,10 @@
   }
 }
 
-void makehanning( float *H, float *A, float *S, int Nw, int N, int I, int odd )
+void makehanning( t_float *H, t_float *A, t_float *S, int Nw, int N, int I, int odd )
 {
   int i;
-  float sum ;
+  t_float sum ;
 
 
   if (odd) {
@@ -1495,7 +1495,7 @@
   }
 
   if ( Nw > N ) {
-    float x ;
+    t_float x ;
 
     x = -(Nw - 1)/2. ;
     for ( i = 0 ; i < Nw ; i++, x += 1. )
@@ -1509,8 +1509,8 @@
     sum += A[i] ;
 
   for ( i = 0 ; i < Nw ; i++ ) {
-    float afac = 2./sum ;
-    float sfac = Nw > N ? 1./afac : afac ;
+    t_float afac = 2./sum ;
+    t_float sfac = Nw > N ? 1./afac : afac ;
     A[i] *= afac ;
     S[i] *= sfac ;
   }
--- pd-lyonpotpourri.orig/splitspec~.c
+++ pd-lyonpotpourri/splitspec~.c
@@ -22,11 +22,11 @@
   t_float *t_offset_loc;
   t_float *b_offset_loc;
   t_float *manual_control_loc;
-  float frame_duration;
+  t_float frame_duration;
   int table_offset;
   int bin_offset;
-  float *last_mag;
-  float *current_mag;
+  t_float *last_mag;
+  t_float *current_mag;
   int *last_binsplit;
   int *current_binsplit;
   int **stored_binsplits;
@@ -39,8 +39,8 @@
   long countdown_samps; // samps for a given fadetime
   long counter;
   int overlap_factor; // compensate for overlap in fade
-  float sr;
-  float fl_phase; // show phase as float
+  t_float sr;
+  t_float fl_phase; // show phase as t_float
   int hopsamps; // number of samples to hop
   int channel_count; // number of channels to split
   t_clock *phase_clock;
@@ -65,10 +65,10 @@
 static void splitspec_store( t_splitspec *x, t_floatarg floc);
 static void splitspec_recall( t_splitspec *x, t_floatarg floc);
 static void splitspeci( int *current_binsplit, int *last_binsplit, int bin_offset, int table_offset,
-                 float *current_mag, float *last_mag, float *inmag, float *dest_mag, int start, int end, int n,
-                 float oldfrac, float newfrac );
+                 t_float *current_mag, t_float *last_mag, t_float *inmag, t_float *dest_mag, int start, int end, int n,
+                 t_float oldfrac, t_float newfrac );
 static void splitspec( int *binsplit, int bin_offset, int table_offset,
-                float *inmag, float *dest_mag, int start, int end, int n );
+                t_float *inmag, t_float *dest_mag, int start, int end, int n );
 
 static void splitspec_dsp_free( t_splitspec *x );
 
@@ -234,8 +234,8 @@
 }
 
 void splitspeci( int *current_binsplit, int *last_binsplit, int bin_offset, int table_offset,
-                 float *current_mag, float *last_mag, float *inmag, float *dest_mag, int start, int end, int n,
-                 float oldfrac, float newfrac )
+                 t_float *current_mag, t_float *last_mag, t_float *inmag, t_float *dest_mag, int start, int end, int n,
+                 t_float oldfrac, t_float newfrac )
 {
   int i;
   int bindex;
@@ -262,7 +262,7 @@
 }
 
 void splitspec( int *binsplit, int bin_offset, int table_offset,
-                float *inmag, float *dest_mag, int start, int end, int n )
+                t_float *inmag, t_float *dest_mag, int start, int end, int n )
 {
   int i;
   int bindex;
@@ -386,11 +386,11 @@
   t_splitspec *x = (t_splitspec *) (w[1]);
   int channel_count = x->channel_count;
 
-  float *inmag = (t_float *)(w[2]);
-  float *inphase = (t_float *)(w[3]);
-  float *t_offset = (t_float *)(w[4]);
-  float *b_offset = (t_float *)(w[5]);
-  float *manual_control = (t_float *)(w[6]);
+  t_float *inmag = (t_float *)(w[2]);
+  t_float *inphase = (t_float *)(w[3]);
+  t_float *t_offset = (t_float *)(w[4]);
+  t_float *b_offset = (t_float *)(w[5]);
+  t_float *manual_control = (t_float *)(w[6]);
 
   t_float **magvecs = x->magvecs;
   t_float **phasevecs = x->phasevecs;
@@ -401,11 +401,11 @@
 
   int *current_binsplit = x->current_binsplit;
   int *last_binsplit = x->last_binsplit;
-  float *last_mag = x->last_mag;
-  float *current_mag = x->current_mag;
+  t_float *last_mag = x->last_mag;
+  t_float *current_mag = x->current_mag;
   long counter = x->counter;
   long countdown_samps = x->countdown_samps;
-  float frac, oldgain, newgain;
+  t_float frac, oldgain, newgain;
   t_float *inmag_loc = x->inmag_loc;
   t_float *inphase_loc = x->inphase_loc;
   t_float *t_offset_loc = x->t_offset_loc;
@@ -500,7 +500,7 @@
     frac = 1.0;
   } else {
     // do interpolation
-    frac = (float) counter / (float) countdown_samps;
+    frac = (t_float) counter / (t_float) countdown_samps;
     oldgain = cos( frac * PIOVERTWO );
     newgain = sin( frac * PIOVERTWO );
     for(j = 0; j < channel_count; j++) {
@@ -519,7 +519,7 @@
   }
 
   x->fl_phase = frac;
-  clock_delay(x->phase_clock,0.0); // send current phase to float outlet
+  clock_delay(x->phase_clock,0.0); // send current phase to t_float outlet
   x->counter = counter;
   return (w + next_ptr);
 }
@@ -595,7 +595,7 @@
 }
 
 void splitspec_ramptime (t_splitspec *x, t_symbol *msg, int argc, t_atom *argv) {
-  float rampdur;
+  t_float rampdur;
 
   rampdur = atom_getfloatarg(0,argc,argv) * 0.001; // convert from milliseconds
   x->countdown_samps = rampdur * x->sr;
@@ -615,7 +615,7 @@
 
   if(! x->initialize) {
     for( i = 0; i < x->N2; i++ ) {
-      SETFLOAT(list_data+count,(float)x->current_binsplit[i]);
+      SETFLOAT(list_data+count,(t_float)x->current_binsplit[i]);
       ++count;
     }
     outlet_list(x->list_outlet,0,x->N2,list_data);
@@ -666,14 +666,14 @@
     //       post("FFT size is %d, N2 is %d",x->N, x->N2);
     //R = sys_getsr();
 //        post("sampling rate: %f, vector thinks it is: %f", sys_getsr(), sp[0]->s_sr);
-    //funda = R / (2. * (float) x->N) ;
+    //funda = R / (2. * (t_float) x->N) ;
 
     if(x->initialize) {
       x->list_data = (t_atom *) getbytes((x->N + 2) * sizeof(t_atom));
       x->last_binsplit = (int *) getbytes( x->N2 * sizeof(int));
       x->current_binsplit = (int *) getbytes( x->N2 * sizeof(int));
-      x->last_mag = (float *) getbytes(x->N2 * sizeof(float)) ;
-      x->current_mag = (float *) getbytes(x->N2 * sizeof(float)) ;
+      x->last_mag = (t_float *) getbytes(x->N2 * sizeof(t_float)) ;
+      x->current_mag = (t_float *) getbytes(x->N2 * sizeof(t_float)) ;
       x->stored_slots = (short *) getbytes(x->N2 * sizeof(short));
       x->stored_binsplits = (int **) getbytes(MAXSTORE * sizeof(int *));
       for( i = 0; i < MAXSTORE; i++ ) {
@@ -685,8 +685,8 @@
       x->list_data = (t_atom *) resizebytes((void *)x->list_data,(x->N_old + 2) * sizeof(t_atom), (x->N + 2) * sizeof(t_atom));
       x->last_binsplit = (int *) resizebytes((void *)x->last_binsplit,x->N2_old * sizeof(int), x->N2 * sizeof(int));
       x->current_binsplit = (int *) resizebytes((void *)x->current_binsplit,x->N2_old * sizeof(int), x->N2 * sizeof(int));
-      x->last_mag = (float *) resizebytes((void *)x->last_mag,x->N2_old * sizeof(float), x->N2 * sizeof(float));
-      x->current_mag = (float *) resizebytes((void *)x->current_mag,x->N2_old * sizeof(float), x->N2 * sizeof(float));
+      x->last_mag = (t_float *) resizebytes((void *)x->last_mag,x->N2_old * sizeof(t_float), x->N2 * sizeof(t_float));
+      x->current_mag = (t_float *) resizebytes((void *)x->current_mag,x->N2_old * sizeof(t_float), x->N2 * sizeof(t_float));
       x->stored_slots = (short *) resizebytes((void *)x->stored_slots,x->N2_old * sizeof(short), x->N2 * sizeof(short));
       for( i = 0; i < MAXSTORE; i++ ) {
         x->stored_binsplits[i] = (int *) resizebytes((void *)x->stored_binsplits[i],x->N2_old * sizeof(int), x->N2 * sizeof(int));
@@ -699,7 +699,7 @@
       }
     }
 
-    x->frame_duration = (float) sp[0]->s_n / sp[0]->s_sr;
+    x->frame_duration = (t_float) sp[0]->s_n / sp[0]->s_sr;
 
     splitspec_scramble( x );
     for( i = 0; i < x->N2; i++ ) {
--- pd-lyonpotpourri.orig/squash~.c
+++ pd-lyonpotpourri/squash~.c
@@ -19,26 +19,26 @@
   int N2;
   int incnt;
   int outcnt;
-  float *Wanal;
-  float *Wsyn;
-  float *Hwin;
-  float *buffer;
-  float *input;
-  float *output;
-  float thresh;
-  float ratio;
-  float nt;
-  float nmult;
+  t_float *Wanal;
+  t_float *Wsyn;
+  t_float *Hwin;
+  t_float *buffer;
+  t_float *input;
+  t_float *output;
+  t_float thresh;
+  t_float ratio;
+  t_float nt;
+  t_float nmult;
   short mute;
 } t_squash;
 
 
-//static float boundrand(float min, float max);
+//static t_float boundrand(t_float min, t_float max);
 static void *squash_new(t_symbol *msg, int argc, t_atom *argv);
 static void squash_mute(t_squash *x, t_floatarg toggle);
 //static void squash_assist (t_squash *x, void *b, long msg, long arg, char *dst);
 //static void squash_dsp_free(t_squash *x);
-static double squash_squat( float *buffer, float thresh, float ratio, float nt, float nmult, int N );
+static double squash_squat( t_float *buffer, t_float thresh, t_float ratio, t_float nt, t_float nmult, int N );
 static void squash_mute(t_squash *x, t_floatarg f);
 static void squash_thresh(t_squash *x, t_floatarg f);
 static void squash_nt(t_squash *x, t_floatarg f);
@@ -49,12 +49,12 @@
 static void squash_dsp(t_squash *x, t_signal **sp);
 
 
-static void overlapadd( float *I, int N, float *W, float *O, int Nw, int n );
-static void fold( float *I, float *W, int Nw, float *O, int N, int n );
+static void overlapadd( t_float *I, int N, t_float *W, t_float *O, int Nw, int n );
+static void fold( t_float *I, t_float *W, int Nw, t_float *O, int N, int n );
 /*
-void makehanning( float *H, float *A, float *S, int Nw, int N, int I, int odd );
-void makehamming( float *H, float *A, float *S, int Nw, int N, int I, int odd );
-void makewindows( float *H, float *A, float *S, int Nw, int N, int I );
+void makehanning( t_float *H, t_float *A, t_float *S, int Nw, int N, int I, int odd );
+void makehamming( t_float *H, t_float *A, t_float *S, int Nw, int N, int I, int odd );
+void makewindows( t_float *H, t_float *A, t_float *S, int Nw, int N, int I );
 */
 
 void squash_tilde_setup(void) {
@@ -81,12 +81,12 @@
   x->Nw = x->N;
   x->N2 = x->N / 2;
   x->incnt = - x->Nw;
-  x->Wanal = (float *) getbytes(x->Nw * sizeof(float));
-  x->Wsyn = (float *) getbytes(x->Nw *  sizeof(float));
-  x->Hwin = (float *) getbytes(x->Nw * sizeof(float));
-  x->input = (float *) getbytes(x->Nw * sizeof(float));
-  x->output = (float *) getbytes(x->Nw * sizeof(float));
-  x->buffer = (float *) getbytes(x->N * sizeof(float));
+  x->Wanal = (t_float *) getbytes(x->Nw * sizeof(t_float));
+  x->Wsyn = (t_float *) getbytes(x->Nw *  sizeof(t_float));
+  x->Hwin = (t_float *) getbytes(x->Nw * sizeof(t_float));
+  x->input = (t_float *) getbytes(x->Nw * sizeof(t_float));
+  x->output = (t_float *) getbytes(x->Nw * sizeof(t_float));
+  x->buffer = (t_float *) getbytes(x->N * sizeof(t_float));
   lpp_makehanning(x->Hwin, x->Wanal, x->Wsyn, x->Nw, x->N, x->D, 0);
   x->thresh = 0.1;
   x->ratio = 1.;
@@ -99,25 +99,25 @@
 
 void squash_free(t_squash *x)
 {
-    freebytes(x->Wanal, x->Nw * sizeof(float));
-    freebytes(x->Wsyn, x->Nw *  sizeof(float));
-    freebytes(x->Hwin, x->Nw * sizeof(float));
-    freebytes(x->input, x->Nw * sizeof(float));
-    freebytes(x->output, x->Nw * sizeof(float));
-    freebytes(x->buffer, x->N * sizeof(float));
+    freebytes(x->Wanal, x->Nw * sizeof(t_float));
+    freebytes(x->Wsyn, x->Nw *  sizeof(t_float));
+    freebytes(x->Hwin, x->Nw * sizeof(t_float));
+    freebytes(x->input, x->Nw * sizeof(t_float));
+    freebytes(x->output, x->Nw * sizeof(t_float));
+    freebytes(x->buffer, x->N * sizeof(t_float));
 }
 /*
-void makewindows( float *H, float *A, float *S, int Nw, int N, int I )
+void makewindows( t_float *H, t_float *A, t_float *S, int Nw, int N, int I )
 
 {
   int i ;
-  float sum ;
+  t_float sum ;
 
   for ( i = 0 ; i < Nw ; i++ )
     H[i] = A[i] = S[i] = 0.54 - 0.46*cos( TWOPI*i/(Nw - 1) ) ;
 
   if ( Nw > N ) {
-    float x ;
+    t_float x ;
 
     x = -(Nw - 1)/2. ;
     for ( i = 0 ; i < Nw ; i++, x += 1. )
@@ -132,8 +132,8 @@
     sum += A[i] ;
 
   for ( i = 0 ; i < Nw ; i++ ) {
-    float afac = 2./sum ;
-    float sfac = Nw > N ? 1./afac : afac ;
+    t_float afac = 2./sum ;
+    t_float sfac = Nw > N ? 1./afac : afac ;
     A[i] *= afac ;
     S[i] *= sfac ;
   }
@@ -149,11 +149,11 @@
 
 
 
-void makehamming( float *H, float *A, float *S, int Nw, int N, int I, int odd )
+void makehamming( t_float *H, t_float *A, t_float *S, int Nw, int N, int I, int odd )
 
 {
   int i;
-  float sum ;
+  t_float sum ;
 
 
 
@@ -170,7 +170,7 @@
   }
 
   if ( Nw > N ) {
-    float x ;
+    t_float x ;
 
     x = -(Nw - 1)/2. ;
     for ( i = 0 ; i < Nw ; i++, x += 1. )
@@ -184,8 +184,8 @@
     sum += A[i] ;
 
   for ( i = 0 ; i < Nw ; i++ ) {
-    float afac = 2./sum ;
-    float sfac = Nw > N ? 1./afac : afac ;
+    t_float afac = 2./sum ;
+    t_float sfac = Nw > N ? 1./afac : afac ;
     A[i] *= afac ;
     S[i] *= sfac ;
   }
@@ -200,10 +200,10 @@
 
 
 
-void makehanning( float *H, float *A, float *S, int Nw, int N, int I, int odd )
+void makehanning( t_float *H, t_float *A, t_float *S, int Nw, int N, int I, int odd )
 {
   int i;
-  float sum ;
+  t_float sum ;
 
 
   if (odd) {
@@ -219,7 +219,7 @@
   }
 
   if ( Nw > N ) {
-    float x ;
+    t_float x ;
 
     x = -(Nw - 1)/2. ;
     for ( i = 0 ; i < Nw ; i++, x += 1. )
@@ -233,8 +233,8 @@
     sum += A[i] ;
 
   for ( i = 0 ; i < Nw ; i++ ) {
-    float afac = 2./sum ;
-    float sfac = Nw > N ? 1./afac : afac ;
+    t_float afac = 2./sum ;
+    t_float sfac = Nw > N ? 1./afac : afac ;
     A[i] *= afac ;
     S[i] *= sfac ;
   }
@@ -252,7 +252,7 @@
 
 */
 
-void overlapadd( float *I, int N, float *W, float *O, int Nw, int n )
+void overlapadd( t_float *I, int N, t_float *W, t_float *O, int Nw, int n )
 {
   int i ;
   while ( n < 0 )
@@ -265,7 +265,7 @@
   }
 }
 
-void fold( float *I, float *W, int Nw, float *O, int N, int n )
+void fold( t_float *I, t_float *W, int Nw, t_float *O, int N, int n )
 
 {
   int i;
@@ -288,44 +288,44 @@
 }
 
 void squash_thresh(t_squash *x, t_floatarg f) {
-  x->thresh = (float)f;
+  x->thresh = (t_float)f;
 }
 
 void squash_nt(t_squash *x, t_floatarg f) {
-  x->nt = (float)f;
+  x->nt = (t_float)f;
 }
 
 void squash_ratio(t_squash *x, t_floatarg f) {
-  x->ratio = (float)f;
+  x->ratio = (t_float)f;
 }
 
 void squash_nmult(t_squash *x, t_floatarg f) {
-  x->nmult = (float)f;
+  x->nmult = (t_float)f;
 }
 
 t_int *squash_perform(t_int *w)
 {
   t_squash *x = (t_squash *) (w[1]);
-  float *in = (t_float *)(w[2]);
-  float *out = (t_float *)(w[3]);
+  t_float *in = (t_float *)(w[2]);
+  t_float *out = (t_float *)(w[3]);
   int n = (int) w[4];
 
   int j;
-  float *input = x->input;
-  float *output = x->output;
+  t_float *input = x->input;
+  t_float *output = x->output;
   int D = x->D;
   int Nw = x->Nw;
   int N = x->N;
-  float *buffer = x->buffer;
-  float *Wanal = x->Wanal;
-  float *Wsyn = x->Wsyn;
-  float thresh = x->thresh;
-  float ratio = x->ratio;
-  float nt = x->nt;
-  float nmult = x->nmult;
+  t_float *buffer = x->buffer;
+  t_float *Wanal = x->Wanal;
+  t_float *Wsyn = x->Wsyn;
+  t_float thresh = x->thresh;
+  t_float ratio = x->ratio;
+  t_float nt = x->nt;
+  t_float nmult = x->nmult;
 
   if(x->mute) {
-    memset((void *)out, 0, n * sizeof(float) );
+    memset((void *)out, 0, n * sizeof(t_float) );
     return w + 5;
   }
 
@@ -368,12 +368,12 @@
 
 /*  compression/expansion routine! */
 
-double squash_squat( float *buffer, float thresh, float ratio, float nt, float nmult, int N )
+double squash_squat( t_float *buffer, t_float thresh, t_float ratio, t_float nt, t_float nmult, int N )
 {
   register int    i;
   double    rms = 0.;
-  float   dbthr;
-  register float  mult;
+  t_float   dbthr;
+  register t_float  mult;
 
   dbthr = 10. * log10(thresh);
 
@@ -381,7 +381,7 @@
   for ( i=0; i < N; i++ )
     rms += ( *(buffer+i) * *(buffer+i) );
 
-  rms = sqrt(rms/(float)N);
+  rms = sqrt(rms/(t_float)N);
   if (rms < nt && ratio < 1.)
     mult = nmult;
   else
--- pd-lyonpotpourri.orig/stutter~.c
+++ pd-lyonpotpourri/stutter~.c
@@ -52,7 +52,7 @@
   int *stored_starts;
   int *stored_samps;
   long b_valid;
-  //float *b_samples;
+  //t_float *b_samples;
   t_word *b_samples;
   long b_frames;
 } t_stutter;
@@ -79,12 +79,12 @@
 static void stutter_min_echo(t_stutter *x,  t_floatarg f);
 static void stutter_max_echo(t_stutter *x,  t_floatarg f);
 static void stutter_minmax_echo(t_stutter *x,  t_floatarg minf, t_floatarg maxf);
-static float boundrand(float min, float max);
+static t_float boundrand(t_float min, t_float max);
 static void stutter_init(t_stutter *x,short initialized);
 //static void stutter_info(t_stutter *x);
 //static void stutter_version(t_stutter *x);
 static void stutter_setarray(t_stutter *x);
-static float erand(void);
+static t_float erand(void);
 
 t_symbol *ps_buffer;
 
@@ -192,7 +192,7 @@
 
     if( x->framesize != b_frames ) {
       x->framesize = b_frames;
-      x->buffer_duration = (float)  b_frames / (float) x->R ;
+      x->buffer_duration = (t_float)  b_frames / (t_float) x->R ;
     }
 
     while( n-- ) {
@@ -203,10 +203,10 @@
       }
       theSample = tab[ b_index ].w_float;
       if( samps_to_go > loop_samps - taper_samps ) {
-        *out1++ = theSample * ( (float)(loop_samps - samps_to_go)/(float)taper_samps );
+        *out1++ = theSample * ( (t_float)(loop_samps - samps_to_go)/(t_float)taper_samps );
         ++b_index;
       } else if( samps_to_go < taper_samps ) {
-        *out1++ = theSample * ( (float)(samps_to_go)/(float)taper_samps );
+        *out1++ = theSample * ( (t_float)(samps_to_go)/(t_float)taper_samps );
         ++b_index;
 
       } else {
@@ -220,9 +220,9 @@
           sdev = -sdev;
         }
         if(  ( --echos <= 0 ) && ( ! lock_loop ) ) {
-          echos = (int)boundrand((float)x->min_echo,(float)x->max_echo);
+          echos = (int)boundrand((t_float)x->min_echo,(t_float)x->max_echo);
           samps_to_go = loop_samps =
-            loop_min_samps + ( erand() * (float)(loop_max_samps-loop_min_samps) ) ;
+            loop_min_samps + ( erand() * (t_float)(loop_max_samps-loop_min_samps) ) ;
           loop_start = erand() * (b_frames - loop_samps) ;
         } else {
           loop_samps += sdev;
@@ -261,12 +261,12 @@
   }
 }
 
-float erand(void) {
+t_float erand(void) {
   static int im = 6075 ;
   static int ia = 106 ;
   static int ic = 1283 ;
   rand_state = (rand_state * ia +  ic) % im ;
-  return ( (float) rand_state / (float) im );
+  return ( (t_float) rand_state / (t_float) im );
 }
 
 void stutter_info(t_stutter *x)
@@ -276,8 +276,8 @@
 
 void stutter_new_loop(t_stutter *x)
 {
-  x->echos = (int)boundrand((float)x->min_echo,(float)x->max_echo);
-  x->samps_to_go = x->loop_samps = boundrand((float)x->loop_min_samps,(float)x->loop_max_samps);
+  x->echos = (int)boundrand((t_float)x->min_echo,(t_float)x->max_echo);
+  x->samps_to_go = x->loop_samps = boundrand((t_float)x->loop_min_samps,(t_float)x->loop_max_samps);
   x->loop_start = boundrand(0.0,1.0) * (x->framesize - x->loop_samps) ;
 }
 
@@ -316,7 +316,7 @@
 
 void stutter_set_loop(t_stutter *x, t_symbol *msg, int argc, t_atom *argv)
 {
-  float temp;
+  t_float temp;
   atom_arg_getfloat(&temp, 0, argc, argv);
   x->loop_start = temp;
   atom_arg_getfloat(&temp, 0, argc, argv);
@@ -418,9 +418,9 @@
   return x;
 }
 
-float boundrand(float min, float max)
+t_float boundrand(t_float min, t_float max)
 {
-  return min + (max-min) * ((float)rand()/RAND_MAX);
+  return min + (max-min) * ((t_float)rand()/RAND_MAX);
 }
 
 void stutter_taper(t_stutter *x,  t_floatarg f)
@@ -472,15 +472,15 @@
   int i;
 
   if(!initialized) {
-    x->loop_min_samps = x->loop_min_duration * (float)x->R;
-    x->loop_max_samps = x->loop_max_duration * (float)x->R;
+    x->loop_min_samps = x->loop_min_duration * (t_float)x->R;
+    x->loop_max_samps = x->loop_max_duration * (t_float)x->R;
     x->samps_to_go = x->loop_samps = x->loop_min_samps +
-      (erand() * (float)(x->loop_max_samps-x->loop_min_samps) ) ;
+      (erand() * (t_float)(x->loop_max_samps-x->loop_min_samps) ) ;
 
     x->loop_start = 0;
     x->min_echo = 2;
     x->max_echo = 12;
-    x->echos = (int) boundrand((float)x->min_echo,(float)x->max_echo);
+    x->echos = (int) boundrand((t_float)x->min_echo,(t_float)x->max_echo);
     x->b_index = x->loop_start ;
     x->samps_to_go = x->loop_samps;
     x->taper_samps = x->R * x->taper_duration;
@@ -498,10 +498,10 @@
       x->stored_samps[i] = 0;
     }
   } else {
-    x->loop_min_samps = x->loop_min_duration * (float)x->R;
-    x->loop_max_samps = x->loop_max_duration * (float)x->R;
+    x->loop_min_samps = x->loop_min_duration * (t_float)x->R;
+    x->loop_max_samps = x->loop_max_duration * (t_float)x->R;
     x->samps_to_go = x->loop_samps = x->loop_min_samps +
-      (erand() * (float)(x->loop_max_samps - x->loop_min_samps)) ;
+      (erand() * (t_float)(x->loop_max_samps - x->loop_min_samps)) ;
     x->loop_start = 0;
     x->b_index = x->loop_start;
     x->samps_to_go = x->loop_samps;
--- pd-lyonpotpourri.orig/ugens.h
+++ pd-lyonpotpourri/ugens.h
@@ -8,49 +8,49 @@
 #define NALPASSES 2 /* for reverb */
 
 typedef struct {
-  float ps0;
-  float ps1;
-  float ps2;
-  float ps3;
-  float c0;
-  float c1;
-  float c2;
-  float c3;
+  t_float ps0;
+  t_float ps1;
+  t_float ps2;
+  t_float ps3;
+  t_float c0;
+  t_float c1;
+  t_float c2;
+  t_float c3;
 } LSTRUCT ;
 
 typedef struct {
   int len;
-  float *func;
-  float amp;
-  float phs;
-  float si;
+  t_float *func;
+  t_float amp;
+  t_float phs;
+  t_float si;
 } CMIXOSC ;
 
 typedef struct {
-  float *arr;
-  float lpt;
-  float rvbt;
+  t_float *arr;
+  t_float lpt;
+  t_float rvbt;
   int len;
   int status;
 } CMIXCOMB ;
 
 typedef struct {
-  float cf;
-  float bw;
-  float scl;
-  float q[5];
+  t_float cf;
+  t_float bw;
+  t_float scl;
+  t_float q[5];
 } CMIXRESON ;
 
 typedef struct {
-  float a;
-  float d;
-  float s;
-  float r;
-  float v1;
-  float v2;
-  float v3;
-  float v4;
-  float v5;
-  float *func;
+  t_float a;
+  t_float d;
+  t_float s;
+  t_float r;
+  t_float v1;
+  t_float v2;
+  t_float v3;
+  t_float v4;
+  t_float v5;
+  t_float *func;
   int len;
 } CMIXADSR ;
--- pd-lyonpotpourri.orig/unconvert.c
+++ pd-lyonpotpourri/unconvert.c
@@ -2,11 +2,11 @@
 
 
 
-void unconvert( float *C, float *S, int N2, float *lastphase, float fundamental, float factor )
+void unconvert( t_float *C, t_float *S, int N2, t_float *lastphase, t_float fundamental, t_float factor )
 
 {
   int i, real, imag, amp, freq;
-  float mag, phase;
+  t_float mag, phase;
   double sin(), cos();
 
   for ( i = 0; i <= N2; i++ ) {
--- pd-lyonpotpourri.orig/vecdex~.c
+++ pd-lyonpotpourri/vecdex~.c
@@ -11,7 +11,7 @@
 typedef struct _vecdex {
   t_object obj;
   t_float x_f;
-//    float top;
+//    t_float top;
 } t_vecdex;
 
 #define OBJECT_NAME "vecdex~"
--- pd-lyonpotpourri.orig/windowvec~.c
+++ pd-lyonpotpourri/windowvec~.c
@@ -11,7 +11,7 @@
 typedef struct _windowvec {
   t_object obj;
   t_float x_f;
-  float *envelope;
+  t_float *envelope;
   long vecsize;
   long oldbytes;
 } t_windowvec;
@@ -61,7 +61,7 @@
   t_float *output = (t_float *) (w[3]);
   int n = (int) w[4];
   int i;
-  float *envelope = x->envelope;
+  t_float *envelope = x->envelope;
 
   /* Apply a Hann window to the input vector */
 
@@ -74,23 +74,23 @@
 void windowvec_dsp(t_windowvec *x, t_signal **sp, short *count)
 {
   int i;
-  float twopi = 8. * atan(1);
+  t_float twopi = 8. * atan(1);
   if(x->vecsize != sp[0]->s_n) {
     x->vecsize = sp[0]->s_n;
 
     /* Allocate memory */
 
     if(x->envelope == NULL) {
-      x->envelope = (float *) getbytes(x->vecsize * sizeof(float));
+      x->envelope = (t_float *) getbytes(x->vecsize * sizeof(t_float));
     } else {
-      x->envelope = (float *) resizebytes(x->envelope, x->oldbytes, x->vecsize * sizeof(float));
+      x->envelope = (t_float *) resizebytes(x->envelope, x->oldbytes, x->vecsize * sizeof(t_float));
     }
-    x->oldbytes = x->vecsize * sizeof(float);
+    x->oldbytes = x->vecsize * sizeof(t_float);
 
     /* Generate a Hann window */
 
     for(i = 0 ; i < x->vecsize; i++) {
-      x->envelope[i] = - 0.5 * cos(twopi * (i / (float)x->vecsize)) + 0.5;
+      x->envelope[i] = - 0.5 * cos(twopi * (i / (t_float)x->vecsize)) + 0.5;
     }
   }
   dsp_add(windowvec_perform, 4, x, sp[0]->s_vec, sp[1]->s_vec, (t_int)sp[0]->s_n);
