# Changes of Note

- Python support now requires at least version 3.5+ of Python and version 1.13 of Numpy.
- `filters.icp` is no longer a plugin and provides options not previously available.
- Linear algebra that was using single-precision math is now using double-precision math.
- Support was added for GDAL version 3+.
- PCL support has been removed. PCD read/write and `filters.icp` is now natively supported. The PCL filters have been moved to the [unsupported-plugins](https://github.com/PDAL/unsuppported-plugins) repository for those that might need functionality they provided.
- PDAL now uses a JSON library that doesn't support comments.  If your pipelines contains non-standard JSON, they will no longer be accepted.
- PDAL now supports GCC 9.2, clang 8.0.1 and Visual Studio 17

# New Stages

- `filters.covariancefeatures` computes statistics about features of points in a neighborhood. (#2455 - Thanks [Helix.re](http://https://helixre.com/)!)
- `readers.e57` reads the E57 format. (#2442 - Thanks [Helix.re](http://https://helixre.com/)!)
- `writers.e57` writes the E57 format. (#2442 - Thanks [Helix.re](http://https://helixre.com/)!)
- `writers.gltf` provides simple glTF mesh output support. (#2643)
- `filters.reciprocity` computes the percentage of points that are considered uni-directional. (#2504 - @chambbj)
- `filters.miniball` computes a criterion for neighbors based on the miniball algorithm. (#2504 - @chambbj)
- `filters.planefit` computes a deviation of a point from a manifold approximating its neighbors. (#2504 - @chambbj)
- `readers.memory` provides an API interface for direct reading of row-oriented point data. (#2620)
- `filters.projpipeline` processes point through a [PROJ pipeline](https://proj.org/operations/transformations/deformation.html). (#2626 - Thanks @vilaa!)

# Deprecated Stages

- readers.sqlite (will be moved to [unsupported-plugins](https://github.com/PDAL/unsuppported-plugins) in a future release) 
- writers.sqlite (will be moved to [unsupported-plugins](https://github.com/PDAL/unsuppported-plugins) in a future release)
- readers.geowave (will be moved to [unsupported-plugins](https://github.com/PDAL/unsuppported-plugins) in a future release)
- writers.geowave (will be moved to [unsupported-plugins](https://github.com/PDAL/unsuppported-plugins) in a future release)

# Removed Stages

- `filters.mongus`
- `filters.kdistance`
- `readers.greyhound`

# Enhancements

- `readers.mrsid` now supports more recent versions of the Mr. Sid SDK. (#2460)
- `readers.tiledb` and `writers.tiledb` now support stream mode processing.  It also supports an `append` option.
- `readers.ept` now accepts an optional `\<spatial reference>` after the bounds specification in the `bounds` option to indicate the SRS of the provided boundary. (#2295)
- `filters.hag` now supports interpolation from a TIN (triangulated network) of points. (#2520 - Thanks [James McClain](https://github.com/jamesmcclain)!)
- `filters.poisson` now properly applies an inverse transform to points it creates. (#1840)
- `pdal --drivers` now shows the file extensions associated with each driver. It also shows when stages are streamable. (#2571, #2528)
- Some threaded execution has been added to `readers.ept`.
- Alternate dimension names have been added for "Red", "Green" and "Blue" to better support PLY input. (#2570)

# Bug Fixes

- Fixed a problem where data in a forwarded LAS VLR would be lost. (#2542)
- Clear dimension list in `filters.colorization` to eliminate the possibility of writing invalid data. (#2487)
- Delete code that removed control characters when converting to JSON. (#2355)
- Fixed an issue where nested geometries were being written as invalid WKT in `filter.hexbin`. (#2507)
- Fixed a segmentation fault in `readers.bpf` if the specified file didn't exist. (#2515)
- Fixed an issue in `writers.gdal` where interpolation would terminate if the process hit the raster edge. (#2545)
- Fixed an issue writing JSON when characters needed to be escaped. (#2558)
- Delaunay triangulation no longer segfaults with fewer than three points. (#2513)
- Issues with reading binary data with `filters.ept` have been fixed. (#2585)
- `pdal` now errors if an option is provided that wasn't expected. (#2574)
- Forwarding for scale with multiple LAS inputs was fixed. (#2663)

