# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright (C) 2013 Canonical Ltd.
# Author: Sergio Schvezov <sergio.schvezov@canonical.com>

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import logging
import tempfile

log = logging.getLogger()


def backup(adb, backup_file=tempfile.mkstemp()[1]):
    adb.shell('tar -czpf /tmp/backup.tar.gz '
              '/home/phablet '
              '/etc/NetworkManager/system-connections')
    log.info('Saving backup to %s' % backup_file)
    adb.pull('/tmp/backup.tar.gz', backup_file)
    return backup_file


def restore(adb, backup_file):
    adb.push(backup_file, '/tmp/backup.tar.gz')
    log.info('Restoring from %s' % backup_file)
    adb.shell('tar -xzpf /tmp/backup.tar.gz -C /')
    adb.reboot()
