#!/bin/sh

set -e

# Start a web server to serve the file.
php --server localhost:10101 --docroot debian/tests/data &
SERVER_PID=$!

# the startup can be racy making the test a false-positive
# wait up to 10 seconds until it is ready
r=0
until [ "$r" -ge 100 ]; do
    nc -z localhost 10101 && echo "PRE: Connection ready" && break
    sleep 0.1
    echo "PRE: Retry Connection"
done

# A graphviz source file can be created.
php debian/tests/rapper.php > sample.dot

kill -9 $SERVER_PID

# A valid dot can be used by graphviz.
dot -Tpng sample.dot > sample.png
MIME_TYPE=`file --mime-type --brief sample.png`
if [ "$MIME_TYPE" != 'image/png' ]
then
    exit 1;
fi
