/*
   +----------------------------------------------------------------------+
   | PHP version 4.0                                                      |
   +----------------------------------------------------------------------+
   | Copyright (c) 2000, 2001 Matt McClanahan                             |
   | Copyright (c) 2000, 2001, 2005 Steve Langasek                        |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.02 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available at through the world-wide-web at                           |
   | http://www.php.net/license/2_02.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   |                                                                      |
   | Alternatively, you may distribute and/or modify this code under the  |
   | terms of version 2 of the GNU Library General Public License as      |
   | published by the Free Software Foundation.                           |
   |                                                                      |
   | This software is distributed in the hope that it will be useful,     |
   | but WITHOUT ANY WARRANTY; without even the implied warranty of       |
   | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    |
   | Library General Public License for more details.                     |
   |                                                                      |
   | You should have received a copy of the GNU Library General Public    |
   | License in the file COPYING accompanying this software; if not,      |
   | write to the Free Software Foundation, Inc.,                         |
   | 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA              |
   |                                                                      |
   +----------------------------------------------------------------------+
   | Authors: Matt McClanahan <cardinal@dodds.net>                        |
   |          Steve Langasek <vorlon@dodds.net>                           |
   +----------------------------------------------------------------------+
 */

#ifndef _PHP_IMLIB_H
#define _PHP_IMLIB_H

#include <X11/Xlib.h>
#include <Imlib2.h>

#include "config.h"

#if HAVE_IMLIB

#ifdef ZTS
#include "TSRM.h"
#endif

extern zend_module_entry imlib_module_entry;
#define phpext_imlib_ptr &imlib_module_entry

#ifdef PHP_WIN32
#define PHP_IMLIB_API __declspec(dllexport)
#else
#define PHP_IMLIB_API
#endif

PHP_MINIT_FUNCTION(imlib);
PHP_MSHUTDOWN_FUNCTION(imlib);
PHP_RINIT_FUNCTION(imlib);
PHP_RSHUTDOWN_FUNCTION(imlib);
PHP_MINFO_FUNCTION(imlib);

PHP_INI_MH(OnUpdateFontCacheSize);

PHP_FUNCTION(imlib_add_color_to_color_range);
PHP_FUNCTION(imlib_blend_image_onto_image);
PHP_FUNCTION(imlib_clone_image);
PHP_FUNCTION(imlib_create_color_range);
PHP_FUNCTION(imlib_create_cropped_image);
PHP_FUNCTION(imlib_create_cropped_scaled_image);
PHP_FUNCTION(imlib_create_image);
PHP_FUNCTION(imlib_create_rotated_image);
PHP_FUNCTION(imlib_create_scaled_image);
PHP_FUNCTION(imlib_free_color_range);
PHP_FUNCTION(imlib_free_font);
PHP_FUNCTION(imlib_free_image);
PHP_FUNCTION(imlib_get_text_size);
PHP_FUNCTION(imlib_image_blur);
PHP_FUNCTION(imlib_image_draw_ellipse);
PHP_FUNCTION(imlib_image_draw_line);
PHP_FUNCTION(imlib_image_draw_polygon);
PHP_FUNCTION(imlib_image_draw_rectangle);
PHP_FUNCTION(imlib_image_fill_color_range_rectangle);
PHP_FUNCTION(imlib_image_fill_ellipse);
PHP_FUNCTION(imlib_image_fill_polygon);
PHP_FUNCTION(imlib_image_fill_rectangle);
PHP_FUNCTION(imlib_image_flip_horizontal);
PHP_FUNCTION(imlib_image_flip_vertical);
PHP_FUNCTION(imlib_image_flip_diagonal);
PHP_FUNCTION(imlib_image_format);
PHP_FUNCTION(imlib_image_get_filename);
PHP_FUNCTION(imlib_image_get_height);
PHP_FUNCTION(imlib_image_get_width);
PHP_FUNCTION(imlib_image_has_alpha);
PHP_FUNCTION(imlib_image_modify_alpha);
PHP_FUNCTION(imlib_image_set_format);
PHP_FUNCTION(imlib_image_sharpen);
PHP_FUNCTION(imlib_image_tile_horizontal);
PHP_FUNCTION(imlib_image_tile_vertical);
PHP_FUNCTION(imlib_image_tile);
PHP_FUNCTION(imlib_list_fonts);
PHP_FUNCTION(imlib_load_font);
PHP_FUNCTION(imlib_load_image);
PHP_FUNCTION(imlib_load_image_with_error_return);
PHP_FUNCTION(imlib_polygon_add_point);
PHP_FUNCTION(imlib_polygon_contains_point);
PHP_FUNCTION(imlib_polygon_free);
PHP_FUNCTION(imlib_polygon_get_bounds);
PHP_FUNCTION(imlib_polygon_new);
PHP_FUNCTION(imlib_save_image);
PHP_FUNCTION(imlib_dump_image);
PHP_FUNCTION(imlib_text_draw);
PHP_FUNCTION(imlib_get_cache_size);
PHP_FUNCTION(imlib_set_cache_size);

ZEND_BEGIN_MODULE_GLOBALS(imlib)
	char *font_path;
	char **saved_path;
	int cache_size;
	int min_cache_size;
	int max_cache_size;
ZEND_END_MODULE_GLOBALS(imlib)

#ifdef ZTS
#define IMLIBG(v) TSRMG(imlib_globals_id, zend_imlib_globals *, v)
#else
#define IMLIBG(v) (imlib_globals.v)
#endif

#else

#define phpext_imlib_ptr NULL

#endif

#endif	/* _PHP_IMLIB_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
