/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 120 "language.yacc"

/* This is the grammar definition of Pike. */

#include "global.h"
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif

#include "interpret.h"
#include "array.h"
#include "object.h"
#include "mapping.h"
#include "stralloc.h"
#include "las.h"
#include "interpret.h"
#include "program.h"
#include "pike_types.h"
#include "constants.h"
#include "pike_macros.h"
#include "pike_error.h"
#include "docode.h"
#include "pike_embed.h"
#include "opcodes.h"
#include "operators.h"
#include "bignum.h"

#define YYMAXDEPTH	1000

#ifdef PIKE_DEBUG
#ifndef YYDEBUG
/* May also be defined by machine.h */
#define YYDEBUG 1
#endif /* YYDEBUG */
#endif

/* Get verbose parse error reporting. */
#define YYERROR_VERBOSE	1

/* #define LAMBDA_DEBUG	1 */

static void yyerror_reserved(const char *keyword);
static struct pike_string *get_new_name(struct pike_string *prefix);
int add_local_name(struct pike_string *, struct pike_type *, node *);
int low_add_local_name(struct compiler_frame *,
		       struct pike_string *, struct pike_type *, node *);
static void mark_lvalues_as_used(node *n);
static node *lexical_islocal(struct pike_string *);
static node *safe_inc_enum(node *n);
static node *find_versioned_identifier(struct pike_string *identifier,
				       int major, int minor);
static int call_handle_import(struct pike_string *s);

static int inherit_depth;
static struct program_state *inherit_state = NULL;

/*
 * Kludge for Bison not using prototypes.
 */
#ifndef __GNUC__
#ifndef __cplusplus
static void __yy_memcpy(char *to, const char *from,
			unsigned int count);
#endif /* !__cplusplus */
#endif /* !__GNUC__ */


#line 138 "y.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_Y_TAB_H_INCLUDED
# define YY_YY_Y_TAB_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    TOK_ARROW = 258,               /* TOK_ARROW  */
    TOK_CONSTANT = 259,            /* TOK_CONSTANT  */
    TOK_FLOAT = 260,               /* TOK_FLOAT  */
    TOK_STRING = 261,              /* TOK_STRING  */
    TOK_NUMBER = 262,              /* TOK_NUMBER  */
    TOK_INC = 263,                 /* TOK_INC  */
    TOK_DEC = 264,                 /* TOK_DEC  */
    TOK_RETURN = 265,              /* TOK_RETURN  */
    TOK_EQ = 266,                  /* TOK_EQ  */
    TOK_GE = 267,                  /* TOK_GE  */
    TOK_LE = 268,                  /* TOK_LE  */
    TOK_NE = 269,                  /* TOK_NE  */
    TOK_NOT = 270,                 /* TOK_NOT  */
    TOK_LSH = 271,                 /* TOK_LSH  */
    TOK_RSH = 272,                 /* TOK_RSH  */
    TOK_LAND = 273,                /* TOK_LAND  */
    TOK_LOR = 274,                 /* TOK_LOR  */
    TOK_SWITCH = 275,              /* TOK_SWITCH  */
    TOK_SSCANF = 276,              /* TOK_SSCANF  */
    TOK_CATCH = 277,               /* TOK_CATCH  */
    TOK_FOREACH = 278,             /* TOK_FOREACH  */
    TOK_LEX_EOF = 279,             /* TOK_LEX_EOF  */
    TOK_ADD_EQ = 280,              /* TOK_ADD_EQ  */
    TOK_AND_EQ = 281,              /* TOK_AND_EQ  */
    TOK_ARRAY_ID = 282,            /* TOK_ARRAY_ID  */
    TOK_ATTRIBUTE_ID = 283,        /* TOK_ATTRIBUTE_ID  */
    TOK_BREAK = 284,               /* TOK_BREAK  */
    TOK_CASE = 285,                /* TOK_CASE  */
    TOK_CLASS = 286,               /* TOK_CLASS  */
    TOK_COLON_COLON = 287,         /* TOK_COLON_COLON  */
    TOK_CONTINUE = 288,            /* TOK_CONTINUE  */
    TOK_DEFAULT = 289,             /* TOK_DEFAULT  */
    TOK_DEPRECATED_ID = 290,       /* TOK_DEPRECATED_ID  */
    TOK_DIV_EQ = 291,              /* TOK_DIV_EQ  */
    TOK_DO = 292,                  /* TOK_DO  */
    TOK_DOT_DOT = 293,             /* TOK_DOT_DOT  */
    TOK_DOT_DOT_DOT = 294,         /* TOK_DOT_DOT_DOT  */
    TOK_ELSE = 295,                /* TOK_ELSE  */
    TOK_ENUM = 296,                /* TOK_ENUM  */
    TOK_EXTERN = 297,              /* TOK_EXTERN  */
    TOK_FLOAT_ID = 298,            /* TOK_FLOAT_ID  */
    TOK_FOR = 299,                 /* TOK_FOR  */
    TOK_FUNCTION_ID = 300,         /* TOK_FUNCTION_ID  */
    TOK_GAUGE = 301,               /* TOK_GAUGE  */
    TOK_GLOBAL = 302,              /* TOK_GLOBAL  */
    TOK_IDENTIFIER = 303,          /* TOK_IDENTIFIER  */
    TOK_RESERVED = 304,            /* TOK_RESERVED  */
    TOK_IF = 305,                  /* TOK_IF  */
    TOK_IMPORT = 306,              /* TOK_IMPORT  */
    TOK_INHERIT = 307,             /* TOK_INHERIT  */
    TOK_INLINE = 308,              /* TOK_INLINE  */
    TOK_LOCAL_ID = 309,            /* TOK_LOCAL_ID  */
    TOK_FINAL_ID = 310,            /* TOK_FINAL_ID  */
    TOK_FUNCTION_NAME = 311,       /* TOK_FUNCTION_NAME  */
    TOK_INT_ID = 312,              /* TOK_INT_ID  */
    TOK_LAMBDA = 313,              /* TOK_LAMBDA  */
    TOK_MULTISET_ID = 314,         /* TOK_MULTISET_ID  */
    TOK_MULTISET_END = 315,        /* TOK_MULTISET_END  */
    TOK_MULTISET_START = 316,      /* TOK_MULTISET_START  */
    TOK_LSH_EQ = 317,              /* TOK_LSH_EQ  */
    TOK_MAPPING_ID = 318,          /* TOK_MAPPING_ID  */
    TOK_MIXED_ID = 319,            /* TOK_MIXED_ID  */
    TOK_MOD_EQ = 320,              /* TOK_MOD_EQ  */
    TOK_MULT_EQ = 321,             /* TOK_MULT_EQ  */
    TOK_NO_MASK = 322,             /* TOK_NO_MASK  */
    TOK_OBJECT_ID = 323,           /* TOK_OBJECT_ID  */
    TOK_OR_EQ = 324,               /* TOK_OR_EQ  */
    TOK_PRIVATE = 325,             /* TOK_PRIVATE  */
    TOK_PROGRAM_ID = 326,          /* TOK_PROGRAM_ID  */
    TOK_PROTECTED = 327,           /* TOK_PROTECTED  */
    TOK_PREDEF = 328,              /* TOK_PREDEF  */
    TOK_PUBLIC = 329,              /* TOK_PUBLIC  */
    TOK_RSH_EQ = 330,              /* TOK_RSH_EQ  */
    TOK_STATIC = 331,              /* TOK_STATIC  */
    TOK_STRING_ID = 332,           /* TOK_STRING_ID  */
    TOK_SUB_EQ = 333,              /* TOK_SUB_EQ  */
    TOK_TYPEDEF = 334,             /* TOK_TYPEDEF  */
    TOK_TYPEOF = 335,              /* TOK_TYPEOF  */
    TOK_VARIANT = 336,             /* TOK_VARIANT  */
    TOK_VERSION = 337,             /* TOK_VERSION  */
    TOK_VOID_ID = 338,             /* TOK_VOID_ID  */
    TOK_WHILE = 339,               /* TOK_WHILE  */
    TOK_XOR_EQ = 340,              /* TOK_XOR_EQ  */
    TOK_OPTIONAL = 341,            /* TOK_OPTIONAL  */
    TOK_SAFE_INDEX = 342,          /* TOK_SAFE_INDEX  */
    TOK_SAFE_START_INDEX = 343,    /* TOK_SAFE_START_INDEX  */
    TOK_BITS = 344                 /* TOK_BITS  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define TOK_ARROW 258
#define TOK_CONSTANT 259
#define TOK_FLOAT 260
#define TOK_STRING 261
#define TOK_NUMBER 262
#define TOK_INC 263
#define TOK_DEC 264
#define TOK_RETURN 265
#define TOK_EQ 266
#define TOK_GE 267
#define TOK_LE 268
#define TOK_NE 269
#define TOK_NOT 270
#define TOK_LSH 271
#define TOK_RSH 272
#define TOK_LAND 273
#define TOK_LOR 274
#define TOK_SWITCH 275
#define TOK_SSCANF 276
#define TOK_CATCH 277
#define TOK_FOREACH 278
#define TOK_LEX_EOF 279
#define TOK_ADD_EQ 280
#define TOK_AND_EQ 281
#define TOK_ARRAY_ID 282
#define TOK_ATTRIBUTE_ID 283
#define TOK_BREAK 284
#define TOK_CASE 285
#define TOK_CLASS 286
#define TOK_COLON_COLON 287
#define TOK_CONTINUE 288
#define TOK_DEFAULT 289
#define TOK_DEPRECATED_ID 290
#define TOK_DIV_EQ 291
#define TOK_DO 292
#define TOK_DOT_DOT 293
#define TOK_DOT_DOT_DOT 294
#define TOK_ELSE 295
#define TOK_ENUM 296
#define TOK_EXTERN 297
#define TOK_FLOAT_ID 298
#define TOK_FOR 299
#define TOK_FUNCTION_ID 300
#define TOK_GAUGE 301
#define TOK_GLOBAL 302
#define TOK_IDENTIFIER 303
#define TOK_RESERVED 304
#define TOK_IF 305
#define TOK_IMPORT 306
#define TOK_INHERIT 307
#define TOK_INLINE 308
#define TOK_LOCAL_ID 309
#define TOK_FINAL_ID 310
#define TOK_FUNCTION_NAME 311
#define TOK_INT_ID 312
#define TOK_LAMBDA 313
#define TOK_MULTISET_ID 314
#define TOK_MULTISET_END 315
#define TOK_MULTISET_START 316
#define TOK_LSH_EQ 317
#define TOK_MAPPING_ID 318
#define TOK_MIXED_ID 319
#define TOK_MOD_EQ 320
#define TOK_MULT_EQ 321
#define TOK_NO_MASK 322
#define TOK_OBJECT_ID 323
#define TOK_OR_EQ 324
#define TOK_PRIVATE 325
#define TOK_PROGRAM_ID 326
#define TOK_PROTECTED 327
#define TOK_PREDEF 328
#define TOK_PUBLIC 329
#define TOK_RSH_EQ 330
#define TOK_STATIC 331
#define TOK_STRING_ID 332
#define TOK_SUB_EQ 333
#define TOK_TYPEDEF 334
#define TOK_TYPEOF 335
#define TOK_VARIANT 336
#define TOK_VERSION 337
#define TOK_VOID_ID 338
#define TOK_WHILE 339
#define TOK_XOR_EQ 340
#define TOK_OPTIONAL 341
#define TOK_SAFE_INDEX 342
#define TOK_SAFE_START_INDEX 343
#define TOK_BITS 344

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 188 "language.yacc"

  int number;
  FLOAT_TYPE fnum;
  struct node_s *n;
  char *str;
  void *ptr;

#line 377 "y.tab.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif




int yyparse (void);


#endif /* !YY_YY_Y_TAB_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_TOK_ARROW = 3,                  /* TOK_ARROW  */
  YYSYMBOL_TOK_CONSTANT = 4,               /* TOK_CONSTANT  */
  YYSYMBOL_TOK_FLOAT = 5,                  /* TOK_FLOAT  */
  YYSYMBOL_TOK_STRING = 6,                 /* TOK_STRING  */
  YYSYMBOL_TOK_NUMBER = 7,                 /* TOK_NUMBER  */
  YYSYMBOL_TOK_INC = 8,                    /* TOK_INC  */
  YYSYMBOL_TOK_DEC = 9,                    /* TOK_DEC  */
  YYSYMBOL_TOK_RETURN = 10,                /* TOK_RETURN  */
  YYSYMBOL_TOK_EQ = 11,                    /* TOK_EQ  */
  YYSYMBOL_TOK_GE = 12,                    /* TOK_GE  */
  YYSYMBOL_TOK_LE = 13,                    /* TOK_LE  */
  YYSYMBOL_TOK_NE = 14,                    /* TOK_NE  */
  YYSYMBOL_TOK_NOT = 15,                   /* TOK_NOT  */
  YYSYMBOL_TOK_LSH = 16,                   /* TOK_LSH  */
  YYSYMBOL_TOK_RSH = 17,                   /* TOK_RSH  */
  YYSYMBOL_TOK_LAND = 18,                  /* TOK_LAND  */
  YYSYMBOL_TOK_LOR = 19,                   /* TOK_LOR  */
  YYSYMBOL_TOK_SWITCH = 20,                /* TOK_SWITCH  */
  YYSYMBOL_TOK_SSCANF = 21,                /* TOK_SSCANF  */
  YYSYMBOL_TOK_CATCH = 22,                 /* TOK_CATCH  */
  YYSYMBOL_TOK_FOREACH = 23,               /* TOK_FOREACH  */
  YYSYMBOL_TOK_LEX_EOF = 24,               /* TOK_LEX_EOF  */
  YYSYMBOL_TOK_ADD_EQ = 25,                /* TOK_ADD_EQ  */
  YYSYMBOL_TOK_AND_EQ = 26,                /* TOK_AND_EQ  */
  YYSYMBOL_TOK_ARRAY_ID = 27,              /* TOK_ARRAY_ID  */
  YYSYMBOL_TOK_ATTRIBUTE_ID = 28,          /* TOK_ATTRIBUTE_ID  */
  YYSYMBOL_TOK_BREAK = 29,                 /* TOK_BREAK  */
  YYSYMBOL_TOK_CASE = 30,                  /* TOK_CASE  */
  YYSYMBOL_TOK_CLASS = 31,                 /* TOK_CLASS  */
  YYSYMBOL_TOK_COLON_COLON = 32,           /* TOK_COLON_COLON  */
  YYSYMBOL_TOK_CONTINUE = 33,              /* TOK_CONTINUE  */
  YYSYMBOL_TOK_DEFAULT = 34,               /* TOK_DEFAULT  */
  YYSYMBOL_TOK_DEPRECATED_ID = 35,         /* TOK_DEPRECATED_ID  */
  YYSYMBOL_TOK_DIV_EQ = 36,                /* TOK_DIV_EQ  */
  YYSYMBOL_TOK_DO = 37,                    /* TOK_DO  */
  YYSYMBOL_TOK_DOT_DOT = 38,               /* TOK_DOT_DOT  */
  YYSYMBOL_TOK_DOT_DOT_DOT = 39,           /* TOK_DOT_DOT_DOT  */
  YYSYMBOL_TOK_ELSE = 40,                  /* TOK_ELSE  */
  YYSYMBOL_TOK_ENUM = 41,                  /* TOK_ENUM  */
  YYSYMBOL_TOK_EXTERN = 42,                /* TOK_EXTERN  */
  YYSYMBOL_TOK_FLOAT_ID = 43,              /* TOK_FLOAT_ID  */
  YYSYMBOL_TOK_FOR = 44,                   /* TOK_FOR  */
  YYSYMBOL_TOK_FUNCTION_ID = 45,           /* TOK_FUNCTION_ID  */
  YYSYMBOL_TOK_GAUGE = 46,                 /* TOK_GAUGE  */
  YYSYMBOL_TOK_GLOBAL = 47,                /* TOK_GLOBAL  */
  YYSYMBOL_TOK_IDENTIFIER = 48,            /* TOK_IDENTIFIER  */
  YYSYMBOL_TOK_RESERVED = 49,              /* TOK_RESERVED  */
  YYSYMBOL_TOK_IF = 50,                    /* TOK_IF  */
  YYSYMBOL_TOK_IMPORT = 51,                /* TOK_IMPORT  */
  YYSYMBOL_TOK_INHERIT = 52,               /* TOK_INHERIT  */
  YYSYMBOL_TOK_INLINE = 53,                /* TOK_INLINE  */
  YYSYMBOL_TOK_LOCAL_ID = 54,              /* TOK_LOCAL_ID  */
  YYSYMBOL_TOK_FINAL_ID = 55,              /* TOK_FINAL_ID  */
  YYSYMBOL_TOK_FUNCTION_NAME = 56,         /* TOK_FUNCTION_NAME  */
  YYSYMBOL_TOK_INT_ID = 57,                /* TOK_INT_ID  */
  YYSYMBOL_TOK_LAMBDA = 58,                /* TOK_LAMBDA  */
  YYSYMBOL_TOK_MULTISET_ID = 59,           /* TOK_MULTISET_ID  */
  YYSYMBOL_TOK_MULTISET_END = 60,          /* TOK_MULTISET_END  */
  YYSYMBOL_TOK_MULTISET_START = 61,        /* TOK_MULTISET_START  */
  YYSYMBOL_TOK_LSH_EQ = 62,                /* TOK_LSH_EQ  */
  YYSYMBOL_TOK_MAPPING_ID = 63,            /* TOK_MAPPING_ID  */
  YYSYMBOL_TOK_MIXED_ID = 64,              /* TOK_MIXED_ID  */
  YYSYMBOL_TOK_MOD_EQ = 65,                /* TOK_MOD_EQ  */
  YYSYMBOL_TOK_MULT_EQ = 66,               /* TOK_MULT_EQ  */
  YYSYMBOL_TOK_NO_MASK = 67,               /* TOK_NO_MASK  */
  YYSYMBOL_TOK_OBJECT_ID = 68,             /* TOK_OBJECT_ID  */
  YYSYMBOL_TOK_OR_EQ = 69,                 /* TOK_OR_EQ  */
  YYSYMBOL_TOK_PRIVATE = 70,               /* TOK_PRIVATE  */
  YYSYMBOL_TOK_PROGRAM_ID = 71,            /* TOK_PROGRAM_ID  */
  YYSYMBOL_TOK_PROTECTED = 72,             /* TOK_PROTECTED  */
  YYSYMBOL_TOK_PREDEF = 73,                /* TOK_PREDEF  */
  YYSYMBOL_TOK_PUBLIC = 74,                /* TOK_PUBLIC  */
  YYSYMBOL_TOK_RSH_EQ = 75,                /* TOK_RSH_EQ  */
  YYSYMBOL_TOK_STATIC = 76,                /* TOK_STATIC  */
  YYSYMBOL_TOK_STRING_ID = 77,             /* TOK_STRING_ID  */
  YYSYMBOL_TOK_SUB_EQ = 78,                /* TOK_SUB_EQ  */
  YYSYMBOL_TOK_TYPEDEF = 79,               /* TOK_TYPEDEF  */
  YYSYMBOL_TOK_TYPEOF = 80,                /* TOK_TYPEOF  */
  YYSYMBOL_TOK_VARIANT = 81,               /* TOK_VARIANT  */
  YYSYMBOL_TOK_VERSION = 82,               /* TOK_VERSION  */
  YYSYMBOL_TOK_VOID_ID = 83,               /* TOK_VOID_ID  */
  YYSYMBOL_TOK_WHILE = 84,                 /* TOK_WHILE  */
  YYSYMBOL_TOK_XOR_EQ = 85,                /* TOK_XOR_EQ  */
  YYSYMBOL_TOK_OPTIONAL = 86,              /* TOK_OPTIONAL  */
  YYSYMBOL_TOK_SAFE_INDEX = 87,            /* TOK_SAFE_INDEX  */
  YYSYMBOL_TOK_SAFE_START_INDEX = 88,      /* TOK_SAFE_START_INDEX  */
  YYSYMBOL_TOK_BITS = 89,                  /* TOK_BITS  */
  YYSYMBOL_90_ = 90,                       /* '='  */
  YYSYMBOL_91_ = 91,                       /* '?'  */
  YYSYMBOL_92_ = 92,                       /* '|'  */
  YYSYMBOL_93_ = 93,                       /* '^'  */
  YYSYMBOL_94_ = 94,                       /* '&'  */
  YYSYMBOL_95_ = 95,                       /* '>'  */
  YYSYMBOL_96_ = 96,                       /* '<'  */
  YYSYMBOL_97_ = 97,                       /* '+'  */
  YYSYMBOL_98_ = 98,                       /* '-'  */
  YYSYMBOL_99_ = 99,                       /* '*'  */
  YYSYMBOL_100_ = 100,                     /* '%'  */
  YYSYMBOL_101_ = 101,                     /* '/'  */
  YYSYMBOL_102_ = 102,                     /* '~'  */
  YYSYMBOL_103_ = 103,                     /* ';'  */
  YYSYMBOL_104_ = 104,                     /* ':'  */
  YYSYMBOL_105_ = 105,                     /* '}'  */
  YYSYMBOL_106_ = 106,                     /* ','  */
  YYSYMBOL_107_ = 107,                     /* '('  */
  YYSYMBOL_108_ = 108,                     /* ')'  */
  YYSYMBOL_109_ = 109,                     /* '['  */
  YYSYMBOL_110_ = 110,                     /* ']'  */
  YYSYMBOL_111_ = 111,                     /* '{'  */
  YYSYMBOL_112_ = 112,                     /* '@'  */
  YYSYMBOL_113_ = 113,                     /* '.'  */
  YYSYMBOL_YYACCEPT = 114,                 /* $accept  */
  YYSYMBOL_all = 115,                      /* all  */
  YYSYMBOL_program = 116,                  /* program  */
  YYSYMBOL_real_string_or_identifier = 117, /* real_string_or_identifier  */
  YYSYMBOL_optional_rename_inherit = 118,  /* optional_rename_inherit  */
  YYSYMBOL_low_program_ref = 119,          /* low_program_ref  */
  YYSYMBOL_program_ref = 120,              /* program_ref  */
  YYSYMBOL_inherit_ref = 121,              /* inherit_ref  */
  YYSYMBOL_122_1 = 122,                    /* @1  */
  YYSYMBOL_inheritance = 123,              /* inheritance  */
  YYSYMBOL_import = 124,                   /* import  */
  YYSYMBOL_constant_name = 125,            /* constant_name  */
  YYSYMBOL_constant_list = 126,            /* constant_list  */
  YYSYMBOL_constant = 127,                 /* constant  */
  YYSYMBOL_block_or_semi = 128,            /* block_or_semi  */
  YYSYMBOL_type_or_error = 129,            /* type_or_error  */
  YYSYMBOL_open_paren_with_line_info = 130, /* open_paren_with_line_info  */
  YYSYMBOL_close_paren_or_missing = 131,   /* close_paren_or_missing  */
  YYSYMBOL_close_brace_or_missing = 132,   /* close_brace_or_missing  */
  YYSYMBOL_close_brace_or_eof = 133,       /* close_brace_or_eof  */
  YYSYMBOL_open_bracket_with_line_info = 134, /* open_bracket_with_line_info  */
  YYSYMBOL_close_bracket_or_missing = 135, /* close_bracket_or_missing  */
  YYSYMBOL_push_compiler_frame0 = 136,     /* push_compiler_frame0  */
  YYSYMBOL_optional_constant = 137,        /* optional_constant  */
  YYSYMBOL_def = 138,                      /* def  */
  YYSYMBOL_139_2 = 139,                    /* @2  */
  YYSYMBOL_140_3 = 140,                    /* @3  */
  YYSYMBOL_141_4 = 141,                    /* $@4  */
  YYSYMBOL_142_5 = 142,                    /* @5  */
  YYSYMBOL_optional_dot_dot_dot = 143,     /* optional_dot_dot_dot  */
  YYSYMBOL_optional_identifier = 144,      /* optional_identifier  */
  YYSYMBOL_new_arg_name = 145,             /* new_arg_name  */
  YYSYMBOL_func_args = 146,                /* func_args  */
  YYSYMBOL_arguments = 147,                /* arguments  */
  YYSYMBOL_arguments2 = 148,               /* arguments2  */
  YYSYMBOL_modifier = 149,                 /* modifier  */
  YYSYMBOL_magic_identifiers1 = 150,       /* magic_identifiers1  */
  YYSYMBOL_magic_identifiers2 = 151,       /* magic_identifiers2  */
  YYSYMBOL_magic_identifiers3 = 152,       /* magic_identifiers3  */
  YYSYMBOL_magic_identifiers = 153,        /* magic_identifiers  */
  YYSYMBOL_magic_identifier = 154,         /* magic_identifier  */
  YYSYMBOL_modifiers = 155,                /* modifiers  */
  YYSYMBOL_modifier_list = 156,            /* modifier_list  */
  YYSYMBOL_attribute = 157,                /* attribute  */
  YYSYMBOL_optional_attributes = 158,      /* optional_attributes  */
  YYSYMBOL_optional_stars = 159,           /* optional_stars  */
  YYSYMBOL_cast = 160,                     /* cast  */
  YYSYMBOL_soft_cast = 161,                /* soft_cast  */
  YYSYMBOL_type2 = 162,                    /* type2  */
  YYSYMBOL_simple_type = 163,              /* simple_type  */
  YYSYMBOL_simple_type2 = 164,             /* simple_type2  */
  YYSYMBOL_simple_identifier_type = 165,   /* simple_identifier_type  */
  YYSYMBOL_full_type = 166,                /* full_type  */
  YYSYMBOL_type = 167,                     /* type  */
  YYSYMBOL_type3 = 168,                    /* type3  */
  YYSYMBOL_basic_type = 169,               /* basic_type  */
  YYSYMBOL_identifier_type = 170,          /* identifier_type  */
  YYSYMBOL_number_or_maxint = 171,         /* number_or_maxint  */
  YYSYMBOL_number_or_minint = 172,         /* number_or_minint  */
  YYSYMBOL_expected_dot_dot = 173,         /* expected_dot_dot  */
  YYSYMBOL_opt_int_range = 174,            /* opt_int_range  */
  YYSYMBOL_opt_string_width = 175,         /* opt_string_width  */
  YYSYMBOL_opt_object_type = 176,          /* opt_object_type  */
  YYSYMBOL_177_6 = 177,                    /* @6  */
  YYSYMBOL_opt_program_type = 178,         /* opt_program_type  */
  YYSYMBOL_opt_function_type = 179,        /* opt_function_type  */
  YYSYMBOL_180_7 = 180,                    /* $@7  */
  YYSYMBOL_181_8 = 181,                    /* $@8  */
  YYSYMBOL_function_type_list = 182,       /* function_type_list  */
  YYSYMBOL_function_type_list2 = 183,      /* function_type_list2  */
  YYSYMBOL_184_9 = 184,                    /* $@9  */
  YYSYMBOL_opt_array_type = 185,           /* opt_array_type  */
  YYSYMBOL_opt_mapping_type = 186,         /* opt_mapping_type  */
  YYSYMBOL_187_10 = 187,                   /* $@10  */
  YYSYMBOL_188_11 = 188,                   /* $@11  */
  YYSYMBOL_189_12 = 189,                   /* $@12  */
  YYSYMBOL_name_list = 190,                /* name_list  */
  YYSYMBOL_new_name = 191,                 /* new_name  */
  YYSYMBOL_192_13 = 192,                   /* @13  */
  YYSYMBOL_new_local_name = 193,           /* new_local_name  */
  YYSYMBOL_new_local_name2 = 194,          /* new_local_name2  */
  YYSYMBOL_line_number_info = 195,         /* line_number_info  */
  YYSYMBOL_block = 196,                    /* block  */
  YYSYMBOL_197_14 = 197,                   /* @14  */
  YYSYMBOL_198_15 = 198,                   /* @15  */
  YYSYMBOL_199_16 = 199,                   /* @16  */
  YYSYMBOL_end_block = 200,                /* end_block  */
  YYSYMBOL_failsafe_block = 201,           /* failsafe_block  */
  YYSYMBOL_propagated_type = 202,          /* propagated_type  */
  YYSYMBOL_local_name_list = 203,          /* local_name_list  */
  YYSYMBOL_local_name_list2 = 204,         /* local_name_list2  */
  YYSYMBOL_local_constant_name = 205,      /* local_constant_name  */
  YYSYMBOL_local_constant_list = 206,      /* local_constant_list  */
  YYSYMBOL_local_constant = 207,           /* local_constant  */
  YYSYMBOL_statements = 208,               /* statements  */
  YYSYMBOL_statement_with_semicolon = 209, /* statement_with_semicolon  */
  YYSYMBOL_normal_label_statement = 210,   /* normal_label_statement  */
  YYSYMBOL_statement = 211,                /* statement  */
  YYSYMBOL_labeled_statement = 212,        /* labeled_statement  */
  YYSYMBOL_213_17 = 213,                   /* $@17  */
  YYSYMBOL_optional_label = 214,           /* optional_label  */
  YYSYMBOL_break = 215,                    /* break  */
  YYSYMBOL_default = 216,                  /* default  */
  YYSYMBOL_continue = 217,                 /* continue  */
  YYSYMBOL_push_compiler_frame1 = 218,     /* push_compiler_frame1  */
  YYSYMBOL_implicit_identifier = 219,      /* implicit_identifier  */
  YYSYMBOL_lambda = 220,                   /* lambda  */
  YYSYMBOL_221_18 = 221,                   /* $@18  */
  YYSYMBOL_222_19 = 222,                   /* @19  */
  YYSYMBOL_local_function = 223,           /* local_function  */
  YYSYMBOL_224_20 = 224,                   /* @20  */
  YYSYMBOL_local_function2 = 225,          /* local_function2  */
  YYSYMBOL_226_21 = 226,                   /* @21  */
  YYSYMBOL_create_arg = 227,               /* create_arg  */
  YYSYMBOL_create_arguments2 = 228,        /* create_arguments2  */
  YYSYMBOL_create_arguments = 229,         /* create_arguments  */
  YYSYMBOL_optional_create_arguments = 230, /* optional_create_arguments  */
  YYSYMBOL_failsafe_program = 231,         /* failsafe_program  */
  YYSYMBOL_232_22 = 232,                   /* @22  */
  YYSYMBOL_class = 233,                    /* class  */
  YYSYMBOL_234_23 = 234,                   /* @23  */
  YYSYMBOL_235_24 = 235,                   /* @24  */
  YYSYMBOL_simple_identifier = 236,        /* simple_identifier  */
  YYSYMBOL_enum_value = 237,               /* enum_value  */
  YYSYMBOL_enum_def = 238,                 /* enum_def  */
  YYSYMBOL_propagated_enum_value = 239,    /* propagated_enum_value  */
  YYSYMBOL_enum_list = 240,                /* enum_list  */
  YYSYMBOL_enum = 241,                     /* enum  */
  YYSYMBOL_242_25 = 242,                   /* $@25  */
  YYSYMBOL_243_26 = 243,                   /* @26  */
  YYSYMBOL_244_27 = 244,                   /* @27  */
  YYSYMBOL_typedef = 245,                  /* typedef  */
  YYSYMBOL_cond = 246,                     /* cond  */
  YYSYMBOL_247_28 = 247,                   /* @28  */
  YYSYMBOL_248_29 = 248,                   /* @29  */
  YYSYMBOL_end_cond = 249,                 /* end_cond  */
  YYSYMBOL_optional_else_part = 250,       /* optional_else_part  */
  YYSYMBOL_safe_lvalue = 251,              /* safe_lvalue  */
  YYSYMBOL_safe_expr0 = 252,               /* safe_expr0  */
  YYSYMBOL_foreach_optional_lvalue = 253,  /* foreach_optional_lvalue  */
  YYSYMBOL_foreach_lvalues = 254,          /* foreach_lvalues  */
  YYSYMBOL_foreach = 255,                  /* foreach  */
  YYSYMBOL_256_30 = 256,                   /* @30  */
  YYSYMBOL_257_31 = 257,                   /* @31  */
  YYSYMBOL_do = 258,                       /* do  */
  YYSYMBOL_expected_semicolon = 259,       /* expected_semicolon  */
  YYSYMBOL_for = 260,                      /* for  */
  YYSYMBOL_261_32 = 261,                   /* @32  */
  YYSYMBOL_262_33 = 262,                   /* @33  */
  YYSYMBOL_while = 263,                    /* while  */
  YYSYMBOL_264_34 = 264,                   /* @34  */
  YYSYMBOL_265_35 = 265,                   /* @35  */
  YYSYMBOL_for_expr = 266,                 /* for_expr  */
  YYSYMBOL_switch = 267,                   /* switch  */
  YYSYMBOL_268_36 = 268,                   /* @36  */
  YYSYMBOL_269_37 = 269,                   /* @37  */
  YYSYMBOL_case = 270,                     /* case  */
  YYSYMBOL_expected_colon = 271,           /* expected_colon  */
  YYSYMBOL_return = 272,                   /* return  */
  YYSYMBOL_unused = 273,                   /* unused  */
  YYSYMBOL_unused2 = 274,                  /* unused2  */
  YYSYMBOL_optional_comma_expr = 275,      /* optional_comma_expr  */
  YYSYMBOL_safe_comma_expr = 276,          /* safe_comma_expr  */
  YYSYMBOL_comma_expr = 277,               /* comma_expr  */
  YYSYMBOL_comma_expr2 = 278,              /* comma_expr2  */
  YYSYMBOL_expr00 = 279,                   /* expr00  */
  YYSYMBOL_expr0 = 280,                    /* expr0  */
  YYSYMBOL_expr01 = 281,                   /* expr01  */
  YYSYMBOL_assign = 282,                   /* assign  */
  YYSYMBOL_optional_comma = 283,           /* optional_comma  */
  YYSYMBOL_expr_list = 284,                /* expr_list  */
  YYSYMBOL_expr_list2 = 285,               /* expr_list2  */
  YYSYMBOL_m_expr_list = 286,              /* m_expr_list  */
  YYSYMBOL_m_expr_list2 = 287,             /* m_expr_list2  */
  YYSYMBOL_assoc_pair = 288,               /* assoc_pair  */
  YYSYMBOL_expr1 = 289,                    /* expr1  */
  YYSYMBOL_expr2 = 290,                    /* expr2  */
  YYSYMBOL_expr3 = 291,                    /* expr3  */
  YYSYMBOL_optional_block = 292,           /* optional_block  */
  YYSYMBOL_293_38 = 293,                   /* @38  */
  YYSYMBOL_apply = 294,                    /* apply  */
  YYSYMBOL_implicit_modifiers = 295,       /* implicit_modifiers  */
  YYSYMBOL_expr4 = 296,                    /* expr4  */
  YYSYMBOL_idents2 = 297,                  /* idents2  */
  YYSYMBOL_idents = 298,                   /* idents  */
  YYSYMBOL_string_or_identifier = 299,     /* string_or_identifier  */
  YYSYMBOL_inherit_specifier = 300,        /* inherit_specifier  */
  YYSYMBOL_low_idents = 301,               /* low_idents  */
  YYSYMBOL_range_bound = 302,              /* range_bound  */
  YYSYMBOL_gauge = 303,                    /* gauge  */
  YYSYMBOL_typeof = 304,                   /* typeof  */
  YYSYMBOL_catch_arg = 305,                /* catch_arg  */
  YYSYMBOL_catch = 306,                    /* catch  */
  YYSYMBOL_307_39 = 307,                   /* $@39  */
  YYSYMBOL_sscanf = 308,                   /* sscanf  */
  YYSYMBOL_lvalue = 309,                   /* lvalue  */
  YYSYMBOL_low_lvalue_list = 310,          /* low_lvalue_list  */
  YYSYMBOL_lvalue_list = 311,              /* lvalue_list  */
  YYSYMBOL_string_segment = 312,           /* string_segment  */
  YYSYMBOL_string = 313,                   /* string  */
  YYSYMBOL_string_constant = 314,          /* string_constant  */
  YYSYMBOL_real_string_constant = 315,     /* real_string_constant  */
  YYSYMBOL_bad_identifier = 316,           /* bad_identifier  */
  YYSYMBOL_bad_expr_ident = 317            /* bad_expr_ident  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Second part of user prologue.  */
#line 196 "language.yacc"

/* Need to be included after YYSTYPE is defined. */
#define INCLUDED_FROM_LANGUAGE_YACC
#include "lex.h"
#include "pike_compiler.h"
#line 203 "language.yacc"

/* Include <stdio.h> our selves, so that we can do our magic
 * without being disturbed... */
#include <stdio.h>
int yylex(YYSTYPE *yylval);
/* Bison is stupid, and tries to optimize for space... */
#ifdef YYBISON
#define short int
#endif /* YYBISON */


#line 737 "y.tab.c"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   8606

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  114
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  204
/* YYNRULES -- Number of rules.  */
#define YYNRULES  664
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  992

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   344


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   100,    94,     2,
     107,   108,    99,    97,   106,    98,   113,   101,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   104,   103,
      96,    90,    95,    91,   112,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   109,     2,   110,    93,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   111,    92,   105,   102,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   385,   385,   386,   390,   391,   392,   395,   396,   399,
     400,   401,   402,   408,   433,   450,   462,   462,   472,   487,
     493,   500,   506,   507,   512,   515,   522,   530,   531,   536,
     539,   612,   613,   616,   617,   620,   621,   622,   627,   630,
     635,   636,   637,   641,   654,   661,   667,   674,   676,   681,
     682,   688,   695,   697,   703,   722,   725,   734,   774,   731,
     962,   978,   977,   985,   986,   987,   988,   989,   990,   991,
     992,   998,  1004,  1012,  1010,  1023,  1024,  1029,  1032,  1033,
    1034,  1037,  1067,  1074,  1075,  1078,  1079,  1080,  1088,  1095,
    1096,  1102,  1103,  1104,  1105,  1106,  1107,  1108,  1109,  1113,
    1114,  1115,  1116,  1117,  1118,  1119,  1120,  1121,  1122,  1123,
    1127,  1128,  1129,  1130,  1131,  1132,  1133,  1134,  1135,  1136,
    1137,  1138,  1139,  1140,  1141,  1142,  1146,  1147,  1148,  1149,
    1150,  1151,  1152,  1153,  1154,  1155,  1156,  1157,  1158,  1159,
    1160,  1161,  1162,  1163,  1164,  1165,  1166,  1167,  1168,  1171,
    1171,  1171,  1173,  1173,  1174,  1182,  1189,  1190,  1193,  1197,
    1203,  1212,  1221,  1230,  1233,  1243,  1253,  1253,  1255,  1268,
    1281,  1294,  1295,  1298,  1299,  1302,  1302,  1305,  1306,  1307,
    1308,  1309,  1310,  1311,  1312,  1313,  1314,  1315,  1316,  1321,
    1327,  1331,  1337,  1346,  1445,  1448,  1449,  1462,  1465,  1466,
    1478,  1479,  1486,  1489,  1494,  1529,  1536,  1542,  1543,  1543,
    1577,  1578,  1579,  1587,  1591,  1586,  1618,  1631,  1632,  1635,
    1637,  1636,  1642,  1643,  1647,  1650,  1653,  1646,  1658,  1666,
    1667,  1670,  1686,  1688,  1687,  1743,  1747,  1752,  1759,  1771,
    1772,  1787,  1792,  1798,  1807,  1819,  1820,  1835,  1839,  1846,
    1851,  1860,  1845,  1887,  1888,  1899,  1900,  1901,  1906,  1912,
    1913,  1918,  1919,  1924,  1962,  1963,  1966,  1967,  1970,  1971,
    1972,  1977,  1981,  1982,  1988,  1990,  1991,  1992,  1993,  1994,
    1995,  1996,  1997,  1998,  1999,  2006,  2013,  2016,  2020,  2021,
    2022,  2023,  2024,  2025,  2026,  2027,  2031,  2030,  2047,  2048,
    2051,  2052,  2053,  2059,  2062,  2070,  2078,  2086,  2077,  2222,
    2241,  2240,  2368,  2384,  2383,  2514,  2530,  2572,  2573,  2579,
    2580,  2581,  2588,  2589,  2592,  2593,  2603,  2603,  2604,  2605,
    2613,  2690,  2612,  2868,  2869,  2872,  2873,  2877,  2878,  2944,
    2950,  2951,  2952,  2957,  2967,  2972,  2956,  2988,  3009,  3013,
    3008,  3033,  3034,  3035,  3042,  3043,  3046,  3057,  3060,  3061,
    3062,  3066,  3067,  3070,  3071,  3076,  3080,  3075,  3103,  3111,
    3118,  3127,  3128,  3136,  3140,  3135,  3160,  3164,  3159,  3180,
    3181,  3185,  3189,  3184,  3204,  3208,  3212,  3218,  3219,  3223,
    3227,  3234,  3245,  3251,  3252,  3255,  3257,  3258,  3261,  3262,
    3265,  3266,  3267,  3268,  3269,  3273,  3274,  3280,  3281,  3283,
    3284,  3285,  3286,  3287,  3296,  3297,  3298,  3299,  3305,  3312,
    3313,  3316,  3317,  3318,  3319,  3320,  3321,  3322,  3323,  3324,
    3325,  3328,  3328,  3330,  3331,  3335,  3336,  3339,  3340,  3343,
    3344,  3353,  3356,  3360,  3363,  3364,  3365,  3366,  3367,  3368,
    3369,  3370,  3371,  3372,  3373,  3374,  3375,  3376,  3377,  3378,
    3379,  3380,  3381,  3382,  3383,  3384,  3385,  3386,  3387,  3388,
    3389,  3390,  3391,  3392,  3393,  3394,  3395,  3396,  3397,  3398,
    3399,  3402,  3403,  3408,  3413,  3414,  3415,  3416,  3417,  3420,
    3421,  3422,  3444,  3448,  3445,  3540,  3546,  3552,  3559,  3565,
    3574,  3585,  3586,  3587,  3588,  3589,  3590,  3591,  3592,  3593,
    3594,  3595,  3596,  3597,  3603,  3609,  3616,  3646,  3678,  3684,
    3690,  3692,  3694,  3696,  3704,  3711,  3721,  3728,  3735,  3736,
    3741,  3742,  3743,  3744,  3748,  3753,  3754,  3755,  3761,  3791,
    3799,  3802,  3803,  3870,  3876,  3877,  3886,  3887,  3890,  3891,
    3900,  3977,  3985,  4015,  4018,  4044,  4060,  4067,  4075,  4091,
    4095,  4102,  4107,  4153,  4154,  4155,  4190,  4198,  4199,  4201,
    4203,  4208,  4215,  4230,  4246,  4247,  4248,  4253,  4256,  4257,
    4258,  4263,  4264,  4265,  4266,  4270,  4269,  4280,  4287,  4294,
    4302,  4309,  4316,  4322,  4329,  4335,  4341,  4342,  4347,  4348,
    4351,  4352,  4358,  4369,  4373,  4379,  4380,  4386,  4387,  4418,
    4419,  4432,  4433,  4447,  4448,  4459,  4478,  4479,  4481,  4483,
    4485,  4487,  4489,  4491,  4493,  4495,  4497,  4499,  4501,  4503,
    4505,  4507,  4509,  4511,  4513,  4523,  4525,  4527,  4529,  4531,
    4533,  4535,  4537,  4539,  4541,  4543,  4545,  4547,  4549,  4551,
    4553,  4555,  4557,  4559,  4561,  4563,  4565,  4567,  4569,  4571,
    4573,  4575,  4577,  4579,  4581
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "TOK_ARROW",
  "TOK_CONSTANT", "TOK_FLOAT", "TOK_STRING", "TOK_NUMBER", "TOK_INC",
  "TOK_DEC", "TOK_RETURN", "TOK_EQ", "TOK_GE", "TOK_LE", "TOK_NE",
  "TOK_NOT", "TOK_LSH", "TOK_RSH", "TOK_LAND", "TOK_LOR", "TOK_SWITCH",
  "TOK_SSCANF", "TOK_CATCH", "TOK_FOREACH", "TOK_LEX_EOF", "TOK_ADD_EQ",
  "TOK_AND_EQ", "TOK_ARRAY_ID", "TOK_ATTRIBUTE_ID", "TOK_BREAK",
  "TOK_CASE", "TOK_CLASS", "TOK_COLON_COLON", "TOK_CONTINUE",
  "TOK_DEFAULT", "TOK_DEPRECATED_ID", "TOK_DIV_EQ", "TOK_DO",
  "TOK_DOT_DOT", "TOK_DOT_DOT_DOT", "TOK_ELSE", "TOK_ENUM", "TOK_EXTERN",
  "TOK_FLOAT_ID", "TOK_FOR", "TOK_FUNCTION_ID", "TOK_GAUGE", "TOK_GLOBAL",
  "TOK_IDENTIFIER", "TOK_RESERVED", "TOK_IF", "TOK_IMPORT", "TOK_INHERIT",
  "TOK_INLINE", "TOK_LOCAL_ID", "TOK_FINAL_ID", "TOK_FUNCTION_NAME",
  "TOK_INT_ID", "TOK_LAMBDA", "TOK_MULTISET_ID", "TOK_MULTISET_END",
  "TOK_MULTISET_START", "TOK_LSH_EQ", "TOK_MAPPING_ID", "TOK_MIXED_ID",
  "TOK_MOD_EQ", "TOK_MULT_EQ", "TOK_NO_MASK", "TOK_OBJECT_ID", "TOK_OR_EQ",
  "TOK_PRIVATE", "TOK_PROGRAM_ID", "TOK_PROTECTED", "TOK_PREDEF",
  "TOK_PUBLIC", "TOK_RSH_EQ", "TOK_STATIC", "TOK_STRING_ID", "TOK_SUB_EQ",
  "TOK_TYPEDEF", "TOK_TYPEOF", "TOK_VARIANT", "TOK_VERSION", "TOK_VOID_ID",
  "TOK_WHILE", "TOK_XOR_EQ", "TOK_OPTIONAL", "TOK_SAFE_INDEX",
  "TOK_SAFE_START_INDEX", "TOK_BITS", "'='", "'?'", "'|'", "'^'", "'&'",
  "'>'", "'<'", "'+'", "'-'", "'*'", "'%'", "'/'", "'~'", "';'", "':'",
  "'}'", "','", "'('", "')'", "'['", "']'", "'{'", "'@'", "'.'", "$accept",
  "all", "program", "real_string_or_identifier", "optional_rename_inherit",
  "low_program_ref", "program_ref", "inherit_ref", "@1", "inheritance",
  "import", "constant_name", "constant_list", "constant", "block_or_semi",
  "type_or_error", "open_paren_with_line_info", "close_paren_or_missing",
  "close_brace_or_missing", "close_brace_or_eof",
  "open_bracket_with_line_info", "close_bracket_or_missing",
  "push_compiler_frame0", "optional_constant", "def", "@2", "@3", "$@4",
  "@5", "optional_dot_dot_dot", "optional_identifier", "new_arg_name",
  "func_args", "arguments", "arguments2", "modifier", "magic_identifiers1",
  "magic_identifiers2", "magic_identifiers3", "magic_identifiers",
  "magic_identifier", "modifiers", "modifier_list", "attribute",
  "optional_attributes", "optional_stars", "cast", "soft_cast", "type2",
  "simple_type", "simple_type2", "simple_identifier_type", "full_type",
  "type", "type3", "basic_type", "identifier_type", "number_or_maxint",
  "number_or_minint", "expected_dot_dot", "opt_int_range",
  "opt_string_width", "opt_object_type", "@6", "opt_program_type",
  "opt_function_type", "$@7", "$@8", "function_type_list",
  "function_type_list2", "$@9", "opt_array_type", "opt_mapping_type",
  "$@10", "$@11", "$@12", "name_list", "new_name", "@13", "new_local_name",
  "new_local_name2", "line_number_info", "block", "@14", "@15", "@16",
  "end_block", "failsafe_block", "propagated_type", "local_name_list",
  "local_name_list2", "local_constant_name", "local_constant_list",
  "local_constant", "statements", "statement_with_semicolon",
  "normal_label_statement", "statement", "labeled_statement", "$@17",
  "optional_label", "break", "default", "continue", "push_compiler_frame1",
  "implicit_identifier", "lambda", "$@18", "@19", "local_function", "@20",
  "local_function2", "@21", "create_arg", "create_arguments2",
  "create_arguments", "optional_create_arguments", "failsafe_program",
  "@22", "class", "@23", "@24", "simple_identifier", "enum_value",
  "enum_def", "propagated_enum_value", "enum_list", "enum", "$@25", "@26",
  "@27", "typedef", "cond", "@28", "@29", "end_cond", "optional_else_part",
  "safe_lvalue", "safe_expr0", "foreach_optional_lvalue",
  "foreach_lvalues", "foreach", "@30", "@31", "do", "expected_semicolon",
  "for", "@32", "@33", "while", "@34", "@35", "for_expr", "switch", "@36",
  "@37", "case", "expected_colon", "return", "unused", "unused2",
  "optional_comma_expr", "safe_comma_expr", "comma_expr", "comma_expr2",
  "expr00", "expr0", "expr01", "assign", "optional_comma", "expr_list",
  "expr_list2", "m_expr_list", "m_expr_list2", "assoc_pair", "expr1",
  "expr2", "expr3", "optional_block", "@38", "apply", "implicit_modifiers",
  "expr4", "idents2", "idents", "string_or_identifier",
  "inherit_specifier", "low_idents", "range_bound", "gauge", "typeof",
  "catch_arg", "catch", "$@39", "sscanf", "lvalue", "low_lvalue_list",
  "lvalue_list", "string_segment", "string", "string_constant",
  "real_string_constant", "bad_identifier", "bad_expr_ident", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-800)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-662)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    -800,    51,  1034,  -800,   237,  -800,   307,  -800,  -800,  -800,
    -800,  -800,   208,   808,  -800,  -800,  -800,  -800,   292,  -800,
    7753,   185,    42,  -800,  -800,    56,    86,   189,   265,   224,
    7277,  -800,  -800,   222,  7345,  -800,  -800,   317,  6852,  -800,
    6904,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
     252,  7821,  7889,  -800,  -800,  7413,  -800,  -800,   279,   384,
    -800,  -800,   248,   334,  -800,   299,   364,  7957,  7957,   310,
     258,   582,   361,    61,   366,  -800,   381,   399,   361,   420,
    -800,   450,   459,   399,  -800,  7685,  -800,  -800,  -800,   350,
      36,  -800,    66,   464,   568,  -800,  -800,   481,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  3117,
    -800,  -800,  3117,  -800,  7481,  3117,  -800,  -800,  -800,   465,
    -800,  -800,  -800,   386,  7209,   472,  -800,   350,   314,   480,
    6852,  -800,  -800,    36,  5558,  -800,  -800,   418,  -800,  -800,
    -800,  -800,  -800,   473,  5610,  -800,  -800,  -800,  -800,  6852,
     478,  -800,  4073,    36,  5489,  -800,  -800,  -800,  -800,  -800,
    6739,  6739,  6716,   477,    74,  -800,  5808,   553,    90,  -800,
      56,   479,  6716,  6716,  -800,  -800,  2194,  6430,  6716,  6716,
    -800,  -800,  -800,  -800,   551,  -800,  -800,  -800,   431,  5914,
    -800,   350,  -800,  -800,  -800,  -800,   314,  1107,  -800,   523,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,    32,  -800,  -800,    36,   191,    36,   244,   507,   202,
    6800,   508,  -800,   510,   612,    43,  6852,   582,   519,   275,
    -800,  -800,  -800,  -800,  -800,   110,  -800,  8025,   346,  -800,
     477,  -800,    83,   553,  -800,   479,  3226,   183,   183,  5428,
    -800,   294,  3553,    83,  -800,  2303,  -800,  -800,  -800,  8093,
    -800,  2789,  3662,  -800,  -800,   414,  6525,  6227,   335,  -800,
     169,  -800,  6430,   580,    -2,  -800,   183,  5686,   531,   543,
    -800,  -800,  -800,  4247,  4316,  4385,  4454,  4523,  4592,  4661,
    4730,  6716,  4799,  4868,  4937,  5006,  5075,  5144,  5213,  5282,
    5351,  5420,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  3771,
    -800,  2898,  1539,  3880,  6634,  6634,   547,  6970,  -800,   650,
      36,  -800,   559,  6852,  -800,  -800,  -800,   481,   347,   555,
    -800,  -800,  -800,  -800,  -800,  -800,    33,   356,  -800,   561,
    -800,  -800,  6852,   562,   285,   160,  -800,  -800,    -2,   441,
     100,  -800,   554,  -800,  8161,   583,  -800,   564,   570,  -800,
    -800,  -800,  -800,   415,  6634,  -800,  -800,   300,   571,   563,
     574,  -800,  -800,  -800,  -800,   573,  6430,   720,   576,   584,
    -800,  5794,  1107,  6852,  -800,  6634,  -800,   583,   578,  -800,
    -800,  6430,  -800,  7029,  -800,   924,  -800,   535,  -800,   535,
    -800,   924,  -800,   525,  -800,   525,  -800,  5635,  -800,  5834,
     590,  -800,  5728,  -800,  7046,  -800,   893,  -800,   535,  -800,
     535,  -800,   400,  -800,   400,  -800,  -800,  -800,  -800,  -800,
    -800,  7128,   648,  6009,  -800,  -800,   654,   615,   597,    11,
    -800,  6336,   601,  -800,   602,    43,  -800,  -800,  -800,  -800,
      69,    53,  -800,   617,  -800,   607,  -800,  -800,   336,  -800,
    -800,   611,   319,  -800,  -800,   714,   614,  -800,  -800,  -800,
    3335,    93,  6634,   618,  8229,  -800,  -800,  -800,  -800,  -800,
     663,  6634,  -800,  -800,  -800,  -800,  8297,  -800,   622,  -800,
     156,  -800,   623,  -800,   642,  -800,  -800,   106,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  6525,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,   629,   628,  -800,  -800,  -800,  -800,
    3989,  -800,   631,  3007,  -800,  -800,  -800,  -800,   531,  -800,
    6634,  6634,  6716,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,   632,    43,  -800,  -800,  -800,  -800,   635,   635,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  6118,
    6852,  -800,   355,   644,  -800,  -800,  -800,  -800,  -800,  3117,
    -800,  -800,   223,  -800,  -800,  6852,  -800,  -800,  6852,  -800,
    -800,  6634,  -800,  -800,  -800,  6800,   660,   667,  -800,  -800,
    -800,  -800,    70,   186,   670,  -800,  3117,   122,  -800,  3117,
    -800,  -800,   656,  -800,  -800,  5514,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  6118,  -800,  -800,  -800,
     659,  -800,  -800,    54,  -800,  -800,  -800,  4161,  -800,  8365,
    -800,  -800,  -800,  6852,   481,   481,  -800,  6800,  -800,   662,
     444,    18,  -800,   709,   677,  3444,   126,  6634,  -800,  -800,
    -800,  6800,  -800,  -800,  -800,  -800,  -800,   665,  -800,  -800,
     347,  -800,  -800,   223,  -800,   342,   678,   644,    17,  6852,
    6852,  -800,  7957,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  8433,  -800,   644,    63,  -800,  1430,
      63,  -800,  -800,  8501,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,    63,   674,  -800,  -800,
    -800,  -800,  -800,   421,  7549,  1211,   681,   683,   240,  1320,
     240,  5922,  7043,   686,    20,   690,  1093,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,    12,  -800,    12,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,    12,  -800,
    -800,  -800,  -800,  -800,    17,  -800,  -800,  -800,  -800,   725,
     716,  -800,   392,   717,  -800,  -800,  -800,  -800,    12,  -800,
    -800,  -800,  -800,  -800,  2412,   743,  -800,  -800,  1649,  -800,
     695,  -800,  -800,  -800,  -800,  -800,  1430,  -800,  -800,  3117,
    -800,  -800,  3117,  -800,  7617,  3117,  -800,  -800,  -800,   720,
    1758,  -800,    22,  -800,  1649,  -800,  -800,  -800,  -800,  -800,
     723,  -800,  -800,   697,   711,  -800,   720,  -800,  -800,    -4,
     713,  -800,   715,   719,  2412,  6634,  -800,  -800,  2412,  1976,
    2412,  2412,   181,   453,   181,    12,  -800,   181,   181,  -800,
    -800,  -800,  1649,  2600,  2694,   181,    12,  2085,  1649,  1649,
    -800,  -800,  -800,   724,  -800,  -800,  1649,  -800,    12,  -800,
     776,  -800,  2506,  -800,  1867,  1649,  -800,  -800,   181,  -800,
    1649,  -800
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       6,     0,     0,     1,     0,     3,     0,     5,    64,    65,
      66,     4,   161,   155,    69,    70,    71,    72,     0,   607,
       0,     0,   554,   557,   608,     0,     0,     0,     0,     0,
       0,   544,   609,   549,     0,   248,   343,     0,     0,    73,
       0,    67,    68,    91,    97,    94,    89,    88,    93,    96,
      95,    90,    98,    92,   157,    28,    27,    29,   649,   656,
     655,   652,   663,   617,   618,   658,   659,   619,   660,   661,
     620,   647,   648,   621,   645,   622,   662,   623,   653,   565,
     634,   664,   650,   651,   635,   636,   646,   624,   625,   654,
     628,   626,   627,   637,   629,   639,   630,   640,   638,   641,
     644,   631,   632,   657,   643,   633,   642,   566,   616,   551,
       0,     0,     0,   555,    25,     0,   550,   564,   562,   563,
      26,   610,     0,     0,    33,     0,     0,    80,    80,     0,
       0,     0,   223,     0,     0,   177,   216,   202,   223,   228,
     179,   207,   210,   202,   178,     0,   172,   175,   176,   193,
     549,     6,     0,   160,    55,   162,    43,   168,   556,   558,
     559,   560,   561,   547,   545,   546,   552,   553,    37,     0,
      36,    38,     0,    35,     0,     0,    78,   330,    79,     0,
      23,    22,    24,     0,     0,     0,    17,    14,   611,    13,
       0,   186,   190,     0,     0,   213,   183,     0,   181,   187,
     224,   182,   184,     0,     0,   185,   206,   180,   333,     0,
       0,   334,     0,     0,     0,    56,   163,   360,   503,   502,
     500,   500,   500,   655,   652,   359,     0,   636,   654,   248,
     638,   657,   500,   500,    44,    51,     0,   500,   500,   500,
     508,    32,   358,   409,   419,   444,   481,   512,     0,   489,
     511,   541,   505,   506,   504,   507,   501,     0,    30,     0,
      34,    31,   331,   344,    20,    19,    21,    11,   613,     7,
       9,     8,    10,    18,     0,     0,   611,     0,     0,     0,
     431,     0,   198,     0,     0,     0,     0,     0,     0,     0,
     171,   347,    50,    49,    74,     0,   159,     0,     0,   229,
       0,   585,     0,     0,   248,     0,     0,   484,   485,     0,
     486,   489,     0,     0,   584,     0,   249,   583,   572,     0,
     305,     0,     0,   488,   487,     0,   433,   437,     0,   174,
       0,   405,   500,     0,   166,   167,   600,   193,   605,     0,
     603,   482,   483,     0,     0,     0,     0,     0,     0,     0,
       0,   500,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   509,   510,   248,   490,   491,   426,   421,   430,
     424,   429,   428,   422,   425,   427,   423,   248,   248,     0,
     248,     0,     0,     0,   500,   500,   324,     0,   614,     0,
     612,   222,     0,     0,   192,   191,   432,   219,    77,   431,
     217,   205,   203,   199,   200,   201,   194,     0,    15,     0,
     212,   211,   432,     0,    54,   232,    63,   163,     0,     0,
       0,   586,     0,   163,     0,   169,   170,     0,   400,   248,
     542,   543,   304,     0,   500,   435,   407,     0,   431,     0,
       0,   529,   530,   531,   528,    48,   500,     0,    53,   431,
     439,   489,   603,     0,   164,   500,   523,   166,     0,   602,
     165,   500,   604,     0,   468,   450,   471,   453,   473,   455,
     469,   451,   474,   456,   475,   457,   464,   446,   463,   445,
       0,   465,   447,   466,   448,   467,   449,   470,   452,   472,
     454,   476,   458,   477,   459,   478,   460,   479,   461,   480,
     462,     0,     0,   500,   411,   410,     0,     0,     0,     0,
     570,   500,     0,   568,   405,     0,   415,   414,   412,   416,
     156,     0,   342,   335,   340,   345,   615,   189,     0,    76,
      75,     0,   220,   218,   195,     0,     0,   225,   209,   158,
       0,     0,   500,     0,     0,   230,   597,   599,   598,   596,
       0,   500,   580,   582,   581,   579,     0,   259,   401,   404,
     244,   261,   402,   403,   245,   578,   250,     0,   534,   532,
     535,   536,   533,   408,   526,   527,   432,   434,   576,   577,
     575,   574,   573,    47,     0,     0,   390,   388,   387,   389,
       0,    52,     0,     0,   438,   173,   406,   601,   605,   418,
     500,   500,   500,   540,   137,   144,   146,   145,   132,   131,
     112,   113,   135,   136,   134,   138,   139,   114,   127,   130,
     124,   102,   122,   128,   118,   133,   148,   152,   153,   126,
     140,   141,   107,   104,   100,   119,   123,   142,   116,   115,
     111,    99,   117,   103,   120,   106,   143,   105,   101,   121,
     125,   147,   109,   110,   129,   108,   149,   150,   151,   154,
     537,   538,   405,     0,   539,   497,   498,   499,   492,   492,
     519,   520,   521,   522,   518,   571,   569,   513,   514,   500,
       0,   319,   431,    46,   322,   328,   329,     6,   332,     0,
     338,   339,     0,   188,   214,     0,   196,   204,     0,   235,
     236,   500,    60,    57,   237,   431,   231,   232,   593,   595,
     594,   592,     0,   238,   239,   258,     0,     0,   258,     0,
     251,   309,     0,   436,   524,     0,   443,   442,   525,   441,
     440,   606,   413,   417,   420,   516,   500,   248,   496,   495,
       0,   163,   156,   156,   323,    45,   325,     0,   336,   337,
     254,   253,   346,     0,   221,   226,   234,   431,    85,     0,
     431,    77,    83,     0,     0,     0,     0,   500,   163,   246,
     312,   431,   310,   163,   247,   272,   307,     0,   304,   515,
      77,   321,   320,     0,   341,     0,     0,    46,     0,     0,
     432,    84,    80,   589,   591,   590,   588,   587,   242,   243,
     240,   315,   313,   241,     0,   260,    46,     0,   262,     0,
       0,   517,   493,   318,   327,   215,   227,    58,    42,    41,
      40,    62,    39,    87,    86,    81,     0,   238,    82,   256,
     257,   255,   311,     0,     0,     0,   656,   663,   658,     0,
     660,   302,   248,   662,   554,   664,     0,   376,   286,   276,
     280,   252,   279,   275,   287,   273,   295,     0,   294,     0,
     277,   291,   289,   290,   288,   292,   293,   278,     0,   395,
     308,   272,   316,   317,     0,   314,   284,   283,   285,     0,
       0,   266,     0,     0,   399,   372,   371,   391,     0,   398,
     248,   248,   298,   300,     0,     0,   303,   301,     0,   248,
       0,   248,   248,   281,   282,   274,     0,    59,   270,     0,
     269,   271,     0,   268,     0,     0,   392,   382,   366,     0,
       0,   384,     0,   374,     0,   349,   377,   494,   265,   263,
       0,   267,   264,     0,     0,   386,     0,   397,   370,     0,
       0,   297,     0,     0,     0,   500,   385,   369,     0,     0,
       0,     0,     0,     0,     0,     0,   394,     0,     0,   353,
     352,   351,     0,     0,     0,     0,     0,     0,     0,     0,
     383,   357,   362,     0,   356,   363,     0,   368,     0,   380,
     354,   378,     0,   367,     0,     0,   350,   364,     0,   355,
       0,   375
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -800,  -800,  -145,  -800,  -800,   544,  -800,  -800,  -800,  -800,
      14,   658,  -800,  -800,   -40,   157,   -67,  -740,  -800,  -800,
     247,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -685,
    -127,  -257,  -683,  -514,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,  -489,  -800,  -800,  -800,  -213,  -800,  -800,  -800,  -800,
    -800,  -800,   331,  -223,  -201,    21,     5,  -800,  -800,  -491,
     692,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,  -800,
    -800,   698,  -800,  -800,  -800,  -800,  -800,   422,  -800,  -688,
    -800,   -33,  -147,  -800,  -800,  -800,  -746,  -433,   120,  -800,
    -800,   -73,  -800,  -800,   -29,  -800,  -800,  -498,  -800,  -800,
       3,  -800,  -800,  -800,  -530,  -800,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -182,  -800,  -800,  -800,  -800,  -800,   603,
    -800,  -800,   700,  -800,   103,  -800,  -800,   605,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -274,  -800,  -110,  -107,  -123,
    -800,  -800,  -800,  -800,  -800,  -799,  -800,  -800,  -800,  -800,
    -800,  -800,  -800,  -800,  -800,  -800,  -800,  -483,  -800,  -129,
    -800,  -800,  -615,  -189,   -44,   284,   155,  -347,  -231,  -247,
    -276,  -800,  -800,  -800,   272,  8245,   271,  -800,   195,  -800,
    -800,  -800,  -210,  -800,    -6,  -800,  -800,  -800,  -478,  -800,
    -800,   557,  -800,  -800,  -800,  -452,  -288,  -549,    39,   228,
    -140,  -800,   -13,   -15
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,     2,   270,   185,   186,   409,   130,   131,     8,
     849,   124,   125,    10,   821,   154,   236,   746,   584,   294,
     237,   592,   541,   216,    11,   757,   874,   543,   151,   531,
     177,   758,   772,   759,   760,    54,   656,   657,   658,   659,
     660,    12,    13,   155,    40,   804,   238,   239,   333,   156,
     423,   424,   761,   425,   146,   329,   426,   536,   285,   406,
     198,   207,   202,   203,   205,   196,   280,   753,   398,   399,
     695,   191,   201,   286,   698,   786,   298,   299,   701,   557,
     561,   320,   850,   429,   720,   775,   752,   832,   768,   558,
     562,   881,   882,   852,   809,   853,   854,   855,   856,   900,
     893,   857,   858,   859,   567,   432,   240,   722,   810,   563,
     807,   559,   826,   681,   682,   683,   521,   688,   783,    41,
     262,   386,   523,   690,   524,   749,   525,    42,   128,   387,
     692,    14,   860,   901,   942,   962,   986,   972,   241,   973,
     965,   861,   891,   934,   862,   887,   863,   899,   940,   864,
     902,   943,   978,   865,   890,   933,   866,   590,   867,   955,
     868,   936,   956,   889,   428,   435,   331,   243,   383,   762,
     437,   438,   448,   449,   450,   244,   245,   246,   738,   871,
     247,   248,   249,   250,   251,    29,    30,    31,   515,   252,
     253,   318,   254,   313,   255,   338,   339,   462,    32,   256,
     189,   271,   178,   257
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      28,   179,   127,   297,   480,   108,   212,   107,   290,   598,
     307,   308,   311,   328,   334,   108,     9,   119,   818,   108,
     947,   126,   311,   311,   679,   663,   385,   336,   311,   311,
     717,   680,   149,   400,   149,   670,   885,   814,   388,   776,
     534,   819,    19,   148,   458,   148,   938,   817,   413,   731,
     445,     3,  -548,   277,   685,  -432,   529,   530,   903,   147,
     904,   147,   192,   851,   829,   258,   828,   192,   261,   905,
    -431,   763,   121,   295,  -548,  -585,   792,   686,  -432,   317,
     805,   404,   405,   802,   314,   808,   418,   830,   111,   916,
     453,  -248,    24,  -431,   702,   813,   108,   108,   160,   162,
     108,   550,   165,   948,   334,   508,   939,   721,   460,   457,
     209,   392,   108,   108,   671,   886,   672,   451,   112,   673,
     820,   674,   336,   770,  -296,   187,   427,   801,   316,   389,
     108,   535,   211,   311,   311,   311,   311,   311,   311,   311,
     311,   311,   311,   311,   311,   311,   311,   311,   311,   311,
     311,   311,   533,   306,   306,   317,   967,  -304,   585,   108,
     927,   126,  -432,   764,   687,  -432,   317,   977,   193,   108,
     306,   272,   736,   213,   316,   396,   461,  -431,  -605,   984,
    -431,  -585,   381,   766,   149,  -585,   364,  -304,   149,   121,
     315,   577,   330,   513,   316,   148,   321,  -248,   149,   148,
     703,   740,   594,   149,   544,   959,   551,   274,   149,   148,
     556,   147,    34,  -306,   148,   147,   412,   109,  -431,   148,
     888,   385,   340,   334,   895,   147,     9,   121,    19,   771,
     147,   337,   601,   771,    33,   147,   336,   113,   457,    35,
     381,   381,   335,   787,   381,   392,   716,   750,   812,    36,
     542,   336,   595,   680,   680,   734,   116,   806,   777,   183,
      37,    15,   330,  -304,  -299,   306,   150,   -61,   150,   381,
     377,   378,   168,   684,   149,   455,   765,   456,    24,   919,
     149,   187,   108,   209,   415,   148,   960,    38,   892,   961,
     234,   148,   235,  -304,   209,   121,   380,   364,   110,   391,
     158,   147,   365,   366,   108,   937,   431,   147,    18,   337,
     395,   166,   452,    19,   513,   121,    55,   340,   129,    39,
      19,   337,   676,   -16,   242,   120,   337,   242,   751,   952,
     242,   501,   335,   954,   180,   957,   958,   335,   169,    20,
      16,   274,    17,  -299,   502,   503,  -549,   506,   894,   -16,
     393,   170,   979,   171,    21,    22,    23,  -432,  -432,   188,
     574,   -12,   184,    24,   -16,   -16,   -16,   209,   114,   145,
      24,   157,   108,   -16,   211,   540,   337,   870,   115,   306,
      25,   377,   378,   411,   381,   529,   530,   149,  -231,    26,
     -16,  -231,   311,   875,   306,    56,   566,    57,   148,   -16,
     922,   234,   173,   235,   920,   174,   149,   380,   575,   108,
     264,   564,   921,   181,   147,   182,   167,   148,   150,   281,
      27,   276,   150,  -432,   172,   282,   941,   453,   209,   121,
     -16,   340,   150,   147,   209,   744,   935,   150,   441,   568,
     337,   276,   150,   454,   693,   876,   340,   149,   209,   416,
     815,   335,   417,   946,   175,   337,  -197,  -197,   148,   742,
     537,   743,    35,   115,   970,   546,   335,   420,   190,   309,
     980,   981,    36,   194,   147,   569,   436,   440,   983,   309,
     309,   436,   447,   327,   332,   309,   309,   989,   195,   265,
     513,   266,   991,   310,   601,   913,   382,   337,   914,   359,
     360,   361,   390,   323,   324,   337,   197,   283,   150,   341,
     342,   974,   974,   791,   150,   188,   284,   442,   570,   443,
     571,   275,   444,   572,   877,   279,   878,   200,   780,   108,
     974,   707,   823,   824,   505,   289,   436,   514,   517,   518,
     519,   108,   747,   714,   547,   279,   548,   513,   789,   549,
     790,   347,   348,   327,   382,   382,   963,  -208,   382,   964,
     781,   782,   343,   344,   345,   346,   204,   347,   348,   349,
     350,   214,   215,   209,   446,   273,   263,   274,   552,   332,
     287,   291,   748,   382,   312,   319,   322,   578,    19,   573,
     309,   309,   309,   309,   309,   309,   309,   309,   309,   309,
     309,   309,   309,   309,   309,   309,   309,   309,   309,   769,
     596,   397,   774,   169,    20,   394,   401,   407,   402,   403,
     869,   150,   357,   358,   359,   360,   361,   410,   459,    21,
      22,    23,   357,   358,   359,   360,   361,   461,    24,   665,
     150,   822,   351,   352,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   463,   520,    25,   526,   553,   662,   554,
     831,   532,   555,   831,    26,   825,   579,   527,   580,   538,
     539,   581,   565,   337,   149,   453,   455,   576,   583,   831,
     966,   150,   582,   968,   969,   148,   591,   708,   597,   149,
     593,   976,   149,   332,   602,    27,   661,   704,   382,   149,
     148,   147,   664,   148,   778,   669,   712,   689,   332,   869,
     148,   677,   678,   691,   990,   694,   147,   869,   666,   147,
     667,   696,   697,   668,   528,   705,   147,   822,   715,   718,
     337,   436,   719,   793,   108,   869,   211,   724,   725,   728,
     457,   457,   735,   528,   586,   727,   737,   149,   447,   908,
     540,   149,   745,   336,   336,   732,   733,   542,   148,   457,
     767,     9,   148,   771,   765,   149,   709,   586,   710,   779,
     788,   711,   336,   869,   147,   811,   148,   108,   147,   869,
     869,   404,   405,   149,   149,   797,   816,   869,  -381,   108,
    -365,   714,   147,  -373,   148,   148,   869,  -348,   108,   924,
     873,   869,   928,   337,   944,   929,   912,   915,   932,   898,
     147,   147,   794,   909,   795,   909,   985,   796,   945,   108,
     949,   883,   950,   587,   588,   589,   951,   982,   910,   337,
     911,   408,   260,   337,   907,   206,   199,   741,   773,   545,
      28,   931,   906,   896,   242,   210,   587,   588,   589,   309,
      43,   362,   784,   363,   975,   988,   756,   917,   918,   987,
     723,    44,    45,    46,   739,   730,   923,     0,   925,   926,
     421,   242,     0,     0,   242,    47,     0,     0,    48,     0,
      49,     0,    50,     0,    51,     0,     0,     0,   337,    52,
       0,     0,   337,     0,    53,     0,   306,   306,     0,   108,
     337,   883,     0,     0,   343,   344,   345,   346,   150,   347,
     348,     0,     0,     0,   337,   306,     0,     0,   337,     0,
     800,     0,   803,   150,     0,     0,   150,     0,     0,     0,
       0,     0,     0,   150,     0,     0,   344,   345,   337,     0,
     347,   348,   337,   337,   337,   337,     0,     0,   340,   340,
       0,     0,     0,     0,     0,     0,   337,   337,   337,     0,
       0,   337,   337,   337,     0,     0,     0,   340,   335,   335,
     337,     0,     0,     0,     0,     0,   337,     0,   337,   337,
       0,   150,     0,     0,   337,   150,     0,   335,   355,   356,
     357,   358,   359,   360,   361,     0,     0,     0,     0,   150,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   157,     0,     0,     0,     0,     0,   150,   150,   355,
     356,   357,   358,   359,   360,   361,   754,     0,     0,   755,
       0,     0,     0,     0,    -2,     4,     0,     0,  -156,     0,
    -156,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     5,     0,
       0,  -156,  -156,     0,   242,  -156,  -156,   242,     0,  -156,
     242,     0,     0,     0,    33,  -156,  -156,  -156,     0,  -156,
       0,  -156,  -156,  -156,   785,     6,  -156,  -156,  -156,  -156,
    -156,  -156,     0,  -156,    18,     0,     0,  -156,  -156,    19,
     953,  -156,  -156,     0,  -156,  -156,  -156,  -156,  -156,     0,
    -156,  -156,     0,  -156,     0,  -156,  -156,  -156,  -650,  -650,
    -156,     0,     0,     0,     0,    20,     0,     0,     0,  -650,
       0,     0,   367,   368,     0,     0,     0,     7,     0,     0,
      21,    22,    23,   369,     0,  -156,     0,  -156,     0,    24,
       0,     0,     0,     0,     0,  -650,     0,     0,  -650,  -650,
       0,     0,  -650,     0,     0,     0,    25,     0,  -650,   370,
       0,  -650,   371,   372,     0,    26,   373,     0,  -650,     0,
       0,     0,   374,  -650,     0,   375,     0,     0,     0,     0,
       0,     0,   376,     0,     0,     0,     0,   384,     0,     0,
       0,     0,     0,     0,     0,     0,    27,     0,     0,     0,
     332,   332,   884,     0,     0,     0,   218,    19,   219,   220,
     221,    58,     0,     0,     0,     0,   222,     0,     0,   332,
       0,    59,   223,   224,    62,   885,  -649,  -649,   132,   133,
      65,    66,  -500,    20,    68,    69,   134,  -649,    71,     0,
       0,    72,  -500,    74,   135,    76,   136,   226,    21,    22,
      23,    81,    82,    83,    84,   227,    86,    24,   137,   228,
     138,     0,   229,  -649,   139,   140,  -649,  -649,    93,   141,
    -649,    95,   142,    97,   230,    99,  -649,   100,   143,  -649,
       0,   231,   104,    26,   144,     0,  -649,   106,     0,     0,
       0,  -649,     0,     0,     0,     0,     0,     0,     0,   232,
       0,     0,     0,   233,   886,     0,     0,     0,   234,     0,
     235,   884,     0,     0,    27,   218,    19,   219,   220,   221,
      58,     0,     0,     0,     0,   222,     0,     0,     0,     0,
      59,   223,   224,    62,     0,  -659,  -659,   132,   133,    65,
      66,  -500,    20,    68,    69,   134,  -659,    71,   404,   405,
      72,  -500,    74,   135,    76,   136,   226,    21,    22,    23,
      81,    82,    83,    84,   227,    86,    24,   137,   228,   138,
       0,   229,  -659,   139,   140,  -659,  -659,    93,   141,  -659,
      95,   142,    97,   230,    99,  -659,   100,   143,  -659,     0,
     231,   104,    26,   144,     0,  -659,   106,     0,     0,     0,
    -659,     0,     0,     0,     0,     0,     0,     0,   232,     0,
       0,     0,   233,     0,     0,     0,     0,   234,     0,   235,
       0,   833,     0,    27,   834,   218,    19,   219,   220,   221,
     835,     0,     0,     0,     0,   222,     0,     0,     0,     0,
     836,   223,   224,   837,   750,     0,     0,   132,   133,   838,
     839,  -500,    20,   840,   841,   134,     0,   842,     0,     0,
      72,  -500,    74,   135,   843,   136,   226,    21,   844,    23,
     845,   846,    83,    84,   227,    86,    24,   137,   228,   138,
       0,   229,     0,   139,   140,     0,     0,    93,   141,     0,
      95,   142,    97,   230,    99,     0,   100,   143,     0,     0,
     231,   104,    26,   144,   847,     0,   106,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   232,     0,
       0,     0,   233,   848,     0,   751,     0,   234,     0,   235,
     509,   316,     0,    27,   218,    19,   219,   220,   221,    58,
       0,     0,     0,     0,   222,     0,     0,     0,     0,    59,
     223,   224,    62,   510,     0,     0,   132,   133,    65,    66,
    -500,    20,    68,    69,   134,     0,    71,  -567,  -567,    72,
    -500,    74,   135,    76,   136,   226,    21,    22,    23,    81,
      82,    83,    84,   227,    86,    24,   137,   228,   138,     0,
     229,     0,   139,   140,     0,     0,    93,   141,     0,    95,
     142,    97,   230,    99,     0,   100,   143,     0,     0,   231,
     104,    26,   144,     0,     0,   106,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   511,     0,   232,   512,     0,
       0,   233,     0,     0,     0,     0,   234,     0,   235,     0,
     833,     0,    27,   834,   218,    19,   219,   220,   221,   835,
       0,     0,     0,     0,   222,     0,     0,     0,     0,   836,
     223,   224,   837,     0,     0,     0,   132,   133,   838,   839,
    -500,    20,   840,   841,   134,     0,   842,     0,     0,    72,
    -500,    74,   135,   843,   136,   226,    21,   844,    23,   845,
     846,    83,    84,   227,    86,    24,   137,   228,   138,     0,
     229,     0,   139,   140,     0,     0,    93,   141,     0,    95,
     142,    97,   230,    99,     0,   100,   143,     0,     0,   231,
     104,    26,   144,   847,     0,   106,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   232,     0,     0,
       0,   233,   848,     0,     0,     0,   234,     0,   235,   884,
     316,     0,    27,   218,    19,   219,   220,   221,    58,     0,
       0,     0,     0,   222,     0,     0,     0,     0,    59,   223,
     224,    62,  -396,     0,     0,   132,   133,    65,    66,  -500,
      20,    68,    69,   134,     0,    71,     0,     0,    72,  -500,
      74,   135,    76,   136,   226,    21,    22,    23,    81,    82,
      83,    84,   227,    86,    24,   137,   228,   138,     0,   229,
       0,   139,   140,     0,     0,    93,   141,     0,    95,   142,
      97,   230,    99,     0,   100,   143,     0,     0,   231,   104,
      26,   144,     0,     0,   106,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,     0,     0,     0,
     233,  -396,  -396,  -396,     0,   234,     0,   235,   884,     0,
       0,    27,   218,    19,   219,   220,   221,    58,     0,     0,
       0,     0,   222,     0,     0,     0,     0,    59,   223,   224,
      62,  -393,     0,     0,   132,   133,    65,    66,  -500,    20,
      68,    69,   134,     0,    71,     0,     0,    72,  -500,    74,
     135,    76,   136,   226,    21,    22,    23,    81,    82,    83,
      84,   227,    86,    24,   137,   228,   138,     0,   229,     0,
     139,   140,     0,     0,    93,   141,     0,    95,   142,    97,
     230,    99,     0,   100,   143,     0,     0,   231,   104,    26,
     144,     0,     0,   106,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   232,     0,     0,     0,   233,
       0,     0,  -393,     0,   234,  -393,   235,   884,     0,     0,
      27,   218,    19,   219,   220,   221,    58,     0,     0,     0,
       0,   222,     0,     0,     0,     0,    59,   223,   224,    62,
    -393,     0,     0,   132,   133,    65,    66,  -500,    20,    68,
      69,   134,     0,    71,     0,     0,    72,  -500,    74,   135,
      76,   136,   226,    21,    22,    23,    81,    82,    83,    84,
     227,    86,    24,   137,   228,   138,     0,   229,     0,   139,
     140,     0,     0,    93,   141,     0,    95,   142,    97,   230,
      99,     0,   100,   143,     0,     0,   231,   104,    26,   144,
       0,     0,   106,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   232,     0,     0,     0,   233,  -393,
       0,     0,     0,   234,     0,   235,   884,     0,     0,    27,
     218,    19,   219,   220,   221,    58,     0,     0,     0,     0,
     222,     0,     0,     0,     0,    59,   223,   224,    62,  -379,
       0,     0,   132,   133,    65,    66,  -500,    20,    68,    69,
     134,     0,    71,     0,     0,    72,  -500,    74,   135,    76,
     136,   226,    21,    22,    23,    81,    82,    83,    84,   227,
      86,    24,   137,   228,   138,     0,   229,     0,   139,   140,
       0,     0,    93,   141,     0,    95,   142,    97,   230,    99,
       0,   100,   143,     0,     0,   231,   104,    26,   144,     0,
       0,   106,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   232,     0,     0,     0,   233,  -379,     0,
       0,     0,   234,     0,   235,   325,     0,     0,    27,   218,
      19,   219,   220,   221,    58,     0,     0,     0,     0,   222,
       0,     0,     0,     0,    59,   223,   224,    62,     0,     0,
       0,   132,   133,    65,    66,  -500,    20,    68,    69,   134,
       0,    71,     0,     0,    72,  -500,    74,   135,    76,   136,
     226,    21,    22,    23,    81,    82,    83,    84,   227,    86,
      24,   137,   228,   138,     0,   229,     0,   139,   140,     0,
       0,    93,   141,     0,    95,   142,    97,   230,    99,     0,
     100,   143,     0,     0,   231,   104,    26,   144,     0,     0,
     106,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   232,     0,     0,     0,   233,     0,     0,     0,
       0,   234,     0,   235,   422,   326,     0,    27,   218,    19,
     219,   220,   221,    58,     0,     0,     0,     0,   222,     0,
       0,     0,     0,    59,   223,   224,    62,     0,     0,     0,
     132,   133,    65,    66,  -500,    20,    68,    69,   134,     0,
      71,     0,     0,    72,  -500,    74,   135,    76,   136,   226,
      21,    22,    23,    81,    82,    83,    84,   227,    86,    24,
     137,   228,   138,     0,   229,     0,   139,   140,     0,     0,
      93,   141,     0,    95,   142,    97,   230,    99,     0,   100,
     143,     0,     0,   231,   104,    26,   144,     0,     0,   106,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   232,     0,     0,     0,   233,     0,     0,     0,     0,
     234,     0,   235,   884,     0,     0,    27,   218,    19,   219,
     220,   221,    58,     0,     0,     0,     0,   222,     0,     0,
       0,     0,    59,   223,   224,    62,     0,     0,     0,   132,
     133,    65,    66,  -500,    20,    68,    69,   134,     0,    71,
       0,     0,    72,  -500,    74,   135,    76,   136,   226,    21,
      22,    23,    81,    82,    83,    84,   227,    86,    24,   137,
     228,   138,     0,   229,     0,   139,   140,     0,     0,    93,
     141,     0,    95,   142,    97,   230,    99,     0,   100,   143,
       0,     0,   231,   104,    26,   144,     0,     0,   106,     0,
       0,     0,     0,     0,     0,     0,     0,   971,     0,     0,
     232,   218,    19,   219,   233,     0,    58,     0,     0,   234,
       0,   235,     0,     0,     0,    27,    59,   223,   224,    62,
    -361,     0,     0,   132,   133,    65,    66,  -500,    20,    68,
      69,   134,     0,    71,     0,     0,    72,  -500,    74,   135,
      76,   136,   226,    21,    22,    23,    81,    82,    83,    84,
     227,    86,    24,   137,   228,   138,     0,   229,     0,   139,
     140,     0,     0,    93,   141,     0,    95,   142,    97,   230,
      99,     0,   100,   143,     0,     0,   231,   104,    26,   144,
       0,     0,   106,     0,     0,     0,     0,     0,     0,     0,
       0,   971,     0,     0,     0,   218,    19,   219,     0,     0,
      58,  -361,     0,   234,  -361,   235,     0,     0,     0,    27,
      59,   223,   224,    62,     0,     0,     0,   132,   133,    65,
      66,  -500,    20,    68,    69,   134,     0,    71,     0,     0,
      72,  -500,    74,   135,    76,   136,   226,    21,    22,    23,
      81,    82,    83,    84,   227,    86,    24,   137,   228,   138,
       0,   229,     0,   139,   140,     0,     0,    93,   141,     0,
      95,   142,    97,   230,    99,     0,   100,   143,     0,     0,
     231,   104,    26,   144,     0,     0,   106,     0,     0,     0,
       0,     0,     0,     0,     0,   971,     0,     0,     0,   218,
      19,   219,     0,  -361,    58,     0,     0,   234,     0,   235,
       0,     0,     0,    27,    59,   223,   224,    62,     0,     0,
       0,   132,   133,    65,    66,  -500,    20,    68,    69,   134,
       0,    71,     0,     0,    72,  -500,    74,   135,    76,   136,
     226,    21,    22,    23,    81,    82,    83,    84,   227,    86,
      24,   137,   228,   138,     0,   229,     0,   139,   140,     0,
       0,    93,   141,     0,    95,   142,    97,   230,    99,     0,
     100,   143,     0,     0,   231,   104,    26,   144,     0,     0,
     106,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     433,     0,     0,     0,   218,    19,   219,   220,   221,    58,
       0,   234,     0,   235,   222,     0,     0,    27,     0,    59,
     223,   224,    62,     0,     0,     0,     0,     0,    65,    66,
    -500,    20,    68,    69,     0,     0,    71,     0,     0,    72,
    -500,    74,     0,    76,     0,   226,    21,    22,    23,    81,
      82,    83,    84,   227,    86,    24,     0,   228,     0,  -433,
     229,     0,     0,     0,     0,     0,    93,     0,     0,    95,
       0,    97,   230,    99,     0,   100,     0,     0,     0,   231,
     104,    26,     0,     0,     0,   106,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   232,     0,     0,
       0,   233,     0,     0,     0,     0,   234,  -433,   235,   507,
       0,   434,    27,   218,    19,   219,   220,   221,    58,     0,
       0,     0,     0,   222,     0,     0,     0,     0,    59,   223,
     224,    62,     0,     0,     0,     0,     0,    65,    66,  -500,
      20,    68,    69,     0,     0,    71,     0,     0,    72,  -500,
      74,     0,    76,     0,   226,    21,    22,    23,    81,    82,
      83,    84,   227,    86,    24,     0,   228,     0,     0,   229,
       0,     0,     0,     0,     0,    93,     0,     0,    95,     0,
      97,   230,    99,     0,   100,     0,     0,     0,   231,   104,
      26,     0,     0,     0,   106,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   232,     0,     0,     0,
     233,     0,     0,     0,     0,   234,  -433,   235,   729,     0,
     434,    27,   218,    19,   219,   220,   221,    58,     0,     0,
       0,     0,   222,     0,     0,     0,     0,    59,   223,   224,
      62,     0,     0,     0,     0,     0,    65,    66,  -500,    20,
      68,    69,     0,     0,    71,     0,     0,    72,  -500,    74,
       0,    76,     0,   226,    21,    22,    23,    81,    82,    83,
      84,   227,    86,    24,     0,   228,     0,     0,   229,     0,
       0,     0,     0,     0,    93,     0,     0,    95,     0,    97,
     230,    99,     0,   100,     0,     0,     0,   231,   104,    26,
       0,     0,     0,   106,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   232,     0,     0,     0,   233,
       0,     0,     0,     0,   234,  -432,   235,  -432,   217,     0,
      27,     0,   218,    19,   219,   220,   221,    58,     0,     0,
       0,     0,   222,     0,     0,     0,     0,    59,   223,   224,
      62,   225,     0,     0,     0,     0,    65,    66,  -500,    20,
      68,    69,     0,     0,    71,     0,     0,    72,  -500,    74,
       0,    76,     0,   226,    21,    22,    23,    81,    82,    83,
      84,   227,    86,    24,     0,   228,     0,     0,   229,     0,
       0,     0,     0,     0,    93,     0,     0,    95,     0,    97,
     230,    99,     0,   100,     0,     0,     0,   231,   104,    26,
       0,     0,     0,   106,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   232,     0,     0,     0,   233,
       0,     0,     0,     0,   234,     0,   235,   325,     0,     0,
      27,   218,    19,   219,   220,   221,    58,     0,     0,     0,
       0,   222,     0,     0,     0,     0,    59,   223,   224,    62,
       0,     0,     0,     0,     0,    65,    66,  -500,    20,    68,
      69,     0,     0,    71,     0,     0,    72,  -500,    74,     0,
      76,     0,   226,    21,    22,    23,    81,    82,    83,    84,
     227,    86,    24,     0,   228,     0,     0,   229,     0,     0,
       0,     0,     0,    93,     0,     0,    95,     0,    97,   230,
      99,     0,   100,     0,     0,     0,   231,   104,    26,     0,
       0,     0,   106,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   232,     0,     0,     0,   233,     0,
       0,     0,     0,   234,     0,   235,   699,   326,     0,    27,
    -233,  -233,  -233,  -233,  -233,  -233,     0,     0,     0,     0,
    -233,     0,     0,     0,     0,  -233,  -233,  -233,  -233,   700,
       0,     0,     0,     0,  -233,  -233,  -233,  -233,  -233,  -233,
       0,     0,  -233,     0,     0,  -233,  -233,  -233,     0,  -233,
       0,  -233,  -233,  -233,  -233,  -233,  -233,  -233,  -233,  -233,
    -233,  -233,     0,  -233,     0,     0,  -233,     0,     0,     0,
       0,     0,  -233,     0,     0,  -233,     0,  -233,  -233,  -233,
       0,  -233,     0,     0,     0,  -233,  -233,  -233,     0,     0,
       0,  -233,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -233,     0,     0,     0,  -233,     0,     0,
       0,     0,  -233,     0,  -233,   798,     0,     0,  -233,   218,
      19,   219,   220,   221,    58,     0,     0,     0,     0,   222,
       0,     0,     0,     0,    59,   223,   224,    62,   799,     0,
       0,     0,     0,    65,    66,  -500,    20,    68,    69,     0,
       0,    71,     0,     0,    72,  -500,    74,     0,    76,     0,
     226,    21,    22,    23,    81,    82,    83,    84,   227,    86,
      24,     0,   228,     0,     0,   229,     0,     0,     0,     0,
       0,    93,     0,     0,    95,     0,    97,   230,    99,     0,
     100,     0,     0,     0,   231,   104,    26,     0,     0,     0,
     106,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   232,     0,     0,     0,   233,     0,     0,     0,
       0,   234,     0,   235,   419,     0,     0,    27,   218,    19,
     219,   220,   221,    58,     0,     0,     0,     0,   222,     0,
       0,     0,     0,    59,   223,   224,    62,     0,     0,     0,
       0,     0,    65,    66,  -500,    20,    68,    69,     0,     0,
      71,     0,     0,    72,  -500,    74,     0,    76,     0,   226,
      21,    22,    23,    81,    82,    83,    84,   227,    86,    24,
       0,   228,     0,     0,   229,     0,     0,     0,     0,     0,
      93,     0,     0,    95,     0,    97,   230,    99,     0,   100,
       0,     0,     0,   231,   104,    26,     0,     0,     0,   106,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   232,     0,     0,     0,   233,     0,     0,     0,     0,
     234,     0,   235,   439,     0,     0,    27,   218,    19,   219,
     220,   221,    58,     0,     0,     0,     0,   222,     0,     0,
       0,     0,    59,   223,   224,    62,     0,     0,     0,     0,
       0,    65,    66,  -500,    20,    68,    69,     0,     0,    71,
       0,     0,    72,  -500,    74,     0,    76,     0,   226,    21,
      22,    23,    81,    82,    83,    84,   227,    86,    24,     0,
     228,     0,     0,   229,     0,     0,     0,     0,     0,    93,
       0,     0,    95,     0,    97,   230,    99,     0,   100,     0,
       0,     0,   231,   104,    26,     0,     0,     0,   106,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     232,     0,     0,     0,   233,     0,     0,     0,     0,   234,
       0,   235,   504,     0,     0,    27,   218,    19,   219,   220,
     221,    58,     0,     0,     0,     0,   222,     0,     0,     0,
       0,    59,   223,   224,    62,     0,     0,     0,     0,     0,
      65,    66,  -500,    20,    68,    69,     0,     0,    71,     0,
       0,    72,  -500,    74,     0,    76,     0,   226,    21,    22,
      23,    81,    82,    83,    84,   227,    86,    24,     0,   228,
       0,     0,   229,     0,     0,     0,     0,     0,    93,     0,
       0,    95,     0,    97,   230,    99,     0,   100,     0,     0,
       0,   231,   104,    26,     0,     0,     0,   106,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   232,
       0,     0,     0,   233,     0,     0,     0,     0,   234,     0,
     235,   516,     0,     0,    27,   218,    19,   219,   220,   221,
      58,     0,     0,     0,     0,   222,     0,     0,     0,     0,
      59,   223,   224,    62,     0,     0,     0,     0,     0,    65,
      66,  -500,    20,    68,    69,     0,     0,    71,     0,     0,
      72,  -500,    74,     0,    76,     0,   226,    21,    22,    23,
      81,    82,    83,    84,   227,    86,    24,     0,   228,     0,
       0,   229,     0,     0,     0,     0,     0,    93,     0,     0,
      95,     0,    97,   230,    99,     0,   100,     0,     0,     0,
     231,   104,    26,     0,     0,     0,   106,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   232,     0,
       0,     0,   233,     0,     0,     0,     0,   234,     0,   235,
     726,     0,     0,    27,   218,    19,   219,   220,   221,    58,
       0,     0,     0,     0,   222,     0,     0,     0,     0,    59,
     223,   224,    62,     0,     0,     0,     0,     0,    65,    66,
    -500,    20,    68,    69,     0,     0,    71,     0,     0,    72,
    -500,    74,     0,    76,     0,   226,    21,    22,    23,    81,
      82,    83,    84,   227,    86,    24,     0,   228,     0,     0,
     229,     0,     0,     0,     0,     0,    93,     0,     0,    95,
       0,    97,   230,    99,     0,   100,     0,     0,     0,   231,
     104,    26,     0,     0,     4,   106,     0,  -156,     0,  -156,
       0,     0,     0,     0,     0,     0,     0,   232,     0,     0,
       0,   233,     0,     0,     0,     0,   234,   292,   235,     0,
    -156,  -156,    27,     0,  -156,  -156,     0,     0,  -156,     0,
       0,     0,     0,     0,  -156,  -156,  -156,     0,  -156,     0,
    -156,  -156,  -156,     0,     6,  -156,  -156,  -156,  -156,  -156,
    -156,     0,  -156,     0,     0,     0,  -156,  -156,     0,     0,
    -156,  -156,     0,  -156,  -156,  -156,  -156,  -156,     0,  -156,
    -156,     0,  -156,     0,  -156,  -156,  -156,     0,     0,  -156,
       0,     0,     4,     0,     0,  -156,     0,  -156,     0,     0,
       0,     0,     0,     0,     0,     0,     7,     0,   293,     0,
       0,     0,     0,     0,  -156,  -326,  -156,     0,  -156,  -156,
       0,     0,  -156,  -156,     0,     0,  -156,     0,     0,     0,
       0,     0,  -156,  -156,  -156,     0,  -156,     0,  -156,  -156,
    -156,     0,     6,  -156,  -156,  -156,  -156,  -156,  -156,     0,
    -156,     0,     0,     0,  -156,  -156,     0,     0,  -156,  -156,
       0,  -156,  -156,  -156,  -156,  -156,     0,  -156,  -156,     0,
    -156,     0,  -156,  -156,  -156,     0,     0,  -156,   464,     0,
       0,     0,   218,    19,   219,   220,   221,     0,     0,     0,
       0,     0,   222,     0,     7,     0,  -326,     0,   300,   301,
       0,     0,  -156,     0,  -156,     0,     0,     0,  -500,    20,
       0,     0,     0,     0,     0,     0,     0,     0,  -500,     0,
       0,     0,     0,   302,    21,    22,    23,     0,     0,     0,
       0,   303,     0,    24,     0,   304,     0,     0,   229,     0,
       0,     0,     0,     0,     0,     0,     0,   466,     0,     0,
      25,   218,    19,   219,   220,   221,     0,   305,     0,    26,
       0,   222,     0,     0,     0,     0,     0,   300,   301,     0,
       0,     0,     0,     0,     0,   232,     0,  -500,    20,   233,
       0,     0,     0,     0,   234,     0,   235,  -500,     0,     0,
      27,     0,   302,    21,    22,    23,     0,     0,     0,     0,
     303,     0,    24,     0,   304,     0,     0,   229,     0,     0,
       0,     0,     0,     0,     0,     0,   468,     0,     0,    25,
     218,    19,   219,   220,   221,     0,   305,     0,    26,     0,
     222,     0,     0,     0,     0,     0,   300,   301,     0,     0,
       0,     0,     0,     0,   232,     0,  -500,    20,   233,     0,
       0,     0,     0,   234,     0,   235,  -500,     0,     0,    27,
       0,   302,    21,    22,    23,     0,     0,     0,     0,   303,
       0,    24,     0,   304,     0,     0,   229,     0,     0,     0,
       0,     0,     0,     0,     0,   470,     0,     0,    25,   218,
      19,   219,   220,   221,     0,   305,     0,    26,     0,   222,
       0,     0,     0,     0,     0,   300,   301,     0,     0,     0,
       0,     0,     0,   232,     0,  -500,    20,   233,     0,     0,
       0,     0,   234,     0,   235,  -500,     0,     0,    27,     0,
     302,    21,    22,    23,     0,     0,     0,     0,   303,     0,
      24,     0,   304,     0,     0,   229,     0,     0,     0,     0,
       0,     0,     0,     0,   472,     0,     0,    25,   218,    19,
     219,   220,   221,     0,   305,     0,    26,     0,   222,     0,
       0,     0,     0,     0,   300,   301,     0,     0,     0,     0,
       0,     0,   232,     0,  -500,    20,   233,     0,     0,     0,
       0,   234,     0,   235,  -500,     0,     0,    27,     0,   302,
      21,    22,    23,     0,     0,     0,     0,   303,     0,    24,
       0,   304,     0,     0,   229,     0,     0,     0,     0,     0,
       0,     0,     0,   474,     0,     0,    25,   218,    19,   219,
     220,   221,     0,   305,     0,    26,     0,   222,     0,     0,
       0,     0,     0,   300,   301,     0,     0,     0,     0,     0,
       0,   232,     0,  -500,    20,   233,     0,     0,     0,     0,
     234,     0,   235,  -500,     0,     0,    27,     0,   302,    21,
      22,    23,     0,     0,     0,     0,   303,     0,    24,     0,
     304,     0,     0,   229,     0,     0,     0,     0,     0,     0,
       0,     0,   476,     0,     0,    25,   218,    19,   219,   220,
     221,     0,   305,     0,    26,     0,   222,     0,     0,     0,
       0,     0,   300,   301,     0,     0,     0,     0,     0,     0,
     232,     0,  -500,    20,   233,     0,     0,     0,     0,   234,
       0,   235,  -500,     0,     0,    27,     0,   302,    21,    22,
      23,     0,     0,     0,     0,   303,     0,    24,     0,   304,
       0,     0,   229,     0,     0,     0,     0,     0,     0,     0,
       0,   478,     0,     0,    25,   218,    19,   219,   220,   221,
       0,   305,     0,    26,     0,   222,     0,     0,     0,     0,
       0,   300,   301,     0,     0,     0,     0,     0,     0,   232,
       0,  -500,    20,   233,     0,     0,     0,     0,   234,     0,
     235,  -500,     0,     0,    27,     0,   302,    21,    22,    23,
       0,     0,     0,     0,   303,     0,    24,     0,   304,     0,
       0,   229,     0,     0,     0,     0,     0,     0,     0,     0,
     481,     0,     0,    25,   218,    19,   219,   220,   221,     0,
     305,     0,    26,     0,   222,     0,     0,     0,     0,     0,
     300,   301,     0,     0,     0,     0,     0,     0,   232,     0,
    -500,    20,   233,     0,     0,     0,     0,   234,     0,   235,
    -500,     0,     0,    27,     0,   302,    21,    22,    23,     0,
       0,     0,     0,   303,     0,    24,     0,   304,     0,     0,
     229,     0,     0,     0,     0,     0,     0,     0,     0,   483,
       0,     0,    25,   218,    19,   219,   220,   221,     0,   305,
       0,    26,     0,   222,     0,     0,     0,     0,     0,   300,
     301,     0,     0,     0,     0,     0,     0,   232,     0,  -500,
      20,   233,     0,     0,     0,     0,   234,     0,   235,  -500,
       0,     0,    27,     0,   302,    21,    22,    23,     0,     0,
       0,     0,   303,     0,    24,     0,   304,     0,     0,   229,
       0,     0,     0,     0,     0,     0,     0,     0,   485,     0,
       0,    25,   218,    19,   219,   220,   221,     0,   305,     0,
      26,     0,   222,     0,     0,     0,     0,     0,   300,   301,
       0,     0,     0,     0,     0,     0,   232,     0,  -500,    20,
     233,     0,     0,     0,     0,   234,     0,   235,  -500,     0,
       0,    27,     0,   302,    21,    22,    23,     0,     0,     0,
       0,   303,     0,    24,     0,   304,     0,     0,   229,     0,
       0,     0,     0,     0,     0,     0,     0,   487,     0,     0,
      25,   218,    19,   219,   220,   221,     0,   305,     0,    26,
       0,   222,     0,     0,     0,     0,     0,   300,   301,     0,
       0,     0,     0,     0,     0,   232,     0,  -500,    20,   233,
       0,     0,     0,     0,   234,     0,   235,  -500,     0,     0,
      27,     0,   302,    21,    22,    23,     0,     0,     0,     0,
     303,     0,    24,     0,   304,     0,     0,   229,     0,     0,
       0,     0,     0,     0,     0,     0,   489,     0,     0,    25,
     218,    19,   219,   220,   221,     0,   305,     0,    26,     0,
     222,     0,     0,     0,     0,     0,   300,   301,     0,     0,
       0,     0,     0,     0,   232,     0,  -500,    20,   233,     0,
       0,     0,     0,   234,     0,   235,  -500,     0,     0,    27,
       0,   302,    21,    22,    23,     0,     0,     0,     0,   303,
       0,    24,     0,   304,     0,     0,   229,     0,     0,     0,
       0,     0,     0,     0,     0,   491,     0,     0,    25,   218,
      19,   219,   220,   221,     0,   305,     0,    26,     0,   222,
       0,     0,     0,     0,     0,   300,   301,     0,     0,     0,
       0,     0,     0,   232,     0,  -500,    20,   233,     0,     0,
       0,     0,   234,     0,   235,  -500,     0,     0,    27,     0,
     302,    21,    22,    23,     0,     0,     0,     0,   303,     0,
      24,     0,   304,     0,     0,   229,     0,     0,     0,     0,
       0,     0,     0,     0,   493,     0,     0,    25,   218,    19,
     219,   220,   221,     0,   305,     0,    26,     0,   222,     0,
       0,     0,     0,     0,   300,   301,     0,     0,     0,     0,
       0,     0,   232,     0,  -500,    20,   233,     0,     0,     0,
       0,   234,     0,   235,  -500,     0,     0,    27,     0,   302,
      21,    22,    23,     0,     0,     0,     0,   303,     0,    24,
       0,   304,     0,     0,   229,     0,     0,     0,     0,     0,
       0,     0,     0,   495,     0,     0,    25,   218,    19,   219,
     220,   221,     0,   305,     0,    26,     0,   222,     0,     0,
       0,     0,     0,   300,   301,     0,     0,     0,     0,     0,
       0,   232,     0,  -500,    20,   233,     0,     0,     0,     0,
     234,     0,   235,  -500,     0,     0,    27,     0,   302,    21,
      22,    23,     0,     0,     0,     0,   303,     0,    24,     0,
     304,     0,     0,   229,     0,     0,     0,     0,     0,     0,
       0,     0,   497,     0,     0,    25,   218,    19,   219,   220,
     221,     0,   305,     0,    26,     0,   222,     0,     0,     0,
       0,     0,   300,   301,     0,     0,     0,     0,     0,     0,
     232,     0,  -500,    20,   233,     0,     0,     0,     0,   234,
       0,   235,  -500,     0,     0,    27,     0,   302,    21,    22,
      23,     0,     0,     0,     0,   303,     0,    24,     0,   304,
       0,     0,   229,     0,     0,     0,     0,     0,     0,     0,
       0,   499,     0,     0,    25,   218,    19,   219,   220,   221,
       0,   305,     0,    26,     0,   222,     0,     0,     0,     0,
       0,   300,   301,     0,     0,     0,     0,     0,     0,   232,
       0,  -500,    20,   233,     0,   132,   133,     0,   234,     0,
     235,  -500,     0,   134,    27,     0,   302,    21,    22,    23,
       0,   135,     0,   136,   303,     0,    24,     0,   304,     0,
       0,   229,     0,     0,     0,   137,     0,   138,     0,     0,
     278,   139,   140,    25,     0,    19,   141,     0,     0,   142,
     305,     0,    26,     0,     0,   143,     0,     0,     0,     0,
       0,   144,     0,     0,     0,   599,   132,   133,   232,     0,
       0,    20,   233,     0,   134,     0,     0,   234,     0,   235,
       0,     0,   135,    27,   136,     0,    21,    22,    23,   367,
     368,     0,     0,     0,     0,    24,   137,     0,   138,     0,
     369,     0,   139,   140,     0,     0,     0,   141,     0,   278,
     142,     0,    25,     0,    19,     0,   143,     0,     0,     0,
       0,    26,   144,     0,     0,     0,   370,     0,     0,   371,
     372,     0,     0,   373,     0,   132,   133,     0,     0,   374,
      20,     0,   375,   134,     0,     0,     0,   296,     0,   376,
       0,   135,    27,   136,   600,    21,    22,    23,     0,     0,
       0,   288,     0,     0,    24,   137,    19,   138,     0,     0,
    -601,   139,   140,     0,  -601,     0,   141,     0,     0,   142,
       0,    25,     0,     0,     0,   143,     0,   132,   133,     0,
      26,   144,    20,     0,     0,   134,   343,   344,   345,   346,
       0,   347,   348,   135,     0,   136,     0,    21,    22,    23,
       0,     0,     0,     0,     0,     0,    24,   137,     0,   138,
       0,    27,     0,   139,   140,     0,     0,     0,   141,     0,
       0,   142,     0,    25,     0,     0,     0,   143,     0,  -541,
       0,     0,    26,   144,  -541,  -541,     0,  -541,  -541,  -541,
    -541,     0,  -541,  -541,  -541,  -541,     0,     0,     0,     0,
    -541,  -541,  -541,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -541,    27,  -541,  -541,     0,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,     0,     0,   343,
     344,   345,   346,     0,   347,   348,     0,     0,  -541,     0,
       0,  -541,  -541,     0,     0,  -541,     0,     0,     0,     0,
       0,  -541,     0,     0,  -541,     0,     0,     0,     0,     0,
       0,  -541,     0,  -541,  -541,     0,  -541,  -541,  -541,  -541,
    -541,  -541,  -541,  -541,  -541,  -541,  -541,  -541,     0,  -541,
    -541,  -541,  -541,  -541,  -541,  -541,  -541,   364,     0,   115,
       0,     0,   365,   366,     0,     0,     0,     0,     0,   314,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   367,
     368,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     369,     0,  -653,  -653,  -653,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  -653,   343,   344,   345,   346,     0,
     347,   348,   349,     0,     0,     0,   370,     0,     0,   371,
     372,     0,     0,   373,     0,     0,     0,     0,     0,   374,
    -653,     0,   375,  -653,  -653,     0,     0,  -653,     0,   376,
       0,   377,   378,  -653,   379,     0,  -653,     0,     0,     0,
       0,     0,     0,  -653,     0,     0,     0,     0,  -653,     0,
    -600,   234,     0,   235,  -600,     0,     0,   380,     0,     0,
       0,  -653,     0,  -653,  -653,   315,  -653,   364,  -653,   316,
       0,     0,   365,   366,     0,     0,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,     0,     0,     0,   367,
     368,     0,     0,     0,     0,     0,     0,  -661,  -661,     0,
     369,     0,     0,     0,     0,     0,     0,     0,  -661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   370,     0,     0,   371,
     372,     0,     0,   373,  -661,     0,     0,  -661,  -661,   374,
       0,  -661,   375,     0,     0,     0,     0,  -661,     0,   376,
    -661,   377,   378,     0,   379,     0,     0,  -661,     0,     0,
       0,     0,  -661,     0,   218,    19,   219,   220,   221,    58,
       0,   234,     0,   235,   222,     0,   897,   380,     0,    59,
     223,   224,    62,   510,     0,     0,   132,   133,    65,    66,
       0,    20,    68,    69,   134,     0,    71,  -567,  -567,    72,
       0,    74,   135,    76,   136,   226,    21,    22,    23,    81,
      82,    83,    84,   227,    86,    24,   137,   228,   138,     0,
     229,     0,   139,   140,     0,     0,    93,   141,     0,    95,
     142,    97,   230,    99,     0,   100,   143,     0,     0,   231,
     104,    26,   144,     0,     0,   106,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   511,     0,   232,     0,     0,
       0,   233,     0,     0,     0,     0,   234,     0,   235,     0,
       0,     0,    27,   218,    19,   219,   220,   221,    58,     0,
       0,     0,     0,   222,     0,     0,     0,     0,    59,   223,
     224,    62,   510,     0,     0,   132,   133,    65,    66,     0,
      20,    68,    69,   134,     0,    71,     0,     0,    72,     0,
      74,   135,    76,   136,   226,    21,    22,    23,    81,    82,
      83,    84,   227,    86,    24,   137,   228,   138,     0,   229,
       0,   139,   140,     0,     0,    93,   141,     0,    95,   142,
      97,   230,    99,     0,   100,   143,     0,     0,   231,   104,
      26,   144,     0,     0,   106,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   511,     0,   232,     0,     0,     0,
     233,     0,     0,     0,     0,   234,     0,   235,  -567,     0,
       0,    27,   218,    19,   219,   220,   221,    58,     0,     0,
       0,     0,   222,     0,     0,     0,     0,    59,   223,   224,
      62,     0,     0,     0,   132,   133,    65,    66,  -500,    20,
      68,    69,   134,     0,    71,     0,     0,    72,  -500,    74,
     135,    76,   136,   226,    21,    22,    23,    81,    82,    83,
      84,   227,    86,    24,   137,   228,   138,     0,   229,     0,
     139,   140,     0,     0,    93,   141,     0,    95,   142,    97,
     230,    99,     0,   100,   143,     0,     0,   231,   104,    26,
     144,     0,     0,   106,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   232,     0,     0,     0,   233,
       0,     0,     0,     0,   234,     0,   235,     0,     0,     0,
      27,   218,    19,   219,   220,   221,    58,     0,     0,     0,
       0,   222,     0,     0,     0,     0,    59,   223,   224,    62,
     675,     0,     0,   132,   133,    65,    66,     0,    20,    68,
      69,   134,     0,    71,     0,     0,    72,     0,    74,   135,
      76,   136,   226,    21,    22,    23,    81,    82,    83,    84,
     227,    86,    24,   137,   228,   138,     0,   229,     0,   139,
     140,     0,     0,    93,   141,     0,    95,   142,    97,   230,
      99,     0,   100,   143,     0,     0,   231,   104,    26,   144,
       0,     0,   106,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   232,   218,    19,   219,   233,     0,
      58,     0,     0,   234,     0,   235,     0,     0,     0,    27,
      59,   223,   224,    62,     0,     0,     0,   132,   133,    65,
      66,     0,    20,    68,    69,   134,     0,    71,     0,     0,
      72,     0,    74,   135,    76,   136,   226,    21,    22,    23,
      81,    82,    83,    84,   227,    86,    24,   137,   228,   138,
       0,   229,     0,   139,   140,     0,     0,    93,   141,     0,
      95,   142,    97,   230,    99,     0,   100,   143,     0,     0,
     231,   104,    26,   144,     0,     0,   106,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     218,    19,   219,   220,   221,    58,     0,   234,     0,   235,
     222,     0,     0,    27,     0,    59,   223,   224,    62,     0,
       0,     0,     0,     0,    65,    66,  -500,    20,    68,    69,
       0,     0,    71,     0,     0,    72,  -500,    74,     0,    76,
       0,   226,    21,    22,    23,    81,    82,    83,    84,   227,
      86,    24,     0,   228,     0,     0,   229,     0,     0,     0,
       0,     0,    93,     0,     0,    95,     0,    97,   230,    99,
       0,   100,     0,     0,     0,   231,   104,    26,     0,     0,
       0,   106,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   232,     0,     0,     0,   233,     0,     0,
       0,     0,   234,     0,   235,     0,     0,   434,    27,   218,
      19,   219,   220,   221,    58,     0,     0,     0,     0,   222,
       0,     0,     0,     0,    59,   223,   224,    62,     0,     0,
       0,     0,     0,    65,    66,     0,    20,    68,    69,     0,
       0,    71,     0,     0,    72,     0,    74,     0,    76,     0,
     226,    21,    22,    23,    81,    82,    83,    84,   227,    86,
      24,     0,   228,     0,     0,   229,     0,     0,     0,     0,
       0,    93,     0,     0,    95,     0,    97,   230,    99,     0,
     100,     0,     0,     0,   231,   104,    26,     0,     0,     0,
     106,   218,    19,   219,   220,   221,     0,     0,     0,     0,
       0,   222,   232,     0,     0,     0,   233,   300,   301,     0,
       0,   234,     0,   235,   218,    19,   219,    27,    20,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     300,   301,   302,    21,    22,    23,     0,     0,     0,     0,
     303,    20,    24,     0,   304,     0,     0,   229,     0,     0,
       0,     0,     0,     0,     0,   302,    21,    22,    23,    25,
       0,     0,     0,   303,     0,    24,   305,   304,    26,     0,
     229,     0,     0,     0,     0,     0,    19,     0,     0,     0,
       0,     0,    25,     0,   232,     0,     0,     0,   233,   305,
       0,    26,     0,   234,     0,   235,     0,   132,   133,    27,
       0,     0,    20,     0,     0,   134,     0,     0,     0,     0,
       0,     0,     0,   135,     0,   136,   234,    21,    22,    23,
       0,     0,    27,     0,     0,     0,    24,   137,    19,   138,
       0,     0,     0,   139,   140,     0,     0,     0,   141,     0,
       0,   142,     0,    25,     0,     0,     0,   143,     0,   132,
     133,     0,    26,   144,    20,     0,     0,   134,     0,     0,
       0,     0,     0,     0,     0,   135,     0,   136,     0,    21,
      22,    23,     0,     0,     0,     0,   396,     0,    24,   137,
      19,   138,     0,    27,     0,   139,   140,     0,     0,     0,
     141,     0,     0,   142,     0,    25,     0,     0,     0,   143,
       0,   132,   152,     0,    26,   144,    20,     0,     0,   153,
       0,     0,     0,     0,     0,     0,     0,   135,     0,   136,
       0,    21,    22,    23,     0,     0,     0,     0,     0,     0,
      24,   137,     0,   138,     0,    27,     0,   139,   140,     0,
       0,   522,   141,     0,     0,   142,     0,    25,     0,     0,
      58,   143,     0,     0,     0,     0,    26,   144,     0,     0,
      59,    60,    61,    62,  -337,     0,     0,    63,    64,    65,
      66,    67,     0,    68,    69,    70,     0,    71,     0,     0,
      72,    73,    74,    75,    76,    77,    78,    27,   208,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
     599,     0,     0,    91,    92,     0,     0,    93,    94,     0,
      95,    96,    97,    98,    99,     0,   100,   101,     0,   102,
     103,   104,     0,   105,   367,   368,   106,   343,   344,   345,
     346,     0,   347,   348,     0,   369,     0,     0,  -647,  -647,
       0,     0,     0,     0,     0,  -337,  -337,     0,     0,  -647,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   370,     0,     0,   371,   372,     0,     0,   373,     0,
       0,     0,     0,     0,   374,  -647,     0,   375,  -647,  -647,
       0,     0,  -647,     0,   376,     0,     0,     0,  -647,   600,
       0,  -647,     0,     0,     0,     0,     0,     0,  -647,   603,
       0,     0,   604,  -647,     0,     0,     0,     0,   605,     0,
     354,   355,   356,   357,   358,   359,   360,   361,   606,   607,
     608,   609,     0,     0,     0,   610,   611,   612,   613,   614,
       0,   615,   616,   617,     0,   618,     0,     0,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   628,   629,   630,
     631,   632,   633,   634,   635,   636,   637,   638,     0,     0,
       0,   639,   640,     0,     0,   641,   642,     0,   643,   644,
     645,   646,   647,     0,   648,   649,     0,   650,   651,   652,
     267,   653,   654,     0,   655,   268,     0,     0,     0,    58,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    59,
      60,    61,    62,     0,     0,     0,    63,    64,    65,    66,
      67,     0,    68,    69,    70,     0,    71,     0,     0,    72,
      73,    74,    75,    76,    77,    78,     0,   269,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
       0,     0,    91,    92,     0,     0,    93,    94,   117,    95,
      96,    97,    98,    99,     0,   100,   101,    58,   102,   103,
     104,     0,   105,     0,     0,   106,     0,    59,    60,    61,
      62,     0,     0,     0,    63,    64,    65,    66,    67,     0,
      68,    69,    70,     0,    71,     0,     0,    72,    73,    74,
      75,    76,    77,    78,     0,   118,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,     0,     0,     0,
      91,    92,     0,     0,    93,    94,   122,    95,    96,    97,
      98,    99,     0,   100,   101,    58,   102,   103,   104,     0,
     105,     0,     0,   106,     0,    59,    60,    61,    62,     0,
       0,     0,    63,    64,    65,    66,    67,     0,    68,    69,
      70,     0,    71,     0,     0,    72,    73,    74,    75,    76,
      77,    78,     0,   123,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,     0,     0,     0,    91,    92,
       0,     0,    93,    94,   163,    95,    96,    97,    98,    99,
       0,   100,   101,    58,   102,   103,   104,     0,   105,     0,
       0,   106,     0,    59,    60,    61,    62,     0,     0,     0,
      63,    64,    65,    66,    67,     0,    68,    69,    70,     0,
      71,     0,     0,    72,    73,    74,    75,    76,    77,    78,
       0,   164,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,     0,     0,     0,    91,    92,     0,     0,
      93,    94,   259,    95,    96,    97,    98,    99,     0,   100,
     101,    58,   102,   103,   104,     0,   105,     0,     0,   106,
       0,    59,    60,    61,    62,     0,     0,     0,    63,    64,
      65,    66,    67,     0,    68,    69,    70,     0,    71,     0,
       0,    72,    73,    74,    75,    76,    77,    78,     0,   123,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,     0,     0,     0,    91,    92,     0,     0,    93,    94,
     879,    95,    96,    97,    98,    99,     0,   100,   101,    58,
     102,   103,   104,     0,   105,     0,     0,   106,     0,    59,
      60,    61,    62,     0,     0,     0,    63,    64,    65,    66,
      67,     0,    68,    69,    70,     0,    71,     0,     0,    72,
      73,    74,    75,    76,    77,    78,     0,   880,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
       0,     0,    91,    92,     0,     0,    93,    94,   930,    95,
      96,    97,    98,    99,     0,   100,   101,    58,   102,   103,
     104,     0,   105,     0,     0,   106,     0,    59,    60,    61,
      62,     0,     0,     0,    63,    64,    65,    66,    67,     0,
      68,    69,    70,     0,    71,     0,     0,    72,    73,    74,
      75,    76,    77,    78,     0,   880,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,     0,     0,     0,
      91,    92,     0,     0,    93,    94,     0,    95,    96,    97,
      98,    99,     0,   100,   101,    58,   102,   103,   104,     0,
     105,     0,     0,   106,     0,    59,    60,    61,    62,     0,
       0,     0,    63,    64,    65,    66,    67,     0,    68,    69,
      70,     0,    71,     0,     0,    72,    73,    74,    75,    76,
      77,    78,     0,   208,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,     0,     0,     0,    91,    92,
       0,     0,    93,    94,     0,    95,    96,    97,    98,    99,
       0,   100,   101,    58,   102,   103,   104,     0,   105,     0,
       0,   106,     0,    59,    60,    61,    62,   209,     0,     0,
      63,    64,    65,    66,    67,     0,    68,    69,    70,     0,
      71,     0,     0,    72,    73,    74,    75,    76,    77,    78,
       0,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,     0,     0,     0,    91,    92,     0,     0,
      93,    94,     0,    95,    96,    97,    98,    99,     0,   100,
     101,    58,   102,   103,   104,     0,   105,     0,     0,   106,
       0,    59,    60,    61,    62,     0,     0,     0,    63,    64,
      65,    66,    67,     0,    68,    69,    70,     0,    71,     0,
       0,    72,    73,    74,    75,    76,    77,    78,     0,   159,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,     0,     0,     0,    91,    92,     0,     0,    93,    94,
       0,    95,    96,    97,    98,    99,     0,   100,   101,    58,
     102,   103,   104,     0,   105,     0,     0,   106,     0,    59,
      60,    61,    62,     0,     0,     0,    63,    64,    65,    66,
      67,     0,    68,    69,    70,     0,    71,     0,     0,    72,
      73,    74,    75,    76,    77,    78,     0,   161,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
       0,     0,    91,    92,     0,     0,    93,    94,     0,    95,
      96,    97,    98,    99,     0,   100,   101,    58,   102,   103,
     104,     0,   105,     0,     0,   106,     0,    59,    60,    61,
      62,     0,     0,     0,    63,    64,    65,    66,    67,     0,
      68,    69,    70,     0,    71,     0,     0,    72,    73,    74,
      75,    76,    77,    78,     0,   176,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,     0,     0,     0,
      91,    92,     0,     0,    93,    94,     0,    95,    96,    97,
      98,    99,     0,   100,   101,    58,   102,   103,   104,     0,
     105,     0,     0,   106,     0,    59,    60,    61,    62,     0,
       0,     0,    63,    64,    65,    66,    67,     0,    68,    69,
      70,     0,    71,     0,     0,    72,    73,    74,    75,    76,
      77,    78,     0,   414,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,     0,     0,     0,    91,    92,
       0,     0,    93,    94,     0,    95,    96,    97,    98,    99,
       0,   100,   101,    58,   102,   103,   104,     0,   105,     0,
       0,   106,     0,    59,    60,    61,    62,     0,     0,     0,
      63,    64,    65,    66,    67,     0,    68,    69,    70,     0,
      71,     0,     0,    72,    73,    74,    75,    76,    77,    78,
       0,   430,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,     0,     0,     0,    91,    92,     0,     0,
      93,    94,     0,    95,    96,    97,    98,    99,     0,   100,
     101,    58,   102,   103,   104,     0,   105,     0,     0,   106,
       0,    59,    60,    61,    62,     0,     0,     0,    63,    64,
      65,    66,    67,     0,    68,    69,    70,     0,    71,     0,
       0,    72,    73,    74,    75,    76,    77,    78,     0,   560,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,     0,     0,     0,    91,    92,     0,     0,    93,    94,
       0,    95,    96,    97,    98,    99,     0,   100,   101,    58,
     102,   103,   104,     0,   105,     0,     0,   106,     0,    59,
      60,    61,    62,     0,     0,     0,    63,    64,    65,    66,
      67,     0,    68,    69,    70,     0,    71,     0,     0,    72,
      73,    74,    75,    76,    77,    78,     0,   706,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,     0,
       0,     0,    91,    92,     0,     0,    93,    94,     0,    95,
      96,    97,    98,    99,     0,   100,   101,    58,   102,   103,
     104,     0,   105,     0,     0,   106,     0,    59,    60,    61,
      62,     0,     0,     0,    63,    64,    65,    66,    67,     0,
      68,    69,    70,     0,    71,     0,     0,    72,    73,    74,
      75,    76,    77,    78,     0,   713,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    90,     0,     0,     0,
      91,    92,     0,     0,    93,    94,     0,    95,    96,    97,
      98,    99,     0,   100,   101,    58,   102,   103,   104,     0,
     105,     0,     0,   106,     0,    59,    60,    61,    62,     0,
       0,     0,    63,    64,    65,    66,    67,     0,    68,    69,
      70,     0,    71,     0,     0,    72,    73,    74,    75,    76,
      77,    78,     0,   208,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,     0,     0,     0,    91,    92,
       0,     0,    93,    94,     0,    95,    96,    97,    98,    99,
       0,   100,   101,    58,   102,   103,   104,     0,   105,     0,
       0,   106,     0,    59,    60,    61,    62,     0,     0,     0,
      63,    64,    65,    66,    67,     0,    68,    69,    70,     0,
      71,     0,     0,    72,    73,    74,    75,    76,    77,    78,
       0,   827,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    90,     0,     0,     0,    91,    92,     0,     0,
      93,    94,     0,    95,    96,    97,    98,    99,     0,   100,
     101,    58,   102,   103,   104,     0,   105,     0,     0,   106,
       0,    59,    60,    61,    62,     0,     0,     0,    63,    64,
      65,    66,    67,     0,    68,    69,    70,     0,    71,     0,
       0,    72,    73,    74,    75,    76,    77,    78,     0,   872,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,     0,     0,     0,    91,    92,     0,     0,    93,    94,
       0,    95,    96,    97,    98,    99,     0,   100,   101,     0,
     102,   103,   104,     0,   105,     0,     0,   106,   465,   467,
     469,   471,   473,   475,   477,   479,     0,   482,   484,   486,
     488,   490,   492,   494,   496,   498,   500
};

static const yytype_int16 yycheck[] =
{
       6,   128,    35,   216,   351,    20,   151,    20,   209,   461,
     220,   221,   222,   236,   237,    30,     2,    30,     1,    34,
      24,    34,   232,   233,   515,   503,   257,   237,   238,   239,
     560,   520,    38,   280,    40,    24,    24,   783,     6,   722,
       7,    24,     6,    38,   332,    40,    24,   787,   295,   598,
     326,     0,    32,   193,     1,     1,    38,    39,   857,    38,
     859,    40,     1,   809,     1,   172,   806,     1,   175,   868,
       1,     1,    33,   213,    32,     1,   761,    24,    24,   226,
     768,    38,    39,   766,     1,   773,   309,    24,    32,   888,
      92,     1,    56,    24,     1,   780,   111,   112,   111,   112,
     115,     1,   115,   107,   327,   381,    84,     1,   110,   332,
      92,     1,   127,   128,   103,   103,   105,   327,    32,   108,
     103,   110,   332,     1,   104,   131,   315,     1,   111,    97,
     145,    98,   145,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   399,   220,   221,   302,   955,     1,   446,   174,
     906,   174,   108,   712,   111,   111,   313,   966,   107,   184,
     237,   184,   663,   107,   111,   106,   106,   108,   108,   978,
     111,   107,   249,   713,   190,   111,     3,     1,   194,   150,
     107,   438,   236,   382,   111,   190,   229,   107,   204,   194,
     107,   679,   449,   209,   417,    24,   106,    97,   214,   204,
     423,   190,     4,   107,   209,   194,   106,    32,   108,   214,
     835,   452,   237,   446,   839,   204,   212,   188,     6,   107,
     209,   237,   463,   107,     6,   214,   446,    48,   461,    31,
     307,   308,   237,   757,   311,     1,    90,    24,   778,    41,
      90,   461,   453,   742,   743,   602,    32,   771,   736,     1,
      52,    24,   306,   107,    24,   332,    38,   107,    40,   336,
      87,    88,    24,   520,   280,   106,    90,   108,    56,   894,
     286,   287,   297,    92,   297,   280,   105,    79,    48,   108,
     107,   286,   109,   107,    92,   256,   113,     3,   113,   108,
      48,   280,     8,     9,   319,   920,   319,   286,     1,   315,
     108,    32,   327,     6,   503,   276,    24,   332,     1,   111,
       6,   327,   511,     6,   169,   103,   332,   172,   105,   944,
     175,   364,   327,   948,    24,   950,   951,   332,    90,    32,
     103,    97,   105,   103,   377,   378,    32,   380,   839,    32,
     106,   103,   967,   105,    47,    48,    49,    38,    39,   131,
      60,   103,   104,    56,    47,    48,    49,    92,   103,    38,
      56,    40,   387,    56,   387,    90,   382,   810,   113,   446,
      73,    87,    88,   108,   451,    38,    39,   393,   103,    82,
      73,   106,   602,   826,   461,   103,   429,   105,   393,    82,
     898,   107,   103,   109,   895,   106,   412,   113,   108,   424,
      24,   424,   895,   103,   393,   105,    32,   412,   190,     1,
     113,   193,   194,   104,    90,     7,   924,    92,    92,   390,
     113,   446,   204,   412,    92,   682,   919,   209,    24,    24,
     446,   213,   214,   108,   108,    24,   461,   453,    92,   103,
     108,   446,   106,   936,    90,   461,    38,    39,   453,   104,
     104,   106,    31,   113,   962,    24,   461,   312,   107,   222,
     968,   969,    41,   107,   453,    60,   321,   322,   976,   232,
     233,   326,   327,   236,   237,   238,   239,   985,   107,   103,
     679,   105,   990,   222,   725,   103,   249,   503,   106,    99,
     100,   101,   274,   232,   233,   511,   107,    89,   280,   238,
     239,   963,   964,   760,   286,   287,    98,   103,   103,   105,
     105,   190,   108,   108,   103,   194,   105,   107,   741,   544,
     982,   544,   789,   790,   379,   204,   381,   382,   383,   384,
     385,   556,   687,   556,   103,   214,   105,   736,   104,   108,
     106,    16,    17,   306,   307,   308,   103,   107,   311,   106,
     742,   743,    11,    12,    13,    14,   107,    16,    17,    18,
      19,   107,     4,    92,   327,   103,   111,    97,    24,   332,
     107,   103,   689,   336,   107,    32,   107,    24,     6,   434,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   716,
     455,   280,   719,    90,    32,   108,   108,   286,   108,     7,
     809,   393,    97,    98,    99,   100,   101,   108,    48,    47,
      48,    49,    97,    98,    99,   100,   101,   106,    56,    24,
     412,   788,    91,    92,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   110,   107,    73,     6,   103,   503,   105,
     807,   106,   108,   810,    82,   792,   103,   108,   105,   108,
     108,   108,   108,   679,   680,    92,   106,   106,   105,   826,
     954,   453,   108,   957,   958,   680,   110,    24,   110,   695,
     106,   965,   698,   446,   104,   113,    48,   542,   451,   705,
     695,   680,    48,   698,   737,   108,   551,    90,   461,   898,
     705,   110,   110,   106,   988,   104,   695,   906,   103,   698,
     105,     7,   108,   108,   393,   107,   705,   874,   106,   106,
     736,   576,    90,    24,   749,   924,   749,   108,   110,   108,
     963,   964,   110,   412,    24,   590,   111,   753,   593,    24,
      90,   757,   108,   963,   964,   600,   601,    90,   753,   982,
      90,   747,   757,   107,    90,   771,   103,    24,   105,   110,
     108,   108,   982,   962,   753,   110,   771,   792,   757,   968,
     969,    38,    39,   789,   790,   108,   108,   976,   107,   804,
     107,   804,   771,   107,   789,   790,   985,   107,   813,   104,
     813,   990,   909,   809,   107,   912,    90,    90,   915,   842,
     789,   790,   103,    90,   105,    90,    40,   108,   107,   834,
     107,   834,   107,   103,   104,   105,   107,   103,   103,   835,
     105,   287,   174,   839,   874,   143,   138,   680,   718,   417,
     846,   914,   871,   840,   689,   145,   103,   104,   105,   602,
      42,   248,   749,   248,   964,   984,   701,   890,   891,   982,
     576,    53,    54,    55,   669,   593,   899,    -1,   901,   902,
     313,   716,    -1,    -1,   719,    67,    -1,    -1,    70,    -1,
      72,    -1,    74,    -1,    76,    -1,    -1,    -1,   894,    81,
      -1,    -1,   898,    -1,    86,    -1,   963,   964,    -1,   914,
     906,   914,    -1,    -1,    11,    12,    13,    14,   680,    16,
      17,    -1,    -1,    -1,   920,   982,    -1,    -1,   924,    -1,
     765,    -1,   767,   695,    -1,    -1,   698,    -1,    -1,    -1,
      -1,    -1,    -1,   705,    -1,    -1,    12,    13,   944,    -1,
      16,    17,   948,   949,   950,   951,    -1,    -1,   963,   964,
      -1,    -1,    -1,    -1,    -1,    -1,   962,   963,   964,    -1,
      -1,   967,   968,   969,    -1,    -1,    -1,   982,   963,   964,
     976,    -1,    -1,    -1,    -1,    -1,   982,    -1,   984,   985,
      -1,   753,    -1,    -1,   990,   757,    -1,   982,    95,    96,
      97,    98,    99,   100,   101,    -1,    -1,    -1,    -1,   771,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   680,    -1,    -1,    -1,    -1,    -1,   789,   790,    95,
      96,    97,    98,    99,   100,   101,   695,    -1,    -1,   698,
      -1,    -1,    -1,    -1,     0,     1,    -1,    -1,     4,    -1,
       6,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    24,    -1,
      -1,    27,    28,    -1,   909,    31,    32,   912,    -1,    35,
     915,    -1,    -1,    -1,   846,    41,    42,    43,    -1,    45,
      -1,    47,    48,    49,   753,    51,    52,    53,    54,    55,
      56,    57,    -1,    59,     1,    -1,    -1,    63,    64,     6,
     945,    67,    68,    -1,    70,    71,    72,    73,    74,    -1,
      76,    77,    -1,    79,    -1,    81,    82,    83,    25,    26,
      86,    -1,    -1,    -1,    -1,    32,    -1,    -1,    -1,    36,
      -1,    -1,    25,    26,    -1,    -1,    -1,   103,    -1,    -1,
      47,    48,    49,    36,    -1,   111,    -1,   113,    -1,    56,
      -1,    -1,    -1,    -1,    -1,    62,    -1,    -1,    65,    66,
      -1,    -1,    69,    -1,    -1,    -1,    73,    -1,    75,    62,
      -1,    78,    65,    66,    -1,    82,    69,    -1,    85,    -1,
      -1,    -1,    75,    90,    -1,    78,    -1,    -1,    -1,    -1,
      -1,    -1,    85,    -1,    -1,    -1,    -1,    90,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   113,    -1,    -1,    -1,
     963,   964,     1,    -1,    -1,    -1,     5,     6,     7,     8,
       9,    10,    -1,    -1,    -1,    -1,    15,    -1,    -1,   982,
      -1,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    -1,
      -1,    40,    41,    42,    43,    44,    45,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    61,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      -1,    80,    81,    82,    83,    -1,    85,    86,    -1,    -1,
      -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,   102,   103,    -1,    -1,    -1,   107,    -1,
     109,     1,    -1,    -1,   113,     5,     6,     7,     8,     9,
      10,    -1,    -1,    -1,    -1,    15,    -1,    -1,    -1,    -1,
      20,    21,    22,    23,    -1,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    -1,
      80,    81,    82,    83,    -1,    85,    86,    -1,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,    -1,   109,
      -1,     1,    -1,   113,     4,     5,     6,     7,     8,     9,
      10,    -1,    -1,    -1,    -1,    15,    -1,    -1,    -1,    -1,
      20,    21,    22,    23,    24,    -1,    -1,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    -1,    37,    -1,    -1,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    61,    -1,    63,    64,    -1,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    -1,    76,    77,    -1,    -1,
      80,    81,    82,    83,    84,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,    -1,   102,   103,    -1,   105,    -1,   107,    -1,   109,
       1,   111,    -1,   113,     5,     6,     7,     8,     9,    10,
      -1,    -1,    -1,    -1,    15,    -1,    -1,    -1,    -1,    20,
      21,    22,    23,    24,    -1,    -1,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      61,    -1,    63,    64,    -1,    -1,    67,    68,    -1,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    -1,    80,
      81,    82,    83,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    -1,    98,    99,    -1,
      -1,   102,    -1,    -1,    -1,    -1,   107,    -1,   109,    -1,
       1,    -1,   113,     4,     5,     6,     7,     8,     9,    10,
      -1,    -1,    -1,    -1,    15,    -1,    -1,    -1,    -1,    20,
      21,    22,    23,    -1,    -1,    -1,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    -1,    37,    -1,    -1,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      61,    -1,    63,    64,    -1,    -1,    67,    68,    -1,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    -1,    80,
      81,    82,    83,    84,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,   102,   103,    -1,    -1,    -1,   107,    -1,   109,     1,
     111,    -1,   113,     5,     6,     7,     8,     9,    10,    -1,
      -1,    -1,    -1,    15,    -1,    -1,    -1,    -1,    20,    21,
      22,    23,    24,    -1,    -1,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    -1,    37,    -1,    -1,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    61,
      -1,    63,    64,    -1,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    -1,    76,    77,    -1,    -1,    80,    81,
      82,    83,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,
     102,   103,   104,   105,    -1,   107,    -1,   109,     1,    -1,
      -1,   113,     5,     6,     7,     8,     9,    10,    -1,    -1,
      -1,    -1,    15,    -1,    -1,    -1,    -1,    20,    21,    22,
      23,    24,    -1,    -1,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    -1,    -1,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    61,    -1,
      63,    64,    -1,    -1,    67,    68,    -1,    70,    71,    72,
      73,    74,    -1,    76,    77,    -1,    -1,    80,    81,    82,
      83,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   102,
      -1,    -1,   105,    -1,   107,   108,   109,     1,    -1,    -1,
     113,     5,     6,     7,     8,     9,    10,    -1,    -1,    -1,
      -1,    15,    -1,    -1,    -1,    -1,    20,    21,    22,    23,
      24,    -1,    -1,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    -1,    37,    -1,    -1,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    61,    -1,    63,
      64,    -1,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    -1,    80,    81,    82,    83,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   102,   103,
      -1,    -1,    -1,   107,    -1,   109,     1,    -1,    -1,   113,
       5,     6,     7,     8,     9,    10,    -1,    -1,    -1,    -1,
      15,    -1,    -1,    -1,    -1,    20,    21,    22,    23,    24,
      -1,    -1,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    -1,    37,    -1,    -1,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    61,    -1,    63,    64,
      -1,    -1,    67,    68,    -1,    70,    71,    72,    73,    74,
      -1,    76,    77,    -1,    -1,    80,    81,    82,    83,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,    -1,   102,   103,    -1,
      -1,    -1,   107,    -1,   109,     1,    -1,    -1,   113,     5,
       6,     7,     8,     9,    10,    -1,    -1,    -1,    -1,    15,
      -1,    -1,    -1,    -1,    20,    21,    22,    23,    -1,    -1,
      -1,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      -1,    37,    -1,    -1,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    61,    -1,    63,    64,    -1,
      -1,    67,    68,    -1,    70,    71,    72,    73,    74,    -1,
      76,    77,    -1,    -1,    80,    81,    82,    83,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,    -1,   102,    -1,    -1,    -1,
      -1,   107,    -1,   109,     1,   111,    -1,   113,     5,     6,
       7,     8,     9,    10,    -1,    -1,    -1,    -1,    15,    -1,
      -1,    -1,    -1,    20,    21,    22,    23,    -1,    -1,    -1,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    -1,
      37,    -1,    -1,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    -1,    61,    -1,    63,    64,    -1,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    -1,    80,    81,    82,    83,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,    -1,   109,     1,    -1,    -1,   113,     5,     6,     7,
       8,     9,    10,    -1,    -1,    -1,    -1,    15,    -1,    -1,
      -1,    -1,    20,    21,    22,    23,    -1,    -1,    -1,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    -1,    37,
      -1,    -1,    40,    41,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    -1,    61,    -1,    63,    64,    -1,    -1,    67,
      68,    -1,    70,    71,    72,    73,    74,    -1,    76,    77,
      -1,    -1,    80,    81,    82,    83,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,
      98,     5,     6,     7,   102,    -1,    10,    -1,    -1,   107,
      -1,   109,    -1,    -1,    -1,   113,    20,    21,    22,    23,
      24,    -1,    -1,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    -1,    37,    -1,    -1,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    61,    -1,    63,
      64,    -1,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    -1,    80,    81,    82,    83,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     1,    -1,    -1,    -1,     5,     6,     7,    -1,    -1,
      10,   105,    -1,   107,   108,   109,    -1,    -1,    -1,   113,
      20,    21,    22,    23,    -1,    -1,    -1,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    -1,    37,    -1,    -1,
      40,    41,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    61,    -1,    63,    64,    -1,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    -1,    76,    77,    -1,    -1,
      80,    81,    82,    83,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,     5,
       6,     7,    -1,   103,    10,    -1,    -1,   107,    -1,   109,
      -1,    -1,    -1,   113,    20,    21,    22,    23,    -1,    -1,
      -1,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      -1,    37,    -1,    -1,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    -1,    61,    -1,    63,    64,    -1,
      -1,    67,    68,    -1,    70,    71,    72,    73,    74,    -1,
      76,    77,    -1,    -1,    80,    81,    82,    83,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       1,    -1,    -1,    -1,     5,     6,     7,     8,     9,    10,
      -1,   107,    -1,   109,    15,    -1,    -1,   113,    -1,    20,
      21,    22,    23,    -1,    -1,    -1,    -1,    -1,    29,    30,
      31,    32,    33,    34,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    -1,    58,    -1,    60,
      61,    -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,    70,
      -1,    72,    73,    74,    -1,    76,    -1,    -1,    -1,    80,
      81,    82,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,   107,   108,   109,     1,
      -1,   112,   113,     5,     6,     7,     8,     9,    10,    -1,
      -1,    -1,    -1,    15,    -1,    -1,    -1,    -1,    20,    21,
      22,    23,    -1,    -1,    -1,    -1,    -1,    29,    30,    31,
      32,    33,    34,    -1,    -1,    37,    -1,    -1,    40,    41,
      42,    -1,    44,    -1,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    -1,    58,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,    70,    -1,
      72,    73,    74,    -1,    76,    -1,    -1,    -1,    80,    81,
      82,    -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,   108,   109,     1,    -1,
     112,   113,     5,     6,     7,     8,     9,    10,    -1,    -1,
      -1,    -1,    15,    -1,    -1,    -1,    -1,    20,    21,    22,
      23,    -1,    -1,    -1,    -1,    -1,    29,    30,    31,    32,
      33,    34,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    -1,    58,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    67,    -1,    -1,    70,    -1,    72,
      73,    74,    -1,    76,    -1,    -1,    -1,    80,    81,    82,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,   107,   108,   109,   110,     1,    -1,
     113,    -1,     5,     6,     7,     8,     9,    10,    -1,    -1,
      -1,    -1,    15,    -1,    -1,    -1,    -1,    20,    21,    22,
      23,    24,    -1,    -1,    -1,    -1,    29,    30,    31,    32,
      33,    34,    -1,    -1,    37,    -1,    -1,    40,    41,    42,
      -1,    44,    -1,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    -1,    58,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    67,    -1,    -1,    70,    -1,    72,
      73,    74,    -1,    76,    -1,    -1,    -1,    80,    81,    82,
      -1,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,   107,    -1,   109,     1,    -1,    -1,
     113,     5,     6,     7,     8,     9,    10,    -1,    -1,    -1,
      -1,    15,    -1,    -1,    -1,    -1,    20,    21,    22,    23,
      -1,    -1,    -1,    -1,    -1,    29,    30,    31,    32,    33,
      34,    -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,
      44,    -1,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    -1,    58,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    67,    -1,    -1,    70,    -1,    72,    73,
      74,    -1,    76,    -1,    -1,    -1,    80,    81,    82,    -1,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   102,    -1,
      -1,    -1,    -1,   107,    -1,   109,     1,   111,    -1,   113,
       5,     6,     7,     8,     9,    10,    -1,    -1,    -1,    -1,
      15,    -1,    -1,    -1,    -1,    20,    21,    22,    23,    24,
      -1,    -1,    -1,    -1,    29,    30,    31,    32,    33,    34,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    -1,    58,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    67,    -1,    -1,    70,    -1,    72,    73,    74,
      -1,    76,    -1,    -1,    -1,    80,    81,    82,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,   107,    -1,   109,     1,    -1,    -1,   113,     5,
       6,     7,     8,     9,    10,    -1,    -1,    -1,    -1,    15,
      -1,    -1,    -1,    -1,    20,    21,    22,    23,    24,    -1,
      -1,    -1,    -1,    29,    30,    31,    32,    33,    34,    -1,
      -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    67,    -1,    -1,    70,    -1,    72,    73,    74,    -1,
      76,    -1,    -1,    -1,    80,    81,    82,    -1,    -1,    -1,
      86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,    -1,   102,    -1,    -1,    -1,
      -1,   107,    -1,   109,     1,    -1,    -1,   113,     5,     6,
       7,     8,     9,    10,    -1,    -1,    -1,    -1,    15,    -1,
      -1,    -1,    -1,    20,    21,    22,    23,    -1,    -1,    -1,
      -1,    -1,    29,    30,    31,    32,    33,    34,    -1,    -1,
      37,    -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      -1,    58,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      67,    -1,    -1,    70,    -1,    72,    73,    74,    -1,    76,
      -1,    -1,    -1,    80,    81,    82,    -1,    -1,    -1,    86,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,
     107,    -1,   109,     1,    -1,    -1,   113,     5,     6,     7,
       8,     9,    10,    -1,    -1,    -1,    -1,    15,    -1,    -1,
      -1,    -1,    20,    21,    22,    23,    -1,    -1,    -1,    -1,
      -1,    29,    30,    31,    32,    33,    34,    -1,    -1,    37,
      -1,    -1,    40,    41,    42,    -1,    44,    -1,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    -1,
      58,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    67,
      -1,    -1,    70,    -1,    72,    73,    74,    -1,    76,    -1,
      -1,    -1,    80,    81,    82,    -1,    -1,    -1,    86,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,
      -1,   109,     1,    -1,    -1,   113,     5,     6,     7,     8,
       9,    10,    -1,    -1,    -1,    -1,    15,    -1,    -1,    -1,
      -1,    20,    21,    22,    23,    -1,    -1,    -1,    -1,    -1,
      29,    30,    31,    32,    33,    34,    -1,    -1,    37,    -1,
      -1,    40,    41,    42,    -1,    44,    -1,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    -1,    58,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    67,    -1,
      -1,    70,    -1,    72,    73,    74,    -1,    76,    -1,    -1,
      -1,    80,    81,    82,    -1,    -1,    -1,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    -1,    -1,   102,    -1,    -1,    -1,    -1,   107,    -1,
     109,     1,    -1,    -1,   113,     5,     6,     7,     8,     9,
      10,    -1,    -1,    -1,    -1,    15,    -1,    -1,    -1,    -1,
      20,    21,    22,    23,    -1,    -1,    -1,    -1,    -1,    29,
      30,    31,    32,    33,    34,    -1,    -1,    37,    -1,    -1,
      40,    41,    42,    -1,    44,    -1,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    -1,    58,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,
      70,    -1,    72,    73,    74,    -1,    76,    -1,    -1,    -1,
      80,    81,    82,    -1,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,    -1,   102,    -1,    -1,    -1,    -1,   107,    -1,   109,
       1,    -1,    -1,   113,     5,     6,     7,     8,     9,    10,
      -1,    -1,    -1,    -1,    15,    -1,    -1,    -1,    -1,    20,
      21,    22,    23,    -1,    -1,    -1,    -1,    -1,    29,    30,
      31,    32,    33,    34,    -1,    -1,    37,    -1,    -1,    40,
      41,    42,    -1,    44,    -1,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    -1,    58,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    67,    -1,    -1,    70,
      -1,    72,    73,    74,    -1,    76,    -1,    -1,    -1,    80,
      81,    82,    -1,    -1,     1,    86,    -1,     4,    -1,     6,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,   107,    24,   109,    -1,
      27,    28,   113,    -1,    31,    32,    -1,    -1,    35,    -1,
      -1,    -1,    -1,    -1,    41,    42,    43,    -1,    45,    -1,
      47,    48,    49,    -1,    51,    52,    53,    54,    55,    56,
      57,    -1,    59,    -1,    -1,    -1,    63,    64,    -1,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    -1,    76,
      77,    -1,    79,    -1,    81,    82,    83,    -1,    -1,    86,
      -1,    -1,     1,    -1,    -1,     4,    -1,     6,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   103,    -1,   105,    -1,
      -1,    -1,    -1,    -1,   111,    24,   113,    -1,    27,    28,
      -1,    -1,    31,    32,    -1,    -1,    35,    -1,    -1,    -1,
      -1,    -1,    41,    42,    43,    -1,    45,    -1,    47,    48,
      49,    -1,    51,    52,    53,    54,    55,    56,    57,    -1,
      59,    -1,    -1,    -1,    63,    64,    -1,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    -1,    76,    77,    -1,
      79,    -1,    81,    82,    83,    -1,    -1,    86,     1,    -1,
      -1,    -1,     5,     6,     7,     8,     9,    -1,    -1,    -1,
      -1,    -1,    15,    -1,   103,    -1,   105,    -1,    21,    22,
      -1,    -1,   111,    -1,   113,    -1,    -1,    -1,    31,    32,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    41,    -1,
      -1,    -1,    -1,    46,    47,    48,    49,    -1,    -1,    -1,
      -1,    54,    -1,    56,    -1,    58,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,
      73,     5,     6,     7,     8,     9,    -1,    80,    -1,    82,
      -1,    15,    -1,    -1,    -1,    -1,    -1,    21,    22,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    31,    32,   102,
      -1,    -1,    -1,    -1,   107,    -1,   109,    41,    -1,    -1,
     113,    -1,    46,    47,    48,    49,    -1,    -1,    -1,    -1,
      54,    -1,    56,    -1,    58,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    73,
       5,     6,     7,     8,     9,    -1,    80,    -1,    82,    -1,
      15,    -1,    -1,    -1,    -1,    -1,    21,    22,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    31,    32,   102,    -1,
      -1,    -1,    -1,   107,    -1,   109,    41,    -1,    -1,   113,
      -1,    46,    47,    48,    49,    -1,    -1,    -1,    -1,    54,
      -1,    56,    -1,    58,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    73,     5,
       6,     7,     8,     9,    -1,    80,    -1,    82,    -1,    15,
      -1,    -1,    -1,    -1,    -1,    21,    22,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    31,    32,   102,    -1,    -1,
      -1,    -1,   107,    -1,   109,    41,    -1,    -1,   113,    -1,
      46,    47,    48,    49,    -1,    -1,    -1,    -1,    54,    -1,
      56,    -1,    58,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     1,    -1,    -1,    73,     5,     6,
       7,     8,     9,    -1,    80,    -1,    82,    -1,    15,    -1,
      -1,    -1,    -1,    -1,    21,    22,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    31,    32,   102,    -1,    -1,    -1,
      -1,   107,    -1,   109,    41,    -1,    -1,   113,    -1,    46,
      47,    48,    49,    -1,    -1,    -1,    -1,    54,    -1,    56,
      -1,    58,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     1,    -1,    -1,    73,     5,     6,     7,
       8,     9,    -1,    80,    -1,    82,    -1,    15,    -1,    -1,
      -1,    -1,    -1,    21,    22,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    31,    32,   102,    -1,    -1,    -1,    -1,
     107,    -1,   109,    41,    -1,    -1,   113,    -1,    46,    47,
      48,    49,    -1,    -1,    -1,    -1,    54,    -1,    56,    -1,
      58,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     1,    -1,    -1,    73,     5,     6,     7,     8,
       9,    -1,    80,    -1,    82,    -1,    15,    -1,    -1,    -1,
      -1,    -1,    21,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    31,    32,   102,    -1,    -1,    -1,    -1,   107,
      -1,   109,    41,    -1,    -1,   113,    -1,    46,    47,    48,
      49,    -1,    -1,    -1,    -1,    54,    -1,    56,    -1,    58,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     1,    -1,    -1,    73,     5,     6,     7,     8,     9,
      -1,    80,    -1,    82,    -1,    15,    -1,    -1,    -1,    -1,
      -1,    21,    22,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    31,    32,   102,    -1,    -1,    -1,    -1,   107,    -1,
     109,    41,    -1,    -1,   113,    -1,    46,    47,    48,    49,
      -1,    -1,    -1,    -1,    54,    -1,    56,    -1,    58,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       1,    -1,    -1,    73,     5,     6,     7,     8,     9,    -1,
      80,    -1,    82,    -1,    15,    -1,    -1,    -1,    -1,    -1,
      21,    22,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      31,    32,   102,    -1,    -1,    -1,    -1,   107,    -1,   109,
      41,    -1,    -1,   113,    -1,    46,    47,    48,    49,    -1,
      -1,    -1,    -1,    54,    -1,    56,    -1,    58,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,
      -1,    -1,    73,     5,     6,     7,     8,     9,    -1,    80,
      -1,    82,    -1,    15,    -1,    -1,    -1,    -1,    -1,    21,
      22,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    31,
      32,   102,    -1,    -1,    -1,    -1,   107,    -1,   109,    41,
      -1,    -1,   113,    -1,    46,    47,    48,    49,    -1,    -1,
      -1,    -1,    54,    -1,    56,    -1,    58,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,
      -1,    73,     5,     6,     7,     8,     9,    -1,    80,    -1,
      82,    -1,    15,    -1,    -1,    -1,    -1,    -1,    21,    22,
      -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,    31,    32,
     102,    -1,    -1,    -1,    -1,   107,    -1,   109,    41,    -1,
      -1,   113,    -1,    46,    47,    48,    49,    -1,    -1,    -1,
      -1,    54,    -1,    56,    -1,    58,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,
      73,     5,     6,     7,     8,     9,    -1,    80,    -1,    82,
      -1,    15,    -1,    -1,    -1,    -1,    -1,    21,    22,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    31,    32,   102,
      -1,    -1,    -1,    -1,   107,    -1,   109,    41,    -1,    -1,
     113,    -1,    46,    47,    48,    49,    -1,    -1,    -1,    -1,
      54,    -1,    56,    -1,    58,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    73,
       5,     6,     7,     8,     9,    -1,    80,    -1,    82,    -1,
      15,    -1,    -1,    -1,    -1,    -1,    21,    22,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    31,    32,   102,    -1,
      -1,    -1,    -1,   107,    -1,   109,    41,    -1,    -1,   113,
      -1,    46,    47,    48,    49,    -1,    -1,    -1,    -1,    54,
      -1,    56,    -1,    58,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    73,     5,
       6,     7,     8,     9,    -1,    80,    -1,    82,    -1,    15,
      -1,    -1,    -1,    -1,    -1,    21,    22,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    31,    32,   102,    -1,    -1,
      -1,    -1,   107,    -1,   109,    41,    -1,    -1,   113,    -1,
      46,    47,    48,    49,    -1,    -1,    -1,    -1,    54,    -1,
      56,    -1,    58,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     1,    -1,    -1,    73,     5,     6,
       7,     8,     9,    -1,    80,    -1,    82,    -1,    15,    -1,
      -1,    -1,    -1,    -1,    21,    22,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    31,    32,   102,    -1,    -1,    -1,
      -1,   107,    -1,   109,    41,    -1,    -1,   113,    -1,    46,
      47,    48,    49,    -1,    -1,    -1,    -1,    54,    -1,    56,
      -1,    58,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     1,    -1,    -1,    73,     5,     6,     7,
       8,     9,    -1,    80,    -1,    82,    -1,    15,    -1,    -1,
      -1,    -1,    -1,    21,    22,    -1,    -1,    -1,    -1,    -1,
      -1,    98,    -1,    31,    32,   102,    -1,    -1,    -1,    -1,
     107,    -1,   109,    41,    -1,    -1,   113,    -1,    46,    47,
      48,    49,    -1,    -1,    -1,    -1,    54,    -1,    56,    -1,
      58,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     1,    -1,    -1,    73,     5,     6,     7,     8,
       9,    -1,    80,    -1,    82,    -1,    15,    -1,    -1,    -1,
      -1,    -1,    21,    22,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    31,    32,   102,    -1,    -1,    -1,    -1,   107,
      -1,   109,    41,    -1,    -1,   113,    -1,    46,    47,    48,
      49,    -1,    -1,    -1,    -1,    54,    -1,    56,    -1,    58,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     1,    -1,    -1,    73,     5,     6,     7,     8,     9,
      -1,    80,    -1,    82,    -1,    15,    -1,    -1,    -1,    -1,
      -1,    21,    22,    -1,    -1,    -1,    -1,    -1,    -1,    98,
      -1,    31,    32,   102,    -1,    27,    28,    -1,   107,    -1,
     109,    41,    -1,    35,   113,    -1,    46,    47,    48,    49,
      -1,    43,    -1,    45,    54,    -1,    56,    -1,    58,    -1,
      -1,    61,    -1,    -1,    -1,    57,    -1,    59,    -1,    -1,
       1,    63,    64,    73,    -1,     6,    68,    -1,    -1,    71,
      80,    -1,    82,    -1,    -1,    77,    -1,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,     1,    27,    28,    98,    -1,
      -1,    32,   102,    -1,    35,    -1,    -1,   107,    -1,   109,
      -1,    -1,    43,   113,    45,    -1,    47,    48,    49,    25,
      26,    -1,    -1,    -1,    -1,    56,    57,    -1,    59,    -1,
      36,    -1,    63,    64,    -1,    -1,    -1,    68,    -1,     1,
      71,    -1,    73,    -1,     6,    -1,    77,    -1,    -1,    -1,
      -1,    82,    83,    -1,    -1,    -1,    62,    -1,    -1,    65,
      66,    -1,    -1,    69,    -1,    27,    28,    -1,    -1,    75,
      32,    -1,    78,    35,    -1,    -1,    -1,   108,    -1,    85,
      -1,    43,   113,    45,    90,    47,    48,    49,    -1,    -1,
      -1,     1,    -1,    -1,    56,    57,     6,    59,    -1,    -1,
     106,    63,    64,    -1,   110,    -1,    68,    -1,    -1,    71,
      -1,    73,    -1,    -1,    -1,    77,    -1,    27,    28,    -1,
      82,    83,    32,    -1,    -1,    35,    11,    12,    13,    14,
      -1,    16,    17,    43,    -1,    45,    -1,    47,    48,    49,
      -1,    -1,    -1,    -1,    -1,    -1,    56,    57,    -1,    59,
      -1,   113,    -1,    63,    64,    -1,    -1,    -1,    68,    -1,
      -1,    71,    -1,    73,    -1,    -1,    -1,    77,    -1,     3,
      -1,    -1,    82,    83,     8,     9,    -1,    11,    12,    13,
      14,    -1,    16,    17,    18,    19,    -1,    -1,    -1,    -1,
      24,    25,    26,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    36,   113,    38,    39,    -1,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,    -1,    -1,    11,
      12,    13,    14,    -1,    16,    17,    -1,    -1,    62,    -1,
      -1,    65,    66,    -1,    -1,    69,    -1,    -1,    -1,    -1,
      -1,    75,    -1,    -1,    78,    -1,    -1,    -1,    -1,    -1,
      -1,    85,    -1,    87,    88,    -1,    90,    91,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,    -1,   103,
     104,   105,   106,   107,   108,   109,   110,     3,    -1,   113,
      -1,    -1,     8,     9,    -1,    -1,    -1,    -1,    -1,     1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,
      26,    93,    94,    95,    96,    97,    98,    99,   100,   101,
      36,    -1,    24,    25,    26,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    36,    11,    12,    13,    14,    -1,
      16,    17,    18,    -1,    -1,    -1,    62,    -1,    -1,    65,
      66,    -1,    -1,    69,    -1,    -1,    -1,    -1,    -1,    75,
      62,    -1,    78,    65,    66,    -1,    -1,    69,    -1,    85,
      -1,    87,    88,    75,    90,    -1,    78,    -1,    -1,    -1,
      -1,    -1,    -1,    85,    -1,    -1,    -1,    -1,    90,    -1,
     106,   107,    -1,   109,   110,    -1,    -1,   113,    -1,    -1,
      -1,   103,    -1,   105,   106,   107,   108,     3,   110,   111,
      -1,    -1,     8,     9,    -1,    -1,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,    -1,    -1,    -1,    25,
      26,    -1,    -1,    -1,    -1,    -1,    -1,    25,    26,    -1,
      36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    36,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    62,    -1,    -1,    65,
      66,    -1,    -1,    69,    62,    -1,    -1,    65,    66,    75,
      -1,    69,    78,    -1,    -1,    -1,    -1,    75,    -1,    85,
      78,    87,    88,    -1,    90,    -1,    -1,    85,    -1,    -1,
      -1,    -1,    90,    -1,     5,     6,     7,     8,     9,    10,
      -1,   107,    -1,   109,    15,    -1,   104,   113,    -1,    20,
      21,    22,    23,    24,    -1,    -1,    27,    28,    29,    30,
      -1,    32,    33,    34,    35,    -1,    37,    38,    39,    40,
      -1,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      61,    -1,    63,    64,    -1,    -1,    67,    68,    -1,    70,
      71,    72,    73,    74,    -1,    76,    77,    -1,    -1,    80,
      81,    82,    83,    -1,    -1,    86,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    96,    -1,    98,    -1,    -1,
      -1,   102,    -1,    -1,    -1,    -1,   107,    -1,   109,    -1,
      -1,    -1,   113,     5,     6,     7,     8,     9,    10,    -1,
      -1,    -1,    -1,    15,    -1,    -1,    -1,    -1,    20,    21,
      22,    23,    24,    -1,    -1,    27,    28,    29,    30,    -1,
      32,    33,    34,    35,    -1,    37,    -1,    -1,    40,    -1,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    61,
      -1,    63,    64,    -1,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    -1,    76,    77,    -1,    -1,    80,    81,
      82,    83,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    96,    -1,    98,    -1,    -1,    -1,
     102,    -1,    -1,    -1,    -1,   107,    -1,   109,   110,    -1,
      -1,   113,     5,     6,     7,     8,     9,    10,    -1,    -1,
      -1,    -1,    15,    -1,    -1,    -1,    -1,    20,    21,    22,
      23,    -1,    -1,    -1,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    -1,    37,    -1,    -1,    40,    41,    42,
      43,    44,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    61,    -1,
      63,    64,    -1,    -1,    67,    68,    -1,    70,    71,    72,
      73,    74,    -1,    76,    77,    -1,    -1,    80,    81,    82,
      83,    -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   102,
      -1,    -1,    -1,    -1,   107,    -1,   109,    -1,    -1,    -1,
     113,     5,     6,     7,     8,     9,    10,    -1,    -1,    -1,
      -1,    15,    -1,    -1,    -1,    -1,    20,    21,    22,    23,
      24,    -1,    -1,    27,    28,    29,    30,    -1,    32,    33,
      34,    35,    -1,    37,    -1,    -1,    40,    -1,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    -1,    61,    -1,    63,
      64,    -1,    -1,    67,    68,    -1,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    -1,    80,    81,    82,    83,
      -1,    -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,     5,     6,     7,   102,    -1,
      10,    -1,    -1,   107,    -1,   109,    -1,    -1,    -1,   113,
      20,    21,    22,    23,    -1,    -1,    -1,    27,    28,    29,
      30,    -1,    32,    33,    34,    35,    -1,    37,    -1,    -1,
      40,    -1,    42,    43,    44,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      -1,    61,    -1,    63,    64,    -1,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    -1,    76,    77,    -1,    -1,
      80,    81,    82,    83,    -1,    -1,    86,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       5,     6,     7,     8,     9,    10,    -1,   107,    -1,   109,
      15,    -1,    -1,   113,    -1,    20,    21,    22,    23,    -1,
      -1,    -1,    -1,    -1,    29,    30,    31,    32,    33,    34,
      -1,    -1,    37,    -1,    -1,    40,    41,    42,    -1,    44,
      -1,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    -1,    58,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    67,    -1,    -1,    70,    -1,    72,    73,    74,
      -1,    76,    -1,    -1,    -1,    80,    81,    82,    -1,    -1,
      -1,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,    -1,    -1,    -1,   102,    -1,    -1,
      -1,    -1,   107,    -1,   109,    -1,    -1,   112,   113,     5,
       6,     7,     8,     9,    10,    -1,    -1,    -1,    -1,    15,
      -1,    -1,    -1,    -1,    20,    21,    22,    23,    -1,    -1,
      -1,    -1,    -1,    29,    30,    -1,    32,    33,    34,    -1,
      -1,    37,    -1,    -1,    40,    -1,    42,    -1,    44,    -1,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    -1,    58,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    67,    -1,    -1,    70,    -1,    72,    73,    74,    -1,
      76,    -1,    -1,    -1,    80,    81,    82,    -1,    -1,    -1,
      86,     5,     6,     7,     8,     9,    -1,    -1,    -1,    -1,
      -1,    15,    98,    -1,    -1,    -1,   102,    21,    22,    -1,
      -1,   107,    -1,   109,     5,     6,     7,   113,    32,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      21,    22,    46,    47,    48,    49,    -1,    -1,    -1,    -1,
      54,    32,    56,    -1,    58,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    47,    48,    49,    73,
      -1,    -1,    -1,    54,    -1,    56,    80,    58,    82,    -1,
      61,    -1,    -1,    -1,    -1,    -1,     6,    -1,    -1,    -1,
      -1,    -1,    73,    -1,    98,    -1,    -1,    -1,   102,    80,
      -1,    82,    -1,   107,    -1,   109,    -1,    27,    28,   113,
      -1,    -1,    32,    -1,    -1,    35,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    43,    -1,    45,   107,    47,    48,    49,
      -1,    -1,   113,    -1,    -1,    -1,    56,    57,     6,    59,
      -1,    -1,    -1,    63,    64,    -1,    -1,    -1,    68,    -1,
      -1,    71,    -1,    73,    -1,    -1,    -1,    77,    -1,    27,
      28,    -1,    82,    83,    32,    -1,    -1,    35,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    43,    -1,    45,    -1,    47,
      48,    49,    -1,    -1,    -1,    -1,   106,    -1,    56,    57,
       6,    59,    -1,   113,    -1,    63,    64,    -1,    -1,    -1,
      68,    -1,    -1,    71,    -1,    73,    -1,    -1,    -1,    77,
      -1,    27,    28,    -1,    82,    83,    32,    -1,    -1,    35,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    43,    -1,    45,
      -1,    47,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,
      56,    57,    -1,    59,    -1,   113,    -1,    63,    64,    -1,
      -1,     1,    68,    -1,    -1,    71,    -1,    73,    -1,    -1,
      10,    77,    -1,    -1,    -1,    -1,    82,    83,    -1,    -1,
      20,    21,    22,    23,    24,    -1,    -1,    27,    28,    29,
      30,    31,    -1,    33,    34,    35,    -1,    37,    -1,    -1,
      40,    41,    42,    43,    44,    45,    46,   113,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
       1,    -1,    -1,    63,    64,    -1,    -1,    67,    68,    -1,
      70,    71,    72,    73,    74,    -1,    76,    77,    -1,    79,
      80,    81,    -1,    83,    25,    26,    86,    11,    12,    13,
      14,    -1,    16,    17,    -1,    36,    -1,    -1,    25,    26,
      -1,    -1,    -1,    -1,    -1,   105,   106,    -1,    -1,    36,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    62,    -1,    -1,    65,    66,    -1,    -1,    69,    -1,
      -1,    -1,    -1,    -1,    75,    62,    -1,    78,    65,    66,
      -1,    -1,    69,    -1,    85,    -1,    -1,    -1,    75,    90,
      -1,    78,    -1,    -1,    -1,    -1,    -1,    -1,    85,     1,
      -1,    -1,     4,    90,    -1,    -1,    -1,    -1,    10,    -1,
      94,    95,    96,    97,    98,    99,   100,   101,    20,    21,
      22,    23,    -1,    -1,    -1,    27,    28,    29,    30,    31,
      -1,    33,    34,    35,    -1,    37,    -1,    -1,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    -1,    -1,
      -1,    63,    64,    -1,    -1,    67,    68,    -1,    70,    71,
      72,    73,    74,    -1,    76,    77,    -1,    79,    80,    81,
       1,    83,    84,    -1,    86,     6,    -1,    -1,    -1,    10,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    20,
      21,    22,    23,    -1,    -1,    -1,    27,    28,    29,    30,
      31,    -1,    33,    34,    35,    -1,    37,    -1,    -1,    40,
      41,    42,    43,    44,    45,    46,    -1,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    63,    64,    -1,    -1,    67,    68,     1,    70,
      71,    72,    73,    74,    -1,    76,    77,    10,    79,    80,
      81,    -1,    83,    -1,    -1,    86,    -1,    20,    21,    22,
      23,    -1,    -1,    -1,    27,    28,    29,    30,    31,    -1,
      33,    34,    35,    -1,    37,    -1,    -1,    40,    41,    42,
      43,    44,    45,    46,    -1,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      63,    64,    -1,    -1,    67,    68,     1,    70,    71,    72,
      73,    74,    -1,    76,    77,    10,    79,    80,    81,    -1,
      83,    -1,    -1,    86,    -1,    20,    21,    22,    23,    -1,
      -1,    -1,    27,    28,    29,    30,    31,    -1,    33,    34,
      35,    -1,    37,    -1,    -1,    40,    41,    42,    43,    44,
      45,    46,    -1,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    63,    64,
      -1,    -1,    67,    68,     1,    70,    71,    72,    73,    74,
      -1,    76,    77,    10,    79,    80,    81,    -1,    83,    -1,
      -1,    86,    -1,    20,    21,    22,    23,    -1,    -1,    -1,
      27,    28,    29,    30,    31,    -1,    33,    34,    35,    -1,
      37,    -1,    -1,    40,    41,    42,    43,    44,    45,    46,
      -1,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    -1,    -1,    -1,    63,    64,    -1,    -1,
      67,    68,     1,    70,    71,    72,    73,    74,    -1,    76,
      77,    10,    79,    80,    81,    -1,    83,    -1,    -1,    86,
      -1,    20,    21,    22,    23,    -1,    -1,    -1,    27,    28,
      29,    30,    31,    -1,    33,    34,    35,    -1,    37,    -1,
      -1,    40,    41,    42,    43,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    -1,    -1,    63,    64,    -1,    -1,    67,    68,
       1,    70,    71,    72,    73,    74,    -1,    76,    77,    10,
      79,    80,    81,    -1,    83,    -1,    -1,    86,    -1,    20,
      21,    22,    23,    -1,    -1,    -1,    27,    28,    29,    30,
      31,    -1,    33,    34,    35,    -1,    37,    -1,    -1,    40,
      41,    42,    43,    44,    45,    46,    -1,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    63,    64,    -1,    -1,    67,    68,     1,    70,
      71,    72,    73,    74,    -1,    76,    77,    10,    79,    80,
      81,    -1,    83,    -1,    -1,    86,    -1,    20,    21,    22,
      23,    -1,    -1,    -1,    27,    28,    29,    30,    31,    -1,
      33,    34,    35,    -1,    37,    -1,    -1,    40,    41,    42,
      43,    44,    45,    46,    -1,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      63,    64,    -1,    -1,    67,    68,    -1,    70,    71,    72,
      73,    74,    -1,    76,    77,    10,    79,    80,    81,    -1,
      83,    -1,    -1,    86,    -1,    20,    21,    22,    23,    -1,
      -1,    -1,    27,    28,    29,    30,    31,    -1,    33,    34,
      35,    -1,    37,    -1,    -1,    40,    41,    42,    43,    44,
      45,    46,    -1,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    63,    64,
      -1,    -1,    67,    68,    -1,    70,    71,    72,    73,    74,
      -1,    76,    77,    10,    79,    80,    81,    -1,    83,    -1,
      -1,    86,    -1,    20,    21,    22,    23,    92,    -1,    -1,
      27,    28,    29,    30,    31,    -1,    33,    34,    35,    -1,
      37,    -1,    -1,    40,    41,    42,    43,    44,    45,    46,
      -1,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    -1,    -1,    -1,    63,    64,    -1,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    -1,    76,
      77,    10,    79,    80,    81,    -1,    83,    -1,    -1,    86,
      -1,    20,    21,    22,    23,    -1,    -1,    -1,    27,    28,
      29,    30,    31,    -1,    33,    34,    35,    -1,    37,    -1,
      -1,    40,    41,    42,    43,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    -1,    -1,    63,    64,    -1,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    -1,    76,    77,    10,
      79,    80,    81,    -1,    83,    -1,    -1,    86,    -1,    20,
      21,    22,    23,    -1,    -1,    -1,    27,    28,    29,    30,
      31,    -1,    33,    34,    35,    -1,    37,    -1,    -1,    40,
      41,    42,    43,    44,    45,    46,    -1,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    63,    64,    -1,    -1,    67,    68,    -1,    70,
      71,    72,    73,    74,    -1,    76,    77,    10,    79,    80,
      81,    -1,    83,    -1,    -1,    86,    -1,    20,    21,    22,
      23,    -1,    -1,    -1,    27,    28,    29,    30,    31,    -1,
      33,    34,    35,    -1,    37,    -1,    -1,    40,    41,    42,
      43,    44,    45,    46,    -1,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      63,    64,    -1,    -1,    67,    68,    -1,    70,    71,    72,
      73,    74,    -1,    76,    77,    10,    79,    80,    81,    -1,
      83,    -1,    -1,    86,    -1,    20,    21,    22,    23,    -1,
      -1,    -1,    27,    28,    29,    30,    31,    -1,    33,    34,
      35,    -1,    37,    -1,    -1,    40,    41,    42,    43,    44,
      45,    46,    -1,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    63,    64,
      -1,    -1,    67,    68,    -1,    70,    71,    72,    73,    74,
      -1,    76,    77,    10,    79,    80,    81,    -1,    83,    -1,
      -1,    86,    -1,    20,    21,    22,    23,    -1,    -1,    -1,
      27,    28,    29,    30,    31,    -1,    33,    34,    35,    -1,
      37,    -1,    -1,    40,    41,    42,    43,    44,    45,    46,
      -1,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    -1,    -1,    -1,    63,    64,    -1,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    -1,    76,
      77,    10,    79,    80,    81,    -1,    83,    -1,    -1,    86,
      -1,    20,    21,    22,    23,    -1,    -1,    -1,    27,    28,
      29,    30,    31,    -1,    33,    34,    35,    -1,    37,    -1,
      -1,    40,    41,    42,    43,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    -1,    -1,    63,    64,    -1,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    -1,    76,    77,    10,
      79,    80,    81,    -1,    83,    -1,    -1,    86,    -1,    20,
      21,    22,    23,    -1,    -1,    -1,    27,    28,    29,    30,
      31,    -1,    33,    34,    35,    -1,    37,    -1,    -1,    40,
      41,    42,    43,    44,    45,    46,    -1,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    -1,
      -1,    -1,    63,    64,    -1,    -1,    67,    68,    -1,    70,
      71,    72,    73,    74,    -1,    76,    77,    10,    79,    80,
      81,    -1,    83,    -1,    -1,    86,    -1,    20,    21,    22,
      23,    -1,    -1,    -1,    27,    28,    29,    30,    31,    -1,
      33,    34,    35,    -1,    37,    -1,    -1,    40,    41,    42,
      43,    44,    45,    46,    -1,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    -1,    -1,    -1,
      63,    64,    -1,    -1,    67,    68,    -1,    70,    71,    72,
      73,    74,    -1,    76,    77,    10,    79,    80,    81,    -1,
      83,    -1,    -1,    86,    -1,    20,    21,    22,    23,    -1,
      -1,    -1,    27,    28,    29,    30,    31,    -1,    33,    34,
      35,    -1,    37,    -1,    -1,    40,    41,    42,    43,    44,
      45,    46,    -1,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    -1,    -1,    -1,    63,    64,
      -1,    -1,    67,    68,    -1,    70,    71,    72,    73,    74,
      -1,    76,    77,    10,    79,    80,    81,    -1,    83,    -1,
      -1,    86,    -1,    20,    21,    22,    23,    -1,    -1,    -1,
      27,    28,    29,    30,    31,    -1,    33,    34,    35,    -1,
      37,    -1,    -1,    40,    41,    42,    43,    44,    45,    46,
      -1,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    59,    -1,    -1,    -1,    63,    64,    -1,    -1,
      67,    68,    -1,    70,    71,    72,    73,    74,    -1,    76,
      77,    10,    79,    80,    81,    -1,    83,    -1,    -1,    86,
      -1,    20,    21,    22,    23,    -1,    -1,    -1,    27,    28,
      29,    30,    31,    -1,    33,    34,    35,    -1,    37,    -1,
      -1,    40,    41,    42,    43,    44,    45,    46,    -1,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    -1,    -1,    -1,    63,    64,    -1,    -1,    67,    68,
      -1,    70,    71,    72,    73,    74,    -1,    76,    77,    -1,
      79,    80,    81,    -1,    83,    -1,    -1,    86,   343,   344,
     345,   346,   347,   348,   349,   350,    -1,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   115,   116,     0,     1,    24,    51,   103,   123,   124,
     127,   138,   155,   156,   245,    24,   103,   105,     1,     6,
      32,    47,    48,    49,    56,    73,    82,   113,   298,   299,
     300,   301,   312,   313,     4,    31,    41,    52,    79,   111,
     158,   233,   241,    42,    53,    54,    55,    67,    70,    72,
      74,    76,    81,    86,   149,    24,   103,   105,    10,    20,
      21,    22,    23,    27,    28,    29,    30,    31,    33,    34,
      35,    37,    40,    41,    42,    43,    44,    45,    46,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    63,    64,    67,    68,    70,    71,    72,    73,    74,
      76,    77,    79,    80,    81,    83,    86,   316,   317,    32,
     113,    32,    32,    48,   103,   113,    32,     1,    48,   316,
     103,   312,     1,    48,   125,   126,   316,   195,   242,     1,
     121,   122,    27,    28,    35,    43,    45,    57,    59,    63,
      64,    68,    71,    77,    83,   166,   168,   169,   170,   298,
     313,   142,    28,    35,   129,   157,   163,   166,    48,    48,
     316,    48,   316,     1,    48,   316,    32,    32,    24,    90,
     103,   105,    90,   103,   106,    90,    48,   144,   316,   144,
      24,   103,   105,     1,   104,   118,   119,   298,   313,   314,
     107,   185,     1,   107,   107,   107,   179,   107,   174,   185,
     107,   186,   176,   177,   107,   178,   174,   175,    48,    92,
     236,   316,   116,   107,   107,     4,   137,     1,     5,     7,
       8,     9,    15,    21,    22,    24,    46,    54,    58,    61,
      73,    80,    98,   102,   107,   109,   130,   134,   160,   161,
     220,   252,   280,   281,   289,   290,   291,   294,   295,   296,
     297,   298,   303,   304,   306,   308,   313,   317,   252,     1,
     125,   252,   234,   111,    24,   103,   105,     1,     6,    48,
     117,   315,   316,   103,    97,   166,   313,   314,     1,   166,
     180,     1,     7,    89,    98,   172,   187,   107,     1,   166,
     168,   103,    24,   105,   133,   314,   108,   159,   190,   191,
      21,    22,    46,    54,    58,    80,   130,   296,   296,   134,
     290,   296,   107,   307,     1,   107,   111,   196,   305,    32,
     195,   195,   107,   290,   290,     1,   111,   134,   167,   169,
     278,   280,   134,   162,   167,   170,   296,   298,   309,   310,
     317,   290,   290,    11,    12,    13,    14,    16,    17,    18,
      19,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   233,   241,     3,     8,     9,    25,    26,    36,
      62,    65,    66,    69,    75,    78,    85,    87,    88,    90,
     113,   130,   134,   282,    90,   282,   235,   243,     6,    97,
     313,   108,     1,   106,   108,   108,   106,   166,   182,   183,
     283,   108,   108,     7,    38,    39,   173,   166,   119,   120,
     108,   108,   106,   283,    48,   316,   103,   106,   167,     1,
     280,   305,     1,   164,   165,   167,   170,   277,   278,   197,
      48,   316,   219,     1,   112,   279,   280,   284,   285,     1,
     280,    24,   103,   105,   108,   284,   134,   280,   286,   287,
     288,   296,   317,    92,   108,   106,   108,   167,   310,    48,
     110,   106,   311,   110,     1,   289,     1,   289,     1,   289,
       1,   289,     1,   289,     1,   289,     1,   289,     1,   289,
     281,     1,   289,     1,   289,     1,   289,     1,   289,     1,
     289,     1,   289,     1,   289,     1,   289,     1,   289,     1,
     289,   195,   195,   195,     1,   280,   195,     1,   284,     1,
      24,    96,    99,   277,   280,   302,     1,   280,   280,   280,
     107,   230,     1,   236,   238,   240,     6,   108,   166,    38,
      39,   143,   106,   283,     7,    98,   171,   104,   108,   108,
      90,   136,    90,   141,   159,   191,    24,   103,   105,   108,
       1,   106,    24,   103,   105,   108,   159,   193,   203,   225,
      48,   194,   204,   223,   316,   108,   195,   218,    24,    60,
     103,   105,   108,   280,    60,   108,   106,   283,    24,   103,
     105,   108,   108,   105,   132,   310,    24,   103,   104,   105,
     271,   110,   135,   106,   283,   168,   280,   110,   309,     1,
      90,   282,   104,     1,     4,    10,    20,    21,    22,    23,
      27,    28,    29,    30,    31,    33,    34,    35,    37,    40,
      41,    42,    43,    44,    45,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    63,
      64,    67,    68,    70,    71,    72,    73,    74,    76,    77,
      79,    80,    81,    83,    84,    86,   150,   151,   152,   153,
     154,    48,   280,   302,    48,    24,   103,   105,   108,   108,
      24,   103,   105,   108,   110,    24,   277,   110,   110,   173,
     155,   227,   228,   229,   283,     1,    24,   111,   231,    90,
     237,   106,   244,   108,   104,   184,     7,   108,   188,     1,
      24,   192,     1,   107,   280,   107,    48,   316,    24,   103,
     105,   108,   280,    48,   316,   106,    90,   218,   106,    90,
     198,     1,   221,   279,   108,   110,     1,   280,   108,     1,
     288,   311,   280,   280,   281,   110,   173,   111,   292,   292,
     302,   129,   104,   106,   283,   108,   131,   116,   252,   239,
      24,   105,   200,   181,   166,   166,   280,   139,   145,   147,
     148,   166,   283,     1,   311,    90,   218,    90,   202,   252,
       1,   107,   146,   202,   252,   199,   146,   302,   195,   110,
     159,   227,   227,   232,   238,   166,   189,   147,   108,   104,
     106,   283,   143,    24,   103,   105,   108,   108,     1,    24,
     280,     1,   146,   280,   159,   193,   147,   224,   193,   208,
     222,   110,   218,   143,   200,   108,   108,   131,     1,    24,
     103,   128,   196,   145,   145,   144,   226,    48,   131,     1,
      24,   196,   201,     1,     4,    10,    20,    23,    29,    30,
      33,    34,    37,    44,    48,    50,    51,    84,   103,   124,
     196,   200,   207,   209,   210,   211,   212,   215,   216,   217,
     246,   255,   258,   260,   263,   267,   270,   272,   274,   277,
     201,   293,    48,   316,   140,   201,    24,   103,   105,     1,
      48,   205,   206,   316,     1,    24,   103,   259,   276,   277,
     268,   256,    48,   214,   173,   276,   214,   104,   195,   261,
     213,   247,   264,   259,   259,   259,   208,   128,    24,    90,
     103,   105,    90,   103,   106,    90,   259,   195,   195,   276,
     173,   271,   211,   195,   104,   195,   195,   200,   252,   252,
       1,   205,   252,   269,   257,   271,   275,   276,    24,    84,
     262,   211,   248,   265,   107,   107,   271,    24,   107,   107,
     107,   107,   276,   280,   276,   273,   276,   276,   276,    24,
     105,   108,   249,   103,   106,   254,   249,   259,   249,   249,
     211,     1,   251,   253,   309,   251,   249,   259,   266,   276,
     211,   211,   103,   211,   259,    40,   250,   253,   273,   211,
     249,   211
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   114,   115,   115,   116,   116,   116,   117,   117,   118,
     118,   118,   118,   119,   119,   120,   122,   121,   123,   123,
     123,   123,   123,   123,   123,   124,   124,   124,   124,   124,
     125,   125,   125,   126,   126,   127,   127,   127,   127,   128,
     128,   128,   128,   129,   130,   131,   131,   132,   132,   133,
     133,   134,   135,   135,   136,   137,   137,   139,   140,   138,
     138,   141,   138,   138,   138,   138,   138,   138,   138,   138,
     138,   138,   138,   142,   138,   143,   143,   143,   144,   144,
     144,   145,   146,   147,   147,   148,   148,   148,   149,   149,
     149,   149,   149,   149,   149,   149,   149,   149,   149,   150,
     150,   150,   150,   150,   150,   150,   150,   150,   150,   150,
     151,   151,   151,   151,   151,   151,   151,   151,   151,   151,
     151,   151,   151,   151,   151,   151,   152,   152,   152,   152,
     152,   152,   152,   152,   152,   152,   152,   152,   152,   152,
     152,   152,   152,   152,   152,   152,   152,   152,   152,   153,
     153,   153,   154,   154,   154,   155,   156,   156,   157,   157,
     157,   158,   158,   159,   160,   161,   162,   162,   163,   164,
     165,   166,   166,   167,   167,   168,   168,   169,   169,   169,
     169,   169,   169,   169,   169,   169,   169,   169,   169,   169,
     169,   169,   169,   170,   171,   171,   171,   172,   172,   172,
     173,   173,   174,   174,   174,   174,   175,   176,   177,   176,
     178,   178,   178,   180,   181,   179,   179,   182,   182,   183,
     184,   183,   185,   185,   187,   188,   189,   186,   186,   190,
     190,   191,   191,   192,   191,   191,   191,   191,   193,   193,
     193,   193,   193,   193,   194,   194,   194,   194,   195,   197,
     198,   199,   196,   200,   200,   201,   201,   201,   202,   203,
     203,   204,   204,   205,   205,   205,   206,   206,   207,   207,
     207,   207,   208,   208,   209,   210,   210,   210,   210,   210,
     210,   210,   210,   210,   210,   210,   210,   211,   211,   211,
     211,   211,   211,   211,   211,   211,   213,   212,   214,   214,
     215,   216,   216,   217,   218,   219,   221,   222,   220,   220,
     224,   223,   223,   226,   225,   225,   227,   227,   227,   228,
     228,   228,   229,   229,   230,   230,   232,   231,   231,   231,
     234,   235,   233,   236,   236,   237,   237,   238,   238,   239,
     240,   240,   240,   242,   243,   244,   241,   245,   247,   248,
     246,   249,   249,   249,   250,   250,   251,   251,   252,   252,
     252,   253,   253,   254,   254,   256,   257,   255,   258,   258,
     258,   259,   259,   261,   262,   260,   264,   265,   263,   266,
     266,   268,   269,   267,   270,   270,   270,   271,   271,   271,
     271,   272,   272,   273,   273,   274,   275,   275,   276,   276,
     277,   277,   277,   277,   277,   278,   278,   279,   279,   280,
     280,   280,   280,   280,   280,   280,   280,   280,   280,   281,
     281,   282,   282,   282,   282,   282,   282,   282,   282,   282,
     282,   283,   283,   284,   284,   285,   285,   286,   286,   287,
     287,   287,   288,   288,   289,   289,   289,   289,   289,   289,
     289,   289,   289,   289,   289,   289,   289,   289,   289,   289,
     289,   289,   289,   289,   289,   289,   289,   289,   289,   289,
     289,   289,   289,   289,   289,   289,   289,   289,   289,   289,
     289,   290,   290,   290,   290,   290,   290,   290,   290,   291,
     291,   291,   292,   293,   292,   294,   294,   294,   294,   294,
     295,   296,   296,   296,   296,   296,   296,   296,   296,   296,
     296,   296,   296,   296,   296,   296,   296,   296,   296,   296,
     296,   296,   296,   296,   296,   296,   296,   296,   296,   296,
     296,   296,   296,   296,   296,   296,   296,   296,   296,   296,
     296,   297,   297,   297,   298,   298,   298,   298,   299,   299,
     300,   300,   300,   300,   301,   301,   301,   301,   301,   301,
     301,   301,   301,   301,   301,   301,   301,   302,   302,   302,
     302,   302,   303,   304,   304,   304,   304,   304,   305,   305,
     305,   305,   305,   305,   305,   307,   306,   308,   308,   308,
     308,   308,   308,   308,   308,   308,   308,   308,   308,   308,
     309,   309,   309,   309,   310,   311,   311,   312,   312,   313,
     313,   314,   314,   315,   315,   315,   316,   316,   316,   316,
     316,   316,   316,   316,   316,   316,   316,   316,   316,   316,
     316,   316,   316,   316,   316,   317,   317,   317,   317,   317,
     317,   317,   317,   317,   317,   317,   317,   317,   317,   317,
     317,   317,   317,   317,   317,   317,   317,   317,   317,   317,
     317,   317,   317,   317,   317
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     2,     2,     0,     1,     1,     2,
       2,     2,     0,     1,     1,     1,     0,     2,     5,     5,
       5,     5,     4,     4,     4,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     3,     4,     4,     4,     4,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     0,     1,
       1,     1,     1,     0,     0,     0,     1,     0,     0,    13,
       8,     0,    11,     6,     1,     1,     1,     2,     2,     1,
       2,     2,     2,     0,     5,     1,     1,     0,     1,     1,
       0,     3,     3,     1,     2,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     2,     5,     3,
       1,     0,     2,     0,     3,     3,     1,     1,     1,     1,
       1,     3,     1,     3,     1,     1,     1,     1,     1,     1,
       2,     2,     2,     2,     2,     2,     2,     2,     6,     5,
       2,     4,     4,     1,     0,     1,     2,     0,     1,     2,
       1,     1,     0,     3,     5,     3,     1,     0,     0,     4,
       0,     3,     3,     0,     0,     8,     0,     1,     2,     1,
       0,     4,     3,     0,     0,     0,     0,     8,     0,     1,
       3,     2,     2,     0,     5,     4,     4,     4,     2,     2,
       4,     4,     4,     4,     1,     1,     3,     3,     0,     0,
       0,     0,     7,     1,     1,     1,     1,     1,     0,     1,
       4,     1,     4,     3,     3,     3,     1,     3,     3,     3,
       3,     3,     0,     2,     2,     1,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     4,     1,     0,
       2,     2,     1,     2,     0,     0,     0,     0,     8,     5,
       0,     5,     3,     0,     6,     4,     5,     5,     4,     1,
       3,     3,     1,     2,     0,     3,     0,     4,     1,     1,
       0,     0,     7,     1,     1,     0,     2,     0,     2,     0,
       1,     4,     1,     0,     0,     0,     8,     5,     0,     0,
       9,     1,     1,     1,     0,     2,     1,     1,     1,     1,
       1,     0,     1,     2,     4,     0,     0,     9,     8,     5,
       4,     1,     1,     0,     0,    12,     0,     0,     8,     0,
       1,     0,     0,     8,     3,     5,     4,     1,     1,     1,
       1,     2,     3,     0,     1,     1,     0,     1,     1,     1,
       1,     2,     2,     2,     2,     1,     3,     1,     2,     1,
       3,     3,     3,     5,     3,     3,     3,     5,     4,     1,
       5,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     0,     2,     1,     3,     0,     2,     1,
       3,     3,     3,     3,     1,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     1,     2,     2,     2,     2,     2,     2,     2,     1,
       2,     2,     0,     0,     6,     5,     5,     4,     4,     4,
       0,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     1,     1,     4,     4,     6,     5,     7,     4,     4,
       4,     4,     4,     3,     5,     5,     4,     4,     3,     3,
       3,     3,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     1,     3,     3,     1,     3,     3,     3,     1,     1,
       2,     2,     3,     3,     1,     2,     3,     1,     3,     3,
       3,     3,     2,     2,     2,     2,     2,     0,     1,     2,
       1,     2,     2,     4,     4,     4,     4,     4,     3,     3,
       3,     3,     3,     1,     1,     0,     3,     7,     7,     7,
       7,     7,     5,     5,     5,     5,     4,     4,     4,     4,
       1,     3,     2,     1,     2,     0,     3,     1,     1,     1,
       2,     1,     3,     1,     2,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* all: program  */
#line 385 "language.yacc"
             { YYACCEPT; }
#line 4012 "y.tab.c"
    break;

  case 3: /* all: program TOK_LEX_EOF  */
#line 386 "language.yacc"
                        { YYACCEPT; }
#line 4018 "y.tab.c"
    break;

  case 9: /* optional_rename_inherit: ':' real_string_or_identifier  */
#line 399 "language.yacc"
                                                       { (yyval.n)=(yyvsp[0].n); }
#line 4024 "y.tab.c"
    break;

  case 10: /* optional_rename_inherit: ':' bad_identifier  */
#line 400 "language.yacc"
                       { (yyval.n)=0; }
#line 4030 "y.tab.c"
    break;

  case 11: /* optional_rename_inherit: ':' error  */
#line 401 "language.yacc"
              { (yyval.n)=0; }
#line 4036 "y.tab.c"
    break;

  case 12: /* optional_rename_inherit: %empty  */
#line 402 "language.yacc"
    { (yyval.n)=0; }
#line 4042 "y.tab.c"
    break;

  case 13: /* low_program_ref: string_constant  */
#line 409 "language.yacc"
  {
    STACK_LEVEL_START(0);

    ref_push_string((yyvsp[0].n)->u.sval.u.string);
    if (call_handle_inherit((yyvsp[0].n)->u.sval.u.string)) {
      STACK_LEVEL_CHECK(2);
      (yyval.n)=mksvaluenode(Pike_sp-1);
      pop_stack();
    }
    else
      (yyval.n)=mknewintnode(0);
    STACK_LEVEL_CHECK(1);
    if((yyval.n)->name) free_string((yyval.n)->name);
#ifdef PIKE_DEBUG
    if (TYPEOF(Pike_sp[-1]) != T_STRING) {
      Pike_fatal("Compiler lost track of program name.\n");
    }
#endif /* PIKE_DEBUG */
    /* FIXME: Why not use $1->u.sval.u.string here? */
    add_ref( (yyval.n)->name=Pike_sp[-1].u.string );
    free_node((yyvsp[0].n));

    STACK_LEVEL_DONE(1);
  }
#line 4071 "y.tab.c"
    break;

  case 14: /* low_program_ref: idents  */
#line 434 "language.yacc"
  {
    STACK_LEVEL_START(0);

    if(Pike_compiler->last_identifier)
    {
      ref_push_string(Pike_compiler->last_identifier);
    }else{
      push_empty_string();
    }
    (yyval.n)=(yyvsp[0].n);

    STACK_LEVEL_DONE(1);
  }
#line 4089 "y.tab.c"
    break;

  case 15: /* program_ref: low_program_ref  */
#line 451 "language.yacc"
  {
    STACK_LEVEL_START(0);

    resolv_program((yyvsp[0].n));
    free_node((yyvsp[0].n));

    STACK_LEVEL_DONE(1);
  }
#line 4102 "y.tab.c"
    break;

  case 16: /* @1: %empty  */
#line 462 "language.yacc"
  {
    SET_FORCE_RESOLVE((yyval.number));
  }
#line 4110 "y.tab.c"
    break;

  case 17: /* inherit_ref: @1 low_program_ref  */
#line 466 "language.yacc"
  {
    UNSET_FORCE_RESOLVE((yyvsp[-1].number));
    (yyval.n) = (yyvsp[0].n);
  }
#line 4119 "y.tab.c"
    break;

  case 18: /* inheritance: modifiers TOK_INHERIT inherit_ref optional_rename_inherit ';'  */
#line 473 "language.yacc"
  {
    if (((yyvsp[-4].number) & ID_EXTERN) && (Pike_compiler->compiler_pass == 1)) {
      yywarning("Extern declared inherit.");
    }
    if((yyvsp[-2].n))
    {
      struct pike_string *s=Pike_sp[-1].u.string;
      if((yyvsp[-1].n)) s=(yyvsp[-1].n)->u.sval.u.string;
      compiler_do_inherit((yyvsp[-2].n),(yyvsp[-4].number),s);
    }
    if((yyvsp[-1].n)) free_node((yyvsp[-1].n));
    pop_stack();
    if ((yyvsp[-2].n)) free_node((yyvsp[-2].n));
  }
#line 4138 "y.tab.c"
    break;

  case 19: /* inheritance: modifiers TOK_INHERIT inherit_ref error ';'  */
#line 488 "language.yacc"
  {
    if ((yyvsp[-2].n)) free_node((yyvsp[-2].n));
    pop_stack();
    yyerrok;
  }
#line 4148 "y.tab.c"
    break;

  case 20: /* inheritance: modifiers TOK_INHERIT inherit_ref error TOK_LEX_EOF  */
#line 494 "language.yacc"
  {
    if ((yyvsp[-2].n)) free_node((yyvsp[-2].n));
    pop_stack();
    yyerror("Missing ';'.");
    yyerror("Unexpected end of file.");
  }
#line 4159 "y.tab.c"
    break;

  case 21: /* inheritance: modifiers TOK_INHERIT inherit_ref error '}'  */
#line 501 "language.yacc"
  {
    if ((yyvsp[-2].n)) free_node((yyvsp[-2].n));
    pop_stack();
    yyerror("Missing ';'.");
  }
#line 4169 "y.tab.c"
    break;

  case 22: /* inheritance: modifiers TOK_INHERIT error ';'  */
#line 506 "language.yacc"
                                    { yyerrok; }
#line 4175 "y.tab.c"
    break;

  case 23: /* inheritance: modifiers TOK_INHERIT error TOK_LEX_EOF  */
#line 508 "language.yacc"
  {
    yyerror("Missing ';'.");
    yyerror("Unexpected end of file.");
  }
#line 4184 "y.tab.c"
    break;

  case 24: /* inheritance: modifiers TOK_INHERIT error '}'  */
#line 512 "language.yacc"
                                    { yyerror("Missing ';'."); }
#line 4190 "y.tab.c"
    break;

  case 25: /* import: TOK_IMPORT idents ';'  */
#line 516 "language.yacc"
  {
    resolv_constant((yyvsp[-1].n));
    free_node((yyvsp[-1].n));
    use_module(Pike_sp-1);
    pop_stack();
  }
#line 4201 "y.tab.c"
    break;

  case 26: /* import: TOK_IMPORT string ';'  */
#line 523 "language.yacc"
  {
    if (call_handle_import((yyvsp[-1].n)->u.sval.u.string)) {
      use_module(Pike_sp-1);
      pop_stack();
    }
    free_node((yyvsp[-1].n));
  }
#line 4213 "y.tab.c"
    break;

  case 27: /* import: TOK_IMPORT error ';'  */
#line 530 "language.yacc"
                         { yyerrok; }
#line 4219 "y.tab.c"
    break;

  case 28: /* import: TOK_IMPORT error TOK_LEX_EOF  */
#line 532 "language.yacc"
  {
    yyerror("Missing ';'.");
    yyerror("Unexpected end of file.");
  }
#line 4228 "y.tab.c"
    break;

  case 29: /* import: TOK_IMPORT error '}'  */
#line 536 "language.yacc"
                         { yyerror("Missing ';'."); }
#line 4234 "y.tab.c"
    break;

  case 30: /* constant_name: TOK_IDENTIFIER '=' safe_expr0  */
#line 540 "language.yacc"
  {
    /* This can be made more lenient in the future */

    /* Ugly hack to make sure that $3 is optimized */
    {
      int tmp=Pike_compiler->compiler_pass;
      (yyvsp[0].n)=mknode(F_COMMA_EXPR,(yyvsp[0].n),0);
      Pike_compiler->compiler_pass=tmp;
    }

    if (!TEST_COMPAT(7, 6) && (Pike_compiler->current_modifiers & ID_EXTERN)) {
      int depth = 0;
      struct program_state *state = Pike_compiler;
      node *n = (yyvsp[0].n);
      while (((n->token == F_COMMA_EXPR) || (n->token == F_ARG_LIST)) &&
	     ((!CAR(n)) ^ (!CDR(n)))) {
	if (CAR(n)) n = CAR(n);
	else n = CDR(n);
      }
      if (n->token == F_EXTERNAL) {
	while (state && (state->new_program->id != n->u.integer.a)) {
	  depth++;
	  state = state->previous;
	}
      }
      if (depth && state) {
	/* Alias for a symbol in a surrounding scope. */
	int id = really_low_reference_inherited_identifier(state, 0,
							   n->u.integer.b);
	define_alias((yyvsp[-2].n)->u.sval.u.string, n->type,
		     Pike_compiler->current_modifiers & ~ID_EXTERN,
		     depth, id);
      } else if (Pike_compiler->compiler_pass == 1) {
	yyerror("Invalid extern declared constant.");
	add_constant((yyvsp[-2].n)->u.sval.u.string, &svalue_undefined,
		     Pike_compiler->current_modifiers & ~ID_EXTERN);
      }
    } else {
      if (TEST_COMPAT(7, 6) &&
	  (Pike_compiler->current_modifiers & ID_EXTERN) &&
	  (Pike_compiler->compiler_pass == 1)) {
	yywarning("Extern declared constant.");
      }
      if(!is_const((yyvsp[0].n))) {
	if (Pike_compiler->compiler_pass == 2) {
	  yyerror("Constant definition is not constant.");
	}
	add_constant((yyvsp[-2].n)->u.sval.u.string, 0,
		     Pike_compiler->current_modifiers & ~ID_EXTERN);
      } else {
	if(!Pike_compiler->num_parse_error)
	{
	  ptrdiff_t tmp=eval_low((yyvsp[0].n),1);
	  if(tmp < 1)
	  {
	    yyerror("Error in constant definition.");
	    push_undefined();
	  }else{
	    pop_n_elems(DO_NOT_WARN((INT32)(tmp - 1)));
	  }
	} else {
	  push_undefined();
	}
	add_constant((yyvsp[-2].n)->u.sval.u.string, Pike_sp-1,
		     Pike_compiler->current_modifiers & ~ID_EXTERN);
	pop_stack();
      }
    }
  const_def_ok:
    if((yyvsp[0].n)) free_node((yyvsp[0].n));
    free_node((yyvsp[-2].n));
  }
#line 4311 "y.tab.c"
    break;

  case 31: /* constant_name: bad_identifier '=' safe_expr0  */
#line 612 "language.yacc"
                                  { if ((yyvsp[0].n)) free_node((yyvsp[0].n)); }
#line 4317 "y.tab.c"
    break;

  case 32: /* constant_name: error '=' safe_expr0  */
#line 613 "language.yacc"
                         { if ((yyvsp[0].n)) free_node((yyvsp[0].n)); }
#line 4323 "y.tab.c"
    break;

  case 35: /* constant: modifiers TOK_CONSTANT constant_list ';'  */
#line 620 "language.yacc"
                                                   {}
#line 4329 "y.tab.c"
    break;

  case 36: /* constant: modifiers TOK_CONSTANT error ';'  */
#line 621 "language.yacc"
                                     { yyerrok; }
#line 4335 "y.tab.c"
    break;

  case 37: /* constant: modifiers TOK_CONSTANT error TOK_LEX_EOF  */
#line 623 "language.yacc"
  {
    yyerror("Missing ';'.");
    yyerror("Unexpected end of file.");
  }
#line 4344 "y.tab.c"
    break;

  case 38: /* constant: modifiers TOK_CONSTANT error '}'  */
#line 627 "language.yacc"
                                     { yyerror("Missing ';'."); }
#line 4350 "y.tab.c"
    break;

  case 39: /* block_or_semi: block  */
#line 631 "language.yacc"
  {
    (yyval.n) = mknode(F_COMMA_EXPR,(yyvsp[0].n),mknode(F_RETURN,mkintnode(0),0));
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[0].n));
  }
#line 4359 "y.tab.c"
    break;

  case 40: /* block_or_semi: ';'  */
#line 635 "language.yacc"
        { (yyval.n) = NULL; }
#line 4365 "y.tab.c"
    break;

  case 41: /* block_or_semi: TOK_LEX_EOF  */
#line 636 "language.yacc"
                { yyerror("Expected ';'."); (yyval.n) = NULL; }
#line 4371 "y.tab.c"
    break;

  case 42: /* block_or_semi: error  */
#line 637 "language.yacc"
          { (yyval.n) = NULL; }
#line 4377 "y.tab.c"
    break;

  case 43: /* type_or_error: simple_type  */
#line 642 "language.yacc"
  {
#ifdef PIKE_DEBUG
    check_type_string((yyvsp[0].n)->u.sval.u.type);
#endif /* PIKE_DEBUG */
    if(Pike_compiler->compiler_frame->current_type)
      free_type(Pike_compiler->compiler_frame->current_type);
    copy_pike_type(Pike_compiler->compiler_frame->current_type,
		   (yyvsp[0].n)->u.sval.u.type);
    free_node((yyvsp[0].n));
  }
#line 4392 "y.tab.c"
    break;

  case 44: /* open_paren_with_line_info: '('  */
#line 655 "language.yacc"
  {
    /* Used to hold line-number info */
    (yyval.n) = mkintnode(0);
  }
#line 4401 "y.tab.c"
    break;

  case 45: /* close_paren_or_missing: ')'  */
#line 662 "language.yacc"
  {
    /* Used to hold line-number info */
    (yyval.n) = mkintnode(0);
  }
#line 4410 "y.tab.c"
    break;

  case 46: /* close_paren_or_missing: %empty  */
#line 667 "language.yacc"
  {
    yyerror("Missing ')'.");
    /* Used to hold line-number info */
    (yyval.n) = mkintnode(0);
  }
#line 4420 "y.tab.c"
    break;

  case 48: /* close_brace_or_missing: %empty  */
#line 676 "language.yacc"
  {
    yyerror("Missing '}'.");
  }
#line 4428 "y.tab.c"
    break;

  case 50: /* close_brace_or_eof: TOK_LEX_EOF  */
#line 683 "language.yacc"
  {
    yyerror("Missing '}'.");
  }
#line 4436 "y.tab.c"
    break;

  case 51: /* open_bracket_with_line_info: '['  */
#line 689 "language.yacc"
  {
    /* Used to hold line-number info */
    (yyval.n) = mkintnode(0);
  }
#line 4445 "y.tab.c"
    break;

  case 53: /* close_bracket_or_missing: %empty  */
#line 697 "language.yacc"
  {
    yyerror("Missing ']'.");
  }
#line 4453 "y.tab.c"
    break;

  case 54: /* push_compiler_frame0: %empty  */
#line 703 "language.yacc"
  {
    push_compiler_frame(SCOPE_LOCAL);

    if(!Pike_compiler->compiler_frame->previous ||
       !Pike_compiler->compiler_frame->previous->current_type)
    {
      yyerror("Internal compiler error (push_compiler_frame0).");
      copy_pike_type(Pike_compiler->compiler_frame->current_type,
		mixed_type_string);
    }else{
      copy_pike_type(Pike_compiler->compiler_frame->current_type,
		Pike_compiler->compiler_frame->previous->current_type);
    }

    (yyval.ptr) = Pike_compiler->compiler_frame;
  }
#line 4474 "y.tab.c"
    break;

  case 55: /* optional_constant: %empty  */
#line 722 "language.yacc"
  {
    (yyval.number) = OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT;
  }
#line 4482 "y.tab.c"
    break;

  case 56: /* optional_constant: TOK_CONSTANT  */
#line 726 "language.yacc"
  {
    (yyval.number) = 0;
  }
#line 4490 "y.tab.c"
    break;

  case 57: /* @2: %empty  */
#line 734 "language.yacc"
  {
    (yyval.number) = 0;
    /* Check for the (very special) case of create and create_args. */
    if (Pike_compiler->num_create_args) {
      struct pike_string *create_string = NULL;
      int e;
      MAKE_CONST_STRING(create_string, "create");
      if ((yyvsp[-2].n)->u.sval.u.string == create_string) {
	if (TEST_COMPAT(7, 6)) {
	  yywarning("Having both an implicit and an explicit create() "
		    "was not supported in Pike 7.6 and before.");
	}
	/* Prepend the create arguments. */
	if (Pike_compiler->num_create_args < 0) {
	  Pike_compiler->varargs = 1;
	  for (e = 0; e < -Pike_compiler->num_create_args; e++) {
	    struct identifier *id =
	      Pike_compiler->new_program->identifiers + e;
	    add_ref(id->type);
	    add_local_name(empty_pike_string, id->type, 0);
	    /* Note: add_local_name() above will return e. */
	    Pike_compiler->compiler_frame->variable[e].flags |=
	      LOCAL_VAR_IS_USED;
	  }
	} else {
	  for (e = 0; e < Pike_compiler->num_create_args; e++) {
	    struct identifier *id =
	      Pike_compiler->new_program->identifiers + e;
	    add_ref(id->type);
	    add_local_name(empty_pike_string, id->type, 0);
	    /* Note: add_local_name() above will return e. */
	    Pike_compiler->compiler_frame->variable[e].flags |=
	      LOCAL_VAR_IS_USED;
	  }
	}
	(yyval.number) = e;
      }
    }
  }
#line 4534 "y.tab.c"
    break;

  case 58: /* @3: %empty  */
#line 774 "language.yacc"
  {
    int e;

    /* Adjust opt_flags in case we've got an optional_constant. */
    Pike_compiler->compiler_frame->opt_flags = (yyvsp[-7].number);

    /* construct the function type */
    push_finished_type(Pike_compiler->compiler_frame->current_type);

    if(Pike_compiler->compiler_frame->current_return_type)
      free_type(Pike_compiler->compiler_frame->current_return_type);
    Pike_compiler->compiler_frame->current_return_type = compiler_pop_type();

    push_finished_type(Pike_compiler->compiler_frame->current_return_type);

    e = (yyvsp[-2].number) + (yyvsp[-1].number) - 1;
    if(Pike_compiler->varargs &&
       (!(yyvsp[-2].number) || (Pike_compiler->num_create_args >= 0)))
    {
      push_finished_type(Pike_compiler->compiler_frame->variable[e].type);
      e--;
      pop_type_stack(T_ARRAY);
    }else{
      push_type(T_VOID);
    }
    push_type(T_MANY);
    for(; e>=0; e--)
    {
      push_finished_type(Pike_compiler->compiler_frame->variable[e].type);
      push_type(T_FUNCTION);
    }

    if (Pike_compiler->current_attributes) {
      node *n = Pike_compiler->current_attributes;
      while (n) {
	push_type_attribute(CDR(n)->u.sval.u.string);
	n = CAR(n);
      }
    }

    {
      struct pike_type *s=compiler_pop_type();
      int i = isidentifier((yyvsp[-5].n)->u.sval.u.string);

      if (Pike_compiler->compiler_pass != 1) {
	if (i < 0) {
	  my_yyerror("Identifier %S lost after first pass.",
		     (yyvsp[-5].n)->u.sval.u.string);
	}
      }

      (yyval.n) = mktypenode(s);
      free_type(s);
    }


/*    if(Pike_compiler->compiler_pass==1) */
    {
      /* FIXME:
       * set current_function_number for local functions as well
       */
      Pike_compiler->compiler_frame->current_function_number=
	define_function((yyvsp[-5].n)->u.sval.u.string,
			(yyval.n)->u.sval.u.type,
			(yyvsp[-10].number) & (~ID_EXTERN),
			IDENTIFIER_PIKE_FUNCTION |
			(Pike_compiler->varargs?IDENTIFIER_VARARGS:0),
			0,
			(yyvsp[-7].number));

      Pike_compiler->varargs=0;
    }
  }
#line 4612 "y.tab.c"
    break;

  case 59: /* def: modifiers optional_attributes type_or_error optional_constant optional_stars TOK_IDENTIFIER push_compiler_frame0 '(' @2 arguments close_paren_or_missing @3 block_or_semi  */
#line 848 "language.yacc"
  {
    int e;
    if((yyvsp[0].n))
    {
      int f;
      node *check_args = NULL;
      struct compilation *c = THIS_COMPILATION;
      struct pike_string *save_file = c->lex.current_file;
      int save_line  = c->lex.current_line;
      int num_required_args = 0;
      struct identifier *i;
      c->lex.current_file = (yyvsp[-7].n)->current_file;
      c->lex.current_line = (yyvsp[-7].n)->line_number;

      if (((yyvsp[-12].number) & ID_EXTERN) && (Pike_compiler->compiler_pass == 1)) {
	yywarning("Extern declared function definition.");
      }

      for(e=0; e<(yyvsp[-4].number)+(yyvsp[-3].number); e++)
      {
	if((e >= (yyvsp[-4].number)) &&
	   (!Pike_compiler->compiler_frame->variable[e].name ||
	    !Pike_compiler->compiler_frame->variable[e].name->len))
	{
	  my_yyerror("Missing name for argument %d.", e - (yyvsp[-4].number));
	} else {
	  if (Pike_compiler->compiler_pass == 2) {
	      /* FIXME: Should probably use some other flag. */
	      if ((runtime_options & RUNTIME_CHECK_TYPES) &&
		  (Pike_compiler->compiler_frame->variable[e].type !=
		   mixed_type_string)) {
		node *local_node;

		/* fprintf(stderr, "Creating soft cast node for local #%d\n", e);*/

		local_node = mkcastnode(mixed_type_string, mklocalnode(e, 0));

		/* NOTE: The cast to mixed above is needed to avoid generating
		 *       compilation errors, as well as avoiding optimizations
		 *       in mksoftcastnode().
		 */
		check_args =
		  mknode(F_COMMA_EXPR, check_args,
			 mksoftcastnode(Pike_compiler->compiler_frame->variable[e].type,
					local_node));
	      }
	  }
	}
      }

      if ((yyvsp[-4].number)) {
	/* Hook in the initializers for the create arguments. */
	for (e = (yyvsp[-4].number); e--;) {
	  (yyvsp[0].n) = mknode(F_COMMA_EXPR,
		       mknode(F_POP_VALUE,
			      mknode(F_ASSIGN, mklocalnode(e, 0),
				     mkidentifiernode(e)), NULL),
		       (yyvsp[0].n));
	}
      }

      {
	int l = (yyvsp[0].n)->line_number;
	struct pike_string *f = (yyvsp[0].n)->current_file;
	if (check_args) {
	  /* Prepend the arg checking code. */
	  (yyvsp[0].n) = mknode(F_COMMA_EXPR, mknode(F_POP_VALUE, check_args, NULL), (yyvsp[0].n));
	}
	c->lex.current_line = l;
	c->lex.current_file = f;
      }

      f=dooptcode((yyvsp[-7].n)->u.sval.u.string, (yyvsp[0].n), (yyvsp[-1].n)->u.sval.u.type, (yyvsp[-12].number));

      i = ID_FROM_INT(Pike_compiler->new_program, f);
      i->opt_flags = Pike_compiler->compiler_frame->opt_flags;

#ifdef PIKE_DEBUG
      if(Pike_interpreter.recoveries &&
	 ((Pike_sp - Pike_interpreter.evaluator_stack) <
	  Pike_interpreter.recoveries->stack_pointer))
	Pike_fatal("Stack error (underflow)\n");

      if((Pike_compiler->compiler_pass == 1) &&
	 (f != Pike_compiler->compiler_frame->current_function_number)) {
	fprintf(stderr, "define_function()/do_opt_code() failed for symbol %s\n",
		(yyvsp[-7].n)->u.sval.u.string->str);
	dump_program_desc(Pike_compiler->new_program);
	Pike_fatal("define_function screwed up! %d != %d\n",
	      f, Pike_compiler->compiler_frame->current_function_number);
      }
#endif

      c->lex.current_line = save_line;
      c->lex.current_file = save_file;
    } else {
      /* Prototype; don't warn about unused arguments. */
      for (e = Pike_compiler->compiler_frame->current_number_of_locals; e--;) {
	Pike_compiler->compiler_frame->variable[e].flags |= LOCAL_VAR_IS_USED;
      }
    }
#ifdef PIKE_DEBUG
    if (Pike_compiler->compiler_frame != (yyvsp[-6].ptr)) {
      Pike_fatal("Lost track of compiler_frame!\n"
		 "  Got: %p (Expected: %p) Previous: %p\n",
		 Pike_compiler->compiler_frame, (yyvsp[-6].ptr),
		 Pike_compiler->compiler_frame->previous);
    }
#endif
    pop_compiler_frame();
    free_node((yyvsp[-7].n));
    free_node((yyvsp[-2].n));
    free_node((yyvsp[-1].n));
  }
#line 4731 "y.tab.c"
    break;

  case 60: /* def: modifiers optional_attributes type_or_error optional_constant optional_stars TOK_IDENTIFIER push_compiler_frame0 error  */
#line 965 "language.yacc"
  {
#ifdef PIKE_DEBUG
    if (Pike_compiler->compiler_frame != (yyvsp[-1].ptr)) {
      Pike_fatal("Lost track of compiler_frame!\n"
		 "  Got: %p (Expected: %p) Previous: %p\n",
		 Pike_compiler->compiler_frame, (yyvsp[-1].ptr),
		 Pike_compiler->compiler_frame->previous);
    }
#endif
    pop_compiler_frame();
    free_node((yyvsp[-2].n));
  }
#line 4748 "y.tab.c"
    break;

  case 61: /* $@4: %empty  */
#line 978 "language.yacc"
  {
    compiler_discard_type();
  }
#line 4756 "y.tab.c"
    break;

  case 62: /* def: modifiers optional_attributes type_or_error optional_constant optional_stars bad_identifier $@4 '(' arguments ')' block_or_semi  */
#line 982 "language.yacc"
  {
    if ((yyvsp[0].n)) free_node((yyvsp[0].n));
  }
#line 4764 "y.tab.c"
    break;

  case 64: /* def: inheritance  */
#line 986 "language.yacc"
                {}
#line 4770 "y.tab.c"
    break;

  case 65: /* def: import  */
#line 987 "language.yacc"
           {}
#line 4776 "y.tab.c"
    break;

  case 66: /* def: constant  */
#line 988 "language.yacc"
             {}
#line 4782 "y.tab.c"
    break;

  case 67: /* def: modifiers class  */
#line 989 "language.yacc"
                    { free_node((yyvsp[0].n)); }
#line 4788 "y.tab.c"
    break;

  case 68: /* def: modifiers enum  */
#line 990 "language.yacc"
                   { free_node((yyvsp[0].n)); }
#line 4794 "y.tab.c"
    break;

  case 69: /* def: typedef  */
#line 991 "language.yacc"
            {}
#line 4800 "y.tab.c"
    break;

  case 70: /* def: error TOK_LEX_EOF  */
#line 993 "language.yacc"
  {
    reset_type_stack();
    yyerror("Missing ';'.");
    yyerror("Unexpected end of file");
  }
#line 4810 "y.tab.c"
    break;

  case 71: /* def: error ';'  */
#line 999 "language.yacc"
  {
    reset_type_stack();
    yyerrok;
/*     if(Pike_compiler->num_parse_error>5) YYACCEPT; */
  }
#line 4820 "y.tab.c"
    break;

  case 72: /* def: error '}'  */
#line 1005 "language.yacc"
  {
    reset_type_stack();
    yyerror("Missing ';'.");
   /* yychar = '}';	*/ /* Put the '}' back on the input stream */
  }
#line 4830 "y.tab.c"
    break;

  case 73: /* @5: %empty  */
#line 1012 "language.yacc"
    {
      (yyval.number)=THIS_COMPILATION->lex.pragmas;
      THIS_COMPILATION->lex.pragmas|=(yyvsp[-1].number);
    }
#line 4839 "y.tab.c"
    break;

  case 74: /* def: modifiers '{' @5 program close_brace_or_eof  */
#line 1018 "language.yacc"
    {
      THIS_COMPILATION->lex.pragmas=(yyvsp[-2].number);
    }
#line 4847 "y.tab.c"
    break;

  case 75: /* optional_dot_dot_dot: TOK_DOT_DOT_DOT  */
#line 1023 "language.yacc"
                                      { (yyval.number)=1; }
#line 4853 "y.tab.c"
    break;

  case 76: /* optional_dot_dot_dot: TOK_DOT_DOT  */
#line 1025 "language.yacc"
  {
    yyerror("Range indicator ('..') where elipsis ('...') expected.");
    (yyval.number)=1;
  }
#line 4862 "y.tab.c"
    break;

  case 77: /* optional_dot_dot_dot: %empty  */
#line 1029 "language.yacc"
                { (yyval.number)=0; }
#line 4868 "y.tab.c"
    break;

  case 79: /* optional_identifier: bad_identifier  */
#line 1033 "language.yacc"
                   { (yyval.n)=0; }
#line 4874 "y.tab.c"
    break;

  case 80: /* optional_identifier: %empty  */
#line 1034 "language.yacc"
                { (yyval.n)=0; }
#line 4880 "y.tab.c"
    break;

  case 81: /* new_arg_name: full_type optional_dot_dot_dot optional_identifier  */
#line 1038 "language.yacc"
  {
    int i;
    if(Pike_compiler->varargs) yyerror("Can't define more arguments after ...");

    if((yyvsp[-1].number))
    {
      push_type(T_ARRAY);
      Pike_compiler->varargs=1;
    }

    if(!(yyvsp[0].n))
    {
      (yyvsp[0].n)=mkstrnode(empty_pike_string);
    }

    if((yyvsp[0].n)->u.sval.u.string->len &&
       islocal((yyvsp[0].n)->u.sval.u.string) >= 0)
      my_yyerror("Variable %S appears twice in argument list.",
		 (yyvsp[0].n)->u.sval.u.string);

    i = add_local_name((yyvsp[0].n)->u.sval.u.string, compiler_pop_type(),0);
    if (i >= 0) {
      /* Don't warn about unused arguments. */
      Pike_compiler->compiler_frame->variable[i].flags |= LOCAL_VAR_IS_USED;
    }
    free_node((yyvsp[0].n));
  }
#line 4912 "y.tab.c"
    break;

  case 82: /* func_args: '(' arguments close_paren_or_missing  */
#line 1068 "language.yacc"
  {
    free_node((yyvsp[0].n));
    (yyval.number)=(yyvsp[-1].number);
  }
#line 4921 "y.tab.c"
    break;

  case 83: /* arguments: optional_comma  */
#line 1074 "language.yacc"
                                      { (yyval.number)=0; }
#line 4927 "y.tab.c"
    break;

  case 85: /* arguments2: new_arg_name  */
#line 1078 "language.yacc"
                         { (yyval.number) = 1; }
#line 4933 "y.tab.c"
    break;

  case 86: /* arguments2: arguments2 ',' new_arg_name  */
#line 1079 "language.yacc"
                                { (yyval.number) = (yyvsp[-2].number) + 1; }
#line 4939 "y.tab.c"
    break;

  case 87: /* arguments2: arguments2 ':' new_arg_name  */
#line 1081 "language.yacc"
  {
    yyerror("Unexpected ':' in argument list.");
    (yyval.number) = (yyvsp[-2].number) + 1;
  }
#line 4948 "y.tab.c"
    break;

  case 88: /* modifier: TOK_NO_MASK  */
#line 1089 "language.yacc"
    {
      (yyval.number) = ID_FINAL | ID_INLINE;
      if( !(THIS_COMPILATION->lex.pragmas & ID_NO_DEPRECATION_WARNINGS) &&
          !TEST_COMPAT(7, 6) && Pike_compiler->compiler_pass==1 )
        yywarning("Keyword nomask is deprecated in favour of 'final'.");
    }
#line 4959 "y.tab.c"
    break;

  case 89: /* modifier: TOK_FINAL_ID  */
#line 1095 "language.yacc"
                   { (yyval.number) = ID_FINAL | ID_INLINE; }
#line 4965 "y.tab.c"
    break;

  case 90: /* modifier: TOK_STATIC  */
#line 1096 "language.yacc"
                   {
    (yyval.number) = ID_PROTECTED;
    if( !(THIS_COMPILATION->lex.pragmas & ID_NO_DEPRECATION_WARNINGS) &&
        !TEST_COMPAT(7, 8) && Pike_compiler->compiler_pass==1 )
      yywarning("Keyword static is deprecated in favour of 'protected'.");
    }
#line 4976 "y.tab.c"
    break;

  case 91: /* modifier: TOK_EXTERN  */
#line 1102 "language.yacc"
                   { (yyval.number) = ID_EXTERN | ID_OPTIONAL; }
#line 4982 "y.tab.c"
    break;

  case 92: /* modifier: TOK_OPTIONAL  */
#line 1103 "language.yacc"
                   { (yyval.number) = ID_OPTIONAL; }
#line 4988 "y.tab.c"
    break;

  case 93: /* modifier: TOK_PRIVATE  */
#line 1104 "language.yacc"
                   { (yyval.number) = ID_PRIVATE | ID_PROTECTED | ID_INLINE; }
#line 4994 "y.tab.c"
    break;

  case 94: /* modifier: TOK_LOCAL_ID  */
#line 1105 "language.yacc"
                   { (yyval.number) = ID_INLINE; }
#line 5000 "y.tab.c"
    break;

  case 95: /* modifier: TOK_PUBLIC  */
#line 1106 "language.yacc"
                   { (yyval.number) = ID_PUBLIC; }
#line 5006 "y.tab.c"
    break;

  case 96: /* modifier: TOK_PROTECTED  */
#line 1107 "language.yacc"
                   { (yyval.number) = ID_PROTECTED; }
#line 5012 "y.tab.c"
    break;

  case 97: /* modifier: TOK_INLINE  */
#line 1108 "language.yacc"
                   { (yyval.number) = ID_INLINE; }
#line 5018 "y.tab.c"
    break;

  case 98: /* modifier: TOK_VARIANT  */
#line 1109 "language.yacc"
                   { (yyval.number) = ID_VARIANT; }
#line 5024 "y.tab.c"
    break;

  case 99: /* magic_identifiers1: TOK_NO_MASK  */
#line 1113 "language.yacc"
                   { (yyval.str) = "nomask"; }
#line 5030 "y.tab.c"
    break;

  case 100: /* magic_identifiers1: TOK_FINAL_ID  */
#line 1114 "language.yacc"
                   { (yyval.str) = "final"; }
#line 5036 "y.tab.c"
    break;

  case 101: /* magic_identifiers1: TOK_STATIC  */
#line 1115 "language.yacc"
                   { (yyval.str) = "static"; }
#line 5042 "y.tab.c"
    break;

  case 102: /* magic_identifiers1: TOK_EXTERN  */
#line 1116 "language.yacc"
                   { (yyval.str) = "extern"; }
#line 5048 "y.tab.c"
    break;

  case 103: /* magic_identifiers1: TOK_PRIVATE  */
#line 1117 "language.yacc"
                   { (yyval.str) = "private"; }
#line 5054 "y.tab.c"
    break;

  case 104: /* magic_identifiers1: TOK_LOCAL_ID  */
#line 1118 "language.yacc"
                   { (yyval.str) = "local"; }
#line 5060 "y.tab.c"
    break;

  case 105: /* magic_identifiers1: TOK_PUBLIC  */
#line 1119 "language.yacc"
                   { (yyval.str) = "public"; }
#line 5066 "y.tab.c"
    break;

  case 106: /* magic_identifiers1: TOK_PROTECTED  */
#line 1120 "language.yacc"
                   { (yyval.str) = "protected"; }
#line 5072 "y.tab.c"
    break;

  case 107: /* magic_identifiers1: TOK_INLINE  */
#line 1121 "language.yacc"
                   { (yyval.str) = "inline"; }
#line 5078 "y.tab.c"
    break;

  case 108: /* magic_identifiers1: TOK_OPTIONAL  */
#line 1122 "language.yacc"
                   { (yyval.str) = "optional"; }
#line 5084 "y.tab.c"
    break;

  case 109: /* magic_identifiers1: TOK_VARIANT  */
#line 1123 "language.yacc"
                   { (yyval.str) = "variant"; }
#line 5090 "y.tab.c"
    break;

  case 110: /* magic_identifiers2: TOK_VOID_ID  */
#line 1127 "language.yacc"
                      { (yyval.str) = "void"; }
#line 5096 "y.tab.c"
    break;

  case 111: /* magic_identifiers2: TOK_MIXED_ID  */
#line 1128 "language.yacc"
                      { (yyval.str) = "mixed"; }
#line 5102 "y.tab.c"
    break;

  case 112: /* magic_identifiers2: TOK_ARRAY_ID  */
#line 1129 "language.yacc"
                      { (yyval.str) = "array"; }
#line 5108 "y.tab.c"
    break;

  case 113: /* magic_identifiers2: TOK_ATTRIBUTE_ID  */
#line 1130 "language.yacc"
                      { (yyval.str) = "__attribute__"; }
#line 5114 "y.tab.c"
    break;

  case 114: /* magic_identifiers2: TOK_DEPRECATED_ID  */
#line 1131 "language.yacc"
                      { (yyval.str) = "__deprecated__"; }
#line 5120 "y.tab.c"
    break;

  case 115: /* magic_identifiers2: TOK_MAPPING_ID  */
#line 1132 "language.yacc"
                      { (yyval.str) = "mapping"; }
#line 5126 "y.tab.c"
    break;

  case 116: /* magic_identifiers2: TOK_MULTISET_ID  */
#line 1133 "language.yacc"
                      { (yyval.str) = "multiset"; }
#line 5132 "y.tab.c"
    break;

  case 117: /* magic_identifiers2: TOK_OBJECT_ID  */
#line 1134 "language.yacc"
                      { (yyval.str) = "object"; }
#line 5138 "y.tab.c"
    break;

  case 118: /* magic_identifiers2: TOK_FUNCTION_ID  */
#line 1135 "language.yacc"
                      { (yyval.str) = "function"; }
#line 5144 "y.tab.c"
    break;

  case 119: /* magic_identifiers2: TOK_FUNCTION_NAME  */
#line 1136 "language.yacc"
                      { (yyval.str) = "__func__"; }
#line 5150 "y.tab.c"
    break;

  case 120: /* magic_identifiers2: TOK_PROGRAM_ID  */
#line 1137 "language.yacc"
                      { (yyval.str) = "program"; }
#line 5156 "y.tab.c"
    break;

  case 121: /* magic_identifiers2: TOK_STRING_ID  */
#line 1138 "language.yacc"
                      { (yyval.str) = "string"; }
#line 5162 "y.tab.c"
    break;

  case 122: /* magic_identifiers2: TOK_FLOAT_ID  */
#line 1139 "language.yacc"
                      { (yyval.str) = "float"; }
#line 5168 "y.tab.c"
    break;

  case 123: /* magic_identifiers2: TOK_INT_ID  */
#line 1140 "language.yacc"
                      { (yyval.str) = "int"; }
#line 5174 "y.tab.c"
    break;

  case 124: /* magic_identifiers2: TOK_ENUM  */
#line 1141 "language.yacc"
                      { (yyval.str) = "enum"; }
#line 5180 "y.tab.c"
    break;

  case 125: /* magic_identifiers2: TOK_TYPEDEF  */
#line 1142 "language.yacc"
                      { (yyval.str) = "typedef"; }
#line 5186 "y.tab.c"
    break;

  case 126: /* magic_identifiers3: TOK_IF  */
#line 1146 "language.yacc"
                   { (yyval.str) = "if"; }
#line 5192 "y.tab.c"
    break;

  case 127: /* magic_identifiers3: TOK_DO  */
#line 1147 "language.yacc"
                   { (yyval.str) = "do"; }
#line 5198 "y.tab.c"
    break;

  case 128: /* magic_identifiers3: TOK_FOR  */
#line 1148 "language.yacc"
                   { (yyval.str) = "for"; }
#line 5204 "y.tab.c"
    break;

  case 129: /* magic_identifiers3: TOK_WHILE  */
#line 1149 "language.yacc"
                   { (yyval.str) = "while"; }
#line 5210 "y.tab.c"
    break;

  case 130: /* magic_identifiers3: TOK_ELSE  */
#line 1150 "language.yacc"
                   { (yyval.str) = "else"; }
#line 5216 "y.tab.c"
    break;

  case 131: /* magic_identifiers3: TOK_FOREACH  */
#line 1151 "language.yacc"
                   { (yyval.str) = "foreach"; }
#line 5222 "y.tab.c"
    break;

  case 132: /* magic_identifiers3: TOK_CATCH  */
#line 1152 "language.yacc"
                   { (yyval.str) = "catch"; }
#line 5228 "y.tab.c"
    break;

  case 133: /* magic_identifiers3: TOK_GAUGE  */
#line 1153 "language.yacc"
                   { (yyval.str) = "gauge"; }
#line 5234 "y.tab.c"
    break;

  case 134: /* magic_identifiers3: TOK_CLASS  */
#line 1154 "language.yacc"
                   { (yyval.str) = "class"; }
#line 5240 "y.tab.c"
    break;

  case 135: /* magic_identifiers3: TOK_BREAK  */
#line 1155 "language.yacc"
                   { (yyval.str) = "break"; }
#line 5246 "y.tab.c"
    break;

  case 136: /* magic_identifiers3: TOK_CASE  */
#line 1156 "language.yacc"
                   { (yyval.str) = "case"; }
#line 5252 "y.tab.c"
    break;

  case 137: /* magic_identifiers3: TOK_CONSTANT  */
#line 1157 "language.yacc"
                   { (yyval.str) = "constant"; }
#line 5258 "y.tab.c"
    break;

  case 138: /* magic_identifiers3: TOK_CONTINUE  */
#line 1158 "language.yacc"
                   { (yyval.str) = "continue"; }
#line 5264 "y.tab.c"
    break;

  case 139: /* magic_identifiers3: TOK_DEFAULT  */
#line 1159 "language.yacc"
                   { (yyval.str) = "default"; }
#line 5270 "y.tab.c"
    break;

  case 140: /* magic_identifiers3: TOK_IMPORT  */
#line 1160 "language.yacc"
                   { (yyval.str) = "import"; }
#line 5276 "y.tab.c"
    break;

  case 141: /* magic_identifiers3: TOK_INHERIT  */
#line 1161 "language.yacc"
                   { (yyval.str) = "inherit"; }
#line 5282 "y.tab.c"
    break;

  case 142: /* magic_identifiers3: TOK_LAMBDA  */
#line 1162 "language.yacc"
                   { (yyval.str) = "lambda"; }
#line 5288 "y.tab.c"
    break;

  case 143: /* magic_identifiers3: TOK_PREDEF  */
#line 1163 "language.yacc"
                   { (yyval.str) = "predef"; }
#line 5294 "y.tab.c"
    break;

  case 144: /* magic_identifiers3: TOK_RETURN  */
#line 1164 "language.yacc"
                   { (yyval.str) = "return"; }
#line 5300 "y.tab.c"
    break;

  case 145: /* magic_identifiers3: TOK_SSCANF  */
#line 1165 "language.yacc"
                   { (yyval.str) = "sscanf"; }
#line 5306 "y.tab.c"
    break;

  case 146: /* magic_identifiers3: TOK_SWITCH  */
#line 1166 "language.yacc"
                   { (yyval.str) = "switch"; }
#line 5312 "y.tab.c"
    break;

  case 147: /* magic_identifiers3: TOK_TYPEOF  */
#line 1167 "language.yacc"
                   { (yyval.str) = "typeof"; }
#line 5318 "y.tab.c"
    break;

  case 148: /* magic_identifiers3: TOK_GLOBAL  */
#line 1168 "language.yacc"
                   { (yyval.str) = "global"; }
#line 5324 "y.tab.c"
    break;

  case 154: /* magic_identifier: magic_identifiers  */
#line 1175 "language.yacc"
  {
    struct pike_string *tmp=make_shared_string((yyvsp[0].str));
    (yyval.n)=mkstrnode(tmp);
    free_string(tmp);
  }
#line 5334 "y.tab.c"
    break;

  case 155: /* modifiers: modifier_list  */
#line 1183 "language.yacc"
 {
   (yyval.number)=Pike_compiler->current_modifiers=(yyvsp[0].number) |
     (THIS_COMPILATION->lex.pragmas & ID_MODIFIER_MASK);
 }
#line 5343 "y.tab.c"
    break;

  case 156: /* modifier_list: %empty  */
#line 1189 "language.yacc"
                           { (yyval.number) = 0; }
#line 5349 "y.tab.c"
    break;

  case 157: /* modifier_list: modifier_list modifier  */
#line 1190 "language.yacc"
                           { (yyval.number) = (yyvsp[-1].number) | (yyvsp[0].number); }
#line 5355 "y.tab.c"
    break;

  case 158: /* attribute: TOK_ATTRIBUTE_ID '(' string_constant optional_comma ')'  */
#line 1194 "language.yacc"
  {
    (yyval.n) = (yyvsp[-2].n);
  }
#line 5363 "y.tab.c"
    break;

  case 159: /* attribute: TOK_DEPRECATED_ID '(' ')'  */
#line 1198 "language.yacc"
  {
    struct pike_string *deprecated_string;
    MAKE_CONST_STRING(deprecated_string, "deprecated");
    (yyval.n) = mkstrnode(deprecated_string);
  }
#line 5373 "y.tab.c"
    break;

  case 160: /* attribute: TOK_DEPRECATED_ID  */
#line 1204 "language.yacc"
  {
    struct pike_string *deprecated_string;
    MAKE_CONST_STRING(deprecated_string, "deprecated");
    (yyval.n) = mkstrnode(deprecated_string);
  }
#line 5383 "y.tab.c"
    break;

  case 161: /* optional_attributes: %empty  */
#line 1212 "language.yacc"
  {
    if (Pike_compiler->current_attributes) {
      free_node(Pike_compiler->current_attributes);
    }
    if ((Pike_compiler->current_attributes =
	 THIS_COMPILATION->lex.attributes)) {
      add_ref(Pike_compiler->current_attributes);
    }
  }
#line 5397 "y.tab.c"
    break;

  case 162: /* optional_attributes: optional_attributes attribute  */
#line 1222 "language.yacc"
  {
    if ((yyvsp[0].n)) {
      Pike_compiler->current_attributes =
	mknode(F_ARG_LIST, Pike_compiler->current_attributes, (yyvsp[0].n));
    }
  }
#line 5408 "y.tab.c"
    break;

  case 163: /* optional_stars: %empty  */
#line 1230 "language.yacc"
                             { (yyval.number)=0; }
#line 5414 "y.tab.c"
    break;

  case 164: /* cast: open_paren_with_line_info type ')'  */
#line 1234 "language.yacc"
    {
      struct pike_type *s = compiler_pop_type();
      (yyval.n) = mktypenode(s);
      free_type(s);
      COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-2].n));
      free_node ((yyvsp[-2].n));
    }
#line 5426 "y.tab.c"
    break;

  case 165: /* soft_cast: open_bracket_with_line_info type ']'  */
#line 1244 "language.yacc"
    {
      struct pike_type *s = compiler_pop_type();
      (yyval.n) = mktypenode(s);
      free_type(s);
      COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-2].n));
      free_node ((yyvsp[-2].n));
    }
#line 5438 "y.tab.c"
    break;

  case 168: /* simple_type: full_type  */
#line 1256 "language.yacc"
  {
    struct pike_type *s = compiler_pop_type();
    (yyval.n) = mktypenode(s);
#ifdef PIKE_DEBUG
    if ((yyval.n)->u.sval.u.type != s) {
      Pike_fatal("mktypenode(%p) created node with %p\n", s, (yyval.n)->u.sval.u.type);
    }
#endif /* PIKE_DEBUG */
    free_type(s);
  }
#line 5453 "y.tab.c"
    break;

  case 169: /* simple_type2: type  */
#line 1269 "language.yacc"
  {
    struct pike_type *s = compiler_pop_type();
    (yyval.n) = mktypenode(s);
#ifdef PIKE_DEBUG
    if ((yyval.n)->u.sval.u.type != s) {
      Pike_fatal("mktypenode(%p) created node with %p\n", s, (yyval.n)->u.sval.u.type);
    }
#endif /* PIKE_DEBUG */
    free_type(s);
  }
#line 5468 "y.tab.c"
    break;

  case 170: /* simple_identifier_type: identifier_type  */
#line 1282 "language.yacc"
  {
    struct pike_type *s = compiler_pop_type();
    (yyval.n) = mktypenode(s);
#ifdef PIKE_DEBUG
    if ((yyval.n)->u.sval.u.type != s) {
      Pike_fatal("mktypenode(%p) created node with %p\n", s, (yyval.n)->u.sval.u.type);
    }
#endif /* PIKE_DEBUG */
    free_type(s);
  }
#line 5483 "y.tab.c"
    break;

  case 171: /* full_type: full_type '|' type3  */
#line 1294 "language.yacc"
                               { push_type(T_OR); }
#line 5489 "y.tab.c"
    break;

  case 173: /* type: type '|' type3  */
#line 1298 "language.yacc"
                     { push_type(T_OR); }
#line 5495 "y.tab.c"
    break;

  case 177: /* basic_type: TOK_FLOAT_ID  */
#line 1305 "language.yacc"
                                      { push_type(T_FLOAT); }
#line 5501 "y.tab.c"
    break;

  case 178: /* basic_type: TOK_VOID_ID  */
#line 1306 "language.yacc"
                                      { push_type(T_VOID); }
#line 5507 "y.tab.c"
    break;

  case 179: /* basic_type: TOK_MIXED_ID  */
#line 1307 "language.yacc"
                                      { push_type(T_MIXED); }
#line 5513 "y.tab.c"
    break;

  case 180: /* basic_type: TOK_STRING_ID opt_string_width  */
#line 1308 "language.yacc"
                                      {}
#line 5519 "y.tab.c"
    break;

  case 181: /* basic_type: TOK_INT_ID opt_int_range  */
#line 1309 "language.yacc"
                                      {}
#line 5525 "y.tab.c"
    break;

  case 182: /* basic_type: TOK_MAPPING_ID opt_mapping_type  */
#line 1310 "language.yacc"
                                      {}
#line 5531 "y.tab.c"
    break;

  case 183: /* basic_type: TOK_FUNCTION_ID opt_function_type  */
#line 1311 "language.yacc"
                                      {}
#line 5537 "y.tab.c"
    break;

  case 184: /* basic_type: TOK_OBJECT_ID opt_object_type  */
#line 1312 "language.yacc"
                                      {}
#line 5543 "y.tab.c"
    break;

  case 185: /* basic_type: TOK_PROGRAM_ID opt_program_type  */
#line 1313 "language.yacc"
                                      { push_type(T_PROGRAM); }
#line 5549 "y.tab.c"
    break;

  case 186: /* basic_type: TOK_ARRAY_ID opt_array_type  */
#line 1314 "language.yacc"
                                      { push_type(T_ARRAY); }
#line 5555 "y.tab.c"
    break;

  case 187: /* basic_type: TOK_MULTISET_ID opt_array_type  */
#line 1315 "language.yacc"
                                      { push_type(T_MULTISET); }
#line 5561 "y.tab.c"
    break;

  case 188: /* basic_type: TOK_ATTRIBUTE_ID '(' string_constant ',' full_type ')'  */
#line 1317 "language.yacc"
  {
    push_type_attribute((yyvsp[-3].n)->u.sval.u.string);
    free_node((yyvsp[-3].n));
  }
#line 5570 "y.tab.c"
    break;

  case 189: /* basic_type: TOK_ATTRIBUTE_ID '(' string_constant error ')'  */
#line 1322 "language.yacc"
  {
    push_type(T_MIXED);
    push_type_attribute((yyvsp[-2].n)->u.sval.u.string);
    free_node((yyvsp[-2].n));
  }
#line 5580 "y.tab.c"
    break;

  case 190: /* basic_type: TOK_ATTRIBUTE_ID error  */
#line 1328 "language.yacc"
  {
    push_type(T_MIXED);
  }
#line 5588 "y.tab.c"
    break;

  case 191: /* basic_type: TOK_DEPRECATED_ID '(' full_type ')'  */
#line 1332 "language.yacc"
  {
    struct pike_string *deprecated_string;
    MAKE_CONST_STRING(deprecated_string, "deprecated");
    push_type_attribute(deprecated_string);
  }
#line 5598 "y.tab.c"
    break;

  case 192: /* basic_type: TOK_DEPRECATED_ID '(' error ')'  */
#line 1338 "language.yacc"
  {
    struct pike_string *deprecated_string;
    MAKE_CONST_STRING(deprecated_string, "deprecated");
    push_type(T_MIXED);
    push_type_attribute(deprecated_string);
  }
#line 5609 "y.tab.c"
    break;

  case 193: /* identifier_type: idents  */
#line 1347 "language.yacc"
  {
    if ((yyvsp[0].n)) {
      fix_type_field((yyvsp[0].n));

      if (!pike_types_le((yyvsp[0].n)->type, typeable_type_string) &&
	  (THIS_COMPILATION->lex.pragmas & ID_STRICT_TYPES)) {
	yytype_report(REPORT_WARNING,
		      (yyvsp[0].n)->current_file, (yyvsp[0].n)->line_number, typeable_type_string,
		      (yyvsp[0].n)->current_file, (yyvsp[0].n)->line_number, (yyvsp[0].n)->type,
		      0, "Invalid type.");
      }
    }

    resolv_constant((yyvsp[0].n));

    if (TYPEOF(Pike_sp[-1]) == T_TYPE) {
      /* "typedef" */
      push_finished_type(Pike_sp[-1].u.type);
    } else {
      /* object type */
      struct program *p = NULL;

      if (TYPEOF(Pike_sp[-1]) == T_OBJECT) {
	if(!(p = Pike_sp[-1].u.object->prog))
	{
	  pop_stack();
	  push_int(0);
	  yyerror("Destructed object used as program identifier.");
	}else{
	  int f = FIND_LFUN(p->inherits[SUBTYPEOF(Pike_sp[-1])].prog,
			    LFUN_CALL);
	  if(f!=-1)
	  {
	    SET_SVAL_SUBTYPE(Pike_sp[-1],
			     f + p->inherits[SUBTYPEOF(Pike_sp[-1])].
			     identifier_level);
	    SET_SVAL_TYPE(Pike_sp[-1], T_FUNCTION);
	  }else{
	    extern void f_object_program(INT32);
	    if (Pike_compiler->compiler_pass == 2)
	      yywarning("Using object as program identifier.");
	    f_object_program(1);
	  }
	}
      }

      switch(TYPEOF(Pike_sp[-1])) {
	case T_FUNCTION:
	if((p = program_from_function(Pike_sp-1))) {
	  push_object_type(0, p?(p->id):0);
	  break;
	} else {
	  /* Attempt to get the return type for the function. */
	  struct pike_type *a, *b;
	  a = get_type_of_svalue(Pike_sp-1);
	  /* Note: check_splice_call() below eats a reference from a.
	   * Note: CALL_INHIBIT_WARNINGS is needed since we don't
	   *       provide a function name (and we don't want
	   *       warnings here anyway).
	   */
	  a = check_splice_call(NULL, a, 0, mixed_type_string, NULL,
				CALL_INHIBIT_WARNINGS);
	  if (a) {
	    b = new_get_return_type(a, 0);
	    free_type(a);
	    if (b) {
	      push_finished_type(b);
	      free_type(b);
	      break;
	    }
	  }
	}
	/* FALL_THROUGH */

      default:
	if (Pike_compiler->compiler_pass!=1)
	  my_yyerror("Illegal program identifier: %O.", Pike_sp-1);
	pop_stack();
	push_int(0);
	push_object_type(0, 0);
	break;

      case T_PROGRAM:
	p = Pike_sp[-1].u.program;
	push_object_type(0, p?(p->id):0);
	break;
      }
    }
    /* Attempt to name the type. */
    if (Pike_compiler->last_identifier) {
      push_type_name(Pike_compiler->last_identifier);
    }
    pop_stack();
    free_node((yyvsp[0].n));
  }
#line 5709 "y.tab.c"
    break;

  case 194: /* number_or_maxint: %empty  */
#line 1445 "language.yacc"
  {
    (yyval.n) = mkintnode(MAX_INT_TYPE);
  }
#line 5717 "y.tab.c"
    break;

  case 196: /* number_or_maxint: '-' TOK_NUMBER  */
#line 1450 "language.yacc"
  {
#ifdef PIKE_DEBUG
    if (((yyvsp[0].n)->token != F_CONSTANT) || (TYPEOF((yyvsp[0].n)->u.sval) != T_INT)) {
      Pike_fatal("Unexpected number in negative int-range.\n");
    }
#endif /* PIKE_DEBUG */
    (yyval.n) = mkintnode(-((yyvsp[0].n)->u.sval.u.integer));
    free_node((yyvsp[0].n));
  }
#line 5731 "y.tab.c"
    break;

  case 197: /* number_or_minint: %empty  */
#line 1462 "language.yacc"
  {
    (yyval.n) = mkintnode(MIN_INT_TYPE);
  }
#line 5739 "y.tab.c"
    break;

  case 199: /* number_or_minint: '-' TOK_NUMBER  */
#line 1467 "language.yacc"
  {
#ifdef PIKE_DEBUG
    if (((yyvsp[0].n)->token != F_CONSTANT) || (TYPEOF((yyvsp[0].n)->u.sval) != T_INT)) {
      Pike_fatal("Unexpected number in negative int-range.\n");
    }
#endif /* PIKE_DEBUG */
    (yyval.n) = mkintnode(-((yyvsp[0].n)->u.sval.u.integer));
    free_node((yyvsp[0].n));
  }
#line 5753 "y.tab.c"
    break;

  case 201: /* expected_dot_dot: TOK_DOT_DOT_DOT  */
#line 1480 "language.yacc"
  {
    yyerror("Elipsis ('...') where range indicator ('..') expected.");
  }
#line 5761 "y.tab.c"
    break;

  case 202: /* opt_int_range: %empty  */
#line 1486 "language.yacc"
  {
    push_int_type(MIN_INT_TYPE, MAX_INT_TYPE);
  }
#line 5769 "y.tab.c"
    break;

  case 203: /* opt_int_range: '(' TOK_BITS ')'  */
#line 1490 "language.yacc"
  {
      push_int_type( 0, (1<<(yyvsp[-1].n)->u.sval.u.integer)-1 );
      free_node( (yyvsp[-1].n) );
  }
#line 5778 "y.tab.c"
    break;

  case 204: /* opt_int_range: '(' number_or_minint expected_dot_dot number_or_maxint ')'  */
#line 1495 "language.yacc"
  {
    INT_TYPE min = MIN_INT_TYPE;
    INT_TYPE max = MAX_INT_TYPE;

    /* FIXME: Check that $4 is >= $2. */
    if((yyvsp[-1].n)->token == F_CONSTANT) {
      if (TYPEOF((yyvsp[-1].n)->u.sval) == T_INT) {
	max = (yyvsp[-1].n)->u.sval.u.integer;
      } else if (is_bignum_object_in_svalue(&(yyvsp[-1].n)->u.sval)) {
	push_int(0);
	if (is_lt(&(yyvsp[-1].n)->u.sval, Pike_sp-1)) {
	  max = MIN_INT_TYPE;
	}
	pop_stack();
      }
    }

    if((yyvsp[-3].n)->token == F_CONSTANT) {
      if (TYPEOF((yyvsp[-3].n)->u.sval) == T_INT) {
	min = (yyvsp[-3].n)->u.sval.u.integer;
      } else if (is_bignum_object_in_svalue(&(yyvsp[-3].n)->u.sval)) {
	push_int(0);
	if (is_lt(Pike_sp-1, &(yyvsp[-3].n)->u.sval)) {
	  min = MAX_INT_TYPE;
	}
	pop_stack();
      }
    }

    push_int_type(min, max);

    free_node((yyvsp[-3].n));
    free_node((yyvsp[-1].n));
  }
#line 5817 "y.tab.c"
    break;

  case 205: /* opt_int_range: '(' error ')'  */
#line 1530 "language.yacc"
  {
    push_int_type(MIN_INT32, MAX_INT32);
    yyerror("Expected integer range.");
  }
#line 5826 "y.tab.c"
    break;

  case 206: /* opt_string_width: opt_int_range  */
#line 1537 "language.yacc"
  {
    push_type(T_STRING);
  }
#line 5834 "y.tab.c"
    break;

  case 207: /* opt_object_type: %empty  */
#line 1542 "language.yacc"
                              { push_object_type(0, 0); }
#line 5840 "y.tab.c"
    break;

  case 208: /* @6: %empty  */
#line 1543 "language.yacc"
    {
#ifdef PIKE_DEBUG
      (yyval.ptr) = Pike_sp;
#endif /* PIKE_DEBUG */
    }
#line 5850 "y.tab.c"
    break;

  case 209: /* opt_object_type: @6 '(' program_ref ')'  */
#line 1549 "language.yacc"
  {
    /* NOTE: On entry, there are two items on the stack:
     *   Pike_sp-2:	Name of the program reference (string).
     *   Pike_sp-1:	The resolved program (program|function|zero).
     */
    struct program *p=program_from_svalue(Pike_sp-1);

#ifdef PIKE_DEBUG
    if ((yyvsp[-3].ptr) != (Pike_sp - 2)) {
      Pike_fatal("Unexpected stack depth: %p != %p\n",
		 (yyvsp[-3].n), Pike_sp-2);
    }
#endif /* PIKE_DEBUG */

    if(!p) {
      if (Pike_compiler->compiler_pass!=1) {
	my_yyerror("Not a valid program specifier: %S", Pike_sp[-2].u.string);
      }
    }
    push_object_type(0, p?(p->id):0);
    /* Attempt to name the type. */
    if (TYPEOF(Pike_sp[-2]) == T_STRING) {
      push_type_name(Pike_sp[-2].u.string);
    }
    pop_n_elems(2);
  }
#line 5881 "y.tab.c"
    break;

  case 210: /* opt_program_type: %empty  */
#line 1577 "language.yacc"
                               { push_object_type(0, 0); }
#line 5887 "y.tab.c"
    break;

  case 212: /* opt_program_type: '(' error ')'  */
#line 1580 "language.yacc"
  {
    push_object_type(0, 0);
    yyerror("Invalid program subtype.");
  }
#line 5896 "y.tab.c"
    break;

  case 213: /* $@7: %empty  */
#line 1587 "language.yacc"
  {
    type_stack_mark();
  }
#line 5904 "y.tab.c"
    break;

  case 214: /* $@8: %empty  */
#line 1591 "language.yacc"
  {
    /* Add the many type if there is none. */
    if ((yyvsp[-1].number))
    {
      if (!(yyvsp[-2].number)) {
	/* function_type_list ends with a comma, or is empty.
	 * FIXME: Should this be a syntax error or not?
	 */
	if (Pike_compiler->compiler_pass == 1) {
	  yyerror("Missing type before ... .");
	}
	push_type(T_MIXED);
      }
    }else{
      push_type(T_VOID);
    }
  }
#line 5926 "y.tab.c"
    break;

  case 215: /* opt_function_type: '(' $@7 function_type_list optional_dot_dot_dot ':' $@8 full_type ')'  */
#line 1609 "language.yacc"
  {
    push_reverse_type(T_MANY);
    Pike_compiler->pike_type_mark_stackp--;
    while (*Pike_compiler->pike_type_mark_stackp+1 <
	   Pike_compiler->type_stackp) {
      push_reverse_type(T_FUNCTION);
    }
  }
#line 5939 "y.tab.c"
    break;

  case 216: /* opt_function_type: %empty  */
#line 1618 "language.yacc"
  {
   push_type(T_MIXED);
   push_type(T_VOID);
   push_type(T_OR);

   push_type(T_ZERO);
   push_type(T_VOID);
   push_type(T_OR);

   push_type(T_MANY);
  }
#line 5955 "y.tab.c"
    break;

  case 217: /* function_type_list: optional_comma  */
#line 1631 "language.yacc"
                                               { (yyval.number)=0; }
#line 5961 "y.tab.c"
    break;

  case 218: /* function_type_list: function_type_list2 optional_comma  */
#line 1632 "language.yacc"
                                       { (yyval.number)=!(yyvsp[0].number); }
#line 5967 "y.tab.c"
    break;

  case 219: /* function_type_list2: full_type  */
#line 1635 "language.yacc"
                               { (yyval.number)=1; }
#line 5973 "y.tab.c"
    break;

  case 220: /* $@9: %empty  */
#line 1637 "language.yacc"
  {
  }
#line 5980 "y.tab.c"
    break;

  case 223: /* opt_array_type: %empty  */
#line 1643 "language.yacc"
     { push_type(T_MIXED); }
#line 5986 "y.tab.c"
    break;

  case 224: /* $@10: %empty  */
#line 1647 "language.yacc"
  {
  }
#line 5993 "y.tab.c"
    break;

  case 225: /* $@11: %empty  */
#line 1650 "language.yacc"
  {
  }
#line 6000 "y.tab.c"
    break;

  case 226: /* $@12: %empty  */
#line 1653 "language.yacc"
  {
    push_reverse_type(T_MAPPING);
  }
#line 6008 "y.tab.c"
    break;

  case 228: /* opt_mapping_type: %empty  */
#line 1658 "language.yacc"
  {
    push_type(T_MIXED);
    push_type(T_MIXED);
    push_type(T_MAPPING);
  }
#line 6018 "y.tab.c"
    break;

  case 231: /* new_name: optional_stars TOK_IDENTIFIER  */
#line 1671 "language.yacc"
  {
    struct pike_type *type;
    node *n;
    push_finished_type(Pike_compiler->compiler_frame->current_type);
    n = Pike_compiler->current_attributes;
    while(n) {
      push_type_attribute(CDR(n)->u.sval.u.string);
      n = CAR(n);
    }
    type=compiler_pop_type();
    define_variable((yyvsp[0].n)->u.sval.u.string, type,
		    Pike_compiler->current_modifiers);
    free_type(type);
    free_node((yyvsp[0].n));
  }
#line 6038 "y.tab.c"
    break;

  case 232: /* new_name: optional_stars bad_identifier  */
#line 1686 "language.yacc"
                                  {}
#line 6044 "y.tab.c"
    break;

  case 233: /* @13: %empty  */
#line 1688 "language.yacc"
  {
    struct pike_type *type;
    node *n;
    push_finished_type(Pike_compiler->compiler_frame->current_type);
    n = Pike_compiler->current_attributes;
    while(n) {
      push_type_attribute(CDR(n)->u.sval.u.string);
      n = CAR(n);
    }
    type=compiler_pop_type();
    if ((Pike_compiler->current_modifiers & ID_EXTERN) &&
	(Pike_compiler->compiler_pass == 1)) {
      yywarning("Extern declared variable has initializer.");
    }
    (yyval.number)=define_variable((yyvsp[-1].n)->u.sval.u.string, type,
			       Pike_compiler->current_modifiers & (~ID_EXTERN));
    free_type(type);
  }
#line 6067 "y.tab.c"
    break;

  case 234: /* new_name: optional_stars TOK_IDENTIFIER '=' @13 expr0  */
#line 1707 "language.yacc"
  {
    if ((Pike_compiler->compiler_pass == 2) &&
	!TEST_COMPAT(7, 8) && ((yyvsp[0].n)) && ((yyvsp[0].n)->token == F_CONSTANT) &&
	!Pike_compiler->num_parse_error) {
      /* Check if it is zero, in which case we can throw it away.
       *
       * NB: The compat test is due to that this changes the semantics
       *     of calling __INIT() by hand.
       */
      if ((TYPEOF((yyvsp[0].n)->u.sval) == PIKE_T_INT) && !SUBTYPEOF((yyvsp[0].n)->u.sval) &&
	  !(yyvsp[0].n)->u.sval.u.integer &&
	  !IDENTIFIER_IS_ALIAS(ID_FROM_INT(Pike_compiler->new_program,
					   (yyvsp[-1].number))->identifier_flags)) {
	/* NB: Inherited variables get converted into aliases by
	 *     define_variable, and we need to support clearing
	 *     of inherited variables.
	 */
#ifdef PIKE_DEBUG
	if (l_flag > 5) {
	  fprintf(stderr,
		  "Ignoring initialization to zero for variable %s.\n",
		  (yyvsp[-3].n)->u.sval.u.string->str);
	}
#endif /* PIKE_DEBUG */
	free_node((yyvsp[0].n));
	(yyvsp[0].n) = NULL;
      }
    }
    if ((yyvsp[0].n)) {
      Pike_compiler->init_node=mknode(F_COMMA_EXPR,Pike_compiler->init_node,
		       mkcastnode(void_type_string,
				  mknode(F_ASSIGN,(yyvsp[0].n),
					 mkidentifiernode((yyvsp[-1].number)))));
    }
    free_node((yyvsp[-3].n));
  }
#line 6108 "y.tab.c"
    break;

  case 235: /* new_name: optional_stars TOK_IDENTIFIER '=' error  */
#line 1744 "language.yacc"
  {
    free_node((yyvsp[-2].n));
  }
#line 6116 "y.tab.c"
    break;

  case 236: /* new_name: optional_stars TOK_IDENTIFIER '=' TOK_LEX_EOF  */
#line 1748 "language.yacc"
  {
    yyerror("Unexpected end of file in variable definition.");
    free_node((yyvsp[-2].n));
  }
#line 6125 "y.tab.c"
    break;

  case 237: /* new_name: optional_stars bad_identifier '=' expr0  */
#line 1753 "language.yacc"
  {
    free_node((yyvsp[0].n));
  }
#line 6133 "y.tab.c"
    break;

  case 238: /* new_local_name: optional_stars TOK_IDENTIFIER  */
#line 1760 "language.yacc"
  {
    int id;
    push_finished_type((yyvsp[-2].n)->u.sval.u.type);
    id = add_local_name((yyvsp[0].n)->u.sval.u.string, compiler_pop_type(),0);
    if (id >= 0) {
      /* FIXME: Consider using mklocalnode(id, -1). */
      (yyval.n)=mknode(F_ASSIGN,mkintnode(0),mklocalnode(id,0));
    } else
      (yyval.n) = 0;
    free_node((yyvsp[0].n));
  }
#line 6149 "y.tab.c"
    break;

  case 239: /* new_local_name: optional_stars bad_identifier  */
#line 1771 "language.yacc"
                                  { (yyval.n)=0; }
#line 6155 "y.tab.c"
    break;

  case 240: /* new_local_name: optional_stars TOK_IDENTIFIER '=' expr0  */
#line 1773 "language.yacc"
  {
    int id;
    push_finished_type((yyvsp[-4].n)->u.sval.u.type);
    id = add_local_name((yyvsp[-2].n)->u.sval.u.string, compiler_pop_type(),0);
    if (id >= 0) {
      if (!(THIS_COMPILATION->lex.pragmas & ID_STRICT_TYPES)) {
	/* Only warn about unused initialized variables in strict types mode. */
	Pike_compiler->compiler_frame->variable[id].flags |= LOCAL_VAR_IS_USED;
      }
      (yyval.n)=mknode(F_ASSIGN,(yyvsp[0].n),mklocalnode(id,0));
    } else
      (yyval.n) = 0;
    free_node((yyvsp[-2].n));
  }
#line 6174 "y.tab.c"
    break;

  case 241: /* new_local_name: optional_stars bad_identifier '=' expr0  */
#line 1788 "language.yacc"
  {
    free_node((yyvsp[0].n));
    (yyval.n)=0;
  }
#line 6183 "y.tab.c"
    break;

  case 242: /* new_local_name: optional_stars TOK_IDENTIFIER '=' error  */
#line 1793 "language.yacc"
  {
    free_node((yyvsp[-2].n));
    /* No yyerok here since we aren't done yet. */
    (yyval.n)=0;
  }
#line 6193 "y.tab.c"
    break;

  case 243: /* new_local_name: optional_stars TOK_IDENTIFIER '=' TOK_LEX_EOF  */
#line 1799 "language.yacc"
  {
    yyerror("Unexpected end of file in local variable definition.");
    free_node((yyvsp[-2].n));
    /* No yyerok here since we aren't done yet. */
    (yyval.n)=0;
  }
#line 6204 "y.tab.c"
    break;

  case 244: /* new_local_name2: TOK_IDENTIFIER  */
#line 1808 "language.yacc"
  {
    int id;
    add_ref((yyvsp[-1].n)->u.sval.u.type);
    id = add_local_name((yyvsp[0].n)->u.sval.u.string, (yyvsp[-1].n)->u.sval.u.type, 0);
    if (id >= 0) {
      /* FIXME: Consider using mklocalnode(id, -1). */
      (yyval.n)=mknode(F_ASSIGN,mkintnode(0),mklocalnode(id,0));
    } else
      (yyval.n) = 0;
    free_node((yyvsp[0].n));
  }
#line 6220 "y.tab.c"
    break;

  case 245: /* new_local_name2: bad_identifier  */
#line 1819 "language.yacc"
                   { (yyval.n)=0; }
#line 6226 "y.tab.c"
    break;

  case 246: /* new_local_name2: TOK_IDENTIFIER '=' safe_expr0  */
#line 1821 "language.yacc"
  {
    int id;
    add_ref((yyvsp[-3].n)->u.sval.u.type);
    id = add_local_name((yyvsp[-2].n)->u.sval.u.string, (yyvsp[-3].n)->u.sval.u.type, 0);
    if (id >= 0) {
      if (!(THIS_COMPILATION->lex.pragmas & ID_STRICT_TYPES)) {
	/* Only warn about unused initialized variables in strict types mode. */
	Pike_compiler->compiler_frame->variable[id].flags |= LOCAL_VAR_IS_USED;
      }
      (yyval.n)=mknode(F_ASSIGN,(yyvsp[0].n), mklocalnode(id,0));
    } else
      (yyval.n) = 0;
    free_node((yyvsp[-2].n));
  }
#line 6245 "y.tab.c"
    break;

  case 247: /* new_local_name2: bad_identifier '=' safe_expr0  */
#line 1835 "language.yacc"
                                  { (yyval.n)=(yyvsp[0].n); }
#line 6251 "y.tab.c"
    break;

  case 248: /* line_number_info: %empty  */
#line 1839 "language.yacc"
  {
    /* Used to hold line-number info */
    (yyval.n) = mkintnode(0);
  }
#line 6260 "y.tab.c"
    break;

  case 249: /* @14: %empty  */
#line 1846 "language.yacc"
  {
    (yyvsp[0].number)=Pike_compiler->num_used_modules;
    (yyval.number)=Pike_compiler->compiler_frame->current_number_of_locals;
  }
#line 6269 "y.tab.c"
    break;

  case 250: /* @15: %empty  */
#line 1851 "language.yacc"
  {
    /* Trick to store more than one number on compiler stack - Hubbe */
    (yyval.number)=Pike_compiler->compiler_frame->last_block_level;

    if((yyval.number) == -1) /* if 'first block' */
      Pike_compiler->compiler_frame->last_block_level=0; /* all variables */
    else
      Pike_compiler->compiler_frame->last_block_level=(yyvsp[-1].number);
  }
#line 6283 "y.tab.c"
    break;

  case 251: /* @16: %empty  */
#line 1860 "language.yacc"
  {
    (yyval.ptr) = Pike_compiler;
  }
#line 6291 "y.tab.c"
    break;

  case 252: /* block: '{' @14 line_number_info @15 @16 statements end_block  */
#line 1864 "language.yacc"
  {
    /* Recover compilation context on syntax errors. */
    while (Pike_compiler != (yyvsp[-2].ptr)) {
      struct program *p;
      /* fprintf(stderr, "Compiler context out of sync. Attempting to recover...\n"); */
      if(Pike_compiler->compiler_pass == 1)
	p = end_first_pass(0);
      else
	p=end_first_pass(1);

      if (p) free_program(p);
    }

    unuse_modules(Pike_compiler->num_used_modules - (yyvsp[-6].number));
    (yyvsp[-1].n) = pop_local_variables((yyvsp[-5].number), (yyvsp[-1].n));
    Pike_compiler->compiler_frame->last_block_level=(yyvsp[-3].number);
    if ((yyvsp[-1].n)) COPY_LINE_NUMBER_INFO((yyvsp[-1].n), (yyvsp[-4].n));
    free_node ((yyvsp[-4].n));
    (yyval.n)=(yyvsp[-1].n);
  }
#line 6316 "y.tab.c"
    break;

  case 254: /* end_block: TOK_LEX_EOF  */
#line 1889 "language.yacc"
  {
    yyerror("Missing '}'.");
    if ((yyvsp[-1].n)) {
      low_yyreport(REPORT_ERROR, (yyvsp[-1].n)->current_file, (yyvsp[-1].n)->line_number,
		   parser_system_string, 0, "Opening '{' was here.");
    }
    yyerror("Unexpected end of file.");
  }
#line 6329 "y.tab.c"
    break;

  case 256: /* failsafe_block: error  */
#line 1900 "language.yacc"
                      { (yyval.n)=0; }
#line 6335 "y.tab.c"
    break;

  case 257: /* failsafe_block: TOK_LEX_EOF  */
#line 1901 "language.yacc"
                            { yyerror("Unexpected end of file."); (yyval.n)=0; }
#line 6341 "y.tab.c"
    break;

  case 258: /* propagated_type: %empty  */
#line 1906 "language.yacc"
  {
    (yyval.n) = (yyvsp[(-2) - (0)].n);
  }
#line 6349 "y.tab.c"
    break;

  case 260: /* local_name_list: local_name_list ',' propagated_type new_local_name  */
#line 1914 "language.yacc"
    { (yyval.n) = mknode(F_COMMA_EXPR, mkcastnode(void_type_string, (yyvsp[-3].n)), (yyvsp[0].n)); }
#line 6355 "y.tab.c"
    break;

  case 262: /* local_name_list2: local_name_list2 ',' propagated_type new_local_name  */
#line 1920 "language.yacc"
    { (yyval.n) = mknode(F_COMMA_EXPR, mkcastnode(void_type_string, (yyvsp[-3].n)), (yyvsp[0].n)); }
#line 6361 "y.tab.c"
    break;

  case 263: /* local_constant_name: TOK_IDENTIFIER '=' safe_expr0  */
#line 1925 "language.yacc"
  {
    struct pike_type *type;

    /* Ugly hack to make sure that $3 is optimized */
    {
      int tmp=Pike_compiler->compiler_pass;
      (yyvsp[0].n)=mknode(F_COMMA_EXPR,(yyvsp[0].n),0);
      optimize_node((yyvsp[0].n));
      Pike_compiler->compiler_pass=tmp;
      type=(yyvsp[0].n)->u.node.a->type;
    }

    if(!is_const((yyvsp[0].n)))
    {
      if(Pike_compiler->compiler_pass==2)
	yyerror("Constant definition is not constant.");
    }else{
      ptrdiff_t tmp=eval_low((yyvsp[0].n),1);
      if(tmp < 1)
      {
	yyerror("Error in constant definition.");
      }else{
	pop_n_elems(DO_NOT_WARN((INT32)(tmp - 1)));
	if((yyvsp[0].n)) free_node((yyvsp[0].n));
	(yyvsp[0].n)=mksvaluenode(Pike_sp-1);
	type=(yyvsp[0].n)->type;
	pop_stack();
      }
    }
    if(!type) type = mixed_type_string;
    add_ref(type);
    low_add_local_name(Pike_compiler->compiler_frame, /*->previous,*/
		       (yyvsp[-2].n)->u.sval.u.string,
		       type, (yyvsp[0].n));
    /* Note: Intentionally not marked as used. */
    free_node((yyvsp[-2].n));
  }
#line 6403 "y.tab.c"
    break;

  case 264: /* local_constant_name: bad_identifier '=' safe_expr0  */
#line 1962 "language.yacc"
                                  { if ((yyvsp[0].n)) free_node((yyvsp[0].n)); }
#line 6409 "y.tab.c"
    break;

  case 265: /* local_constant_name: error '=' safe_expr0  */
#line 1963 "language.yacc"
                         { if ((yyvsp[0].n)) free_node((yyvsp[0].n)); }
#line 6415 "y.tab.c"
    break;

  case 269: /* local_constant: TOK_CONSTANT error ';'  */
#line 1971 "language.yacc"
                           { yyerrok; }
#line 6421 "y.tab.c"
    break;

  case 270: /* local_constant: TOK_CONSTANT error TOK_LEX_EOF  */
#line 1973 "language.yacc"
  {
    yyerror("Missing ';'.");
    yyerror("Unexpected end of file.");
  }
#line 6430 "y.tab.c"
    break;

  case 271: /* local_constant: TOK_CONSTANT error '}'  */
#line 1977 "language.yacc"
                           { yyerror("Missing ';'."); }
#line 6436 "y.tab.c"
    break;

  case 272: /* statements: %empty  */
#line 1981 "language.yacc"
            { (yyval.n)=0; }
#line 6442 "y.tab.c"
    break;

  case 273: /* statements: statements statement  */
#line 1983 "language.yacc"
  {
    (yyval.n) = mknode(F_COMMA_EXPR, (yyvsp[-1].n), mkcastnode(void_type_string, (yyvsp[0].n)));
  }
#line 6450 "y.tab.c"
    break;

  case 276: /* normal_label_statement: import  */
#line 1991 "language.yacc"
           { (yyval.n)=0; }
#line 6456 "y.tab.c"
    break;

  case 279: /* normal_label_statement: local_constant  */
#line 1994 "language.yacc"
                   { (yyval.n)=0; }
#line 6462 "y.tab.c"
    break;

  case 283: /* normal_label_statement: error ';'  */
#line 1998 "language.yacc"
              { reset_type_stack(); (yyval.n)=0; yyerrok; }
#line 6468 "y.tab.c"
    break;

  case 284: /* normal_label_statement: error TOK_LEX_EOF  */
#line 2000 "language.yacc"
  {
    reset_type_stack();
    yyerror("Missing ';'.");
    yyerror("Unexpected end of file.");
    (yyval.n)=0;
  }
#line 6479 "y.tab.c"
    break;

  case 285: /* normal_label_statement: error '}'  */
#line 2007 "language.yacc"
  {
    reset_type_stack();
    yyerror("Missing ';'.");
/*    yychar = '}'; */	/* Put the '}' back on the input stream. */
    (yyval.n)=0;
  }
#line 6490 "y.tab.c"
    break;

  case 286: /* normal_label_statement: ';'  */
#line 2013 "language.yacc"
        { (yyval.n)=0; }
#line 6496 "y.tab.c"
    break;

  case 287: /* statement: normal_label_statement  */
#line 2017 "language.yacc"
  {
    Pike_compiler->compiler_frame->opt_flags &= ~OPT_CUSTOM_LABELS;
  }
#line 6504 "y.tab.c"
    break;

  case 296: /* $@17: %empty  */
#line 2031 "language.yacc"
  {
    Pike_compiler->compiler_frame->opt_flags &= ~OPT_CUSTOM_LABELS;
  }
#line 6512 "y.tab.c"
    break;

  case 297: /* labeled_statement: TOK_IDENTIFIER $@17 ':' statement  */
#line 2035 "language.yacc"
  {
    (yyval.n) = mknode(Pike_compiler->compiler_frame->opt_flags & OPT_CUSTOM_LABELS ?
		F_CUSTOM_STMT_LABEL : F_NORMAL_STMT_LABEL,
		(yyvsp[-3].n), (yyvsp[0].n));

    /* FIXME: This won't be correct if the node happens to be shared.
     * That's an issue to be solved with shared nodes in general,
     * though. */
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-3].n));
  }
#line 6527 "y.tab.c"
    break;

  case 299: /* optional_label: %empty  */
#line 2048 "language.yacc"
                {(yyval.n) = 0;}
#line 6533 "y.tab.c"
    break;

  case 300: /* break: TOK_BREAK optional_label  */
#line 2051 "language.yacc"
                                { (yyval.n)=mknode(F_BREAK,(yyvsp[0].n),0); }
#line 6539 "y.tab.c"
    break;

  case 301: /* default: TOK_DEFAULT ':'  */
#line 2052 "language.yacc"
                          { (yyval.n)=mknode(F_DEFAULT,0,0); }
#line 6545 "y.tab.c"
    break;

  case 302: /* default: TOK_DEFAULT  */
#line 2054 "language.yacc"
  {
    (yyval.n)=mknode(F_DEFAULT,0,0); yyerror("Expected ':' after default.");
  }
#line 6553 "y.tab.c"
    break;

  case 303: /* continue: TOK_CONTINUE optional_label  */
#line 2059 "language.yacc"
                                      { (yyval.n)=mknode(F_CONTINUE,(yyvsp[0].n),0); }
#line 6559 "y.tab.c"
    break;

  case 304: /* push_compiler_frame1: %empty  */
#line 2062 "language.yacc"
  {
    push_compiler_frame(SCOPE_LOCAL);

    (yyval.ptr) = Pike_compiler->compiler_frame;
  }
#line 6569 "y.tab.c"
    break;

  case 305: /* implicit_identifier: %empty  */
#line 2070 "language.yacc"
  {
    struct pike_string *name;
    (yyval.n)=mkstrnode(name = get_new_name(NULL));
    free_string(name);
  }
#line 6579 "y.tab.c"
    break;

  case 306: /* $@18: %empty  */
#line 2078 "language.yacc"
  {
    debug_malloc_touch(Pike_compiler->compiler_frame->current_return_type);
    if(Pike_compiler->compiler_frame->current_return_type)
      free_type(Pike_compiler->compiler_frame->current_return_type);
    copy_pike_type(Pike_compiler->compiler_frame->current_return_type,
		   any_type_string);
  }
#line 6591 "y.tab.c"
    break;

  case 307: /* @19: %empty  */
#line 2086 "language.yacc"
  {
    struct pike_string *name = (yyvsp[-3].n)->u.sval.u.string;
    struct pike_type *type;
    int e;

    (yyval.number) = Pike_compiler->varargs;
    Pike_compiler->varargs = 0;

    if (Pike_compiler->compiler_pass == 1) {
      /* Define a tentative prototype for the lambda. */
      push_finished_type(mixed_type_string);
      e=(yyvsp[0].number)-1;
      if((yyval.number))
      {
	push_finished_type(Pike_compiler->compiler_frame->variable[e].type);
	e--;
	pop_type_stack(T_ARRAY);
      }else{
	push_type(T_VOID);
      }
      Pike_compiler->varargs=0;
      push_type(T_MANY);
      for(; e>=0; e--) {
	push_finished_type(Pike_compiler->compiler_frame->variable[e].type);
	push_type(T_FUNCTION);
      }
      type=compiler_pop_type();
      Pike_compiler->compiler_frame->current_function_number =
	define_function(name, type,
			ID_PROTECTED | ID_PRIVATE | ID_INLINE | ID_USED,
			IDENTIFIER_PIKE_FUNCTION, NULL,
			(unsigned INT16)
			(Pike_compiler->compiler_frame->opt_flags));
      free_type(type);
    } else {
      /* In pass 2 we just reuse the type from pass 1. */
      Pike_compiler->compiler_frame->current_function_number =
	isidentifier(name);
    }
  }
#line 6636 "y.tab.c"
    break;

  case 308: /* lambda: TOK_LAMBDA line_number_info implicit_identifier push_compiler_frame1 $@18 func_args @19 failsafe_block  */
#line 2127 "language.yacc"
  {
    struct pike_type *type;
    int f,e;
    struct pike_string *name;
    struct compilation *c = THIS_COMPILATION;
    struct pike_string *save_file = c->lex.current_file;
    int save_line = c->lex.current_line;
    c->lex.current_file = (yyvsp[-6].n)->current_file;
    c->lex.current_line = (yyvsp[-6].n)->line_number;

    debug_malloc_touch((yyvsp[0].n));
    (yyvsp[0].n)=mknode(F_COMMA_EXPR,(yyvsp[0].n),mknode(F_RETURN,mkintnode(0),0));
    if (Pike_compiler->compiler_pass == 2) {
      /* Doing this in pass 1 might induce too strict checks on types
       * in cases where we got placeholders. */
      type=find_return_type((yyvsp[0].n));
      if (type) {
	push_finished_type(type);
	free_type(type);
      } else {
	yywarning("Failed to determine return type for lambda.");
	push_type(T_ZERO);
      }
    } else {
      /* Tentative return type. */
      push_type(T_MIXED);
    }

    e=(yyvsp[-2].number)-1;
    if((yyvsp[-1].number))
    {
      push_finished_type(Pike_compiler->compiler_frame->variable[e].type);
      e--;
      pop_type_stack(T_ARRAY);
    }else{
      push_type(T_VOID);
    }
    Pike_compiler->varargs=0;
    push_type(T_MANY);
    for(; e>=0; e--) {
      push_finished_type(Pike_compiler->compiler_frame->variable[e].type);
      push_type(T_FUNCTION);
    }

    type=compiler_pop_type();

    name = (yyvsp[-5].n)->u.sval.u.string;

#ifdef LAMBDA_DEBUG
    fprintf(stderr, "%d: LAMBDA: %s 0x%08lx 0x%08lx\n%d:   type: ",
	    Pike_compiler->compiler_pass, name->str,
	    (long)Pike_compiler->new_program->id,
	    Pike_compiler->local_class_counter-1,
	    Pike_compiler->compiler_pass);
    simple_describe_type(type);
    fprintf(stderr, "\n");
#endif /* LAMBDA_DEBUG */

    f=dooptcode(name,
		(yyvsp[0].n),
		type,
		ID_PROTECTED | ID_PRIVATE | ID_INLINE | ID_USED);

#ifdef PIKE_DEBUG
    if (f != Pike_compiler->compiler_frame->current_function_number) {
      Pike_fatal("Lost track of lambda %s.\n", name->str);
    }
#endif /* PIKE_DEBUG */

#ifdef LAMBDA_DEBUG
    fprintf(stderr, "%d:   lexical_scope: 0x%08x\n",
	    Pike_compiler->compiler_pass,
	    Pike_compiler->compiler_frame->lexical_scope);
#endif /* LAMBDA_DEBUG */

    if(Pike_compiler->compiler_frame->lexical_scope & SCOPE_SCOPED) {
      (yyval.n) = mktrampolinenode(f, Pike_compiler->compiler_frame->previous);
    } else {
      (yyval.n) = mkidentifiernode(f);
    }
    free_type(type);
    c->lex.current_line = save_line;
    c->lex.current_file = save_file;
    free_node((yyvsp[-5].n));
    free_node ((yyvsp[-6].n));
#ifdef PIKE_DEBUG
    if (Pike_compiler->compiler_frame != (yyvsp[-4].ptr)) {
      Pike_fatal("Lost track of compiler_frame!\n"
		 "  Got: %p (Expected: %p) Previous: %p\n",
		 Pike_compiler->compiler_frame, (yyvsp[-4].ptr),
		 Pike_compiler->compiler_frame->previous);
    }
#endif
    pop_compiler_frame();
  }
#line 6736 "y.tab.c"
    break;

  case 309: /* lambda: TOK_LAMBDA line_number_info implicit_identifier push_compiler_frame1 error  */
#line 2223 "language.yacc"
  {
#ifdef PIKE_DEBUG
    if (Pike_compiler->compiler_frame != (yyvsp[-1].ptr)) {
      Pike_fatal("Lost track of compiler_frame!\n"
		 "  Got: %p (Expected: %p) Previous: %p\n",
		 Pike_compiler->compiler_frame, (yyvsp[-1].ptr),
		 Pike_compiler->compiler_frame->previous);
    }
#endif
    pop_compiler_frame();
    (yyval.n) = mkintnode(0);
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-3].n));
    free_node((yyvsp[-2].n));
    free_node((yyvsp[-3].n));
  }
#line 6756 "y.tab.c"
    break;

  case 310: /* @20: %empty  */
#line 2241 "language.yacc"
  {
    struct pike_string *name;
    struct pike_type *type;
    int id,e;
    node *n;
    struct identifier *i=0;

    debug_malloc_touch(Pike_compiler->compiler_frame->current_return_type);
    if(Pike_compiler->compiler_frame->current_return_type)
      free_type(Pike_compiler->compiler_frame->current_return_type);
    copy_pike_type(Pike_compiler->compiler_frame->current_return_type,
		   (yyvsp[-3].n)->u.sval.u.type);


    /***/
    push_finished_type(Pike_compiler->compiler_frame->current_return_type);

    e=(yyvsp[0].number)-1;
    if(Pike_compiler->varargs)
    {
      push_finished_type(Pike_compiler->compiler_frame->variable[e].type);
      e--;
      pop_type_stack(T_ARRAY);
    }else{
      push_type(T_VOID);
    }
    push_type(T_MANY);
    for(; e>=0; e--) {
      push_finished_type(Pike_compiler->compiler_frame->variable[e].type);
    push_type(T_FUNCTION);
    }

    type=compiler_pop_type();
    /***/

    name = get_new_name((yyvsp[-2].n)->u.sval.u.string);

#ifdef LAMBDA_DEBUG
    fprintf(stderr, "%d: LAMBDA: %s 0x%08lx 0x%08lx\n",
	    Pike_compiler->compiler_pass, name->str,
	    (long)Pike_compiler->new_program->id,
	    Pike_compiler->local_class_counter-1);
#endif /* LAMBDA_DEBUG */

    if(Pike_compiler->compiler_pass > 1)
    {
      id=isidentifier(name);
    }else{
      id=define_function(name,
			 type,
			 ID_PROTECTED | ID_PRIVATE | ID_INLINE | ID_USED,
			 IDENTIFIER_PIKE_FUNCTION |
			 (Pike_compiler->varargs?IDENTIFIER_VARARGS:0),
			 0,
			 OPT_SIDE_EFFECT|OPT_EXTERNAL_DEPEND);
    }
    Pike_compiler->varargs=0;
    Pike_compiler->compiler_frame->current_function_number=id;

    n=0;
    if(Pike_compiler->compiler_pass > 1 &&
       (i=ID_FROM_INT(Pike_compiler->new_program, id)))
    {
      if(i->identifier_flags & IDENTIFIER_SCOPED)
	n = mktrampolinenode(id, Pike_compiler->compiler_frame->previous);
      else
	n = mkidentifiernode(id);
    }

    low_add_local_name(Pike_compiler->compiler_frame->previous,
		       (yyvsp[-2].n)->u.sval.u.string, type, n);

    (yyval.number)=id;
    free_string(name);
  }
#line 6836 "y.tab.c"
    break;

  case 311: /* local_function: TOK_IDENTIFIER push_compiler_frame1 func_args @20 failsafe_block  */
#line 2317 "language.yacc"
  {
    int localid;
    struct identifier *i=ID_FROM_INT(Pike_compiler->new_program, (yyvsp[-1].number));
    struct compilation *c = THIS_COMPILATION;
    struct pike_string *save_file = c->lex.current_file;
    int save_line = c->lex.current_line;
    c->lex.current_file = (yyvsp[-4].n)->current_file;
    c->lex.current_line = (yyvsp[-4].n)->line_number;

    (yyvsp[0].n)=mknode(F_COMMA_EXPR,(yyvsp[0].n),mknode(F_RETURN,mkintnode(0),0));

    debug_malloc_touch((yyvsp[0].n));
    dooptcode(i->name,
	      (yyvsp[0].n),
	      i->type,
	      ID_PROTECTED | ID_PRIVATE | ID_INLINE);

    i->opt_flags = Pike_compiler->compiler_frame->opt_flags;

    c->lex.current_line = save_line;
    c->lex.current_file = save_file;
#ifdef PIKE_DEBUG
    if (Pike_compiler->compiler_frame != (yyvsp[-3].ptr)) {
      Pike_fatal("Lost track of compiler_frame!\n"
		 "  Got: %p (Expected: %p) Previous: %p\n",
		 Pike_compiler->compiler_frame, (yyvsp[-3].ptr),
		 Pike_compiler->compiler_frame->previous);
    }
#endif
    pop_compiler_frame();
    free_node((yyvsp[-4].n));

    /* WARNING: If the local function adds more variables we are screwed */
    /* WARNING2: if add_local_name stops adding local variables at the end,
     *           this has to be fixed.
     */

    localid=Pike_compiler->compiler_frame->current_number_of_locals-1;
    if(Pike_compiler->compiler_frame->variable[localid].def)
    {
      (yyval.n)=copy_node(Pike_compiler->compiler_frame->variable[localid].def);
    }else{
      if(Pike_compiler->compiler_frame->lexical_scope &
	 (SCOPE_SCOPE_USED | SCOPE_SCOPED))
      {
	(yyval.n) = mktrampolinenode((yyvsp[-1].number),Pike_compiler->compiler_frame);
      }else{
	(yyval.n) = mkidentifiernode((yyvsp[-1].number));
      }
    }
  }
#line 6892 "y.tab.c"
    break;

  case 312: /* local_function: TOK_IDENTIFIER push_compiler_frame1 error  */
#line 2369 "language.yacc"
  {
#ifdef PIKE_DEBUG
    if (Pike_compiler->compiler_frame != (yyvsp[-1].ptr)) {
      Pike_fatal("Lost track of compiler_frame!\n"
		 "  Got: %p (Expected: %p) Previous: %p\n",
		 Pike_compiler->compiler_frame, (yyvsp[-1].ptr),
		 Pike_compiler->compiler_frame->previous);
    }
#endif
    pop_compiler_frame();
    (yyval.n)=mkintnode(0);
  }
#line 6909 "y.tab.c"
    break;

  case 313: /* @21: %empty  */
#line 2384 "language.yacc"
  {
    struct pike_string *name;
    struct pike_type *type;
    int id,e;
    node *n;
    struct identifier *i=0;

    /***/
    debug_malloc_touch(Pike_compiler->compiler_frame->current_return_type);

    push_finished_type((yyvsp[-4].n)->u.sval.u.type);

    if(Pike_compiler->compiler_frame->current_return_type)
      free_type(Pike_compiler->compiler_frame->current_return_type);
    Pike_compiler->compiler_frame->current_return_type=compiler_pop_type();

    /***/
    push_finished_type(Pike_compiler->compiler_frame->current_return_type);

    e=(yyvsp[0].number)-1;
    if(Pike_compiler->varargs)
    {
      push_finished_type(Pike_compiler->compiler_frame->variable[e].type);
      e--;
      pop_type_stack(T_ARRAY);
    }else{
      push_type(T_VOID);
    }
    push_type(T_MANY);
    for(; e>=0; e--) {
      push_finished_type(Pike_compiler->compiler_frame->variable[e].type);
      push_type(T_FUNCTION);
    }

    type=compiler_pop_type();
    /***/

    name = get_new_name((yyvsp[-2].n)->u.sval.u.string);

#ifdef LAMBDA_DEBUG
    fprintf(stderr, "%d: LAMBDA: %s 0x%08lx 0x%08lx\n",
	    Pike_compiler->compiler_pass, name->str,
	    (long)Pike_compiler->new_program->id,
	    Pike_compiler->local_class_counter-1);
#endif /* LAMBDA_DEBUG */

    if(Pike_compiler->compiler_pass > 1)
    {
      id=isidentifier(name);
    }else{
      id=define_function(name,
			 type,
			 ID_PROTECTED | ID_PRIVATE | ID_INLINE | ID_USED,
			 IDENTIFIER_PIKE_FUNCTION|
			 (Pike_compiler->varargs?IDENTIFIER_VARARGS:0),
			 0,
			 OPT_SIDE_EFFECT|OPT_EXTERNAL_DEPEND);
    }
    Pike_compiler->varargs=0;
    Pike_compiler->compiler_frame->current_function_number=id;

    n=0;
    if(Pike_compiler->compiler_pass > 1 &&
       (i=ID_FROM_INT(Pike_compiler->new_program, id)))
    {
      if(i->identifier_flags & IDENTIFIER_SCOPED)
	n = mktrampolinenode(id, Pike_compiler->compiler_frame->previous);
      else
	n = mkidentifiernode(id);
    }

    low_add_local_name(Pike_compiler->compiler_frame->previous,
		       (yyvsp[-2].n)->u.sval.u.string, type, n);
    (yyval.number)=id;
    free_string(name);
  }
#line 6990 "y.tab.c"
    break;

  case 314: /* local_function2: optional_stars TOK_IDENTIFIER push_compiler_frame1 func_args @21 failsafe_block  */
#line 2461 "language.yacc"
  {
    int localid;
    struct identifier *i=ID_FROM_INT(Pike_compiler->new_program, (yyvsp[-1].number));
    struct compilation *c = THIS_COMPILATION;
    struct pike_string *save_file = c->lex.current_file;
    int save_line = c->lex.current_line;
    c->lex.current_file = (yyvsp[-4].n)->current_file;
    c->lex.current_line = (yyvsp[-4].n)->line_number;

    debug_malloc_touch((yyvsp[0].n));
    (yyvsp[0].n)=mknode(F_COMMA_EXPR,(yyvsp[0].n),mknode(F_RETURN,mkintnode(0),0));


    debug_malloc_touch((yyvsp[0].n));
    dooptcode(i->name,
	      (yyvsp[0].n),
	      i->type,
	      ID_PROTECTED | ID_PRIVATE | ID_INLINE);

    i->opt_flags = Pike_compiler->compiler_frame->opt_flags;

    c->lex.current_line = save_line;
    c->lex.current_file = save_file;
#ifdef PIKE_DEBUG
    if (Pike_compiler->compiler_frame != (yyvsp[-3].ptr)) {
      Pike_fatal("Lost track of compiler_frame!\n"
		 "  Got: %p (Expected: %p) Previous: %p\n",
		 Pike_compiler->compiler_frame, (yyvsp[-3].ptr),
		 Pike_compiler->compiler_frame->previous);
    }
#endif
    pop_compiler_frame();
    free_node((yyvsp[-4].n));

    /* WARNING: If the local function adds more variables we are screwed */
    /* WARNING2: if add_local_name stops adding local variables at the end,
     *           this has to be fixed.
     */

    localid=Pike_compiler->compiler_frame->current_number_of_locals-1;
    if(Pike_compiler->compiler_frame->variable[localid].def)
    {
      (yyval.n)=copy_node(Pike_compiler->compiler_frame->variable[localid].def);
    }else{
      if(Pike_compiler->compiler_frame->lexical_scope &
	 (SCOPE_SCOPE_USED | SCOPE_SCOPED))
      {
        (yyval.n) = mktrampolinenode((yyvsp[-1].number),Pike_compiler->compiler_frame);
      }else{
        (yyval.n) = mkidentifiernode((yyvsp[-1].number));
      }
    }
  }
#line 7048 "y.tab.c"
    break;

  case 315: /* local_function2: optional_stars TOK_IDENTIFIER push_compiler_frame1 error  */
#line 2515 "language.yacc"
  {
#ifdef PIKE_DEBUG
    if (Pike_compiler->compiler_frame != (yyvsp[-1].ptr)) {
      Pike_fatal("Lost track of compiler_frame!\n"
		 "  Got: %p (Expected: %p) Previous: %p\n",
		 Pike_compiler->compiler_frame, (yyvsp[-1].ptr),
		 Pike_compiler->compiler_frame->previous);
    }
#endif
    pop_compiler_frame();
    free_node((yyvsp[-2].n));
    (yyval.n)=mkintnode(0);
  }
#line 7066 "y.tab.c"
    break;

  case 316: /* create_arg: modifiers type_or_error optional_stars optional_dot_dot_dot TOK_IDENTIFIER  */
#line 2531 "language.yacc"
  {
    struct pike_type *type;
    int ref_no;

    if (Pike_compiler->num_create_args < 0) {
      yyerror("Can't define more variables after ...");
    }

    push_finished_type(Pike_compiler->compiler_frame->current_type);
    if ((yyvsp[-1].number)) {
      push_type(T_ARRAY);
    }
    type=compiler_pop_type();

    /* Add the identifier globally.
     * Note: Since these are the first identifiers (and references)
     *       to be added to the program, they will be numbered in
     *       sequence starting at 0 (zero). This means that the
     *       counter num_create_args is sufficient extra information
     *       to be able to keep track of them.
     */
    ref_no = define_variable((yyvsp[0].n)->u.sval.u.string, type,
			     Pike_compiler->current_modifiers);
    free_type(type);

    if (Pike_compiler->num_create_args != ref_no) {
      my_yyerror("Multiple definitions of create variable %S (%d != %d).",
		 (yyvsp[0].n)->u.sval.u.string,
		 Pike_compiler->num_create_args, ref_no);
    }
    if ((yyvsp[-1].number)) {
      /* Encode varargs marker as negative number of args. */
      Pike_compiler->num_create_args = -(ref_no + 1);
    } else {
      Pike_compiler->num_create_args = ref_no + 1;
    }

    /* free_type(type); */
    free_node((yyvsp[0].n));
    (yyval.number)=0;
  }
#line 7112 "y.tab.c"
    break;

  case 317: /* create_arg: modifiers type_or_error optional_stars optional_dot_dot_dot bad_identifier  */
#line 2572 "language.yacc"
                                                                               { (yyval.number)=0; }
#line 7118 "y.tab.c"
    break;

  case 318: /* create_arg: modifiers type_or_error optional_stars optional_dot_dot_dot  */
#line 2573 "language.yacc"
                                                                {
    yyerror("Missing identifier.");
    (yyval.number)=0;
  }
#line 7127 "y.tab.c"
    break;

  case 319: /* create_arguments2: create_arg  */
#line 2579 "language.yacc"
                              { (yyval.number) = 1; }
#line 7133 "y.tab.c"
    break;

  case 320: /* create_arguments2: create_arguments2 ',' create_arg  */
#line 2580 "language.yacc"
                                     { (yyval.number) = (yyvsp[-2].number) + 1; }
#line 7139 "y.tab.c"
    break;

  case 321: /* create_arguments2: create_arguments2 ':' create_arg  */
#line 2582 "language.yacc"
  {
    yyerror("Unexpected ':' in create argument list.");
    (yyval.number) = (yyvsp[-2].number) + 1;
  }
#line 7148 "y.tab.c"
    break;

  case 322: /* create_arguments: optional_comma  */
#line 2588 "language.yacc"
                                             { (yyval.number)=0; }
#line 7154 "y.tab.c"
    break;

  case 324: /* optional_create_arguments: %empty  */
#line 2592 "language.yacc"
                                       { (yyval.number) = 0; }
#line 7160 "y.tab.c"
    break;

  case 325: /* optional_create_arguments: '(' create_arguments close_paren_or_missing  */
#line 2594 "language.yacc"
  {
    /* NOTE: One more than the number of arguments, so that we
     *       can detect the case of no parenthesis below. */
    (yyval.number) = (Pike_compiler->num_create_args < 0) ?
      (1 - Pike_compiler->num_create_args):(1 + Pike_compiler->num_create_args);
    free_node((yyvsp[0].n));
  }
#line 7172 "y.tab.c"
    break;

  case 326: /* @22: %empty  */
#line 2603 "language.yacc"
                              { (yyval.n) = NULL; }
#line 7178 "y.tab.c"
    break;

  case 328: /* failsafe_program: error  */
#line 2604 "language.yacc"
                        { yyerrok; }
#line 7184 "y.tab.c"
    break;

  case 329: /* failsafe_program: TOK_LEX_EOF  */
#line 2606 "language.yacc"
                {
		  yyerror("End of file where program definition expected.");
		}
#line 7192 "y.tab.c"
    break;

  case 330: /* @23: %empty  */
#line 2613 "language.yacc"
  {
    if(!(yyvsp[0].n))
    {
      struct pike_string *s;
      char buffer[42];
      sprintf(buffer,"__class_%ld_%ld_line_%d",
	      (long)Pike_compiler->new_program->id,
	      (long)Pike_compiler->local_class_counter++,
	      (int) (yyvsp[-1].n)->line_number);
      s=make_shared_string(buffer);
      (yyvsp[0].n)=mkstrnode(s);
      free_string(s);
      (yyvsp[-3].number)|=ID_PROTECTED | ID_PRIVATE | ID_INLINE;
    }
    /* fprintf(stderr, "LANGUAGE.YACC: CLASS start\n"); */
    if(Pike_compiler->compiler_pass==1)
    {
      if ((yyvsp[-3].number) & ID_EXTERN) {
	yywarning("Extern declared class definition.");
      }
      low_start_new_program(0, 1, (yyvsp[0].n)->u.sval.u.string,
			    (yyvsp[-3].number),
			    &(yyval.number));

      /* fprintf(stderr, "Pass 1: Program %s has id %d\n",
	 $4->u.sval.u.string->str, Pike_compiler->new_program->id); */

      store_linenumber((yyvsp[-1].n)->line_number, (yyvsp[-1].n)->current_file);
      debug_malloc_name(Pike_compiler->new_program,
			(yyvsp[-1].n)->current_file->str,
			(yyvsp[-1].n)->line_number);
    }else{
      int i;
      struct identifier *id;
      int tmp=Pike_compiler->compiler_pass;
      i=isidentifier((yyvsp[0].n)->u.sval.u.string);
      if(i<0)
      {
	/* Seriously broken... */
	yyerror("Pass 2: program not defined!");
	low_start_new_program(0, 2, 0,
			      (yyvsp[-3].number),
			      &(yyval.number));
      }else{
	id=ID_FROM_INT(Pike_compiler->new_program, i);
	if(IDENTIFIER_IS_CONSTANT(id->identifier_flags))
	{
	  struct svalue *s;
	  if ((id->func.const_info.offset >= 0) &&
	      (TYPEOF(*(s = &PROG_FROM_INT(Pike_compiler->new_program,i)->
			constants[id->func.const_info.offset].sval)) ==
	       T_PROGRAM))
	  {
	    low_start_new_program(s->u.program, 2,
				  (yyvsp[0].n)->u.sval.u.string,
				  (yyvsp[-3].number),
				  &(yyval.number));

	    /* fprintf(stderr, "Pass 2: Program %s has id %d\n",
	       $4->u.sval.u.string->str, Pike_compiler->new_program->id); */

	  }else{
	    yyerror("Pass 2: constant redefined!");
	    low_start_new_program(0, 2, 0,
				  (yyvsp[-3].number),
				  &(yyval.number));
	  }
	}else{
	  yyerror("Pass 2: class constant no longer constant!");
	  low_start_new_program(0, 2, 0,
				(yyvsp[-3].number),
				&(yyval.number));
	}
      }
      Pike_compiler->compiler_pass=tmp;
    }
  }
#line 7274 "y.tab.c"
    break;

  case 331: /* @24: %empty  */
#line 2690 "language.yacc"
  {
    /* Clear scoped modifiers. */
    (yyval.number) = THIS_COMPILATION->lex.pragmas;
    THIS_COMPILATION->lex.pragmas &= ~ID_MODIFIER_MASK;
  }
#line 7284 "y.tab.c"
    break;

  case 332: /* class: TOK_CLASS line_number_info optional_identifier @23 @24 optional_create_arguments failsafe_program  */
#line 2696 "language.yacc"
  {
    struct program *p;

    /* Check if we have create arguments but no locally defined create(). */
    if ((yyvsp[-1].number)) {
      struct pike_string *create_string = NULL;
      struct reference *ref = NULL;
      struct identifier *id = NULL;
      int ref_id;
      MAKE_CONST_STRING(create_string, "create");
      if (((ref_id = isidentifier(create_string)) < 0) ||
	  (ref = PTR_FROM_INT(Pike_compiler->new_program, ref_id))->inherit_offset ||
	  ((id = ID_FROM_PTR(Pike_compiler->new_program, ref))->func.offset == -1)) {
	int e;
	struct pike_type *type = NULL;
	int nargs = Pike_compiler->num_create_args;

	push_compiler_frame(SCOPE_LOCAL);

	/* Init: Prepend the create arguments. */
	if (Pike_compiler->num_create_args < 0) {
	  for (e = 0; e < -Pike_compiler->num_create_args; e++) {
	    id = Pike_compiler->new_program->identifiers + e;
	    add_ref(id->type);
	    add_local_name(id->name, id->type, 0);
	    /* Note: add_local_name() above will return e. */
	    Pike_compiler->compiler_frame->variable[e].flags |=
	      LOCAL_VAR_IS_USED;
	  }
	} else {
	  for (e = 0; e < Pike_compiler->num_create_args; e++) {
	    id = Pike_compiler->new_program->identifiers + e;
	    add_ref(id->type);
	    add_local_name(id->name, id->type, 0);
	    /* Note: add_local_name() above will return e. */
	    Pike_compiler->compiler_frame->variable[e].flags |=
	      LOCAL_VAR_IS_USED;
	  }
	}

	/* First: Deduce the type for the create() function. */
	push_type(T_VOID); /* Return type. */

	if ((e = nargs) < 0) {
	  /* Varargs */
	  e = nargs = -nargs;
	  push_finished_type(Pike_compiler->compiler_frame->variable[--e].type);
	  pop_type_stack(T_ARRAY); /* Pop one level of array. */
	} else {
	  /* Not varargs. */
	  push_type(T_VOID);
	}
	push_type(T_MANY);
	while(e--) {
	  push_finished_type(Pike_compiler->compiler_frame->variable[e].type);
	  push_type(T_FUNCTION);
	}

	type = compiler_pop_type();

	/* Second: Declare the function. */

	Pike_compiler->compiler_frame->current_function_number=
	  define_function(create_string, type,
			  ID_INLINE | ID_PROTECTED,
			  IDENTIFIER_PIKE_FUNCTION |
			  (Pike_compiler->num_create_args < 0?IDENTIFIER_VARARGS:0),
			  0,
			  OPT_SIDE_EFFECT);

	if (Pike_compiler->compiler_pass == 2) {
	  node *create_code = NULL;
	  int f;

	  /* Third: Generate the initialization code.
	   *
	   * global_arg = [type]local_arg;
	   * [,..]
	   */

	  for(e=0; e<nargs; e++)
	  {
	    if(!Pike_compiler->compiler_frame->variable[e].name ||
	       !Pike_compiler->compiler_frame->variable[e].name->len)
	    {
	      my_yyerror("Missing name for argument %d.",e);
	    } else {
	      node *local_node = mklocalnode(e, 0);

	      /* FIXME: Should probably use some other flag. */
	      if ((runtime_options & RUNTIME_CHECK_TYPES) &&
		  (Pike_compiler->compiler_pass == 2) &&
		  (Pike_compiler->compiler_frame->variable[e].type !=
		   mixed_type_string)) {
		/* fprintf(stderr, "Creating soft cast node for local #%d\n", e);*/

		local_node = mkcastnode(mixed_type_string, local_node);

		/* NOTE: The cast to mixed above is needed to avoid generating
		 *       compilation errors, as well as avoiding optimizations
		 *       in mksoftcastnode().
		 */
		local_node = mksoftcastnode(Pike_compiler->compiler_frame->
					    variable[e].type, local_node);
	      }
	      create_code =
		mknode(F_COMMA_EXPR, create_code,
		       mknode(F_ASSIGN, local_node,
			      mkidentifiernode(e)));
	    }
	  }

	  /* Fourth: Add a return 0; at the end. */

	  create_code = mknode(F_COMMA_EXPR,
			       mknode(F_POP_VALUE, create_code, NULL),
			       mknode(F_RETURN, mkintnode(0), NULL));

	  /* Fifth: Define the function. */

	  f=dooptcode(create_string, create_code, type, ID_PROTECTED);

#ifdef PIKE_DEBUG
	  if(Pike_interpreter.recoveries &&
	     Pike_sp-Pike_interpreter.evaluator_stack < Pike_interpreter.recoveries->stack_pointer)
	    Pike_fatal("Stack error (underflow)\n");

	  if(Pike_compiler->compiler_pass == 1 &&
	     f!=Pike_compiler->compiler_frame->current_function_number)
	    Pike_fatal("define_function screwed up! %d != %d\n",
		       f, Pike_compiler->compiler_frame->current_function_number);
#endif
	}

	/* Done. */

	free_type(type);
	pop_compiler_frame();
      }
    }

    if(Pike_compiler->compiler_pass == 1)
      p=end_first_pass(0);
    else
      p=end_first_pass(1);

    /* fprintf(stderr, "LANGUAGE.YACC: CLASS end\n"); */

    if(p) {
      /* Update the type for the program constant,
       * since we might have a lfun::create(). */
      struct identifier *i;
      struct svalue sv;
      SET_SVAL(sv, T_PROGRAM, 0, program, p);
      i = ID_FROM_INT(Pike_compiler->new_program, (yyvsp[-3].number));
      free_type(i->type);
      i->type = get_type_of_svalue(&sv);
      free_program(p);
    } else if (!Pike_compiler->num_parse_error) {
      /* Make sure code in this class is aware that something went wrong. */
      Pike_compiler->num_parse_error = 1;
    }

    (yyval.n)=mkidentifiernode((yyvsp[-3].number));

    free_node((yyvsp[-5].n));
    free_node((yyvsp[-4].n));
    check_tree((yyval.n),0);
    THIS_COMPILATION->lex.pragmas = (yyvsp[-2].number);
  }
#line 7459 "y.tab.c"
    break;

  case 334: /* simple_identifier: bad_identifier  */
#line 2869 "language.yacc"
                   { (yyval.n) = 0; }
#line 7465 "y.tab.c"
    break;

  case 335: /* enum_value: %empty  */
#line 2872 "language.yacc"
                        { (yyval.n) = 0; }
#line 7471 "y.tab.c"
    break;

  case 336: /* enum_value: '=' safe_expr0  */
#line 2873 "language.yacc"
                   { (yyval.n) = (yyvsp[0].n); }
#line 7477 "y.tab.c"
    break;

  case 338: /* enum_def: simple_identifier enum_value  */
#line 2879 "language.yacc"
  {
    if ((yyvsp[-1].n)) {
      if ((yyvsp[0].n)) {
	/* Explicit enum value. */

	/* This can be made more lenient in the future */

	/* Ugly hack to make sure that $2 is optimized */
	{
	  int tmp=Pike_compiler->compiler_pass;
	  (yyvsp[0].n)=mknode(F_COMMA_EXPR,(yyvsp[0].n),0);
	  Pike_compiler->compiler_pass=tmp;
	}

	if(!is_const((yyvsp[0].n)))
	{
	  if(Pike_compiler->compiler_pass==2)
	    yyerror("Enum definition is not constant.");
	  push_int(0);
	} else {
	  if(!Pike_compiler->num_parse_error)
	  {
	    ptrdiff_t tmp=eval_low((yyvsp[0].n),1);
	    if(tmp < 1)
	    {
	      yyerror("Error in enum definition.");
	      push_int(0);
	    }else{
	      pop_n_elems(DO_NOT_WARN((INT32)(tmp - 1)));
	    }
	  } else {
	    push_int(0);
	  }
	}
	free_node((yyvsp[0].n));
	free_node((yyvsp[-2].n));
	(yyvsp[-2].n) = mkconstantsvaluenode(Pike_sp-1);
      } else {
	/* Implicit enum value. */
	(yyvsp[-2].n) = safe_inc_enum((yyvsp[-2].n));
	push_svalue(&(yyvsp[-2].n)->u.sval);
      }
      add_constant((yyvsp[-1].n)->u.sval.u.string, Pike_sp-1,
		   (Pike_compiler->current_modifiers & ~ID_EXTERN) | ID_INLINE);
      /* Update the type. */
      {
	struct pike_type *current = pop_unfinished_type();
	struct pike_type *new = get_type_of_svalue(Pike_sp-1);
	struct pike_type *res = or_pike_types(new, current, 3);
	free_type(current);
	free_type(new);
	type_stack_mark();
	push_finished_type(res);
	free_type(res);
      }
      pop_stack();
      free_node((yyvsp[-1].n));
    } else if ((yyvsp[0].n)) {
      free_node((yyvsp[0].n));
    }
  }
#line 7543 "y.tab.c"
    break;

  case 339: /* propagated_enum_value: %empty  */
#line 2944 "language.yacc"
  {
    (yyval.n) = (yyvsp[(-2) - (0)].n);
  }
#line 7551 "y.tab.c"
    break;

  case 341: /* enum_list: enum_list ',' propagated_enum_value enum_def  */
#line 2951 "language.yacc"
                                                 { (yyvsp[-4].n) = (yyvsp[-1].n); }
#line 7557 "y.tab.c"
    break;

  case 343: /* $@25: %empty  */
#line 2957 "language.yacc"
  {
    if ((Pike_compiler->current_modifiers & ID_EXTERN) &&
	(Pike_compiler->compiler_pass == 1)) {
      yywarning("Extern declared enum.");
    }

    type_stack_mark();
    push_type(T_ZERO);	/* Joined type so far. */
  }
#line 7571 "y.tab.c"
    break;

  case 344: /* @26: %empty  */
#line 2967 "language.yacc"
  {
    push_int(-1);	/* Previous value. */
    (yyval.n) = mkconstantsvaluenode(Pike_sp-1);
    pop_stack();
  }
#line 7581 "y.tab.c"
    break;

  case 345: /* @27: %empty  */
#line 2972 "language.yacc"
            { (yyval.n) = NULL; }
#line 7587 "y.tab.c"
    break;

  case 346: /* enum: TOK_ENUM $@25 optional_identifier '{' @26 enum_list @27 end_block  */
#line 2973 "language.yacc"
  {
    struct pike_type *t = pop_unfinished_type();
    free_node((yyvsp[-3].n));
    if ((yyvsp[-5].n)) {
      ref_push_type_value(t);
      add_constant((yyvsp[-5].n)->u.sval.u.string, Pike_sp-1,
		   (Pike_compiler->current_modifiers & ~ID_EXTERN) | ID_INLINE);
      pop_stack();
      free_node((yyvsp[-5].n));
    }
    (yyval.n) = mktypenode(t);
    free_type(t);
  }
#line 7605 "y.tab.c"
    break;

  case 347: /* typedef: modifiers TOK_TYPEDEF full_type simple_identifier ';'  */
#line 2989 "language.yacc"
  {
    struct pike_type *t = compiler_pop_type();

    if ((Pike_compiler->current_modifiers & ID_EXTERN) &&
	(Pike_compiler->compiler_pass == 1)) {
      yywarning("Extern declared typedef.");
    }

    if ((yyvsp[-1].n)) {
      ref_push_type_value(t);
      add_constant((yyvsp[-1].n)->u.sval.u.string, Pike_sp-1,
		   (Pike_compiler->current_modifiers & ~ID_EXTERN) | ID_INLINE);
      pop_stack();
      free_node((yyvsp[-1].n));
    }
    free_type(t);
  }
#line 7627 "y.tab.c"
    break;

  case 348: /* @28: %empty  */
#line 3009 "language.yacc"
  {
    (yyval.number)=Pike_compiler->compiler_frame->current_number_of_locals;
  }
#line 7635 "y.tab.c"
    break;

  case 349: /* @29: %empty  */
#line 3013 "language.yacc"
  {
    /* Trick to store more than one number on compiler stack - Hubbe */
    (yyval.number)=Pike_compiler->compiler_frame->last_block_level;
    Pike_compiler->compiler_frame->last_block_level=(yyvsp[-1].number);
  }
#line 7645 "y.tab.c"
    break;

  case 350: /* cond: TOK_IF @28 line_number_info @29 '(' safe_comma_expr end_cond statement optional_else_part  */
#line 3019 "language.yacc"
  {
    (yyval.n) = mknode('?', (yyvsp[-3].n),
		mknode(':',
		       mkcastnode(void_type_string, (yyvsp[-1].n)),
		       mkcastnode(void_type_string, (yyvsp[0].n))));
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-6].n));
    (yyval.n) = mkcastnode(void_type_string, (yyval.n));
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-6].n));
    free_node ((yyvsp[-6].n));
    (yyval.n) = pop_local_variables((yyvsp[-7].number), (yyval.n));
    Pike_compiler->compiler_frame->last_block_level=(yyvsp[-5].number);
  }
#line 7662 "y.tab.c"
    break;

  case 352: /* end_cond: '}'  */
#line 3034 "language.yacc"
        { yyerror("Missing ')'."); }
#line 7668 "y.tab.c"
    break;

  case 353: /* end_cond: TOK_LEX_EOF  */
#line 3036 "language.yacc"
  {
    yyerror("Missing ')'.");
    yyerror("Unexpected end of file.");
  }
#line 7677 "y.tab.c"
    break;

  case 354: /* optional_else_part: %empty  */
#line 3042 "language.yacc"
                    { (yyval.n)=0; }
#line 7683 "y.tab.c"
    break;

  case 355: /* optional_else_part: TOK_ELSE statement  */
#line 3043 "language.yacc"
                       { (yyval.n)=(yyvsp[0].n); }
#line 7689 "y.tab.c"
    break;

  case 356: /* safe_lvalue: lvalue  */
#line 3047 "language.yacc"
  {
    if (!(THIS_COMPILATION->lex.pragmas & ID_STRICT_TYPES) && (yyvsp[0].n)) {
      if ((yyvsp[0].n)->token == F_ARRAY_LVALUE) {
	mark_lvalues_as_used(CAR((yyvsp[0].n)));
      } else if (((yyvsp[0].n)->token == F_LOCAL) && !((yyvsp[0].n)->u.integer.b)) {
	Pike_compiler->compiler_frame->variable[(yyvsp[0].n)->u.integer.a].flags |=
	  LOCAL_VAR_IS_USED;
      }
    }
  }
#line 7704 "y.tab.c"
    break;

  case 357: /* safe_lvalue: error  */
#line 3057 "language.yacc"
          { (yyval.n)=0; }
#line 7710 "y.tab.c"
    break;

  case 359: /* safe_expr0: TOK_LEX_EOF  */
#line 3061 "language.yacc"
                { yyerror("Unexpected end of file."); (yyval.n)=0; }
#line 7716 "y.tab.c"
    break;

  case 360: /* safe_expr0: error  */
#line 3062 "language.yacc"
          { (yyval.n)=0; }
#line 7722 "y.tab.c"
    break;

  case 361: /* foreach_optional_lvalue: %empty  */
#line 3066 "language.yacc"
                                     { (yyval.n)=0; }
#line 7728 "y.tab.c"
    break;

  case 363: /* foreach_lvalues: ',' safe_lvalue  */
#line 3070 "language.yacc"
                                  { (yyval.n)=(yyvsp[0].n); }
#line 7734 "y.tab.c"
    break;

  case 364: /* foreach_lvalues: ';' foreach_optional_lvalue ';' foreach_optional_lvalue  */
#line 3072 "language.yacc"
  { (yyval.n)=mknode(':',(yyvsp[-2].n),(yyvsp[0].n)); }
#line 7740 "y.tab.c"
    break;

  case 365: /* @30: %empty  */
#line 3076 "language.yacc"
  {
    (yyval.number)=Pike_compiler->compiler_frame->current_number_of_locals;
  }
#line 7748 "y.tab.c"
    break;

  case 366: /* @31: %empty  */
#line 3080 "language.yacc"
  {
    /* Trick to store more than one number on compiler stack - Hubbe */
    (yyval.number)=Pike_compiler->compiler_frame->last_block_level;
    Pike_compiler->compiler_frame->last_block_level=(yyvsp[-1].number);
  }
#line 7758 "y.tab.c"
    break;

  case 367: /* foreach: TOK_FOREACH @30 line_number_info @31 '(' expr0 foreach_lvalues end_cond statement  */
#line 3086 "language.yacc"
  {
    if ((yyvsp[-2].n)) {
      (yyval.n)=mknode(F_FOREACH,
		mknode(F_VAL_LVAL,(yyvsp[-3].n),(yyvsp[-2].n)),
		(yyvsp[0].n));
    } else {
      /* Error in lvalue */
      (yyval.n)=mknode(F_COMMA_EXPR, mkcastnode(void_type_string, (yyvsp[-3].n)), (yyvsp[0].n));
    }
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-6].n));
    free_node ((yyvsp[-6].n));
    (yyval.n) = pop_local_variables((yyvsp[-7].number), (yyval.n));
    Pike_compiler->compiler_frame->last_block_level=(yyvsp[-5].number);
    Pike_compiler->compiler_frame->opt_flags |= OPT_CUSTOM_LABELS;
  }
#line 7778 "y.tab.c"
    break;

  case 368: /* do: TOK_DO line_number_info statement TOK_WHILE '(' safe_comma_expr end_cond expected_semicolon  */
#line 3105 "language.yacc"
  {
    (yyval.n)=mknode(F_DO,(yyvsp[-5].n),(yyvsp[-2].n));
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-6].n));
    free_node ((yyvsp[-6].n));
    Pike_compiler->compiler_frame->opt_flags |= OPT_CUSTOM_LABELS;
  }
#line 7789 "y.tab.c"
    break;

  case 369: /* do: TOK_DO line_number_info statement TOK_WHILE TOK_LEX_EOF  */
#line 3112 "language.yacc"
  {
    free_node ((yyvsp[-3].n));
    (yyval.n)=0;
    yyerror("Missing '(' in do-while loop.");
    yyerror("Unexpected end of file.");
  }
#line 7800 "y.tab.c"
    break;

  case 370: /* do: TOK_DO line_number_info statement TOK_LEX_EOF  */
#line 3119 "language.yacc"
  {
    free_node ((yyvsp[-2].n));
    (yyval.n)=0;
    yyerror("Missing 'while' in do-while loop.");
    yyerror("Unexpected end of file.");
  }
#line 7811 "y.tab.c"
    break;

  case 372: /* expected_semicolon: TOK_LEX_EOF  */
#line 3129 "language.yacc"
  {
    yyerror("Missing ';'.");
    yyerror("Unexpected end of file.");
  }
#line 7820 "y.tab.c"
    break;

  case 373: /* @32: %empty  */
#line 3136 "language.yacc"
  {
    (yyval.number)=Pike_compiler->compiler_frame->current_number_of_locals;
  }
#line 7828 "y.tab.c"
    break;

  case 374: /* @33: %empty  */
#line 3140 "language.yacc"
  {
    /* Trick to store more than one number on compiler stack - Hubbe */
    (yyval.number)=Pike_compiler->compiler_frame->last_block_level;
    Pike_compiler->compiler_frame->last_block_level=(yyvsp[-1].number);
  }
#line 7838 "y.tab.c"
    break;

  case 375: /* for: TOK_FOR @32 line_number_info @33 '(' unused expected_semicolon for_expr expected_semicolon unused end_cond statement  */
#line 3147 "language.yacc"
  {
    (yyval.n)=mknode(F_COMMA_EXPR, mkcastnode(void_type_string, (yyvsp[-6].n)),
	      mknode(F_FOR,(yyvsp[-4].n),mknode(':',(yyvsp[0].n),(yyvsp[-2].n))));
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-9].n));
    free_node ((yyvsp[-9].n));
    (yyval.n) = pop_local_variables((yyvsp[-10].number), (yyval.n));
    Pike_compiler->compiler_frame->last_block_level=(yyvsp[-8].number);
    Pike_compiler->compiler_frame->opt_flags |= OPT_CUSTOM_LABELS;
  }
#line 7852 "y.tab.c"
    break;

  case 376: /* @34: %empty  */
#line 3160 "language.yacc"
  {
    (yyval.number)=Pike_compiler->compiler_frame->current_number_of_locals;
  }
#line 7860 "y.tab.c"
    break;

  case 377: /* @35: %empty  */
#line 3164 "language.yacc"
  {
    /* Trick to store more than one number on compiler stack - Hubbe */
    (yyval.number)=Pike_compiler->compiler_frame->last_block_level;
    Pike_compiler->compiler_frame->last_block_level=(yyvsp[-1].number);
  }
#line 7870 "y.tab.c"
    break;

  case 378: /* while: TOK_WHILE @34 line_number_info @35 '(' safe_comma_expr end_cond statement  */
#line 3170 "language.yacc"
  {
    (yyval.n)=mknode(F_FOR,(yyvsp[-2].n),mknode(':',(yyvsp[0].n),NULL));
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-5].n));
    free_node ((yyvsp[-5].n));
    (yyval.n) = pop_local_variables((yyvsp[-6].number), (yyval.n));
    Pike_compiler->compiler_frame->last_block_level=(yyvsp[-4].number);
    Pike_compiler->compiler_frame->opt_flags |= OPT_CUSTOM_LABELS;
  }
#line 7883 "y.tab.c"
    break;

  case 379: /* for_expr: %empty  */
#line 3180 "language.yacc"
                      { (yyval.n)=mkintnode(1); }
#line 7889 "y.tab.c"
    break;

  case 381: /* @36: %empty  */
#line 3185 "language.yacc"
  {
    (yyval.number)=Pike_compiler->compiler_frame->current_number_of_locals;
  }
#line 7897 "y.tab.c"
    break;

  case 382: /* @37: %empty  */
#line 3189 "language.yacc"
  {
    /* Trick to store more than one number on compiler stack - Hubbe */
    (yyval.number)=Pike_compiler->compiler_frame->last_block_level;
    Pike_compiler->compiler_frame->last_block_level=(yyvsp[-1].number);
  }
#line 7907 "y.tab.c"
    break;

  case 383: /* switch: TOK_SWITCH @36 line_number_info @37 '(' safe_comma_expr end_cond statement  */
#line 3195 "language.yacc"
  {
    (yyval.n)=mknode(F_SWITCH,(yyvsp[-2].n),(yyvsp[0].n));
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-5].n));
    free_node ((yyvsp[-5].n));
    (yyval.n) = pop_local_variables((yyvsp[-6].number), (yyval.n));
    Pike_compiler->compiler_frame->last_block_level=(yyvsp[-4].number);
  }
#line 7919 "y.tab.c"
    break;

  case 384: /* case: TOK_CASE safe_comma_expr expected_colon  */
#line 3205 "language.yacc"
  {
    (yyval.n)=mknode(F_CASE,(yyvsp[-1].n),0);
  }
#line 7927 "y.tab.c"
    break;

  case 385: /* case: TOK_CASE safe_comma_expr expected_dot_dot optional_comma_expr expected_colon  */
#line 3209 "language.yacc"
  {
     (yyval.n)=mknode(F_CASE_RANGE,(yyvsp[-3].n),(yyvsp[-1].n));
  }
#line 7935 "y.tab.c"
    break;

  case 386: /* case: TOK_CASE expected_dot_dot safe_comma_expr expected_colon  */
#line 3213 "language.yacc"
  {
     (yyval.n)=mknode(F_CASE_RANGE,0,(yyvsp[-1].n));
  }
#line 7943 "y.tab.c"
    break;

  case 388: /* expected_colon: ';'  */
#line 3220 "language.yacc"
  {
    yyerror("Missing ':'.");
  }
#line 7951 "y.tab.c"
    break;

  case 389: /* expected_colon: '}'  */
#line 3224 "language.yacc"
  {
    yyerror("Missing ':'.");
  }
#line 7959 "y.tab.c"
    break;

  case 390: /* expected_colon: TOK_LEX_EOF  */
#line 3228 "language.yacc"
  {
    yyerror("Missing ':'.");
    yyerror("Unexpected end of file.");
  }
#line 7968 "y.tab.c"
    break;

  case 391: /* return: TOK_RETURN expected_semicolon  */
#line 3235 "language.yacc"
  {
    if(!match_types(Pike_compiler->compiler_frame->current_return_type,
		    void_type_string))
    {
      yytype_error("Must return a value for a non-void function.",
		   Pike_compiler->compiler_frame->current_return_type,
		   void_type_string, 0);
    }
    (yyval.n)=mknode(F_RETURN,mkintnode(0),0);
  }
#line 7983 "y.tab.c"
    break;

  case 392: /* return: TOK_RETURN safe_comma_expr expected_semicolon  */
#line 3246 "language.yacc"
  {
    (yyval.n)=mknode(F_RETURN,(yyvsp[-1].n),0);
  }
#line 7991 "y.tab.c"
    break;

  case 393: /* unused: %empty  */
#line 3251 "language.yacc"
        { (yyval.n)=0; }
#line 7997 "y.tab.c"
    break;

  case 394: /* unused: safe_comma_expr  */
#line 3252 "language.yacc"
                    { (yyval.n)=mkcastnode(void_type_string, (yyvsp[0].n));  }
#line 8003 "y.tab.c"
    break;

  case 395: /* unused2: comma_expr  */
#line 3255 "language.yacc"
                    { (yyval.n)=mkcastnode(void_type_string, (yyvsp[0].n));  }
#line 8009 "y.tab.c"
    break;

  case 396: /* optional_comma_expr: %empty  */
#line 3257 "language.yacc"
                     { (yyval.n)=0; }
#line 8015 "y.tab.c"
    break;

  case 399: /* safe_comma_expr: error  */
#line 3262 "language.yacc"
          { (yyval.n)=0; }
#line 8021 "y.tab.c"
    break;

  case 401: /* comma_expr: simple_type2 local_name_list  */
#line 3266 "language.yacc"
                                 { (yyval.n)=(yyvsp[0].n); free_node((yyvsp[-1].n)); }
#line 8027 "y.tab.c"
    break;

  case 402: /* comma_expr: simple_identifier_type local_name_list2  */
#line 3267 "language.yacc"
                                            { (yyval.n)=(yyvsp[0].n); free_node((yyvsp[-1].n)); }
#line 8033 "y.tab.c"
    break;

  case 403: /* comma_expr: simple_identifier_type local_function  */
#line 3268 "language.yacc"
                                          { (yyval.n)=(yyvsp[0].n); free_node((yyvsp[-1].n)); }
#line 8039 "y.tab.c"
    break;

  case 404: /* comma_expr: simple_type2 local_function2  */
#line 3269 "language.yacc"
                                 { (yyval.n)=(yyvsp[0].n); free_node((yyvsp[-1].n)); }
#line 8045 "y.tab.c"
    break;

  case 406: /* comma_expr2: comma_expr2 ',' expr0  */
#line 3275 "language.yacc"
  {
    (yyval.n) = mknode(F_COMMA_EXPR, mkcastnode(void_type_string, (yyvsp[-2].n)), (yyvsp[0].n));
  }
#line 8053 "y.tab.c"
    break;

  case 408: /* expr00: '@' expr0  */
#line 3281 "language.yacc"
                  { (yyval.n)=mknode(F_PUSH_ARRAY,(yyvsp[0].n),0); }
#line 8059 "y.tab.c"
    break;

  case 410: /* expr0: expr4 '=' expr0  */
#line 3284 "language.yacc"
                     { (yyval.n)=mknode(F_ASSIGN,(yyvsp[0].n),(yyvsp[-2].n)); }
#line 8065 "y.tab.c"
    break;

  case 411: /* expr0: expr4 '=' error  */
#line 3285 "language.yacc"
                    { (yyval.n)=(yyvsp[-2].n); reset_type_stack(); yyerrok; }
#line 8071 "y.tab.c"
    break;

  case 412: /* expr0: bad_expr_ident '=' expr0  */
#line 3286 "language.yacc"
                             { (yyval.n)=(yyvsp[0].n); }
#line 8077 "y.tab.c"
    break;

  case 413: /* expr0: open_bracket_with_line_info low_lvalue_list ']' '=' expr0  */
#line 3288 "language.yacc"
  {
    if (!(THIS_COMPILATION->lex.pragmas & ID_STRICT_TYPES)) {
      mark_lvalues_as_used((yyvsp[-3].n));
    }
    (yyval.n)=mknode(F_ASSIGN,(yyvsp[0].n),mknode(F_ARRAY_LVALUE,(yyvsp[-3].n),0));
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-4].n));
    free_node ((yyvsp[-4].n));
  }
#line 8090 "y.tab.c"
    break;

  case 414: /* expr0: expr4 assign expr0  */
#line 3296 "language.yacc"
                        { (yyval.n)=mknode((yyvsp[-1].number),(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8096 "y.tab.c"
    break;

  case 415: /* expr0: expr4 assign error  */
#line 3297 "language.yacc"
                       { (yyval.n)=(yyvsp[-2].n); reset_type_stack(); yyerrok; }
#line 8102 "y.tab.c"
    break;

  case 416: /* expr0: bad_expr_ident assign expr0  */
#line 3298 "language.yacc"
                                { (yyval.n)=(yyvsp[0].n); }
#line 8108 "y.tab.c"
    break;

  case 417: /* expr0: open_bracket_with_line_info low_lvalue_list ']' assign expr0  */
#line 3300 "language.yacc"
  {
    (yyval.n)=mknode((yyvsp[-1].number),mknode(F_ARRAY_LVALUE,(yyvsp[-3].n),0),(yyvsp[0].n));
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-4].n));
    free_node ((yyvsp[-4].n));
  }
#line 8118 "y.tab.c"
    break;

  case 418: /* expr0: open_bracket_with_line_info low_lvalue_list ']' error  */
#line 3306 "language.yacc"
    {
      (yyval.n)=(yyvsp[-2].n); free_node ((yyvsp[-3].n)); reset_type_stack(); yyerrok;
    }
#line 8126 "y.tab.c"
    break;

  case 420: /* expr01: expr1 '?' expr01 ':' expr01  */
#line 3313 "language.yacc"
                                { (yyval.n)=mknode('?',(yyvsp[-4].n),mknode(':',(yyvsp[-2].n),(yyvsp[0].n))); }
#line 8132 "y.tab.c"
    break;

  case 421: /* assign: TOK_AND_EQ  */
#line 3316 "language.yacc"
                   { (yyval.number)=F_AND_EQ; }
#line 8138 "y.tab.c"
    break;

  case 422: /* assign: TOK_OR_EQ  */
#line 3317 "language.yacc"
               { (yyval.number)=F_OR_EQ; }
#line 8144 "y.tab.c"
    break;

  case 423: /* assign: TOK_XOR_EQ  */
#line 3318 "language.yacc"
               { (yyval.number)=F_XOR_EQ; }
#line 8150 "y.tab.c"
    break;

  case 424: /* assign: TOK_LSH_EQ  */
#line 3319 "language.yacc"
               { (yyval.number)=F_LSH_EQ; }
#line 8156 "y.tab.c"
    break;

  case 425: /* assign: TOK_RSH_EQ  */
#line 3320 "language.yacc"
               { (yyval.number)=F_RSH_EQ; }
#line 8162 "y.tab.c"
    break;

  case 426: /* assign: TOK_ADD_EQ  */
#line 3321 "language.yacc"
               { (yyval.number)=F_ADD_EQ; }
#line 8168 "y.tab.c"
    break;

  case 427: /* assign: TOK_SUB_EQ  */
#line 3322 "language.yacc"
               { (yyval.number)=F_SUB_EQ; }
#line 8174 "y.tab.c"
    break;

  case 428: /* assign: TOK_MULT_EQ  */
#line 3323 "language.yacc"
               { (yyval.number)=F_MULT_EQ; }
#line 8180 "y.tab.c"
    break;

  case 429: /* assign: TOK_MOD_EQ  */
#line 3324 "language.yacc"
               { (yyval.number)=F_MOD_EQ; }
#line 8186 "y.tab.c"
    break;

  case 430: /* assign: TOK_DIV_EQ  */
#line 3325 "language.yacc"
               { (yyval.number)=F_DIV_EQ; }
#line 8192 "y.tab.c"
    break;

  case 431: /* optional_comma: %empty  */
#line 3328 "language.yacc"
                { (yyval.number)=0; }
#line 8198 "y.tab.c"
    break;

  case 432: /* optional_comma: ','  */
#line 3328 "language.yacc"
                                { (yyval.number)=1; }
#line 8204 "y.tab.c"
    break;

  case 433: /* expr_list: %empty  */
#line 3330 "language.yacc"
           { (yyval.n)=0; }
#line 8210 "y.tab.c"
    break;

  case 436: /* expr_list2: expr_list2 ',' expr00  */
#line 3336 "language.yacc"
                          { (yyval.n)=mknode(F_ARG_LIST,(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8216 "y.tab.c"
    break;

  case 437: /* m_expr_list: %empty  */
#line 3339 "language.yacc"
             { (yyval.n)=0; }
#line 8222 "y.tab.c"
    break;

  case 440: /* m_expr_list2: m_expr_list2 ',' assoc_pair  */
#line 3345 "language.yacc"
  {
    if ((yyvsp[0].n)) {
      (yyval.n)=mknode(F_ARG_LIST,(yyvsp[-2].n),(yyvsp[0].n));
    } else {
      /* Error in assoc_pair */
      (yyval.n)=(yyvsp[-2].n);
    }
  }
#line 8235 "y.tab.c"
    break;

  case 442: /* assoc_pair: expr0 expected_colon expr0  */
#line 3357 "language.yacc"
  {
    (yyval.n)=mknode(F_ARG_LIST,(yyvsp[-2].n),(yyvsp[0].n));
  }
#line 8243 "y.tab.c"
    break;

  case 443: /* assoc_pair: expr0 expected_colon error  */
#line 3360 "language.yacc"
                               { free_node((yyvsp[-2].n)); (yyval.n)=0; }
#line 8249 "y.tab.c"
    break;

  case 445: /* expr1: expr1 TOK_LOR expr1  */
#line 3364 "language.yacc"
                         { (yyval.n)=mknode(F_LOR,(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8255 "y.tab.c"
    break;

  case 446: /* expr1: expr1 TOK_LAND expr1  */
#line 3365 "language.yacc"
                         { (yyval.n)=mknode(F_LAND,(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8261 "y.tab.c"
    break;

  case 447: /* expr1: expr1 '|' expr1  */
#line 3366 "language.yacc"
                       { (yyval.n)=mkopernode("`|",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8267 "y.tab.c"
    break;

  case 448: /* expr1: expr1 '^' expr1  */
#line 3367 "language.yacc"
                       { (yyval.n)=mkopernode("`^",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8273 "y.tab.c"
    break;

  case 449: /* expr1: expr1 '&' expr1  */
#line 3368 "language.yacc"
                       { (yyval.n)=mkopernode("`&",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8279 "y.tab.c"
    break;

  case 450: /* expr1: expr1 TOK_EQ expr1  */
#line 3369 "language.yacc"
                         { (yyval.n)=mkopernode("`==",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8285 "y.tab.c"
    break;

  case 451: /* expr1: expr1 TOK_NE expr1  */
#line 3370 "language.yacc"
                         { (yyval.n)=mkopernode("`!=",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8291 "y.tab.c"
    break;

  case 452: /* expr1: expr1 '>' expr1  */
#line 3371 "language.yacc"
                       { (yyval.n)=mkopernode("`>",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8297 "y.tab.c"
    break;

  case 453: /* expr1: expr1 TOK_GE expr1  */
#line 3372 "language.yacc"
                         { (yyval.n)=mkopernode("`>=",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8303 "y.tab.c"
    break;

  case 454: /* expr1: expr1 '<' expr1  */
#line 3373 "language.yacc"
                       { (yyval.n)=mkopernode("`<",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8309 "y.tab.c"
    break;

  case 455: /* expr1: expr1 TOK_LE expr1  */
#line 3374 "language.yacc"
                         { (yyval.n)=mkopernode("`<=",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8315 "y.tab.c"
    break;

  case 456: /* expr1: expr1 TOK_LSH expr1  */
#line 3375 "language.yacc"
                         { (yyval.n)=mkopernode("`<<",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8321 "y.tab.c"
    break;

  case 457: /* expr1: expr1 TOK_RSH expr1  */
#line 3376 "language.yacc"
                         { (yyval.n)=mkopernode("`>>",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8327 "y.tab.c"
    break;

  case 458: /* expr1: expr1 '+' expr1  */
#line 3377 "language.yacc"
                       { (yyval.n)=mkopernode("`+",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8333 "y.tab.c"
    break;

  case 459: /* expr1: expr1 '-' expr1  */
#line 3378 "language.yacc"
                       { (yyval.n)=mkopernode("`-",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8339 "y.tab.c"
    break;

  case 460: /* expr1: expr1 '*' expr1  */
#line 3379 "language.yacc"
                       { (yyval.n)=mkopernode("`*",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8345 "y.tab.c"
    break;

  case 461: /* expr1: expr1 '%' expr1  */
#line 3380 "language.yacc"
                       { (yyval.n)=mkopernode("`%",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8351 "y.tab.c"
    break;

  case 462: /* expr1: expr1 '/' expr1  */
#line 3381 "language.yacc"
                       { (yyval.n)=mkopernode("`/",(yyvsp[-2].n),(yyvsp[0].n)); }
#line 8357 "y.tab.c"
    break;

  case 482: /* expr2: cast expr2  */
#line 3404 "language.yacc"
  {
    (yyval.n) = mkcastnode((yyvsp[-1].n)->u.sval.u.type, (yyvsp[0].n));
    free_node((yyvsp[-1].n));
  }
#line 8366 "y.tab.c"
    break;

  case 483: /* expr2: soft_cast expr2  */
#line 3409 "language.yacc"
  {
    (yyval.n) = mksoftcastnode((yyvsp[-1].n)->u.sval.u.type, (yyvsp[0].n));
    free_node((yyvsp[-1].n));
  }
#line 8375 "y.tab.c"
    break;

  case 484: /* expr2: TOK_INC expr4  */
#line 3413 "language.yacc"
                        { (yyval.n)=mknode(F_INC,(yyvsp[0].n),0); }
#line 8381 "y.tab.c"
    break;

  case 485: /* expr2: TOK_DEC expr4  */
#line 3414 "language.yacc"
                        { (yyval.n)=mknode(F_DEC,(yyvsp[0].n),0); }
#line 8387 "y.tab.c"
    break;

  case 486: /* expr2: TOK_NOT expr2  */
#line 3415 "language.yacc"
                         { (yyval.n)=mkopernode("`!",(yyvsp[0].n),0); }
#line 8393 "y.tab.c"
    break;

  case 487: /* expr2: '~' expr2  */
#line 3416 "language.yacc"
                       { (yyval.n)=mkopernode("`~",(yyvsp[0].n),0); }
#line 8399 "y.tab.c"
    break;

  case 488: /* expr2: '-' expr2  */
#line 3417 "language.yacc"
                       { (yyval.n)=mkopernode("`-",(yyvsp[0].n),0); }
#line 8405 "y.tab.c"
    break;

  case 490: /* expr3: expr4 TOK_INC  */
#line 3421 "language.yacc"
                        { (yyval.n)=mknode(F_POST_INC,(yyvsp[-1].n),0); }
#line 8411 "y.tab.c"
    break;

  case 491: /* expr3: expr4 TOK_DEC  */
#line 3422 "language.yacc"
                        { (yyval.n)=mknode(F_POST_DEC,(yyvsp[-1].n),0); }
#line 8417 "y.tab.c"
    break;

  case 492: /* optional_block: %empty  */
#line 3444 "language.yacc"
                            { (yyval.n)=0; }
#line 8423 "y.tab.c"
    break;

  case 493: /* @38: %empty  */
#line 3448 "language.yacc"
  {
    debug_malloc_touch(Pike_compiler->compiler_frame->current_return_type);
    if(Pike_compiler->compiler_frame->current_return_type)
      free_type(Pike_compiler->compiler_frame->current_return_type);
    copy_pike_type(Pike_compiler->compiler_frame->current_return_type,
		   any_type_string);

    /* block code */
    (yyvsp[-2].number)=Pike_compiler->num_used_modules;
    (yyval.number)=Pike_compiler->compiler_frame->current_number_of_locals;
  }
#line 8439 "y.tab.c"
    break;

  case 494: /* optional_block: '{' line_number_info push_compiler_frame1 @38 statements end_block  */
#line 3460 "language.yacc"
  {
    struct pike_type *type;
    int f/*, e */;
    struct pike_string *name;
    struct compilation *c = THIS_COMPILATION;
    struct pike_string *save_file = c->lex.current_file;
    int save_line = c->lex.current_line;
    c->lex.current_file = (yyvsp[-4].n)->current_file;
    c->lex.current_line = (yyvsp[-4].n)->line_number;

    /* block code */
    unuse_modules(Pike_compiler->num_used_modules - (yyvsp[-5].number));
    (yyvsp[-1].n) = pop_local_variables((yyvsp[-2].number), (yyvsp[-1].n));

    debug_malloc_touch((yyvsp[-1].n));
    (yyvsp[-1].n)=mknode(F_COMMA_EXPR,(yyvsp[-1].n),mknode(F_RETURN,mkintnode(0),0));
    if (Pike_compiler->compiler_pass == 2) {
      /* Doing this in pass 1 might induce too strict checks on types
       * in cases where we got placeholders. */
      type=find_return_type((yyvsp[-1].n));
      if (type) {
	push_finished_type(type);
	free_type(type);
      } else {
	yywarning("Failed to determine return type for implicit lambda.");
	push_type(T_ZERO);
      }
    } else {
      /* Tentative return type. */
      push_type(T_MIXED);
    }

    push_type(T_VOID);
    push_type(T_MANY);
/*
    e=$5-1;
    for(; e>=0; e--)
      push_finished_type(Pike_compiler->compiler_frame->variable[e].type);
*/

    type=compiler_pop_type();

    name = get_new_name(NULL);

#ifdef LAMBDA_DEBUG
    fprintf(stderr, "%d: IMPLICIT LAMBDA: %s 0x%08lx 0x%08lx\n",
	    Pike_compiler->compiler_pass, name->str,
	    (long)Pike_compiler->new_program->id,
	    Pike_compiler->local_class_counter-1);
#endif /* LAMBDA_DEBUG */

    f=dooptcode(name,
		(yyvsp[-1].n),
		type,
		ID_PROTECTED | ID_PRIVATE | ID_INLINE | ID_USED);

    if(Pike_compiler->compiler_frame->lexical_scope & SCOPE_SCOPED) {
      (yyval.n) = mktrampolinenode(f,Pike_compiler->compiler_frame->previous);
    } else {
      (yyval.n) = mkidentifiernode(f);
    }

    c->lex.current_line = save_line;
    c->lex.current_file = save_file;
    free_node ((yyvsp[-4].n));
    free_string(name);
    free_type(type);
#ifdef PIKE_DEBUG
    if (Pike_compiler->compiler_frame != (yyvsp[-3].ptr)) {
      Pike_fatal("Lost track of compiler_frame!\n"
		 "  Got: %p (Expected: %p) Previous: %p\n",
		 Pike_compiler->compiler_frame, (yyvsp[-3].ptr),
		 Pike_compiler->compiler_frame->previous);
    }
#endif
    pop_compiler_frame();
  }
#line 8521 "y.tab.c"
    break;

  case 495: /* apply: expr4 open_paren_with_line_info expr_list ')' optional_block  */
#line 3541 "language.yacc"
  {
    (yyval.n) = mkapplynode((yyvsp[-4].n), mknode(F_ARG_LIST, (yyvsp[-2].n), (yyvsp[0].n)));
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-3].n));
    free_node ((yyvsp[-3].n));
  }
#line 8531 "y.tab.c"
    break;

  case 496: /* apply: expr4 open_paren_with_line_info error ')' optional_block  */
#line 3547 "language.yacc"
  {
    (yyval.n)=mkapplynode((yyvsp[-4].n), (yyvsp[0].n));
    free_node ((yyvsp[-3].n));
    yyerrok;
  }
#line 8541 "y.tab.c"
    break;

  case 497: /* apply: expr4 open_paren_with_line_info error TOK_LEX_EOF  */
#line 3553 "language.yacc"
  {
    yyerror("Missing ')'.");
    yyerror("Unexpected end of file.");
    (yyval.n)=mkapplynode((yyvsp[-3].n), NULL);
    free_node ((yyvsp[-2].n));
  }
#line 8552 "y.tab.c"
    break;

  case 498: /* apply: expr4 open_paren_with_line_info error ';'  */
#line 3560 "language.yacc"
  {
    yyerror("Missing ')'.");
    (yyval.n)=mkapplynode((yyvsp[-3].n), NULL);
    free_node ((yyvsp[-2].n));
  }
#line 8562 "y.tab.c"
    break;

  case 499: /* apply: expr4 open_paren_with_line_info error '}'  */
#line 3566 "language.yacc"
  {
    yyerror("Missing ')'.");
    (yyval.n)=mkapplynode((yyvsp[-3].n), NULL);
    free_node ((yyvsp[-2].n));
  }
#line 8572 "y.tab.c"
    break;

  case 500: /* implicit_modifiers: %empty  */
#line 3574 "language.yacc"
  {
    if (TEST_COMPAT(7, 6)) {
      (yyval.number) = Pike_compiler->current_modifiers =
	(THIS_COMPILATION->lex.pragmas & ID_MODIFIER_MASK);
    } else {
      (yyval.number) = Pike_compiler->current_modifiers = ID_PROTECTED|ID_INLINE|ID_PRIVATE |
	(THIS_COMPILATION->lex.pragmas & ID_MODIFIER_MASK);
    }
  }
#line 8586 "y.tab.c"
    break;

  case 503: /* expr4: TOK_FLOAT  */
#line 3587 "language.yacc"
              { (yyval.n)=mkfloatnode((FLOAT_TYPE)(yyvsp[0].fnum)); }
#line 8592 "y.tab.c"
    break;

  case 509: /* expr4: implicit_modifiers class  */
#line 3593 "language.yacc"
                             { (yyval.n) = (yyvsp[0].n); }
#line 8598 "y.tab.c"
    break;

  case 510: /* expr4: implicit_modifiers enum  */
#line 3594 "language.yacc"
                            { (yyval.n) = (yyvsp[0].n); }
#line 8604 "y.tab.c"
    break;

  case 513: /* expr4: expr4 open_bracket_with_line_info '*' ']'  */
#line 3598 "language.yacc"
  {
    (yyval.n)=mknode(F_AUTO_MAP_MARKER, (yyvsp[-3].n), 0);
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-2].n));
    free_node ((yyvsp[-2].n));
  }
#line 8614 "y.tab.c"
    break;

  case 514: /* expr4: expr4 open_bracket_with_line_info expr0 ']'  */
#line 3604 "language.yacc"
  {
    (yyval.n)=mknode(F_INDEX,(yyvsp[-3].n),(yyvsp[-1].n));
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-2].n));
    free_node ((yyvsp[-2].n));
  }
#line 8624 "y.tab.c"
    break;

  case 515: /* expr4: expr4 open_bracket_with_line_info range_bound expected_dot_dot range_bound ']'  */
#line 3611 "language.yacc"
  {
    (yyval.n)=mknode(F_RANGE,(yyvsp[-5].n),mknode(':',(yyvsp[-3].n),(yyvsp[-1].n)));
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-4].n));
    free_node ((yyvsp[-4].n));
  }
#line 8634 "y.tab.c"
    break;

  case 516: /* expr4: expr4 TOK_SAFE_START_INDEX line_number_info expr0 ']'  */
#line 3617 "language.yacc"
  {
    /* A[?X] to ((tmp=A) && tmp[X]) */
    if( (yyvsp[-4].n) && ((yyvsp[-4].n)->token == F_LOCAL) )
    {
      (yyval.n)=mknode(F_LAND, copy_node((yyvsp[-4].n)), mknode(F_INDEX,  (yyvsp[-4].n), (yyvsp[-1].n)));
    }
    else
    {
      fix_type_field( (yyvsp[-4].n) );
      if( (yyvsp[-4].n) && (yyvsp[-4].n)->type )
      {
        int temporary;
        (yyvsp[-4].n)->type->refs++;

        temporary = add_local_name(empty_pike_string, (yyvsp[-4].n)->type, 0);
        Pike_compiler->compiler_frame->variable[temporary].flags |= LOCAL_VAR_IS_USED;
        (yyval.n)=mknode(F_LAND,
                  mknode(F_ASSIGN, (yyvsp[-4].n), mklocalnode(temporary,0)),
                  mknode(F_INDEX,  mklocalnode(temporary,0), (yyvsp[-1].n)));
      }
      else
      {
        (yyval.n)=mknode(F_INDEX, (yyvsp[-4].n),(yyvsp[-1].n));
        yyerror("Indexing unexpected value.");
      }
    }
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-2].n));
    free_node ((yyvsp[-2].n));
  }
#line 8668 "y.tab.c"
    break;

  case 517: /* expr4: expr4 TOK_SAFE_START_INDEX line_number_info range_bound expected_dot_dot range_bound ']'  */
#line 3648 "language.yacc"
  {
    /* A[?X..Y] to ((tmp=A) && tmp[X..Y]) */
    node *range = mknode(':',(yyvsp[-3].n),(yyvsp[-1].n));
    if( (yyvsp[-6].n) && ((yyvsp[-6].n)->token == F_LOCAL ) )
    {
      (yyval.n) = mknode( F_LAND, copy_node((yyvsp[-6].n)), mknode(F_RANGE, (yyvsp[-6].n), range) );
    }
    else
    {
      fix_type_field( (yyvsp[-6].n) );
      if( (yyvsp[-6].n) && (yyvsp[-6].n)->type )
      {
        int temporary;
        (yyvsp[-6].n)->type->refs++;

        temporary = add_local_name(empty_pike_string, (yyvsp[-6].n)->type, 0);
        Pike_compiler->compiler_frame->variable[temporary].flags |= LOCAL_VAR_IS_USED;
        (yyval.n)=mknode(F_LAND,
                  mknode(F_ASSIGN, (yyvsp[-6].n), mklocalnode(temporary,0) ),
                  mknode(F_RANGE,  mklocalnode(temporary,0), range) );
      }
      else
      {
        (yyval.n) = mknode( F_LAND, (yyvsp[-6].n), mknode(F_RANGE,(yyvsp[-6].n),range) );
        yyerror("Indexing unexpected value.");
      }
    }
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-4].n));
    free_node ((yyvsp[-4].n));
  }
#line 8703 "y.tab.c"
    break;

  case 518: /* expr4: expr4 open_bracket_with_line_info error ']'  */
#line 3679 "language.yacc"
  {
    (yyval.n)=(yyvsp[-3].n);
    free_node ((yyvsp[-2].n));
    yyerrok;
  }
#line 8713 "y.tab.c"
    break;

  case 519: /* expr4: expr4 open_bracket_with_line_info error TOK_LEX_EOF  */
#line 3685 "language.yacc"
  {
    (yyval.n)=(yyvsp[-3].n); yyerror("Missing ']'.");
    yyerror("Unexpected end of file.");
    free_node ((yyvsp[-2].n));
  }
#line 8723 "y.tab.c"
    break;

  case 520: /* expr4: expr4 open_bracket_with_line_info error ';'  */
#line 3691 "language.yacc"
    {(yyval.n)=(yyvsp[-3].n); yyerror("Missing ']'."); free_node ((yyvsp[-2].n));}
#line 8729 "y.tab.c"
    break;

  case 521: /* expr4: expr4 open_bracket_with_line_info error '}'  */
#line 3693 "language.yacc"
    {(yyval.n)=(yyvsp[-3].n); yyerror("Missing ']'."); free_node ((yyvsp[-2].n));}
#line 8735 "y.tab.c"
    break;

  case 522: /* expr4: expr4 open_bracket_with_line_info error ')'  */
#line 3695 "language.yacc"
    {(yyval.n)=(yyvsp[-3].n); yyerror("Missing ']'."); free_node ((yyvsp[-2].n));}
#line 8741 "y.tab.c"
    break;

  case 523: /* expr4: open_paren_with_line_info comma_expr2 ')'  */
#line 3697 "language.yacc"
    {
      (yyval.n)=(yyvsp[-1].n);
      if ((yyval.n)) {
	COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-2].n));
      }
      free_node ((yyvsp[-2].n));
    }
#line 8753 "y.tab.c"
    break;

  case 524: /* expr4: open_paren_with_line_info '{' expr_list close_brace_or_missing ')'  */
#line 3705 "language.yacc"
    {
      /* FIXME: May eat lots of stack; cf Standards.FIPS10_4.divisions */
      (yyval.n)=mkefuncallnode("aggregate",(yyvsp[-2].n));
      COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-4].n));
      free_node ((yyvsp[-4].n));
    }
#line 8764 "y.tab.c"
    break;

  case 525: /* expr4: open_paren_with_line_info open_bracket_with_line_info m_expr_list close_bracket_or_missing ')'  */
#line 3714 "language.yacc"
    {
      /* FIXME: May eat lots of stack; cf Standards.FIPS10_4.divisions */
      (yyval.n)=mkefuncallnode("aggregate_mapping",(yyvsp[-2].n));
      COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-4].n));
      free_node ((yyvsp[-4].n));
      free_node ((yyvsp[-3].n));
    }
#line 8776 "y.tab.c"
    break;

  case 526: /* expr4: TOK_MULTISET_START line_number_info expr_list TOK_MULTISET_END  */
#line 3722 "language.yacc"
    {
      /* FIXME: May eat lots of stack; cf Standards.FIPS10_4.divisions */
      (yyval.n)=mkefuncallnode("aggregate_multiset",(yyvsp[-1].n));
      COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-2].n));
      free_node ((yyvsp[-2].n));
    }
#line 8787 "y.tab.c"
    break;

  case 527: /* expr4: TOK_MULTISET_START line_number_info expr_list ')'  */
#line 3729 "language.yacc"
    {
      yyerror("Missing '>'.");
      (yyval.n)=mkefuncallnode("aggregate_multiset",(yyvsp[-1].n));
      COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-2].n));
      free_node ((yyvsp[-2].n));
    }
#line 8798 "y.tab.c"
    break;

  case 528: /* expr4: open_paren_with_line_info error ')'  */
#line 3735 "language.yacc"
                                        { (yyval.n)=(yyvsp[-2].n); yyerrok; }
#line 8804 "y.tab.c"
    break;

  case 529: /* expr4: open_paren_with_line_info error TOK_LEX_EOF  */
#line 3737 "language.yacc"
  {
    (yyval.n)=(yyvsp[-2].n); yyerror("Missing ')'.");
    yyerror("Unexpected end of file.");
  }
#line 8813 "y.tab.c"
    break;

  case 530: /* expr4: open_paren_with_line_info error ';'  */
#line 3741 "language.yacc"
                                        { (yyval.n)=(yyvsp[-2].n); yyerror("Missing ')'."); }
#line 8819 "y.tab.c"
    break;

  case 531: /* expr4: open_paren_with_line_info error '}'  */
#line 3742 "language.yacc"
                                        { (yyval.n)=(yyvsp[-2].n); yyerror("Missing ')'."); }
#line 8825 "y.tab.c"
    break;

  case 532: /* expr4: TOK_MULTISET_START line_number_info error TOK_MULTISET_END  */
#line 3743 "language.yacc"
                                                               { (yyval.n)=(yyvsp[-2].n); yyerrok; }
#line 8831 "y.tab.c"
    break;

  case 533: /* expr4: TOK_MULTISET_START line_number_info error ')'  */
#line 3744 "language.yacc"
                                                  {
    yyerror("Missing '>'.");
    (yyval.n)=(yyvsp[-2].n); yyerrok;
  }
#line 8840 "y.tab.c"
    break;

  case 534: /* expr4: TOK_MULTISET_START line_number_info error TOK_LEX_EOF  */
#line 3749 "language.yacc"
  {
    (yyval.n)=(yyvsp[-2].n); yyerror("Missing '>)'.");
    yyerror("Unexpected end of file.");
  }
#line 8849 "y.tab.c"
    break;

  case 535: /* expr4: TOK_MULTISET_START line_number_info error ';'  */
#line 3753 "language.yacc"
                                                  { (yyval.n)=(yyvsp[-2].n); yyerror("Missing '>)'."); }
#line 8855 "y.tab.c"
    break;

  case 536: /* expr4: TOK_MULTISET_START line_number_info error '}'  */
#line 3754 "language.yacc"
                                                  { (yyval.n)=(yyvsp[-2].n); yyerror("Missing '>)'."); }
#line 8861 "y.tab.c"
    break;

  case 537: /* expr4: expr4 TOK_ARROW line_number_info magic_identifier  */
#line 3756 "language.yacc"
  {
    (yyval.n)=mknode(F_ARROW,(yyvsp[-3].n),(yyvsp[0].n));
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-1].n));
    free_node ((yyvsp[-1].n));
  }
#line 8871 "y.tab.c"
    break;

  case 538: /* expr4: expr4 TOK_SAFE_INDEX line_number_info TOK_IDENTIFIER  */
#line 3762 "language.yacc"
  {
    /* A->?B to ((tmp=A) && tmp->B) */
    int temporary;
    if( (yyvsp[-3].n) && ((yyvsp[-3].n)->token == F_LOCAL) )
    {
      (yyval.n)=mknode(F_LAND, copy_node((yyvsp[-3].n)), mknode(F_ARROW, (yyvsp[-3].n), (yyvsp[0].n)));
    }
    else
    {
      fix_type_field( (yyvsp[-3].n) );
      if( (yyvsp[-3].n) && (yyvsp[-3].n)->type )
      {
        (yyvsp[-3].n)->type->refs++;

        temporary = add_local_name(empty_pike_string, (yyvsp[-3].n)->type, 0);
        Pike_compiler->compiler_frame->variable[temporary].flags |= LOCAL_VAR_IS_USED;
        (yyval.n)=mknode(F_LAND,
                  mknode(F_ASSIGN, (yyvsp[-3].n), mklocalnode(temporary,0)),
                  mknode(F_ARROW,  mklocalnode(temporary,0), (yyvsp[0].n)));
      }
      else
      {
        (yyval.n)=mknode(F_ARROW, (yyvsp[-3].n),(yyvsp[0].n));
        yyerror("Indexing unexpected value.");
      }
    }
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-1].n));
    free_node ((yyvsp[-1].n));
  }
#line 8905 "y.tab.c"
    break;

  case 539: /* expr4: expr4 '.' line_number_info TOK_IDENTIFIER  */
#line 3792 "language.yacc"
  {
    (yyval.n)=index_node((yyvsp[-3].n),".",(yyvsp[0].n)->u.sval.u.string);
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-1].n));
    free_node ((yyvsp[-3].n));
    free_node ((yyvsp[-1].n));
    free_node ((yyvsp[0].n));
  }
#line 8917 "y.tab.c"
    break;

  case 540: /* expr4: expr4 TOK_ARROW line_number_info error  */
#line 3799 "language.yacc"
                                           {(yyval.n)=(yyvsp[-3].n); free_node ((yyvsp[-1].n));}
#line 8923 "y.tab.c"
    break;

  case 542: /* idents2: TOK_LOCAL_ID TOK_COLON_COLON TOK_IDENTIFIER  */
#line 3804 "language.yacc"
  {
    int i;

    if(Pike_compiler->last_identifier) free_string(Pike_compiler->last_identifier);
    copy_shared_string(Pike_compiler->last_identifier, (yyvsp[0].n)->u.sval.u.string);

    if (((i = find_shared_string_identifier(Pike_compiler->last_identifier,
					    Pike_compiler->new_program)) >= 0) ||
	((i = really_low_find_shared_string_identifier(Pike_compiler->last_identifier,
						       Pike_compiler->new_program,
						       SEE_PROTECTED|
						       SEE_PRIVATE)) >= 0)) {
      struct reference *ref = Pike_compiler->new_program->identifier_references + i;
      if (IDENTIFIER_IS_VARIABLE (
	    ID_FROM_PTR (Pike_compiler->new_program, ref)->identifier_flags)) {
	/* Allowing local:: on variables would lead to pathological
	 * behavior: If a non-local variable in a class is referenced
	 * both with and without local::, both references would
	 * address the same variable in all cases except where an
	 * inheriting program overrides it (c.f. [bug 1252]).
	 *
	 * Furthermore, that's not how it works currently; if this
	 * error is removed then local:: will do nothing on variables
	 * except forcing a lookup in the closest surrounding class
	 * scope. */
	yyerror ("Cannot make local references to variables.");
	(yyval.n) = 0;
      }
      else {
	if (!(ref->id_flags & ID_LOCAL)) {
	  /* We need to generate a new reference. */
	  int d;
	  struct reference funp = *ref;
	  funp.id_flags = (funp.id_flags & ~ID_INHERITED) | ID_INLINE|ID_HIDDEN;
	  i = -1;
	  for(d = 0; d < (int)Pike_compiler->new_program->num_identifier_references; d++) {
	    struct reference *refp;
	    refp = Pike_compiler->new_program->identifier_references + d;

	    if (!(refp->id_flags & ID_LOCAL)) continue;

	    if((refp->inherit_offset == funp.inherit_offset) &&
	       (refp->identifier_offset == funp.identifier_offset)) {
	      i = d;
	      break;
	    }
	  }
	  if (i < 0) {
	    add_to_identifier_references(funp);
	    i = Pike_compiler->new_program->num_identifier_references - 1;
	  }
	}
	(yyval.n) = mkidentifiernode(i);
      }
    } else {
      if (Pike_compiler->compiler_pass == 2) {
	my_yyerror("%S not defined in local scope.",
		   Pike_compiler->last_identifier);
	(yyval.n) = 0;
      } else {
	(yyval.n) = mknode(F_UNDEFINED, 0, 0);
      }
    }

    free_node((yyvsp[0].n));
  }
#line 8994 "y.tab.c"
    break;

  case 543: /* idents2: TOK_LOCAL_ID TOK_COLON_COLON bad_identifier  */
#line 3871 "language.yacc"
  {
    (yyval.n)=0;
  }
#line 9002 "y.tab.c"
    break;

  case 545: /* idents: idents '.' TOK_IDENTIFIER  */
#line 3878 "language.yacc"
  {
    (yyval.n)=index_node((yyvsp[-2].n), Pike_compiler->last_identifier?Pike_compiler->last_identifier->str:NULL,
		  (yyvsp[0].n)->u.sval.u.string);
    free_node((yyvsp[-2].n));
    if(Pike_compiler->last_identifier) free_string(Pike_compiler->last_identifier);
    copy_shared_string(Pike_compiler->last_identifier, (yyvsp[0].n)->u.sval.u.string);
    free_node((yyvsp[0].n));
  }
#line 9015 "y.tab.c"
    break;

  case 546: /* idents: idents '.' bad_identifier  */
#line 3886 "language.yacc"
                              {}
#line 9021 "y.tab.c"
    break;

  case 547: /* idents: idents '.' error  */
#line 3887 "language.yacc"
                     {}
#line 9027 "y.tab.c"
    break;

  case 550: /* inherit_specifier: string_or_identifier TOK_COLON_COLON  */
#line 3901 "language.yacc"
  {
    struct compilation *c = THIS_COMPILATION;
    struct program_state *state = Pike_compiler;
    int depth;
    int e = -1;

    inherit_state = NULL;
    inherit_depth = 0;

    /* NB: The heuristics here are a bit strange
     *     (all to make it as backward compatible as possible).
     *
     *     The priority order is as follows:
     *
     *     1: Direct inherits in the current class.
     *
     *     2: The name of the current class.
     *
     *     3: 1 & 2 recursively for surrounding parent classes.
     *
     *     4: Indirect inherits in the current class.
     *
     *     5: 4 recursively for surrounding parent classes.
     *
     *     6: this_program.
     *
     * Note that a deep inherit in the current class trumphs
     * a not so deep inherit in a parent class (but not a
     * direct inherit in a parent class). To select the deep
     * inherit in the parent class in this case, prefix it
     * with the name of the parent class.
     */
    for (depth = 0;; depth++, state = state->previous) {
      int inh = find_inherit(state->new_program, (yyvsp[-1].n)->u.sval.u.string);
      if (inh &&
	  (!inherit_state ||
	   (state->new_program->inherits[inh].inherit_level == 1))) {
	/* Found, and we've either not found anything earlier,
	 * or this is a direct inherit (and the previous
	 * wasn't since we didn't break out of the loop).
	 */
	e = inh;
	inherit_state = state;
	inherit_depth = depth;
	if (state->new_program->inherits[inh].inherit_level == 1) {
	  /* Name of direct inherit ==> Done. */
	  break;
	}
      }
      /* The top-level class does not have a name, so break here. */
      if (depth == c->compilation_depth) break;
      if (ID_FROM_INT (state->previous->new_program,
		       state->parent_identifier)->name ==
	  (yyvsp[-1].n)->u.sval.u.string) {
	/* Name of surrounding class ==> Done. */
	e = 0;
	inherit_state = state;
	inherit_depth = depth;
	break;
      }
    }
    if (e == -1) {
      inherit_state = state;
      inherit_depth = depth;
      if ((yyvsp[-1].n)->u.sval.u.string == this_program_string || (yyvsp[-1].n)->u.sval.u.string == this_string) {
        inherit_state = Pike_compiler;
        inherit_depth = 0;
        e = 0;
      }
      else
        my_yyerror("No inherit or surrounding class %S.",
                   (yyvsp[-1].n)->u.sval.u.string);
    }
    free_node((yyvsp[-1].n));
    (yyval.number) = e;
  }
#line 9108 "y.tab.c"
    break;

  case 551: /* inherit_specifier: TOK_GLOBAL TOK_COLON_COLON  */
#line 3978 "language.yacc"
  {
    struct compilation *c = THIS_COMPILATION;
    inherit_state = Pike_compiler;
    for (inherit_depth = 0; inherit_depth < c->compilation_depth;
	 inherit_depth++, inherit_state = inherit_state->previous) {}
    (yyval.number) = -1;
  }
#line 9120 "y.tab.c"
    break;

  case 552: /* inherit_specifier: inherit_specifier TOK_IDENTIFIER TOK_COLON_COLON  */
#line 3986 "language.yacc"
  {
    int e = 0;
    if ((yyvsp[-2].number) < 0) {
      (yyvsp[-2].number) = 0;
    }
#if 0
    /* FIXME: The inherit modifiers aren't kept. */
    if (!(inherit_state->new_program->inherits[(yyvsp[-2].number)].flags & ID_PRIVATE)) {
#endif /* 0 */
      e = find_inherit(inherit_state->new_program->inherits[(yyvsp[-2].number)].prog,
		       (yyvsp[-1].n)->u.sval.u.string);
#if 0
    }
#endif /* 0 */
    if (!e) {
      if (inherit_state->new_program->inherits[(yyvsp[-2].number)].name) {
	my_yyerror("No such inherit %S::%S.",
		   inherit_state->new_program->inherits[(yyvsp[-2].number)].name,
		   (yyvsp[-1].n)->u.sval.u.string);
      } else {
	my_yyerror("No such inherit %S.", (yyvsp[-1].n)->u.sval.u.string);
      }
      (yyval.number) = -1;
    } else {
      /* We know stuff about the inherit structure... */
      (yyval.number) = e + (yyvsp[-2].number);
    }
    free_node((yyvsp[-1].n));
  }
#line 9154 "y.tab.c"
    break;

  case 553: /* inherit_specifier: inherit_specifier bad_identifier TOK_COLON_COLON  */
#line 4015 "language.yacc"
                                                     { (yyval.number) = -1; }
#line 9160 "y.tab.c"
    break;

  case 554: /* low_idents: TOK_IDENTIFIER  */
#line 4019 "language.yacc"
  {
    if(Pike_compiler->last_identifier) free_string(Pike_compiler->last_identifier);
    copy_shared_string(Pike_compiler->last_identifier, (yyvsp[0].n)->u.sval.u.string);

    if(((yyval.n)=lexical_islocal(Pike_compiler->last_identifier)))
    {
      /* done, nothing to do here */
    }else if(!((yyval.n)=find_module_identifier(Pike_compiler->last_identifier,1)) &&
	     !((yyval.n) = program_magic_identifier (Pike_compiler, 0, -1,
					      Pike_compiler->last_identifier, 0))) {
      if((Pike_compiler->flags & COMPILATION_FORCE_RESOLVE) ||
	 (Pike_compiler->compiler_pass==2)) {
	my_yyerror("Undefined identifier %S.",
		   Pike_compiler->last_identifier);
	/* FIXME: Add this identifier as a constant in the current program to
	 *        avoid multiple reporting of the same identifier.
	 * NOTE: This should then only be done in the second pass.
	 */	
	(yyval.n)=0;
      }else{
	(yyval.n)=mknode(F_UNDEFINED,0,0);
      }
    }
    free_node((yyvsp[0].n));
  }
#line 9190 "y.tab.c"
    break;

  case 555: /* low_idents: '.' TOK_IDENTIFIER  */
#line 4045 "language.yacc"
  {
    struct pike_string *dot;
    MAKE_CONST_STRING(dot, ".");
    if (call_handle_import(dot)) {
      node *tmp=mkconstantsvaluenode(Pike_sp-1);
      pop_stack();
      (yyval.n)=index_node(tmp, ".", (yyvsp[0].n)->u.sval.u.string);
      free_node(tmp);
    }
    else
      (yyval.n)=mknewintnode(0);
    if(Pike_compiler->last_identifier) free_string(Pike_compiler->last_identifier);
    copy_shared_string(Pike_compiler->last_identifier, (yyvsp[0].n)->u.sval.u.string);
    free_node((yyvsp[0].n));
  }
#line 9210 "y.tab.c"
    break;

  case 556: /* low_idents: TOK_GLOBAL '.' TOK_IDENTIFIER  */
#line 4061 "language.yacc"
  {
    (yyval.n) = resolve_identifier ((yyvsp[0].n)->u.sval.u.string);
    if(Pike_compiler->last_identifier) free_string(Pike_compiler->last_identifier);
    copy_shared_string(Pike_compiler->last_identifier, (yyvsp[0].n)->u.sval.u.string);
    free_node ((yyvsp[0].n));
  }
#line 9221 "y.tab.c"
    break;

  case 557: /* low_idents: TOK_RESERVED  */
#line 4068 "language.yacc"
  {
    ref_push_string((yyvsp[0].n)->u.sval.u.string);
    low_yyreport(REPORT_ERROR, NULL, 0, parser_system_string,
		 1, "Unknown reserved symbol %s.");
    free_node((yyvsp[0].n));
    (yyval.n) = 0;
  }
#line 9233 "y.tab.c"
    break;

  case 558: /* low_idents: TOK_PREDEF TOK_COLON_COLON TOK_IDENTIFIER  */
#line 4076 "language.yacc"
  {
    struct compilation *c = THIS_COMPILATION;
    node *tmp2;

    if(Pike_compiler->last_identifier)
      free_string(Pike_compiler->last_identifier);
    copy_shared_string(Pike_compiler->last_identifier, (yyvsp[0].n)->u.sval.u.string);

    tmp2 = mkconstantsvaluenode(&c->default_module);
    (yyval.n) = index_node(tmp2, "predef", (yyvsp[0].n)->u.sval.u.string);
    if(!(yyval.n)->name)
      add_ref( (yyval.n)->name=(yyvsp[0].n)->u.sval.u.string );
    free_node(tmp2);
    free_node((yyvsp[0].n));
  }
#line 9253 "y.tab.c"
    break;

  case 559: /* low_idents: TOK_PREDEF TOK_COLON_COLON bad_identifier  */
#line 4092 "language.yacc"
  {
    (yyval.n)=0;
  }
#line 9261 "y.tab.c"
    break;

  case 560: /* low_idents: TOK_VERSION TOK_COLON_COLON TOK_IDENTIFIER  */
#line 4096 "language.yacc"
  {
    (yyval.n) = find_versioned_identifier((yyvsp[0].n)->u.sval.u.string,
				   (yyvsp[-2].n)->u.integer.a, (yyvsp[-2].n)->u.integer.b);
    free_node((yyvsp[-2].n));
    free_node((yyvsp[0].n));
  }
#line 9272 "y.tab.c"
    break;

  case 561: /* low_idents: TOK_VERSION TOK_COLON_COLON bad_identifier  */
#line 4103 "language.yacc"
  {
    free_node((yyvsp[-2].n));
    (yyval.n)=0;
  }
#line 9281 "y.tab.c"
    break;

  case 562: /* low_idents: inherit_specifier TOK_IDENTIFIER  */
#line 4108 "language.yacc"
  {
    int id;

    if(Pike_compiler->last_identifier) free_string(Pike_compiler->last_identifier);
    copy_shared_string(Pike_compiler->last_identifier, (yyvsp[0].n)->u.sval.u.string);

    if ((yyvsp[-1].number) > 0)
      id = low_reference_inherited_identifier(inherit_state,
					      (yyvsp[-1].number),
					      Pike_compiler->last_identifier,
					      SEE_PROTECTED);
    else
      id = really_low_find_shared_string_identifier(Pike_compiler->last_identifier,
						    inherit_state->new_program,
						    SEE_PROTECTED|SEE_PRIVATE);

    if (id != -1) {
      if (inherit_depth > 0) {
	(yyval.n) = mkexternalnode(inherit_state->new_program, id);
      } else {
	(yyval.n) = mkidentifiernode(id);
      }
    } else if (((yyval.n) = program_magic_identifier (inherit_state, inherit_depth, (yyvsp[-1].number),
					       Pike_compiler->last_identifier, 1))) {
      /* All done. */
    }
    else {
      if ((Pike_compiler->flags & COMPILATION_FORCE_RESOLVE) ||
	  (Pike_compiler->compiler_pass == 2)) {
	if (((yyvsp[-1].number) >= 0) && inherit_state->new_program->inherits[(yyvsp[-1].number)].name) {
	  my_yyerror("Undefined identifier %S::%S.",
		     inherit_state->new_program->inherits[(yyvsp[-1].number)].name,
		     Pike_compiler->last_identifier);
	} else {
	  my_yyerror("Undefined identifier %S.",
		     Pike_compiler->last_identifier);
	}
	(yyval.n)=0;
      }
      else
	(yyval.n)=mknode(F_UNDEFINED,0,0);
    }

    free_node((yyvsp[0].n));
  }
#line 9331 "y.tab.c"
    break;

  case 563: /* low_idents: inherit_specifier bad_identifier  */
#line 4153 "language.yacc"
                                     { (yyval.n)=0; }
#line 9337 "y.tab.c"
    break;

  case 564: /* low_idents: inherit_specifier error  */
#line 4154 "language.yacc"
                            { (yyval.n)=0; }
#line 9343 "y.tab.c"
    break;

  case 565: /* low_idents: TOK_COLON_COLON TOK_IDENTIFIER  */
#line 4156 "language.yacc"
  {
    int e,i;

    if(Pike_compiler->last_identifier) free_string(Pike_compiler->last_identifier);
    copy_shared_string(Pike_compiler->last_identifier, (yyvsp[0].n)->u.sval.u.string);

    (yyval.n)=0;
    for(e=1;e<(int)Pike_compiler->new_program->num_inherits;e++)
    {
      if(Pike_compiler->new_program->inherits[e].inherit_level!=1) continue;
      i=low_reference_inherited_identifier(0,e,(yyvsp[0].n)->u.sval.u.string,SEE_PROTECTED);
      if(i==-1) continue;
      if((yyval.n))
      {
	(yyval.n)=mknode(F_ARG_LIST,(yyval.n),mkidentifiernode(i));
      }else{
	(yyval.n)=mkidentifiernode(i);
      }
    }
    if(!(yyval.n))
    {
      if (!((yyval.n) = program_magic_identifier (Pike_compiler, 0, -1,
					   (yyvsp[0].n)->u.sval.u.string, 1)))
      {
	if (Pike_compiler->compiler_pass == 2) {
          my_yyerror("Undefined identifier ::%S.", (yyvsp[0].n)->u.sval.u.string);
	}
	(yyval.n)=mkintnode(0);
      }
    }else{
      if((yyval.n)->token==F_ARG_LIST) (yyval.n)=mkefuncallnode("aggregate",(yyval.n));
    }
    free_node((yyvsp[0].n));
  }
#line 9382 "y.tab.c"
    break;

  case 566: /* low_idents: TOK_COLON_COLON bad_identifier  */
#line 4191 "language.yacc"
  {
    (yyval.n)=0;
  }
#line 9390 "y.tab.c"
    break;

  case 567: /* range_bound: %empty  */
#line 4198 "language.yacc"
  {(yyval.n) = mknode (F_RANGE_OPEN, NULL, NULL);}
#line 9396 "y.tab.c"
    break;

  case 568: /* range_bound: comma_expr  */
#line 4200 "language.yacc"
  {(yyval.n) = mknode (F_RANGE_FROM_BEG, (yyvsp[0].n), NULL);}
#line 9402 "y.tab.c"
    break;

  case 569: /* range_bound: '<' comma_expr  */
#line 4202 "language.yacc"
  {(yyval.n) = mknode (F_RANGE_FROM_END, (yyvsp[0].n), NULL);}
#line 9408 "y.tab.c"
    break;

  case 570: /* range_bound: TOK_LEX_EOF  */
#line 4204 "language.yacc"
  {
    yyerror("Unexpected end of file.");
    (yyval.n) = mknode (F_RANGE_OPEN, NULL, NULL);
  }
#line 9417 "y.tab.c"
    break;

  case 571: /* range_bound: '<' TOK_LEX_EOF  */
#line 4209 "language.yacc"
  {
    yyerror("Unexpected end of file.");
    (yyval.n) = mknode (F_RANGE_OPEN, NULL, NULL);
  }
#line 9426 "y.tab.c"
    break;

  case 572: /* gauge: TOK_GAUGE catch_arg  */
#line 4216 "language.yacc"
  {
    (yyval.n)=mkopernode("`/",
		  mkopernode("`-",
			     mkopernode("`-",
					mkefuncallnode("gethrvtime",
						       mkintnode(1)),
					mknode(F_COMMA_EXPR,
					       mknode(F_POP_VALUE, (yyvsp[0].n), NULL),
					       mkefuncallnode("gethrvtime",
							      mkintnode(1)))),
			     NULL),
		  mkfloatnode((FLOAT_TYPE)1e9));
  }
#line 9444 "y.tab.c"
    break;

  case 573: /* typeof: TOK_TYPEOF '(' expr0 ')'  */
#line 4231 "language.yacc"
  {
    struct pike_type *t;
    node *tmp;

    /* FIXME: Why build the node at all? */
    /* Because the optimizer cannot optimize the root node of the
     * tree properly -Hubbe
     */
    tmp=mknode(F_COMMA_EXPR, (yyvsp[-1].n), 0);
    optimize_node(tmp);

    t=(tmp && CAR(tmp) && CAR(tmp)->type ? CAR(tmp)->type : mixed_type_string);
    (yyval.n) = mktypenode(t);
    free_node(tmp);
  }
#line 9464 "y.tab.c"
    break;

  case 574: /* typeof: TOK_TYPEOF '(' error ')'  */
#line 4246 "language.yacc"
                             { (yyval.n)=0; yyerrok; }
#line 9470 "y.tab.c"
    break;

  case 575: /* typeof: TOK_TYPEOF '(' error '}'  */
#line 4247 "language.yacc"
                             { (yyval.n)=0; yyerror("Missing ')'."); }
#line 9476 "y.tab.c"
    break;

  case 576: /* typeof: TOK_TYPEOF '(' error TOK_LEX_EOF  */
#line 4249 "language.yacc"
  {
    (yyval.n)=0; yyerror("Missing ')'.");
    yyerror("Unexpected end of file.");
  }
#line 9485 "y.tab.c"
    break;

  case 577: /* typeof: TOK_TYPEOF '(' error ';'  */
#line 4253 "language.yacc"
                             { (yyval.n)=0; yyerror("Missing ')'."); }
#line 9491 "y.tab.c"
    break;

  case 578: /* catch_arg: '(' comma_expr ')'  */
#line 4256 "language.yacc"
                               { (yyval.n)=(yyvsp[-1].n); }
#line 9497 "y.tab.c"
    break;

  case 579: /* catch_arg: '(' error ')'  */
#line 4257 "language.yacc"
                  { (yyval.n)=0; yyerrok; }
#line 9503 "y.tab.c"
    break;

  case 580: /* catch_arg: '(' error TOK_LEX_EOF  */
#line 4259 "language.yacc"
  {
    (yyval.n)=0; yyerror("Missing ')'.");
    yyerror("Unexpected end of file.");
  }
#line 9512 "y.tab.c"
    break;

  case 581: /* catch_arg: '(' error '}'  */
#line 4263 "language.yacc"
                  { (yyval.n)=0; yyerror("Missing ')'."); }
#line 9518 "y.tab.c"
    break;

  case 582: /* catch_arg: '(' error ';'  */
#line 4264 "language.yacc"
                  { (yyval.n)=0; yyerror("Missing ')'."); }
#line 9524 "y.tab.c"
    break;

  case 584: /* catch_arg: error  */
#line 4266 "language.yacc"
          { (yyval.n)=0; yyerror("Bad expression for catch."); }
#line 9530 "y.tab.c"
    break;

  case 585: /* $@39: %empty  */
#line 4270 "language.yacc"
     {
       Pike_compiler->catch_level++;
     }
#line 9538 "y.tab.c"
    break;

  case 586: /* catch: TOK_CATCH $@39 catch_arg  */
#line 4274 "language.yacc"
     {
       (yyval.n)=mknode(F_CATCH,(yyvsp[0].n),NULL);
       Pike_compiler->catch_level--;
     }
#line 9547 "y.tab.c"
    break;

  case 587: /* sscanf: TOK_SSCANF '(' expr0 ',' expr0 lvalue_list ')'  */
#line 4281 "language.yacc"
  {
    if ((yyvsp[-1].n) && !(THIS_COMPILATION->lex.pragmas & ID_STRICT_TYPES)) {
      mark_lvalues_as_used((yyvsp[-1].n));
    }
    (yyval.n)=mknode(F_SSCANF,mknode(':', mkintnode(TEST_COMPAT(7, 6)? SSCANF_FLAG_76_COMPAT : 0), mknode(F_ARG_LIST,(yyvsp[-4].n),(yyvsp[-2].n))),(yyvsp[-1].n));
  }
#line 9558 "y.tab.c"
    break;

  case 588: /* sscanf: TOK_SSCANF '(' expr0 ',' expr0 error ')'  */
#line 4288 "language.yacc"
  {
    (yyval.n)=0;
    free_node((yyvsp[-4].n));
    free_node((yyvsp[-2].n));
    yyerrok;
  }
#line 9569 "y.tab.c"
    break;

  case 589: /* sscanf: TOK_SSCANF '(' expr0 ',' expr0 error TOK_LEX_EOF  */
#line 4295 "language.yacc"
  {
    (yyval.n)=0;
    free_node((yyvsp[-4].n));
    free_node((yyvsp[-2].n));
    yyerror("Missing ')'.");
    yyerror("Unexpected end of file.");
  }
#line 9581 "y.tab.c"
    break;

  case 590: /* sscanf: TOK_SSCANF '(' expr0 ',' expr0 error '}'  */
#line 4303 "language.yacc"
  {
    (yyval.n)=0;
    free_node((yyvsp[-4].n));
    free_node((yyvsp[-2].n));
    yyerror("Missing ')'.");
  }
#line 9592 "y.tab.c"
    break;

  case 591: /* sscanf: TOK_SSCANF '(' expr0 ',' expr0 error ';'  */
#line 4310 "language.yacc"
  {
    (yyval.n)=0;
    free_node((yyvsp[-4].n));
    free_node((yyvsp[-2].n));
    yyerror("Missing ')'.");
  }
#line 9603 "y.tab.c"
    break;

  case 592: /* sscanf: TOK_SSCANF '(' expr0 error ')'  */
#line 4317 "language.yacc"
  {
    (yyval.n)=0;
    free_node((yyvsp[-2].n));
    yyerrok;
  }
#line 9613 "y.tab.c"
    break;

  case 593: /* sscanf: TOK_SSCANF '(' expr0 error TOK_LEX_EOF  */
#line 4323 "language.yacc"
  {
    (yyval.n)=0;
    free_node((yyvsp[-2].n));
    yyerror("Missing ')'.");
    yyerror("Unexpected end of file.");
  }
#line 9624 "y.tab.c"
    break;

  case 594: /* sscanf: TOK_SSCANF '(' expr0 error '}'  */
#line 4330 "language.yacc"
  {
    (yyval.n)=0;
    free_node((yyvsp[-2].n));
    yyerror("Missing ')'.");
  }
#line 9634 "y.tab.c"
    break;

  case 595: /* sscanf: TOK_SSCANF '(' expr0 error ';'  */
#line 4336 "language.yacc"
  {
    (yyval.n)=0;
    free_node((yyvsp[-2].n));
    yyerror("Missing ')'.");
  }
#line 9644 "y.tab.c"
    break;

  case 596: /* sscanf: TOK_SSCANF '(' error ')'  */
#line 4341 "language.yacc"
                             { (yyval.n)=0; yyerrok; }
#line 9650 "y.tab.c"
    break;

  case 597: /* sscanf: TOK_SSCANF '(' error TOK_LEX_EOF  */
#line 4343 "language.yacc"
  {
    (yyval.n)=0; yyerror("Missing ')'.");
    yyerror("Unexpected end of file.");
  }
#line 9659 "y.tab.c"
    break;

  case 598: /* sscanf: TOK_SSCANF '(' error '}'  */
#line 4347 "language.yacc"
                             { (yyval.n)=0; yyerror("Missing ')'."); }
#line 9665 "y.tab.c"
    break;

  case 599: /* sscanf: TOK_SSCANF '(' error ';'  */
#line 4348 "language.yacc"
                             { (yyval.n)=0; yyerror("Missing ')'."); }
#line 9671 "y.tab.c"
    break;

  case 601: /* lvalue: open_bracket_with_line_info low_lvalue_list ']'  */
#line 4353 "language.yacc"
  {
    (yyval.n)=mknode(F_ARRAY_LVALUE, (yyvsp[-1].n),0);
    COPY_LINE_NUMBER_INFO((yyval.n), (yyvsp[-2].n));
    free_node((yyvsp[-2].n));
  }
#line 9681 "y.tab.c"
    break;

  case 602: /* lvalue: type2 TOK_IDENTIFIER  */
#line 4359 "language.yacc"
  {
    int id = add_local_name((yyvsp[0].n)->u.sval.u.string,compiler_pop_type(),0);
    /* Note: Variable intentionally not marked as used. */
    if (id >= 0)
      (yyval.n)=mklocalnode(id,-1);
    else
      (yyval.n) = 0;
    free_node((yyvsp[0].n));
  }
#line 9695 "y.tab.c"
    break;

  case 603: /* lvalue: bad_expr_ident  */
#line 4370 "language.yacc"
  { (yyval.n)=mknewintnode(0); }
#line 9701 "y.tab.c"
    break;

  case 604: /* low_lvalue_list: lvalue lvalue_list  */
#line 4374 "language.yacc"
  {
    (yyval.n)=mknode(F_LVALUE_LIST,(yyvsp[-1].n),(yyvsp[0].n));
  }
#line 9709 "y.tab.c"
    break;

  case 605: /* lvalue_list: %empty  */
#line 4379 "language.yacc"
                         { (yyval.n) = 0; }
#line 9715 "y.tab.c"
    break;

  case 606: /* lvalue_list: ',' lvalue lvalue_list  */
#line 4381 "language.yacc"
  {
    (yyval.n) = mknode(F_LVALUE_LIST,(yyvsp[-1].n),(yyvsp[0].n));
  }
#line 9723 "y.tab.c"
    break;

  case 608: /* string_segment: TOK_FUNCTION_NAME  */
#line 4388 "language.yacc"
  {
    struct compiler_frame *f = Pike_compiler->compiler_frame;
    if (!f || (f->current_function_number < 0)) {
      (yyval.n) = mkstrnode(lfun_strings[LFUN___INIT]);
    } else {
      struct identifier *id =
	ID_FROM_INT(Pike_compiler->new_program, f->current_function_number);
      if (!id->name->size_shift) {
	int len;
	if ((len = strlen(id->name->str)) == id->name->len) {
	  /* Most common case. */
	  (yyval.n) = mkstrnode(id->name);
	} else {
	  struct pike_string *str =
	    make_shared_binary_string(id->name->str, len);
	  (yyval.n) = mkstrnode(str);
	  free_string(str);
	}
      } else {
	struct pike_string *str;
	struct array *split;
	MAKE_CONST_STRING(str, "\0");
	split = explode(id->name, str);
	(yyval.n) = mkstrnode(split->item->u.string);
	free_array(split);
      }
    }
  }
#line 9756 "y.tab.c"
    break;

  case 610: /* string: string string_segment  */
#line 4420 "language.yacc"
  {
    struct pike_string *a,*b;
    copy_shared_string(a,(yyvsp[-1].n)->u.sval.u.string);
    copy_shared_string(b,(yyvsp[0].n)->u.sval.u.string);
    free_node((yyvsp[-1].n));
    free_node((yyvsp[0].n));
    a=add_and_free_shared_strings(a,b);
    (yyval.n)=mkstrnode(a);
    free_string(a);
  }
#line 9771 "y.tab.c"
    break;

  case 612: /* string_constant: string_constant '+' string  */
#line 4434 "language.yacc"
  {
    struct pike_string *a,*b;
    copy_shared_string(a,(yyvsp[-2].n)->u.sval.u.string);
    copy_shared_string(b,(yyvsp[0].n)->u.sval.u.string);
    free_node((yyvsp[-2].n));
    free_node((yyvsp[0].n));
    a=add_and_free_shared_strings(a,b);
    (yyval.n)=mkstrnode(a);
    free_string(a);
  }
#line 9786 "y.tab.c"
    break;

  case 614: /* real_string_constant: real_string_constant TOK_STRING  */
#line 4449 "language.yacc"
  {
    struct pike_string *a,*b;
    copy_shared_string(a,(yyvsp[-1].n)->u.sval.u.string);
    copy_shared_string(b,(yyvsp[0].n)->u.sval.u.string);
    free_node((yyvsp[-1].n));
    free_node((yyvsp[0].n));
    a=add_and_free_shared_strings(a,b);
    (yyval.n)=mkstrnode(a);
    free_string(a);
  }
#line 9801 "y.tab.c"
    break;

  case 615: /* real_string_constant: real_string_constant '+' TOK_STRING  */
#line 4460 "language.yacc"
  {
    struct pike_string *a,*b;
    copy_shared_string(a,(yyvsp[-2].n)->u.sval.u.string);
    copy_shared_string(b,(yyvsp[0].n)->u.sval.u.string);
    free_node((yyvsp[-2].n));
    free_node((yyvsp[0].n));
    a=add_and_free_shared_strings(a,b);
    (yyval.n)=mkstrnode(a);
    free_string(a);
  }
#line 9816 "y.tab.c"
    break;

  case 617: /* bad_identifier: TOK_ARRAY_ID  */
#line 4480 "language.yacc"
  { yyerror_reserved("array"); }
#line 9822 "y.tab.c"
    break;

  case 618: /* bad_identifier: TOK_ATTRIBUTE_ID  */
#line 4482 "language.yacc"
  { yyerror_reserved("__attribute__"); }
#line 9828 "y.tab.c"
    break;

  case 619: /* bad_identifier: TOK_CLASS  */
#line 4484 "language.yacc"
  { yyerror_reserved("class"); }
#line 9834 "y.tab.c"
    break;

  case 620: /* bad_identifier: TOK_DEPRECATED_ID  */
#line 4486 "language.yacc"
  { yyerror_reserved("__deprecated__"); }
#line 9840 "y.tab.c"
    break;

  case 621: /* bad_identifier: TOK_ENUM  */
#line 4488 "language.yacc"
  { yyerror_reserved("enum"); }
#line 9846 "y.tab.c"
    break;

  case 622: /* bad_identifier: TOK_FLOAT_ID  */
#line 4490 "language.yacc"
  { yyerror_reserved("float");}
#line 9852 "y.tab.c"
    break;

  case 623: /* bad_identifier: TOK_FUNCTION_ID  */
#line 4492 "language.yacc"
  { yyerror_reserved("function");}
#line 9858 "y.tab.c"
    break;

  case 624: /* bad_identifier: TOK_FUNCTION_NAME  */
#line 4494 "language.yacc"
  { yyerror_reserved("__FUNCTION__");}
#line 9864 "y.tab.c"
    break;

  case 625: /* bad_identifier: TOK_INT_ID  */
#line 4496 "language.yacc"
  { yyerror_reserved("int"); }
#line 9870 "y.tab.c"
    break;

  case 626: /* bad_identifier: TOK_MAPPING_ID  */
#line 4498 "language.yacc"
  { yyerror_reserved("mapping"); }
#line 9876 "y.tab.c"
    break;

  case 627: /* bad_identifier: TOK_MIXED_ID  */
#line 4500 "language.yacc"
  { yyerror_reserved("mixed"); }
#line 9882 "y.tab.c"
    break;

  case 628: /* bad_identifier: TOK_MULTISET_ID  */
#line 4502 "language.yacc"
  { yyerror_reserved("multiset"); }
#line 9888 "y.tab.c"
    break;

  case 629: /* bad_identifier: TOK_OBJECT_ID  */
#line 4504 "language.yacc"
  { yyerror_reserved("object"); }
#line 9894 "y.tab.c"
    break;

  case 630: /* bad_identifier: TOK_PROGRAM_ID  */
#line 4506 "language.yacc"
  { yyerror_reserved("program"); }
#line 9900 "y.tab.c"
    break;

  case 631: /* bad_identifier: TOK_STRING_ID  */
#line 4508 "language.yacc"
  { yyerror_reserved("string"); }
#line 9906 "y.tab.c"
    break;

  case 632: /* bad_identifier: TOK_TYPEDEF  */
#line 4510 "language.yacc"
  { yyerror_reserved("typedef"); }
#line 9912 "y.tab.c"
    break;

  case 633: /* bad_identifier: TOK_VOID_ID  */
#line 4512 "language.yacc"
  { yyerror_reserved("void"); }
#line 9918 "y.tab.c"
    break;

  case 634: /* bad_identifier: TOK_RESERVED  */
#line 4514 "language.yacc"
  {
    ref_push_string((yyvsp[0].n)->u.sval.u.string);
    low_yyreport(REPORT_ERROR, NULL, 0, parser_system_string,
		 1, "Unknown reserved symbol %s.");
    free_node((yyvsp[0].n));
  }
#line 9929 "y.tab.c"
    break;

  case 635: /* bad_expr_ident: TOK_INLINE  */
#line 4524 "language.yacc"
  { yyerror_reserved("inline"); }
#line 9935 "y.tab.c"
    break;

  case 636: /* bad_expr_ident: TOK_LOCAL_ID  */
#line 4526 "language.yacc"
  { yyerror_reserved("local"); }
#line 9941 "y.tab.c"
    break;

  case 637: /* bad_expr_ident: TOK_NO_MASK  */
#line 4528 "language.yacc"
  { yyerror_reserved("nomask"); }
#line 9947 "y.tab.c"
    break;

  case 638: /* bad_expr_ident: TOK_PREDEF  */
#line 4530 "language.yacc"
  { yyerror_reserved("predef"); }
#line 9953 "y.tab.c"
    break;

  case 639: /* bad_expr_ident: TOK_PRIVATE  */
#line 4532 "language.yacc"
  { yyerror_reserved("private"); }
#line 9959 "y.tab.c"
    break;

  case 640: /* bad_expr_ident: TOK_PROTECTED  */
#line 4534 "language.yacc"
  { yyerror_reserved("protected"); }
#line 9965 "y.tab.c"
    break;

  case 641: /* bad_expr_ident: TOK_PUBLIC  */
#line 4536 "language.yacc"
  { yyerror_reserved("public"); }
#line 9971 "y.tab.c"
    break;

  case 642: /* bad_expr_ident: TOK_OPTIONAL  */
#line 4538 "language.yacc"
  { yyerror_reserved("optional"); }
#line 9977 "y.tab.c"
    break;

  case 643: /* bad_expr_ident: TOK_VARIANT  */
#line 4540 "language.yacc"
  { yyerror_reserved("variant"); }
#line 9983 "y.tab.c"
    break;

  case 644: /* bad_expr_ident: TOK_STATIC  */
#line 4542 "language.yacc"
  { yyerror_reserved("static"); }
#line 9989 "y.tab.c"
    break;

  case 645: /* bad_expr_ident: TOK_EXTERN  */
#line 4544 "language.yacc"
  { yyerror_reserved("extern"); }
#line 9995 "y.tab.c"
    break;

  case 646: /* bad_expr_ident: TOK_FINAL_ID  */
#line 4546 "language.yacc"
  { yyerror_reserved("final");}
#line 10001 "y.tab.c"
    break;

  case 647: /* bad_expr_ident: TOK_DO  */
#line 4548 "language.yacc"
  { yyerror_reserved("do"); }
#line 10007 "y.tab.c"
    break;

  case 648: /* bad_expr_ident: TOK_ELSE  */
#line 4550 "language.yacc"
  { yyerror("else without if."); }
#line 10013 "y.tab.c"
    break;

  case 649: /* bad_expr_ident: TOK_RETURN  */
#line 4552 "language.yacc"
  { yyerror_reserved("return"); }
#line 10019 "y.tab.c"
    break;

  case 650: /* bad_expr_ident: TOK_IMPORT  */
#line 4554 "language.yacc"
  { yyerror_reserved("import"); }
#line 10025 "y.tab.c"
    break;

  case 651: /* bad_expr_ident: TOK_INHERIT  */
#line 4556 "language.yacc"
  { yyerror_reserved("inherit"); }
#line 10031 "y.tab.c"
    break;

  case 652: /* bad_expr_ident: TOK_CATCH  */
#line 4558 "language.yacc"
  { yyerror_reserved("catch"); }
#line 10037 "y.tab.c"
    break;

  case 653: /* bad_expr_ident: TOK_GAUGE  */
#line 4560 "language.yacc"
  { yyerror_reserved("gauge"); }
#line 10043 "y.tab.c"
    break;

  case 654: /* bad_expr_ident: TOK_LAMBDA  */
#line 4562 "language.yacc"
  { yyerror_reserved("lambda"); }
#line 10049 "y.tab.c"
    break;

  case 655: /* bad_expr_ident: TOK_SSCANF  */
#line 4564 "language.yacc"
  { yyerror_reserved("sscanf"); }
#line 10055 "y.tab.c"
    break;

  case 656: /* bad_expr_ident: TOK_SWITCH  */
#line 4566 "language.yacc"
  { yyerror_reserved("switch"); }
#line 10061 "y.tab.c"
    break;

  case 657: /* bad_expr_ident: TOK_TYPEOF  */
#line 4568 "language.yacc"
  { yyerror_reserved("typeof"); }
#line 10067 "y.tab.c"
    break;

  case 658: /* bad_expr_ident: TOK_BREAK  */
#line 4570 "language.yacc"
  { yyerror_reserved("break"); }
#line 10073 "y.tab.c"
    break;

  case 659: /* bad_expr_ident: TOK_CASE  */
#line 4572 "language.yacc"
  { yyerror_reserved("case"); }
#line 10079 "y.tab.c"
    break;

  case 660: /* bad_expr_ident: TOK_CONTINUE  */
#line 4574 "language.yacc"
  { yyerror_reserved("continue"); }
#line 10085 "y.tab.c"
    break;

  case 661: /* bad_expr_ident: TOK_DEFAULT  */
#line 4576 "language.yacc"
  { yyerror_reserved("default"); }
#line 10091 "y.tab.c"
    break;

  case 662: /* bad_expr_ident: TOK_FOR  */
#line 4578 "language.yacc"
  { yyerror_reserved("for"); }
#line 10097 "y.tab.c"
    break;

  case 663: /* bad_expr_ident: TOK_FOREACH  */
#line 4580 "language.yacc"
  { yyerror_reserved("foreach"); }
#line 10103 "y.tab.c"
    break;

  case 664: /* bad_expr_ident: TOK_IF  */
#line 4582 "language.yacc"
  { yyerror_reserved("if"); }
#line 10109 "y.tab.c"
    break;


#line 10113 "y.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 4595 "language.yacc"


static void yyerror_reserved(const char *keyword)
{
  my_yyerror("%s is a reserved word.", keyword);
}

static struct pike_string *get_new_name(struct pike_string *prefix)
{
  char buf[40];
  /* Generate a name for a global symbol... */
  sprintf(buf,"__lambda_%ld_%ld_line_%d",
	  (long)Pike_compiler->new_program->id,
	  (long)(Pike_compiler->local_class_counter++ & 0xffffffff), /* OSF/1 cc bug. */
	  (int) THIS_COMPILATION->lex.current_line);
  if (prefix) {
    struct string_builder sb;
    init_string_builder_alloc(&sb, prefix->len + strlen(buf) + 1,
			      prefix->size_shift);
    string_builder_shared_strcat(&sb, prefix);
    string_builder_putchar(&sb, 0);
    string_builder_strcat(&sb, buf);
    return finish_string_builder(&sb);
  }
  return make_shared_string(buf);
}


static int low_islocal(struct compiler_frame *f,
		       struct pike_string *str)
{
  int e;
  for(e=f->current_number_of_locals-1;e>=0;e--)
    if(f->variable[e].name==str) {
      f->variable[e].flags |= LOCAL_VAR_IS_USED;
      return e;
    }
  return -1;
}


/* Add a local variable to the current function in frame.
 * NOTE: Steals the references to type and def, but not to str.
 */
int low_add_local_name(struct compiler_frame *frame,
		       struct pike_string *str,
		       struct pike_type *type,
		       node *def)
{

  if (str->len) {
    int tmp=low_islocal(frame,str);
    if(tmp>=0 && tmp >= frame->last_block_level)
    {
      my_yyerror("Duplicate local variable %S, "
		 "previous declaration on line %d\n",
		 str, frame->variable[tmp].line);
    }

    if(type == void_type_string)
    {
      my_yyerror("Local variable %S is void.\n", str);
    }
  }

  debug_malloc_touch(def);
  debug_malloc_touch(type);
  debug_malloc_touch(str);
  /* NOTE: The number of locals can be 0..255 (not 256), due to
   *       the use of READ_INCR_BYTE() in apply_low.h.
   */
  if (frame->current_number_of_locals == MAX_LOCAL-1)
  {
    my_yyerror("Too many local variables: no space for local variable %S.",
	       str);
    free_type(type);
    if (def) free_node(def);
    return -1;
  } else {
    int var = frame->current_number_of_locals;

#ifdef PIKE_DEBUG
    check_type_string(type);
#endif /* PIKE_DEBUG */
    if (pike_types_le(type, void_type_string)) {
      if (Pike_compiler->compiler_pass != 1) {
	yywarning("Declaring local variable %S with type void "
		  "(converted to type zero).", str);
      }
      free_type(type);
      copy_pike_type(type, zero_type_string);
    }
    frame->variable[var].type = type;
    frame->variable[var].name = str;
    reference_shared_string(str);
    frame->variable[var].def = def;

    frame->variable[var].line = THIS_COMPILATION->lex.current_line;
    copy_shared_string(frame->variable[var].file,
		       THIS_COMPILATION->lex.current_file);

    if (pike_types_le(void_type_string, type)) {
      /* Don't warn about unused voidable variables. */
      frame->variable[var].flags = LOCAL_VAR_IS_USED;
    } else {
      frame->variable[var].flags = 0;
    }

    frame->current_number_of_locals++;
    if(frame->current_number_of_locals > frame->max_number_of_locals)
    {
      frame->max_number_of_locals = frame->current_number_of_locals;
    }

    return var;
  }
}


/* argument must be a shared string */
/* Note that this function eats a reference to 'type' */
/* If def is nonzero, it also eats a ref to def */
int add_local_name(struct pike_string *str,
		   struct pike_type *type,
		   node *def)
{
  return low_add_local_name(Pike_compiler->compiler_frame,
			    str,
			    type,
			    def);
}

/* Mark local variables declared in a multi-assign or sscanf expression
 * as used. */
static void mark_lvalues_as_used(node *n)
{
  while (n && n->token == F_LVALUE_LIST) {
    if (!CAR(n)) {
      /* Can happen if a variable hasn't been declared. */
    } else if (CAR(n)->token == F_ARRAY_LVALUE) {
      mark_lvalues_as_used(CAAR(n));
    } else if ((CAR(n)->token == F_LOCAL) && !(CAR(n)->u.integer.b)) {
      Pike_compiler->compiler_frame->variable[CAR(n)->u.integer.a].flags |=
	LOCAL_VAR_IS_USED;
    }
    n = CDR(n);
  }
}

#if 0
/* Note that this function eats a reference to each of
 * 'type' and 'initializer', but not to 'name'.
 * Note also that 'initializer' may be NULL.
 */
static node *add_protected_variable(struct pike_string *name,
				    struct pike_type *type,
				    int depth,
				    node *initializer)
{
  struct compiler_frame *f = Pike_compiler->compiler_frame;
  int i;
  int id;
  node *n = NULL;

  if (initializer) {
    /* FIXME: We need to pop levels off local and external variables here. */
  }

  for(i = depth; f && i; i--) {
    f->lexical_scope |= SCOPE_SCOPED;
    f = f->previous;
  }
  if (!f) {
    int parent_depth = i;
    struct program_state *p = Pike_compiler;
    struct pike_string *tmp_name;
    while (i--) {
      if (!p->previous) {
	my_yyerror("Too many levels of protected (%d, max:%d).",
		   depth, depth - (i+1));
	parent_depth -= i+1;
	break;
      }
      p->new_program->flags |= PROGRAM_USES_PARENT;
      p = p->previous;
    }
    
    tmp_name = get_new_name(name);
    id = define_parent_variable(p, tmp_name, type,
				ID_PROTECTED|ID_PRIVATE|ID_INLINE);
    free_string(tmp_name);
    if (id >= 0) {
      if (def) {
	p->init_node =
	  mknode(F_COMMA_EXPR, Pike_compiler->init_node,
		 mkcastnode(void_type_string,
			    mknode(F_ASSIGN, initializer,
				   mkidentifiernode(id))));
	initializer = NULL;
      }
      n = mkexternalnode(id, parent_depth);
    }
  } else if (depth) {
    f->lexical_scope|=SCOPE_SCOPE_USED;
    tmp_name = get_new_name(name);
    id = low_add_local_name(f, tmp_name, type, NULL);
    free_string(tmp_name);
    if(f->min_number_of_locals < id+1)
      f->min_number_of_locals = id+1;
    if (initializer) {
      /* FIXME! */
      yyerror("Initializers not yet supported for protected variables with function scope.");
    }
    n = mklocalnode(id, depth);
  }
  id = add_local_name(name, type, n);
  if (id >= 0) {
    if (initializer) {
      return mknode(F_ASSIGN, initializer, mklocalnode(id,0));
    }
    return mklocalnode(id, 0);
  }
  if (initializer) {
    free_node(initializer);
  }
  return NULL;
}
#endif /* 0 */

int islocal(struct pike_string *str)
{
  return low_islocal(Pike_compiler->compiler_frame, str);
}

/* argument must be a shared string */
static node *lexical_islocal(struct pike_string *str)
{
  int e,depth=0;
  struct compiler_frame *f=Pike_compiler->compiler_frame;
  
  while(1)
  {
    for(e=f->current_number_of_locals-1;e>=0;e--)
    {
      if(f->variable[e].name==str)
      {
	struct compiler_frame *q=Pike_compiler->compiler_frame;

	f->variable[e].flags |= LOCAL_VAR_IS_USED;

	while(q!=f) 
	{
	  q->lexical_scope|=SCOPE_SCOPED;
	  q=q->previous;
	}

	if(depth) {
	  q->lexical_scope|=SCOPE_SCOPE_USED;

	  if(q->min_number_of_locals < e+1)
	    q->min_number_of_locals = e+1;
	}

	if(f->variable[e].def) {
	  /*fprintf(stderr, "Found prior definition of \"%s\"\n", str->str); */
	  return copy_node(f->variable[e].def);
	}

	return mklocalnode(e,depth);
      }
    }
    if(!(f->lexical_scope & SCOPE_LOCAL)) return 0;
    depth++;
    f=f->previous;
  }
}

static node *safe_inc_enum(node *n)
{
  JMP_BUF recovery;
  STACK_LEVEL_START(0);

  if (SETJMP(recovery)) {
    handle_compile_exception ("Bad implicit enum value (failed to add 1).");
    push_int(0);
  } else {
    if (n->token != F_CONSTANT) Pike_fatal("Bad node to safe_inc_enum().\n");
    push_svalue(&n->u.sval);
    push_int(1);
    f_add(2);
  }
  UNSETJMP(recovery);
  STACK_LEVEL_DONE(1);
  free_node(n);
  n = mkconstantsvaluenode(Pike_sp-1);
  pop_stack();
  return n;
}

static node *find_versioned_identifier(struct pike_string *identifier,
				       int major, int minor)
{
  struct compilation *c = THIS_COMPILATION;
  int old_major = Pike_compiler->compat_major;
  int old_minor = Pike_compiler->compat_minor;
  struct svalue *efun = NULL;
  node *res = NULL;

  change_compiler_compatibility(major, minor);

  if(Pike_compiler->last_identifier)
    free_string(Pike_compiler->last_identifier);
  copy_shared_string(Pike_compiler->last_identifier, identifier);

  /* Check predef:: first, and then the modules. */

  if (TYPEOF(c->default_module) == T_MAPPING) {
    if ((efun = low_mapping_string_lookup(c->default_module.u.mapping,
					  identifier)))
      res = mkconstantsvaluenode(efun);
  }
  else if (TYPEOF(c->default_module) != T_INT) {
    JMP_BUF tmp;
    if (SETJMP (tmp)) {
      handle_compile_exception ("Couldn't index %d.%d "
				"default module with \"%S\".",
				major, minor, identifier);
    } else {
      push_svalue(&c->default_module);
      ref_push_string(identifier);
      f_index (2);
      if (!IS_UNDEFINED(Pike_sp - 1))
	res = mkconstantsvaluenode(Pike_sp - 1);
      pop_stack();
    }
    UNSETJMP(tmp);
  }

  if (!res && !(res = resolve_identifier(identifier))) {
    if((Pike_compiler->flags & COMPILATION_FORCE_RESOLVE) ||
       (Pike_compiler->compiler_pass==2)) {
      my_yyerror("Undefined identifier %d.%d::%S.",
		 major, minor, identifier);
    }else{
      res = mknode(F_UNDEFINED, 0, 0);
    }
  }

  change_compiler_compatibility(old_major, old_minor);

  return res;
}

static int call_handle_import(struct pike_string *s)
{
  struct compilation *c = THIS_COMPILATION;
  int args;

  ref_push_string(s);
  ref_push_string(c->lex.current_file);
  if (c->handler && c->handler->prog) {
    ref_push_object(c->handler);
    args = 3;
  }
  else args = 2;

  if (safe_apply_handler("handle_import", c->handler, c->compat_handler,
			 args, BIT_MAPPING|BIT_OBJECT|BIT_PROGRAM|BIT_ZERO))
    if (TYPEOF(Pike_sp[-1]) != T_INT)
      return 1;
    else {
      pop_stack();
      my_yyerror("Couldn't find module to import: %S", s);
    }
  else
    handle_compile_exception ("Error finding module to import");

  return 0;
}

void cleanup_compiler(void)
{
}
