#! /usr/bin/perl -w

use strict;
use warnings;

use DBI;

require 'Functions/config.pl';
require 'Functions/db.pl';
require 'Functions/FilterList.pl';
require 'Functions/Delete.pl';

require 'Classes/Filter.pm';

package main;

if ( ! $ARGV[0] ) {die( "usage: perl crontab/cleanup_db.pl Filter.flt\n" );};

our %conf = ();	# configuration directives

LoadConfig();

  # Open the DB connection :
our $dbh = DB_Open();

while( my $FilterFile = shift )
{
	if ( -f $FilterFile )
	{
		my $Filter = Filter->new();
		$Filter->load( $FilterFile );
		my $Nb = $Filter->DeleteAlerts();

		print " $Nb alerts removed by the following rule/filter : $FilterFile\n";
	}
	else
	{
		print " Filter not found : $FilterFile\n";
	}
}
