/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2014, Arnaud Roques
 *
 * Project Info:  http://plantuml.sourceforge.net
 * 
 * This file is part of PlantUML.
 *
 * Licensed under The MIT License (Massachusetts Institute of Technology License)
 * 
 * See http://opensource.org/licenses/MIT
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.List;

import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.StringUtils;

public class CommandMouseOver extends CommandMultilines2<ClassDiagram> {

	public CommandMouseOver() {
		super(getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
	}

	@Override
	public String getPatternEnd() {
		return "(?i)^[%s]*\\}[%s]*$";
	}

	private static RegexConcat getRegexConcat() {
		return new RegexConcat(new RegexLeaf("^"), //
				new RegexLeaf("mouseover[%s]+"), //
				new RegexOr(//
						new RegexLeaf("NAME1", "(\\.?[\\p{L}0-9_]+(?:\\.[\\p{L}0-9_]+)*)"), //
						new RegexLeaf("NAME3", "[%g]([^%g]+)[%g]")), //
				new RegexLeaf("[%s]*\\{[%s]*$"));
	}

	public CommandExecutionResult executeNow(ClassDiagram system, List<String> lines) {
		StringUtils.trim(lines, false);
		final RegexResult line0 = getStartingPattern().matcher(lines.get(0).trim());
		Code code = Code.of(line0.get("NAME1", 0));
		if (code == null) {
			code = Code.of(line0.get("NAME3", 0));
		}
		if (system.leafExist(code) == false) {
			return CommandExecutionResult.error("No such entity");
		}
		final IEntity entity = system.getLeafsget(code);
		for (String s : lines.subList(1, lines.size() - 1)) {
			entity.mouseOver(s);
		}

		return CommandExecutionResult.ok();
	}

	// private Entity executeArg0(Map<String, RegexPartialMatch> arg) {
	//
	// final EntityType type = EntityType.getEntityType(arg.get("TYPE").get(0).goUpperCase());
	// final String code;
	// final String display;
	// if (arg.get("NAME1").get(1) != null) {
	// code = arg.get("NAME1").get(1);
	// display = arg.get("NAME1").get(0);
	// } else if (arg.get("NAME3").get(0) != null) {
	// code = arg.get("NAME3").get(0);
	// display = arg.get("NAME3").get(0);
	// } else {
	// code = arg.get("NAME2").get(0);
	// display = arg.get("NAME2").get(1);
	// }
	// final String stereotype = arg.get("STEREO").get(0);
	// final String generic = arg.get("GENERIC").get(0);
	//
	// if (system.entityExist(code)) {
	// final Entity result = (Entity) system.getOrCreateClass(code);
	// result.muteToType(type);
	// return result;
	// }
	// final Entity entity = system.createEntity(code, display, type);
	// if (stereotype != null) {
	// entity.setStereotype(new Stereotype(stereotype, system.getSkinParam().getCircledCharacterRadius(),
	// system.getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
	// }
	// if (generic != null) {
	// entity.setGeneric(generic);
	// }
	// return entity;
	// }

}
