/*
 * auth.h	Header file for the authentication stuff.
 *		We only use radius, but anyway this is
 *		a try to hide the authentication protocol
 *		from the rest of the system.
 *
 * Version:	@(#)auth.h  1.00  05-Jul-1996  miquels@cistron.nl
 *
 */

#ifndef __auth_h
#define __auth_h

/*
 *	Types of connection.
 */
#define P_UNKNOWN	0
#define P_LOCAL		'L'
#define P_RLOGIN	'R'
#define P_SLIP		'S'
#define P_CSLIP		'C'
#define P_PPP		'P'
#define P_PPP_ONLY	'O'
#define P_AUTOPPP	'A'
#define P_TELNET	'E'
#define P_TCPCLEAR      'T'
#define P_TCPLOGIN      'U'
#define P_CONSOLE	'!'
#define P_SHELL		'X'
#define P_SSH1		'H'
#define P_SSH2		'2'
#define P_SOCKET_SERVER 'W'
#define P_SOCKET_CLIENT 'I'
#define P_SOCKET_SSH	'Y'

/*
 *     Types of authentication
 */
#define AUTH_NONE		0
#define AUTH_RADIUS		1
#define AUTH_TACACS		2
#define AUTH_REMOTE		3
#define AUTH_LOCAL		4
#define AUTH_RADIUS_LOCAL	5
#define AUTH_TACACS_LOCAL	6
#define AUTH_LOCAL_RADIUS	7
#define AUTH_LOCAL_TACACS	8
#ifdef CYCLADES
#define AUTH_RADIUS_DOWN_LOCAL	9
#define AUTH_TACACS_DOWN_LOCAL	10
#endif

struct traffic_stat
{
	int sent_bytes;
	int recv_bytes;
	int sent_pkts;
	int recv_pkts;
};

/*
 *	Authentication info. This struct
 *	contains all info we get back from
 *	the authentication protocol.
 */
#define MAX_FRAMED_ROUTES 16
#define MAX_RADIUS_MESSAGES 16
#define MAX_FILTERS 16
struct auth {
	/* Input */
	char login[64];
	char passwd[64];
	time_t start;
	/* Output */
	char *message[MAX_RADIUS_MESSAGES];	 /* Up to 16 messages. Good? */
	unsigned int msn;		/* message num */
	char *filterid[MAX_FILTERS];	/* Up to 16 filters. Good? */
	unsigned int fln;		/* filterid num */
	char *framed_route[MAX_FRAMED_ROUTES];	/* Up to 16 routes. Good? */
	unsigned int frn;		/* framed_router num */
	char conn_info[128];
	char cli_src[32];  /* number of caller    */
	char cli_dst[32];  /* number being called */
	int  proto;
	int  nasport;			/* NAS-Port attribute value	    */
	int  loginport;			/* Login-TCP-Port attribute value   */
	unsigned int port_limit;	/* Limit of MPPP ports */
	char *acct_session_id; /* session ID for accounting */
	bool authenticated;
	bool do_acct;			/* bool for whether we do accounting */
	unsigned int host;	/* Address in network byte order of ssh/telnet target */
	unsigned int address;	/* Remote IP address */
#ifdef HAVE_IPV6
#endif
	unsigned int localip;
	unsigned int netmask;
	int mtu;
	int mru;
	int idletime;
	int sessiontime;  /* maxconnect for pppd, maximum length of this call in seconds */
	int porttype;
	struct traffic_stat traffic;
#ifdef PORTSLAVE_CALLBACK
	unsigned char cb_allowed; /* bool for whether callback is allowed */
	char *cb_number; /* number to call back */
#endif
#ifdef PORTSLAVE_CLIENT_IP_RULES
	char **valid_ip_rules;	/* Validate client-specified IP addr */
	int num_ip_rules;
#endif
	char *called_station;  /* number they apparently called to get us */
	char *calling_station; /* apparent phone number of the user */
#ifndef NO_CHAP
	int done_chap_once;    /* chap is done in two stages */
#endif
};

int login_local(struct auth *pai);
int do_local_or_server_authentication(struct auth *pai, bool ppp);

#ifndef NO_CHAP
#ifdef __CHAP_INCLUDE__
int do_chap_authentication(struct auth *pai, u_char *remmd, chap_state *cstate);
int rad_client_chap(struct auth *ai, u_char *remmd, chap_state *cstate);
#endif
#endif

int rad_client(struct auth *ai, bool ppp);
int rad_acct(const struct auth *ai, bool islogin);
#define RAD_INIT_PPPD -2
int rad_init(const char *config_file, int port, struct auth *ai, const char *tty);
struct realm_def *ckrealm(const struct auth *ai);

#endif	/* __auth_h */
